"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.borderRadius = exports.borderColor = exports.borderLeft = exports.borderBottom = exports.borderRight = exports.borderTop = exports.border = void 0;

var _style = _interopRequireDefault(require("./style"));

var _compose = _interopRequireDefault(require("./compose"));

function getBorder(value) {
  if (typeof value !== 'number') {
    return value;
  }

  return "".concat(value, "px solid");
}

var border = (0, _style.default)({
  prop: 'border',
  themeKey: 'borders',
  transform: getBorder
});
exports.border = border;
var borderTop = (0, _style.default)({
  prop: 'borderTop',
  themeKey: 'borders',
  transform: getBorder
});
exports.borderTop = borderTop;
var borderRight = (0, _style.default)({
  prop: 'borderRight',
  themeKey: 'borders',
  transform: getBorder
});
exports.borderRight = borderRight;
var borderBottom = (0, _style.default)({
  prop: 'borderBottom',
  themeKey: 'borders',
  transform: getBorder
});
exports.borderBottom = borderBottom;
var borderLeft = (0, _style.default)({
  prop: 'borderLeft',
  themeKey: 'borders',
  transform: getBorder
});
exports.borderLeft = borderLeft;
var borderColor = (0, _style.default)({
  prop: 'borderColor',
  themeKey: 'palette'
});
exports.borderColor = borderColor;
var borderRadius = (0, _style.default)({
  prop: 'borderRadius',
  themeKey: 'shape'
});
exports.borderRadius = borderRadius;
var borders = (0, _compose.default)(border, borderTop, borderRight, borderBottom, borderLeft, borderColor, borderRadius);
var _default = borders;
exports.default = _default;