import _typeof from "@babel/runtime/helpers/typeof";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import merge from 'lodash/merge';
import mapKeys from 'lodash/mapKeys';
export var CSV_TYPE = 'text/csv;charset=utf-8;';
export var JSON_TYPE = 'data:text/json;charset=utf-8,';
var monthMap = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'June', 'July', 'Aug', 'Sept', 'Oct', 'Nov', 'Dec'];
export function mergeArraysByKey(arrays) {
  var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'id';
  var mergedObject = merge.apply(void 0, _toConsumableArray(arrays.map(function (row) {
    return mapKeys(row, function (a) {
      return a && a[key];
    });
  })));
  return Object.values(mergedObject);
}
export function downloadFile(data) {
  var filename = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "".concat(new Date().toISOString());
  var format = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : CSV_TYPE;
  var type = format === 'json' ? JSON_TYPE : CSV_TYPE;
  var blob = new Blob([data], {
    type: type
  });
  var link = document.createElement('a');
  link.setAttribute('href', URL.createObjectURL(blob));
  link.setAttribute('download', "".concat(filename, ".").concat(format));
  link.style.visibility = 'hidden';
  document.body.appendChild(link);
  link.click();
  document.body.removeChild(link);
}
export function processDate(dateString) {
  var date = new Date(dateString);
  var month = monthMap[date.getMonth()];
  var day = date.getDate() < 10 ? "0".concat(date.getDate()) : date.getDate();

  if (!month || isNaN(day)) {
    return 'N/A';
  }

  return "".concat(day, " ").concat(month, " ").concat(date.getFullYear());
}
export function getBaseName(pathname) {
  var level = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 2;
  var release = '/';
  var pathName = pathname.replace(/(#|\?).*/, '').split('/');
  pathName.shift();

  if (pathName[0] === 'beta') {
    pathName.shift();
    release = "/beta/";
  }

  return _toConsumableArray(new Array(level)).reduce(function (acc, _curr, key) {
    return "".concat(acc).concat(pathName[key] || '').concat(key < level - 1 ? '/' : '');
  }, release);
}
export var generateFilter = function generateFilter(data) {
  var path = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'filter';
  var options = arguments.length > 2 ? arguments[2] : undefined;
  return Object.entries(data || {}).reduce(function (acc, _ref) {
    var _ref2 = _slicedToArray(_ref, 2),
        key = _ref2[0],
        value = _ref2[1];

    var newPath = "".concat(path || '', "[").concat(key, "]").concat(Array.isArray(value) ? "".concat(options !== null && options !== void 0 && options.arrayEnhancer ? "[".concat(options.arrayEnhancer, "]") : '', "[]") : '');

    if (value instanceof Function || value instanceof Date) {
      return acc;
    }

    return _objectSpread(_objectSpread({}, acc), Array.isArray(value) || _typeof(value) !== 'object' ? _defineProperty({}, newPath, value) : generateFilter(value, newPath, options));
  }, {});
};
export var toUpperCase = function toUpperCase() {
  var text = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  return "".concat(text.charAt(0).toUpperCase()).concat(text.slice(1));
};