"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _dot = _interopRequireDefault(require("dot"));

var _marked = _interopRequireDefault(require("marked"));

var _sanitizeHtml = _interopRequireDefault(require("sanitize-html"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

_marked["default"].Renderer.prototype.link = function (href, title, text) {
  return "<a href=\"".concat(href, "\" rel=\"noopener noreferrer\" target=\"_blank\" class=\"ins-c-rule__link-in-description\">").concat(text, "</a>");
};

_marked["default"].setOptions({
  renderer: new _marked["default"].Renderer()
});

var Markdown = function Markdown(_ref) {
  var template = _ref.template,
      definitions = _ref.definitions;

  var DOT_SETTINGS = _objectSpread(_objectSpread({}, _dot["default"].templateSettings), {}, {
    varname: ['pydata'],
    strip: false
  });

  var sanitizeOptions = {
    allowedAttributes: _objectSpread(_objectSpread({}, _sanitizeHtml["default"].defaults.allowedAttributes), {}, {
      '*': ['style']
    }),
    transformTags: {
      ul: function ul(tagName, attribs) {
        return {
          tagName: 'ul',
          attribs: {
            "class": 'pf-c-list'
          }
        };
      }
    },
    textFilter: function textFilter(text) {
      return text.replace(/&amp;/g, '&').replace(/&gt;/g, '>').replace(/&lt;/g, '<');
    }
  };
  var externalLinkIcon = '<i class="fas fa-external-link-alt"></i>';

  try {
    var compiledDot = definitions ? _dot["default"].template(template, DOT_SETTINGS)(definitions) : template;
    var compiledMd = (0, _marked["default"])((0, _sanitizeHtml["default"])(compiledDot, sanitizeOptions));
    return /*#__PURE__*/_react["default"].createElement("div", {
      className: "ins-c-rule__markdown",
      dangerouslySetInnerHTML: {
        __html: compiledMd.replace(/<ul>/gim, "<ul class=\"pf-c-list\" style=\"font-size: inherit\">").replace(/<a>/gim, "<a rel=\"noopener noreferrer\" target=\"_blank\">").replace(/<\/a>/gim, " ".concat(externalLinkIcon, "</a>"))
      }
    });
  } catch (error) {
    console.warn(error, definitions, template); // eslint-disable-line no-console

    return /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, null, " Ouch. We were unable to correctly render this text, instead please enjoy the raw data.", /*#__PURE__*/_react["default"].createElement("pre", null, /*#__PURE__*/_react["default"].createElement("code", null, template)));
  }
};

Markdown.propTypes = {
  template: _propTypes["default"].string.isRequired,
  definitions: _propTypes["default"].object
};
var _default = Markdown;
exports["default"] = _default;