"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommonStyles = void 0;
const tslib_1 = require("tslib");
/* eslint-disable camelcase */
const chart_global_FontFamily_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_global_FontFamily'));
const chart_global_FontSize_sm_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_global_FontSize_sm'));
const chart_global_label_Margin_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_global_label_Margin'));
const chart_global_letter_spacing_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_global_letter_spacing'));
const chart_legend_Margin_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_legend_Margin'));
const chart_legend_position_1 = tslib_1.__importDefault(require('@patternfly/react-tokens/dist/js/chart_legend_position'));
// Typography
const TYPOGRAPHY_FONT_FAMILY = chart_global_FontFamily_1.default.var;
const TYPOGRAPHY_LETTER_SPACING = chart_global_letter_spacing_1.default.var;
const TYPOGRAPHY_FONT_SIZE = chart_global_FontSize_sm_1.default.value;
exports.CommonStyles = {
    label: {
        fontFamily: TYPOGRAPHY_FONT_FAMILY,
        fontSize: TYPOGRAPHY_FONT_SIZE,
        letterSpacing: TYPOGRAPHY_LETTER_SPACING,
        margin: chart_global_label_Margin_1.default.value
    },
    legend: {
        margin: chart_legend_Margin_1.default.value,
        position: chart_legend_position_1.default.value
    }
};
//# sourceMappingURL=common-styles.js.map