"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartPie = exports.ChartPieSortOrder = exports.ChartPieLegendPosition = exports.ChartPieLabelPosition = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_core_1 = require("victory-core");
const victory_pie_1 = require("victory-pie");
const ChartContainer_1 = require("../ChartContainer");
const ChartLegend_1 = require("../ChartLegend");
const ChartTheme_1 = require("../ChartTheme");
const ChartTooltip_1 = require("../ChartTooltip");
const ChartUtils_1 = require("../ChartUtils");
var ChartPieLabelPosition;
(function (ChartPieLabelPosition) {
    ChartPieLabelPosition["centroid"] = "centroid";
    ChartPieLabelPosition["endAngle"] = "endAngle";
    ChartPieLabelPosition["startAngle"] = "startAngle";
})(ChartPieLabelPosition = exports.ChartPieLabelPosition || (exports.ChartPieLabelPosition = {}));
var ChartPieLegendPosition;
(function (ChartPieLegendPosition) {
    ChartPieLegendPosition["bottom"] = "bottom";
    ChartPieLegendPosition["right"] = "right";
})(ChartPieLegendPosition = exports.ChartPieLegendPosition || (exports.ChartPieLegendPosition = {}));
var ChartPieSortOrder;
(function (ChartPieSortOrder) {
    ChartPieSortOrder["ascending"] = "ascending";
    ChartPieSortOrder["descending"] = "descending";
})(ChartPieSortOrder = exports.ChartPieSortOrder || (exports.ChartPieSortOrder = {}));
const ChartPie = (_a) => {
    var { allowTooltip = true, ariaDesc, ariaTitle, constrainToVisibleArea = false, containerComponent = React.createElement(ChartContainer_1.ChartContainer, null), labels, legendAllowWrap = false, legendComponent = React.createElement(ChartLegend_1.ChartLegend, null), legendData, legendPosition = ChartTheme_1.ChartCommonStyles.legend.position, padding, radius, standalone = true, themeColor, themeVariant, 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant), labelComponent = allowTooltip ? (React.createElement(ChartTooltip_1.ChartTooltip, { constrainToVisibleArea: constrainToVisibleArea, theme: theme })) : (undefined), legendOrientation = theme.legend.orientation, height = theme.pie.height, width = theme.pie.width } = _a, rest = tslib_1.__rest(_a, ["allowTooltip", "ariaDesc", "ariaTitle", "constrainToVisibleArea", "containerComponent", "labels", "legendAllowWrap", "legendComponent", "legendData", "legendPosition", "padding", "radius", "standalone", "themeColor", "themeVariant", "theme", "labelComponent", "legendOrientation", "height", "width"]);
    const defaultPadding = {
        bottom: ChartUtils_1.getPaddingForSide('bottom', padding, theme.pie.padding),
        left: ChartUtils_1.getPaddingForSide('left', padding, theme.pie.padding),
        right: ChartUtils_1.getPaddingForSide('right', padding, theme.pie.padding),
        top: ChartUtils_1.getPaddingForSide('top', padding, theme.pie.padding)
    };
    // Ensure non-negative value is returned
    const getDefaultRadius = () => {
        const result = victory_core_1.Helpers.getRadius({
            height,
            width,
            padding: defaultPadding
        });
        return result > -1 ? result : undefined;
    };
    const chartRadius = radius ? radius : getDefaultRadius();
    const chart = (React.createElement(victory_pie_1.VictoryPie, Object.assign({ height: height, key: "pf-chart-pie", labels: labels, labelComponent: labelComponent, padding: padding, radius: chartRadius, standalone: false, theme: theme, width: width }, rest)));
    const legend = React.cloneElement(legendComponent, Object.assign({ data: legendData, key: 'pf-chart-pie-legend', orientation: legendOrientation, theme }, legendComponent.props));
    // Returns a computed legend
    const getLegend = () => {
        if (!legend.props.data) {
            return null;
        }
        return ChartUtils_1.getComputedLegend({
            allowWrap: legendAllowWrap,
            chartType: 'pie',
            height,
            legendComponent: legend,
            padding: defaultPadding,
            position: legendPosition,
            theme,
            width
        });
    };
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ desc: ariaDesc, height, title: ariaTitle, width,
        theme }, containerComponent.props), [chart, getLegend()]);
    return standalone ? (React.createElement(React.Fragment, null, container)) : (React.createElement(React.Fragment, null,
        chart,
        getLegend()));
};
exports.ChartPie = ChartPie;
exports.ChartPie.displayName = 'ChartPie';
// Note: VictoryPie.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartPie, victory_pie_1.VictoryPie);
//# sourceMappingURL=ChartPie.js.map