"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartBulletQualitativeRange = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_bar_1 = require("victory-bar");
const utils_1 = require("./utils");
const ChartBar_1 = require("../ChartBar");
const ChartContainer_1 = require("../ChartContainer");
const ChartTheme_1 = require("../ChartTheme");
const ChartTooltip_1 = require("../ChartTooltip");
const ChartUtils_1 = require("../ChartUtils");
const ChartBulletQualitativeRange = ({ allowTooltip = true, ariaDesc, ariaTitle, barWidth = ChartTheme_1.ChartBulletStyles.qualitativeRangeWidth, constrainToVisibleArea = false, data, domain, horizontal = true, invert = false, labels, measureComponent = React.createElement(ChartBar_1.ChartBar, null), padding, standalone = true, themeColor, themeVariant, y, y0, 
// destructure last
theme = ChartUtils_1.getBulletQualitativeRangeTheme(themeColor, themeVariant), height = theme.group.height, width = theme.group.width, labelComponent = React.createElement(ChartTooltip_1.ChartTooltip, null) }) => {
    const computedData = utils_1.getQualitativeRangeData({
        data,
        invert,
        theme,
        y,
        y0
    });
    // Label component
    //
    // The x and y calculations below ensure that the tooltip appears above the bar, instead of vertically centered.
    // Having the tooltip vertically centered is visually confusing with comparative measures.
    //
    // Note: SVG height and width are provided by ChartBullet as a workaround to support constrainToVisibleArea
    const tooltip = React.cloneElement(labelComponent, Object.assign({ constrainToVisibleArea, dx: () => {
            if (horizontal) {
                return 0;
            }
            const result = typeof barWidth === 'function' ? barWidth(data) : barWidth;
            return result / 2;
        }, dy: () => {
            if (!horizontal) {
                return 0;
            }
            const result = typeof barWidth === 'function' ? barWidth(data) : barWidth;
            return -(result / 2);
        }, orientation: 'top' }, labelComponent.props));
    const measure = computedData.map((dataPoint, index) => React.cloneElement(measureComponent, Object.assign({ barWidth, data: [Object.assign({}, dataPoint)], domain,
        height,
        horizontal, key: `pf-chart-bullet-qualitative-range-${index}`, labelComponent: allowTooltip ? tooltip : undefined, labels,
        padding, standalone: false, style: {
            data: {
                fill: dataPoint._color
            }
        }, theme,
        width }, measureComponent.props)));
    return standalone ? (React.createElement(ChartContainer_1.ChartContainer, { desc: ariaDesc, height: height, title: ariaTitle, width: width }, measure)) : (React.createElement(React.Fragment, null, measure));
};
exports.ChartBulletQualitativeRange = ChartBulletQualitativeRange;
exports.ChartBulletQualitativeRange.displayName = 'ChartBulletQualitativeRange';
// Note: VictoryBar.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartBulletQualitativeRange, victory_bar_1.VictoryBar);
//# sourceMappingURL=ChartBulletQualitativeRange.js.map