import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryBar } from 'victory-bar';
import { ChartContainer } from '../ChartContainer';
import { getBulletComparativeWarningMeasureTheme } from '../ChartUtils';
import { ChartBulletComparativeMeasure } from './ChartBulletComparativeMeasure';
export const ChartBulletComparativeWarningMeasure = ({ allowTooltip = true, ariaDesc, ariaTitle, barWidth, constrainToVisibleArea = false, data, domain, horizontal = true, labelComponent, labels, measureComponent = React.createElement(ChartBulletComparativeMeasure, null), padding, standalone = true, themeColor, themeVariant, y, 
// destructure last
theme = getBulletComparativeWarningMeasureTheme(themeColor, themeVariant), height = theme.bar.height, width = theme.bar.width }) => {
    // Comparative measure component
    const measure = React.cloneElement(measureComponent, Object.assign({ allowTooltip,
        ariaDesc,
        ariaTitle,
        barWidth,
        constrainToVisibleArea,
        data,
        domain,
        height,
        horizontal,
        labelComponent,
        labels,
        padding, standalone: false, theme,
        width,
        y }, measureComponent.props));
    return standalone ? (React.createElement(ChartContainer, { desc: ariaDesc, height: height, title: ariaTitle, width: width }, measure)) : (React.createElement(React.Fragment, null, measure));
};
ChartBulletComparativeWarningMeasure.displayName = 'ChartBulletComparativeWarningMeasure';
// Note: VictoryBar.role must be hoisted
hoistNonReactStatics(ChartBulletComparativeWarningMeasure, VictoryBar);
//# sourceMappingURL=ChartBulletComparativeWarningMeasure.js.map