"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmAutoRefreshSelect = exports.savePollInterval = void 0;
var react_1 = __importStar(require("react"));
var react_icons_1 = require("@patternfly/react-icons");
var react_core_1 = require("@patternfly/react-core");
var styles_1 = require("@material-ui/styles");
var DEFAULTS = {
    initPollInterval: 60,
    refreshIntervals: [30, 60, 5 * 60, 30 * 60, 0],
    refreshIntervalCookie: 'acm-page-refresh-interval',
};
var useStyles = styles_1.makeStyles({
    container: {
        display: 'flex',
        alignItems: 'center',
        maxWidth: '225px',
    },
    reloadButton: {
        cursor: 'pointer',
        marginRight: '0.6rem',
    },
    buttonTitle: {
        maxWidth: '200px',
        '& button': {
            paddingLeft: '0',
            paddingRight: '0',
            '& span': {
                fontSize: 'var(--pf-global--FontSize--sm)',
                color: 'var(--pf-global--primary-color--100)',
            },
            '& span:last-of-type': {
                marginRight: '0',
            },
            '&:hover, &:focus': {
                '& span': {
                    color: 'var(--pf-global--primary-color--200)',
                },
            },
        },
    },
    icon: {
        maxWidth: '25px',
        color: 'var(--pf-global--primary-color--100)',
    },
});
var savePollInterval = function (refreshIntervalCookie, pollInterval) {
    localStorage.setItem(refreshIntervalCookie, "" + pollInterval);
};
exports.savePollInterval = savePollInterval;
var initializeLocalStorage = function (props) {
    var _a, _b;
    var initialValue = props.pollInterval;
    var key = (_a = props.refreshIntervalCookie) !== null && _a !== void 0 ? _a : DEFAULTS.refreshIntervalCookie;
    var defaultValue = ((_b = props.initPollInterval) !== null && _b !== void 0 ? _b : DEFAULTS.initPollInterval) * 1000;
    return react_1.useState(function () {
        var _a;
        if (initialValue != null /* initialValue can be 0 for refresh disabled */) {
            exports.savePollInterval(key, initialValue);
            return initialValue;
        }
        else if (window && window.localStorage && window.localStorage.getItem(key)) {
            /* istanbul ignore next */
            var value = (_a = window.localStorage.getItem(key)) !== null && _a !== void 0 ? _a : "" + defaultValue;
            return parseInt(value, 10);
        }
        exports.savePollInterval(key, defaultValue);
        return defaultValue;
    });
};
function AcmAutoRefreshSelect(props) {
    var _a;
    var _b = react_1.useState(false), isOpen = _b[0], setOpen = _b[1];
    var _c = initializeLocalStorage(props), selected = _c[0], setStoredValue = _c[1];
    var _d = react_1.useState(false), initialFetchCalled = _d[0], setInitialFetchCalled = _d[1];
    var _e = react_1.useState(window.document.hidden), docHidden = _e[0], setDocHidden = _e[1];
    var onVisibilityChange = function () {
        setDocHidden(window.document.hidden);
    };
    var setValue = function (value) {
        var _a;
        setStoredValue(value);
        exports.savePollInterval((_a = props.refreshIntervalCookie) !== null && _a !== void 0 ? _a : DEFAULTS.refreshIntervalCookie, value);
    };
    var classes = useStyles();
    var refetch = props.refetch;
    react_1.useEffect(function () {
        refetch();
        setInitialFetchCalled(true);
        document.addEventListener('visibilitychange', onVisibilityChange);
        return function () { return document.removeEventListener('visibilitychange', onVisibilityChange); };
    }, []);
    react_1.useEffect(function () {
        if (!docHidden && selected !== 0) {
            if (initialFetchCalled) {
                // avoid double fetch on the first render
                refetch();
            }
            var interval_1 = setInterval(function () { return refetch(); }, selected);
            return function () { return clearInterval(interval_1); };
        }
        return;
    }, [selected, docHidden] // intentionally exclude initialFetchCalled to avoid double refetch
    );
    var handleKeyPress = function (e) {
        /* istanbul ignore else */
        if (e.key === 'Enter') {
            refetch();
        }
    };
    var autoRefreshChoices = ((_a = props.refreshIntervals) !== null && _a !== void 0 ? _a : DEFAULTS.refreshIntervals).map(function (pi) {
        var id;
        if (pi >= 60) {
            id = "refresh-" + pi / 60 + "m";
        }
        else if (pi !== 0) {
            id = "refresh-" + pi + "s";
        }
        else {
            id = 'refresh-disable';
        }
        pi *= 1000;
        return { id: id, pi: pi };
    });
    var conversion = function (pi) {
        if (pi >= 60000) {
            return "Refresh every " + pi / 60000 + "m";
        }
        else if (pi !== 0) {
            return "Refresh every " + pi / 1000 + "s";
        }
        else {
            return 'Disable refresh';
        }
    };
    return (react_1.default.createElement("div", { className: classes.container },
        react_1.default.createElement("div", { className: classes.reloadButton, tabIndex: 0, id: 'refresh-icon', "aria-label": 'refresh-icon', role: 'button', onClick: function () { return refetch(); }, onKeyPress: handleKeyPress },
            react_1.default.createElement(react_icons_1.SyncAltIcon, { className: classes.icon })),
        react_1.default.createElement(react_core_1.Dropdown, { className: classes.buttonTitle, "aria-label": 'refetch-intervals', id: "refresh-dropdown", onSelect: function () { return setOpen(!isOpen); }, isOpen: isOpen, isPlain: true, toggle: react_1.default.createElement(react_core_1.DropdownToggle, { id: "refresh-toggle", "aria-label": "refresh-label", isDisabled: false, onToggle: function () { return setOpen(!isOpen); } }, conversion(selected)), dropdownItems: autoRefreshChoices.map(function (item) { return (react_1.default.createElement(react_core_1.DropdownItem, __assign({ key: item.id }, item, { onClick: function () { return setValue(item.pi); } }), conversion(item.pi))); }) })));
}
exports.AcmAutoRefreshSelect = AcmAutoRefreshSelect;
//# sourceMappingURL=AcmAutoRefreshSelect.js.map