import React from 'react';
import { EmptyState } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyState.js";
import { EmptyStateIcon } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateIcon.js";
import { EmptyStateVariant } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyState.js";
import { EmptyStateBody } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateBody.js";
import { Title } from "@patternfly/react-core/dist/esm/components/Title/Title.js";
import ExclamationCircleIcon from "@patternfly/react-icons/dist/esm/icons/exclamation-circle-icon";
import "../../Unavailable/./Unavailable.css";

var Unavailable = function Unavailable() {
  return /*#__PURE__*/React.createElement(EmptyState, {
    variant: EmptyStateVariant.large,
    className: "ins-c-empty-state__unavailable pf-m-redhat-font"
  }, /*#__PURE__*/React.createElement(EmptyStateIcon, {
    icon: ExclamationCircleIcon
  }), /*#__PURE__*/React.createElement(Title, {
    headingLevel: "h5",
    size: "lg"
  }, "This page is temporarily unavailable"), /*#__PURE__*/React.createElement(EmptyStateBody, null, "Try refreshing the page. If the problem persists, contact your organization administrator or visit our", /*#__PURE__*/React.createElement("a", {
    href: "https://status.redhat.com/",
    target: "_blank",
    rel: "noopener noreferrer"
  }, " status page"), " for known outages."));
};

export default Unavailable;