import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React from 'react';
import { RowSelectVariant, Table, TableHeader, TableBody } from '@patternfly/react-table';
import { Skeleton, SkeletonSize } from '../Skeleton';
import PropTypes from 'prop-types';

var SkeletonTable = /*#__PURE__*/function (_React$Component) {
  _inherits(SkeletonTable, _React$Component);

  var _super = _createSuper(SkeletonTable);

  function SkeletonTable() {
    var _this;

    _classCallCheck(this, SkeletonTable);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "createColumns", function () {
      var colSize = _this.props.colSize;
      return _toConsumableArray(Array(colSize)).map(function () {
        return {
          title: /*#__PURE__*/React.createElement(Skeleton, {
            size: SkeletonSize.sm
          })
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "getColumns", function () {
      var _this$props = _this.props,
          paddingColumnSize = _this$props.paddingColumnSize,
          columns = _this$props.columns;
      return _this.newArray(paddingColumnSize).map(function () {
        return '';
      }).concat(columns || _this.createColumns());
    });

    _defineProperty(_assertThisInitialized(_this), "createRows", function () {
      var _this$props2 = _this.props,
          colSize = _this$props2.colSize,
          rowSize = _this$props2.rowSize,
          columns = _this$props2.columns,
          paddingColumnSize = _this$props2.paddingColumnSize;
      var numberOfCols = columns ? columns.length : colSize;
      return _this.newArray(rowSize).map(function () {
        return {
          disableSelection: true,
          cells: _this.newArray(paddingColumnSize).map(function () {
            return '';
          }).concat(_this.newArray(numberOfCols).map(function () {
            return {
              title: /*#__PURE__*/React.createElement(Skeleton, {
                size: SkeletonSize.md
              })
            };
          }))
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "selectVariant", function () {
      var hasRadio = _this.props.hasRadio;
      return hasRadio ? (RowSelectVariant === null || RowSelectVariant === void 0 ? void 0 : RowSelectVariant.radio) || 'radio' : (RowSelectVariant === null || RowSelectVariant === void 0 ? void 0 : RowSelectVariant.checkbox) || 'checkbox';
    });

    _defineProperty(_assertThisInitialized(_this), "newArray", function (size) {
      return _toConsumableArray(Array(size));
    });

    return _this;
  }

  _createClass(SkeletonTable, [{
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          canSelectAll = _this$props3.canSelectAll,
          isSelectable = _this$props3.isSelectable,
          sortBy = _this$props3.sortBy,
          variant = _this$props3.variant;
      return /*#__PURE__*/React.createElement(Table, {
        cells: this.getColumns(),
        rows: this.createRows(),
        sortBy: sortBy,
        "aria-label": "Loading",
        onSelect: isSelectable,
        selectVariant: isSelectable ? this.selectVariant() : null,
        canSelectAll: canSelectAll,
        variant: variant
      }, /*#__PURE__*/React.createElement(TableHeader, null), /*#__PURE__*/React.createElement(TableBody, null));
    }
  }]);

  return SkeletonTable;
}(React.Component);

SkeletonTable.propTypes = {
  colSize: PropTypes.number,
  rowSize: PropTypes.number,
  columns: PropTypes.array,
  paddingColumnSize: PropTypes.number,
  sortBy: PropTypes.shape({
    index: PropTypes.number,
    direction: PropTypes.oneOf(['asc', 'desc'])
  }),
  isSelectable: PropTypes.bool,
  canSelectAll: PropTypes.bool,
  hasRadio: PropTypes.bool,
  variant: PropTypes.string
};
SkeletonTable.defaultProps = {
  rowSize: 0,
  paddingColumnSize: 0,
  canSelectAll: false,
  isSelectable: false,
  hasRadio: false,
  variant: null
};
export default SkeletonTable;