import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import React from 'react';
import propTypes from 'prop-types';
import classNames from 'classnames';
import RebootingIcon from "@patternfly/react-icons/dist/esm/icons/rebooting-icon";
import "../../Reboot/./reboot.css";

var Reboot = function Reboot(_ref) {
  var red = _ref.red,
      className = _ref.className,
      props = _objectWithoutProperties(_ref, ["red", "className"]);

  var rebootIconClasses = classNames('ins-c-reboot', _defineProperty({}, "ins-m-red", red), className);
  return /*#__PURE__*/React.createElement("span", _extends({
    className: rebootIconClasses
  }, props), /*#__PURE__*/React.createElement(RebootingIcon, null), /*#__PURE__*/React.createElement("span", null, "Reboot required"));
};

export default Reboot;
Reboot.propTypes = {
  className: propTypes.string,
  red: propTypes.bool
};