import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component } from 'react';
import PropTypes from 'prop-types';
import PaginationNav from './PaginationNav';
import PaginationMenu from './PaginationMenu';

var PaginationNext = /*#__PURE__*/function (_Component) {
  _inherits(PaginationNext, _Component);

  var _super = _createSuper(PaginationNext);

  function PaginationNext() {
    _classCallCheck(this, PaginationNext);

    return _super.apply(this, arguments);
  }

  _createClass(PaginationNext, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          className = _this$props.className,
          page = _this$props.page,
          lastPage = _this$props.lastPage,
          setPage = _this$props.setPage,
          itemsStart = _this$props.itemsStart,
          itemsEnd = _this$props.itemsEnd,
          widtgetId = _this$props.widtgetId,
          onSetPerPage = _this$props.onSetPerPage,
          itemCount = _this$props.itemCount,
          perPageOptions = _this$props.perPageOptions,
          dropDirection = _this$props.dropDirection,
          amountOfPages = _this$props.amountOfPages,
          onFirstPage = _this$props.onFirstPage,
          onLastPage = _this$props.onLastPage,
          onPreviousPage = _this$props.onPreviousPage,
          onNextPage = _this$props.onNextPage,
          perPage = _this$props.perPage,
          props = _objectWithoutProperties(_this$props, ["className", "page", "lastPage", "setPage", "itemsStart", "itemsEnd", "widtgetId", "onSetPerPage", "itemCount", "perPageOptions", "dropDirection", "amountOfPages", "onFirstPage", "onLastPage", "onPreviousPage", "onNextPage", "perPage"]);

      return /*#__PURE__*/React.createElement("div", _extends({
        className: "pf-c-pagination pf-m-footer ".concat(className),
        "aria-label": "Element pagination"
      }, props), /*#__PURE__*/React.createElement(PaginationMenu, {
        itemsStart: itemsStart,
        itemsEnd: itemsEnd,
        widtgetId: widtgetId,
        dropDirection: dropDirection,
        onSetPerPage: onSetPerPage,
        itemCount: itemCount,
        perPage: perPage,
        perPageOptions: perPageOptions
      }), /*#__PURE__*/React.createElement(PaginationNav, {
        lastPage: lastPage,
        page: page,
        setPage: setPage,
        onFirstPage: onFirstPage,
        onLastPage: onLastPage,
        onPreviousPage: onPreviousPage,
        onNextPage: onNextPage
      }));
    }
  }]);

  return PaginationNext;
}(Component);

PaginationNext.propTypes = {
  amountOfPages: PropTypes.number,
  itemCount: PropTypes.number.isRequired,
  page: PropTypes.number,
  itemsStart: PropTypes.number,
  itemsEnd: PropTypes.number,
  widtgetId: PropTypes.string,
  dropDirection: PropTypes.string,
  onSetPerPage: PropTypes.func,
  perPage: PropTypes.number,
  perPageOptions: PropTypes.arrayOf(PropTypes.shape({
    title: PropTypes.node,
    value: PropTypes.number
  })),
  lastPage: PropTypes.number,
  setPage: PropTypes.func,
  onFirstPage: PropTypes.func,
  onLastPage: PropTypes.func,
  onPreviousPage: PropTypes.func,
  onNextPage: PropTypes.func,
  className: PropTypes.string
};
export default PaginationNext;