import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import React from 'react';
import propTypes from 'prop-types';
import classNames from 'classnames';
import ThemeContext from '../Dark/configContext';
import "../../PageHeader/./page-header.css";
/**
 * This is a page header that mimics the patternfly layout for a header section
 */

var PageHeader = function PageHeader(_ref) {
  var className = _ref.className,
      children = _ref.children,
      props = _objectWithoutProperties(_ref, ["className", "children"]);

  var pageHeaderClasses = classNames(className, 'pf-l-page-header', 'pf-c-page-header', 'pf-l-page__main-section', 'pf-c-page__main-section');
  return /*#__PURE__*/React.createElement(ThemeContext.Consumer, null, function () {
    var theme = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'light';
    var themeClasses = classNames(_defineProperty({}, "pf-m-".concat(theme, "-200"), theme === 'dark'), _defineProperty({}, "pf-m-light", theme === 'light'));
    return /*#__PURE__*/React.createElement("section", _extends({}, props, {
      className: "".concat(pageHeaderClasses, " ").concat(themeClasses),
      "widget-type": "InsightsPageHeader"
    }), children);
  });
};

export default PageHeader;
PageHeader.propTypes = {
  children: propTypes.any.isRequired,
  className: propTypes.string
};