import React from 'react';
import propTypes from 'prop-types';
import { EmptyState } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyState.js";
import { EmptyStateIcon } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateIcon.js";
import { EmptyStateBody } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateBody.js";
import { Title } from "@patternfly/react-core/dist/esm/components/Title/Title.js";
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import DisconnectedIcon from "@patternfly/react-icons/dist/esm/icons/disconnected-icon";

var NotConnected = function NotConnected(_ref) {
  var titleText = _ref.titleText,
      bodyText = _ref.bodyText,
      buttonText = _ref.buttonText;
  return /*#__PURE__*/React.createElement(EmptyState, null, /*#__PURE__*/React.createElement(EmptyStateIcon, {
    icon: DisconnectedIcon
  }), /*#__PURE__*/React.createElement(Title, {
    headingLevel: "h5",
    size: "lg"
  }, titleText), /*#__PURE__*/React.createElement(EmptyStateBody, null, bodyText), /*#__PURE__*/React.createElement(Button, {
    variant: "primary",
    component: "a",
    href: "http://access.redhat.com/products/cloud_management_services_for_rhel#getstarted",
    target: "_blank",
    rel: "noopener noreferrer",
    className: "pf-u-mt-lg"
  }, buttonText));
};

NotConnected.propTypes = {
  titleText: propTypes.node,
  bodyText: propTypes.node,
  buttonText: propTypes.node
};
NotConnected.defaultProps = {
  titleText: 'This system isn’t connected to Insights yet',
  bodyText: 'To get started, activate the Insights client for this system.',
  buttonText: 'Learn how to activate the Insights client'
};
export default NotConnected;