import _extends from "@babel/runtime/helpers/extends";
import "../../InsightsLabel/./labels.css";
import AngleDoubleDownIcon from "@patternfly/react-icons/dist/esm/icons/angle-double-down-icon";
import AngleDoubleUpIcon from "@patternfly/react-icons/dist/esm/icons/angle-double-up-icon";
import CriticalIcon from './CriticalIcon';
import EqualsIcon from "@patternfly/react-icons/dist/esm/icons/equals-icon";
import { Label } from "@patternfly/react-core/dist/esm/components/Label/Label.js";
import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';
var VALUE_TO_STATE = {
  1: {
    icon: /*#__PURE__*/React.createElement(AngleDoubleDownIcon, null),
    text: 'Low'
  },
  2: {
    icon: /*#__PURE__*/React.createElement(EqualsIcon, null),
    text: 'Moderate'
  },
  3: {
    icon: /*#__PURE__*/React.createElement(AngleDoubleUpIcon, null),
    text: 'Important'
  },
  4: {
    icon: /*#__PURE__*/React.createElement(CriticalIcon, null),
    text: 'Critical'
  }
};

var InsightsLabel = function InsightsLabel(_ref) {
  var value = _ref.value,
      text = _ref.text,
      hideIcon = _ref.hideIcon,
      className = _ref.className,
      rest = _ref.rest;
  return /*#__PURE__*/React.createElement(Label, _extends({}, rest, {
    className: classNames(className, "ins-c-label-".concat(value)),
    icon: !hideIcon && VALUE_TO_STATE[value].icon
  }), text || VALUE_TO_STATE[value].text);
};

InsightsLabel.propTypes = {
  value: PropTypes.number,
  text: PropTypes.node,
  hideIcon: PropTypes.bool,
  className: PropTypes.string,
  rest: PropTypes.object
};
InsightsLabel.defaultProps = {
  value: 1
};
export default InsightsLabel;