import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component } from 'react';
import { Checkbox } from "@patternfly/react-core/dist/esm/components/Checkbox/Checkbox.js";
import { Radio } from "@patternfly/react-core/dist/esm/components/Radio/Radio.js";
import PropTypes from 'prop-types';

var FilterInput = /*#__PURE__*/function (_Component) {
  _inherits(FilterInput, _Component);

  var _super = _createSuper(FilterInput);

  function FilterInput() {
    var _this;

    _classCallCheck(this, FilterInput);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      checked: false
    });

    _defineProperty(_assertThisInitialized(_this), "handleChange", function (checked) {
      var _this$props = _this.props,
          type = _this$props.type,
          addRemoveFilters = _this$props.addRemoveFilters,
          param = _this$props.param,
          value = _this$props.value;
      var updateState;

      switch (type) {
        case 'checkbox':
          updateState = {
            checked: !_this.state.checked
          };
          break;
      }

      _this.setState(_objectSpread({}, updateState));

      addRemoveFilters(value, param, type, checked);
    });

    return _this;
  }

  _createClass(FilterInput, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this$props2 = this.props,
          type = _this$props2.type,
          filters = _this$props2.filters,
          param = _this$props2.param,
          value = _this$props2.value;

      switch (type) {
        case 'checkbox':
          param in filters && filters[param] && filters[param].includes(value) ? this.setState({
            checked: true
          }) : this.setState({
            checked: false
          });
          break;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props3 = this.props,
          label = _this$props3.label,
          id = _this$props3.id,
          param = _this$props3.param,
          value = _this$props3.value,
          type = _this$props3.type,
          filters = _this$props3.filters;
      var checked = this.state.checked;
      return function () {
        switch (type) {
          case 'checkbox':
            return /*#__PURE__*/React.createElement(Checkbox, {
              "aria-label": label,
              id: id,
              isChecked: checked,
              label: label,
              onChange: _this2.handleChange,
              param: param,
              value: value,
              ouiaId: label
            });

          case 'radio':
            return /*#__PURE__*/React.createElement(Radio, {
              isChecked: filters[param] === value,
              "aria-label": label,
              id: id,
              label: label,
              name: param,
              onChange: _this2.handleChange,
              param: param,
              value: value,
              ouiaId: label
            });
        }
      }();
    }
  }]);

  return FilterInput;
}(Component);

FilterInput.propTypes = {
  addRemoveFilters: PropTypes.func,
  className: PropTypes.string,
  currentPage: PropTypes.string,
  id: PropTypes.string.isRequired,
  label: PropTypes.node.isRequired,
  param: PropTypes.string,
  value: PropTypes.any,
  filters: PropTypes.object,
  type: PropTypes.string
};
FilterInput.defaultProps = {
  addRemoveFilters: Function.prototype,
  className: null,
  currentPage: null,
  param: null,
  filters: {},
  type: 'checkbox',
  value: undefined
};
export default FilterInput;