import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import React, { useState, useEffect } from 'react';
import { constructGroups, mapGroups } from './constants';
import { Spinner } from "@patternfly/react-core/dist/esm/components/Spinner/Spinner.js";
import "../../FilterHooks/./tagFilterHook.css";
export var tagsFilterState = {
  tagsFilter: {}
};
export var TAGS_FILTER = 'TAGS_FILTER';
export var tagsFilterReducer = function tagsFilterReducer(_state, _ref) {
  var type = _ref.type,
      payload = _ref.payload;
  return _objectSpread({}, type === TAGS_FILTER && {
    tagsFilter: payload
  });
};
export var useTagsFilter = function useTagsFilter() {
  var allTags = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  var loaded = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var additionalTagsCount = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
  var onShowMoreClick = arguments.length > 3 ? arguments[3] : undefined;

  var _ref2 = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : [tagsFilterState],
      _ref3 = _slicedToArray(_ref2, 2),
      globalState = _ref3[0],
      dispatch = _ref3[1];

  var itemText = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : 'item';
  var showMoreTitle = arguments.length > 6 ? arguments[6] : undefined;

  var _useState = useState({
    allTags: [],
    loaded: false,
    additionalTagsCount: 0
  }),
      _useState2 = _slicedToArray(_useState, 2),
      state = _useState2[0],
      setState = _useState2[1];

  useEffect(function () {
    setState(function () {
      return {
        allTags: allTags,
        loaded: loaded,
        additionalTagsCount: additionalTagsCount
      };
    });
  }, [loaded]);

  var _useState3 = useState({}),
      _useState4 = _slicedToArray(_useState3, 2),
      selectedStateTags = _useState4[0],
      setStateValue = _useState4[1];

  var selectedTags = dispatch ? globalState.tagsFilter : selectedStateTags;
  var setValue = dispatch ? function (newValue) {
    return dispatch({
      type: TAGS_FILTER,
      payload: newValue
    });
  } : setStateValue;

  var _useState5 = useState(''),
      _useState6 = _slicedToArray(_useState5, 2),
      filterTagsBy = _useState6[0],
      seFilterTagsBy = _useState6[1];

  var filter = _objectSpread(_objectSpread({
    className: 'ins-c-tagfilter',
    onFilter: function onFilter(value) {
      return seFilterTagsBy(value);
    },
    filterBy: filterTagsBy,
    onChange: function onChange(_e, newSelection, group, item, groupKey, itemKey) {
      if (item.meta) {
        var isSelected = newSelection[groupKey][itemKey];
        newSelection[groupKey][itemKey] = {
          isSelected: isSelected,
          group: group,
          item: item
        };
        setValue(newSelection);
      }
    },
    selected: selectedTags
  }, additionalTagsCount && {
    onShowMore: function onShowMore() {
      return onShowMoreClick && onShowMoreClick.apply(void 0, arguments);
    },
    showMoreTitle: showMoreTitle || "".concat(state.additionalTagsCount, " more tags available")
  }), loaded && allTags.length > 0 ? {
    groups: _toConsumableArray(constructGroups(allTags, itemText))
  } : {
    value: '',
    items: [{
      value: '',
      label: !state.loaded ? /*#__PURE__*/React.createElement("span", {
        key: "no-tags-tooltip"
      }, " ", /*#__PURE__*/React.createElement(Spinner, {
        size: "md"
      }), " ") : /*#__PURE__*/React.createElement("div", {
        className: "ins-c-tagfilter__no-tags"
      }, " No tags available "),
      isDisabled: true,
      className: 'ins-c-tagfilter__tail'
    }]
  });

  return {
    filter: filter,
    chips: mapGroups(selectedTags, 'chips'),
    selectedTags: selectedTags,
    setValue: setValue,
    filterTagsBy: filterTagsBy,
    seFilterTagsBy: seFilterTagsBy
  };
};