import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import React from 'react';
import { Stack } from "@patternfly/react-core/dist/esm/layouts/Stack/Stack.js";
import { StackItem } from "@patternfly/react-core/dist/esm/layouts/Stack/StackItem.js";
import { ExclamationCircleIcon } from '@patternfly/react-icons/';
import DefaultErrorMessage from './DefaultErrorMessage';
import propTypes from 'prop-types';
import { Title } from "@patternfly/react-core/dist/esm/components/Title/Title.js";
import { EmptyState } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyState.js";
import { EmptyStateVariant } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyState.js";
import { EmptyStateIcon } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateIcon.js";
import { EmptyStateBody } from "@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateBody.js";
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import "../../ErrorState/./error-state.css";

var ErrorState = function ErrorState(_ref) {
  var errorTitle = _ref.errorTitle,
      errorDescription = _ref.errorDescription,
      props = _objectWithoutProperties(_ref, ["errorTitle", "errorDescription"]);

  return /*#__PURE__*/React.createElement(EmptyState, _extends({
    variant: EmptyStateVariant.large
  }, props, {
    className: "ins-c-error-state"
  }), /*#__PURE__*/React.createElement(EmptyStateIcon, {
    icon: ExclamationCircleIcon
  }), /*#__PURE__*/React.createElement(Title, {
    headingLevel: "h4",
    size: "lg"
  }, errorTitle), /*#__PURE__*/React.createElement(EmptyStateBody, null, /*#__PURE__*/React.createElement(Stack, null, !errorDescription && /*#__PURE__*/React.createElement(StackItem, null, "There was a problem processing the request. Please try again."), /*#__PURE__*/React.createElement(StackItem, null, errorDescription || /*#__PURE__*/React.createElement(DefaultErrorMessage, null)))), document.referrer ? /*#__PURE__*/React.createElement(Button, {
    variant: "primary",
    onClick: function onClick() {
      return history.back();
    }
  }, "Return to last page") : /*#__PURE__*/React.createElement(Button, {
    variant: "primary",
    component: "a",
    href: ".",
    target: "_blank",
    rel: "noopener noreferrer"
  }, "Go to home page"));
};

ErrorState.propTypes = {
  errorTitle: propTypes.string,
  errorDescription: propTypes.string
};
ErrorState.defaultProps = {
  errorTitle: 'Something went wrong'
};
export default ErrorState;