"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _Modal = require("@patternfly/react-core/dist/js/components/Modal/Modal.js");

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

require("./wizard.css");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var Wizard = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(Wizard, _Component);

  var _super = _createSuper(Wizard);

  function Wizard() {
    var _this;

    (0, _classCallCheck2["default"])(this, Wizard);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "state", {
      currentStep: 0
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "handleNextModalStep", function () {
      _this.setState(function (_ref) {
        var currentStep = _ref.currentStep;
        return {
          currentStep: currentStep + 1
        };
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "handlePreviousModalStep", function () {
      _this.setState(function (_ref2) {
        var currentStep = _ref2.currentStep;
        return {
          currentStep: currentStep - 1
        };
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "handleOnClose", function (submit) {
      var result = _this.props.onClose(submit);

      if (result === false) {
        return;
      }

      _this.setState({
        currentStep: 0
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "handleKeyPress", function (event) {
      if (event.key === 'Enter' && _this.props.isValidated === true) {
        _this.handleNextModalStep();
      }
    });
    return _this;
  }

  (0, _createClass2["default"])(Wizard, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          isLarge = _this$props.isLarge,
          title = _this$props.title,
          className = _this$props.className,
          isOpen = _this$props.isOpen,
          isValidated = _this$props.isValidated,
          confirmAction = _this$props.confirmAction,
          props = (0, _objectWithoutProperties2["default"])(_this$props, ["isLarge", "title", "className", "isOpen", "isValidated", "confirmAction"]);
      var wizardClasses = (0, _classnames["default"])('ins-c-wizard', className);
      var renderModalActions = [// Conditionally render 'confirm' button if on last page
      this.state.currentStep < this.props.content.length - 1 ? /*#__PURE__*/_react["default"].createElement(_Button.Button, {
        key: "Next",
        action: "next",
        variant: "primary",
        isDisabled: !isValidated,
        onClick: this.handleNextModalStep
      }, "Next") : /*#__PURE__*/_react["default"].createElement(_Button.Button, {
        key: "confirm",
        action: "confirm",
        variant: "primary",
        isDisabled: !isValidated,
        onClick: function onClick() {
          return _this2.handleOnClose(true);
        }
      }, confirmAction), // Conditionally render 'previous' button if not on first page
      this.state.currentStep !== 0 && /*#__PURE__*/_react["default"].createElement(_Button.Button, {
        key: "back",
        action: "back",
        variant: "secondary",
        onClick: this.handlePreviousModalStep
      }, " Back "), /*#__PURE__*/_react["default"].createElement(_Button.Button, {
        key: "cancel",
        action: "cancel",
        variant: "secondary",
        onClick: function onClick() {
          return _this2.handleOnClose(false);
        }
      }, "Cancel")];
      return /*#__PURE__*/_react["default"].createElement(_Modal.Modal, (0, _extends2["default"])({}, props, {
        onKeyPress: this.handleKeyPress,
        variant: "large",
        title: title,
        className: wizardClasses,
        isOpen: isOpen,
        onClose: function onClose() {
          return _this2.handleOnClose(false);
        },
        actions: renderModalActions
      }), this.props.content[this.state.currentStep]);
    }
  }]);
  return Wizard;
}(_react.Component);

Wizard.propTypes = {
  isValidated: _propTypes["default"].bool,
  isLarge: _propTypes["default"].bool,
  title: _propTypes["default"].string,
  className: _propTypes["default"].string,
  confirmAction: _propTypes["default"].string,
  isOpen: _propTypes["default"].any,
  content: _propTypes["default"].array,
  onClose: _propTypes["default"].func
};
Wizard.defaultProps = {
  onClose: function onClose(f) {
    return f;
  },
  isValidated: true,
  confirmAction: 'Confirm'
};
var _default = Wizard;
exports["default"] = _default;