"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _Toolbar = require("@patternfly/react-core/dist/js/components/Toolbar/Toolbar.js");

var _reactCore = require("@patternfly/react-core/");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

require("./TableToolbar.css");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function generateCount(results) {
  if (results > 1 || results < 1) {
    return "".concat(results, " Results");
  } else {
    return "".concat(results, " Result");
  }
}

var TableToolbar = function TableToolbar(_ref) {
  var isFooter = _ref.isFooter,
      results = _ref.results,
      className = _ref.className,
      selected = _ref.selected,
      children = _ref.children,
      ouiaId = _ref.ouiaId,
      _ref$ouiaSafe = _ref.ouiaSafe,
      ouiaSafe = _ref$ouiaSafe === void 0 ? true : _ref$ouiaSafe,
      props = (0, _objectWithoutProperties2["default"])(_ref, ["isFooter", "results", "className", "selected", "children", "ouiaId", "ouiaSafe"]);
  var tableToolbarClasses = (0, _classnames["default"])('ins-c-table__toolbar', (0, _defineProperty2["default"])({}, "ins-m-footer", isFooter), className);
  var ouiaComponentType = 'RHI/TableToolbar';
  var ouiaFinalId = (0, _reactCore.useOUIAId)(ouiaComponentType, ouiaId, ouiaSafe);
  return /*#__PURE__*/_react["default"].createElement(_react.Fragment, null, /*#__PURE__*/_react["default"].createElement(_Toolbar.Toolbar, (0, _extends2["default"])({
    className: tableToolbarClasses,
    "data-ouia-component-type": ouiaComponentType,
    "data-ouia-component-id": ouiaFinalId,
    "data-ouia-safe": ouiaSafe
  }, props), children), (results >= 0 || selected >= 0) && /*#__PURE__*/_react["default"].createElement("div", {
    className: "ins-c-table__toolbar-results"
  }, results >= 0 && /*#__PURE__*/_react["default"].createElement("span", {
    className: "ins-c-table__toolbar-results-count"
  }, " ", generateCount(results), " "), selected >= 0 && /*#__PURE__*/_react["default"].createElement("span", {
    className: "ins-c-table__toolbar-results-selected"
  }, " ", selected, " Selected ")));
};

var _default = TableToolbar;
exports["default"] = _default;
TableToolbar.propTypes = {
  isFooter: _propTypes["default"].bool,
  results: _propTypes["default"].number,
  children: _propTypes["default"].any,
  className: _propTypes["default"].string,
  selected: _propTypes["default"].number,
  ouiaId: _propTypes["default"].string,
  ouiaSafe: _propTypes["default"].bool
};
TableToolbar.defaultProps = {
  isFooter: false
};