"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireDefault(require("react"));

var _reactTable = require("@patternfly/react-table");

var _Skeleton = require("../Skeleton");

var _propTypes = _interopRequireDefault(require("prop-types"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var SkeletonTable = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2["default"])(SkeletonTable, _React$Component);

  var _super = _createSuper(SkeletonTable);

  function SkeletonTable() {
    var _this;

    (0, _classCallCheck2["default"])(this, SkeletonTable);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "createColumns", function () {
      var colSize = _this.props.colSize;
      return (0, _toConsumableArray2["default"])(Array(colSize)).map(function () {
        return {
          title: /*#__PURE__*/_react["default"].createElement(_Skeleton.Skeleton, {
            size: _Skeleton.SkeletonSize.sm
          })
        };
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "getColumns", function () {
      var _this$props = _this.props,
          paddingColumnSize = _this$props.paddingColumnSize,
          columns = _this$props.columns;
      return _this.newArray(paddingColumnSize).map(function () {
        return '';
      }).concat(columns || _this.createColumns());
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "createRows", function () {
      var _this$props2 = _this.props,
          colSize = _this$props2.colSize,
          rowSize = _this$props2.rowSize,
          columns = _this$props2.columns,
          paddingColumnSize = _this$props2.paddingColumnSize;
      var numberOfCols = columns ? columns.length : colSize;
      return _this.newArray(rowSize).map(function () {
        return {
          disableSelection: true,
          cells: _this.newArray(paddingColumnSize).map(function () {
            return '';
          }).concat(_this.newArray(numberOfCols).map(function () {
            return {
              title: /*#__PURE__*/_react["default"].createElement(_Skeleton.Skeleton, {
                size: _Skeleton.SkeletonSize.md
              })
            };
          }))
        };
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "selectVariant", function () {
      var hasRadio = _this.props.hasRadio;
      return hasRadio ? (_reactTable.RowSelectVariant === null || _reactTable.RowSelectVariant === void 0 ? void 0 : _reactTable.RowSelectVariant.radio) || 'radio' : (_reactTable.RowSelectVariant === null || _reactTable.RowSelectVariant === void 0 ? void 0 : _reactTable.RowSelectVariant.checkbox) || 'checkbox';
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "newArray", function (size) {
      return (0, _toConsumableArray2["default"])(Array(size));
    });
    return _this;
  }

  (0, _createClass2["default"])(SkeletonTable, [{
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          canSelectAll = _this$props3.canSelectAll,
          isSelectable = _this$props3.isSelectable,
          sortBy = _this$props3.sortBy,
          variant = _this$props3.variant;
      return /*#__PURE__*/_react["default"].createElement(_reactTable.Table, {
        cells: this.getColumns(),
        rows: this.createRows(),
        sortBy: sortBy,
        "aria-label": "Loading",
        onSelect: isSelectable,
        selectVariant: isSelectable ? this.selectVariant() : null,
        canSelectAll: canSelectAll,
        variant: variant
      }, /*#__PURE__*/_react["default"].createElement(_reactTable.TableHeader, null), /*#__PURE__*/_react["default"].createElement(_reactTable.TableBody, null));
    }
  }]);
  return SkeletonTable;
}(_react["default"].Component);

SkeletonTable.propTypes = {
  colSize: _propTypes["default"].number,
  rowSize: _propTypes["default"].number,
  columns: _propTypes["default"].array,
  paddingColumnSize: _propTypes["default"].number,
  sortBy: _propTypes["default"].shape({
    index: _propTypes["default"].number,
    direction: _propTypes["default"].oneOf(['asc', 'desc'])
  }),
  isSelectable: _propTypes["default"].bool,
  canSelectAll: _propTypes["default"].bool,
  hasRadio: _propTypes["default"].bool,
  variant: _propTypes["default"].string
};
SkeletonTable.defaultProps = {
  rowSize: 0,
  paddingColumnSize: 0,
  canSelectAll: false,
  isSelectable: false,
  hasRadio: false,
  variant: null
};
var _default = SkeletonTable;
exports["default"] = _default;