"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.dropDirection = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _PaginationNext = _interopRequireDefault(require("./PaginationNext"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var dropDirection = {
  up: 'up',
  down: 'down'
};
exports.dropDirection = dropDirection;
var pager = [10, 15, 20, 25, 50];

var Pagination = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(Pagination, _Component);

  var _super = _createSuper(Pagination);

  function Pagination() {
    var _this;

    (0, _classCallCheck2["default"])(this, Pagination);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "setPage", function (page, debounce) {
      var currPage = _this.props.page;
      var perPage = _this.props.itemsPerPage || pager[0];
      var maxPage = Math.ceil(_this.props.numberOfItems / perPage);
      page = isNaN(page) ? currPage : page;
      page = page > maxPage ? maxPage : page < 0 ? 0 : page;
      _this.props.hasOwnProperty('onSetPage') && _this.props.onSetPage(page, debounce);
    });
    return _this;
  }

  (0, _createClass2["default"])(Pagination, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          page = _this$props.page,
          onSetPage = _this$props.onSetPage,
          numberOfItems = _this$props.numberOfItems,
          itemsPerPage = _this$props.itemsPerPage,
          perPageOptions = _this$props.perPageOptions,
          onPerPageSelect = _this$props.onPerPageSelect,
          onFirstPage = _this$props.onFirstPage,
          onLastPage = _this$props.onLastPage,
          onPreviousPage = _this$props.onPreviousPage,
          onNextPage = _this$props.onNextPage,
          props = (0, _objectWithoutProperties2["default"])(_this$props, ["page", "onSetPage", "numberOfItems", "itemsPerPage", "perPageOptions", "onPerPageSelect", "onFirstPage", "onLastPage", "onPreviousPage", "onNextPage"]);
      var pagerOptions = perPageOptions || pager;
      var perPage = itemsPerPage || pagerOptions[0];
      var lastPage = Math.ceil(numberOfItems / perPage);
      var lastIndex = numberOfItems === 0 ? 0 : page === lastPage ? numberOfItems : page * perPage;
      var firstIndex = numberOfItems === 0 ? 0 : (page - 1) * perPage + 1;
      return /*#__PURE__*/_react["default"].createElement(_PaginationNext["default"], (0, _extends2["default"])({}, props, {
        itemCount: this.props.numberOfItems,
        className: "ins-c-pagination-next",
        itemsStart: firstIndex,
        itemsEnd: lastIndex,
        lastPage: lastPage || 1,
        dropDirection: this.props.direction,
        onFirstPage: onFirstPage,
        onLastPage: onLastPage,
        onPreviousPage: onPreviousPage,
        onNextPage: onNextPage,
        perPage: perPage,
        onSetPerPage: function onSetPerPage(_event, value) {
          return _this2.props.onPerPageSelect(value);
        },
        page: this.props.page,
        setPage: function setPage(event, page) {
          return _this2.setPage(page, event.currentTarget.tagName === 'INPUT');
        },
        perPageOptions: pagerOptions.map(function (value) {
          return {
            title: value,
            value: value
          };
        })
      }));
    }
  }]);
  return Pagination;
}(_react.Component);

Pagination.propTypes = {
  direction: _propTypes["default"].oneOf(Object.keys(dropDirection)),
  viewType: _propTypes["default"].string,
  itemsPerPage: _propTypes["default"].number,
  perPageOptions: _propTypes["default"].arrayOf(_propTypes["default"].number),
  numberOfItems: _propTypes["default"].number.isRequired,
  onSetPage: _propTypes["default"].func,
  onPerPageSelect: _propTypes["default"].func,
  onFirstPage: _propTypes["default"].func,
  onLastPage: _propTypes["default"].func,
  onPreviousPage: _propTypes["default"].func,
  onNextPage: _propTypes["default"].func,
  page: _propTypes["default"].number
};
Pagination.defaultProps = {
  page: 1
};
var _default = Pagination;
exports["default"] = _default;