"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapGroups = mapGroups;
exports.constructValues = constructValues;
exports.constructGroups = constructGroups;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireDefault(require("react"));

var _Badge = require("@patternfly/react-core/dist/js/components/Badge/Badge.js");

var _Tooltip = require("@patternfly/react-core/dist/js/components/Tooltip/Tooltip.js");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function mapGroups(currSelection) {
  var valuesKey = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'values';
  return Object.entries(currSelection || {}).reduce(function (acc, _ref) {
    var _ref2 = (0, _slicedToArray2["default"])(_ref, 2),
        groupKey = _ref2[0],
        groupValue = _ref2[1];

    var values = constructValues(groupValue, groupKey);

    if (values.length > 0) {
      var _values$, _values$$group, _values$2, _values$2$group;

      return [].concat((0, _toConsumableArray2["default"])(acc), [(0, _defineProperty2["default"])({
        type: 'tags',
        key: groupKey,
        category: ((_values$ = values[0]) === null || _values$ === void 0 ? void 0 : (_values$$group = _values$.group) === null || _values$$group === void 0 ? void 0 : _values$$group.value) || ((_values$2 = values[0]) === null || _values$2 === void 0 ? void 0 : (_values$2$group = _values$2.group) === null || _values$2$group === void 0 ? void 0 : _values$2$group.label)
      }, valuesKey, values)]);
    }

    return acc;
  }, []);
}

function constructValues(groupValue, groupKey) {
  return Object.entries(groupValue || {}).reduce(function (acc, _ref4) {
    var _ref5 = (0, _slicedToArray2["default"])(_ref4, 2),
        key = _ref5[0],
        _ref5$ = _ref5[1],
        isSelected = _ref5$.isSelected,
        group = _ref5$.group,
        value = _ref5$.value,
        item = _ref5$.item;

    if (isSelected) {
      var _item$meta;

      var _ref6 = (item === null || item === void 0 ? void 0 : (_item$meta = item.meta) === null || _item$meta === void 0 ? void 0 : _item$meta.tag) || {
        key: (item === null || item === void 0 ? void 0 : item.tagKey) || groupKey,
        value: value || (item === null || item === void 0 ? void 0 : item.tagValue)
      },
          tagKey = _ref6.key,
          tagValue = _ref6.value;

      return [].concat((0, _toConsumableArray2["default"])(acc), [{
        key: key,
        tagKey: tagKey,
        value: tagValue,
        name: "".concat(tagKey).concat(tagValue ? "=".concat(tagValue) : ''),
        group: _objectSpread({
          value: groupKey
        }, group)
      }]);
    }

    return acc;
  }, []);
}

function constructGroups(allTags) {
  var item = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'item';
  return allTags.map(function (_ref7) {
    var name = _ref7.name,
        tags = _ref7.tags,
        _ref7$type = _ref7.type,
        type = _ref7$type === void 0 ? 'checkbox' : _ref7$type,
        rest = (0, _objectWithoutProperties2["default"])(_ref7, ["name", "tags", "type"]);
    return _objectSpread(_objectSpread({}, rest), {}, {
      label: name,
      value: name,
      type: type,
      items: tags.map(function (_ref8) {
        var count = _ref8.count,
            _ref8$tag = _ref8.tag,
            tagKey = _ref8$tag.key,
            value = _ref8$tag.value;
        var tagText = "".concat(tagKey).concat(value ? "=".concat(value) : '');
        return {
          className: 'ins-c-tagfilter__option',
          label: /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, null, /*#__PURE__*/_react["default"].createElement(_Tooltip.Tooltip, {
            content: tagText
          }, /*#__PURE__*/_react["default"].createElement("div", {
            className: "ins-c-tagfilter__option-value"
          }, tagText)), count !== undefined && /*#__PURE__*/_react["default"].createElement(_Tooltip.Tooltip, {
            position: "right",
            enableFlip: true,
            content: "Applicable to ".concat(count, " ").concat(item).concat(count === 1 ? '' : 's', ".")
          }, /*#__PURE__*/_react["default"].createElement(_Badge.Badge, {
            isRead: count <= 0
          }, count))),
          meta: {
            count: count,
            tag: {
              key: tagKey,
              value: value
            }
          },
          id: "".concat(tagKey, "-").concat(value),
          tagKey: tagKey,
          value: tagText,
          tagValue: value
        };
      })
    });
  });
}