"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dateByType = exports.dateStringByType = exports.addTooltip = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _Tooltip = require("@patternfly/react-core/dist/js/components/Tooltip/Tooltip.js");

var second = 1000;
var minute = second * 60;
var hour = minute * 60;
var day = hour * 24;
var month = day * 30; // let's count that every month has 30 days

var year = day * 365;

var formatTime = function formatTime(number, unit) {
  return "".concat(number, " ").concat(number > 1 ? "".concat(unit, "s") : unit, " ago");
};

var relativeTimeTable = [{
  rightBound: Infinity,
  description: function description(date) {
    return formatTime(Math.round(date / year), 'year');
  }
}, {
  rightBound: year,
  description: function description(date) {
    return formatTime(Math.round(date / month), 'month');
  }
}, {
  rightBound: month,
  description: function description(date) {
    return formatTime(Math.round(date / day), 'day');
  }
}, {
  rightBound: day,
  description: function description(date) {
    return formatTime(Math.round(date / hour), 'hour');
  }
}, {
  rightBound: hour,
  description: function description(date) {
    return formatTime(Math.round(date / minute), 'minute');
  }
}, {
  rightBound: minute,
  description: function description() {
    return 'Just now';
  }
}];

var _exact = function exact(value) {
  return value.toUTCString().split(',')[1].slice(0, -7).trim();
};

var addTooltip = function addTooltip(date, element, tooltipProps) {
  var extraTitle = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
  return /*#__PURE__*/_react["default"].createElement(_Tooltip.Tooltip, (0, _extends2["default"])({}, tooltipProps, {
    content: /*#__PURE__*/_react["default"].createElement("div", null, extraTitle, date)
  }), element);
};

exports.addTooltip = addTooltip;

var dateStringByType = function dateStringByType(type) {
  return {
    exact: function exact(date) {
      return _exact(date) + ' UTC';
    },
    onlyDate: function onlyDate(date) {
      return _exact(date).slice(0, -6);
    },
    relative: function relative(date) {
      return relativeTimeTable.reduce(function (acc, i) {
        return i.rightBound > Date.now() - date ? i.description(Date.now() - date) : acc;
      }, _exact(date));
    },
    invalid: function invalid() {
      return 'Invalid date';
    }
  }[type];
};

exports.dateStringByType = dateStringByType;

var dateByType = function dateByType(type, tooltipProps, extraTitle) {
  return {
    exact: function exact(date) {
      return dateStringByType(type)(date);
    },
    onlyDate: function onlyDate(date) {
      return dateStringByType(type)(date);
    },
    relative: function relative(date) {
      return addTooltip(dateStringByType('exact')(date), /*#__PURE__*/_react["default"].createElement("span", null, dateStringByType(type)(date)), tooltipProps, extraTitle);
    },
    invalid: function invalid() {
      return 'Invalid date';
    }
  }[type];
};

exports.dateByType = dateByType;