"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Select = require("@patternfly/react-core/dist/js/components/Select/Select.js");

var _SelectOption = require("@patternfly/react-core/dist/js/components/Select/SelectOption.js");

var _selectConstants = require("@patternfly/react-core/dist/js/components/Select/selectConstants.js");

var _Radio = require("@patternfly/react-core/dist/js/components/Radio/Radio.js");

var _TextFilter = _interopRequireDefault(require("./TextFilter"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var Radio = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(Radio, _Component);

  var _super = _createSuper(Radio);

  function Radio() {
    var _this;

    (0, _classCallCheck2["default"])(this, Radio);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "state", {
      isExpanded: false,
      checked: undefined
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onToggle", function (isExpanded) {
      _this.setState({
        isExpanded: isExpanded
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "calculateSelected", function () {
      var checked = _this.state.checked;
      var selectedValue = _this.props.value;
      return selectedValue && (selectedValue.value || selectedValue) || checked && (checked.value || checked);
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onSelect", function (event, selection) {
      var onChange = _this.props.onChange;
      onChange(event, selection);

      _this.setState({
        checked: selection
      });
    });
    return _this;
  }

  (0, _createClass2["default"])(Radio, [{
    key: "render",
    value: function render() {
      var isExpanded = this.state.isExpanded;
      var _this$props = this.props,
          items = _this$props.items,
          placeholder = _this$props.placeholder,
          isDisabled = _this$props.isDisabled,
          className = _this$props.className;
      var checkedValue = this.calculateSelected();
      return /*#__PURE__*/_react["default"].createElement(_react.Fragment, null, !items || items && items.length <= 0 ? /*#__PURE__*/_react["default"].createElement(_TextFilter["default"], (0, _extends2["default"])({}, this.props, {
        value: "".concat(this.calculateSelected())
      })) : /*#__PURE__*/_react["default"].createElement(_Select.Select, {
        className: className,
        variant: _selectConstants.SelectVariant.single,
        "aria-label": "Select Input",
        isDisabled: isDisabled,
        onToggle: this.onToggle,
        onSelect: this.onSelect,
        isOpen: isExpanded,
        placeholderText: placeholder,
        ouiaId: placeholder
      }, items.map(function (_ref, key) {
        var value = _ref.value,
            isChecked = _ref.isChecked,
            _onChange = _ref.onChange,
            label = _ref.label,
            id = _ref.id,
            item = (0, _objectWithoutProperties2["default"])(_ref, ["value", "isChecked", "onChange", "label", "id"]);
        return /*#__PURE__*/_react["default"].createElement(_SelectOption.SelectOption, (0, _extends2["default"])({}, item, {
          key: id || key,
          value: value || '' + key
        }), /*#__PURE__*/_react["default"].createElement(_Radio.Radio, (0, _extends2["default"])({}, item, {
          name: id || "".concat(key, "-radio"),
          label: label,
          value: value || key,
          isChecked: isChecked || checkedValue !== undefined && checkedValue === value || checkedValue !== undefined && checkedValue === '' + key || false,
          onChange: function onChange(_value, e) {
            return _onChange && _onChange(e, _objectSpread({
              id: id,
              label: label,
              value: value,
              isChecked: isChecked
            }, item), key);
          },
          id: id || "".concat(value, "-").concat(key)
        })));
      })));
    }
  }]);
  return Radio;
}(_react.Component);

Radio.propTypes = {
  onChange: _propTypes["default"].func,
  value: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].shape({
    label: _propTypes["default"].node,
    value: _propTypes["default"].string
  })]),
  placeholder: _propTypes["default"].string,
  items: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    value: _propTypes["default"].string,
    label: _propTypes["default"].node,
    id: _propTypes["default"].string,
    isChecked: _propTypes["default"].bool,
    onChange: _propTypes["default"].func
  })),
  isDisabled: _propTypes["default"].bool,
  className: _propTypes["default"].string
};
Radio.defaultProps = {
  items: [],
  onChange: function onChange() {
    return undefined;
  },
  isDisabled: false
};
var _default = Radio;
exports["default"] = _default;