"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _TextInput = require("@patternfly/react-core/dist/js/components/TextInput/TextInput.js");

var _MenuList = require("@patternfly/react-core/dist/js/components/Menu/MenuList.js");

var _MenuItem = require("@patternfly/react-core/dist/js/components/Menu/MenuItem.js");

var _MenuGroup = require("@patternfly/react-core/dist/js/components/Menu/MenuGroup.js");

var _Checkbox = require("@patternfly/react-core/dist/js/components/Checkbox/Checkbox.js");

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

var _MenuToggle = require("@patternfly/react-core/dist/js/components/MenuToggle/MenuToggle.js");

var _Menu = require("@patternfly/react-core/dist/js/components/Menu/Menu.js");

var _MenuContent = require("@patternfly/react-core/dist/js/components/Menu/MenuContent.js");

var _Popper = require("@patternfly/react-core/dist/js/helpers/Popper/Popper.js");

var _Radio = require("@patternfly/react-core/dist/js/components/Radio/Radio.js");

var _groupFilterConstants = require("./groupFilterConstants");

var _groupType = _interopRequireDefault(require("./groupType"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var Group = function Group(_ref) {
  var placeholder = _ref.placeholder,
      onShowMore = _ref.onShowMore,
      showMoreTitle = _ref.showMoreTitle,
      showMoreOptions = _ref.showMoreOptions,
      items = _ref.items,
      filterBy = _ref.filterBy,
      onFilter = _ref.onFilter,
      className = _ref.className,
      _ref$groups = _ref.groups,
      groups = _ref$groups === void 0 ? [] : _ref$groups,
      onChange = _ref.onChange,
      selected = _ref.selected,
      isFilterable = _ref.isFilterable;

  var _useState = (0, _react.useState)({}),
      _useState2 = (0, _slicedToArray2["default"])(_useState, 2),
      stateSelected = _useState2[0],
      setStateSelected = _useState2[1];

  var _useState3 = (0, _react.useState)(''),
      _useState4 = (0, _slicedToArray2["default"])(_useState3, 2),
      searchString = _useState4[0],
      setSearchString = _useState4[1];

  var _useState5 = (0, _react.useState)(false),
      _useState6 = (0, _slicedToArray2["default"])(_useState5, 2),
      isOpen = _useState6[0],
      setIsOpen = _useState6[1];

  var toggleRef = (0, _react.useRef)();
  var containerRef = (0, _react.useRef)();
  var menuRef = (0, _react.useRef)();
  (0, _react.useEffect)(function () {
    setStateSelected(selected);
  }, [selected]);
  var calculateSelection = (0, _react.useCallback)(_groupFilterConstants.calculateSelected, [stateSelected]);
  (0, _react.useEffect)(function () {
    setSearchString(filterBy);
  }, [filterBy]);

  var handleMenuKeys = function handleMenuKeys(event) {
    if (!isOpen) {
      return;
    }

    if (menuRef.current.contains(event.target) || toggleRef.current.contains(event.target)) {
      if (event.key === 'Escape' || event.key === 'Enter') {
        setIsOpen(!isOpen);
        toggleRef.current.focus();
      }
    }
  };

  var handleClickOutside = function handleClickOutside(event) {
    if (isOpen && !menuRef.current.contains(event.target)) {
      setIsOpen(false);
    }
  };

  (0, _react.useEffect)(function () {
    window.addEventListener('keydown', handleMenuKeys);
    window.addEventListener('click', handleClickOutside);
    return function () {
      window.removeEventListener('keydown', handleMenuKeys);
      window.removeEventListener('click', handleClickOutside);
    };
  }, [isOpen, menuRef]);

  var onToggleClick = function onToggleClick(ev) {
    ev.stopPropagation(); // Stop handleClickOutside from handling

    ev.persist();
    setIsOpen(!isOpen);
  };

  var groupMenuItems = (0, _groupFilterConstants.getGroupMenuItems)(groups, onChange, calculateSelection(selected));
  var menuItems = (0, _groupFilterConstants.getMenuItems)(items, onChange, calculateSelection(selected)); // eslint-disable-next-line react/prop-types

  var renderItems = function renderItems(items, type) {
    var groupKey = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
    return items.map(function (item, key) {
      return /*#__PURE__*/_react["default"].createElement(_MenuItem.MenuItem, {
        itemId: key,
        key: "".concat(item.value, "-").concat(key, "-item"),
        className: item === null || item === void 0 ? void 0 : item.className,
        onClick: item.onClick && (type || item.type) === _groupType["default"].checkbox ? function (e) {
          item.onClick();
          e.preventDefault();
        } : undefined
      }, (type || item.type) === _groupType["default"].checkbox ? /*#__PURE__*/_react["default"].createElement(_Checkbox.Checkbox, (0, _extends2["default"])({}, item, {
        label: item === null || item === void 0 ? void 0 : item.label,
        isChecked: (item === null || item === void 0 ? void 0 : item.isChecked) || (0, _groupFilterConstants.isChecked)(groupKey, (item === null || item === void 0 ? void 0 : item.value) || key, item === null || item === void 0 ? void 0 : item.id, item === null || item === void 0 ? void 0 : item.tagValue, stateSelected, selected) || false,
        onChange: function onChange(value, event) {
          var _item$onChange;

          item === null || item === void 0 ? void 0 : (_item$onChange = item.onChange) === null || _item$onChange === void 0 ? void 0 : _item$onChange.call(item, value, event);
        },
        onClick: item.onClick ? function (e) {
          item.onClick();
          e.stopPropagation();
        } : undefined,
        name: (item === null || item === void 0 ? void 0 : item.name) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key),
        id: (item === null || item === void 0 ? void 0 : item.id) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key)
      })) : (type || item.type) === _groupType["default"].radio ? /*#__PURE__*/_react["default"].createElement(_Radio.Radio, (0, _extends2["default"])({}, item, {
        isChecked: (item === null || item === void 0 ? void 0 : item.isChecked) || (0, _groupFilterConstants.isChecked)((groups === null || groups === void 0 ? void 0 : groups.value) || groupKey, (item === null || item === void 0 ? void 0 : item.value) || key, item === null || item === void 0 ? void 0 : item.id, item === null || item === void 0 ? void 0 : item.tagValue, stateSelected, selected) || false,
        onChange: function onChange(value, event) {
          var _item$onChange2;

          item === null || item === void 0 ? void 0 : (_item$onChange2 = item.onChange) === null || _item$onChange2 === void 0 ? void 0 : _item$onChange2.call(item, value, event);
        },
        value: (item === null || item === void 0 ? void 0 : item.value) || key,
        name: (item === null || item === void 0 ? void 0 : item.name) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key),
        label: (item === null || item === void 0 ? void 0 : item.label) || '',
        id: (item === null || item === void 0 ? void 0 : item.id) || (item === null || item === void 0 ? void 0 : item.value) || "".concat(groupKey, "-").concat(key)
      })) : (type || item.type) === _groupType["default"].button ? /*#__PURE__*/_react["default"].createElement(_Button.Button, (0, _extends2["default"])({}, item, {
        className: "pf-c-select__option-button ".concat((item === null || item === void 0 ? void 0 : item.className) || ''),
        variant: item === null || item === void 0 ? void 0 : item.variant,
        onClick: item.onClick
      }), item === null || item === void 0 ? void 0 : item.label) : (item === null || item === void 0 ? void 0 : item.label) || '');
    });
  };

  return /*#__PURE__*/_react["default"].createElement("div", {
    ref: containerRef
  }, /*#__PURE__*/_react["default"].createElement(_Popper.Popper, {
    appendTo: containerRef.current,
    trigger: /*#__PURE__*/_react["default"].createElement(_MenuToggle.MenuToggle, {
      ref: toggleRef,
      onClick: onToggleClick,
      isExpanded: isOpen,
      className: className
    }, isFilterable || onFilter ? /*#__PURE__*/_react["default"].createElement(_TextInput.TextInput, {
      "aria-label": "input with dropdown and clear button",
      placeholder: placeholder,
      value: searchString,
      tabIndex: 0,
      onChange: function onChange(value) {
        setSearchString(value);
        onFilter === null || onFilter === void 0 ? void 0 : onFilter(value);
      },
      type: "search"
    }) : placeholder),
    popper: /*#__PURE__*/_react["default"].createElement(_Menu.Menu, {
      ref: menuRef,
      className: (0, _classnames["default"])('ins-c-menu__scrollable', className, {
        'pf-m-expanded': isOpen
      })
    }, /*#__PURE__*/_react["default"].createElement(_MenuContent.MenuContent, null, /*#__PURE__*/_react["default"].createElement(_MenuList.MenuList, null, menuItems.length > 0 && /*#__PURE__*/_react["default"].createElement(_MenuGroup.MenuGroup, null, renderItems(items)), groupMenuItems.map(function (group, groupKey) {
      return /*#__PURE__*/_react["default"].createElement(_MenuGroup.MenuGroup, {
        label: group.label,
        key: "".concat(group.label, "-").concat(groupKey, "-group")
      }, renderItems(group.items, group.type, group.value, group));
    }), onShowMore ? /*#__PURE__*/_react["default"].createElement(_MenuItem.MenuItem, (0, _extends2["default"])({
      itemId: "loader",
      className: "ins-c-menu__show--more"
    }, showMoreOptions, {
      onClick: function onClick(e) {
        return onShowMore(e);
      }
    }), showMoreTitle) : /*#__PURE__*/_react["default"].createElement("span", {
      hidden: true,
      value: ""
    })))),
    isVisible: isOpen
  }));
};

Group.propTypes = {
  placeholder: _propTypes["default"].string,
  onShowMore: _propTypes["default"].func,
  showMoreTitle: _propTypes["default"].node,
  onShowMoreTitle: _propTypes["default"].func,
  showMoreOptions: _propTypes["default"].any,
  items: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    id: _propTypes["default"].string,
    value: _propTypes["default"].string,
    label: _propTypes["default"].node
  })),
  className: _propTypes["default"].string,
  selected: _propTypes["default"].shape((0, _defineProperty2["default"])({}, _propTypes["default"].string, _propTypes["default"].shape((0, _defineProperty2["default"])({}, _propTypes["default"].string, _propTypes["default"].shape((0, _defineProperty2["default"])({}, _propTypes["default"].string, _propTypes["default"].any)))))),
  isFilterable: _propTypes["default"].bool,
  filterBy: _propTypes["default"].string,
  onFilter: _propTypes["default"].func,
  groups: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    type: _propTypes["default"].oneOf(Object.keys(_groupType["default"])),
    value: _propTypes["default"].string,
    label: _propTypes["default"].node,
    items: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      id: _propTypes["default"].string,
      tagKey: _propTypes["default"].string
    }))
  })),
  onChange: _propTypes["default"].func.isRequired,
  selectedTags: _propTypes["default"].shape({})
};
var _default = Group;
exports["default"] = _default;