# path-starts-with [![NPM version](https://img.shields.io/npm/v/path-starts-with.svg?style=flat)](https://www.npmjs.com/package/path-starts-with) [![NPM monthly downloads](https://img.shields.io/npm/dm/path-starts-with.svg?style=flat)](https://npmjs.org/package/path-starts-with) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/path-starts-with.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/path-starts-with)

> Returns true if a filepath starts with the given string. Works with windows and posix/unix paths.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save path-starts-with
```

Install with [yarn](https://yarnpkg.com):

```sh
$ yarn add path-starts-with
```

## Usage

```js
var startsWith = require('path-starts-with');

console.log(startsWith('foo/bar', 'foo')); //=> true
console.log(startsWith('foo/bar', 'bar')); //=> false
```

## options

### options.nocase

**Type**: `boolean`

**Default**: `false`

Disable case sensitivity.

```js
startsWith('foo/bar', 'FOO');                 
//=> false
startsWith('foo/bar', 'FOO', {nocase: true}); 
//=> true
```

### options.partialMatch

**Type**: `boolean`

**Default**: `false`

Allow partial matches:

```js
startsWith('foobar', 'foo');  //=> false                 
startsWith('foo.bar', 'foo'); //=> false                 

startsWith('foobar', 'foo', {partialMatch: true});  //=> true 
startsWith('foo.bar', 'foo', {partialMatch: true}); //=> true 
```

## Comparison behavior

### Windows paths

Backslashes are converted to forward slashes before the comparison is done. Thus, both of the following would be `true`:

```js
console.log(startsWith('foo\\bar', 'foo/bar')); //=> true
console.log(startsWith('foo/bar', 'foo\\bar')); //=> true
```

### Leading dot-slash

Leading `./` is stripped from both the filepath and substring. Thus, both of the following would be `true`:

```js
console.log(startsWith('./foo/bar', 'foo')); //=> true
console.log(startsWith('foo/bar', './foo')); //=> true
```

### Leading slashes

When the substring is prefixed with leading slashes, _the number of leading slashes_ must match exactly.

```js
console.log(startsWith('/foo', '/foo'));      //=> true
console.log(startsWith('/foo/bar', '/foo'));  //=> true

console.log(startsWith('/foo/bar', '//foo')); //=> false
console.log(startsWith('//foo/bar', '/foo')); //=> false
```

## About

### Related projects

* [contains-path](https://www.npmjs.com/package/contains-path): Return true if a file path contains the given path. | [homepage](https://github.com/jonschlinkert/contains-path "Return true if a file path contains the given path.")
* [normalize-path](https://www.npmjs.com/package/normalize-path): Normalize file path slashes to be unix-like forward slashes. Also condenses repeat slashes to a… [more](https://github.com/jonschlinkert/normalize-path) | [homepage](https://github.com/jonschlinkert/normalize-path "Normalize file path slashes to be unix-like forward slashes. Also condenses repeat slashes to a single slash and removes and trailing slashes unless disabled.")
* [path-ends-with](https://www.npmjs.com/package/path-ends-with): Return `true` if a file path ends with the given string/suffix. | [homepage](https://github.com/jonschlinkert/path-ends-with "Return `true` if a file path ends with the given string/suffix.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

Please read the [contributing guide](.github/contributing.md) for advice on opening issues, pull requests, and coding standards.

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.5.0, on April 17, 2017._