"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmLaunchLink = void 0;
var react_1 = __importDefault(require("react"));
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
var AcmButton_1 = require("../AcmButton/AcmButton");
var AcmDropdown_1 = require("../AcmDropdown/AcmDropdown");
function AcmLaunchLink(props) {
    /* istanbul ignore next */
    var onSelect = function () { return null; };
    if (props.links !== undefined && props.links.length > 0) {
        if (props.links.length === 1) {
            var link = props.links[0];
            return (react_1.default.createElement(AcmButton_1.AcmButton, { href: link.href, variant: react_core_1.ButtonVariant.link, component: "a", target: "_blank", rel: "noreferrer", id: link.id, icon: react_1.default.createElement(react_icons_1.ExternalLinkAltIcon, null), iconPosition: "right" }, link.text));
        }
        else {
            return (react_1.default.createElement(AcmDropdown_1.AcmDropdown, { onSelect: onSelect, text: "Launch dashboard", id: "addon-launch-links", dropdownItems: props.links.map(function (link) { return ({
                    id: link.id,
                    text: link.text,
                    href: link.href,
                    component: 'a',
                    target: '_blank',
                    rel: 'noreferrer',
                    icon: react_1.default.createElement(react_icons_1.ExternalLinkAltIcon, null),
                }); }) }));
        }
    }
    else {
        return null;
    }
}
exports.AcmLaunchLink = AcmLaunchLink;
//# sourceMappingURL=AcmLaunchLink.js.map