// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/automl/v1beta1/data_stats.proto

package automl // import "google.golang.org/genproto/googleapis/cloud/automl/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The data statistics of a series of values that share the same DataType.
type DataStats struct {
	// The data statistics specific to a DataType.
	//
	// Types that are valid to be assigned to Stats:
	//	*DataStats_Float64Stats
	//	*DataStats_StringStats
	//	*DataStats_TimestampStats
	//	*DataStats_ArrayStats
	//	*DataStats_StructStats
	//	*DataStats_CategoryStats
	Stats isDataStats_Stats `protobuf_oneof:"stats"`
	// The number of distinct values.
	DistinctValueCount int64 `protobuf:"varint,1,opt,name=distinct_value_count,json=distinctValueCount,proto3" json:"distinct_value_count,omitempty"`
	// The number of values that are null.
	NullValueCount       int64    `protobuf:"varint,2,opt,name=null_value_count,json=nullValueCount,proto3" json:"null_value_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DataStats) Reset()         { *m = DataStats{} }
func (m *DataStats) String() string { return proto.CompactTextString(m) }
func (*DataStats) ProtoMessage()    {}
func (*DataStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_stats_e2571ab261ca3ffb, []int{0}
}
func (m *DataStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DataStats.Unmarshal(m, b)
}
func (m *DataStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DataStats.Marshal(b, m, deterministic)
}
func (dst *DataStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataStats.Merge(dst, src)
}
func (m *DataStats) XXX_Size() int {
	return xxx_messageInfo_DataStats.Size(m)
}
func (m *DataStats) XXX_DiscardUnknown() {
	xxx_messageInfo_DataStats.DiscardUnknown(m)
}

var xxx_messageInfo_DataStats proto.InternalMessageInfo

type isDataStats_Stats interface {
	isDataStats_Stats()
}

type DataStats_Float64Stats struct {
	Float64Stats *Float64Stats `protobuf:"bytes,3,opt,name=float64_stats,json=float64Stats,proto3,oneof"`
}

type DataStats_StringStats struct {
	StringStats *StringStats `protobuf:"bytes,4,opt,name=string_stats,json=stringStats,proto3,oneof"`
}

type DataStats_TimestampStats struct {
	TimestampStats *TimestampStats `protobuf:"bytes,5,opt,name=timestamp_stats,json=timestampStats,proto3,oneof"`
}

type DataStats_ArrayStats struct {
	ArrayStats *ArrayStats `protobuf:"bytes,6,opt,name=array_stats,json=arrayStats,proto3,oneof"`
}

type DataStats_StructStats struct {
	StructStats *StructStats `protobuf:"bytes,7,opt,name=struct_stats,json=structStats,proto3,oneof"`
}

type DataStats_CategoryStats struct {
	CategoryStats *CategoryStats `protobuf:"bytes,8,opt,name=category_stats,json=categoryStats,proto3,oneof"`
}

func (*DataStats_Float64Stats) isDataStats_Stats() {}

func (*DataStats_StringStats) isDataStats_Stats() {}

func (*DataStats_TimestampStats) isDataStats_Stats() {}

func (*DataStats_ArrayStats) isDataStats_Stats() {}

func (*DataStats_StructStats) isDataStats_Stats() {}

func (*DataStats_CategoryStats) isDataStats_Stats() {}

func (m *DataStats) GetStats() isDataStats_Stats {
	if m != nil {
		return m.Stats
	}
	return nil
}

func (m *DataStats) GetFloat64Stats() *Float64Stats {
	if x, ok := m.GetStats().(*DataStats_Float64Stats); ok {
		return x.Float64Stats
	}
	return nil
}

func (m *DataStats) GetStringStats() *StringStats {
	if x, ok := m.GetStats().(*DataStats_StringStats); ok {
		return x.StringStats
	}
	return nil
}

func (m *DataStats) GetTimestampStats() *TimestampStats {
	if x, ok := m.GetStats().(*DataStats_TimestampStats); ok {
		return x.TimestampStats
	}
	return nil
}

func (m *DataStats) GetArrayStats() *ArrayStats {
	if x, ok := m.GetStats().(*DataStats_ArrayStats); ok {
		return x.ArrayStats
	}
	return nil
}

func (m *DataStats) GetStructStats() *StructStats {
	if x, ok := m.GetStats().(*DataStats_StructStats); ok {
		return x.StructStats
	}
	return nil
}

func (m *DataStats) GetCategoryStats() *CategoryStats {
	if x, ok := m.GetStats().(*DataStats_CategoryStats); ok {
		return x.CategoryStats
	}
	return nil
}

func (m *DataStats) GetDistinctValueCount() int64 {
	if m != nil {
		return m.DistinctValueCount
	}
	return 0
}

func (m *DataStats) GetNullValueCount() int64 {
	if m != nil {
		return m.NullValueCount
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DataStats) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DataStats_OneofMarshaler, _DataStats_OneofUnmarshaler, _DataStats_OneofSizer, []interface{}{
		(*DataStats_Float64Stats)(nil),
		(*DataStats_StringStats)(nil),
		(*DataStats_TimestampStats)(nil),
		(*DataStats_ArrayStats)(nil),
		(*DataStats_StructStats)(nil),
		(*DataStats_CategoryStats)(nil),
	}
}

func _DataStats_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DataStats)
	// stats
	switch x := m.Stats.(type) {
	case *DataStats_Float64Stats:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Float64Stats); err != nil {
			return err
		}
	case *DataStats_StringStats:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StringStats); err != nil {
			return err
		}
	case *DataStats_TimestampStats:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimestampStats); err != nil {
			return err
		}
	case *DataStats_ArrayStats:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ArrayStats); err != nil {
			return err
		}
	case *DataStats_StructStats:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StructStats); err != nil {
			return err
		}
	case *DataStats_CategoryStats:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CategoryStats); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("DataStats.Stats has unexpected type %T", x)
	}
	return nil
}

func _DataStats_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DataStats)
	switch tag {
	case 3: // stats.float64_stats
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Float64Stats)
		err := b.DecodeMessage(msg)
		m.Stats = &DataStats_Float64Stats{msg}
		return true, err
	case 4: // stats.string_stats
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StringStats)
		err := b.DecodeMessage(msg)
		m.Stats = &DataStats_StringStats{msg}
		return true, err
	case 5: // stats.timestamp_stats
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TimestampStats)
		err := b.DecodeMessage(msg)
		m.Stats = &DataStats_TimestampStats{msg}
		return true, err
	case 6: // stats.array_stats
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ArrayStats)
		err := b.DecodeMessage(msg)
		m.Stats = &DataStats_ArrayStats{msg}
		return true, err
	case 7: // stats.struct_stats
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StructStats)
		err := b.DecodeMessage(msg)
		m.Stats = &DataStats_StructStats{msg}
		return true, err
	case 8: // stats.category_stats
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CategoryStats)
		err := b.DecodeMessage(msg)
		m.Stats = &DataStats_CategoryStats{msg}
		return true, err
	default:
		return false, nil
	}
}

func _DataStats_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DataStats)
	// stats
	switch x := m.Stats.(type) {
	case *DataStats_Float64Stats:
		s := proto.Size(x.Float64Stats)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *DataStats_StringStats:
		s := proto.Size(x.StringStats)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *DataStats_TimestampStats:
		s := proto.Size(x.TimestampStats)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *DataStats_ArrayStats:
		s := proto.Size(x.ArrayStats)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *DataStats_StructStats:
		s := proto.Size(x.StructStats)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *DataStats_CategoryStats:
		s := proto.Size(x.CategoryStats)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The data statistics of a series of FLOAT64 values.
type Float64Stats struct {
	// The mean of the series.
	Mean float64 `protobuf:"fixed64,1,opt,name=mean,proto3" json:"mean,omitempty"`
	// The standard deviation of the series.
	StandardDeviation float64 `protobuf:"fixed64,2,opt,name=standard_deviation,json=standardDeviation,proto3" json:"standard_deviation,omitempty"`
	// Ordered from 0 to k k-quantile values of the data series of n values.
	// The value at index i is, approximately, the i*n/k-th smallest value in the
	// series; for i = 0 and i = k these are, respectively, the min and max
	// values.
	Quantiles []float64 `protobuf:"fixed64,3,rep,packed,name=quantiles,proto3" json:"quantiles,omitempty"`
	// Histogram buckets of the data series. Sorted by the min value of the
	// bucket, ascendingly, and the number of the buckets is dynamically
	// generated. The buckets are non-overlapping and completely cover whole
	// FLOAT64 range with min of first bucket being `"-Infinity"`, and max of
	// the last one being `"Infinity"`.
	HistogramBuckets     []*Float64Stats_HistogramBucket `protobuf:"bytes,4,rep,name=histogram_buckets,json=histogramBuckets,proto3" json:"histogram_buckets,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *Float64Stats) Reset()         { *m = Float64Stats{} }
func (m *Float64Stats) String() string { return proto.CompactTextString(m) }
func (*Float64Stats) ProtoMessage()    {}
func (*Float64Stats) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_stats_e2571ab261ca3ffb, []int{1}
}
func (m *Float64Stats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Float64Stats.Unmarshal(m, b)
}
func (m *Float64Stats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Float64Stats.Marshal(b, m, deterministic)
}
func (dst *Float64Stats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Float64Stats.Merge(dst, src)
}
func (m *Float64Stats) XXX_Size() int {
	return xxx_messageInfo_Float64Stats.Size(m)
}
func (m *Float64Stats) XXX_DiscardUnknown() {
	xxx_messageInfo_Float64Stats.DiscardUnknown(m)
}

var xxx_messageInfo_Float64Stats proto.InternalMessageInfo

func (m *Float64Stats) GetMean() float64 {
	if m != nil {
		return m.Mean
	}
	return 0
}

func (m *Float64Stats) GetStandardDeviation() float64 {
	if m != nil {
		return m.StandardDeviation
	}
	return 0
}

func (m *Float64Stats) GetQuantiles() []float64 {
	if m != nil {
		return m.Quantiles
	}
	return nil
}

func (m *Float64Stats) GetHistogramBuckets() []*Float64Stats_HistogramBucket {
	if m != nil {
		return m.HistogramBuckets
	}
	return nil
}

// A bucket of a histogram.
type Float64Stats_HistogramBucket struct {
	// The minimum value of the bucket, inclusive.
	Min float64 `protobuf:"fixed64,1,opt,name=min,proto3" json:"min,omitempty"`
	// The maximum value of the bucket, exclusive unless max = `"Infinity"`, in
	// which case it's inclusive.
	Max float64 `protobuf:"fixed64,2,opt,name=max,proto3" json:"max,omitempty"`
	// The number of data values that are in the bucket, i.e. are between
	// min and max values.
	Count                int64    `protobuf:"varint,3,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Float64Stats_HistogramBucket) Reset()         { *m = Float64Stats_HistogramBucket{} }
func (m *Float64Stats_HistogramBucket) String() string { return proto.CompactTextString(m) }
func (*Float64Stats_HistogramBucket) ProtoMessage()    {}
func (*Float64Stats_HistogramBucket) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_stats_e2571ab261ca3ffb, []int{1, 0}
}
func (m *Float64Stats_HistogramBucket) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Float64Stats_HistogramBucket.Unmarshal(m, b)
}
func (m *Float64Stats_HistogramBucket) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Float64Stats_HistogramBucket.Marshal(b, m, deterministic)
}
func (dst *Float64Stats_HistogramBucket) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Float64Stats_HistogramBucket.Merge(dst, src)
}
func (m *Float64Stats_HistogramBucket) XXX_Size() int {
	return xxx_messageInfo_Float64Stats_HistogramBucket.Size(m)
}
func (m *Float64Stats_HistogramBucket) XXX_DiscardUnknown() {
	xxx_messageInfo_Float64Stats_HistogramBucket.DiscardUnknown(m)
}

var xxx_messageInfo_Float64Stats_HistogramBucket proto.InternalMessageInfo

func (m *Float64Stats_HistogramBucket) GetMin() float64 {
	if m != nil {
		return m.Min
	}
	return 0
}

func (m *Float64Stats_HistogramBucket) GetMax() float64 {
	if m != nil {
		return m.Max
	}
	return 0
}

func (m *Float64Stats_HistogramBucket) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

// The data statistics of a series of STRING values.
type StringStats struct {
	// The statistics of the top 20 unigrams, ordered by
	// [count][google.cloud.automl.v1beta1.StringStats.UnigramStats.count].
	TopUnigramStats      []*StringStats_UnigramStats `protobuf:"bytes,1,rep,name=top_unigram_stats,json=topUnigramStats,proto3" json:"top_unigram_stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *StringStats) Reset()         { *m = StringStats{} }
func (m *StringStats) String() string { return proto.CompactTextString(m) }
func (*StringStats) ProtoMessage()    {}
func (*StringStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_stats_e2571ab261ca3ffb, []int{2}
}
func (m *StringStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StringStats.Unmarshal(m, b)
}
func (m *StringStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StringStats.Marshal(b, m, deterministic)
}
func (dst *StringStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringStats.Merge(dst, src)
}
func (m *StringStats) XXX_Size() int {
	return xxx_messageInfo_StringStats.Size(m)
}
func (m *StringStats) XXX_DiscardUnknown() {
	xxx_messageInfo_StringStats.DiscardUnknown(m)
}

var xxx_messageInfo_StringStats proto.InternalMessageInfo

func (m *StringStats) GetTopUnigramStats() []*StringStats_UnigramStats {
	if m != nil {
		return m.TopUnigramStats
	}
	return nil
}

// The statistics of a unigram.
type StringStats_UnigramStats struct {
	// The unigram.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// The number of occurrences of this unigram in the series.
	Count                int64    `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StringStats_UnigramStats) Reset()         { *m = StringStats_UnigramStats{} }
func (m *StringStats_UnigramStats) String() string { return proto.CompactTextString(m) }
func (*StringStats_UnigramStats) ProtoMessage()    {}
func (*StringStats_UnigramStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_stats_e2571ab261ca3ffb, []int{2, 0}
}
func (m *StringStats_UnigramStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StringStats_UnigramStats.Unmarshal(m, b)
}
func (m *StringStats_UnigramStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StringStats_UnigramStats.Marshal(b, m, deterministic)
}
func (dst *StringStats_UnigramStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringStats_UnigramStats.Merge(dst, src)
}
func (m *StringStats_UnigramStats) XXX_Size() int {
	return xxx_messageInfo_StringStats_UnigramStats.Size(m)
}
func (m *StringStats_UnigramStats) XXX_DiscardUnknown() {
	xxx_messageInfo_StringStats_UnigramStats.DiscardUnknown(m)
}

var xxx_messageInfo_StringStats_UnigramStats proto.InternalMessageInfo

func (m *StringStats_UnigramStats) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *StringStats_UnigramStats) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

// The data statistics of a series of TIMESTAMP values.
type TimestampStats struct {
	// The string key is the pre-defined granularity. Currently supported:
	// hour_of_day, day_of_week, month_of_year.
	// Granularities finer that the granularity of timestamp data are not
	// populated (e.g. if timestamps are at day granularity, then hour_of_day
	// is not populated).
	GranularStats        map[string]*TimestampStats_GranularStats `protobuf:"bytes,1,rep,name=granular_stats,json=granularStats,proto3" json:"granular_stats,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                                 `json:"-"`
	XXX_unrecognized     []byte                                   `json:"-"`
	XXX_sizecache        int32                                    `json:"-"`
}

func (m *TimestampStats) Reset()         { *m = TimestampStats{} }
func (m *TimestampStats) String() string { return proto.CompactTextString(m) }
func (*TimestampStats) ProtoMessage()    {}
func (*TimestampStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_stats_e2571ab261ca3ffb, []int{3}
}
func (m *TimestampStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimestampStats.Unmarshal(m, b)
}
func (m *TimestampStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimestampStats.Marshal(b, m, deterministic)
}
func (dst *TimestampStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimestampStats.Merge(dst, src)
}
func (m *TimestampStats) XXX_Size() int {
	return xxx_messageInfo_TimestampStats.Size(m)
}
func (m *TimestampStats) XXX_DiscardUnknown() {
	xxx_messageInfo_TimestampStats.DiscardUnknown(m)
}

var xxx_messageInfo_TimestampStats proto.InternalMessageInfo

func (m *TimestampStats) GetGranularStats() map[string]*TimestampStats_GranularStats {
	if m != nil {
		return m.GranularStats
	}
	return nil
}

// Stats split by a defined in context granularity.
type TimestampStats_GranularStats struct {
	// A map from granularity key to example count for that key.
	// E.g. for hour_of_day `13` means 1pm, or for month_of_year `5` means May).
	Buckets              map[int32]int64 `protobuf:"bytes,1,rep,name=buckets,proto3" json:"buckets,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *TimestampStats_GranularStats) Reset()         { *m = TimestampStats_GranularStats{} }
func (m *TimestampStats_GranularStats) String() string { return proto.CompactTextString(m) }
func (*TimestampStats_GranularStats) ProtoMessage()    {}
func (*TimestampStats_GranularStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_stats_e2571ab261ca3ffb, []int{3, 0}
}
func (m *TimestampStats_GranularStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimestampStats_GranularStats.Unmarshal(m, b)
}
func (m *TimestampStats_GranularStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimestampStats_GranularStats.Marshal(b, m, deterministic)
}
func (dst *TimestampStats_GranularStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimestampStats_GranularStats.Merge(dst, src)
}
func (m *TimestampStats_GranularStats) XXX_Size() int {
	return xxx_messageInfo_TimestampStats_GranularStats.Size(m)
}
func (m *TimestampStats_GranularStats) XXX_DiscardUnknown() {
	xxx_messageInfo_TimestampStats_GranularStats.DiscardUnknown(m)
}

var xxx_messageInfo_TimestampStats_GranularStats proto.InternalMessageInfo

func (m *TimestampStats_GranularStats) GetBuckets() map[int32]int64 {
	if m != nil {
		return m.Buckets
	}
	return nil
}

// The data statistics of a series of ARRAY values.
type ArrayStats struct {
	// Stats of all the values of all arrays, as if they were a single long
	// series of data. The type depends on the element type of the array.
	MemberStats          *DataStats `protobuf:"bytes,2,opt,name=member_stats,json=memberStats,proto3" json:"member_stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ArrayStats) Reset()         { *m = ArrayStats{} }
func (m *ArrayStats) String() string { return proto.CompactTextString(m) }
func (*ArrayStats) ProtoMessage()    {}
func (*ArrayStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_stats_e2571ab261ca3ffb, []int{4}
}
func (m *ArrayStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ArrayStats.Unmarshal(m, b)
}
func (m *ArrayStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ArrayStats.Marshal(b, m, deterministic)
}
func (dst *ArrayStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ArrayStats.Merge(dst, src)
}
func (m *ArrayStats) XXX_Size() int {
	return xxx_messageInfo_ArrayStats.Size(m)
}
func (m *ArrayStats) XXX_DiscardUnknown() {
	xxx_messageInfo_ArrayStats.DiscardUnknown(m)
}

var xxx_messageInfo_ArrayStats proto.InternalMessageInfo

func (m *ArrayStats) GetMemberStats() *DataStats {
	if m != nil {
		return m.MemberStats
	}
	return nil
}

// The data statistics of a series of STRUCT values.
type StructStats struct {
	// Map from a field name of the struct to data stats aggregated over series
	// of all data in that field across all the structs.
	FieldStats           map[string]*DataStats `protobuf:"bytes,1,rep,name=field_stats,json=fieldStats,proto3" json:"field_stats,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *StructStats) Reset()         { *m = StructStats{} }
func (m *StructStats) String() string { return proto.CompactTextString(m) }
func (*StructStats) ProtoMessage()    {}
func (*StructStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_stats_e2571ab261ca3ffb, []int{5}
}
func (m *StructStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StructStats.Unmarshal(m, b)
}
func (m *StructStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StructStats.Marshal(b, m, deterministic)
}
func (dst *StructStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StructStats.Merge(dst, src)
}
func (m *StructStats) XXX_Size() int {
	return xxx_messageInfo_StructStats.Size(m)
}
func (m *StructStats) XXX_DiscardUnknown() {
	xxx_messageInfo_StructStats.DiscardUnknown(m)
}

var xxx_messageInfo_StructStats proto.InternalMessageInfo

func (m *StructStats) GetFieldStats() map[string]*DataStats {
	if m != nil {
		return m.FieldStats
	}
	return nil
}

// The data statistics of a series of CATEGORY values.
type CategoryStats struct {
	// The statistics of the top 20 CATEGORY values, ordered by
	//
	// [count][google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats.count].
	TopCategoryStats     []*CategoryStats_SingleCategoryStats `protobuf:"bytes,1,rep,name=top_category_stats,json=topCategoryStats,proto3" json:"top_category_stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *CategoryStats) Reset()         { *m = CategoryStats{} }
func (m *CategoryStats) String() string { return proto.CompactTextString(m) }
func (*CategoryStats) ProtoMessage()    {}
func (*CategoryStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_stats_e2571ab261ca3ffb, []int{6}
}
func (m *CategoryStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CategoryStats.Unmarshal(m, b)
}
func (m *CategoryStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CategoryStats.Marshal(b, m, deterministic)
}
func (dst *CategoryStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CategoryStats.Merge(dst, src)
}
func (m *CategoryStats) XXX_Size() int {
	return xxx_messageInfo_CategoryStats.Size(m)
}
func (m *CategoryStats) XXX_DiscardUnknown() {
	xxx_messageInfo_CategoryStats.DiscardUnknown(m)
}

var xxx_messageInfo_CategoryStats proto.InternalMessageInfo

func (m *CategoryStats) GetTopCategoryStats() []*CategoryStats_SingleCategoryStats {
	if m != nil {
		return m.TopCategoryStats
	}
	return nil
}

// The statistics of a single CATEGORY value.
type CategoryStats_SingleCategoryStats struct {
	// The CATEGORY value.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// The number of occurrences of this value in the series.
	Count                int64    `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CategoryStats_SingleCategoryStats) Reset()         { *m = CategoryStats_SingleCategoryStats{} }
func (m *CategoryStats_SingleCategoryStats) String() string { return proto.CompactTextString(m) }
func (*CategoryStats_SingleCategoryStats) ProtoMessage()    {}
func (*CategoryStats_SingleCategoryStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_stats_e2571ab261ca3ffb, []int{6, 0}
}
func (m *CategoryStats_SingleCategoryStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CategoryStats_SingleCategoryStats.Unmarshal(m, b)
}
func (m *CategoryStats_SingleCategoryStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CategoryStats_SingleCategoryStats.Marshal(b, m, deterministic)
}
func (dst *CategoryStats_SingleCategoryStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CategoryStats_SingleCategoryStats.Merge(dst, src)
}
func (m *CategoryStats_SingleCategoryStats) XXX_Size() int {
	return xxx_messageInfo_CategoryStats_SingleCategoryStats.Size(m)
}
func (m *CategoryStats_SingleCategoryStats) XXX_DiscardUnknown() {
	xxx_messageInfo_CategoryStats_SingleCategoryStats.DiscardUnknown(m)
}

var xxx_messageInfo_CategoryStats_SingleCategoryStats proto.InternalMessageInfo

func (m *CategoryStats_SingleCategoryStats) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *CategoryStats_SingleCategoryStats) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

// A correlation statistics between two series of DataType values. The series
// may have differing DataType-s, but within a single series the DataType must
// be the same.
type CorrelationStats struct {
	// The correlation value using the Cramer's V measure.
	CramersV             float64  `protobuf:"fixed64,1,opt,name=cramers_v,json=cramersV,proto3" json:"cramers_v,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CorrelationStats) Reset()         { *m = CorrelationStats{} }
func (m *CorrelationStats) String() string { return proto.CompactTextString(m) }
func (*CorrelationStats) ProtoMessage()    {}
func (*CorrelationStats) Descriptor() ([]byte, []int) {
	return fileDescriptor_data_stats_e2571ab261ca3ffb, []int{7}
}
func (m *CorrelationStats) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CorrelationStats.Unmarshal(m, b)
}
func (m *CorrelationStats) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CorrelationStats.Marshal(b, m, deterministic)
}
func (dst *CorrelationStats) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CorrelationStats.Merge(dst, src)
}
func (m *CorrelationStats) XXX_Size() int {
	return xxx_messageInfo_CorrelationStats.Size(m)
}
func (m *CorrelationStats) XXX_DiscardUnknown() {
	xxx_messageInfo_CorrelationStats.DiscardUnknown(m)
}

var xxx_messageInfo_CorrelationStats proto.InternalMessageInfo

func (m *CorrelationStats) GetCramersV() float64 {
	if m != nil {
		return m.CramersV
	}
	return 0
}

func init() {
	proto.RegisterType((*DataStats)(nil), "google.cloud.automl.v1beta1.DataStats")
	proto.RegisterType((*Float64Stats)(nil), "google.cloud.automl.v1beta1.Float64Stats")
	proto.RegisterType((*Float64Stats_HistogramBucket)(nil), "google.cloud.automl.v1beta1.Float64Stats.HistogramBucket")
	proto.RegisterType((*StringStats)(nil), "google.cloud.automl.v1beta1.StringStats")
	proto.RegisterType((*StringStats_UnigramStats)(nil), "google.cloud.automl.v1beta1.StringStats.UnigramStats")
	proto.RegisterType((*TimestampStats)(nil), "google.cloud.automl.v1beta1.TimestampStats")
	proto.RegisterMapType((map[string]*TimestampStats_GranularStats)(nil), "google.cloud.automl.v1beta1.TimestampStats.GranularStatsEntry")
	proto.RegisterType((*TimestampStats_GranularStats)(nil), "google.cloud.automl.v1beta1.TimestampStats.GranularStats")
	proto.RegisterMapType((map[int32]int64)(nil), "google.cloud.automl.v1beta1.TimestampStats.GranularStats.BucketsEntry")
	proto.RegisterType((*ArrayStats)(nil), "google.cloud.automl.v1beta1.ArrayStats")
	proto.RegisterType((*StructStats)(nil), "google.cloud.automl.v1beta1.StructStats")
	proto.RegisterMapType((map[string]*DataStats)(nil), "google.cloud.automl.v1beta1.StructStats.FieldStatsEntry")
	proto.RegisterType((*CategoryStats)(nil), "google.cloud.automl.v1beta1.CategoryStats")
	proto.RegisterType((*CategoryStats_SingleCategoryStats)(nil), "google.cloud.automl.v1beta1.CategoryStats.SingleCategoryStats")
	proto.RegisterType((*CorrelationStats)(nil), "google.cloud.automl.v1beta1.CorrelationStats")
}

func init() {
	proto.RegisterFile("google/cloud/automl/v1beta1/data_stats.proto", fileDescriptor_data_stats_e2571ab261ca3ffb)
}

var fileDescriptor_data_stats_e2571ab261ca3ffb = []byte{
	// 830 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x96, 0xcb, 0x6f, 0xd3, 0x48,
	0x18, 0xc0, 0xd7, 0x49, 0xd3, 0x36, 0x5f, 0x9e, 0x9d, 0xed, 0xa1, 0x4a, 0x2b, 0x6d, 0x95, 0xc3,
	0x6e, 0xf6, 0x65, 0x6f, 0xbb, 0x80, 0x4a, 0x41, 0x48, 0x69, 0x4a, 0x5b, 0x40, 0x15, 0x95, 0x03,
	0x41, 0xa0, 0x4a, 0x61, 0xe2, 0x4c, 0x5c, 0xab, 0xf6, 0x4c, 0xb0, 0xc7, 0x11, 0x15, 0x57, 0xfe,
	0x94, 0x1e, 0xe1, 0x7f, 0xe0, 0xcc, 0x85, 0x33, 0xff, 0x0d, 0xf2, 0xcc, 0x38, 0xb1, 0x4b, 0x65,
	0x52, 0x6e, 0xfe, 0x5e, 0xbf, 0x6f, 0xbe, 0xc7, 0x4c, 0x02, 0xff, 0xd8, 0x8c, 0xd9, 0x2e, 0x31,
	0x2c, 0x97, 0x85, 0x43, 0x03, 0x87, 0x9c, 0x79, 0xae, 0x31, 0xd9, 0x1a, 0x10, 0x8e, 0xb7, 0x8c,
	0x21, 0xe6, 0xb8, 0x1f, 0x70, 0xcc, 0x03, 0x7d, 0xec, 0x33, 0xce, 0xd0, 0xba, 0xf4, 0xd6, 0x85,
	0xb7, 0x2e, 0xbd, 0x75, 0xe5, 0xdd, 0xd8, 0x50, 0x28, 0x3c, 0x76, 0x0c, 0x4c, 0x29, 0xe3, 0x98,
	0x3b, 0x8c, 0xaa, 0xd0, 0xe6, 0xd7, 0x05, 0x28, 0xee, 0x63, 0x8e, 0xbb, 0x11, 0x0e, 0x9d, 0x40,
	0x65, 0xe4, 0x32, 0xcc, 0xef, 0xdc, 0x92, 0xfc, 0xb5, 0xfc, 0xa6, 0xd6, 0x2a, 0x6d, 0xff, 0xa9,
	0x67, 0x24, 0xd0, 0x0f, 0x64, 0x84, 0x20, 0x1c, 0xfd, 0x62, 0x96, 0x47, 0x09, 0x19, 0x1d, 0x43,
	0x39, 0xe0, 0xbe, 0x43, 0x6d, 0x05, 0x5c, 0x10, 0xc0, 0x56, 0x26, 0xb0, 0x2b, 0x02, 0x62, 0x5e,
	0x29, 0x98, 0x89, 0xa8, 0x07, 0x35, 0xee, 0x78, 0x24, 0xe0, 0xd8, 0x1b, 0x2b, 0x62, 0x41, 0x10,
	0xff, 0xce, 0x24, 0x3e, 0x8b, 0x63, 0x62, 0x68, 0x95, 0xa7, 0x34, 0xe8, 0x31, 0x94, 0xb0, 0xef,
	0xe3, 0x0b, 0xc5, 0x5c, 0x14, 0xcc, 0x3f, 0x32, 0x99, 0xed, 0xc8, 0x3f, 0xe6, 0x01, 0x9e, 0x4a,
	0xaa, 0xe4, 0xd0, 0xe2, 0x0a, 0xb6, 0x34, 0x5f, 0xc9, 0xa1, 0xc5, 0x93, 0x25, 0xc7, 0x22, 0xea,
	0x42, 0xd5, 0xc2, 0x9c, 0xd8, 0xcc, 0x8f, 0x4f, 0xb7, 0x2c, 0x80, 0x7f, 0x65, 0x02, 0x3b, 0x2a,
	0x24, 0x46, 0x56, 0xac, 0xa4, 0x02, 0xfd, 0x07, 0xab, 0x43, 0x27, 0xe0, 0x0e, 0xb5, 0x78, 0x7f,
	0x82, 0xdd, 0x90, 0xf4, 0x2d, 0x16, 0x52, 0xbe, 0xa6, 0x6d, 0x6a, 0xad, 0xbc, 0x89, 0x62, 0x5b,
	0x2f, 0x32, 0x75, 0x22, 0x0b, 0x6a, 0x41, 0x9d, 0x86, 0xae, 0x9b, 0xf2, 0xce, 0x09, 0xef, 0x6a,
	0xa4, 0x9f, 0x79, 0xee, 0x2d, 0x41, 0x41, 0x9c, 0xb3, 0x79, 0x99, 0x83, 0x72, 0x72, 0x39, 0x10,
	0x82, 0x05, 0x8f, 0x60, 0x2a, 0xb2, 0x68, 0xa6, 0xf8, 0x46, 0xff, 0x02, 0x0a, 0x38, 0xa6, 0x43,
	0xec, 0x0f, 0xfb, 0x43, 0x32, 0x71, 0xc4, 0x76, 0x0a, 0xb2, 0x66, 0xae, 0xc4, 0x96, 0xfd, 0xd8,
	0x80, 0x36, 0xa0, 0xf8, 0x26, 0xc4, 0x94, 0x3b, 0x2e, 0x89, 0xb6, 0x33, 0xdf, 0xd2, 0xcc, 0x99,
	0x02, 0x8d, 0x60, 0xe5, 0xcc, 0x09, 0x38, 0xb3, 0x7d, 0xec, 0xf5, 0x07, 0xa1, 0x75, 0x4e, 0xc4,
	0xca, 0xe5, 0x5b, 0xa5, 0xed, 0xbb, 0x73, 0xef, 0xb0, 0x7e, 0x14, 0x23, 0xf6, 0x04, 0xc1, 0xac,
	0x9f, 0xa5, 0x15, 0x41, 0xe3, 0x09, 0xd4, 0xae, 0x38, 0xa1, 0x3a, 0xe4, 0x3d, 0x27, 0x2e, 0x2d,
	0xfa, 0x14, 0x1a, 0xfc, 0x56, 0x95, 0x12, 0x7d, 0xa2, 0x55, 0x28, 0xc8, 0xc6, 0xe5, 0x45, 0xe3,
	0xa4, 0xd0, 0xfc, 0xa0, 0x41, 0x29, 0xb1, 0xf2, 0x08, 0xc3, 0x0a, 0x67, 0xe3, 0x7e, 0x48, 0x1d,
	0x51, 0x86, 0x9c, 0xb9, 0x26, 0x8a, 0xb8, 0x3d, 0xef, 0xbd, 0xd1, 0x9f, 0xcb, 0x68, 0x21, 0x98,
	0x35, 0xce, 0xc6, 0x49, 0x45, 0x63, 0x17, 0xca, 0x49, 0x39, 0x3a, 0x98, 0x98, 0xab, 0x38, 0x7e,
	0xd1, 0x94, 0xc2, 0xec, 0xb8, 0xb9, 0xe4, 0x71, 0x2f, 0xf3, 0x50, 0x4d, 0xdf, 0x27, 0x44, 0xa0,
	0x6a, 0xfb, 0x98, 0x86, 0x2e, 0xf6, 0x53, 0xc7, 0x7d, 0x70, 0x83, 0x4b, 0xa9, 0x1f, 0x2a, 0x82,
	0x90, 0x1e, 0x52, 0xee, 0x5f, 0x98, 0x15, 0x3b, 0xa9, 0x6b, 0x7c, 0xd4, 0xa0, 0x92, 0xf2, 0x42,
	0xaf, 0x61, 0x29, 0x9e, 0xb2, 0xcc, 0x78, 0xf0, 0xd3, 0x19, 0x75, 0x35, 0x5b, 0x99, 0x39, 0xc6,
	0x46, 0x9d, 0x4a, 0x1a, 0xa2, 0xa1, 0x9e, 0x93, 0x0b, 0xd1, 0xa7, 0x82, 0x19, 0x7d, 0xce, 0x7a,
	0xa7, 0xba, 0x24, 0x84, 0xdd, 0xdc, 0x8e, 0xd6, 0x78, 0x07, 0xe8, 0xfb, 0xa2, 0x92, 0x84, 0xa2,
	0x24, 0x3c, 0x4d, 0x12, 0x7e, 0xb4, 0xa9, 0x59, 0x35, 0x24, 0x92, 0x37, 0x5f, 0x00, 0xcc, 0x5e,
	0x28, 0xf4, 0x08, 0xca, 0x1e, 0xf1, 0x06, 0x24, 0x9e, 0x8f, 0xcc, 0xf4, 0x7b, 0x66, 0xa6, 0xe9,
	0xcf, 0x82, 0x59, 0x92, 0xb1, 0x42, 0x68, 0x7e, 0x91, 0xeb, 0x3a, 0x7d, 0x9f, 0x5e, 0x42, 0x69,
	0xe4, 0x10, 0x77, 0x98, 0x9a, 0xfc, 0xce, 0xbc, 0xaf, 0x9d, 0x7e, 0x10, 0xc5, 0x26, 0x66, 0x0e,
	0xa3, 0xa9, 0xa2, 0x41, 0xa0, 0x76, 0xc5, 0x7c, 0x4d, 0xf7, 0xee, 0xa7, 0xbb, 0x37, 0x6f, 0x4d,
	0x89, 0x56, 0x7d, 0xd2, 0xa0, 0x92, 0x7a, 0x2f, 0x91, 0x0b, 0x28, 0xba, 0x82, 0x57, 0xde, 0xdd,
	0x79, 0x96, 0x3a, 0xc5, 0xd1, 0xbb, 0x0e, 0xb5, 0x5d, 0x92, 0xd2, 0x99, 0x75, 0xce, 0xc6, 0x29,
	0x4d, 0xa3, 0x0d, 0xbf, 0x5e, 0xe3, 0x78, 0xa3, 0x4b, 0x69, 0x40, 0xbd, 0xc3, 0x7c, 0x9f, 0xb8,
	0xe2, 0x95, 0x94, 0xf1, 0xeb, 0x50, 0xb4, 0x7c, 0xec, 0x11, 0x3f, 0xe8, 0x4f, 0xd4, 0xbb, 0xb4,
	0xac, 0x14, 0xbd, 0xbd, 0xf7, 0x1a, 0xfc, 0x66, 0x31, 0x2f, 0xab, 0x96, 0x13, 0xed, 0x55, 0x5b,
	0x99, 0x6d, 0xe6, 0x62, 0x6a, 0xeb, 0xcc, 0xb7, 0x0d, 0x9b, 0x50, 0xf1, 0xcf, 0xc1, 0x90, 0x26,
	0x3c, 0x76, 0x82, 0x6b, 0xff, 0xa5, 0xdc, 0x93, 0xe2, 0xe7, 0xdc, 0xfa, 0xa1, 0x70, 0x3c, 0xed,
	0x44, 0x4e, 0xa7, 0xed, 0x90, 0xb3, 0x63, 0xf7, 0xb4, 0x27, 0x9d, 0x06, 0x8b, 0x82, 0xf5, 0xff,
	0xb7, 0x00, 0x00, 0x00, 0xff, 0xff, 0x52, 0xf8, 0x53, 0x15, 0xf0, 0x08, 0x00, 0x00,
}
