// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAcceptQualificationRequest = "AcceptQualificationRequest"

// AcceptQualificationRequestRequest generates a "aws/request.Request" representing the
// client's request for the AcceptQualificationRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptQualificationRequest for more information on using the AcceptQualificationRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptQualificationRequestRequest method.
//    req, resp := client.AcceptQualificationRequestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/AcceptQualificationRequest
func (c *MTurk) AcceptQualificationRequestRequest(input *AcceptQualificationRequestInput) (req *request.Request, output *AcceptQualificationRequestOutput) {
	op := &request.Operation{
		Name:       opAcceptQualificationRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptQualificationRequestInput{}
	}

	output = &AcceptQualificationRequestOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AcceptQualificationRequest API operation for Amazon Mechanical Turk.
//
// The AcceptQualificationRequest operation approves a Worker's request for
// a Qualification.
//
// Only the owner of the Qualification type can grant a Qualification request
// for that type.
//
// A successful request for the AcceptQualificationRequest operation returns
// with no errors and an empty body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation AcceptQualificationRequest for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/AcceptQualificationRequest
func (c *MTurk) AcceptQualificationRequest(input *AcceptQualificationRequestInput) (*AcceptQualificationRequestOutput, error) {
	req, out := c.AcceptQualificationRequestRequest(input)
	return out, req.Send()
}

// AcceptQualificationRequestWithContext is the same as AcceptQualificationRequest with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptQualificationRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) AcceptQualificationRequestWithContext(ctx aws.Context, input *AcceptQualificationRequestInput, opts ...request.Option) (*AcceptQualificationRequestOutput, error) {
	req, out := c.AcceptQualificationRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opApproveAssignment = "ApproveAssignment"

// ApproveAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the ApproveAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ApproveAssignment for more information on using the ApproveAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ApproveAssignmentRequest method.
//    req, resp := client.ApproveAssignmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ApproveAssignment
func (c *MTurk) ApproveAssignmentRequest(input *ApproveAssignmentInput) (req *request.Request, output *ApproveAssignmentOutput) {
	op := &request.Operation{
		Name:       opApproveAssignment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApproveAssignmentInput{}
	}

	output = &ApproveAssignmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ApproveAssignment API operation for Amazon Mechanical Turk.
//
// The ApproveAssignment operation approves the results of a completed assignment.
//
// Approving an assignment initiates two payments from the Requester's Amazon.com
// account
//
//    * The Worker who submitted the results is paid the reward specified in
//    the HIT.
//
//    * Amazon Mechanical Turk fees are debited.
//
// If the Requester's account does not have adequate funds for these payments,
// the call to ApproveAssignment returns an exception, and the approval is not
// processed. You can include an optional feedback message with the approval,
// which the Worker can see in the Status section of the web site.
//
// You can also call this operation for assignments that were previous rejected
// and approve them by explicitly overriding the previous rejection. This only
// works on rejected assignments that were submitted within the previous 30
// days and only if the assignment's related HIT has not been deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation ApproveAssignment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ApproveAssignment
func (c *MTurk) ApproveAssignment(input *ApproveAssignmentInput) (*ApproveAssignmentOutput, error) {
	req, out := c.ApproveAssignmentRequest(input)
	return out, req.Send()
}

// ApproveAssignmentWithContext is the same as ApproveAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See ApproveAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ApproveAssignmentWithContext(ctx aws.Context, input *ApproveAssignmentInput, opts ...request.Option) (*ApproveAssignmentOutput, error) {
	req, out := c.ApproveAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateQualificationWithWorker = "AssociateQualificationWithWorker"

// AssociateQualificationWithWorkerRequest generates a "aws/request.Request" representing the
// client's request for the AssociateQualificationWithWorker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateQualificationWithWorker for more information on using the AssociateQualificationWithWorker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateQualificationWithWorkerRequest method.
//    req, resp := client.AssociateQualificationWithWorkerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/AssociateQualificationWithWorker
func (c *MTurk) AssociateQualificationWithWorkerRequest(input *AssociateQualificationWithWorkerInput) (req *request.Request, output *AssociateQualificationWithWorkerOutput) {
	op := &request.Operation{
		Name:       opAssociateQualificationWithWorker,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateQualificationWithWorkerInput{}
	}

	output = &AssociateQualificationWithWorkerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateQualificationWithWorker API operation for Amazon Mechanical Turk.
//
// The AssociateQualificationWithWorker operation gives a Worker a Qualification.
// AssociateQualificationWithWorker does not require that the Worker submit
// a Qualification request. It gives the Qualification directly to the Worker.
//
// You can only assign a Qualification of a Qualification type that you created
// (using the CreateQualificationType operation).
//
// Note: AssociateQualificationWithWorker does not affect any pending Qualification
// requests for the Qualification by the Worker. If you assign a Qualification
// to a Worker, then later grant a Qualification request made by the Worker,
// the granting of the request may modify the Qualification score. To resolve
// a pending Qualification request without affecting the Qualification the Worker
// already has, reject the request with the RejectQualificationRequest operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation AssociateQualificationWithWorker for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/AssociateQualificationWithWorker
func (c *MTurk) AssociateQualificationWithWorker(input *AssociateQualificationWithWorkerInput) (*AssociateQualificationWithWorkerOutput, error) {
	req, out := c.AssociateQualificationWithWorkerRequest(input)
	return out, req.Send()
}

// AssociateQualificationWithWorkerWithContext is the same as AssociateQualificationWithWorker with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateQualificationWithWorker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) AssociateQualificationWithWorkerWithContext(ctx aws.Context, input *AssociateQualificationWithWorkerInput, opts ...request.Option) (*AssociateQualificationWithWorkerOutput, error) {
	req, out := c.AssociateQualificationWithWorkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAdditionalAssignmentsForHIT = "CreateAdditionalAssignmentsForHIT"

// CreateAdditionalAssignmentsForHITRequest generates a "aws/request.Request" representing the
// client's request for the CreateAdditionalAssignmentsForHIT operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAdditionalAssignmentsForHIT for more information on using the CreateAdditionalAssignmentsForHIT
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAdditionalAssignmentsForHITRequest method.
//    req, resp := client.CreateAdditionalAssignmentsForHITRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateAdditionalAssignmentsForHIT
func (c *MTurk) CreateAdditionalAssignmentsForHITRequest(input *CreateAdditionalAssignmentsForHITInput) (req *request.Request, output *CreateAdditionalAssignmentsForHITOutput) {
	op := &request.Operation{
		Name:       opCreateAdditionalAssignmentsForHIT,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAdditionalAssignmentsForHITInput{}
	}

	output = &CreateAdditionalAssignmentsForHITOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateAdditionalAssignmentsForHIT API operation for Amazon Mechanical Turk.
//
// The CreateAdditionalAssignmentsForHIT operation increases the maximum number
// of assignments of an existing HIT.
//
// To extend the maximum number of assignments, specify the number of additional
// assignments.
//
//    * HITs created with fewer than 10 assignments cannot be extended to have
//    10 or more assignments. Attempting to add assignments in a way that brings
//    the total number of assignments for a HIT from fewer than 10 assignments
//    to 10 or more assignments will result in an AWS.MechanicalTurk.InvalidMaximumAssignmentsIncrease
//    exception.
//
//    * HITs that were created before July 22, 2015 cannot be extended. Attempting
//    to extend HITs that were created before July 22, 2015 will result in an
//    AWS.MechanicalTurk.HITTooOldForExtension exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation CreateAdditionalAssignmentsForHIT for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateAdditionalAssignmentsForHIT
func (c *MTurk) CreateAdditionalAssignmentsForHIT(input *CreateAdditionalAssignmentsForHITInput) (*CreateAdditionalAssignmentsForHITOutput, error) {
	req, out := c.CreateAdditionalAssignmentsForHITRequest(input)
	return out, req.Send()
}

// CreateAdditionalAssignmentsForHITWithContext is the same as CreateAdditionalAssignmentsForHIT with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAdditionalAssignmentsForHIT for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) CreateAdditionalAssignmentsForHITWithContext(ctx aws.Context, input *CreateAdditionalAssignmentsForHITInput, opts ...request.Option) (*CreateAdditionalAssignmentsForHITOutput, error) {
	req, out := c.CreateAdditionalAssignmentsForHITRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHIT = "CreateHIT"

// CreateHITRequest generates a "aws/request.Request" representing the
// client's request for the CreateHIT operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHIT for more information on using the CreateHIT
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateHITRequest method.
//    req, resp := client.CreateHITRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateHIT
func (c *MTurk) CreateHITRequest(input *CreateHITInput) (req *request.Request, output *CreateHITOutput) {
	op := &request.Operation{
		Name:       opCreateHIT,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHITInput{}
	}

	output = &CreateHITOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHIT API operation for Amazon Mechanical Turk.
//
// The CreateHIT operation creates a new Human Intelligence Task (HIT). The
// new HIT is made available for Workers to find and accept on the Amazon Mechanical
// Turk website.
//
// This operation allows you to specify a new HIT by passing in values for the
// properties of the HIT, such as its title, reward amount and number of assignments.
// When you pass these values to CreateHIT, a new HIT is created for you, with
// a new HITTypeID. The HITTypeID can be used to create additional HITs in the
// future without needing to specify common parameters such as the title, description
// and reward amount each time.
//
// An alternative way to create HITs is to first generate a HITTypeID using
// the CreateHITType operation and then call the CreateHITWithHITType operation.
// This is the recommended best practice for Requesters who are creating large
// numbers of HITs.
//
// CreateHIT also supports several ways to provide question data: by providing
// a value for the Question parameter that fully specifies the contents of the
// HIT, or by providing a HitLayoutId and associated HitLayoutParameters.
//
// If a HIT is created with 10 or more maximum assignments, there is an additional
// fee. For more information, see Amazon Mechanical Turk Pricing (https://requester.mturk.com/pricing).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation CreateHIT for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateHIT
func (c *MTurk) CreateHIT(input *CreateHITInput) (*CreateHITOutput, error) {
	req, out := c.CreateHITRequest(input)
	return out, req.Send()
}

// CreateHITWithContext is the same as CreateHIT with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHIT for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) CreateHITWithContext(ctx aws.Context, input *CreateHITInput, opts ...request.Option) (*CreateHITOutput, error) {
	req, out := c.CreateHITRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHITType = "CreateHITType"

// CreateHITTypeRequest generates a "aws/request.Request" representing the
// client's request for the CreateHITType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHITType for more information on using the CreateHITType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateHITTypeRequest method.
//    req, resp := client.CreateHITTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateHITType
func (c *MTurk) CreateHITTypeRequest(input *CreateHITTypeInput) (req *request.Request, output *CreateHITTypeOutput) {
	op := &request.Operation{
		Name:       opCreateHITType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHITTypeInput{}
	}

	output = &CreateHITTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHITType API operation for Amazon Mechanical Turk.
//
// The CreateHITType operation creates a new HIT type. This operation allows
// you to define a standard set of HIT properties to use when creating HITs.
// If you register a HIT type with values that match an existing HIT type, the
// HIT type ID of the existing type will be returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation CreateHITType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateHITType
func (c *MTurk) CreateHITType(input *CreateHITTypeInput) (*CreateHITTypeOutput, error) {
	req, out := c.CreateHITTypeRequest(input)
	return out, req.Send()
}

// CreateHITTypeWithContext is the same as CreateHITType with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHITType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) CreateHITTypeWithContext(ctx aws.Context, input *CreateHITTypeInput, opts ...request.Option) (*CreateHITTypeOutput, error) {
	req, out := c.CreateHITTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHITWithHITType = "CreateHITWithHITType"

// CreateHITWithHITTypeRequest generates a "aws/request.Request" representing the
// client's request for the CreateHITWithHITType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHITWithHITType for more information on using the CreateHITWithHITType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateHITWithHITTypeRequest method.
//    req, resp := client.CreateHITWithHITTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateHITWithHITType
func (c *MTurk) CreateHITWithHITTypeRequest(input *CreateHITWithHITTypeInput) (req *request.Request, output *CreateHITWithHITTypeOutput) {
	op := &request.Operation{
		Name:       opCreateHITWithHITType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHITWithHITTypeInput{}
	}

	output = &CreateHITWithHITTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHITWithHITType API operation for Amazon Mechanical Turk.
//
// The CreateHITWithHITType operation creates a new Human Intelligence Task
// (HIT) using an existing HITTypeID generated by the CreateHITType operation.
//
// This is an alternative way to create HITs from the CreateHIT operation. This
// is the recommended best practice for Requesters who are creating large numbers
// of HITs.
//
// CreateHITWithHITType also supports several ways to provide question data:
// by providing a value for the Question parameter that fully specifies the
// contents of the HIT, or by providing a HitLayoutId and associated HitLayoutParameters.
//
// If a HIT is created with 10 or more maximum assignments, there is an additional
// fee. For more information, see Amazon Mechanical Turk Pricing (https://requester.mturk.com/pricing).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation CreateHITWithHITType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateHITWithHITType
func (c *MTurk) CreateHITWithHITType(input *CreateHITWithHITTypeInput) (*CreateHITWithHITTypeOutput, error) {
	req, out := c.CreateHITWithHITTypeRequest(input)
	return out, req.Send()
}

// CreateHITWithHITTypeWithContext is the same as CreateHITWithHITType with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHITWithHITType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) CreateHITWithHITTypeWithContext(ctx aws.Context, input *CreateHITWithHITTypeInput, opts ...request.Option) (*CreateHITWithHITTypeOutput, error) {
	req, out := c.CreateHITWithHITTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateQualificationType = "CreateQualificationType"

// CreateQualificationTypeRequest generates a "aws/request.Request" representing the
// client's request for the CreateQualificationType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateQualificationType for more information on using the CreateQualificationType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateQualificationTypeRequest method.
//    req, resp := client.CreateQualificationTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateQualificationType
func (c *MTurk) CreateQualificationTypeRequest(input *CreateQualificationTypeInput) (req *request.Request, output *CreateQualificationTypeOutput) {
	op := &request.Operation{
		Name:       opCreateQualificationType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateQualificationTypeInput{}
	}

	output = &CreateQualificationTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateQualificationType API operation for Amazon Mechanical Turk.
//
// The CreateQualificationType operation creates a new Qualification type, which
// is represented by a QualificationType data structure.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation CreateQualificationType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateQualificationType
func (c *MTurk) CreateQualificationType(input *CreateQualificationTypeInput) (*CreateQualificationTypeOutput, error) {
	req, out := c.CreateQualificationTypeRequest(input)
	return out, req.Send()
}

// CreateQualificationTypeWithContext is the same as CreateQualificationType with the addition of
// the ability to pass a context and additional request options.
//
// See CreateQualificationType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) CreateQualificationTypeWithContext(ctx aws.Context, input *CreateQualificationTypeInput, opts ...request.Option) (*CreateQualificationTypeOutput, error) {
	req, out := c.CreateQualificationTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkerBlock = "CreateWorkerBlock"

// CreateWorkerBlockRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkerBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkerBlock for more information on using the CreateWorkerBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkerBlockRequest method.
//    req, resp := client.CreateWorkerBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateWorkerBlock
func (c *MTurk) CreateWorkerBlockRequest(input *CreateWorkerBlockInput) (req *request.Request, output *CreateWorkerBlockOutput) {
	op := &request.Operation{
		Name:       opCreateWorkerBlock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkerBlockInput{}
	}

	output = &CreateWorkerBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateWorkerBlock API operation for Amazon Mechanical Turk.
//
// The CreateWorkerBlock operation allows you to prevent a Worker from working
// on your HITs. For example, you can block a Worker who is producing poor quality
// work. You can block up to 100,000 Workers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation CreateWorkerBlock for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateWorkerBlock
func (c *MTurk) CreateWorkerBlock(input *CreateWorkerBlockInput) (*CreateWorkerBlockOutput, error) {
	req, out := c.CreateWorkerBlockRequest(input)
	return out, req.Send()
}

// CreateWorkerBlockWithContext is the same as CreateWorkerBlock with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkerBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) CreateWorkerBlockWithContext(ctx aws.Context, input *CreateWorkerBlockInput, opts ...request.Option) (*CreateWorkerBlockOutput, error) {
	req, out := c.CreateWorkerBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteHIT = "DeleteHIT"

// DeleteHITRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHIT operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteHIT for more information on using the DeleteHIT
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteHITRequest method.
//    req, resp := client.DeleteHITRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DeleteHIT
func (c *MTurk) DeleteHITRequest(input *DeleteHITInput) (req *request.Request, output *DeleteHITOutput) {
	op := &request.Operation{
		Name:       opDeleteHIT,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteHITInput{}
	}

	output = &DeleteHITOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteHIT API operation for Amazon Mechanical Turk.
//
// The DeleteHIT operation is used to delete HIT that is no longer needed. Only
// the Requester who created the HIT can delete it.
//
// You can only dispose of HITs that are in the Reviewable state, with all of
// their submitted assignments already either approved or rejected. If you call
// the DeleteHIT operation on a HIT that is not in the Reviewable state (for
// example, that has not expired, or still has active assignments), or on a
// HIT that is Reviewable but without all of its submitted assignments already
// approved or rejected, the service will return an error.
//
//    * HITs are automatically disposed of after 120 days.
//
//    * After you dispose of a HIT, you can no longer approve the HIT's rejected
//    assignments.
//
//    * Disposed HITs are not returned in results for the ListHITs operation.
//
//    * Disposing HITs can improve the performance of operations such as ListReviewableHITs
//    and ListHITs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation DeleteHIT for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DeleteHIT
func (c *MTurk) DeleteHIT(input *DeleteHITInput) (*DeleteHITOutput, error) {
	req, out := c.DeleteHITRequest(input)
	return out, req.Send()
}

// DeleteHITWithContext is the same as DeleteHIT with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteHIT for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) DeleteHITWithContext(ctx aws.Context, input *DeleteHITInput, opts ...request.Option) (*DeleteHITOutput, error) {
	req, out := c.DeleteHITRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteQualificationType = "DeleteQualificationType"

// DeleteQualificationTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteQualificationType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteQualificationType for more information on using the DeleteQualificationType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteQualificationTypeRequest method.
//    req, resp := client.DeleteQualificationTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DeleteQualificationType
func (c *MTurk) DeleteQualificationTypeRequest(input *DeleteQualificationTypeInput) (req *request.Request, output *DeleteQualificationTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteQualificationType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteQualificationTypeInput{}
	}

	output = &DeleteQualificationTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteQualificationType API operation for Amazon Mechanical Turk.
//
// The DeleteQualificationType deletes a Qualification type and deletes any
// HIT types that are associated with the Qualification type.
//
// This operation does not revoke Qualifications already assigned to Workers
// because the Qualifications might be needed for active HITs. If there are
// any pending requests for the Qualification type, Amazon Mechanical Turk rejects
// those requests. After you delete a Qualification type, you can no longer
// use it to create HITs or HIT types.
//
// DeleteQualificationType must wait for all the HITs that use the deleted Qualification
// type to be deleted before completing. It may take up to 48 hours before DeleteQualificationType
// completes and the unique name of the Qualification type is available for
// reuse with CreateQualificationType.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation DeleteQualificationType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DeleteQualificationType
func (c *MTurk) DeleteQualificationType(input *DeleteQualificationTypeInput) (*DeleteQualificationTypeOutput, error) {
	req, out := c.DeleteQualificationTypeRequest(input)
	return out, req.Send()
}

// DeleteQualificationTypeWithContext is the same as DeleteQualificationType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteQualificationType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) DeleteQualificationTypeWithContext(ctx aws.Context, input *DeleteQualificationTypeInput, opts ...request.Option) (*DeleteQualificationTypeOutput, error) {
	req, out := c.DeleteQualificationTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkerBlock = "DeleteWorkerBlock"

// DeleteWorkerBlockRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkerBlock operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkerBlock for more information on using the DeleteWorkerBlock
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWorkerBlockRequest method.
//    req, resp := client.DeleteWorkerBlockRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DeleteWorkerBlock
func (c *MTurk) DeleteWorkerBlockRequest(input *DeleteWorkerBlockInput) (req *request.Request, output *DeleteWorkerBlockOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkerBlock,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkerBlockInput{}
	}

	output = &DeleteWorkerBlockOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkerBlock API operation for Amazon Mechanical Turk.
//
// The DeleteWorkerBlock operation allows you to reinstate a blocked Worker
// to work on your HITs. This operation reverses the effects of the CreateWorkerBlock
// operation. You need the Worker ID to use this operation. If the Worker ID
// is missing or invalid, this operation fails and returns the message “WorkerId
// is invalid.” If the specified Worker is not blocked, this operation returns
// successfully.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation DeleteWorkerBlock for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DeleteWorkerBlock
func (c *MTurk) DeleteWorkerBlock(input *DeleteWorkerBlockInput) (*DeleteWorkerBlockOutput, error) {
	req, out := c.DeleteWorkerBlockRequest(input)
	return out, req.Send()
}

// DeleteWorkerBlockWithContext is the same as DeleteWorkerBlock with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkerBlock for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) DeleteWorkerBlockWithContext(ctx aws.Context, input *DeleteWorkerBlockInput, opts ...request.Option) (*DeleteWorkerBlockOutput, error) {
	req, out := c.DeleteWorkerBlockRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateQualificationFromWorker = "DisassociateQualificationFromWorker"

// DisassociateQualificationFromWorkerRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateQualificationFromWorker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateQualificationFromWorker for more information on using the DisassociateQualificationFromWorker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateQualificationFromWorkerRequest method.
//    req, resp := client.DisassociateQualificationFromWorkerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DisassociateQualificationFromWorker
func (c *MTurk) DisassociateQualificationFromWorkerRequest(input *DisassociateQualificationFromWorkerInput) (req *request.Request, output *DisassociateQualificationFromWorkerOutput) {
	op := &request.Operation{
		Name:       opDisassociateQualificationFromWorker,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateQualificationFromWorkerInput{}
	}

	output = &DisassociateQualificationFromWorkerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateQualificationFromWorker API operation for Amazon Mechanical Turk.
//
// The DisassociateQualificationFromWorker revokes a previously granted Qualification
// from a user.
//
// You can provide a text message explaining why the Qualification was revoked.
// The user who had the Qualification can see this message.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation DisassociateQualificationFromWorker for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/DisassociateQualificationFromWorker
func (c *MTurk) DisassociateQualificationFromWorker(input *DisassociateQualificationFromWorkerInput) (*DisassociateQualificationFromWorkerOutput, error) {
	req, out := c.DisassociateQualificationFromWorkerRequest(input)
	return out, req.Send()
}

// DisassociateQualificationFromWorkerWithContext is the same as DisassociateQualificationFromWorker with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateQualificationFromWorker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) DisassociateQualificationFromWorkerWithContext(ctx aws.Context, input *DisassociateQualificationFromWorkerInput, opts ...request.Option) (*DisassociateQualificationFromWorkerOutput, error) {
	req, out := c.DisassociateQualificationFromWorkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountBalance = "GetAccountBalance"

// GetAccountBalanceRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountBalance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountBalance for more information on using the GetAccountBalance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccountBalanceRequest method.
//    req, resp := client.GetAccountBalanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetAccountBalance
func (c *MTurk) GetAccountBalanceRequest(input *GetAccountBalanceInput) (req *request.Request, output *GetAccountBalanceOutput) {
	op := &request.Operation{
		Name:       opGetAccountBalance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccountBalanceInput{}
	}

	output = &GetAccountBalanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountBalance API operation for Amazon Mechanical Turk.
//
// The GetAccountBalance operation retrieves the amount of money in your Amazon
// Mechanical Turk account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation GetAccountBalance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetAccountBalance
func (c *MTurk) GetAccountBalance(input *GetAccountBalanceInput) (*GetAccountBalanceOutput, error) {
	req, out := c.GetAccountBalanceRequest(input)
	return out, req.Send()
}

// GetAccountBalanceWithContext is the same as GetAccountBalance with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountBalance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) GetAccountBalanceWithContext(ctx aws.Context, input *GetAccountBalanceInput, opts ...request.Option) (*GetAccountBalanceOutput, error) {
	req, out := c.GetAccountBalanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssignment = "GetAssignment"

// GetAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the GetAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssignment for more information on using the GetAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssignmentRequest method.
//    req, resp := client.GetAssignmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetAssignment
func (c *MTurk) GetAssignmentRequest(input *GetAssignmentInput) (req *request.Request, output *GetAssignmentOutput) {
	op := &request.Operation{
		Name:       opGetAssignment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAssignmentInput{}
	}

	output = &GetAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssignment API operation for Amazon Mechanical Turk.
//
// The GetAssignment operation retrieves the details of the specified Assignment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation GetAssignment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetAssignment
func (c *MTurk) GetAssignment(input *GetAssignmentInput) (*GetAssignmentOutput, error) {
	req, out := c.GetAssignmentRequest(input)
	return out, req.Send()
}

// GetAssignmentWithContext is the same as GetAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) GetAssignmentWithContext(ctx aws.Context, input *GetAssignmentInput, opts ...request.Option) (*GetAssignmentOutput, error) {
	req, out := c.GetAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFileUploadURL = "GetFileUploadURL"

// GetFileUploadURLRequest generates a "aws/request.Request" representing the
// client's request for the GetFileUploadURL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFileUploadURL for more information on using the GetFileUploadURL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFileUploadURLRequest method.
//    req, resp := client.GetFileUploadURLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetFileUploadURL
func (c *MTurk) GetFileUploadURLRequest(input *GetFileUploadURLInput) (req *request.Request, output *GetFileUploadURLOutput) {
	op := &request.Operation{
		Name:       opGetFileUploadURL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetFileUploadURLInput{}
	}

	output = &GetFileUploadURLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFileUploadURL API operation for Amazon Mechanical Turk.
//
// The GetFileUploadURL operation generates and returns a temporary URL. You
// use the temporary URL to retrieve a file uploaded by a Worker as an answer
// to a FileUploadAnswer question for a HIT. The temporary URL is generated
// the instant the GetFileUploadURL operation is called, and is valid for 60
// seconds. You can get a temporary file upload URL any time until the HIT is
// disposed. After the HIT is disposed, any uploaded files are deleted, and
// cannot be retrieved. Pending Deprecation on December 12, 2017. The Answer
// Specification structure will no longer support the FileUploadAnswer element
// to be used for the QuestionForm data structure. Instead, we recommend that
// Requesters who want to create HITs asking Workers to upload files to use
// Amazon S3.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation GetFileUploadURL for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetFileUploadURL
func (c *MTurk) GetFileUploadURL(input *GetFileUploadURLInput) (*GetFileUploadURLOutput, error) {
	req, out := c.GetFileUploadURLRequest(input)
	return out, req.Send()
}

// GetFileUploadURLWithContext is the same as GetFileUploadURL with the addition of
// the ability to pass a context and additional request options.
//
// See GetFileUploadURL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) GetFileUploadURLWithContext(ctx aws.Context, input *GetFileUploadURLInput, opts ...request.Option) (*GetFileUploadURLOutput, error) {
	req, out := c.GetFileUploadURLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetHIT = "GetHIT"

// GetHITRequest generates a "aws/request.Request" representing the
// client's request for the GetHIT operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetHIT for more information on using the GetHIT
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetHITRequest method.
//    req, resp := client.GetHITRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetHIT
func (c *MTurk) GetHITRequest(input *GetHITInput) (req *request.Request, output *GetHITOutput) {
	op := &request.Operation{
		Name:       opGetHIT,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetHITInput{}
	}

	output = &GetHITOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetHIT API operation for Amazon Mechanical Turk.
//
// The GetHIT operation retrieves the details of the specified HIT.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation GetHIT for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetHIT
func (c *MTurk) GetHIT(input *GetHITInput) (*GetHITOutput, error) {
	req, out := c.GetHITRequest(input)
	return out, req.Send()
}

// GetHITWithContext is the same as GetHIT with the addition of
// the ability to pass a context and additional request options.
//
// See GetHIT for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) GetHITWithContext(ctx aws.Context, input *GetHITInput, opts ...request.Option) (*GetHITOutput, error) {
	req, out := c.GetHITRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQualificationScore = "GetQualificationScore"

// GetQualificationScoreRequest generates a "aws/request.Request" representing the
// client's request for the GetQualificationScore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQualificationScore for more information on using the GetQualificationScore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetQualificationScoreRequest method.
//    req, resp := client.GetQualificationScoreRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetQualificationScore
func (c *MTurk) GetQualificationScoreRequest(input *GetQualificationScoreInput) (req *request.Request, output *GetQualificationScoreOutput) {
	op := &request.Operation{
		Name:       opGetQualificationScore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetQualificationScoreInput{}
	}

	output = &GetQualificationScoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetQualificationScore API operation for Amazon Mechanical Turk.
//
// The GetQualificationScore operation returns the value of a Worker's Qualification
// for a given Qualification type.
//
// To get a Worker's Qualification, you must know the Worker's ID. The Worker's
// ID is included in the assignment data returned by the ListAssignmentsForHIT
// operation.
//
// Only the owner of a Qualification type can query the value of a Worker's
// Qualification of that type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation GetQualificationScore for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetQualificationScore
func (c *MTurk) GetQualificationScore(input *GetQualificationScoreInput) (*GetQualificationScoreOutput, error) {
	req, out := c.GetQualificationScoreRequest(input)
	return out, req.Send()
}

// GetQualificationScoreWithContext is the same as GetQualificationScore with the addition of
// the ability to pass a context and additional request options.
//
// See GetQualificationScore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) GetQualificationScoreWithContext(ctx aws.Context, input *GetQualificationScoreInput, opts ...request.Option) (*GetQualificationScoreOutput, error) {
	req, out := c.GetQualificationScoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQualificationType = "GetQualificationType"

// GetQualificationTypeRequest generates a "aws/request.Request" representing the
// client's request for the GetQualificationType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQualificationType for more information on using the GetQualificationType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetQualificationTypeRequest method.
//    req, resp := client.GetQualificationTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetQualificationType
func (c *MTurk) GetQualificationTypeRequest(input *GetQualificationTypeInput) (req *request.Request, output *GetQualificationTypeOutput) {
	op := &request.Operation{
		Name:       opGetQualificationType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetQualificationTypeInput{}
	}

	output = &GetQualificationTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetQualificationType API operation for Amazon Mechanical Turk.
//
// The GetQualificationTypeoperation retrieves information about a Qualification
// type using its ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation GetQualificationType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/GetQualificationType
func (c *MTurk) GetQualificationType(input *GetQualificationTypeInput) (*GetQualificationTypeOutput, error) {
	req, out := c.GetQualificationTypeRequest(input)
	return out, req.Send()
}

// GetQualificationTypeWithContext is the same as GetQualificationType with the addition of
// the ability to pass a context and additional request options.
//
// See GetQualificationType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) GetQualificationTypeWithContext(ctx aws.Context, input *GetQualificationTypeInput, opts ...request.Option) (*GetQualificationTypeOutput, error) {
	req, out := c.GetQualificationTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssignmentsForHIT = "ListAssignmentsForHIT"

// ListAssignmentsForHITRequest generates a "aws/request.Request" representing the
// client's request for the ListAssignmentsForHIT operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssignmentsForHIT for more information on using the ListAssignmentsForHIT
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssignmentsForHITRequest method.
//    req, resp := client.ListAssignmentsForHITRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListAssignmentsForHIT
func (c *MTurk) ListAssignmentsForHITRequest(input *ListAssignmentsForHITInput) (req *request.Request, output *ListAssignmentsForHITOutput) {
	op := &request.Operation{
		Name:       opListAssignmentsForHIT,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssignmentsForHITInput{}
	}

	output = &ListAssignmentsForHITOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssignmentsForHIT API operation for Amazon Mechanical Turk.
//
// The ListAssignmentsForHIT operation retrieves completed assignments for a
// HIT. You can use this operation to retrieve the results for a HIT.
//
// You can get assignments for a HIT at any time, even if the HIT is not yet
// Reviewable. If a HIT requested multiple assignments, and has received some
// results but has not yet become Reviewable, you can still retrieve the partial
// results with this operation.
//
// Use the AssignmentStatus parameter to control which set of assignments for
// a HIT are returned. The ListAssignmentsForHIT operation can return submitted
// assignments awaiting approval, or it can return assignments that have already
// been approved or rejected. You can set AssignmentStatus=Approved,Rejected
// to get assignments that have already been approved and rejected together
// in one result set.
//
// Only the Requester who created the HIT can retrieve the assignments for that
// HIT.
//
// Results are sorted and divided into numbered pages and the operation returns
// a single page of results. You can use the parameters of the operation to
// control sorting and pagination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation ListAssignmentsForHIT for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListAssignmentsForHIT
func (c *MTurk) ListAssignmentsForHIT(input *ListAssignmentsForHITInput) (*ListAssignmentsForHITOutput, error) {
	req, out := c.ListAssignmentsForHITRequest(input)
	return out, req.Send()
}

// ListAssignmentsForHITWithContext is the same as ListAssignmentsForHIT with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssignmentsForHIT for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListAssignmentsForHITWithContext(ctx aws.Context, input *ListAssignmentsForHITInput, opts ...request.Option) (*ListAssignmentsForHITOutput, error) {
	req, out := c.ListAssignmentsForHITRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssignmentsForHITPages iterates over the pages of a ListAssignmentsForHIT operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssignmentsForHIT method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssignmentsForHIT operation.
//    pageNum := 0
//    err := client.ListAssignmentsForHITPages(params,
//        func(page *mturk.ListAssignmentsForHITOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MTurk) ListAssignmentsForHITPages(input *ListAssignmentsForHITInput, fn func(*ListAssignmentsForHITOutput, bool) bool) error {
	return c.ListAssignmentsForHITPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssignmentsForHITPagesWithContext same as ListAssignmentsForHITPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListAssignmentsForHITPagesWithContext(ctx aws.Context, input *ListAssignmentsForHITInput, fn func(*ListAssignmentsForHITOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssignmentsForHITInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssignmentsForHITRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListAssignmentsForHITOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListBonusPayments = "ListBonusPayments"

// ListBonusPaymentsRequest generates a "aws/request.Request" representing the
// client's request for the ListBonusPayments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBonusPayments for more information on using the ListBonusPayments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBonusPaymentsRequest method.
//    req, resp := client.ListBonusPaymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListBonusPayments
func (c *MTurk) ListBonusPaymentsRequest(input *ListBonusPaymentsInput) (req *request.Request, output *ListBonusPaymentsOutput) {
	op := &request.Operation{
		Name:       opListBonusPayments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBonusPaymentsInput{}
	}

	output = &ListBonusPaymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBonusPayments API operation for Amazon Mechanical Turk.
//
// The ListBonusPayments operation retrieves the amounts of bonuses you have
// paid to Workers for a given HIT or assignment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation ListBonusPayments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListBonusPayments
func (c *MTurk) ListBonusPayments(input *ListBonusPaymentsInput) (*ListBonusPaymentsOutput, error) {
	req, out := c.ListBonusPaymentsRequest(input)
	return out, req.Send()
}

// ListBonusPaymentsWithContext is the same as ListBonusPayments with the addition of
// the ability to pass a context and additional request options.
//
// See ListBonusPayments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListBonusPaymentsWithContext(ctx aws.Context, input *ListBonusPaymentsInput, opts ...request.Option) (*ListBonusPaymentsOutput, error) {
	req, out := c.ListBonusPaymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBonusPaymentsPages iterates over the pages of a ListBonusPayments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBonusPayments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListBonusPayments operation.
//    pageNum := 0
//    err := client.ListBonusPaymentsPages(params,
//        func(page *mturk.ListBonusPaymentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MTurk) ListBonusPaymentsPages(input *ListBonusPaymentsInput, fn func(*ListBonusPaymentsOutput, bool) bool) error {
	return c.ListBonusPaymentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBonusPaymentsPagesWithContext same as ListBonusPaymentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListBonusPaymentsPagesWithContext(ctx aws.Context, input *ListBonusPaymentsInput, fn func(*ListBonusPaymentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBonusPaymentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBonusPaymentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListBonusPaymentsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListHITs = "ListHITs"

// ListHITsRequest generates a "aws/request.Request" representing the
// client's request for the ListHITs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHITs for more information on using the ListHITs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHITsRequest method.
//    req, resp := client.ListHITsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListHITs
func (c *MTurk) ListHITsRequest(input *ListHITsInput) (req *request.Request, output *ListHITsOutput) {
	op := &request.Operation{
		Name:       opListHITs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHITsInput{}
	}

	output = &ListHITsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHITs API operation for Amazon Mechanical Turk.
//
// The ListHITs operation returns all of a Requester's HITs. The operation returns
// HITs of any status, except for HITs that have been deleted of with the DeleteHIT
// operation or that have been auto-deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation ListHITs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListHITs
func (c *MTurk) ListHITs(input *ListHITsInput) (*ListHITsOutput, error) {
	req, out := c.ListHITsRequest(input)
	return out, req.Send()
}

// ListHITsWithContext is the same as ListHITs with the addition of
// the ability to pass a context and additional request options.
//
// See ListHITs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListHITsWithContext(ctx aws.Context, input *ListHITsInput, opts ...request.Option) (*ListHITsOutput, error) {
	req, out := c.ListHITsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHITsPages iterates over the pages of a ListHITs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHITs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHITs operation.
//    pageNum := 0
//    err := client.ListHITsPages(params,
//        func(page *mturk.ListHITsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MTurk) ListHITsPages(input *ListHITsInput, fn func(*ListHITsOutput, bool) bool) error {
	return c.ListHITsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHITsPagesWithContext same as ListHITsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListHITsPagesWithContext(ctx aws.Context, input *ListHITsInput, fn func(*ListHITsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHITsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHITsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListHITsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListHITsForQualificationType = "ListHITsForQualificationType"

// ListHITsForQualificationTypeRequest generates a "aws/request.Request" representing the
// client's request for the ListHITsForQualificationType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHITsForQualificationType for more information on using the ListHITsForQualificationType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListHITsForQualificationTypeRequest method.
//    req, resp := client.ListHITsForQualificationTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListHITsForQualificationType
func (c *MTurk) ListHITsForQualificationTypeRequest(input *ListHITsForQualificationTypeInput) (req *request.Request, output *ListHITsForQualificationTypeOutput) {
	op := &request.Operation{
		Name:       opListHITsForQualificationType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHITsForQualificationTypeInput{}
	}

	output = &ListHITsForQualificationTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHITsForQualificationType API operation for Amazon Mechanical Turk.
//
// The ListHITsForQualificationType operation returns the HITs that use the
// given Qualification type for a Qualification requirement. The operation returns
// HITs of any status, except for HITs that have been deleted with the DeleteHIT
// operation or that have been auto-deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation ListHITsForQualificationType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListHITsForQualificationType
func (c *MTurk) ListHITsForQualificationType(input *ListHITsForQualificationTypeInput) (*ListHITsForQualificationTypeOutput, error) {
	req, out := c.ListHITsForQualificationTypeRequest(input)
	return out, req.Send()
}

// ListHITsForQualificationTypeWithContext is the same as ListHITsForQualificationType with the addition of
// the ability to pass a context and additional request options.
//
// See ListHITsForQualificationType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListHITsForQualificationTypeWithContext(ctx aws.Context, input *ListHITsForQualificationTypeInput, opts ...request.Option) (*ListHITsForQualificationTypeOutput, error) {
	req, out := c.ListHITsForQualificationTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHITsForQualificationTypePages iterates over the pages of a ListHITsForQualificationType operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHITsForQualificationType method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListHITsForQualificationType operation.
//    pageNum := 0
//    err := client.ListHITsForQualificationTypePages(params,
//        func(page *mturk.ListHITsForQualificationTypeOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MTurk) ListHITsForQualificationTypePages(input *ListHITsForQualificationTypeInput, fn func(*ListHITsForQualificationTypeOutput, bool) bool) error {
	return c.ListHITsForQualificationTypePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHITsForQualificationTypePagesWithContext same as ListHITsForQualificationTypePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListHITsForQualificationTypePagesWithContext(ctx aws.Context, input *ListHITsForQualificationTypeInput, fn func(*ListHITsForQualificationTypeOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHITsForQualificationTypeInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHITsForQualificationTypeRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListHITsForQualificationTypeOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListQualificationRequests = "ListQualificationRequests"

// ListQualificationRequestsRequest generates a "aws/request.Request" representing the
// client's request for the ListQualificationRequests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQualificationRequests for more information on using the ListQualificationRequests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListQualificationRequestsRequest method.
//    req, resp := client.ListQualificationRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListQualificationRequests
func (c *MTurk) ListQualificationRequestsRequest(input *ListQualificationRequestsInput) (req *request.Request, output *ListQualificationRequestsOutput) {
	op := &request.Operation{
		Name:       opListQualificationRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQualificationRequestsInput{}
	}

	output = &ListQualificationRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListQualificationRequests API operation for Amazon Mechanical Turk.
//
// The ListQualificationRequests operation retrieves requests for Qualifications
// of a particular Qualification type. The owner of the Qualification type calls
// this operation to poll for pending requests, and accepts them using the AcceptQualification
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation ListQualificationRequests for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListQualificationRequests
func (c *MTurk) ListQualificationRequests(input *ListQualificationRequestsInput) (*ListQualificationRequestsOutput, error) {
	req, out := c.ListQualificationRequestsRequest(input)
	return out, req.Send()
}

// ListQualificationRequestsWithContext is the same as ListQualificationRequests with the addition of
// the ability to pass a context and additional request options.
//
// See ListQualificationRequests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListQualificationRequestsWithContext(ctx aws.Context, input *ListQualificationRequestsInput, opts ...request.Option) (*ListQualificationRequestsOutput, error) {
	req, out := c.ListQualificationRequestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListQualificationRequestsPages iterates over the pages of a ListQualificationRequests operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListQualificationRequests method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListQualificationRequests operation.
//    pageNum := 0
//    err := client.ListQualificationRequestsPages(params,
//        func(page *mturk.ListQualificationRequestsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MTurk) ListQualificationRequestsPages(input *ListQualificationRequestsInput, fn func(*ListQualificationRequestsOutput, bool) bool) error {
	return c.ListQualificationRequestsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListQualificationRequestsPagesWithContext same as ListQualificationRequestsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListQualificationRequestsPagesWithContext(ctx aws.Context, input *ListQualificationRequestsInput, fn func(*ListQualificationRequestsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListQualificationRequestsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListQualificationRequestsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListQualificationRequestsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListQualificationTypes = "ListQualificationTypes"

// ListQualificationTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListQualificationTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQualificationTypes for more information on using the ListQualificationTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListQualificationTypesRequest method.
//    req, resp := client.ListQualificationTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListQualificationTypes
func (c *MTurk) ListQualificationTypesRequest(input *ListQualificationTypesInput) (req *request.Request, output *ListQualificationTypesOutput) {
	op := &request.Operation{
		Name:       opListQualificationTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQualificationTypesInput{}
	}

	output = &ListQualificationTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListQualificationTypes API operation for Amazon Mechanical Turk.
//
// The ListQualificationTypes operation returns a list of Qualification types,
// filtered by an optional search term.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation ListQualificationTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListQualificationTypes
func (c *MTurk) ListQualificationTypes(input *ListQualificationTypesInput) (*ListQualificationTypesOutput, error) {
	req, out := c.ListQualificationTypesRequest(input)
	return out, req.Send()
}

// ListQualificationTypesWithContext is the same as ListQualificationTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListQualificationTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListQualificationTypesWithContext(ctx aws.Context, input *ListQualificationTypesInput, opts ...request.Option) (*ListQualificationTypesOutput, error) {
	req, out := c.ListQualificationTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListQualificationTypesPages iterates over the pages of a ListQualificationTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListQualificationTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListQualificationTypes operation.
//    pageNum := 0
//    err := client.ListQualificationTypesPages(params,
//        func(page *mturk.ListQualificationTypesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MTurk) ListQualificationTypesPages(input *ListQualificationTypesInput, fn func(*ListQualificationTypesOutput, bool) bool) error {
	return c.ListQualificationTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListQualificationTypesPagesWithContext same as ListQualificationTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListQualificationTypesPagesWithContext(ctx aws.Context, input *ListQualificationTypesInput, fn func(*ListQualificationTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListQualificationTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListQualificationTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListQualificationTypesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListReviewPolicyResultsForHIT = "ListReviewPolicyResultsForHIT"

// ListReviewPolicyResultsForHITRequest generates a "aws/request.Request" representing the
// client's request for the ListReviewPolicyResultsForHIT operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReviewPolicyResultsForHIT for more information on using the ListReviewPolicyResultsForHIT
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListReviewPolicyResultsForHITRequest method.
//    req, resp := client.ListReviewPolicyResultsForHITRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListReviewPolicyResultsForHIT
func (c *MTurk) ListReviewPolicyResultsForHITRequest(input *ListReviewPolicyResultsForHITInput) (req *request.Request, output *ListReviewPolicyResultsForHITOutput) {
	op := &request.Operation{
		Name:       opListReviewPolicyResultsForHIT,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReviewPolicyResultsForHITInput{}
	}

	output = &ListReviewPolicyResultsForHITOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReviewPolicyResultsForHIT API operation for Amazon Mechanical Turk.
//
// The ListReviewPolicyResultsForHIT operation retrieves the computed results
// and the actions taken in the course of executing your Review Policies for
// a given HIT. For information about how to specify Review Policies when you
// call CreateHIT, see Review Policies. The ListReviewPolicyResultsForHIT operation
// can return results for both Assignment-level and HIT-level review results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation ListReviewPolicyResultsForHIT for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListReviewPolicyResultsForHIT
func (c *MTurk) ListReviewPolicyResultsForHIT(input *ListReviewPolicyResultsForHITInput) (*ListReviewPolicyResultsForHITOutput, error) {
	req, out := c.ListReviewPolicyResultsForHITRequest(input)
	return out, req.Send()
}

// ListReviewPolicyResultsForHITWithContext is the same as ListReviewPolicyResultsForHIT with the addition of
// the ability to pass a context and additional request options.
//
// See ListReviewPolicyResultsForHIT for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListReviewPolicyResultsForHITWithContext(ctx aws.Context, input *ListReviewPolicyResultsForHITInput, opts ...request.Option) (*ListReviewPolicyResultsForHITOutput, error) {
	req, out := c.ListReviewPolicyResultsForHITRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReviewPolicyResultsForHITPages iterates over the pages of a ListReviewPolicyResultsForHIT operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReviewPolicyResultsForHIT method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListReviewPolicyResultsForHIT operation.
//    pageNum := 0
//    err := client.ListReviewPolicyResultsForHITPages(params,
//        func(page *mturk.ListReviewPolicyResultsForHITOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MTurk) ListReviewPolicyResultsForHITPages(input *ListReviewPolicyResultsForHITInput, fn func(*ListReviewPolicyResultsForHITOutput, bool) bool) error {
	return c.ListReviewPolicyResultsForHITPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReviewPolicyResultsForHITPagesWithContext same as ListReviewPolicyResultsForHITPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListReviewPolicyResultsForHITPagesWithContext(ctx aws.Context, input *ListReviewPolicyResultsForHITInput, fn func(*ListReviewPolicyResultsForHITOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReviewPolicyResultsForHITInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReviewPolicyResultsForHITRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListReviewPolicyResultsForHITOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListReviewableHITs = "ListReviewableHITs"

// ListReviewableHITsRequest generates a "aws/request.Request" representing the
// client's request for the ListReviewableHITs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReviewableHITs for more information on using the ListReviewableHITs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListReviewableHITsRequest method.
//    req, resp := client.ListReviewableHITsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListReviewableHITs
func (c *MTurk) ListReviewableHITsRequest(input *ListReviewableHITsInput) (req *request.Request, output *ListReviewableHITsOutput) {
	op := &request.Operation{
		Name:       opListReviewableHITs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReviewableHITsInput{}
	}

	output = &ListReviewableHITsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReviewableHITs API operation for Amazon Mechanical Turk.
//
// The ListReviewableHITs operation retrieves the HITs with Status equal to
// Reviewable or Status equal to Reviewing that belong to the Requester calling
// the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation ListReviewableHITs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListReviewableHITs
func (c *MTurk) ListReviewableHITs(input *ListReviewableHITsInput) (*ListReviewableHITsOutput, error) {
	req, out := c.ListReviewableHITsRequest(input)
	return out, req.Send()
}

// ListReviewableHITsWithContext is the same as ListReviewableHITs with the addition of
// the ability to pass a context and additional request options.
//
// See ListReviewableHITs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListReviewableHITsWithContext(ctx aws.Context, input *ListReviewableHITsInput, opts ...request.Option) (*ListReviewableHITsOutput, error) {
	req, out := c.ListReviewableHITsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReviewableHITsPages iterates over the pages of a ListReviewableHITs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReviewableHITs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListReviewableHITs operation.
//    pageNum := 0
//    err := client.ListReviewableHITsPages(params,
//        func(page *mturk.ListReviewableHITsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MTurk) ListReviewableHITsPages(input *ListReviewableHITsInput, fn func(*ListReviewableHITsOutput, bool) bool) error {
	return c.ListReviewableHITsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReviewableHITsPagesWithContext same as ListReviewableHITsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListReviewableHITsPagesWithContext(ctx aws.Context, input *ListReviewableHITsInput, fn func(*ListReviewableHITsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReviewableHITsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReviewableHITsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListReviewableHITsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListWorkerBlocks = "ListWorkerBlocks"

// ListWorkerBlocksRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkerBlocks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkerBlocks for more information on using the ListWorkerBlocks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorkerBlocksRequest method.
//    req, resp := client.ListWorkerBlocksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkerBlocks
func (c *MTurk) ListWorkerBlocksRequest(input *ListWorkerBlocksInput) (req *request.Request, output *ListWorkerBlocksOutput) {
	op := &request.Operation{
		Name:       opListWorkerBlocks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkerBlocksInput{}
	}

	output = &ListWorkerBlocksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkerBlocks API operation for Amazon Mechanical Turk.
//
// The ListWorkersBlocks operation retrieves a list of Workers who are blocked
// from working on your HITs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation ListWorkerBlocks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkerBlocks
func (c *MTurk) ListWorkerBlocks(input *ListWorkerBlocksInput) (*ListWorkerBlocksOutput, error) {
	req, out := c.ListWorkerBlocksRequest(input)
	return out, req.Send()
}

// ListWorkerBlocksWithContext is the same as ListWorkerBlocks with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkerBlocks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListWorkerBlocksWithContext(ctx aws.Context, input *ListWorkerBlocksInput, opts ...request.Option) (*ListWorkerBlocksOutput, error) {
	req, out := c.ListWorkerBlocksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkerBlocksPages iterates over the pages of a ListWorkerBlocks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkerBlocks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorkerBlocks operation.
//    pageNum := 0
//    err := client.ListWorkerBlocksPages(params,
//        func(page *mturk.ListWorkerBlocksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MTurk) ListWorkerBlocksPages(input *ListWorkerBlocksInput, fn func(*ListWorkerBlocksOutput, bool) bool) error {
	return c.ListWorkerBlocksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkerBlocksPagesWithContext same as ListWorkerBlocksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListWorkerBlocksPagesWithContext(ctx aws.Context, input *ListWorkerBlocksInput, fn func(*ListWorkerBlocksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkerBlocksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkerBlocksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListWorkerBlocksOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListWorkersWithQualificationType = "ListWorkersWithQualificationType"

// ListWorkersWithQualificationTypeRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkersWithQualificationType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkersWithQualificationType for more information on using the ListWorkersWithQualificationType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorkersWithQualificationTypeRequest method.
//    req, resp := client.ListWorkersWithQualificationTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkersWithQualificationType
func (c *MTurk) ListWorkersWithQualificationTypeRequest(input *ListWorkersWithQualificationTypeInput) (req *request.Request, output *ListWorkersWithQualificationTypeOutput) {
	op := &request.Operation{
		Name:       opListWorkersWithQualificationType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkersWithQualificationTypeInput{}
	}

	output = &ListWorkersWithQualificationTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkersWithQualificationType API operation for Amazon Mechanical Turk.
//
// The ListWorkersWithQualificationType operation returns all of the Workers
// that have been associated with a given Qualification type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation ListWorkersWithQualificationType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/ListWorkersWithQualificationType
func (c *MTurk) ListWorkersWithQualificationType(input *ListWorkersWithQualificationTypeInput) (*ListWorkersWithQualificationTypeOutput, error) {
	req, out := c.ListWorkersWithQualificationTypeRequest(input)
	return out, req.Send()
}

// ListWorkersWithQualificationTypeWithContext is the same as ListWorkersWithQualificationType with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkersWithQualificationType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListWorkersWithQualificationTypeWithContext(ctx aws.Context, input *ListWorkersWithQualificationTypeInput, opts ...request.Option) (*ListWorkersWithQualificationTypeOutput, error) {
	req, out := c.ListWorkersWithQualificationTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkersWithQualificationTypePages iterates over the pages of a ListWorkersWithQualificationType operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkersWithQualificationType method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorkersWithQualificationType operation.
//    pageNum := 0
//    err := client.ListWorkersWithQualificationTypePages(params,
//        func(page *mturk.ListWorkersWithQualificationTypeOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *MTurk) ListWorkersWithQualificationTypePages(input *ListWorkersWithQualificationTypeInput, fn func(*ListWorkersWithQualificationTypeOutput, bool) bool) error {
	return c.ListWorkersWithQualificationTypePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkersWithQualificationTypePagesWithContext same as ListWorkersWithQualificationTypePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) ListWorkersWithQualificationTypePagesWithContext(ctx aws.Context, input *ListWorkersWithQualificationTypeInput, fn func(*ListWorkersWithQualificationTypeOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkersWithQualificationTypeInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkersWithQualificationTypeRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListWorkersWithQualificationTypeOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opNotifyWorkers = "NotifyWorkers"

// NotifyWorkersRequest generates a "aws/request.Request" representing the
// client's request for the NotifyWorkers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See NotifyWorkers for more information on using the NotifyWorkers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the NotifyWorkersRequest method.
//    req, resp := client.NotifyWorkersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/NotifyWorkers
func (c *MTurk) NotifyWorkersRequest(input *NotifyWorkersInput) (req *request.Request, output *NotifyWorkersOutput) {
	op := &request.Operation{
		Name:       opNotifyWorkers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &NotifyWorkersInput{}
	}

	output = &NotifyWorkersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// NotifyWorkers API operation for Amazon Mechanical Turk.
//
// The NotifyWorkers operation sends an email to one or more Workers that you
// specify with the Worker ID. You can specify up to 100 Worker IDs to send
// the same message with a single call to the NotifyWorkers operation. The NotifyWorkers
// operation will send a notification email to a Worker only if you have previously
// approved or rejected work from the Worker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation NotifyWorkers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/NotifyWorkers
func (c *MTurk) NotifyWorkers(input *NotifyWorkersInput) (*NotifyWorkersOutput, error) {
	req, out := c.NotifyWorkersRequest(input)
	return out, req.Send()
}

// NotifyWorkersWithContext is the same as NotifyWorkers with the addition of
// the ability to pass a context and additional request options.
//
// See NotifyWorkers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) NotifyWorkersWithContext(ctx aws.Context, input *NotifyWorkersInput, opts ...request.Option) (*NotifyWorkersOutput, error) {
	req, out := c.NotifyWorkersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectAssignment = "RejectAssignment"

// RejectAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the RejectAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectAssignment for more information on using the RejectAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RejectAssignmentRequest method.
//    req, resp := client.RejectAssignmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/RejectAssignment
func (c *MTurk) RejectAssignmentRequest(input *RejectAssignmentInput) (req *request.Request, output *RejectAssignmentOutput) {
	op := &request.Operation{
		Name:       opRejectAssignment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RejectAssignmentInput{}
	}

	output = &RejectAssignmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RejectAssignment API operation for Amazon Mechanical Turk.
//
// The RejectAssignment operation rejects the results of a completed assignment.
//
// You can include an optional feedback message with the rejection, which the
// Worker can see in the Status section of the web site. When you include a
// feedback message with the rejection, it helps the Worker understand why the
// assignment was rejected, and can improve the quality of the results the Worker
// submits in the future.
//
// Only the Requester who created the HIT can reject an assignment for the HIT.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation RejectAssignment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/RejectAssignment
func (c *MTurk) RejectAssignment(input *RejectAssignmentInput) (*RejectAssignmentOutput, error) {
	req, out := c.RejectAssignmentRequest(input)
	return out, req.Send()
}

// RejectAssignmentWithContext is the same as RejectAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See RejectAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) RejectAssignmentWithContext(ctx aws.Context, input *RejectAssignmentInput, opts ...request.Option) (*RejectAssignmentOutput, error) {
	req, out := c.RejectAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectQualificationRequest = "RejectQualificationRequest"

// RejectQualificationRequestRequest generates a "aws/request.Request" representing the
// client's request for the RejectQualificationRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectQualificationRequest for more information on using the RejectQualificationRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RejectQualificationRequestRequest method.
//    req, resp := client.RejectQualificationRequestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/RejectQualificationRequest
func (c *MTurk) RejectQualificationRequestRequest(input *RejectQualificationRequestInput) (req *request.Request, output *RejectQualificationRequestOutput) {
	op := &request.Operation{
		Name:       opRejectQualificationRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RejectQualificationRequestInput{}
	}

	output = &RejectQualificationRequestOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RejectQualificationRequest API operation for Amazon Mechanical Turk.
//
// The RejectQualificationRequest operation rejects a user's request for a Qualification.
//
// You can provide a text message explaining why the request was rejected. The
// Worker who made the request can see this message.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation RejectQualificationRequest for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/RejectQualificationRequest
func (c *MTurk) RejectQualificationRequest(input *RejectQualificationRequestInput) (*RejectQualificationRequestOutput, error) {
	req, out := c.RejectQualificationRequestRequest(input)
	return out, req.Send()
}

// RejectQualificationRequestWithContext is the same as RejectQualificationRequest with the addition of
// the ability to pass a context and additional request options.
//
// See RejectQualificationRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) RejectQualificationRequestWithContext(ctx aws.Context, input *RejectQualificationRequestInput, opts ...request.Option) (*RejectQualificationRequestOutput, error) {
	req, out := c.RejectQualificationRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendBonus = "SendBonus"

// SendBonusRequest generates a "aws/request.Request" representing the
// client's request for the SendBonus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendBonus for more information on using the SendBonus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendBonusRequest method.
//    req, resp := client.SendBonusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/SendBonus
func (c *MTurk) SendBonusRequest(input *SendBonusInput) (req *request.Request, output *SendBonusOutput) {
	op := &request.Operation{
		Name:       opSendBonus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendBonusInput{}
	}

	output = &SendBonusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendBonus API operation for Amazon Mechanical Turk.
//
// The SendBonus operation issues a payment of money from your account to a
// Worker. This payment happens separately from the reward you pay to the Worker
// when you approve the Worker's assignment. The SendBonus operation requires
// the Worker's ID and the assignment ID as parameters to initiate payment of
// the bonus. You must include a message that explains the reason for the bonus
// payment, as the Worker may not be expecting the payment. Amazon Mechanical
// Turk collects a fee for bonus payments, similar to the HIT listing fee. This
// operation fails if your account does not have enough funds to pay for both
// the bonus and the fees.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation SendBonus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/SendBonus
func (c *MTurk) SendBonus(input *SendBonusInput) (*SendBonusOutput, error) {
	req, out := c.SendBonusRequest(input)
	return out, req.Send()
}

// SendBonusWithContext is the same as SendBonus with the addition of
// the ability to pass a context and additional request options.
//
// See SendBonus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) SendBonusWithContext(ctx aws.Context, input *SendBonusInput, opts ...request.Option) (*SendBonusOutput, error) {
	req, out := c.SendBonusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendTestEventNotification = "SendTestEventNotification"

// SendTestEventNotificationRequest generates a "aws/request.Request" representing the
// client's request for the SendTestEventNotification operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendTestEventNotification for more information on using the SendTestEventNotification
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendTestEventNotificationRequest method.
//    req, resp := client.SendTestEventNotificationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/SendTestEventNotification
func (c *MTurk) SendTestEventNotificationRequest(input *SendTestEventNotificationInput) (req *request.Request, output *SendTestEventNotificationOutput) {
	op := &request.Operation{
		Name:       opSendTestEventNotification,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendTestEventNotificationInput{}
	}

	output = &SendTestEventNotificationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SendTestEventNotification API operation for Amazon Mechanical Turk.
//
// The SendTestEventNotification operation causes Amazon Mechanical Turk to
// send a notification message as if a HIT event occurred, according to the
// provided notification specification. This allows you to test notifications
// without setting up notifications for a real HIT type and trying to trigger
// them using the website. When you call this operation, the service attempts
// to send the test notification immediately.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation SendTestEventNotification for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/SendTestEventNotification
func (c *MTurk) SendTestEventNotification(input *SendTestEventNotificationInput) (*SendTestEventNotificationOutput, error) {
	req, out := c.SendTestEventNotificationRequest(input)
	return out, req.Send()
}

// SendTestEventNotificationWithContext is the same as SendTestEventNotification with the addition of
// the ability to pass a context and additional request options.
//
// See SendTestEventNotification for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) SendTestEventNotificationWithContext(ctx aws.Context, input *SendTestEventNotificationInput, opts ...request.Option) (*SendTestEventNotificationOutput, error) {
	req, out := c.SendTestEventNotificationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateExpirationForHIT = "UpdateExpirationForHIT"

// UpdateExpirationForHITRequest generates a "aws/request.Request" representing the
// client's request for the UpdateExpirationForHIT operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateExpirationForHIT for more information on using the UpdateExpirationForHIT
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateExpirationForHITRequest method.
//    req, resp := client.UpdateExpirationForHITRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateExpirationForHIT
func (c *MTurk) UpdateExpirationForHITRequest(input *UpdateExpirationForHITInput) (req *request.Request, output *UpdateExpirationForHITOutput) {
	op := &request.Operation{
		Name:       opUpdateExpirationForHIT,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateExpirationForHITInput{}
	}

	output = &UpdateExpirationForHITOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateExpirationForHIT API operation for Amazon Mechanical Turk.
//
// The UpdateExpirationForHIT operation allows you update the expiration time
// of a HIT. If you update it to a time in the past, the HIT will be immediately
// expired.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation UpdateExpirationForHIT for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateExpirationForHIT
func (c *MTurk) UpdateExpirationForHIT(input *UpdateExpirationForHITInput) (*UpdateExpirationForHITOutput, error) {
	req, out := c.UpdateExpirationForHITRequest(input)
	return out, req.Send()
}

// UpdateExpirationForHITWithContext is the same as UpdateExpirationForHIT with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateExpirationForHIT for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) UpdateExpirationForHITWithContext(ctx aws.Context, input *UpdateExpirationForHITInput, opts ...request.Option) (*UpdateExpirationForHITOutput, error) {
	req, out := c.UpdateExpirationForHITRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateHITReviewStatus = "UpdateHITReviewStatus"

// UpdateHITReviewStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateHITReviewStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateHITReviewStatus for more information on using the UpdateHITReviewStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateHITReviewStatusRequest method.
//    req, resp := client.UpdateHITReviewStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateHITReviewStatus
func (c *MTurk) UpdateHITReviewStatusRequest(input *UpdateHITReviewStatusInput) (req *request.Request, output *UpdateHITReviewStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateHITReviewStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateHITReviewStatusInput{}
	}

	output = &UpdateHITReviewStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateHITReviewStatus API operation for Amazon Mechanical Turk.
//
// The UpdateHITReviewStatus operation updates the status of a HIT. If the status
// is Reviewable, this operation can update the status to Reviewing, or it can
// revert a Reviewing HIT back to the Reviewable status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation UpdateHITReviewStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateHITReviewStatus
func (c *MTurk) UpdateHITReviewStatus(input *UpdateHITReviewStatusInput) (*UpdateHITReviewStatusOutput, error) {
	req, out := c.UpdateHITReviewStatusRequest(input)
	return out, req.Send()
}

// UpdateHITReviewStatusWithContext is the same as UpdateHITReviewStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateHITReviewStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) UpdateHITReviewStatusWithContext(ctx aws.Context, input *UpdateHITReviewStatusInput, opts ...request.Option) (*UpdateHITReviewStatusOutput, error) {
	req, out := c.UpdateHITReviewStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateHITTypeOfHIT = "UpdateHITTypeOfHIT"

// UpdateHITTypeOfHITRequest generates a "aws/request.Request" representing the
// client's request for the UpdateHITTypeOfHIT operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateHITTypeOfHIT for more information on using the UpdateHITTypeOfHIT
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateHITTypeOfHITRequest method.
//    req, resp := client.UpdateHITTypeOfHITRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateHITTypeOfHIT
func (c *MTurk) UpdateHITTypeOfHITRequest(input *UpdateHITTypeOfHITInput) (req *request.Request, output *UpdateHITTypeOfHITOutput) {
	op := &request.Operation{
		Name:       opUpdateHITTypeOfHIT,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateHITTypeOfHITInput{}
	}

	output = &UpdateHITTypeOfHITOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateHITTypeOfHIT API operation for Amazon Mechanical Turk.
//
// The UpdateHITTypeOfHIT operation allows you to change the HITType properties
// of a HIT. This operation disassociates the HIT from its old HITType properties
// and associates it with the new HITType properties. The HIT takes on the properties
// of the new HITType in place of the old ones.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation UpdateHITTypeOfHIT for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateHITTypeOfHIT
func (c *MTurk) UpdateHITTypeOfHIT(input *UpdateHITTypeOfHITInput) (*UpdateHITTypeOfHITOutput, error) {
	req, out := c.UpdateHITTypeOfHITRequest(input)
	return out, req.Send()
}

// UpdateHITTypeOfHITWithContext is the same as UpdateHITTypeOfHIT with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateHITTypeOfHIT for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) UpdateHITTypeOfHITWithContext(ctx aws.Context, input *UpdateHITTypeOfHITInput, opts ...request.Option) (*UpdateHITTypeOfHITOutput, error) {
	req, out := c.UpdateHITTypeOfHITRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNotificationSettings = "UpdateNotificationSettings"

// UpdateNotificationSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNotificationSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNotificationSettings for more information on using the UpdateNotificationSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNotificationSettingsRequest method.
//    req, resp := client.UpdateNotificationSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateNotificationSettings
func (c *MTurk) UpdateNotificationSettingsRequest(input *UpdateNotificationSettingsInput) (req *request.Request, output *UpdateNotificationSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateNotificationSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNotificationSettingsInput{}
	}

	output = &UpdateNotificationSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateNotificationSettings API operation for Amazon Mechanical Turk.
//
// The UpdateNotificationSettings operation creates, updates, disables or re-enables
// notifications for a HIT type. If you call the UpdateNotificationSettings
// operation for a HIT type that already has a notification specification, the
// operation replaces the old specification with a new one. You can call the
// UpdateNotificationSettings operation to enable or disable notifications for
// the HIT type, without having to modify the notification specification itself
// by providing updates to the Active status without specifying a new notification
// specification. To change the Active status of a HIT type's notifications,
// the HIT type must already have a notification specification, or one must
// be provided in the same call to UpdateNotificationSettings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation UpdateNotificationSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateNotificationSettings
func (c *MTurk) UpdateNotificationSettings(input *UpdateNotificationSettingsInput) (*UpdateNotificationSettingsOutput, error) {
	req, out := c.UpdateNotificationSettingsRequest(input)
	return out, req.Send()
}

// UpdateNotificationSettingsWithContext is the same as UpdateNotificationSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNotificationSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) UpdateNotificationSettingsWithContext(ctx aws.Context, input *UpdateNotificationSettingsInput, opts ...request.Option) (*UpdateNotificationSettingsOutput, error) {
	req, out := c.UpdateNotificationSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateQualificationType = "UpdateQualificationType"

// UpdateQualificationTypeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateQualificationType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateQualificationType for more information on using the UpdateQualificationType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateQualificationTypeRequest method.
//    req, resp := client.UpdateQualificationTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateQualificationType
func (c *MTurk) UpdateQualificationTypeRequest(input *UpdateQualificationTypeInput) (req *request.Request, output *UpdateQualificationTypeOutput) {
	op := &request.Operation{
		Name:       opUpdateQualificationType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateQualificationTypeInput{}
	}

	output = &UpdateQualificationTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateQualificationType API operation for Amazon Mechanical Turk.
//
// The UpdateQualificationType operation modifies the attributes of an existing
// Qualification type, which is represented by a QualificationType data structure.
// Only the owner of a Qualification type can modify its attributes.
//
// Most attributes of a Qualification type can be changed after the type has
// been created. However, the Name and Keywords fields cannot be modified. The
// RetryDelayInSeconds parameter can be modified or added to change the delay
// or to enable retries, but RetryDelayInSeconds cannot be used to disable retries.
//
// You can use this operation to update the test for a Qualification type. The
// test is updated based on the values specified for the Test, TestDurationInSeconds
// and AnswerKey parameters. All three parameters specify the updated test.
// If you are updating the test for a type, you must specify the Test and TestDurationInSeconds
// parameters. The AnswerKey parameter is optional; omitting it specifies that
// the updated test does not have an answer key.
//
// If you omit the Test parameter, the test for the Qualification type is unchanged.
// There is no way to remove a test from a Qualification type that has one.
// If the type already has a test, you cannot update it to be AutoGranted. If
// the Qualification type does not have a test and one is provided by an update,
// the type will henceforth have a test.
//
// If you want to update the test duration or answer key for an existing test
// without changing the questions, you must specify a Test parameter with the
// original questions, along with the updated values.
//
// If you provide an updated Test but no AnswerKey, the new test will not have
// an answer key. Requests for such Qualifications must be granted manually.
//
// You can also update the AutoGranted and AutoGrantedValue attributes of the
// Qualification type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Mechanical Turk's
// API operation UpdateQualificationType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFault "ServiceFault"
//   Amazon Mechanical Turk is temporarily unable to process your request. Try
//   your call again.
//
//   * ErrCodeRequestError "RequestError"
//   Your request is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateQualificationType
func (c *MTurk) UpdateQualificationType(input *UpdateQualificationTypeInput) (*UpdateQualificationTypeOutput, error) {
	req, out := c.UpdateQualificationTypeRequest(input)
	return out, req.Send()
}

// UpdateQualificationTypeWithContext is the same as UpdateQualificationType with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateQualificationType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MTurk) UpdateQualificationTypeWithContext(ctx aws.Context, input *UpdateQualificationTypeInput, opts ...request.Option) (*UpdateQualificationTypeOutput, error) {
	req, out := c.UpdateQualificationTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptQualificationRequestInput struct {
	_ struct{} `type:"structure"`

	// The value of the Qualification. You can omit this value if you are using
	// the presence or absence of the Qualification as the basis for a HIT requirement.
	IntegerValue *int64 `type:"integer"`

	// The ID of the Qualification request, as returned by the GetQualificationRequests
	// operation.
	//
	// QualificationRequestId is a required field
	QualificationRequestId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AcceptQualificationRequestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptQualificationRequestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptQualificationRequestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptQualificationRequestInput"}
	if s.QualificationRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("QualificationRequestId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIntegerValue sets the IntegerValue field's value.
func (s *AcceptQualificationRequestInput) SetIntegerValue(v int64) *AcceptQualificationRequestInput {
	s.IntegerValue = &v
	return s
}

// SetQualificationRequestId sets the QualificationRequestId field's value.
func (s *AcceptQualificationRequestInput) SetQualificationRequestId(v string) *AcceptQualificationRequestInput {
	s.QualificationRequestId = &v
	return s
}

type AcceptQualificationRequestOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AcceptQualificationRequestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptQualificationRequestOutput) GoString() string {
	return s.String()
}

type ApproveAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the assignment. The assignment must correspond to a HIT created
	// by the Requester.
	//
	// AssignmentId is a required field
	AssignmentId *string `min:"1" type:"string" required:"true"`

	// A flag indicating that an assignment should be approved even if it was previously
	// rejected. Defaults to False.
	OverrideRejection *bool `type:"boolean"`

	// A message for the Worker, which the Worker can see in the Status section
	// of the web site.
	RequesterFeedback *string `type:"string"`
}

// String returns the string representation
func (s ApproveAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApproveAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApproveAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApproveAssignmentInput"}
	if s.AssignmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentId"))
	}
	if s.AssignmentId != nil && len(*s.AssignmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentId sets the AssignmentId field's value.
func (s *ApproveAssignmentInput) SetAssignmentId(v string) *ApproveAssignmentInput {
	s.AssignmentId = &v
	return s
}

// SetOverrideRejection sets the OverrideRejection field's value.
func (s *ApproveAssignmentInput) SetOverrideRejection(v bool) *ApproveAssignmentInput {
	s.OverrideRejection = &v
	return s
}

// SetRequesterFeedback sets the RequesterFeedback field's value.
func (s *ApproveAssignmentInput) SetRequesterFeedback(v string) *ApproveAssignmentInput {
	s.RequesterFeedback = &v
	return s
}

type ApproveAssignmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ApproveAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApproveAssignmentOutput) GoString() string {
	return s.String()
}

// The Assignment data structure represents a single assignment of a HIT to
// a Worker. The assignment tracks the Worker's efforts to complete the HIT,
// and contains the results for later retrieval.
type Assignment struct {
	_ struct{} `type:"structure"`

	// The date and time the Worker accepted the assignment.
	AcceptTime *time.Time `type:"timestamp"`

	// The Worker's answers submitted for the HIT contained in a QuestionFormAnswers
	// document, if the Worker provides an answer. If the Worker does not provide
	// any answers, Answer may contain a QuestionFormAnswers document, or Answer
	// may be empty.
	Answer *string `type:"string"`

	// If the Worker has submitted results and the Requester has approved the results,
	// ApprovalTime is the date and time the Requester approved the results. This
	// value is omitted from the assignment if the Requester has not yet approved
	// the results.
	ApprovalTime *time.Time `type:"timestamp"`

	// A unique identifier for the assignment.
	AssignmentId *string `min:"1" type:"string"`

	// The status of the assignment.
	AssignmentStatus *string `type:"string" enum:"AssignmentStatus"`

	// If results have been submitted, AutoApprovalTime is the date and time the
	// results of the assignment results are considered Approved automatically if
	// they have not already been explicitly approved or rejected by the Requester.
	// This value is derived from the auto-approval delay specified by the Requester
	// in the HIT. This value is omitted from the assignment if the Worker has not
	// yet submitted results.
	AutoApprovalTime *time.Time `type:"timestamp"`

	// The date and time of the deadline for the assignment. This value is derived
	// from the deadline specification for the HIT and the date and time the Worker
	// accepted the HIT.
	Deadline *time.Time `type:"timestamp"`

	// The ID of the HIT.
	HITId *string `min:"1" type:"string"`

	// If the Worker has submitted results and the Requester has rejected the results,
	// RejectionTime is the date and time the Requester rejected the results.
	RejectionTime *time.Time `type:"timestamp"`

	// The feedback string included with the call to the ApproveAssignment operation
	// or the RejectAssignment operation, if the Requester approved or rejected
	// the assignment and specified feedback.
	RequesterFeedback *string `type:"string"`

	// If the Worker has submitted results, SubmitTime is the date and time the
	// assignment was submitted. This value is omitted from the assignment if the
	// Worker has not yet submitted results.
	SubmitTime *time.Time `type:"timestamp"`

	// The ID of the Worker who accepted the HIT.
	WorkerId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Assignment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Assignment) GoString() string {
	return s.String()
}

// SetAcceptTime sets the AcceptTime field's value.
func (s *Assignment) SetAcceptTime(v time.Time) *Assignment {
	s.AcceptTime = &v
	return s
}

// SetAnswer sets the Answer field's value.
func (s *Assignment) SetAnswer(v string) *Assignment {
	s.Answer = &v
	return s
}

// SetApprovalTime sets the ApprovalTime field's value.
func (s *Assignment) SetApprovalTime(v time.Time) *Assignment {
	s.ApprovalTime = &v
	return s
}

// SetAssignmentId sets the AssignmentId field's value.
func (s *Assignment) SetAssignmentId(v string) *Assignment {
	s.AssignmentId = &v
	return s
}

// SetAssignmentStatus sets the AssignmentStatus field's value.
func (s *Assignment) SetAssignmentStatus(v string) *Assignment {
	s.AssignmentStatus = &v
	return s
}

// SetAutoApprovalTime sets the AutoApprovalTime field's value.
func (s *Assignment) SetAutoApprovalTime(v time.Time) *Assignment {
	s.AutoApprovalTime = &v
	return s
}

// SetDeadline sets the Deadline field's value.
func (s *Assignment) SetDeadline(v time.Time) *Assignment {
	s.Deadline = &v
	return s
}

// SetHITId sets the HITId field's value.
func (s *Assignment) SetHITId(v string) *Assignment {
	s.HITId = &v
	return s
}

// SetRejectionTime sets the RejectionTime field's value.
func (s *Assignment) SetRejectionTime(v time.Time) *Assignment {
	s.RejectionTime = &v
	return s
}

// SetRequesterFeedback sets the RequesterFeedback field's value.
func (s *Assignment) SetRequesterFeedback(v string) *Assignment {
	s.RequesterFeedback = &v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *Assignment) SetSubmitTime(v time.Time) *Assignment {
	s.SubmitTime = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *Assignment) SetWorkerId(v string) *Assignment {
	s.WorkerId = &v
	return s
}

type AssociateQualificationWithWorkerInput struct {
	_ struct{} `type:"structure"`

	// The value of the Qualification to assign.
	IntegerValue *int64 `type:"integer"`

	// The ID of the Qualification type to use for the assigned Qualification.
	//
	// QualificationTypeId is a required field
	QualificationTypeId *string `min:"1" type:"string" required:"true"`

	// Specifies whether to send a notification email message to the Worker saying
	// that the qualification was assigned to the Worker. Note: this is true by
	// default.
	SendNotification *bool `type:"boolean"`

	// The ID of the Worker to whom the Qualification is being assigned. Worker
	// IDs are included with submitted HIT assignments and Qualification requests.
	//
	// WorkerId is a required field
	WorkerId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateQualificationWithWorkerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateQualificationWithWorkerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateQualificationWithWorkerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateQualificationWithWorkerInput"}
	if s.QualificationTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("QualificationTypeId"))
	}
	if s.QualificationTypeId != nil && len(*s.QualificationTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QualificationTypeId", 1))
	}
	if s.WorkerId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerId"))
	}
	if s.WorkerId != nil && len(*s.WorkerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIntegerValue sets the IntegerValue field's value.
func (s *AssociateQualificationWithWorkerInput) SetIntegerValue(v int64) *AssociateQualificationWithWorkerInput {
	s.IntegerValue = &v
	return s
}

// SetQualificationTypeId sets the QualificationTypeId field's value.
func (s *AssociateQualificationWithWorkerInput) SetQualificationTypeId(v string) *AssociateQualificationWithWorkerInput {
	s.QualificationTypeId = &v
	return s
}

// SetSendNotification sets the SendNotification field's value.
func (s *AssociateQualificationWithWorkerInput) SetSendNotification(v bool) *AssociateQualificationWithWorkerInput {
	s.SendNotification = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *AssociateQualificationWithWorkerInput) SetWorkerId(v string) *AssociateQualificationWithWorkerInput {
	s.WorkerId = &v
	return s
}

type AssociateQualificationWithWorkerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateQualificationWithWorkerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateQualificationWithWorkerOutput) GoString() string {
	return s.String()
}

// An object representing a Bonus payment paid to a Worker.
type BonusPayment struct {
	_ struct{} `type:"structure"`

	// The ID of the assignment associated with this bonus payment.
	AssignmentId *string `min:"1" type:"string"`

	// A string representing a currency amount.
	BonusAmount *string `type:"string"`

	// The date and time of when the bonus was granted.
	GrantTime *time.Time `type:"timestamp"`

	// The Reason text given when the bonus was granted, if any.
	Reason *string `type:"string"`

	// The ID of the Worker to whom the bonus was paid.
	WorkerId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BonusPayment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BonusPayment) GoString() string {
	return s.String()
}

// SetAssignmentId sets the AssignmentId field's value.
func (s *BonusPayment) SetAssignmentId(v string) *BonusPayment {
	s.AssignmentId = &v
	return s
}

// SetBonusAmount sets the BonusAmount field's value.
func (s *BonusPayment) SetBonusAmount(v string) *BonusPayment {
	s.BonusAmount = &v
	return s
}

// SetGrantTime sets the GrantTime field's value.
func (s *BonusPayment) SetGrantTime(v time.Time) *BonusPayment {
	s.GrantTime = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *BonusPayment) SetReason(v string) *BonusPayment {
	s.Reason = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *BonusPayment) SetWorkerId(v string) *BonusPayment {
	s.WorkerId = &v
	return s
}

type CreateAdditionalAssignmentsForHITInput struct {
	_ struct{} `type:"structure"`

	// The ID of the HIT to extend.
	//
	// HITId is a required field
	HITId *string `min:"1" type:"string" required:"true"`

	// The number of additional assignments to request for this HIT.
	//
	// NumberOfAdditionalAssignments is a required field
	NumberOfAdditionalAssignments *int64 `type:"integer" required:"true"`

	// A unique identifier for this request, which allows you to retry the call
	// on error without extending the HIT multiple times. This is useful in cases
	// such as network timeouts where it is unclear whether or not the call succeeded
	// on the server. If the extend HIT already exists in the system from a previous
	// call using the same UniqueRequestToken, subsequent calls will return an error
	// with a message containing the request ID.
	UniqueRequestToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateAdditionalAssignmentsForHITInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAdditionalAssignmentsForHITInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAdditionalAssignmentsForHITInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAdditionalAssignmentsForHITInput"}
	if s.HITId == nil {
		invalidParams.Add(request.NewErrParamRequired("HITId"))
	}
	if s.HITId != nil && len(*s.HITId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HITId", 1))
	}
	if s.NumberOfAdditionalAssignments == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfAdditionalAssignments"))
	}
	if s.UniqueRequestToken != nil && len(*s.UniqueRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UniqueRequestToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHITId sets the HITId field's value.
func (s *CreateAdditionalAssignmentsForHITInput) SetHITId(v string) *CreateAdditionalAssignmentsForHITInput {
	s.HITId = &v
	return s
}

// SetNumberOfAdditionalAssignments sets the NumberOfAdditionalAssignments field's value.
func (s *CreateAdditionalAssignmentsForHITInput) SetNumberOfAdditionalAssignments(v int64) *CreateAdditionalAssignmentsForHITInput {
	s.NumberOfAdditionalAssignments = &v
	return s
}

// SetUniqueRequestToken sets the UniqueRequestToken field's value.
func (s *CreateAdditionalAssignmentsForHITInput) SetUniqueRequestToken(v string) *CreateAdditionalAssignmentsForHITInput {
	s.UniqueRequestToken = &v
	return s
}

type CreateAdditionalAssignmentsForHITOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAdditionalAssignmentsForHITOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAdditionalAssignmentsForHITOutput) GoString() string {
	return s.String()
}

type CreateHITInput struct {
	_ struct{} `type:"structure"`

	// The amount of time, in seconds, that a Worker has to complete the HIT after
	// accepting it. If a Worker does not complete the assignment within the specified
	// duration, the assignment is considered abandoned. If the HIT is still active
	// (that is, its lifetime has not elapsed), the assignment becomes available
	// for other users to find and accept.
	//
	// AssignmentDurationInSeconds is a required field
	AssignmentDurationInSeconds *int64 `type:"long" required:"true"`

	// The Assignment-level Review Policy applies to the assignments under the HIT.
	// You can specify for Mechanical Turk to take various actions based on the
	// policy.
	AssignmentReviewPolicy *ReviewPolicy `type:"structure"`

	// The number of seconds after an assignment for the HIT has been submitted,
	// after which the assignment is considered Approved automatically unless the
	// Requester explicitly rejects it.
	AutoApprovalDelayInSeconds *int64 `type:"long"`

	// A general description of the HIT. A description includes detailed information
	// about the kind of task the HIT contains. On the Amazon Mechanical Turk web
	// site, the HIT description appears in the expanded view of search results,
	// and in the HIT and assignment screens. A good description gives the user
	// enough information to evaluate the HIT before accepting it.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The HITLayoutId allows you to use a pre-existing HIT design with placeholder
	// values and create an additional HIT by providing those values as HITLayoutParameters.
	//
	// Constraints: Either a Question parameter or a HITLayoutId parameter must
	// be provided.
	HITLayoutId *string `min:"1" type:"string"`

	// If the HITLayoutId is provided, any placeholder values must be filled in
	// with values using the HITLayoutParameter structure. For more information,
	// see HITLayout.
	HITLayoutParameters []*HITLayoutParameter `type:"list"`

	// The HIT-level Review Policy applies to the HIT. You can specify for Mechanical
	// Turk to take various actions based on the policy.
	HITReviewPolicy *ReviewPolicy `type:"structure"`

	// One or more words or phrases that describe the HIT, separated by commas.
	// These words are used in searches to find HITs.
	Keywords *string `type:"string"`

	// An amount of time, in seconds, after which the HIT is no longer available
	// for users to accept. After the lifetime of the HIT elapses, the HIT no longer
	// appears in HIT searches, even if not all of the assignments for the HIT have
	// been accepted.
	//
	// LifetimeInSeconds is a required field
	LifetimeInSeconds *int64 `type:"long" required:"true"`

	// The number of times the HIT can be accepted and completed before the HIT
	// becomes unavailable.
	MaxAssignments *int64 `type:"integer"`

	// Conditions that a Worker's Qualifications must meet in order to accept the
	// HIT. A HIT can have between zero and ten Qualification requirements. All
	// requirements must be met in order for a Worker to accept the HIT. Additionally,
	// other actions can be restricted using the ActionsGuarded field on each QualificationRequirement
	// structure.
	QualificationRequirements []*QualificationRequirement `type:"list"`

	// The data the person completing the HIT uses to produce the results.
	//
	// Constraints: Must be a QuestionForm data structure, an ExternalQuestion data
	// structure, or an HTMLQuestion data structure. The XML question data must
	// not be larger than 64 kilobytes (65,535 bytes) in size, including whitespace.
	//
	// Either a Question parameter or a HITLayoutId parameter must be provided.
	Question *string `type:"string"`

	// An arbitrary data field. The RequesterAnnotation parameter lets your application
	// attach arbitrary data to the HIT for tracking purposes. For example, this
	// parameter could be an identifier internal to the Requester's application
	// that corresponds with the HIT.
	//
	// The RequesterAnnotation parameter for a HIT is only visible to the Requester
	// who created the HIT. It is not shown to the Worker, or any other Requester.
	//
	// The RequesterAnnotation parameter may be different for each HIT you submit.
	// It does not affect how your HITs are grouped.
	RequesterAnnotation *string `type:"string"`

	// The amount of money the Requester will pay a Worker for successfully completing
	// the HIT.
	//
	// Reward is a required field
	Reward *string `type:"string" required:"true"`

	// The title of the HIT. A title should be short and descriptive about the kind
	// of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT
	// title appears in search results, and everywhere the HIT is mentioned.
	//
	// Title is a required field
	Title *string `type:"string" required:"true"`

	// A unique identifier for this request which allows you to retry the call on
	// error without creating duplicate HITs. This is useful in cases such as network
	// timeouts where it is unclear whether or not the call succeeded on the server.
	// If the HIT already exists in the system from a previous call using the same
	// UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists
	// error with a message containing the HITId.
	//
	// Note: It is your responsibility to ensure uniqueness of the token. The unique
	// token expires after 24 hours. Subsequent calls using the same UniqueRequestToken
	// made after the 24 hour limit could create duplicate HITs.
	UniqueRequestToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateHITInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHITInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHITInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHITInput"}
	if s.AssignmentDurationInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentDurationInSeconds"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.HITLayoutId != nil && len(*s.HITLayoutId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HITLayoutId", 1))
	}
	if s.LifetimeInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("LifetimeInSeconds"))
	}
	if s.Reward == nil {
		invalidParams.Add(request.NewErrParamRequired("Reward"))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}
	if s.UniqueRequestToken != nil && len(*s.UniqueRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UniqueRequestToken", 1))
	}
	if s.AssignmentReviewPolicy != nil {
		if err := s.AssignmentReviewPolicy.Validate(); err != nil {
			invalidParams.AddNested("AssignmentReviewPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.HITLayoutParameters != nil {
		for i, v := range s.HITLayoutParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HITLayoutParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.HITReviewPolicy != nil {
		if err := s.HITReviewPolicy.Validate(); err != nil {
			invalidParams.AddNested("HITReviewPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.QualificationRequirements != nil {
		for i, v := range s.QualificationRequirements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "QualificationRequirements", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentDurationInSeconds sets the AssignmentDurationInSeconds field's value.
func (s *CreateHITInput) SetAssignmentDurationInSeconds(v int64) *CreateHITInput {
	s.AssignmentDurationInSeconds = &v
	return s
}

// SetAssignmentReviewPolicy sets the AssignmentReviewPolicy field's value.
func (s *CreateHITInput) SetAssignmentReviewPolicy(v *ReviewPolicy) *CreateHITInput {
	s.AssignmentReviewPolicy = v
	return s
}

// SetAutoApprovalDelayInSeconds sets the AutoApprovalDelayInSeconds field's value.
func (s *CreateHITInput) SetAutoApprovalDelayInSeconds(v int64) *CreateHITInput {
	s.AutoApprovalDelayInSeconds = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateHITInput) SetDescription(v string) *CreateHITInput {
	s.Description = &v
	return s
}

// SetHITLayoutId sets the HITLayoutId field's value.
func (s *CreateHITInput) SetHITLayoutId(v string) *CreateHITInput {
	s.HITLayoutId = &v
	return s
}

// SetHITLayoutParameters sets the HITLayoutParameters field's value.
func (s *CreateHITInput) SetHITLayoutParameters(v []*HITLayoutParameter) *CreateHITInput {
	s.HITLayoutParameters = v
	return s
}

// SetHITReviewPolicy sets the HITReviewPolicy field's value.
func (s *CreateHITInput) SetHITReviewPolicy(v *ReviewPolicy) *CreateHITInput {
	s.HITReviewPolicy = v
	return s
}

// SetKeywords sets the Keywords field's value.
func (s *CreateHITInput) SetKeywords(v string) *CreateHITInput {
	s.Keywords = &v
	return s
}

// SetLifetimeInSeconds sets the LifetimeInSeconds field's value.
func (s *CreateHITInput) SetLifetimeInSeconds(v int64) *CreateHITInput {
	s.LifetimeInSeconds = &v
	return s
}

// SetMaxAssignments sets the MaxAssignments field's value.
func (s *CreateHITInput) SetMaxAssignments(v int64) *CreateHITInput {
	s.MaxAssignments = &v
	return s
}

// SetQualificationRequirements sets the QualificationRequirements field's value.
func (s *CreateHITInput) SetQualificationRequirements(v []*QualificationRequirement) *CreateHITInput {
	s.QualificationRequirements = v
	return s
}

// SetQuestion sets the Question field's value.
func (s *CreateHITInput) SetQuestion(v string) *CreateHITInput {
	s.Question = &v
	return s
}

// SetRequesterAnnotation sets the RequesterAnnotation field's value.
func (s *CreateHITInput) SetRequesterAnnotation(v string) *CreateHITInput {
	s.RequesterAnnotation = &v
	return s
}

// SetReward sets the Reward field's value.
func (s *CreateHITInput) SetReward(v string) *CreateHITInput {
	s.Reward = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *CreateHITInput) SetTitle(v string) *CreateHITInput {
	s.Title = &v
	return s
}

// SetUniqueRequestToken sets the UniqueRequestToken field's value.
func (s *CreateHITInput) SetUniqueRequestToken(v string) *CreateHITInput {
	s.UniqueRequestToken = &v
	return s
}

type CreateHITOutput struct {
	_ struct{} `type:"structure"`

	// Contains the newly created HIT data. For a description of the HIT data structure
	// as it appears in responses, see the HIT Data Structure documentation.
	HIT *HIT `type:"structure"`
}

// String returns the string representation
func (s CreateHITOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHITOutput) GoString() string {
	return s.String()
}

// SetHIT sets the HIT field's value.
func (s *CreateHITOutput) SetHIT(v *HIT) *CreateHITOutput {
	s.HIT = v
	return s
}

type CreateHITTypeInput struct {
	_ struct{} `type:"structure"`

	// The amount of time, in seconds, that a Worker has to complete the HIT after
	// accepting it. If a Worker does not complete the assignment within the specified
	// duration, the assignment is considered abandoned. If the HIT is still active
	// (that is, its lifetime has not elapsed), the assignment becomes available
	// for other users to find and accept.
	//
	// AssignmentDurationInSeconds is a required field
	AssignmentDurationInSeconds *int64 `type:"long" required:"true"`

	// The number of seconds after an assignment for the HIT has been submitted,
	// after which the assignment is considered Approved automatically unless the
	// Requester explicitly rejects it.
	AutoApprovalDelayInSeconds *int64 `type:"long"`

	// A general description of the HIT. A description includes detailed information
	// about the kind of task the HIT contains. On the Amazon Mechanical Turk web
	// site, the HIT description appears in the expanded view of search results,
	// and in the HIT and assignment screens. A good description gives the user
	// enough information to evaluate the HIT before accepting it.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// One or more words or phrases that describe the HIT, separated by commas.
	// These words are used in searches to find HITs.
	Keywords *string `type:"string"`

	// Conditions that a Worker's Qualifications must meet in order to accept the
	// HIT. A HIT can have between zero and ten Qualification requirements. All
	// requirements must be met in order for a Worker to accept the HIT. Additionally,
	// other actions can be restricted using the ActionsGuarded field on each QualificationRequirement
	// structure.
	QualificationRequirements []*QualificationRequirement `type:"list"`

	// The amount of money the Requester will pay a Worker for successfully completing
	// the HIT.
	//
	// Reward is a required field
	Reward *string `type:"string" required:"true"`

	// The title of the HIT. A title should be short and descriptive about the kind
	// of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT
	// title appears in search results, and everywhere the HIT is mentioned.
	//
	// Title is a required field
	Title *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateHITTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHITTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHITTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHITTypeInput"}
	if s.AssignmentDurationInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentDurationInSeconds"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Reward == nil {
		invalidParams.Add(request.NewErrParamRequired("Reward"))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}
	if s.QualificationRequirements != nil {
		for i, v := range s.QualificationRequirements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "QualificationRequirements", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentDurationInSeconds sets the AssignmentDurationInSeconds field's value.
func (s *CreateHITTypeInput) SetAssignmentDurationInSeconds(v int64) *CreateHITTypeInput {
	s.AssignmentDurationInSeconds = &v
	return s
}

// SetAutoApprovalDelayInSeconds sets the AutoApprovalDelayInSeconds field's value.
func (s *CreateHITTypeInput) SetAutoApprovalDelayInSeconds(v int64) *CreateHITTypeInput {
	s.AutoApprovalDelayInSeconds = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateHITTypeInput) SetDescription(v string) *CreateHITTypeInput {
	s.Description = &v
	return s
}

// SetKeywords sets the Keywords field's value.
func (s *CreateHITTypeInput) SetKeywords(v string) *CreateHITTypeInput {
	s.Keywords = &v
	return s
}

// SetQualificationRequirements sets the QualificationRequirements field's value.
func (s *CreateHITTypeInput) SetQualificationRequirements(v []*QualificationRequirement) *CreateHITTypeInput {
	s.QualificationRequirements = v
	return s
}

// SetReward sets the Reward field's value.
func (s *CreateHITTypeInput) SetReward(v string) *CreateHITTypeInput {
	s.Reward = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *CreateHITTypeInput) SetTitle(v string) *CreateHITTypeInput {
	s.Title = &v
	return s
}

type CreateHITTypeOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the newly registered HIT type.
	HITTypeId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateHITTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHITTypeOutput) GoString() string {
	return s.String()
}

// SetHITTypeId sets the HITTypeId field's value.
func (s *CreateHITTypeOutput) SetHITTypeId(v string) *CreateHITTypeOutput {
	s.HITTypeId = &v
	return s
}

type CreateHITWithHITTypeInput struct {
	_ struct{} `type:"structure"`

	// The Assignment-level Review Policy applies to the assignments under the HIT.
	// You can specify for Mechanical Turk to take various actions based on the
	// policy.
	AssignmentReviewPolicy *ReviewPolicy `type:"structure"`

	// The HITLayoutId allows you to use a pre-existing HIT design with placeholder
	// values and create an additional HIT by providing those values as HITLayoutParameters.
	//
	// Constraints: Either a Question parameter or a HITLayoutId parameter must
	// be provided.
	HITLayoutId *string `min:"1" type:"string"`

	// If the HITLayoutId is provided, any placeholder values must be filled in
	// with values using the HITLayoutParameter structure. For more information,
	// see HITLayout.
	HITLayoutParameters []*HITLayoutParameter `type:"list"`

	// The HIT-level Review Policy applies to the HIT. You can specify for Mechanical
	// Turk to take various actions based on the policy.
	HITReviewPolicy *ReviewPolicy `type:"structure"`

	// The HIT type ID you want to create this HIT with.
	//
	// HITTypeId is a required field
	HITTypeId *string `min:"1" type:"string" required:"true"`

	// An amount of time, in seconds, after which the HIT is no longer available
	// for users to accept. After the lifetime of the HIT elapses, the HIT no longer
	// appears in HIT searches, even if not all of the assignments for the HIT have
	// been accepted.
	//
	// LifetimeInSeconds is a required field
	LifetimeInSeconds *int64 `type:"long" required:"true"`

	// The number of times the HIT can be accepted and completed before the HIT
	// becomes unavailable.
	MaxAssignments *int64 `type:"integer"`

	// The data the person completing the HIT uses to produce the results.
	//
	// Constraints: Must be a QuestionForm data structure, an ExternalQuestion data
	// structure, or an HTMLQuestion data structure. The XML question data must
	// not be larger than 64 kilobytes (65,535 bytes) in size, including whitespace.
	//
	// Either a Question parameter or a HITLayoutId parameter must be provided.
	Question *string `type:"string"`

	// An arbitrary data field. The RequesterAnnotation parameter lets your application
	// attach arbitrary data to the HIT for tracking purposes. For example, this
	// parameter could be an identifier internal to the Requester's application
	// that corresponds with the HIT.
	//
	// The RequesterAnnotation parameter for a HIT is only visible to the Requester
	// who created the HIT. It is not shown to the Worker, or any other Requester.
	//
	// The RequesterAnnotation parameter may be different for each HIT you submit.
	// It does not affect how your HITs are grouped.
	RequesterAnnotation *string `type:"string"`

	// A unique identifier for this request which allows you to retry the call on
	// error without creating duplicate HITs. This is useful in cases such as network
	// timeouts where it is unclear whether or not the call succeeded on the server.
	// If the HIT already exists in the system from a previous call using the same
	// UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists
	// error with a message containing the HITId.
	//
	// Note: It is your responsibility to ensure uniqueness of the token. The unique
	// token expires after 24 hours. Subsequent calls using the same UniqueRequestToken
	// made after the 24 hour limit could create duplicate HITs.
	UniqueRequestToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateHITWithHITTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHITWithHITTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHITWithHITTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHITWithHITTypeInput"}
	if s.HITLayoutId != nil && len(*s.HITLayoutId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HITLayoutId", 1))
	}
	if s.HITTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("HITTypeId"))
	}
	if s.HITTypeId != nil && len(*s.HITTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HITTypeId", 1))
	}
	if s.LifetimeInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("LifetimeInSeconds"))
	}
	if s.UniqueRequestToken != nil && len(*s.UniqueRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UniqueRequestToken", 1))
	}
	if s.AssignmentReviewPolicy != nil {
		if err := s.AssignmentReviewPolicy.Validate(); err != nil {
			invalidParams.AddNested("AssignmentReviewPolicy", err.(request.ErrInvalidParams))
		}
	}
	if s.HITLayoutParameters != nil {
		for i, v := range s.HITLayoutParameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HITLayoutParameters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.HITReviewPolicy != nil {
		if err := s.HITReviewPolicy.Validate(); err != nil {
			invalidParams.AddNested("HITReviewPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentReviewPolicy sets the AssignmentReviewPolicy field's value.
func (s *CreateHITWithHITTypeInput) SetAssignmentReviewPolicy(v *ReviewPolicy) *CreateHITWithHITTypeInput {
	s.AssignmentReviewPolicy = v
	return s
}

// SetHITLayoutId sets the HITLayoutId field's value.
func (s *CreateHITWithHITTypeInput) SetHITLayoutId(v string) *CreateHITWithHITTypeInput {
	s.HITLayoutId = &v
	return s
}

// SetHITLayoutParameters sets the HITLayoutParameters field's value.
func (s *CreateHITWithHITTypeInput) SetHITLayoutParameters(v []*HITLayoutParameter) *CreateHITWithHITTypeInput {
	s.HITLayoutParameters = v
	return s
}

// SetHITReviewPolicy sets the HITReviewPolicy field's value.
func (s *CreateHITWithHITTypeInput) SetHITReviewPolicy(v *ReviewPolicy) *CreateHITWithHITTypeInput {
	s.HITReviewPolicy = v
	return s
}

// SetHITTypeId sets the HITTypeId field's value.
func (s *CreateHITWithHITTypeInput) SetHITTypeId(v string) *CreateHITWithHITTypeInput {
	s.HITTypeId = &v
	return s
}

// SetLifetimeInSeconds sets the LifetimeInSeconds field's value.
func (s *CreateHITWithHITTypeInput) SetLifetimeInSeconds(v int64) *CreateHITWithHITTypeInput {
	s.LifetimeInSeconds = &v
	return s
}

// SetMaxAssignments sets the MaxAssignments field's value.
func (s *CreateHITWithHITTypeInput) SetMaxAssignments(v int64) *CreateHITWithHITTypeInput {
	s.MaxAssignments = &v
	return s
}

// SetQuestion sets the Question field's value.
func (s *CreateHITWithHITTypeInput) SetQuestion(v string) *CreateHITWithHITTypeInput {
	s.Question = &v
	return s
}

// SetRequesterAnnotation sets the RequesterAnnotation field's value.
func (s *CreateHITWithHITTypeInput) SetRequesterAnnotation(v string) *CreateHITWithHITTypeInput {
	s.RequesterAnnotation = &v
	return s
}

// SetUniqueRequestToken sets the UniqueRequestToken field's value.
func (s *CreateHITWithHITTypeInput) SetUniqueRequestToken(v string) *CreateHITWithHITTypeInput {
	s.UniqueRequestToken = &v
	return s
}

type CreateHITWithHITTypeOutput struct {
	_ struct{} `type:"structure"`

	// Contains the newly created HIT data. For a description of the HIT data structure
	// as it appears in responses, see the HIT Data Structure documentation.
	HIT *HIT `type:"structure"`
}

// String returns the string representation
func (s CreateHITWithHITTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHITWithHITTypeOutput) GoString() string {
	return s.String()
}

// SetHIT sets the HIT field's value.
func (s *CreateHITWithHITTypeOutput) SetHIT(v *HIT) *CreateHITWithHITTypeOutput {
	s.HIT = v
	return s
}

type CreateQualificationTypeInput struct {
	_ struct{} `type:"structure"`

	// The answers to the Qualification test specified in the Test parameter, in
	// the form of an AnswerKey data structure.
	//
	// Constraints: Must not be longer than 65535 bytes.
	//
	// Constraints: None. If not specified, you must process Qualification requests
	// manually.
	AnswerKey *string `type:"string"`

	// Specifies whether requests for the Qualification type are granted immediately,
	// without prompting the Worker with a Qualification test.
	//
	// Constraints: If the Test parameter is specified, this parameter cannot be
	// true.
	AutoGranted *bool `type:"boolean"`

	// The Qualification value to use for automatically granted Qualifications.
	// This parameter is used only if the AutoGranted parameter is true.
	AutoGrantedValue *int64 `type:"integer"`

	// A long description for the Qualification type. On the Amazon Mechanical Turk
	// website, the long description is displayed when a Worker examines a Qualification
	// type.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// One or more words or phrases that describe the Qualification type, separated
	// by commas. The keywords of a type make the type easier to find during a search.
	Keywords *string `type:"string"`

	// The name you give to the Qualification type. The type name is used to represent
	// the Qualification to Workers, and to find the type using a Qualification
	// type search. It must be unique across all of your Qualification types.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The initial status of the Qualification type.
	//
	// Constraints: Valid values are: Active | Inactive
	//
	// QualificationTypeStatus is a required field
	QualificationTypeStatus *string `type:"string" required:"true" enum:"QualificationTypeStatus"`

	// The number of seconds that a Worker must wait after requesting a Qualification
	// of the Qualification type before the worker can retry the Qualification request.
	//
	// Constraints: None. If not specified, retries are disabled and Workers can
	// request a Qualification of this type only once, even if the Worker has not
	// been granted the Qualification. It is not possible to disable retries for
	// a Qualification type after it has been created with retries enabled. If you
	// want to disable retries, you must delete existing retry-enabled Qualification
	// type and then create a new Qualification type with retries disabled.
	RetryDelayInSeconds *int64 `type:"long"`

	// The questions for the Qualification test a Worker must answer correctly to
	// obtain a Qualification of this type. If this parameter is specified, TestDurationInSeconds
	// must also be specified.
	//
	// Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm
	// data structure. This parameter cannot be specified if AutoGranted is true.
	//
	// Constraints: None. If not specified, the Worker may request the Qualification
	// without answering any questions.
	Test *string `type:"string"`

	// The number of seconds the Worker has to complete the Qualification test,
	// starting from the time the Worker requests the Qualification.
	TestDurationInSeconds *int64 `type:"long"`
}

// String returns the string representation
func (s CreateQualificationTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateQualificationTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateQualificationTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateQualificationTypeInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.QualificationTypeStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("QualificationTypeStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnswerKey sets the AnswerKey field's value.
func (s *CreateQualificationTypeInput) SetAnswerKey(v string) *CreateQualificationTypeInput {
	s.AnswerKey = &v
	return s
}

// SetAutoGranted sets the AutoGranted field's value.
func (s *CreateQualificationTypeInput) SetAutoGranted(v bool) *CreateQualificationTypeInput {
	s.AutoGranted = &v
	return s
}

// SetAutoGrantedValue sets the AutoGrantedValue field's value.
func (s *CreateQualificationTypeInput) SetAutoGrantedValue(v int64) *CreateQualificationTypeInput {
	s.AutoGrantedValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateQualificationTypeInput) SetDescription(v string) *CreateQualificationTypeInput {
	s.Description = &v
	return s
}

// SetKeywords sets the Keywords field's value.
func (s *CreateQualificationTypeInput) SetKeywords(v string) *CreateQualificationTypeInput {
	s.Keywords = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateQualificationTypeInput) SetName(v string) *CreateQualificationTypeInput {
	s.Name = &v
	return s
}

// SetQualificationTypeStatus sets the QualificationTypeStatus field's value.
func (s *CreateQualificationTypeInput) SetQualificationTypeStatus(v string) *CreateQualificationTypeInput {
	s.QualificationTypeStatus = &v
	return s
}

// SetRetryDelayInSeconds sets the RetryDelayInSeconds field's value.
func (s *CreateQualificationTypeInput) SetRetryDelayInSeconds(v int64) *CreateQualificationTypeInput {
	s.RetryDelayInSeconds = &v
	return s
}

// SetTest sets the Test field's value.
func (s *CreateQualificationTypeInput) SetTest(v string) *CreateQualificationTypeInput {
	s.Test = &v
	return s
}

// SetTestDurationInSeconds sets the TestDurationInSeconds field's value.
func (s *CreateQualificationTypeInput) SetTestDurationInSeconds(v int64) *CreateQualificationTypeInput {
	s.TestDurationInSeconds = &v
	return s
}

type CreateQualificationTypeOutput struct {
	_ struct{} `type:"structure"`

	// The created Qualification type, returned as a QualificationType data structure.
	QualificationType *QualificationType `type:"structure"`
}

// String returns the string representation
func (s CreateQualificationTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateQualificationTypeOutput) GoString() string {
	return s.String()
}

// SetQualificationType sets the QualificationType field's value.
func (s *CreateQualificationTypeOutput) SetQualificationType(v *QualificationType) *CreateQualificationTypeOutput {
	s.QualificationType = v
	return s
}

type CreateWorkerBlockInput struct {
	_ struct{} `type:"structure"`

	// A message explaining the reason for blocking the Worker. This parameter enables
	// you to keep track of your Workers. The Worker does not see this message.
	//
	// Reason is a required field
	Reason *string `type:"string" required:"true"`

	// The ID of the Worker to block.
	//
	// WorkerId is a required field
	WorkerId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateWorkerBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkerBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkerBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkerBlockInput"}
	if s.Reason == nil {
		invalidParams.Add(request.NewErrParamRequired("Reason"))
	}
	if s.WorkerId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerId"))
	}
	if s.WorkerId != nil && len(*s.WorkerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReason sets the Reason field's value.
func (s *CreateWorkerBlockInput) SetReason(v string) *CreateWorkerBlockInput {
	s.Reason = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *CreateWorkerBlockInput) SetWorkerId(v string) *CreateWorkerBlockInput {
	s.WorkerId = &v
	return s
}

type CreateWorkerBlockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateWorkerBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkerBlockOutput) GoString() string {
	return s.String()
}

type DeleteHITInput struct {
	_ struct{} `type:"structure"`

	// The ID of the HIT to be deleted.
	//
	// HITId is a required field
	HITId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHITInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHITInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHITInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteHITInput"}
	if s.HITId == nil {
		invalidParams.Add(request.NewErrParamRequired("HITId"))
	}
	if s.HITId != nil && len(*s.HITId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HITId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHITId sets the HITId field's value.
func (s *DeleteHITInput) SetHITId(v string) *DeleteHITInput {
	s.HITId = &v
	return s
}

type DeleteHITOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteHITOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHITOutput) GoString() string {
	return s.String()
}

type DeleteQualificationTypeInput struct {
	_ struct{} `type:"structure"`

	// The ID of the QualificationType to dispose.
	//
	// QualificationTypeId is a required field
	QualificationTypeId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteQualificationTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteQualificationTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteQualificationTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteQualificationTypeInput"}
	if s.QualificationTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("QualificationTypeId"))
	}
	if s.QualificationTypeId != nil && len(*s.QualificationTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QualificationTypeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQualificationTypeId sets the QualificationTypeId field's value.
func (s *DeleteQualificationTypeInput) SetQualificationTypeId(v string) *DeleteQualificationTypeInput {
	s.QualificationTypeId = &v
	return s
}

type DeleteQualificationTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteQualificationTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteQualificationTypeOutput) GoString() string {
	return s.String()
}

type DeleteWorkerBlockInput struct {
	_ struct{} `type:"structure"`

	// A message that explains the reason for unblocking the Worker. The Worker
	// does not see this message.
	Reason *string `type:"string"`

	// The ID of the Worker to unblock.
	//
	// WorkerId is a required field
	WorkerId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWorkerBlockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWorkerBlockInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkerBlockInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkerBlockInput"}
	if s.WorkerId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerId"))
	}
	if s.WorkerId != nil && len(*s.WorkerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReason sets the Reason field's value.
func (s *DeleteWorkerBlockInput) SetReason(v string) *DeleteWorkerBlockInput {
	s.Reason = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *DeleteWorkerBlockInput) SetWorkerId(v string) *DeleteWorkerBlockInput {
	s.WorkerId = &v
	return s
}

type DeleteWorkerBlockOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteWorkerBlockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWorkerBlockOutput) GoString() string {
	return s.String()
}

type DisassociateQualificationFromWorkerInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Qualification type of the Qualification to be revoked.
	//
	// QualificationTypeId is a required field
	QualificationTypeId *string `min:"1" type:"string" required:"true"`

	// A text message that explains why the Qualification was revoked. The user
	// who had the Qualification sees this message.
	Reason *string `type:"string"`

	// The ID of the Worker who possesses the Qualification to be revoked.
	//
	// WorkerId is a required field
	WorkerId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateQualificationFromWorkerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateQualificationFromWorkerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateQualificationFromWorkerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateQualificationFromWorkerInput"}
	if s.QualificationTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("QualificationTypeId"))
	}
	if s.QualificationTypeId != nil && len(*s.QualificationTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QualificationTypeId", 1))
	}
	if s.WorkerId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerId"))
	}
	if s.WorkerId != nil && len(*s.WorkerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQualificationTypeId sets the QualificationTypeId field's value.
func (s *DisassociateQualificationFromWorkerInput) SetQualificationTypeId(v string) *DisassociateQualificationFromWorkerInput {
	s.QualificationTypeId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *DisassociateQualificationFromWorkerInput) SetReason(v string) *DisassociateQualificationFromWorkerInput {
	s.Reason = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *DisassociateQualificationFromWorkerInput) SetWorkerId(v string) *DisassociateQualificationFromWorkerInput {
	s.WorkerId = &v
	return s
}

type DisassociateQualificationFromWorkerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateQualificationFromWorkerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateQualificationFromWorkerOutput) GoString() string {
	return s.String()
}

type GetAccountBalanceInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountBalanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountBalanceInput) GoString() string {
	return s.String()
}

type GetAccountBalanceOutput struct {
	_ struct{} `type:"structure"`

	// A string representing a currency amount.
	AvailableBalance *string `type:"string"`

	// A string representing a currency amount.
	OnHoldBalance *string `type:"string"`
}

// String returns the string representation
func (s GetAccountBalanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountBalanceOutput) GoString() string {
	return s.String()
}

// SetAvailableBalance sets the AvailableBalance field's value.
func (s *GetAccountBalanceOutput) SetAvailableBalance(v string) *GetAccountBalanceOutput {
	s.AvailableBalance = &v
	return s
}

// SetOnHoldBalance sets the OnHoldBalance field's value.
func (s *GetAccountBalanceOutput) SetOnHoldBalance(v string) *GetAccountBalanceOutput {
	s.OnHoldBalance = &v
	return s
}

type GetAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Assignment to be retrieved.
	//
	// AssignmentId is a required field
	AssignmentId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssignmentInput"}
	if s.AssignmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentId"))
	}
	if s.AssignmentId != nil && len(*s.AssignmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignmentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentId sets the AssignmentId field's value.
func (s *GetAssignmentInput) SetAssignmentId(v string) *GetAssignmentInput {
	s.AssignmentId = &v
	return s
}

type GetAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// The assignment. The response includes one Assignment element.
	Assignment *Assignment `type:"structure"`

	// The HIT associated with this assignment. The response includes one HIT element.
	HIT *HIT `type:"structure"`
}

// String returns the string representation
func (s GetAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssignmentOutput) GoString() string {
	return s.String()
}

// SetAssignment sets the Assignment field's value.
func (s *GetAssignmentOutput) SetAssignment(v *Assignment) *GetAssignmentOutput {
	s.Assignment = v
	return s
}

// SetHIT sets the HIT field's value.
func (s *GetAssignmentOutput) SetHIT(v *HIT) *GetAssignmentOutput {
	s.HIT = v
	return s
}

type GetFileUploadURLInput struct {
	_ struct{} `type:"structure"`

	// The ID of the assignment that contains the question with a FileUploadAnswer.
	//
	// AssignmentId is a required field
	AssignmentId *string `min:"1" type:"string" required:"true"`

	// The identifier of the question with a FileUploadAnswer, as specified in the
	// QuestionForm of the HIT.
	//
	// QuestionIdentifier is a required field
	QuestionIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetFileUploadURLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFileUploadURLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFileUploadURLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFileUploadURLInput"}
	if s.AssignmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentId"))
	}
	if s.AssignmentId != nil && len(*s.AssignmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignmentId", 1))
	}
	if s.QuestionIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("QuestionIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentId sets the AssignmentId field's value.
func (s *GetFileUploadURLInput) SetAssignmentId(v string) *GetFileUploadURLInput {
	s.AssignmentId = &v
	return s
}

// SetQuestionIdentifier sets the QuestionIdentifier field's value.
func (s *GetFileUploadURLInput) SetQuestionIdentifier(v string) *GetFileUploadURLInput {
	s.QuestionIdentifier = &v
	return s
}

type GetFileUploadURLOutput struct {
	_ struct{} `type:"structure"`

	// A temporary URL for the file that the Worker uploaded for the answer.
	FileUploadURL *string `type:"string"`
}

// String returns the string representation
func (s GetFileUploadURLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFileUploadURLOutput) GoString() string {
	return s.String()
}

// SetFileUploadURL sets the FileUploadURL field's value.
func (s *GetFileUploadURLOutput) SetFileUploadURL(v string) *GetFileUploadURLOutput {
	s.FileUploadURL = &v
	return s
}

type GetHITInput struct {
	_ struct{} `type:"structure"`

	// The ID of the HIT to be retrieved.
	//
	// HITId is a required field
	HITId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetHITInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHITInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHITInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetHITInput"}
	if s.HITId == nil {
		invalidParams.Add(request.NewErrParamRequired("HITId"))
	}
	if s.HITId != nil && len(*s.HITId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HITId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHITId sets the HITId field's value.
func (s *GetHITInput) SetHITId(v string) *GetHITInput {
	s.HITId = &v
	return s
}

type GetHITOutput struct {
	_ struct{} `type:"structure"`

	// Contains the requested HIT data.
	HIT *HIT `type:"structure"`
}

// String returns the string representation
func (s GetHITOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHITOutput) GoString() string {
	return s.String()
}

// SetHIT sets the HIT field's value.
func (s *GetHITOutput) SetHIT(v *HIT) *GetHITOutput {
	s.HIT = v
	return s
}

type GetQualificationScoreInput struct {
	_ struct{} `type:"structure"`

	// The ID of the QualificationType.
	//
	// QualificationTypeId is a required field
	QualificationTypeId *string `min:"1" type:"string" required:"true"`

	// The ID of the Worker whose Qualification is being updated.
	//
	// WorkerId is a required field
	WorkerId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetQualificationScoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQualificationScoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQualificationScoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQualificationScoreInput"}
	if s.QualificationTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("QualificationTypeId"))
	}
	if s.QualificationTypeId != nil && len(*s.QualificationTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QualificationTypeId", 1))
	}
	if s.WorkerId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerId"))
	}
	if s.WorkerId != nil && len(*s.WorkerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQualificationTypeId sets the QualificationTypeId field's value.
func (s *GetQualificationScoreInput) SetQualificationTypeId(v string) *GetQualificationScoreInput {
	s.QualificationTypeId = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *GetQualificationScoreInput) SetWorkerId(v string) *GetQualificationScoreInput {
	s.WorkerId = &v
	return s
}

type GetQualificationScoreOutput struct {
	_ struct{} `type:"structure"`

	// The Qualification data structure of the Qualification assigned to a user,
	// including the Qualification type and the value (score).
	Qualification *Qualification `type:"structure"`
}

// String returns the string representation
func (s GetQualificationScoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQualificationScoreOutput) GoString() string {
	return s.String()
}

// SetQualification sets the Qualification field's value.
func (s *GetQualificationScoreOutput) SetQualification(v *Qualification) *GetQualificationScoreOutput {
	s.Qualification = v
	return s
}

type GetQualificationTypeInput struct {
	_ struct{} `type:"structure"`

	// The ID of the QualificationType.
	//
	// QualificationTypeId is a required field
	QualificationTypeId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetQualificationTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQualificationTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQualificationTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQualificationTypeInput"}
	if s.QualificationTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("QualificationTypeId"))
	}
	if s.QualificationTypeId != nil && len(*s.QualificationTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QualificationTypeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQualificationTypeId sets the QualificationTypeId field's value.
func (s *GetQualificationTypeInput) SetQualificationTypeId(v string) *GetQualificationTypeInput {
	s.QualificationTypeId = &v
	return s
}

type GetQualificationTypeOutput struct {
	_ struct{} `type:"structure"`

	// The returned Qualification Type
	QualificationType *QualificationType `type:"structure"`
}

// String returns the string representation
func (s GetQualificationTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetQualificationTypeOutput) GoString() string {
	return s.String()
}

// SetQualificationType sets the QualificationType field's value.
func (s *GetQualificationTypeOutput) SetQualificationType(v *QualificationType) *GetQualificationTypeOutput {
	s.QualificationType = v
	return s
}

// The HIT data structure represents a single HIT, including all the information
// necessary for a Worker to accept and complete the HIT.
type HIT struct {
	_ struct{} `type:"structure"`

	// The length of time, in seconds, that a Worker has to complete the HIT after
	// accepting it.
	AssignmentDurationInSeconds *int64 `type:"long"`

	// The amount of time, in seconds, after the Worker submits an assignment for
	// the HIT that the results are automatically approved by Amazon Mechanical
	// Turk. This is the amount of time the Requester has to reject an assignment
	// submitted by a Worker before the assignment is auto-approved and the Worker
	// is paid.
	AutoApprovalDelayInSeconds *int64 `type:"long"`

	// The date and time the HIT was created.
	CreationTime *time.Time `type:"timestamp"`

	// A general description of the HIT.
	Description *string `type:"string"`

	// The date and time the HIT expires.
	Expiration *time.Time `type:"timestamp"`

	// The ID of the HIT Group of this HIT.
	HITGroupId *string `min:"1" type:"string"`

	// A unique identifier for the HIT.
	HITId *string `min:"1" type:"string"`

	// The ID of the HIT Layout of this HIT.
	HITLayoutId *string `min:"1" type:"string"`

	// Indicates the review status of the HIT. Valid Values are NotReviewed | MarkedForReview
	// | ReviewedAppropriate | ReviewedInappropriate.
	HITReviewStatus *string `type:"string" enum:"HITReviewStatus"`

	// The status of the HIT and its assignments. Valid Values are Assignable |
	// Unassignable | Reviewable | Reviewing | Disposed.
	HITStatus *string `type:"string" enum:"HITStatus"`

	// The ID of the HIT type of this HIT
	HITTypeId *string `min:"1" type:"string"`

	// One or more words or phrases that describe the HIT, separated by commas.
	// Search terms similar to the keywords of a HIT are more likely to have the
	// HIT in the search results.
	Keywords *string `type:"string"`

	// The number of times the HIT can be accepted and completed before the HIT
	// becomes unavailable.
	MaxAssignments *int64 `type:"integer"`

	// The number of assignments for this HIT that are available for Workers to
	// accept.
	NumberOfAssignmentsAvailable *int64 `type:"integer"`

	// The number of assignments for this HIT that have been approved or rejected.
	NumberOfAssignmentsCompleted *int64 `type:"integer"`

	// The number of assignments for this HIT that are being previewed or have been
	// accepted by Workers, but have not yet been submitted, returned, or abandoned.
	NumberOfAssignmentsPending *int64 `type:"integer"`

	// Conditions that a Worker's Qualifications must meet in order to accept the
	// HIT. A HIT can have between zero and ten Qualification requirements. All
	// requirements must be met in order for a Worker to accept the HIT. Additionally,
	// other actions can be restricted using the ActionsGuarded field on each QualificationRequirement
	// structure.
	QualificationRequirements []*QualificationRequirement `type:"list"`

	// The data the Worker completing the HIT uses produce the results. This is
	// either either a QuestionForm, HTMLQuestion or an ExternalQuestion data structure.
	Question *string `type:"string"`

	// An arbitrary data field the Requester who created the HIT can use. This field
	// is visible only to the creator of the HIT.
	RequesterAnnotation *string `type:"string"`

	// A string representing a currency amount.
	Reward *string `type:"string"`

	// The title of the HIT.
	Title *string `type:"string"`
}

// String returns the string representation
func (s HIT) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HIT) GoString() string {
	return s.String()
}

// SetAssignmentDurationInSeconds sets the AssignmentDurationInSeconds field's value.
func (s *HIT) SetAssignmentDurationInSeconds(v int64) *HIT {
	s.AssignmentDurationInSeconds = &v
	return s
}

// SetAutoApprovalDelayInSeconds sets the AutoApprovalDelayInSeconds field's value.
func (s *HIT) SetAutoApprovalDelayInSeconds(v int64) *HIT {
	s.AutoApprovalDelayInSeconds = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *HIT) SetCreationTime(v time.Time) *HIT {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *HIT) SetDescription(v string) *HIT {
	s.Description = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *HIT) SetExpiration(v time.Time) *HIT {
	s.Expiration = &v
	return s
}

// SetHITGroupId sets the HITGroupId field's value.
func (s *HIT) SetHITGroupId(v string) *HIT {
	s.HITGroupId = &v
	return s
}

// SetHITId sets the HITId field's value.
func (s *HIT) SetHITId(v string) *HIT {
	s.HITId = &v
	return s
}

// SetHITLayoutId sets the HITLayoutId field's value.
func (s *HIT) SetHITLayoutId(v string) *HIT {
	s.HITLayoutId = &v
	return s
}

// SetHITReviewStatus sets the HITReviewStatus field's value.
func (s *HIT) SetHITReviewStatus(v string) *HIT {
	s.HITReviewStatus = &v
	return s
}

// SetHITStatus sets the HITStatus field's value.
func (s *HIT) SetHITStatus(v string) *HIT {
	s.HITStatus = &v
	return s
}

// SetHITTypeId sets the HITTypeId field's value.
func (s *HIT) SetHITTypeId(v string) *HIT {
	s.HITTypeId = &v
	return s
}

// SetKeywords sets the Keywords field's value.
func (s *HIT) SetKeywords(v string) *HIT {
	s.Keywords = &v
	return s
}

// SetMaxAssignments sets the MaxAssignments field's value.
func (s *HIT) SetMaxAssignments(v int64) *HIT {
	s.MaxAssignments = &v
	return s
}

// SetNumberOfAssignmentsAvailable sets the NumberOfAssignmentsAvailable field's value.
func (s *HIT) SetNumberOfAssignmentsAvailable(v int64) *HIT {
	s.NumberOfAssignmentsAvailable = &v
	return s
}

// SetNumberOfAssignmentsCompleted sets the NumberOfAssignmentsCompleted field's value.
func (s *HIT) SetNumberOfAssignmentsCompleted(v int64) *HIT {
	s.NumberOfAssignmentsCompleted = &v
	return s
}

// SetNumberOfAssignmentsPending sets the NumberOfAssignmentsPending field's value.
func (s *HIT) SetNumberOfAssignmentsPending(v int64) *HIT {
	s.NumberOfAssignmentsPending = &v
	return s
}

// SetQualificationRequirements sets the QualificationRequirements field's value.
func (s *HIT) SetQualificationRequirements(v []*QualificationRequirement) *HIT {
	s.QualificationRequirements = v
	return s
}

// SetQuestion sets the Question field's value.
func (s *HIT) SetQuestion(v string) *HIT {
	s.Question = &v
	return s
}

// SetRequesterAnnotation sets the RequesterAnnotation field's value.
func (s *HIT) SetRequesterAnnotation(v string) *HIT {
	s.RequesterAnnotation = &v
	return s
}

// SetReward sets the Reward field's value.
func (s *HIT) SetReward(v string) *HIT {
	s.Reward = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *HIT) SetTitle(v string) *HIT {
	s.Title = &v
	return s
}

// The HITLayoutParameter data structure defines parameter values used with
// a HITLayout. A HITLayout is a reusable Amazon Mechanical Turk project template
// used to provide Human Intelligence Task (HIT) question data for CreateHIT.
type HITLayoutParameter struct {
	_ struct{} `type:"structure"`

	// The name of the parameter in the HITLayout.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value substituted for the parameter referenced in the HITLayout.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s HITLayoutParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HITLayoutParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HITLayoutParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HITLayoutParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *HITLayoutParameter) SetName(v string) *HITLayoutParameter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *HITLayoutParameter) SetValue(v string) *HITLayoutParameter {
	s.Value = &v
	return s
}

type ListAssignmentsForHITInput struct {
	_ struct{} `type:"structure"`

	// The status of the assignments to return: Submitted | Approved | Rejected
	AssignmentStatuses []*string `type:"list"`

	// The ID of the HIT.
	//
	// HITId is a required field
	HITId *string `min:"1" type:"string" required:"true"`

	MaxResults *int64 `min:"1" type:"integer"`

	// Pagination token
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssignmentsForHITInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssignmentsForHITInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssignmentsForHITInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssignmentsForHITInput"}
	if s.HITId == nil {
		invalidParams.Add(request.NewErrParamRequired("HITId"))
	}
	if s.HITId != nil && len(*s.HITId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HITId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentStatuses sets the AssignmentStatuses field's value.
func (s *ListAssignmentsForHITInput) SetAssignmentStatuses(v []*string) *ListAssignmentsForHITInput {
	s.AssignmentStatuses = v
	return s
}

// SetHITId sets the HITId field's value.
func (s *ListAssignmentsForHITInput) SetHITId(v string) *ListAssignmentsForHITInput {
	s.HITId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssignmentsForHITInput) SetMaxResults(v int64) *ListAssignmentsForHITInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssignmentsForHITInput) SetNextToken(v string) *ListAssignmentsForHITInput {
	s.NextToken = &v
	return s
}

type ListAssignmentsForHITOutput struct {
	_ struct{} `type:"structure"`

	// The collection of Assignment data structures returned by this call.
	Assignments []*Assignment `type:"list"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of assignments on the page in the filtered results list, equivalent
	// to the number of assignments returned by this call.
	NumResults *int64 `type:"integer"`
}

// String returns the string representation
func (s ListAssignmentsForHITOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssignmentsForHITOutput) GoString() string {
	return s.String()
}

// SetAssignments sets the Assignments field's value.
func (s *ListAssignmentsForHITOutput) SetAssignments(v []*Assignment) *ListAssignmentsForHITOutput {
	s.Assignments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssignmentsForHITOutput) SetNextToken(v string) *ListAssignmentsForHITOutput {
	s.NextToken = &v
	return s
}

// SetNumResults sets the NumResults field's value.
func (s *ListAssignmentsForHITOutput) SetNumResults(v int64) *ListAssignmentsForHITOutput {
	s.NumResults = &v
	return s
}

type ListBonusPaymentsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the assignment associated with the bonus payments to retrieve.
	// If specified, only bonus payments for the given assignment are returned.
	// Either the HITId parameter or the AssignmentId parameter must be specified
	AssignmentId *string `min:"1" type:"string"`

	// The ID of the HIT associated with the bonus payments to retrieve. If not
	// specified, all bonus payments for all assignments for the given HIT are returned.
	// Either the HITId parameter or the AssignmentId parameter must be specified
	HITId *string `min:"1" type:"string"`

	MaxResults *int64 `min:"1" type:"integer"`

	// Pagination token
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListBonusPaymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBonusPaymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBonusPaymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBonusPaymentsInput"}
	if s.AssignmentId != nil && len(*s.AssignmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignmentId", 1))
	}
	if s.HITId != nil && len(*s.HITId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HITId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentId sets the AssignmentId field's value.
func (s *ListBonusPaymentsInput) SetAssignmentId(v string) *ListBonusPaymentsInput {
	s.AssignmentId = &v
	return s
}

// SetHITId sets the HITId field's value.
func (s *ListBonusPaymentsInput) SetHITId(v string) *ListBonusPaymentsInput {
	s.HITId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBonusPaymentsInput) SetMaxResults(v int64) *ListBonusPaymentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBonusPaymentsInput) SetNextToken(v string) *ListBonusPaymentsInput {
	s.NextToken = &v
	return s
}

type ListBonusPaymentsOutput struct {
	_ struct{} `type:"structure"`

	// A successful request to the ListBonusPayments operation returns a list of
	// BonusPayment objects.
	BonusPayments []*BonusPayment `type:"list"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of bonus payments on this page in the filtered results list, equivalent
	// to the number of bonus payments being returned by this call.
	NumResults *int64 `type:"integer"`
}

// String returns the string representation
func (s ListBonusPaymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBonusPaymentsOutput) GoString() string {
	return s.String()
}

// SetBonusPayments sets the BonusPayments field's value.
func (s *ListBonusPaymentsOutput) SetBonusPayments(v []*BonusPayment) *ListBonusPaymentsOutput {
	s.BonusPayments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBonusPaymentsOutput) SetNextToken(v string) *ListBonusPaymentsOutput {
	s.NextToken = &v
	return s
}

// SetNumResults sets the NumResults field's value.
func (s *ListBonusPaymentsOutput) SetNumResults(v int64) *ListBonusPaymentsOutput {
	s.NumResults = &v
	return s
}

type ListHITsForQualificationTypeInput struct {
	_ struct{} `type:"structure"`

	// Limit the number of results returned.
	MaxResults *int64 `min:"1" type:"integer"`

	// Pagination Token
	NextToken *string `min:"1" type:"string"`

	// The ID of the Qualification type to use when querying HITs.
	//
	// QualificationTypeId is a required field
	QualificationTypeId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListHITsForQualificationTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHITsForQualificationTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHITsForQualificationTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListHITsForQualificationTypeInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.QualificationTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("QualificationTypeId"))
	}
	if s.QualificationTypeId != nil && len(*s.QualificationTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QualificationTypeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListHITsForQualificationTypeInput) SetMaxResults(v int64) *ListHITsForQualificationTypeInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHITsForQualificationTypeInput) SetNextToken(v string) *ListHITsForQualificationTypeInput {
	s.NextToken = &v
	return s
}

// SetQualificationTypeId sets the QualificationTypeId field's value.
func (s *ListHITsForQualificationTypeInput) SetQualificationTypeId(v string) *ListHITsForQualificationTypeInput {
	s.QualificationTypeId = &v
	return s
}

type ListHITsForQualificationTypeOutput struct {
	_ struct{} `type:"structure"`

	// The list of HIT elements returned by the query.
	HITs []*HIT `type:"list"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of HITs on this page in the filtered results list, equivalent
	// to the number of HITs being returned by this call.
	NumResults *int64 `type:"integer"`
}

// String returns the string representation
func (s ListHITsForQualificationTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHITsForQualificationTypeOutput) GoString() string {
	return s.String()
}

// SetHITs sets the HITs field's value.
func (s *ListHITsForQualificationTypeOutput) SetHITs(v []*HIT) *ListHITsForQualificationTypeOutput {
	s.HITs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHITsForQualificationTypeOutput) SetNextToken(v string) *ListHITsForQualificationTypeOutput {
	s.NextToken = &v
	return s
}

// SetNumResults sets the NumResults field's value.
func (s *ListHITsForQualificationTypeOutput) SetNumResults(v int64) *ListHITsForQualificationTypeOutput {
	s.NumResults = &v
	return s
}

type ListHITsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `min:"1" type:"integer"`

	// Pagination token
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListHITsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHITsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListHITsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListHITsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListHITsInput) SetMaxResults(v int64) *ListHITsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHITsInput) SetNextToken(v string) *ListHITsInput {
	s.NextToken = &v
	return s
}

type ListHITsOutput struct {
	_ struct{} `type:"structure"`

	// The list of HIT elements returned by the query.
	HITs []*HIT `type:"list"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of HITs on this page in the filtered results list, equivalent
	// to the number of HITs being returned by this call.
	NumResults *int64 `type:"integer"`
}

// String returns the string representation
func (s ListHITsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHITsOutput) GoString() string {
	return s.String()
}

// SetHITs sets the HITs field's value.
func (s *ListHITsOutput) SetHITs(v []*HIT) *ListHITsOutput {
	s.HITs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListHITsOutput) SetNextToken(v string) *ListHITsOutput {
	s.NextToken = &v
	return s
}

// SetNumResults sets the NumResults field's value.
func (s *ListHITsOutput) SetNumResults(v int64) *ListHITsOutput {
	s.NumResults = &v
	return s
}

type ListQualificationRequestsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The ID of the QualificationType.
	QualificationTypeId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListQualificationRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQualificationRequestsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListQualificationRequestsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListQualificationRequestsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.QualificationTypeId != nil && len(*s.QualificationTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QualificationTypeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListQualificationRequestsInput) SetMaxResults(v int64) *ListQualificationRequestsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQualificationRequestsInput) SetNextToken(v string) *ListQualificationRequestsInput {
	s.NextToken = &v
	return s
}

// SetQualificationTypeId sets the QualificationTypeId field's value.
func (s *ListQualificationRequestsInput) SetQualificationTypeId(v string) *ListQualificationRequestsInput {
	s.QualificationTypeId = &v
	return s
}

type ListQualificationRequestsOutput struct {
	_ struct{} `type:"structure"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of Qualification requests on this page in the filtered results
	// list, equivalent to the number of Qualification requests being returned by
	// this call.
	NumResults *int64 `type:"integer"`

	// The Qualification request. The response includes one QualificationRequest
	// element for each Qualification request returned by the query.
	QualificationRequests []*QualificationRequest `type:"list"`
}

// String returns the string representation
func (s ListQualificationRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQualificationRequestsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListQualificationRequestsOutput) SetNextToken(v string) *ListQualificationRequestsOutput {
	s.NextToken = &v
	return s
}

// SetNumResults sets the NumResults field's value.
func (s *ListQualificationRequestsOutput) SetNumResults(v int64) *ListQualificationRequestsOutput {
	s.NumResults = &v
	return s
}

// SetQualificationRequests sets the QualificationRequests field's value.
func (s *ListQualificationRequestsOutput) SetQualificationRequests(v []*QualificationRequest) *ListQualificationRequestsOutput {
	s.QualificationRequests = v
	return s
}

type ListQualificationTypesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specifies that only Qualification types that the Requester created are returned.
	// If false, the operation returns all Qualification types.
	MustBeOwnedByCaller *bool `type:"boolean"`

	// Specifies that only Qualification types that a user can request through the
	// Amazon Mechanical Turk web site, such as by taking a Qualification test,
	// are returned as results of the search. Some Qualification types, such as
	// those assigned automatically by the system, cannot be requested directly
	// by users. If false, all Qualification types, including those managed by the
	// system, are considered. Valid values are True | False.
	//
	// MustBeRequestable is a required field
	MustBeRequestable *bool `type:"boolean" required:"true"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// A text query against all of the searchable attributes of Qualification types.
	Query *string `type:"string"`
}

// String returns the string representation
func (s ListQualificationTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQualificationTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListQualificationTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListQualificationTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MustBeRequestable == nil {
		invalidParams.Add(request.NewErrParamRequired("MustBeRequestable"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListQualificationTypesInput) SetMaxResults(v int64) *ListQualificationTypesInput {
	s.MaxResults = &v
	return s
}

// SetMustBeOwnedByCaller sets the MustBeOwnedByCaller field's value.
func (s *ListQualificationTypesInput) SetMustBeOwnedByCaller(v bool) *ListQualificationTypesInput {
	s.MustBeOwnedByCaller = &v
	return s
}

// SetMustBeRequestable sets the MustBeRequestable field's value.
func (s *ListQualificationTypesInput) SetMustBeRequestable(v bool) *ListQualificationTypesInput {
	s.MustBeRequestable = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQualificationTypesInput) SetNextToken(v string) *ListQualificationTypesInput {
	s.NextToken = &v
	return s
}

// SetQuery sets the Query field's value.
func (s *ListQualificationTypesInput) SetQuery(v string) *ListQualificationTypesInput {
	s.Query = &v
	return s
}

type ListQualificationTypesOutput struct {
	_ struct{} `type:"structure"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of Qualification types on this page in the filtered results list,
	// equivalent to the number of types this operation returns.
	NumResults *int64 `type:"integer"`

	// The list of QualificationType elements returned by the query.
	QualificationTypes []*QualificationType `type:"list"`
}

// String returns the string representation
func (s ListQualificationTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListQualificationTypesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListQualificationTypesOutput) SetNextToken(v string) *ListQualificationTypesOutput {
	s.NextToken = &v
	return s
}

// SetNumResults sets the NumResults field's value.
func (s *ListQualificationTypesOutput) SetNumResults(v int64) *ListQualificationTypesOutput {
	s.NumResults = &v
	return s
}

// SetQualificationTypes sets the QualificationTypes field's value.
func (s *ListQualificationTypesOutput) SetQualificationTypes(v []*QualificationType) *ListQualificationTypesOutput {
	s.QualificationTypes = v
	return s
}

type ListReviewPolicyResultsForHITInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the HIT to retrieve review results for.
	//
	// HITId is a required field
	HITId *string `min:"1" type:"string" required:"true"`

	// Limit the number of results returned.
	MaxResults *int64 `min:"1" type:"integer"`

	// Pagination token
	NextToken *string `min:"1" type:"string"`

	// The Policy Level(s) to retrieve review results for - HIT or Assignment. If
	// omitted, the default behavior is to retrieve all data for both policy levels.
	// For a list of all the described policies, see Review Policies.
	PolicyLevels []*string `type:"list"`

	// Specify if the operation should retrieve a list of the actions taken executing
	// the Review Policies and their outcomes.
	RetrieveActions *bool `type:"boolean"`

	// Specify if the operation should retrieve a list of the results computed by
	// the Review Policies.
	RetrieveResults *bool `type:"boolean"`
}

// String returns the string representation
func (s ListReviewPolicyResultsForHITInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReviewPolicyResultsForHITInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReviewPolicyResultsForHITInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReviewPolicyResultsForHITInput"}
	if s.HITId == nil {
		invalidParams.Add(request.NewErrParamRequired("HITId"))
	}
	if s.HITId != nil && len(*s.HITId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HITId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHITId sets the HITId field's value.
func (s *ListReviewPolicyResultsForHITInput) SetHITId(v string) *ListReviewPolicyResultsForHITInput {
	s.HITId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReviewPolicyResultsForHITInput) SetMaxResults(v int64) *ListReviewPolicyResultsForHITInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReviewPolicyResultsForHITInput) SetNextToken(v string) *ListReviewPolicyResultsForHITInput {
	s.NextToken = &v
	return s
}

// SetPolicyLevels sets the PolicyLevels field's value.
func (s *ListReviewPolicyResultsForHITInput) SetPolicyLevels(v []*string) *ListReviewPolicyResultsForHITInput {
	s.PolicyLevels = v
	return s
}

// SetRetrieveActions sets the RetrieveActions field's value.
func (s *ListReviewPolicyResultsForHITInput) SetRetrieveActions(v bool) *ListReviewPolicyResultsForHITInput {
	s.RetrieveActions = &v
	return s
}

// SetRetrieveResults sets the RetrieveResults field's value.
func (s *ListReviewPolicyResultsForHITInput) SetRetrieveResults(v bool) *ListReviewPolicyResultsForHITInput {
	s.RetrieveResults = &v
	return s
}

type ListReviewPolicyResultsForHITOutput struct {
	_ struct{} `type:"structure"`

	// The name of the Assignment-level Review Policy. This contains only the PolicyName
	// element.
	AssignmentReviewPolicy *ReviewPolicy `type:"structure"`

	// Contains both ReviewResult and ReviewAction elements for an Assignment.
	AssignmentReviewReport *ReviewReport `type:"structure"`

	// The HITId of the HIT for which results have been returned.
	HITId *string `min:"1" type:"string"`

	// The name of the HIT-level Review Policy. This contains only the PolicyName
	// element.
	HITReviewPolicy *ReviewPolicy `type:"structure"`

	// Contains both ReviewResult and ReviewAction elements for a particular HIT.
	HITReviewReport *ReviewReport `type:"structure"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListReviewPolicyResultsForHITOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReviewPolicyResultsForHITOutput) GoString() string {
	return s.String()
}

// SetAssignmentReviewPolicy sets the AssignmentReviewPolicy field's value.
func (s *ListReviewPolicyResultsForHITOutput) SetAssignmentReviewPolicy(v *ReviewPolicy) *ListReviewPolicyResultsForHITOutput {
	s.AssignmentReviewPolicy = v
	return s
}

// SetAssignmentReviewReport sets the AssignmentReviewReport field's value.
func (s *ListReviewPolicyResultsForHITOutput) SetAssignmentReviewReport(v *ReviewReport) *ListReviewPolicyResultsForHITOutput {
	s.AssignmentReviewReport = v
	return s
}

// SetHITId sets the HITId field's value.
func (s *ListReviewPolicyResultsForHITOutput) SetHITId(v string) *ListReviewPolicyResultsForHITOutput {
	s.HITId = &v
	return s
}

// SetHITReviewPolicy sets the HITReviewPolicy field's value.
func (s *ListReviewPolicyResultsForHITOutput) SetHITReviewPolicy(v *ReviewPolicy) *ListReviewPolicyResultsForHITOutput {
	s.HITReviewPolicy = v
	return s
}

// SetHITReviewReport sets the HITReviewReport field's value.
func (s *ListReviewPolicyResultsForHITOutput) SetHITReviewReport(v *ReviewReport) *ListReviewPolicyResultsForHITOutput {
	s.HITReviewReport = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReviewPolicyResultsForHITOutput) SetNextToken(v string) *ListReviewPolicyResultsForHITOutput {
	s.NextToken = &v
	return s
}

type ListReviewableHITsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the HIT type of the HITs to consider for the query. If not specified,
	// all HITs for the Reviewer are considered
	HITTypeId *string `min:"1" type:"string"`

	// Limit the number of results returned.
	MaxResults *int64 `min:"1" type:"integer"`

	// Pagination Token
	NextToken *string `min:"1" type:"string"`

	// Can be either Reviewable or Reviewing. Reviewable is the default value.
	Status *string `type:"string" enum:"ReviewableHITStatus"`
}

// String returns the string representation
func (s ListReviewableHITsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReviewableHITsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReviewableHITsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReviewableHITsInput"}
	if s.HITTypeId != nil && len(*s.HITTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HITTypeId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHITTypeId sets the HITTypeId field's value.
func (s *ListReviewableHITsInput) SetHITTypeId(v string) *ListReviewableHITsInput {
	s.HITTypeId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReviewableHITsInput) SetMaxResults(v int64) *ListReviewableHITsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReviewableHITsInput) SetNextToken(v string) *ListReviewableHITsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListReviewableHITsInput) SetStatus(v string) *ListReviewableHITsInput {
	s.Status = &v
	return s
}

type ListReviewableHITsOutput struct {
	_ struct{} `type:"structure"`

	// The list of HIT elements returned by the query.
	HITs []*HIT `type:"list"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of HITs on this page in the filtered results list, equivalent
	// to the number of HITs being returned by this call.
	NumResults *int64 `type:"integer"`
}

// String returns the string representation
func (s ListReviewableHITsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReviewableHITsOutput) GoString() string {
	return s.String()
}

// SetHITs sets the HITs field's value.
func (s *ListReviewableHITsOutput) SetHITs(v []*HIT) *ListReviewableHITsOutput {
	s.HITs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReviewableHITsOutput) SetNextToken(v string) *ListReviewableHITsOutput {
	s.NextToken = &v
	return s
}

// SetNumResults sets the NumResults field's value.
func (s *ListReviewableHITsOutput) SetNumResults(v int64) *ListReviewableHITsOutput {
	s.NumResults = &v
	return s
}

type ListWorkerBlocksInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `min:"1" type:"integer"`

	// Pagination token
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListWorkerBlocksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkerBlocksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkerBlocksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkerBlocksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkerBlocksInput) SetMaxResults(v int64) *ListWorkerBlocksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkerBlocksInput) SetNextToken(v string) *ListWorkerBlocksInput {
	s.NextToken = &v
	return s
}

type ListWorkerBlocksOutput struct {
	_ struct{} `type:"structure"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of assignments on the page in the filtered results list, equivalent
	// to the number of assignments returned by this call.
	NumResults *int64 `type:"integer"`

	// The list of WorkerBlocks, containing the collection of Worker IDs and reasons
	// for blocking.
	WorkerBlocks []*WorkerBlock `type:"list"`
}

// String returns the string representation
func (s ListWorkerBlocksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkerBlocksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkerBlocksOutput) SetNextToken(v string) *ListWorkerBlocksOutput {
	s.NextToken = &v
	return s
}

// SetNumResults sets the NumResults field's value.
func (s *ListWorkerBlocksOutput) SetNumResults(v int64) *ListWorkerBlocksOutput {
	s.NumResults = &v
	return s
}

// SetWorkerBlocks sets the WorkerBlocks field's value.
func (s *ListWorkerBlocksOutput) SetWorkerBlocks(v []*WorkerBlock) *ListWorkerBlocksOutput {
	s.WorkerBlocks = v
	return s
}

type ListWorkersWithQualificationTypeInput struct {
	_ struct{} `type:"structure"`

	// Limit the number of results returned.
	MaxResults *int64 `min:"1" type:"integer"`

	// Pagination Token
	NextToken *string `min:"1" type:"string"`

	// The ID of the Qualification type of the Qualifications to return.
	//
	// QualificationTypeId is a required field
	QualificationTypeId *string `min:"1" type:"string" required:"true"`

	// The status of the Qualifications to return. Can be Granted | Revoked.
	Status *string `type:"string" enum:"QualificationStatus"`
}

// String returns the string representation
func (s ListWorkersWithQualificationTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkersWithQualificationTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkersWithQualificationTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkersWithQualificationTypeInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.QualificationTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("QualificationTypeId"))
	}
	if s.QualificationTypeId != nil && len(*s.QualificationTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QualificationTypeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkersWithQualificationTypeInput) SetMaxResults(v int64) *ListWorkersWithQualificationTypeInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkersWithQualificationTypeInput) SetNextToken(v string) *ListWorkersWithQualificationTypeInput {
	s.NextToken = &v
	return s
}

// SetQualificationTypeId sets the QualificationTypeId field's value.
func (s *ListWorkersWithQualificationTypeInput) SetQualificationTypeId(v string) *ListWorkersWithQualificationTypeInput {
	s.QualificationTypeId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListWorkersWithQualificationTypeInput) SetStatus(v string) *ListWorkersWithQualificationTypeInput {
	s.Status = &v
	return s
}

type ListWorkersWithQualificationTypeOutput struct {
	_ struct{} `type:"structure"`

	// If the previous response was incomplete (because there is more data to retrieve),
	// Amazon Mechanical Turk returns a pagination token in the response. You can
	// use this pagination token to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of Qualifications on this page in the filtered results list, equivalent
	// to the number of Qualifications being returned by this call.
	NumResults *int64 `type:"integer"`

	// The list of Qualification elements returned by this call.
	Qualifications []*Qualification `type:"list"`
}

// String returns the string representation
func (s ListWorkersWithQualificationTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkersWithQualificationTypeOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkersWithQualificationTypeOutput) SetNextToken(v string) *ListWorkersWithQualificationTypeOutput {
	s.NextToken = &v
	return s
}

// SetNumResults sets the NumResults field's value.
func (s *ListWorkersWithQualificationTypeOutput) SetNumResults(v int64) *ListWorkersWithQualificationTypeOutput {
	s.NumResults = &v
	return s
}

// SetQualifications sets the Qualifications field's value.
func (s *ListWorkersWithQualificationTypeOutput) SetQualifications(v []*Qualification) *ListWorkersWithQualificationTypeOutput {
	s.Qualifications = v
	return s
}

// The Locale data structure represents a geographical region or location.
type Locale struct {
	_ struct{} `type:"structure"`

	// The country of the locale. Must be a valid ISO 3166 country code. For example,
	// the code US refers to the United States of America.
	//
	// Country is a required field
	Country *string `min:"2" type:"string" required:"true"`

	// The state or subdivision of the locale. A valid ISO 3166-2 subdivision code.
	// For example, the code WA refers to the state of Washington.
	Subdivision *string `min:"2" type:"string"`
}

// String returns the string representation
func (s Locale) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Locale) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Locale) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Locale"}
	if s.Country == nil {
		invalidParams.Add(request.NewErrParamRequired("Country"))
	}
	if s.Country != nil && len(*s.Country) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Country", 2))
	}
	if s.Subdivision != nil && len(*s.Subdivision) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("Subdivision", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCountry sets the Country field's value.
func (s *Locale) SetCountry(v string) *Locale {
	s.Country = &v
	return s
}

// SetSubdivision sets the Subdivision field's value.
func (s *Locale) SetSubdivision(v string) *Locale {
	s.Subdivision = &v
	return s
}

// The NotificationSpecification data structure describes a HIT event notification
// for a HIT type.
type NotificationSpecification struct {
	_ struct{} `type:"structure"`

	// The target for notification messages. The Destination’s format is determined
	// by the specified Transport:
	//
	//    * When Transport is Email, the Destination is your email address.
	//
	//    * When Transport is SQS, the Destination is your queue URL.
	//
	//    * When Transport is SNS, the Destination is the ARN of your topic.
	//
	// Destination is a required field
	Destination *string `type:"string" required:"true"`

	// The list of events that should cause notifications to be sent. Valid Values:
	// AssignmentAccepted | AssignmentAbandoned | AssignmentReturned | AssignmentSubmitted
	// | AssignmentRejected | AssignmentApproved | HITCreated | HITExtended | HITDisposed
	// | HITReviewable | HITExpired | Ping. The Ping event is only valid for the
	// SendTestEventNotification operation.
	//
	// EventTypes is a required field
	EventTypes []*string `type:"list" required:"true"`

	// The method Amazon Mechanical Turk uses to send the notification. Valid Values:
	// Email | SQS | SNS.
	//
	// Transport is a required field
	Transport *string `type:"string" required:"true" enum:"NotificationTransport"`

	// The version of the Notification API to use. Valid value is 2006-05-05.
	//
	// Version is a required field
	Version *string `type:"string" required:"true"`
}

// String returns the string representation
func (s NotificationSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationSpecification"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.EventTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("EventTypes"))
	}
	if s.Transport == nil {
		invalidParams.Add(request.NewErrParamRequired("Transport"))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *NotificationSpecification) SetDestination(v string) *NotificationSpecification {
	s.Destination = &v
	return s
}

// SetEventTypes sets the EventTypes field's value.
func (s *NotificationSpecification) SetEventTypes(v []*string) *NotificationSpecification {
	s.EventTypes = v
	return s
}

// SetTransport sets the Transport field's value.
func (s *NotificationSpecification) SetTransport(v string) *NotificationSpecification {
	s.Transport = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *NotificationSpecification) SetVersion(v string) *NotificationSpecification {
	s.Version = &v
	return s
}

// When MTurk encounters an issue with notifying the Workers you specified,
// it returns back this object with failure details.
type NotifyWorkersFailureStatus struct {
	_ struct{} `type:"structure"`

	// Encoded value for the failure type.
	NotifyWorkersFailureCode *string `type:"string" enum:"NotifyWorkersFailureCode"`

	// A message detailing the reason the Worker could not be notified.
	NotifyWorkersFailureMessage *string `type:"string"`

	// The ID of the Worker.
	WorkerId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s NotifyWorkersFailureStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyWorkersFailureStatus) GoString() string {
	return s.String()
}

// SetNotifyWorkersFailureCode sets the NotifyWorkersFailureCode field's value.
func (s *NotifyWorkersFailureStatus) SetNotifyWorkersFailureCode(v string) *NotifyWorkersFailureStatus {
	s.NotifyWorkersFailureCode = &v
	return s
}

// SetNotifyWorkersFailureMessage sets the NotifyWorkersFailureMessage field's value.
func (s *NotifyWorkersFailureStatus) SetNotifyWorkersFailureMessage(v string) *NotifyWorkersFailureStatus {
	s.NotifyWorkersFailureMessage = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *NotifyWorkersFailureStatus) SetWorkerId(v string) *NotifyWorkersFailureStatus {
	s.WorkerId = &v
	return s
}

type NotifyWorkersInput struct {
	_ struct{} `type:"structure"`

	// The text of the email message to send. Can include up to 4,096 characters
	//
	// MessageText is a required field
	MessageText *string `type:"string" required:"true"`

	// The subject line of the email message to send. Can include up to 200 characters.
	//
	// Subject is a required field
	Subject *string `type:"string" required:"true"`

	// A list of Worker IDs you wish to notify. You can notify upto 100 Workers
	// at a time.
	//
	// WorkerIds is a required field
	WorkerIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s NotifyWorkersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyWorkersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotifyWorkersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotifyWorkersInput"}
	if s.MessageText == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageText"))
	}
	if s.Subject == nil {
		invalidParams.Add(request.NewErrParamRequired("Subject"))
	}
	if s.WorkerIds == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessageText sets the MessageText field's value.
func (s *NotifyWorkersInput) SetMessageText(v string) *NotifyWorkersInput {
	s.MessageText = &v
	return s
}

// SetSubject sets the Subject field's value.
func (s *NotifyWorkersInput) SetSubject(v string) *NotifyWorkersInput {
	s.Subject = &v
	return s
}

// SetWorkerIds sets the WorkerIds field's value.
func (s *NotifyWorkersInput) SetWorkerIds(v []*string) *NotifyWorkersInput {
	s.WorkerIds = v
	return s
}

type NotifyWorkersOutput struct {
	_ struct{} `type:"structure"`

	// When MTurk sends notifications to the list of Workers, it returns back any
	// failures it encounters in this list of NotifyWorkersFailureStatus objects.
	NotifyWorkersFailureStatuses []*NotifyWorkersFailureStatus `type:"list"`
}

// String returns the string representation
func (s NotifyWorkersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyWorkersOutput) GoString() string {
	return s.String()
}

// SetNotifyWorkersFailureStatuses sets the NotifyWorkersFailureStatuses field's value.
func (s *NotifyWorkersOutput) SetNotifyWorkersFailureStatuses(v []*NotifyWorkersFailureStatus) *NotifyWorkersOutput {
	s.NotifyWorkersFailureStatuses = v
	return s
}

// This data structure is the data type for the AnswerKey parameter of the ScoreMyKnownAnswers/2011-09-01
// Review Policy.
type ParameterMapEntry struct {
	_ struct{} `type:"structure"`

	// The QuestionID from the HIT that is used to identify which question requires
	// Mechanical Turk to score as part of the ScoreMyKnownAnswers/2011-09-01 Review
	// Policy.
	Key *string `type:"string"`

	// The list of answers to the question specified in the MapEntry Key element.
	// The Worker must match all values in order for the answer to be scored correctly.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s ParameterMapEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterMapEntry) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ParameterMapEntry) SetKey(v string) *ParameterMapEntry {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ParameterMapEntry) SetValues(v []*string) *ParameterMapEntry {
	s.Values = v
	return s
}

// Name of the parameter from the Review policy.
type PolicyParameter struct {
	_ struct{} `type:"structure"`

	// Name of the parameter from the list of Review Polices.
	Key *string `type:"string"`

	// List of ParameterMapEntry objects.
	MapEntries []*ParameterMapEntry `type:"list"`

	// The list of values of the Parameter
	Values []*string `type:"list"`
}

// String returns the string representation
func (s PolicyParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyParameter) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *PolicyParameter) SetKey(v string) *PolicyParameter {
	s.Key = &v
	return s
}

// SetMapEntries sets the MapEntries field's value.
func (s *PolicyParameter) SetMapEntries(v []*ParameterMapEntry) *PolicyParameter {
	s.MapEntries = v
	return s
}

// SetValues sets the Values field's value.
func (s *PolicyParameter) SetValues(v []*string) *PolicyParameter {
	s.Values = v
	return s
}

// The Qualification data structure represents a Qualification assigned to a
// user, including the Qualification type and the value (score).
type Qualification struct {
	_ struct{} `type:"structure"`

	// The date and time the Qualification was granted to the Worker. If the Worker's
	// Qualification was revoked, and then re-granted based on a new Qualification
	// request, GrantTime is the date and time of the last call to the AcceptQualificationRequest
	// operation.
	GrantTime *time.Time `type:"timestamp"`

	// The value (score) of the Qualification, if the Qualification has an integer
	// value.
	IntegerValue *int64 `type:"integer"`

	// The Locale data structure represents a geographical region or location.
	LocaleValue *Locale `type:"structure"`

	// The ID of the Qualification type for the Qualification.
	QualificationTypeId *string `min:"1" type:"string"`

	// The status of the Qualification. Valid values are Granted | Revoked.
	Status *string `type:"string" enum:"QualificationStatus"`

	// The ID of the Worker who possesses the Qualification.
	WorkerId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Qualification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Qualification) GoString() string {
	return s.String()
}

// SetGrantTime sets the GrantTime field's value.
func (s *Qualification) SetGrantTime(v time.Time) *Qualification {
	s.GrantTime = &v
	return s
}

// SetIntegerValue sets the IntegerValue field's value.
func (s *Qualification) SetIntegerValue(v int64) *Qualification {
	s.IntegerValue = &v
	return s
}

// SetLocaleValue sets the LocaleValue field's value.
func (s *Qualification) SetLocaleValue(v *Locale) *Qualification {
	s.LocaleValue = v
	return s
}

// SetQualificationTypeId sets the QualificationTypeId field's value.
func (s *Qualification) SetQualificationTypeId(v string) *Qualification {
	s.QualificationTypeId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Qualification) SetStatus(v string) *Qualification {
	s.Status = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *Qualification) SetWorkerId(v string) *Qualification {
	s.WorkerId = &v
	return s
}

// The QualificationRequest data structure represents a request a Worker has
// made for a Qualification.
type QualificationRequest struct {
	_ struct{} `type:"structure"`

	// The Worker's answers for the Qualification type's test contained in a QuestionFormAnswers
	// document, if the type has a test and the Worker has submitted answers. If
	// the Worker does not provide any answers, Answer may be empty.
	Answer *string `type:"string"`

	// The ID of the Qualification request, a unique identifier generated when the
	// request was submitted.
	QualificationRequestId *string `type:"string"`

	// The ID of the Qualification type the Worker is requesting, as returned by
	// the CreateQualificationType operation.
	QualificationTypeId *string `min:"1" type:"string"`

	// The date and time the Qualification request had a status of Submitted. This
	// is either the time the Worker submitted answers for a Qualification test,
	// or the time the Worker requested the Qualification if the Qualification type
	// does not have a test.
	SubmitTime *time.Time `type:"timestamp"`

	// The contents of the Qualification test that was presented to the Worker,
	// if the type has a test and the Worker has submitted answers. This value is
	// identical to the QuestionForm associated with the Qualification type at the
	// time the Worker requests the Qualification.
	Test *string `type:"string"`

	// The ID of the Worker requesting the Qualification.
	WorkerId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s QualificationRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QualificationRequest) GoString() string {
	return s.String()
}

// SetAnswer sets the Answer field's value.
func (s *QualificationRequest) SetAnswer(v string) *QualificationRequest {
	s.Answer = &v
	return s
}

// SetQualificationRequestId sets the QualificationRequestId field's value.
func (s *QualificationRequest) SetQualificationRequestId(v string) *QualificationRequest {
	s.QualificationRequestId = &v
	return s
}

// SetQualificationTypeId sets the QualificationTypeId field's value.
func (s *QualificationRequest) SetQualificationTypeId(v string) *QualificationRequest {
	s.QualificationTypeId = &v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *QualificationRequest) SetSubmitTime(v time.Time) *QualificationRequest {
	s.SubmitTime = &v
	return s
}

// SetTest sets the Test field's value.
func (s *QualificationRequest) SetTest(v string) *QualificationRequest {
	s.Test = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *QualificationRequest) SetWorkerId(v string) *QualificationRequest {
	s.WorkerId = &v
	return s
}

// The QualificationRequirement data structure describes a Qualification that
// a Worker must have before the Worker is allowed to accept a HIT. A requirement
// may optionally state that a Worker must have the Qualification in order to
// preview the HIT, or see the HIT in search results.
type QualificationRequirement struct {
	_ struct{} `type:"structure"`

	// Setting this attribute prevents Workers whose Qualifications do not meet
	// this QualificationRequirement from taking the specified action. Valid arguments
	// include "Accept" (Worker cannot accept the HIT, but can preview the HIT and
	// see it in their search results), "PreviewAndAccept" (Worker cannot accept
	// or preview the HIT, but can see the HIT in their search results), and "DiscoverPreviewAndAccept"
	// (Worker cannot accept, preview, or see the HIT in their search results).
	// It's possible for you to create a HIT with multiple QualificationRequirements
	// (which can have different values for the ActionGuarded attribute). In this
	// case, the Worker is only permitted to perform an action when they have met
	// all QualificationRequirements guarding the action. The actions in the order
	// of least restrictive to most restrictive are Discover, Preview and Accept.
	// For example, if a Worker meets all QualificationRequirements that are set
	// to DiscoverPreviewAndAccept, but do not meet all requirements that are set
	// with PreviewAndAccept, then the Worker will be able to Discover, i.e. see
	// the HIT in their search result, but will not be able to Preview or Accept
	// the HIT. ActionsGuarded should not be used in combination with the RequiredToPreview
	// field.
	ActionsGuarded *string `type:"string" enum:"HITAccessActions"`

	// The kind of comparison to make against a Qualification's value. You can compare
	// a Qualification's value to an IntegerValue to see if it is LessThan, LessThanOrEqualTo,
	// GreaterThan, GreaterThanOrEqualTo, EqualTo, or NotEqualTo the IntegerValue.
	// You can compare it to a LocaleValue to see if it is EqualTo, or NotEqualTo
	// the LocaleValue. You can check to see if the value is In or NotIn a set of
	// IntegerValue or LocaleValue values. Lastly, a Qualification requirement can
	// also test if a Qualification Exists or DoesNotExist in the user's profile,
	// regardless of its value.
	//
	// Comparator is a required field
	Comparator *string `type:"string" required:"true" enum:"Comparator"`

	// The integer value to compare against the Qualification's value. IntegerValue
	// must not be present if Comparator is Exists or DoesNotExist. IntegerValue
	// can only be used if the Qualification type has an integer value; it cannot
	// be used with the Worker_Locale QualificationType ID. When performing a set
	// comparison by using the In or the NotIn comparator, you can use up to 15
	// IntegerValue elements in a QualificationRequirement data structure.
	IntegerValues []*int64 `type:"list"`

	// The locale value to compare against the Qualification's value. The local
	// value must be a valid ISO 3166 country code or supports ISO 3166-2 subdivisions.
	// LocaleValue can only be used with a Worker_Locale QualificationType ID. LocaleValue
	// can only be used with the EqualTo, NotEqualTo, In, and NotIn comparators.
	// You must only use a single LocaleValue element when using the EqualTo or
	// NotEqualTo comparators. When performing a set comparison by using the In
	// or the NotIn comparator, you can use up to 30 LocaleValue elements in a QualificationRequirement
	// data structure.
	LocaleValues []*Locale `type:"list"`

	// The ID of the Qualification type for the requirement.
	//
	// QualificationTypeId is a required field
	QualificationTypeId *string `type:"string" required:"true"`

	// DEPRECATED: Use the ActionsGuarded field instead. If RequiredToPreview is
	// true, the question data for the HIT will not be shown when a Worker whose
	// Qualifications do not meet this requirement tries to preview the HIT. That
	// is, a Worker's Qualifications must meet all of the requirements for which
	// RequiredToPreview is true in order to preview the HIT. If a Worker meets
	// all of the requirements where RequiredToPreview is true (or if there are
	// no such requirements), but does not meet all of the requirements for the
	// HIT, the Worker will be allowed to preview the HIT's question data, but will
	// not be allowed to accept and complete the HIT. The default is false. This
	// should not be used in combination with the ActionsGuarded field.
	//
	// Deprecated: RequiredToPreview has been deprecated
	RequiredToPreview *bool `deprecated:"true" type:"boolean"`
}

// String returns the string representation
func (s QualificationRequirement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QualificationRequirement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QualificationRequirement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QualificationRequirement"}
	if s.Comparator == nil {
		invalidParams.Add(request.NewErrParamRequired("Comparator"))
	}
	if s.QualificationTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("QualificationTypeId"))
	}
	if s.LocaleValues != nil {
		for i, v := range s.LocaleValues {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LocaleValues", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionsGuarded sets the ActionsGuarded field's value.
func (s *QualificationRequirement) SetActionsGuarded(v string) *QualificationRequirement {
	s.ActionsGuarded = &v
	return s
}

// SetComparator sets the Comparator field's value.
func (s *QualificationRequirement) SetComparator(v string) *QualificationRequirement {
	s.Comparator = &v
	return s
}

// SetIntegerValues sets the IntegerValues field's value.
func (s *QualificationRequirement) SetIntegerValues(v []*int64) *QualificationRequirement {
	s.IntegerValues = v
	return s
}

// SetLocaleValues sets the LocaleValues field's value.
func (s *QualificationRequirement) SetLocaleValues(v []*Locale) *QualificationRequirement {
	s.LocaleValues = v
	return s
}

// SetQualificationTypeId sets the QualificationTypeId field's value.
func (s *QualificationRequirement) SetQualificationTypeId(v string) *QualificationRequirement {
	s.QualificationTypeId = &v
	return s
}

// SetRequiredToPreview sets the RequiredToPreview field's value.
func (s *QualificationRequirement) SetRequiredToPreview(v bool) *QualificationRequirement {
	s.RequiredToPreview = &v
	return s
}

// The QualificationType data structure represents a Qualification type, a description
// of a property of a Worker that must match the requirements of a HIT for the
// Worker to be able to accept the HIT. The type also describes how a Worker
// can obtain a Qualification of that type, such as through a Qualification
// test.
type QualificationType struct {
	_ struct{} `type:"structure"`

	// The answers to the Qualification test specified in the Test parameter.
	AnswerKey *string `type:"string"`

	// Specifies that requests for the Qualification type are granted immediately,
	// without prompting the Worker with a Qualification test. Valid values are
	// True | False.
	AutoGranted *bool `type:"boolean"`

	// The Qualification integer value to use for automatically granted Qualifications,
	// if AutoGranted is true. This is 1 by default.
	AutoGrantedValue *int64 `type:"integer"`

	// The date and time the Qualification type was created.
	CreationTime *time.Time `type:"timestamp"`

	// A long description for the Qualification type.
	Description *string `type:"string"`

	// Specifies whether the Qualification type is one that a user can request through
	// the Amazon Mechanical Turk web site, such as by taking a Qualification test.
	// This value is False for Qualifications assigned automatically by the system.
	// Valid values are True | False.
	IsRequestable *bool `type:"boolean"`

	// One or more words or phrases that describe theQualification type, separated
	// by commas. The Keywords make the type easier to find using a search.
	Keywords *string `type:"string"`

	// The name of the Qualification type. The type name is used to identify the
	// type, and to find the type using a Qualification type search.
	Name *string `type:"string"`

	// A unique identifier for the Qualification type. A Qualification type is given
	// a Qualification type ID when you call the CreateQualificationType operation.
	QualificationTypeId *string `min:"1" type:"string"`

	// The status of the Qualification type. A Qualification type's status determines
	// if users can apply to receive a Qualification of this type, and if HITs can
	// be created with requirements based on this type. Valid values are Active
	// | Inactive.
	QualificationTypeStatus *string `type:"string" enum:"QualificationTypeStatus"`

	// The amount of time, in seconds, Workers must wait after taking the Qualification
	// test before they can take it again. Workers can take a Qualification test
	// multiple times if they were not granted the Qualification from a previous
	// attempt, or if the test offers a gradient score and they want a better score.
	// If not specified, retries are disabled and Workers can request a Qualification
	// only once.
	RetryDelayInSeconds *int64 `type:"long"`

	// The questions for a Qualification test associated with this Qualification
	// type that a user can take to obtain a Qualification of this type. This parameter
	// must be specified if AnswerKey is present. A Qualification type cannot have
	// both a specified Test parameter and an AutoGranted value of true.
	Test *string `type:"string"`

	// The amount of time, in seconds, given to a Worker to complete the Qualification
	// test, beginning from the time the Worker requests the Qualification.
	TestDurationInSeconds *int64 `type:"long"`
}

// String returns the string representation
func (s QualificationType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QualificationType) GoString() string {
	return s.String()
}

// SetAnswerKey sets the AnswerKey field's value.
func (s *QualificationType) SetAnswerKey(v string) *QualificationType {
	s.AnswerKey = &v
	return s
}

// SetAutoGranted sets the AutoGranted field's value.
func (s *QualificationType) SetAutoGranted(v bool) *QualificationType {
	s.AutoGranted = &v
	return s
}

// SetAutoGrantedValue sets the AutoGrantedValue field's value.
func (s *QualificationType) SetAutoGrantedValue(v int64) *QualificationType {
	s.AutoGrantedValue = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *QualificationType) SetCreationTime(v time.Time) *QualificationType {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *QualificationType) SetDescription(v string) *QualificationType {
	s.Description = &v
	return s
}

// SetIsRequestable sets the IsRequestable field's value.
func (s *QualificationType) SetIsRequestable(v bool) *QualificationType {
	s.IsRequestable = &v
	return s
}

// SetKeywords sets the Keywords field's value.
func (s *QualificationType) SetKeywords(v string) *QualificationType {
	s.Keywords = &v
	return s
}

// SetName sets the Name field's value.
func (s *QualificationType) SetName(v string) *QualificationType {
	s.Name = &v
	return s
}

// SetQualificationTypeId sets the QualificationTypeId field's value.
func (s *QualificationType) SetQualificationTypeId(v string) *QualificationType {
	s.QualificationTypeId = &v
	return s
}

// SetQualificationTypeStatus sets the QualificationTypeStatus field's value.
func (s *QualificationType) SetQualificationTypeStatus(v string) *QualificationType {
	s.QualificationTypeStatus = &v
	return s
}

// SetRetryDelayInSeconds sets the RetryDelayInSeconds field's value.
func (s *QualificationType) SetRetryDelayInSeconds(v int64) *QualificationType {
	s.RetryDelayInSeconds = &v
	return s
}

// SetTest sets the Test field's value.
func (s *QualificationType) SetTest(v string) *QualificationType {
	s.Test = &v
	return s
}

// SetTestDurationInSeconds sets the TestDurationInSeconds field's value.
func (s *QualificationType) SetTestDurationInSeconds(v int64) *QualificationType {
	s.TestDurationInSeconds = &v
	return s
}

type RejectAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the assignment. The assignment must correspond to a HIT created
	// by the Requester.
	//
	// AssignmentId is a required field
	AssignmentId *string `min:"1" type:"string" required:"true"`

	// A message for the Worker, which the Worker can see in the Status section
	// of the web site.
	//
	// RequesterFeedback is a required field
	RequesterFeedback *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RejectAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectAssignmentInput"}
	if s.AssignmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentId"))
	}
	if s.AssignmentId != nil && len(*s.AssignmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignmentId", 1))
	}
	if s.RequesterFeedback == nil {
		invalidParams.Add(request.NewErrParamRequired("RequesterFeedback"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentId sets the AssignmentId field's value.
func (s *RejectAssignmentInput) SetAssignmentId(v string) *RejectAssignmentInput {
	s.AssignmentId = &v
	return s
}

// SetRequesterFeedback sets the RequesterFeedback field's value.
func (s *RejectAssignmentInput) SetRequesterFeedback(v string) *RejectAssignmentInput {
	s.RequesterFeedback = &v
	return s
}

type RejectAssignmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RejectAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectAssignmentOutput) GoString() string {
	return s.String()
}

type RejectQualificationRequestInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Qualification request, as returned by the ListQualificationRequests
	// operation.
	//
	// QualificationRequestId is a required field
	QualificationRequestId *string `type:"string" required:"true"`

	// A text message explaining why the request was rejected, to be shown to the
	// Worker who made the request.
	Reason *string `type:"string"`
}

// String returns the string representation
func (s RejectQualificationRequestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectQualificationRequestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectQualificationRequestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectQualificationRequestInput"}
	if s.QualificationRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("QualificationRequestId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQualificationRequestId sets the QualificationRequestId field's value.
func (s *RejectQualificationRequestInput) SetQualificationRequestId(v string) *RejectQualificationRequestInput {
	s.QualificationRequestId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *RejectQualificationRequestInput) SetReason(v string) *RejectQualificationRequestInput {
	s.Reason = &v
	return s
}

type RejectQualificationRequestOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RejectQualificationRequestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectQualificationRequestOutput) GoString() string {
	return s.String()
}

// Both the AssignmentReviewReport and the HITReviewReport elements contains
// the ReviewActionDetail data structure. This structure is returned multiple
// times for each action specified in the Review Policy.
type ReviewActionDetail struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the action.
	ActionId *string `min:"1" type:"string"`

	// The nature of the action itself. The Review Policy is responsible for examining
	// the HIT and Assignments, emitting results, and deciding which other actions
	// will be necessary.
	ActionName *string `type:"string"`

	// The date when the action was completed.
	CompleteTime *time.Time `type:"timestamp"`

	// Present only when the Results have a FAILED Status.
	ErrorCode *string `type:"string"`

	// A description of the outcome of the review.
	Result *string `type:"string"`

	// The current disposition of the action: INTENDED, SUCCEEDED, FAILED, or CANCELLED.
	Status *string `type:"string" enum:"ReviewActionStatus"`

	// The specific HITId or AssignmentID targeted by the action.
	TargetId *string `min:"1" type:"string"`

	// The type of object in TargetId.
	TargetType *string `type:"string"`
}

// String returns the string representation
func (s ReviewActionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReviewActionDetail) GoString() string {
	return s.String()
}

// SetActionId sets the ActionId field's value.
func (s *ReviewActionDetail) SetActionId(v string) *ReviewActionDetail {
	s.ActionId = &v
	return s
}

// SetActionName sets the ActionName field's value.
func (s *ReviewActionDetail) SetActionName(v string) *ReviewActionDetail {
	s.ActionName = &v
	return s
}

// SetCompleteTime sets the CompleteTime field's value.
func (s *ReviewActionDetail) SetCompleteTime(v time.Time) *ReviewActionDetail {
	s.CompleteTime = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ReviewActionDetail) SetErrorCode(v string) *ReviewActionDetail {
	s.ErrorCode = &v
	return s
}

// SetResult sets the Result field's value.
func (s *ReviewActionDetail) SetResult(v string) *ReviewActionDetail {
	s.Result = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReviewActionDetail) SetStatus(v string) *ReviewActionDetail {
	s.Status = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *ReviewActionDetail) SetTargetId(v string) *ReviewActionDetail {
	s.TargetId = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *ReviewActionDetail) SetTargetType(v string) *ReviewActionDetail {
	s.TargetType = &v
	return s
}

// HIT Review Policy data structures represent HIT review policies, which you
// specify when you create a HIT.
type ReviewPolicy struct {
	_ struct{} `type:"structure"`

	// Name of the parameter from the Review policy.
	Parameters []*PolicyParameter `type:"list"`

	// Name of a Review Policy: SimplePlurality/2011-09-01 or ScoreMyKnownAnswers/2011-09-01
	//
	// PolicyName is a required field
	PolicyName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ReviewPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReviewPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReviewPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReviewPolicy"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameters sets the Parameters field's value.
func (s *ReviewPolicy) SetParameters(v []*PolicyParameter) *ReviewPolicy {
	s.Parameters = v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *ReviewPolicy) SetPolicyName(v string) *ReviewPolicy {
	s.PolicyName = &v
	return s
}

// Contains both ReviewResult and ReviewAction elements for a particular HIT.
type ReviewReport struct {
	_ struct{} `type:"structure"`

	// A list of ReviewAction objects for each action specified in the Review Policy.
	ReviewActions []*ReviewActionDetail `type:"list"`

	// A list of ReviewResults objects for each action specified in the Review Policy.
	ReviewResults []*ReviewResultDetail `type:"list"`
}

// String returns the string representation
func (s ReviewReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReviewReport) GoString() string {
	return s.String()
}

// SetReviewActions sets the ReviewActions field's value.
func (s *ReviewReport) SetReviewActions(v []*ReviewActionDetail) *ReviewReport {
	s.ReviewActions = v
	return s
}

// SetReviewResults sets the ReviewResults field's value.
func (s *ReviewReport) SetReviewResults(v []*ReviewResultDetail) *ReviewReport {
	s.ReviewResults = v
	return s
}

// This data structure is returned multiple times for each result specified
// in the Review Policy.
type ReviewResultDetail struct {
	_ struct{} `type:"structure"`

	// A unique identifier of the Review action result.
	ActionId *string `min:"1" type:"string"`

	// Key identifies the particular piece of reviewed information.
	Key *string `type:"string"`

	// Specifies the QuestionId the result is describing. Depending on whether the
	// TargetType is a HIT or Assignment this results could specify multiple values.
	// If TargetType is HIT and QuestionId is absent, then the result describes
	// results of the HIT, including the HIT agreement score. If ObjectType is Assignment
	// and QuestionId is absent, then the result describes the Worker's performance
	// on the HIT.
	QuestionId *string `min:"1" type:"string"`

	// The HITID or AssignmentId about which this result was taken. Note that HIT-level
	// Review Policies will often emit results about both the HIT itself and its
	// Assignments, while Assignment-level review policies generally only emit results
	// about the Assignment itself.
	SubjectId *string `min:"1" type:"string"`

	// The type of the object from the SubjectId field.
	SubjectType *string `type:"string"`

	// The values of Key provided by the review policies you have selected.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ReviewResultDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReviewResultDetail) GoString() string {
	return s.String()
}

// SetActionId sets the ActionId field's value.
func (s *ReviewResultDetail) SetActionId(v string) *ReviewResultDetail {
	s.ActionId = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ReviewResultDetail) SetKey(v string) *ReviewResultDetail {
	s.Key = &v
	return s
}

// SetQuestionId sets the QuestionId field's value.
func (s *ReviewResultDetail) SetQuestionId(v string) *ReviewResultDetail {
	s.QuestionId = &v
	return s
}

// SetSubjectId sets the SubjectId field's value.
func (s *ReviewResultDetail) SetSubjectId(v string) *ReviewResultDetail {
	s.SubjectId = &v
	return s
}

// SetSubjectType sets the SubjectType field's value.
func (s *ReviewResultDetail) SetSubjectType(v string) *ReviewResultDetail {
	s.SubjectType = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ReviewResultDetail) SetValue(v string) *ReviewResultDetail {
	s.Value = &v
	return s
}

type SendBonusInput struct {
	_ struct{} `type:"structure"`

	// The ID of the assignment for which this bonus is paid.
	//
	// AssignmentId is a required field
	AssignmentId *string `min:"1" type:"string" required:"true"`

	// The Bonus amount is a US Dollar amount specified using a string (for example,
	// "5" represents $5.00 USD and "101.42" represents $101.42 USD). Do not include
	// currency symbols or currency codes.
	//
	// BonusAmount is a required field
	BonusAmount *string `type:"string" required:"true"`

	// A message that explains the reason for the bonus payment. The Worker receiving
	// the bonus can see this message.
	//
	// Reason is a required field
	Reason *string `type:"string" required:"true"`

	// A unique identifier for this request, which allows you to retry the call
	// on error without granting multiple bonuses. This is useful in cases such
	// as network timeouts where it is unclear whether or not the call succeeded
	// on the server. If the bonus already exists in the system from a previous
	// call using the same UniqueRequestToken, subsequent calls will return an error
	// with a message containing the request ID.
	UniqueRequestToken *string `min:"1" type:"string"`

	// The ID of the Worker being paid the bonus.
	//
	// WorkerId is a required field
	WorkerId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SendBonusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendBonusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendBonusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendBonusInput"}
	if s.AssignmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentId"))
	}
	if s.AssignmentId != nil && len(*s.AssignmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssignmentId", 1))
	}
	if s.BonusAmount == nil {
		invalidParams.Add(request.NewErrParamRequired("BonusAmount"))
	}
	if s.Reason == nil {
		invalidParams.Add(request.NewErrParamRequired("Reason"))
	}
	if s.UniqueRequestToken != nil && len(*s.UniqueRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UniqueRequestToken", 1))
	}
	if s.WorkerId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerId"))
	}
	if s.WorkerId != nil && len(*s.WorkerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentId sets the AssignmentId field's value.
func (s *SendBonusInput) SetAssignmentId(v string) *SendBonusInput {
	s.AssignmentId = &v
	return s
}

// SetBonusAmount sets the BonusAmount field's value.
func (s *SendBonusInput) SetBonusAmount(v string) *SendBonusInput {
	s.BonusAmount = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *SendBonusInput) SetReason(v string) *SendBonusInput {
	s.Reason = &v
	return s
}

// SetUniqueRequestToken sets the UniqueRequestToken field's value.
func (s *SendBonusInput) SetUniqueRequestToken(v string) *SendBonusInput {
	s.UniqueRequestToken = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *SendBonusInput) SetWorkerId(v string) *SendBonusInput {
	s.WorkerId = &v
	return s
}

type SendBonusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SendBonusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendBonusOutput) GoString() string {
	return s.String()
}

type SendTestEventNotificationInput struct {
	_ struct{} `type:"structure"`

	// The notification specification to test. This value is identical to the value
	// you would provide to the UpdateNotificationSettings operation when you establish
	// the notification specification for a HIT type.
	//
	// Notification is a required field
	Notification *NotificationSpecification `type:"structure" required:"true"`

	// The event to simulate to test the notification specification. This event
	// is included in the test message even if the notification specification does
	// not include the event type. The notification specification does not filter
	// out the test event.
	//
	// TestEventType is a required field
	TestEventType *string `type:"string" required:"true" enum:"EventType"`
}

// String returns the string representation
func (s SendTestEventNotificationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendTestEventNotificationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendTestEventNotificationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendTestEventNotificationInput"}
	if s.Notification == nil {
		invalidParams.Add(request.NewErrParamRequired("Notification"))
	}
	if s.TestEventType == nil {
		invalidParams.Add(request.NewErrParamRequired("TestEventType"))
	}
	if s.Notification != nil {
		if err := s.Notification.Validate(); err != nil {
			invalidParams.AddNested("Notification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNotification sets the Notification field's value.
func (s *SendTestEventNotificationInput) SetNotification(v *NotificationSpecification) *SendTestEventNotificationInput {
	s.Notification = v
	return s
}

// SetTestEventType sets the TestEventType field's value.
func (s *SendTestEventNotificationInput) SetTestEventType(v string) *SendTestEventNotificationInput {
	s.TestEventType = &v
	return s
}

type SendTestEventNotificationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SendTestEventNotificationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendTestEventNotificationOutput) GoString() string {
	return s.String()
}

type UpdateExpirationForHITInput struct {
	_ struct{} `type:"structure"`

	// The date and time at which you want the HIT to expire
	//
	// ExpireAt is a required field
	ExpireAt *time.Time `type:"timestamp" required:"true"`

	// The HIT to update.
	//
	// HITId is a required field
	HITId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateExpirationForHITInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateExpirationForHITInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateExpirationForHITInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateExpirationForHITInput"}
	if s.ExpireAt == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpireAt"))
	}
	if s.HITId == nil {
		invalidParams.Add(request.NewErrParamRequired("HITId"))
	}
	if s.HITId != nil && len(*s.HITId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HITId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpireAt sets the ExpireAt field's value.
func (s *UpdateExpirationForHITInput) SetExpireAt(v time.Time) *UpdateExpirationForHITInput {
	s.ExpireAt = &v
	return s
}

// SetHITId sets the HITId field's value.
func (s *UpdateExpirationForHITInput) SetHITId(v string) *UpdateExpirationForHITInput {
	s.HITId = &v
	return s
}

type UpdateExpirationForHITOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateExpirationForHITOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateExpirationForHITOutput) GoString() string {
	return s.String()
}

type UpdateHITReviewStatusInput struct {
	_ struct{} `type:"structure"`

	// The ID of the HIT to update.
	//
	// HITId is a required field
	HITId *string `min:"1" type:"string" required:"true"`

	// Specifies how to update the HIT status. Default is False.
	//
	//    * Setting this to false will only transition a HIT from Reviewable to
	//    Reviewing
	//
	//    * Setting this to true will only transition a HIT from Reviewing to Reviewable
	Revert *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateHITReviewStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHITReviewStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateHITReviewStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateHITReviewStatusInput"}
	if s.HITId == nil {
		invalidParams.Add(request.NewErrParamRequired("HITId"))
	}
	if s.HITId != nil && len(*s.HITId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HITId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHITId sets the HITId field's value.
func (s *UpdateHITReviewStatusInput) SetHITId(v string) *UpdateHITReviewStatusInput {
	s.HITId = &v
	return s
}

// SetRevert sets the Revert field's value.
func (s *UpdateHITReviewStatusInput) SetRevert(v bool) *UpdateHITReviewStatusInput {
	s.Revert = &v
	return s
}

type UpdateHITReviewStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateHITReviewStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHITReviewStatusOutput) GoString() string {
	return s.String()
}

type UpdateHITTypeOfHITInput struct {
	_ struct{} `type:"structure"`

	// The HIT to update.
	//
	// HITId is a required field
	HITId *string `min:"1" type:"string" required:"true"`

	// The ID of the new HIT type.
	//
	// HITTypeId is a required field
	HITTypeId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateHITTypeOfHITInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHITTypeOfHITInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateHITTypeOfHITInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateHITTypeOfHITInput"}
	if s.HITId == nil {
		invalidParams.Add(request.NewErrParamRequired("HITId"))
	}
	if s.HITId != nil && len(*s.HITId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HITId", 1))
	}
	if s.HITTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("HITTypeId"))
	}
	if s.HITTypeId != nil && len(*s.HITTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HITTypeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHITId sets the HITId field's value.
func (s *UpdateHITTypeOfHITInput) SetHITId(v string) *UpdateHITTypeOfHITInput {
	s.HITId = &v
	return s
}

// SetHITTypeId sets the HITTypeId field's value.
func (s *UpdateHITTypeOfHITInput) SetHITTypeId(v string) *UpdateHITTypeOfHITInput {
	s.HITTypeId = &v
	return s
}

type UpdateHITTypeOfHITOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateHITTypeOfHITOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHITTypeOfHITOutput) GoString() string {
	return s.String()
}

type UpdateNotificationSettingsInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether notifications are sent for HITs of this HIT type, according
	// to the notification specification. You must specify either the Notification
	// parameter or the Active parameter for the call to UpdateNotificationSettings
	// to succeed.
	Active *bool `type:"boolean"`

	// The ID of the HIT type whose notification specification is being updated.
	//
	// HITTypeId is a required field
	HITTypeId *string `min:"1" type:"string" required:"true"`

	// The notification specification for the HIT type.
	Notification *NotificationSpecification `type:"structure"`
}

// String returns the string representation
func (s UpdateNotificationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNotificationSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNotificationSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNotificationSettingsInput"}
	if s.HITTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("HITTypeId"))
	}
	if s.HITTypeId != nil && len(*s.HITTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HITTypeId", 1))
	}
	if s.Notification != nil {
		if err := s.Notification.Validate(); err != nil {
			invalidParams.AddNested("Notification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActive sets the Active field's value.
func (s *UpdateNotificationSettingsInput) SetActive(v bool) *UpdateNotificationSettingsInput {
	s.Active = &v
	return s
}

// SetHITTypeId sets the HITTypeId field's value.
func (s *UpdateNotificationSettingsInput) SetHITTypeId(v string) *UpdateNotificationSettingsInput {
	s.HITTypeId = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *UpdateNotificationSettingsInput) SetNotification(v *NotificationSpecification) *UpdateNotificationSettingsInput {
	s.Notification = v
	return s
}

type UpdateNotificationSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateNotificationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNotificationSettingsOutput) GoString() string {
	return s.String()
}

type UpdateQualificationTypeInput struct {
	_ struct{} `type:"structure"`

	// The answers to the Qualification test specified in the Test parameter, in
	// the form of an AnswerKey data structure.
	AnswerKey *string `type:"string"`

	// Specifies whether requests for the Qualification type are granted immediately,
	// without prompting the Worker with a Qualification test.
	//
	// Constraints: If the Test parameter is specified, this parameter cannot be
	// true.
	AutoGranted *bool `type:"boolean"`

	// The Qualification value to use for automatically granted Qualifications.
	// This parameter is used only if the AutoGranted parameter is true.
	AutoGrantedValue *int64 `type:"integer"`

	// The new description of the Qualification type.
	Description *string `type:"string"`

	// The ID of the Qualification type to update.
	//
	// QualificationTypeId is a required field
	QualificationTypeId *string `min:"1" type:"string" required:"true"`

	// The new status of the Qualification type - Active | Inactive
	QualificationTypeStatus *string `type:"string" enum:"QualificationTypeStatus"`

	// The amount of time, in seconds, that Workers must wait after requesting a
	// Qualification of the specified Qualification type before they can retry the
	// Qualification request. It is not possible to disable retries for a Qualification
	// type after it has been created with retries enabled. If you want to disable
	// retries, you must dispose of the existing retry-enabled Qualification type
	// using DisposeQualificationType and then create a new Qualification type with
	// retries disabled using CreateQualificationType.
	RetryDelayInSeconds *int64 `type:"long"`

	// The questions for the Qualification test a Worker must answer correctly to
	// obtain a Qualification of this type. If this parameter is specified, TestDurationInSeconds
	// must also be specified.
	//
	// Constraints: Must not be longer than 65535 bytes. Must be a QuestionForm
	// data structure. This parameter cannot be specified if AutoGranted is true.
	//
	// Constraints: None. If not specified, the Worker may request the Qualification
	// without answering any questions.
	Test *string `type:"string"`

	// The number of seconds the Worker has to complete the Qualification test,
	// starting from the time the Worker requests the Qualification.
	TestDurationInSeconds *int64 `type:"long"`
}

// String returns the string representation
func (s UpdateQualificationTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateQualificationTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateQualificationTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateQualificationTypeInput"}
	if s.QualificationTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("QualificationTypeId"))
	}
	if s.QualificationTypeId != nil && len(*s.QualificationTypeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QualificationTypeId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnswerKey sets the AnswerKey field's value.
func (s *UpdateQualificationTypeInput) SetAnswerKey(v string) *UpdateQualificationTypeInput {
	s.AnswerKey = &v
	return s
}

// SetAutoGranted sets the AutoGranted field's value.
func (s *UpdateQualificationTypeInput) SetAutoGranted(v bool) *UpdateQualificationTypeInput {
	s.AutoGranted = &v
	return s
}

// SetAutoGrantedValue sets the AutoGrantedValue field's value.
func (s *UpdateQualificationTypeInput) SetAutoGrantedValue(v int64) *UpdateQualificationTypeInput {
	s.AutoGrantedValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateQualificationTypeInput) SetDescription(v string) *UpdateQualificationTypeInput {
	s.Description = &v
	return s
}

// SetQualificationTypeId sets the QualificationTypeId field's value.
func (s *UpdateQualificationTypeInput) SetQualificationTypeId(v string) *UpdateQualificationTypeInput {
	s.QualificationTypeId = &v
	return s
}

// SetQualificationTypeStatus sets the QualificationTypeStatus field's value.
func (s *UpdateQualificationTypeInput) SetQualificationTypeStatus(v string) *UpdateQualificationTypeInput {
	s.QualificationTypeStatus = &v
	return s
}

// SetRetryDelayInSeconds sets the RetryDelayInSeconds field's value.
func (s *UpdateQualificationTypeInput) SetRetryDelayInSeconds(v int64) *UpdateQualificationTypeInput {
	s.RetryDelayInSeconds = &v
	return s
}

// SetTest sets the Test field's value.
func (s *UpdateQualificationTypeInput) SetTest(v string) *UpdateQualificationTypeInput {
	s.Test = &v
	return s
}

// SetTestDurationInSeconds sets the TestDurationInSeconds field's value.
func (s *UpdateQualificationTypeInput) SetTestDurationInSeconds(v int64) *UpdateQualificationTypeInput {
	s.TestDurationInSeconds = &v
	return s
}

type UpdateQualificationTypeOutput struct {
	_ struct{} `type:"structure"`

	// Contains a QualificationType data structure.
	QualificationType *QualificationType `type:"structure"`
}

// String returns the string representation
func (s UpdateQualificationTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateQualificationTypeOutput) GoString() string {
	return s.String()
}

// SetQualificationType sets the QualificationType field's value.
func (s *UpdateQualificationTypeOutput) SetQualificationType(v *QualificationType) *UpdateQualificationTypeOutput {
	s.QualificationType = v
	return s
}

// The WorkerBlock data structure represents a Worker who has been blocked.
// It has two elements: the WorkerId and the Reason for the block.
type WorkerBlock struct {
	_ struct{} `type:"structure"`

	// A message explaining the reason the Worker was blocked.
	Reason *string `type:"string"`

	// The ID of the Worker who accepted the HIT.
	WorkerId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s WorkerBlock) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkerBlock) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *WorkerBlock) SetReason(v string) *WorkerBlock {
	s.Reason = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *WorkerBlock) SetWorkerId(v string) *WorkerBlock {
	s.WorkerId = &v
	return s
}

const (
	// AssignmentStatusSubmitted is a AssignmentStatus enum value
	AssignmentStatusSubmitted = "Submitted"

	// AssignmentStatusApproved is a AssignmentStatus enum value
	AssignmentStatusApproved = "Approved"

	// AssignmentStatusRejected is a AssignmentStatus enum value
	AssignmentStatusRejected = "Rejected"
)

const (
	// ComparatorLessThan is a Comparator enum value
	ComparatorLessThan = "LessThan"

	// ComparatorLessThanOrEqualTo is a Comparator enum value
	ComparatorLessThanOrEqualTo = "LessThanOrEqualTo"

	// ComparatorGreaterThan is a Comparator enum value
	ComparatorGreaterThan = "GreaterThan"

	// ComparatorGreaterThanOrEqualTo is a Comparator enum value
	ComparatorGreaterThanOrEqualTo = "GreaterThanOrEqualTo"

	// ComparatorEqualTo is a Comparator enum value
	ComparatorEqualTo = "EqualTo"

	// ComparatorNotEqualTo is a Comparator enum value
	ComparatorNotEqualTo = "NotEqualTo"

	// ComparatorExists is a Comparator enum value
	ComparatorExists = "Exists"

	// ComparatorDoesNotExist is a Comparator enum value
	ComparatorDoesNotExist = "DoesNotExist"

	// ComparatorIn is a Comparator enum value
	ComparatorIn = "In"

	// ComparatorNotIn is a Comparator enum value
	ComparatorNotIn = "NotIn"
)

const (
	// EventTypeAssignmentAccepted is a EventType enum value
	EventTypeAssignmentAccepted = "AssignmentAccepted"

	// EventTypeAssignmentAbandoned is a EventType enum value
	EventTypeAssignmentAbandoned = "AssignmentAbandoned"

	// EventTypeAssignmentReturned is a EventType enum value
	EventTypeAssignmentReturned = "AssignmentReturned"

	// EventTypeAssignmentSubmitted is a EventType enum value
	EventTypeAssignmentSubmitted = "AssignmentSubmitted"

	// EventTypeAssignmentRejected is a EventType enum value
	EventTypeAssignmentRejected = "AssignmentRejected"

	// EventTypeAssignmentApproved is a EventType enum value
	EventTypeAssignmentApproved = "AssignmentApproved"

	// EventTypeHitcreated is a EventType enum value
	EventTypeHitcreated = "HITCreated"

	// EventTypeHitexpired is a EventType enum value
	EventTypeHitexpired = "HITExpired"

	// EventTypeHitreviewable is a EventType enum value
	EventTypeHitreviewable = "HITReviewable"

	// EventTypeHitextended is a EventType enum value
	EventTypeHitextended = "HITExtended"

	// EventTypeHitdisposed is a EventType enum value
	EventTypeHitdisposed = "HITDisposed"

	// EventTypePing is a EventType enum value
	EventTypePing = "Ping"
)

const (
	// HITAccessActionsAccept is a HITAccessActions enum value
	HITAccessActionsAccept = "Accept"

	// HITAccessActionsPreviewAndAccept is a HITAccessActions enum value
	HITAccessActionsPreviewAndAccept = "PreviewAndAccept"

	// HITAccessActionsDiscoverPreviewAndAccept is a HITAccessActions enum value
	HITAccessActionsDiscoverPreviewAndAccept = "DiscoverPreviewAndAccept"
)

const (
	// HITReviewStatusNotReviewed is a HITReviewStatus enum value
	HITReviewStatusNotReviewed = "NotReviewed"

	// HITReviewStatusMarkedForReview is a HITReviewStatus enum value
	HITReviewStatusMarkedForReview = "MarkedForReview"

	// HITReviewStatusReviewedAppropriate is a HITReviewStatus enum value
	HITReviewStatusReviewedAppropriate = "ReviewedAppropriate"

	// HITReviewStatusReviewedInappropriate is a HITReviewStatus enum value
	HITReviewStatusReviewedInappropriate = "ReviewedInappropriate"
)

const (
	// HITStatusAssignable is a HITStatus enum value
	HITStatusAssignable = "Assignable"

	// HITStatusUnassignable is a HITStatus enum value
	HITStatusUnassignable = "Unassignable"

	// HITStatusReviewable is a HITStatus enum value
	HITStatusReviewable = "Reviewable"

	// HITStatusReviewing is a HITStatus enum value
	HITStatusReviewing = "Reviewing"

	// HITStatusDisposed is a HITStatus enum value
	HITStatusDisposed = "Disposed"
)

const (
	// NotificationTransportEmail is a NotificationTransport enum value
	NotificationTransportEmail = "Email"

	// NotificationTransportSqs is a NotificationTransport enum value
	NotificationTransportSqs = "SQS"

	// NotificationTransportSns is a NotificationTransport enum value
	NotificationTransportSns = "SNS"
)

const (
	// NotifyWorkersFailureCodeSoftFailure is a NotifyWorkersFailureCode enum value
	NotifyWorkersFailureCodeSoftFailure = "SoftFailure"

	// NotifyWorkersFailureCodeHardFailure is a NotifyWorkersFailureCode enum value
	NotifyWorkersFailureCodeHardFailure = "HardFailure"
)

const (
	// QualificationStatusGranted is a QualificationStatus enum value
	QualificationStatusGranted = "Granted"

	// QualificationStatusRevoked is a QualificationStatus enum value
	QualificationStatusRevoked = "Revoked"
)

const (
	// QualificationTypeStatusActive is a QualificationTypeStatus enum value
	QualificationTypeStatusActive = "Active"

	// QualificationTypeStatusInactive is a QualificationTypeStatus enum value
	QualificationTypeStatusInactive = "Inactive"
)

const (
	// ReviewActionStatusIntended is a ReviewActionStatus enum value
	ReviewActionStatusIntended = "Intended"

	// ReviewActionStatusSucceeded is a ReviewActionStatus enum value
	ReviewActionStatusSucceeded = "Succeeded"

	// ReviewActionStatusFailed is a ReviewActionStatus enum value
	ReviewActionStatusFailed = "Failed"

	// ReviewActionStatusCancelled is a ReviewActionStatus enum value
	ReviewActionStatusCancelled = "Cancelled"
)

const (
	// ReviewPolicyLevelAssignment is a ReviewPolicyLevel enum value
	ReviewPolicyLevelAssignment = "Assignment"

	// ReviewPolicyLevelHit is a ReviewPolicyLevel enum value
	ReviewPolicyLevelHit = "HIT"
)

const (
	// ReviewableHITStatusReviewable is a ReviewableHITStatus enum value
	ReviewableHITStatusReviewable = "Reviewable"

	// ReviewableHITStatusReviewing is a ReviewableHITStatus enum value
	ReviewableHITStatusReviewing = "Reviewing"
)
