// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/websecurityscanner/v1beta/scan_run.proto

package websecurityscanner // import "google.golang.org/genproto/googleapis/cloud/websecurityscanner/v1beta"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Types of ScanRun execution state.
type ScanRun_ExecutionState int32

const (
	// Represents an invalid state caused by internal server error. This value
	// should never be returned.
	ScanRun_EXECUTION_STATE_UNSPECIFIED ScanRun_ExecutionState = 0
	// The scan is waiting in the queue.
	ScanRun_QUEUED ScanRun_ExecutionState = 1
	// The scan is in progress.
	ScanRun_SCANNING ScanRun_ExecutionState = 2
	// The scan is either finished or stopped by user.
	ScanRun_FINISHED ScanRun_ExecutionState = 3
)

var ScanRun_ExecutionState_name = map[int32]string{
	0: "EXECUTION_STATE_UNSPECIFIED",
	1: "QUEUED",
	2: "SCANNING",
	3: "FINISHED",
}
var ScanRun_ExecutionState_value = map[string]int32{
	"EXECUTION_STATE_UNSPECIFIED": 0,
	"QUEUED":                      1,
	"SCANNING":                    2,
	"FINISHED":                    3,
}

func (x ScanRun_ExecutionState) String() string {
	return proto.EnumName(ScanRun_ExecutionState_name, int32(x))
}
func (ScanRun_ExecutionState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_scan_run_4ba20ab7789cc312, []int{0, 0}
}

// Types of ScanRun result state.
type ScanRun_ResultState int32

const (
	// Default value. This value is returned when the ScanRun is not yet
	// finished.
	ScanRun_RESULT_STATE_UNSPECIFIED ScanRun_ResultState = 0
	// The scan finished without errors.
	ScanRun_SUCCESS ScanRun_ResultState = 1
	// The scan finished with errors.
	ScanRun_ERROR ScanRun_ResultState = 2
	// The scan was terminated by user.
	ScanRun_KILLED ScanRun_ResultState = 3
)

var ScanRun_ResultState_name = map[int32]string{
	0: "RESULT_STATE_UNSPECIFIED",
	1: "SUCCESS",
	2: "ERROR",
	3: "KILLED",
}
var ScanRun_ResultState_value = map[string]int32{
	"RESULT_STATE_UNSPECIFIED": 0,
	"SUCCESS":                  1,
	"ERROR":                    2,
	"KILLED":                   3,
}

func (x ScanRun_ResultState) String() string {
	return proto.EnumName(ScanRun_ResultState_name, int32(x))
}
func (ScanRun_ResultState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_scan_run_4ba20ab7789cc312, []int{0, 1}
}

// A ScanRun is a output-only resource representing an actual run of the scan.
// Next id: 12
type ScanRun struct {
	// Output only.
	// The resource name of the ScanRun. The name follows the format of
	// 'projects/{projectId}/scanConfigs/{scanConfigId}/scanRuns/{scanRunId}'.
	// The ScanRun IDs are generated by the system.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only.
	// The execution state of the ScanRun.
	ExecutionState ScanRun_ExecutionState `protobuf:"varint,2,opt,name=execution_state,json=executionState,proto3,enum=google.cloud.websecurityscanner.v1beta.ScanRun_ExecutionState" json:"execution_state,omitempty"`
	// Output only.
	// The result state of the ScanRun. This field is only available after the
	// execution state reaches "FINISHED".
	ResultState ScanRun_ResultState `protobuf:"varint,3,opt,name=result_state,json=resultState,proto3,enum=google.cloud.websecurityscanner.v1beta.ScanRun_ResultState" json:"result_state,omitempty"`
	// Output only.
	// The time at which the ScanRun started.
	StartTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only.
	// The time at which the ScanRun reached termination state - that the ScanRun
	// is either finished or stopped by user.
	EndTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only.
	// The number of URLs crawled during this ScanRun. If the scan is in progress,
	// the value represents the number of URLs crawled up to now.
	UrlsCrawledCount int64 `protobuf:"varint,6,opt,name=urls_crawled_count,json=urlsCrawledCount,proto3" json:"urls_crawled_count,omitempty"`
	// Output only.
	// The number of URLs tested during this ScanRun. If the scan is in progress,
	// the value represents the number of URLs tested up to now. The number of
	// URLs tested is usually larger than the number URLS crawled because
	// typically a crawled URL is tested with multiple test payloads.
	UrlsTestedCount int64 `protobuf:"varint,7,opt,name=urls_tested_count,json=urlsTestedCount,proto3" json:"urls_tested_count,omitempty"`
	// Output only.
	// Whether the scan run has found any vulnerabilities.
	HasVulnerabilities bool `protobuf:"varint,8,opt,name=has_vulnerabilities,json=hasVulnerabilities,proto3" json:"has_vulnerabilities,omitempty"`
	// Output only.
	// The percentage of total completion ranging from 0 to 100.
	// If the scan is in queue, the value is 0.
	// If the scan is running, the value ranges from 0 to 100.
	// If the scan is finished, the value is 100.
	ProgressPercent int32 `protobuf:"varint,9,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Output only.
	// If result_state is an ERROR, this field provides the primary reason for
	// scan's termination and more details, if such are available.
	ErrorTrace *ScanRunErrorTrace `protobuf:"bytes,10,opt,name=error_trace,json=errorTrace,proto3" json:"error_trace,omitempty"`
	// Output only.
	// A list of warnings, if such are encountered during this scan run.
	WarningTraces        []*ScanRunWarningTrace `protobuf:"bytes,11,rep,name=warning_traces,json=warningTraces,proto3" json:"warning_traces,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ScanRun) Reset()         { *m = ScanRun{} }
func (m *ScanRun) String() string { return proto.CompactTextString(m) }
func (*ScanRun) ProtoMessage()    {}
func (*ScanRun) Descriptor() ([]byte, []int) {
	return fileDescriptor_scan_run_4ba20ab7789cc312, []int{0}
}
func (m *ScanRun) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScanRun.Unmarshal(m, b)
}
func (m *ScanRun) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScanRun.Marshal(b, m, deterministic)
}
func (dst *ScanRun) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScanRun.Merge(dst, src)
}
func (m *ScanRun) XXX_Size() int {
	return xxx_messageInfo_ScanRun.Size(m)
}
func (m *ScanRun) XXX_DiscardUnknown() {
	xxx_messageInfo_ScanRun.DiscardUnknown(m)
}

var xxx_messageInfo_ScanRun proto.InternalMessageInfo

func (m *ScanRun) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ScanRun) GetExecutionState() ScanRun_ExecutionState {
	if m != nil {
		return m.ExecutionState
	}
	return ScanRun_EXECUTION_STATE_UNSPECIFIED
}

func (m *ScanRun) GetResultState() ScanRun_ResultState {
	if m != nil {
		return m.ResultState
	}
	return ScanRun_RESULT_STATE_UNSPECIFIED
}

func (m *ScanRun) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *ScanRun) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *ScanRun) GetUrlsCrawledCount() int64 {
	if m != nil {
		return m.UrlsCrawledCount
	}
	return 0
}

func (m *ScanRun) GetUrlsTestedCount() int64 {
	if m != nil {
		return m.UrlsTestedCount
	}
	return 0
}

func (m *ScanRun) GetHasVulnerabilities() bool {
	if m != nil {
		return m.HasVulnerabilities
	}
	return false
}

func (m *ScanRun) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *ScanRun) GetErrorTrace() *ScanRunErrorTrace {
	if m != nil {
		return m.ErrorTrace
	}
	return nil
}

func (m *ScanRun) GetWarningTraces() []*ScanRunWarningTrace {
	if m != nil {
		return m.WarningTraces
	}
	return nil
}

func init() {
	proto.RegisterType((*ScanRun)(nil), "google.cloud.websecurityscanner.v1beta.ScanRun")
	proto.RegisterEnum("google.cloud.websecurityscanner.v1beta.ScanRun_ExecutionState", ScanRun_ExecutionState_name, ScanRun_ExecutionState_value)
	proto.RegisterEnum("google.cloud.websecurityscanner.v1beta.ScanRun_ResultState", ScanRun_ResultState_name, ScanRun_ResultState_value)
}

func init() {
	proto.RegisterFile("google/cloud/websecurityscanner/v1beta/scan_run.proto", fileDescriptor_scan_run_4ba20ab7789cc312)
}

var fileDescriptor_scan_run_4ba20ab7789cc312 = []byte{
	// 616 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x94, 0x5d, 0x4b, 0xdc, 0x4c,
	0x14, 0xc7, 0x9f, 0xb8, 0xba, 0x2f, 0x27, 0x3e, 0x6b, 0x3a, 0xbd, 0x09, 0x56, 0x30, 0x78, 0x51,
	0x52, 0x29, 0x09, 0xb5, 0x78, 0x21, 0x42, 0x41, 0x63, 0x6c, 0x43, 0x65, 0xdd, 0x26, 0xd9, 0xd6,
	0x7a, 0xd1, 0x30, 0x9b, 0x9d, 0xc6, 0x40, 0x76, 0xb2, 0xcc, 0x4c, 0xdc, 0xf6, 0x8b, 0xf4, 0xc3,
	0xf6, 0xaa, 0xcc, 0x24, 0x6b, 0x5d, 0x2c, 0xe8, 0xde, 0xe5, 0xbc, 0xfc, 0x7f, 0x7f, 0xce, 0x99,
	0x43, 0xe0, 0x30, 0x2b, 0xcb, 0xac, 0x20, 0x6e, 0x5a, 0x94, 0xd5, 0xc4, 0x9d, 0x93, 0x31, 0x27,
	0x69, 0xc5, 0x72, 0xf1, 0x93, 0xa7, 0x98, 0x52, 0xc2, 0xdc, 0xdb, 0x37, 0x63, 0x22, 0xb0, 0x2b,
	0xc3, 0x84, 0x55, 0xd4, 0x99, 0xb1, 0x52, 0x94, 0xe8, 0x65, 0x2d, 0x73, 0x94, 0xcc, 0x79, 0x28,
	0x73, 0x6a, 0xd9, 0xf6, 0x4e, 0x83, 0xc7, 0xb3, 0xdc, 0xc5, 0x94, 0x96, 0x02, 0x8b, 0xbc, 0xa4,
	0xbc, 0xa6, 0x6c, 0x9f, 0xac, 0x68, 0x9e, 0x10, 0xc6, 0x4a, 0x96, 0x08, 0x86, 0x53, 0xd2, 0x20,
	0xbc, 0x55, 0x11, 0x73, 0xcc, 0x68, 0x4e, 0xb3, 0x25, 0xc8, 0x6e, 0x03, 0x51, 0xd1, 0xb8, 0xfa,
	0xee, 0x8a, 0x7c, 0x4a, 0xb8, 0xc0, 0xd3, 0x59, 0xdd, 0xb0, 0xf7, 0xbb, 0x0d, 0x9d, 0x28, 0xc5,
	0x34, 0xac, 0x28, 0x42, 0xb0, 0x4e, 0xf1, 0x94, 0x98, 0x9a, 0xa5, 0xd9, 0xbd, 0x50, 0x7d, 0xa3,
	0x0c, 0xb6, 0xc8, 0x0f, 0x92, 0x56, 0x72, 0xb8, 0x84, 0x0b, 0x2c, 0x88, 0xb9, 0x66, 0x69, 0x76,
	0xff, 0xe0, 0x9d, 0xf3, 0xb4, 0x45, 0x39, 0x0d, 0xdd, 0xf1, 0x17, 0x98, 0x48, 0x52, 0xc2, 0x3e,
	0x59, 0x8a, 0xd1, 0x37, 0xd8, 0x64, 0x84, 0x57, 0x85, 0x68, 0x5c, 0x5a, 0xca, 0xe5, 0x78, 0x55,
	0x97, 0x50, 0x31, 0x6a, 0x0b, 0x9d, 0xfd, 0x0d, 0xd0, 0x11, 0x00, 0x17, 0x98, 0x89, 0x44, 0x6e,
	0xc0, 0x5c, 0xb7, 0x34, 0x5b, 0x3f, 0xd8, 0x5e, 0xd0, 0x17, 0xeb, 0x71, 0xe2, 0xc5, 0x7a, 0xc2,
	0x9e, 0xea, 0x96, 0x31, 0x3a, 0x84, 0x2e, 0xa1, 0x93, 0x5a, 0xb8, 0xf1, 0xa8, 0xb0, 0x43, 0xe8,
	0x44, 0xc9, 0x5e, 0x03, 0xaa, 0x58, 0xc1, 0x93, 0x94, 0xe1, 0x79, 0x41, 0x26, 0x49, 0x5a, 0x56,
	0x54, 0x98, 0x6d, 0x4b, 0xb3, 0x5b, 0xa1, 0x21, 0x2b, 0x5e, 0x5d, 0xf0, 0x64, 0x1e, 0xed, 0xc3,
	0x33, 0xd5, 0x2d, 0x08, 0x17, 0x77, 0xcd, 0x1d, 0xd5, 0xbc, 0x25, 0x0b, 0xb1, 0xca, 0xd7, 0xbd,
	0x2e, 0x3c, 0xbf, 0xc1, 0x3c, 0xb9, 0xad, 0x0a, 0x4a, 0x18, 0x1e, 0xe7, 0x45, 0x2e, 0x72, 0xc2,
	0xcd, 0xae, 0xa5, 0xd9, 0xdd, 0x10, 0xdd, 0x60, 0xfe, 0x79, 0xb9, 0x82, 0x5e, 0x81, 0x31, 0x63,
	0x65, 0xc6, 0x08, 0xe7, 0xc9, 0x8c, 0xb0, 0x94, 0x50, 0x61, 0xf6, 0x2c, 0xcd, 0xde, 0x08, 0xb7,
	0x16, 0xf9, 0x61, 0x9d, 0x46, 0xd7, 0xa0, 0xdf, 0xbb, 0x45, 0x13, 0xd4, 0xbc, 0x47, 0x2b, 0x3e,
	0x83, 0x2f, 0x09, 0xb1, 0x04, 0x84, 0x40, 0xee, 0xbe, 0xd1, 0x18, 0xfa, 0x4b, 0x47, 0xca, 0x4d,
	0xdd, 0x6a, 0xd9, 0xfa, 0xca, 0xaf, 0xfc, 0xa5, 0x86, 0xd4, 0x06, 0xff, 0xcf, 0xef, 0x45, 0x7c,
	0xef, 0x2b, 0xf4, 0x97, 0x2f, 0x0d, 0xed, 0xc2, 0x0b, 0xff, 0xca, 0xf7, 0x46, 0x71, 0x70, 0x39,
	0x48, 0xa2, 0xf8, 0x24, 0xf6, 0x93, 0xd1, 0x20, 0x1a, 0xfa, 0x5e, 0x70, 0x1e, 0xf8, 0x67, 0xc6,
	0x7f, 0x08, 0xa0, 0xfd, 0x69, 0xe4, 0x8f, 0xfc, 0x33, 0x43, 0x43, 0x9b, 0xd0, 0x8d, 0xbc, 0x93,
	0xc1, 0x20, 0x18, 0xbc, 0x37, 0xd6, 0x64, 0x74, 0x1e, 0x0c, 0x82, 0xe8, 0x83, 0x7f, 0x66, 0xb4,
	0xf6, 0x2e, 0x41, 0xbf, 0x77, 0x5e, 0x68, 0x07, 0xcc, 0xd0, 0x8f, 0x46, 0x17, 0xf1, 0x3f, 0xa1,
	0x3a, 0x74, 0xa2, 0x91, 0xe7, 0xf9, 0x51, 0x64, 0x68, 0xa8, 0x07, 0x1b, 0x7e, 0x18, 0x5e, 0x86,
	0xc6, 0x9a, 0x34, 0xfb, 0x18, 0x5c, 0x5c, 0x48, 0xe0, 0xe9, 0x2f, 0x0d, 0xf6, 0xd3, 0x72, 0xfa,
	0xc4, 0xe9, 0x4f, 0x37, 0x9b, 0xf1, 0x87, 0xf2, 0xe8, 0x86, 0xda, 0xf5, 0x55, 0xa3, 0xcb, 0xca,
	0x02, 0xd3, 0xcc, 0x29, 0x59, 0xe6, 0x66, 0x84, 0xaa, 0x93, 0x74, 0xeb, 0x12, 0x9e, 0xe5, 0xfc,
	0xb1, 0x1f, 0xc8, 0xf1, 0xc3, 0xca, 0xb8, 0xad, 0x20, 0x6f, 0xff, 0x04, 0x00, 0x00, 0xff, 0xff,
	0x9e, 0x77, 0x0e, 0xed, 0x44, 0x05, 0x00, 0x00,
}
