// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/billing.proto

package serviceconfig // import "google.golang.org/genproto/googleapis/api/serviceconfig"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/metric"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Billing related configuration of the service.
//
// The following example shows how to configure monitored resources and metrics
// for billing:
//
//     monitored_resources:
//     - type: library.googleapis.com/branch
//       labels:
//       - key: /city
//         description: The city where the library branch is located in.
//       - key: /name
//         description: The name of the branch.
//     metrics:
//     - name: library.googleapis.com/book/borrowed_count
//       metric_kind: DELTA
//       value_type: INT64
//     billing:
//       consumer_destinations:
//       - monitored_resource: library.googleapis.com/branch
//         metrics:
//         - library.googleapis.com/book/borrowed_count
type Billing struct {
	// Billing configurations for sending metrics to the consumer project.
	// There can be multiple consumer destinations per service, each one must have
	// a different monitored resource type. A metric can be used in at most
	// one consumer destination.
	ConsumerDestinations []*Billing_BillingDestination `protobuf:"bytes,8,rep,name=consumer_destinations,json=consumerDestinations,proto3" json:"consumer_destinations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *Billing) Reset()         { *m = Billing{} }
func (m *Billing) String() string { return proto.CompactTextString(m) }
func (*Billing) ProtoMessage()    {}
func (*Billing) Descriptor() ([]byte, []int) {
	return fileDescriptor_billing_7a62f78f020eadae, []int{0}
}
func (m *Billing) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Billing.Unmarshal(m, b)
}
func (m *Billing) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Billing.Marshal(b, m, deterministic)
}
func (dst *Billing) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Billing.Merge(dst, src)
}
func (m *Billing) XXX_Size() int {
	return xxx_messageInfo_Billing.Size(m)
}
func (m *Billing) XXX_DiscardUnknown() {
	xxx_messageInfo_Billing.DiscardUnknown(m)
}

var xxx_messageInfo_Billing proto.InternalMessageInfo

func (m *Billing) GetConsumerDestinations() []*Billing_BillingDestination {
	if m != nil {
		return m.ConsumerDestinations
	}
	return nil
}

// Configuration of a specific billing destination (Currently only support
// bill against consumer project).
type Billing_BillingDestination struct {
	// The monitored resource type. The type must be defined in
	// [Service.monitored_resources][google.api.Service.monitored_resources] section.
	MonitoredResource string `protobuf:"bytes,1,opt,name=monitored_resource,json=monitoredResource,proto3" json:"monitored_resource,omitempty"`
	// Names of the metrics to report to this billing destination.
	// Each name must be defined in [Service.metrics][google.api.Service.metrics] section.
	Metrics              []string `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Billing_BillingDestination) Reset()         { *m = Billing_BillingDestination{} }
func (m *Billing_BillingDestination) String() string { return proto.CompactTextString(m) }
func (*Billing_BillingDestination) ProtoMessage()    {}
func (*Billing_BillingDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_billing_7a62f78f020eadae, []int{0, 0}
}
func (m *Billing_BillingDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Billing_BillingDestination.Unmarshal(m, b)
}
func (m *Billing_BillingDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Billing_BillingDestination.Marshal(b, m, deterministic)
}
func (dst *Billing_BillingDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Billing_BillingDestination.Merge(dst, src)
}
func (m *Billing_BillingDestination) XXX_Size() int {
	return xxx_messageInfo_Billing_BillingDestination.Size(m)
}
func (m *Billing_BillingDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_Billing_BillingDestination.DiscardUnknown(m)
}

var xxx_messageInfo_Billing_BillingDestination proto.InternalMessageInfo

func (m *Billing_BillingDestination) GetMonitoredResource() string {
	if m != nil {
		return m.MonitoredResource
	}
	return ""
}

func (m *Billing_BillingDestination) GetMetrics() []string {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func init() {
	proto.RegisterType((*Billing)(nil), "google.api.Billing")
	proto.RegisterType((*Billing_BillingDestination)(nil), "google.api.Billing.BillingDestination")
}

func init() { proto.RegisterFile("google/api/billing.proto", fileDescriptor_billing_7a62f78f020eadae) }

var fileDescriptor_billing_7a62f78f020eadae = []byte{
	// 255 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x64, 0x90, 0xc1, 0x4a, 0xc4, 0x30,
	0x10, 0x86, 0xe9, 0xae, 0xb8, 0x6e, 0x14, 0xc1, 0xa0, 0x18, 0xf6, 0x54, 0x3c, 0x48, 0x2f, 0xa6,
	0xa0, 0x47, 0x4f, 0x16, 0x45, 0xbc, 0x95, 0x1e, 0x15, 0x59, 0xb2, 0xd9, 0x31, 0x0c, 0xb4, 0x99,
	0x92, 0x64, 0x7d, 0x20, 0xdf, 0xc5, 0xf7, 0x12, 0x9b, 0xd6, 0x56, 0xf6, 0x14, 0x26, 0xdf, 0xf7,
	0x4f, 0x26, 0xc3, 0x84, 0x21, 0x32, 0x35, 0xe4, 0xaa, 0xc5, 0x7c, 0x83, 0x75, 0x8d, 0xd6, 0xc8,
	0xd6, 0x51, 0x20, 0xce, 0x22, 0x91, 0xaa, 0xc5, 0xd5, 0xe5, 0xc4, 0x6a, 0x20, 0x38, 0xd4, 0x51,
	0xba, 0xfa, 0x4e, 0xd8, 0xa2, 0x88, 0x31, 0xfe, 0xc6, 0x2e, 0x34, 0x59, 0xbf, 0x6b, 0xc0, 0xad,
	0xb7, 0xe0, 0x03, 0x5a, 0x15, 0x90, 0xac, 0x17, 0x47, 0xe9, 0x3c, 0x3b, 0xbe, 0xbd, 0x96, 0x63,
	0x43, 0xd9, 0x67, 0x86, 0xf3, 0x71, 0xd4, 0xab, 0xf3, 0xa1, 0xc9, 0xe4, 0xd2, 0xaf, 0xde, 0x19,
	0xdf, 0x77, 0xf9, 0x0d, 0xe3, 0x0d, 0x59, 0x0c, 0xe4, 0x60, 0xbb, 0x76, 0xe0, 0x69, 0xe7, 0x34,
	0x88, 0x24, 0x4d, 0xb2, 0x65, 0x75, 0xf6, 0x47, 0xaa, 0x1e, 0x70, 0xc1, 0x16, 0x71, 0x7a, 0x2f,
	0x66, 0xe9, 0x3c, 0x5b, 0x56, 0x43, 0x59, 0x58, 0x76, 0xaa, 0xa9, 0x99, 0x4c, 0x58, 0x9c, 0xf4,
	0xcf, 0x95, 0xbf, 0xff, 0x2c, 0x93, 0xd7, 0xa7, 0x9e, 0x19, 0xaa, 0x95, 0x35, 0x92, 0x9c, 0xc9,
	0x0d, 0xd8, 0x6e, 0x0b, 0x79, 0x44, 0xaa, 0x45, 0xdf, 0x6d, 0xc8, 0x83, 0xfb, 0x44, 0x0d, 0x9a,
	0xec, 0x07, 0x9a, 0xfb, 0x7f, 0xd5, 0xd7, 0xec, 0xe0, 0xf9, 0xa1, 0x7c, 0xd9, 0x1c, 0x76, 0xc1,
	0xbb, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x27, 0xa0, 0xf0, 0x6b, 0x7f, 0x01, 0x00, 0x00,
}
