// Code generated by yy. DO NOT EDIT.

// Copyright 2016 The CC Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package cc // import "modernc.org/cc"

import (
	"go/token"

	"modernc.org/xc"
)

// AbstractDeclarator represents data reduced by productions:
//
//	AbstractDeclarator:
//	        Pointer
//	|       PointerOpt DirectAbstractDeclarator  // Case 1
type AbstractDeclarator struct {
	declarator               *Declarator
	Case                     int
	DirectAbstractDeclarator *DirectAbstractDeclarator
	Pointer                  *Pointer
	PointerOpt               *PointerOpt
}

func (n *AbstractDeclarator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *AbstractDeclarator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *AbstractDeclarator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Pointer.Pos()
	case 1:
		if p := n.PointerOpt.Pos(); p != 0 {
			return p
		}

		return n.DirectAbstractDeclarator.Pos()
	default:
		panic("internal error")
	}
}

// AbstractDeclaratorOpt represents data reduced by productions:
//
//	AbstractDeclaratorOpt:
//	        /* empty */
//	|       AbstractDeclarator  // Case 1
type AbstractDeclaratorOpt struct {
	AbstractDeclarator *AbstractDeclarator
}

func (n *AbstractDeclaratorOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *AbstractDeclaratorOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *AbstractDeclaratorOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.AbstractDeclarator.Pos()
}

// ArgumentExpressionList represents data reduced by productions:
//
//	ArgumentExpressionList:
//	        Expression
//	|       ArgumentExpressionList ',' Expression  // Case 1
type ArgumentExpressionList struct {
	ArgumentExpressionList *ArgumentExpressionList
	Case                   int
	Expression             *Expression
	Token                  xc.Token
}

func (n *ArgumentExpressionList) reverse() *ArgumentExpressionList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.ArgumentExpressionList
	for nb != nil {
		nc := nb.ArgumentExpressionList
		nb.ArgumentExpressionList = na
		na = nb
		nb = nc
	}
	n.ArgumentExpressionList = nil
	return na
}

func (n *ArgumentExpressionList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *ArgumentExpressionList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ArgumentExpressionList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 1:
		return n.ArgumentExpressionList.Pos()
	case 0:
		return n.Expression.Pos()
	default:
		panic("internal error")
	}
}

// ArgumentExpressionListOpt represents data reduced by productions:
//
//	ArgumentExpressionListOpt:
//	        /* empty */
//	|       ArgumentExpressionList  // Case 1
type ArgumentExpressionListOpt struct {
	ArgumentExpressionList *ArgumentExpressionList
}

func (n *ArgumentExpressionListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ArgumentExpressionListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ArgumentExpressionListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.ArgumentExpressionList.Pos()
}

// AssemblerInstructions represents data reduced by productions:
//
//	AssemblerInstructions:
//	        STRINGLITERAL
//	|       AssemblerInstructions STRINGLITERAL  // Case 1
type AssemblerInstructions struct {
	AssemblerInstructions *AssemblerInstructions
	Case                  int
	Token                 xc.Token
}

func (n *AssemblerInstructions) reverse() *AssemblerInstructions {
	if n == nil {
		return nil
	}

	na := n
	nb := na.AssemblerInstructions
	for nb != nil {
		nc := nb.AssemblerInstructions
		nb.AssemblerInstructions = na
		na = nb
		nb = nc
	}
	n.AssemblerInstructions = nil
	return na
}

func (n *AssemblerInstructions) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *AssemblerInstructions) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *AssemblerInstructions) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 1:
		return n.AssemblerInstructions.Pos()
	case 0:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// AssemblerOperand represents data reduced by production:
//
//	AssemblerOperand:
//	        AssemblerSymbolicNameOpt STRINGLITERAL '(' Expression ')'
type AssemblerOperand struct {
	AssemblerSymbolicNameOpt *AssemblerSymbolicNameOpt
	Expression               *Expression
	Token                    xc.Token
	Token2                   xc.Token
	Token3                   xc.Token
}

func (n *AssemblerOperand) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *AssemblerOperand) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *AssemblerOperand) Pos() token.Pos {
	if n == nil {
		return 0
	}

	if p := n.AssemblerSymbolicNameOpt.Pos(); p != 0 {
		return p
	}

	return n.Token.Pos()
}

// AssemblerOperands represents data reduced by productions:
//
//	AssemblerOperands:
//	        AssemblerOperand
//	|       AssemblerOperands ',' AssemblerOperand  // Case 1
type AssemblerOperands struct {
	AssemblerOperand  *AssemblerOperand
	AssemblerOperands *AssemblerOperands
	Case              int
	Token             xc.Token
}

func (n *AssemblerOperands) reverse() *AssemblerOperands {
	if n == nil {
		return nil
	}

	na := n
	nb := na.AssemblerOperands
	for nb != nil {
		nc := nb.AssemblerOperands
		nb.AssemblerOperands = na
		na = nb
		nb = nc
	}
	n.AssemblerOperands = nil
	return na
}

func (n *AssemblerOperands) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *AssemblerOperands) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *AssemblerOperands) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.AssemblerOperand.Pos()
	case 1:
		return n.AssemblerOperands.Pos()
	default:
		panic("internal error")
	}
}

// AssemblerStatement represents data reduced by productions:
//
//	AssemblerStatement:
//	        BasicAssemblerStatement
//	|       "asm" VolatileOpt '(' AssemblerInstructions ':' AssemblerOperands ')'                                             // Case 1
//	|       "asm" VolatileOpt '(' AssemblerInstructions ':' AssemblerOperands ':' AssemblerOperands ')'                       // Case 2
//	|       "asm" VolatileOpt '(' AssemblerInstructions ':' AssemblerOperands ':' AssemblerOperands ':' Clobbers ')'          // Case 3
//	|       "asm" VolatileOpt "goto" '(' AssemblerInstructions ':' ':' AssemblerOperands ':' Clobbers ':' IdentifierList ')'  // Case 4
//	|       "asm" VolatileOpt '(' AssemblerInstructions ':' ')'                                                               // Case 5
//	|       "asm" VolatileOpt '(' AssemblerInstructions ':' ':' AssemblerOperands ')'                                         // Case 6
type AssemblerStatement struct {
	AssemblerInstructions   *AssemblerInstructions
	AssemblerOperands       *AssemblerOperands
	AssemblerOperands2      *AssemblerOperands
	BasicAssemblerStatement *BasicAssemblerStatement
	Case                    int
	Clobbers                *Clobbers
	IdentifierList          *IdentifierList
	Token                   xc.Token
	Token2                  xc.Token
	Token3                  xc.Token
	Token4                  xc.Token
	Token5                  xc.Token
	Token6                  xc.Token
	Token7                  xc.Token
	Token8                  xc.Token
	VolatileOpt             *VolatileOpt
}

func (n *AssemblerStatement) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *AssemblerStatement) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *AssemblerStatement) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.BasicAssemblerStatement.Pos()
	case 1, 2, 3, 4, 5, 6:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// AssemblerSymbolicNameOpt represents data reduced by productions:
//
//	AssemblerSymbolicNameOpt:
//	        /* empty */
//	|       '[' IDENTIFIER ']'  // Case 1
type AssemblerSymbolicNameOpt struct {
	Token  xc.Token
	Token2 xc.Token
	Token3 xc.Token
}

func (n *AssemblerSymbolicNameOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *AssemblerSymbolicNameOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *AssemblerSymbolicNameOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// BasicAssemblerStatement represents data reduced by production:
//
//	BasicAssemblerStatement:
//	        "asm" VolatileOpt '(' AssemblerInstructions ')'
type BasicAssemblerStatement struct {
	AssemblerInstructions *AssemblerInstructions
	Token                 xc.Token
	Token2                xc.Token
	Token3                xc.Token
	VolatileOpt           *VolatileOpt
}

func (n *BasicAssemblerStatement) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *BasicAssemblerStatement) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *BasicAssemblerStatement) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// BlockItem represents data reduced by productions:
//
//	BlockItem:
//	        Declaration
//	|       Statement    // Case 1
type BlockItem struct {
	Case        int
	Declaration *Declaration
	Statement   *Statement
}

func (n *BlockItem) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *BlockItem) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *BlockItem) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Declaration.Pos()
	case 1:
		return n.Statement.Pos()
	default:
		panic("internal error")
	}
}

// BlockItemList represents data reduced by productions:
//
//	BlockItemList:
//	        BlockItem
//	|       BlockItemList BlockItem  // Case 1
type BlockItemList struct {
	BlockItem     *BlockItem
	BlockItemList *BlockItemList
	Case          int
}

func (n *BlockItemList) reverse() *BlockItemList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.BlockItemList
	for nb != nil {
		nc := nb.BlockItemList
		nb.BlockItemList = na
		na = nb
		nb = nc
	}
	n.BlockItemList = nil
	return na
}

func (n *BlockItemList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *BlockItemList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *BlockItemList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.BlockItem.Pos()
	case 1:
		return n.BlockItemList.Pos()
	default:
		panic("internal error")
	}
}

// BlockItemListOpt represents data reduced by productions:
//
//	BlockItemListOpt:
//	        /* empty */
//	|       BlockItemList  // Case 1
type BlockItemListOpt struct {
	BlockItemList *BlockItemList
}

func (n *BlockItemListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *BlockItemListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *BlockItemListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.BlockItemList.Pos()
}

// Clobbers represents data reduced by productions:
//
//	Clobbers:
//	        STRINGLITERAL
//	|       Clobbers ',' STRINGLITERAL  // Case 1
type Clobbers struct {
	Case     int
	Clobbers *Clobbers
	Token    xc.Token
	Token2   xc.Token
}

func (n *Clobbers) reverse() *Clobbers {
	if n == nil {
		return nil
	}

	na := n
	nb := na.Clobbers
	for nb != nil {
		nc := nb.Clobbers
		nb.Clobbers = na
		na = nb
		nb = nc
	}
	n.Clobbers = nil
	return na
}

func (n *Clobbers) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *Clobbers) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Clobbers) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 1:
		return n.Clobbers.Pos()
	case 0:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// CommaOpt represents data reduced by productions:
//
//	CommaOpt:
//	        /* empty */
//	|       ','          // Case 1
type CommaOpt struct {
	Token xc.Token
}

func (n *CommaOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *CommaOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *CommaOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// CompoundStatement represents data reduced by production:
//
//	CompoundStatement:
//	        '{' BlockItemListOpt '}'
type CompoundStatement struct {
	scope            *Bindings // Scope of the CompoundStatement.
	BlockItemListOpt *BlockItemListOpt
	Token            xc.Token
	Token2           xc.Token
}

func (n *CompoundStatement) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *CompoundStatement) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *CompoundStatement) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// ConstantExpression represents data reduced by production:
//
//	ConstantExpression:
//	        Expression
type ConstantExpression struct {
	Type       Type        // Type of expression.
	Value      interface{} // Non nil for certain constant expressions.
	toks       []xc.Token  //
	Expression *Expression
}

func (n *ConstantExpression) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ConstantExpression) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ConstantExpression) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Expression.Pos()
}

// ControlLine represents data reduced by productions:
//
//	ControlLine:
//	        PPDEFINE IDENTIFIER ReplacementList
//	|       PPDEFINE IDENTIFIER_LPAREN "..." ')' ReplacementList                     // Case 1
//	|       PPDEFINE IDENTIFIER_LPAREN IdentifierList ',' "..." ')' ReplacementList  // Case 2
//	|       PPDEFINE IDENTIFIER_LPAREN IdentifierListOpt ')' ReplacementList         // Case 3
//	|       PPERROR PPTokenListOpt                                                   // Case 4
//	|       PPHASH_NL                                                                // Case 5
//	|       PPINCLUDE PPTokenList '\n'                                               // Case 6
//	|       PPLINE PPTokenList '\n'                                                  // Case 7
//	|       PPPRAGMA PPTokenListOpt                                                  // Case 8
//	|       PPUNDEF IDENTIFIER '\n'                                                  // Case 9
//	|       PPDEFINE IDENTIFIER_LPAREN IdentifierList "..." ')' ReplacementList      // Case 10
//	|       PPDEFINE '\n'                                                            // Case 11
//	|       PPUNDEF IDENTIFIER PPTokenList '\n'                                      // Case 12
//	|       PPINCLUDE_NEXT PPTokenList '\n'                                          // Case 13
type ControlLine struct {
	Case              int
	IdentifierList    *IdentifierList
	IdentifierListOpt *IdentifierListOpt
	PPTokenList       PPTokenList
	PPTokenListOpt    PPTokenList
	ReplacementList   PPTokenList
	Token             xc.Token
	Token2            xc.Token
	Token3            xc.Token
	Token4            xc.Token
	Token5            xc.Token
}

func (n *ControlLine) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ControlLine) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ControlLine) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// Declaration represents data reduced by productions:
//
//	Declaration:
//	        DeclarationSpecifiers InitDeclaratorListOpt ';'
//	|       StaticAssertDeclaration                          // Case 1
type Declaration struct {
	declarator              *Declarator // Synthetic declarator when InitDeclaratorListOpt is nil.
	Case                    int
	DeclarationSpecifiers   *DeclarationSpecifiers
	InitDeclaratorListOpt   *InitDeclaratorListOpt
	StaticAssertDeclaration *StaticAssertDeclaration
	Token                   xc.Token
}

func (n *Declaration) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Declaration) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Declaration) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.DeclarationSpecifiers.Pos()
	case 1:
		return n.StaticAssertDeclaration.Pos()
	default:
		panic("internal error")
	}
}

// DeclarationList represents data reduced by productions:
//
//	DeclarationList:
//	        Declaration
//	|       DeclarationList Declaration  // Case 1
type DeclarationList struct {
	Case            int
	Declaration     *Declaration
	DeclarationList *DeclarationList
}

func (n *DeclarationList) reverse() *DeclarationList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.DeclarationList
	for nb != nil {
		nc := nb.DeclarationList
		nb.DeclarationList = na
		na = nb
		nb = nc
	}
	n.DeclarationList = nil
	return na
}

func (n *DeclarationList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *DeclarationList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DeclarationList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Declaration.Pos()
	case 1:
		return n.DeclarationList.Pos()
	default:
		panic("internal error")
	}
}

// DeclarationListOpt represents data reduced by productions:
//
//	DeclarationListOpt:
//	        /* empty */
//	|       DeclarationList  // Case 1
type DeclarationListOpt struct {
	paramsScope     *Bindings
	DeclarationList *DeclarationList
}

func (n *DeclarationListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *DeclarationListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DeclarationListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.DeclarationList.Pos()
}

// DeclarationSpecifiers represents data reduced by productions:
//
//	DeclarationSpecifiers:
//	        StorageClassSpecifier DeclarationSpecifiersOpt
//	|       TypeSpecifier DeclarationSpecifiersOpt          // Case 1
//	|       TypeQualifier DeclarationSpecifiersOpt          // Case 2
//	|       FunctionSpecifier DeclarationSpecifiersOpt      // Case 3
type DeclarationSpecifiers struct {
	attr                     int // tsInline, tsTypedefName, ...
	typeSpecifier            int // Encoded combination of tsVoid, tsInt, ...
	Case                     int
	DeclarationSpecifiersOpt *DeclarationSpecifiersOpt
	FunctionSpecifier        *FunctionSpecifier
	StorageClassSpecifier    *StorageClassSpecifier
	TypeQualifier            *TypeQualifier
	TypeSpecifier            *TypeSpecifier
}

func (n *DeclarationSpecifiers) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *DeclarationSpecifiers) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DeclarationSpecifiers) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 3:
		return n.FunctionSpecifier.Pos()
	case 0:
		return n.StorageClassSpecifier.Pos()
	case 2:
		return n.TypeQualifier.Pos()
	case 1:
		return n.TypeSpecifier.Pos()
	default:
		panic("internal error")
	}
}

// DeclarationSpecifiersOpt represents data reduced by productions:
//
//	DeclarationSpecifiersOpt:
//	        /* empty */
//	|       DeclarationSpecifiers  // Case 1
type DeclarationSpecifiersOpt struct {
	attr                  int // tsInline, tsTypedefName, ...
	typeSpecifier         int // Encoded combination of tsVoid, tsInt, ...
	DeclarationSpecifiers *DeclarationSpecifiers
}

func (n *DeclarationSpecifiersOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *DeclarationSpecifiersOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DeclarationSpecifiersOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.DeclarationSpecifiers.Pos()
}

// Declarator represents data reduced by production:
//
//	Declarator:
//	        PointerOpt DirectDeclarator
type Declarator struct {
	Linkage          Linkage
	Type             Type
	bitFieldType     Type
	bitFieldGroup    int
	bitOffset        int
	bits             int
	offsetOf         int
	padding          int
	specifier        Specifier
	DirectDeclarator *DirectDeclarator
	PointerOpt       *PointerOpt
}

func (n *Declarator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Declarator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Declarator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	if p := n.PointerOpt.Pos(); p != 0 {
		return p
	}

	return n.DirectDeclarator.Pos()
}

// DeclaratorOpt represents data reduced by productions:
//
//	DeclaratorOpt:
//	        /* empty */
//	|       Declarator   // Case 1
type DeclaratorOpt struct {
	Declarator *Declarator
}

func (n *DeclaratorOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *DeclaratorOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DeclaratorOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Declarator.Pos()
}

// Designation represents data reduced by production:
//
//	Designation:
//	        DesignatorList '='
type Designation struct {
	DesignatorList *DesignatorList
	Token          xc.Token
}

func (n *Designation) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Designation) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Designation) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.DesignatorList.Pos()
}

// DesignationOpt represents data reduced by productions:
//
//	DesignationOpt:
//	        /* empty */
//	|       Designation  // Case 1
type DesignationOpt struct {
	Designation *Designation
}

func (n *DesignationOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *DesignationOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DesignationOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Designation.Pos()
}

// Designator represents data reduced by productions:
//
//	Designator:
//	        '[' ConstantExpression ']'
//	|       '.' IDENTIFIER              // Case 1
type Designator struct {
	Case               int
	ConstantExpression *ConstantExpression
	Token              xc.Token
	Token2             xc.Token
}

func (n *Designator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Designator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Designator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// DesignatorList represents data reduced by productions:
//
//	DesignatorList:
//	        Designator
//	|       DesignatorList Designator  // Case 1
type DesignatorList struct {
	Case           int
	Designator     *Designator
	DesignatorList *DesignatorList
}

func (n *DesignatorList) reverse() *DesignatorList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.DesignatorList
	for nb != nil {
		nc := nb.DesignatorList
		nb.DesignatorList = na
		na = nb
		nb = nc
	}
	n.DesignatorList = nil
	return na
}

func (n *DesignatorList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *DesignatorList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DesignatorList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Designator.Pos()
	case 1:
		return n.DesignatorList.Pos()
	default:
		panic("internal error")
	}
}

// DirectAbstractDeclarator represents data reduced by productions:
//
//	DirectAbstractDeclarator:
//	        '(' AbstractDeclarator ')'
//	|       DirectAbstractDeclaratorOpt '[' ExpressionOpt ']'                             // Case 1
//	|       DirectAbstractDeclaratorOpt '[' TypeQualifierList ExpressionOpt ']'           // Case 2
//	|       DirectAbstractDeclaratorOpt '[' "static" TypeQualifierListOpt Expression ']'  // Case 3
//	|       DirectAbstractDeclaratorOpt '[' TypeQualifierList "static" Expression ']'     // Case 4
//	|       DirectAbstractDeclaratorOpt '[' '*' ']'                                       // Case 5
//	|       '(' ParameterTypeListOpt ')'                                                  // Case 6
//	|       DirectAbstractDeclarator '(' ParameterTypeListOpt ')'                         // Case 7
type DirectAbstractDeclarator struct {
	directDeclarator            *DirectDeclarator
	paramsScope                 *Bindings
	AbstractDeclarator          *AbstractDeclarator
	Case                        int
	DirectAbstractDeclarator    *DirectAbstractDeclarator
	DirectAbstractDeclaratorOpt *DirectAbstractDeclaratorOpt
	Expression                  *Expression
	ExpressionOpt               *ExpressionOpt
	ParameterTypeListOpt        *ParameterTypeListOpt
	Token                       xc.Token
	Token2                      xc.Token
	Token3                      xc.Token
	TypeQualifierList           *TypeQualifierList
	TypeQualifierListOpt        *TypeQualifierListOpt
}

func (n *DirectAbstractDeclarator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *DirectAbstractDeclarator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DirectAbstractDeclarator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 7:
		return n.DirectAbstractDeclarator.Pos()
	case 1, 2, 3, 4, 5:
		if p := n.DirectAbstractDeclaratorOpt.Pos(); p != 0 {
			return p
		}

		return n.Token.Pos()
	case 0, 6:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// DirectAbstractDeclaratorOpt represents data reduced by productions:
//
//	DirectAbstractDeclaratorOpt:
//	        /* empty */
//	|       DirectAbstractDeclarator  // Case 1
type DirectAbstractDeclaratorOpt struct {
	DirectAbstractDeclarator *DirectAbstractDeclarator
}

func (n *DirectAbstractDeclaratorOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *DirectAbstractDeclaratorOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DirectAbstractDeclaratorOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.DirectAbstractDeclarator.Pos()
}

// DirectDeclarator represents data reduced by productions:
//
//	DirectDeclarator:
//	        IDENTIFIER
//	|       '(' Declarator ')'                                                 // Case 1
//	|       DirectDeclarator '[' TypeQualifierListOpt ExpressionOpt ']'        // Case 2
//	|       DirectDeclarator '[' "static" TypeQualifierListOpt Expression ']'  // Case 3
//	|       DirectDeclarator '[' TypeQualifierList "static" Expression ']'     // Case 4
//	|       DirectDeclarator '[' TypeQualifierListOpt '*' ']'                  // Case 5
//	|       DirectDeclarator '(' ParameterTypeList ')'                         // Case 6
//	|       DirectDeclarator '(' IdentifierListOpt ')'                         // Case 7
type DirectDeclarator struct {
	EnumVal              interface{} // Non nil if DD declares an enumeration constant.
	declarator           *Declarator
	elements             int
	idScope              *Bindings // Of case 0: IDENTIFIER.
	paramsScope          *Bindings
	parent               *DirectDeclarator
	prev                 *Binding // Existing declaration in same scope, if any.
	specifier            Specifier
	visible              *Binding // Existing declaration of same ident visible in same scope, if any and this DD has storage class extrn.
	Case                 int
	Declarator           *Declarator
	DirectDeclarator     *DirectDeclarator
	Expression           *Expression
	ExpressionOpt        *ExpressionOpt
	IdentifierListOpt    *IdentifierListOpt
	ParameterTypeList    *ParameterTypeList
	Token                xc.Token
	Token2               xc.Token
	Token3               xc.Token
	TypeQualifierList    *TypeQualifierList
	TypeQualifierListOpt *TypeQualifierListOpt
}

func (n *DirectDeclarator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *DirectDeclarator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *DirectDeclarator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 2, 3, 4, 5, 6, 7:
		return n.DirectDeclarator.Pos()
	case 0, 1:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// ElifGroup represents data reduced by production:
//
//	ElifGroup:
//	        PPELIF PPTokenList '\n' GroupListOpt
type ElifGroup struct {
	GroupListOpt *GroupListOpt
	PPTokenList  PPTokenList
	Token        xc.Token
	Token2       xc.Token
}

func (n *ElifGroup) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ElifGroup) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ElifGroup) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// ElifGroupList represents data reduced by productions:
//
//	ElifGroupList:
//	        ElifGroup
//	|       ElifGroupList ElifGroup  // Case 1
type ElifGroupList struct {
	Case          int
	ElifGroup     *ElifGroup
	ElifGroupList *ElifGroupList
}

func (n *ElifGroupList) reverse() *ElifGroupList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.ElifGroupList
	for nb != nil {
		nc := nb.ElifGroupList
		nb.ElifGroupList = na
		na = nb
		nb = nc
	}
	n.ElifGroupList = nil
	return na
}

func (n *ElifGroupList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *ElifGroupList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ElifGroupList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.ElifGroup.Pos()
	case 1:
		return n.ElifGroupList.Pos()
	default:
		panic("internal error")
	}
}

// ElifGroupListOpt represents data reduced by productions:
//
//	ElifGroupListOpt:
//	        /* empty */
//	|       ElifGroupList  // Case 1
type ElifGroupListOpt struct {
	ElifGroupList *ElifGroupList
}

func (n *ElifGroupListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ElifGroupListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ElifGroupListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.ElifGroupList.Pos()
}

// ElseGroup represents data reduced by production:
//
//	ElseGroup:
//	        PPELSE '\n' GroupListOpt
type ElseGroup struct {
	GroupListOpt *GroupListOpt
	Token        xc.Token
	Token2       xc.Token
}

func (n *ElseGroup) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ElseGroup) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ElseGroup) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// ElseGroupOpt represents data reduced by productions:
//
//	ElseGroupOpt:
//	        /* empty */
//	|       ElseGroup    // Case 1
type ElseGroupOpt struct {
	ElseGroup *ElseGroup
}

func (n *ElseGroupOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ElseGroupOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ElseGroupOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.ElseGroup.Pos()
}

// EndifLine represents data reduced by production:
//
//	EndifLine:
//	        PPENDIF
type EndifLine struct {
	Token xc.Token
}

func (n *EndifLine) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *EndifLine) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *EndifLine) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// EnumSpecifier represents data reduced by productions:
//
//	EnumSpecifier:
//	        "enum" IdentifierOpt '{' EnumeratorList CommaOpt '}'
//	|       "enum" IDENTIFIER                                     // Case 1
type EnumSpecifier struct {
	unsigned       bool
	Case           int
	CommaOpt       *CommaOpt
	EnumeratorList *EnumeratorList
	IdentifierOpt  *IdentifierOpt
	Token          xc.Token
	Token2         xc.Token
	Token3         xc.Token
}

func (n *EnumSpecifier) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *EnumSpecifier) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *EnumSpecifier) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// EnumerationConstant represents data reduced by production:
//
//	EnumerationConstant:
//	        IDENTIFIER
type EnumerationConstant struct {
	Token xc.Token
}

func (n *EnumerationConstant) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *EnumerationConstant) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *EnumerationConstant) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// Enumerator represents data reduced by productions:
//
//	Enumerator:
//	        EnumerationConstant
//	|       EnumerationConstant '=' ConstantExpression  // Case 1
type Enumerator struct {
	Value               interface{} // Enumerator's value.
	Case                int
	ConstantExpression  *ConstantExpression
	EnumerationConstant *EnumerationConstant
	Token               xc.Token
}

func (n *Enumerator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Enumerator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Enumerator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.EnumerationConstant.Pos()
}

// EnumeratorList represents data reduced by productions:
//
//	EnumeratorList:
//	        Enumerator
//	|       EnumeratorList ',' Enumerator  // Case 1
type EnumeratorList struct {
	Case           int
	Enumerator     *Enumerator
	EnumeratorList *EnumeratorList
	Token          xc.Token
}

func (n *EnumeratorList) reverse() *EnumeratorList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.EnumeratorList
	for nb != nil {
		nc := nb.EnumeratorList
		nb.EnumeratorList = na
		na = nb
		nb = nc
	}
	n.EnumeratorList = nil
	return na
}

func (n *EnumeratorList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *EnumeratorList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *EnumeratorList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Enumerator.Pos()
	case 1:
		return n.EnumeratorList.Pos()
	default:
		panic("internal error")
	}
}

// Expression represents data reduced by productions:
//
//	Expression:
//	        IDENTIFIER
//	|       CHARCONST                                          // Case 1
//	|       FLOATCONST                                         // Case 2
//	|       INTCONST                                           // Case 3
//	|       LONGCHARCONST                                      // Case 4
//	|       LONGSTRINGLITERAL                                  // Case 5
//	|       STRINGLITERAL                                      // Case 6
//	|       '(' ExpressionList ')'                             // Case 7
//	|       Expression '[' ExpressionList ']'                  // Case 8
//	|       Expression '(' ArgumentExpressionListOpt ')'       // Case 9
//	|       Expression '.' IDENTIFIER                          // Case 10
//	|       Expression "->" IDENTIFIER                         // Case 11
//	|       Expression "++"                                    // Case 12
//	|       Expression "--"                                    // Case 13
//	|       '(' TypeName ')' '{' InitializerList CommaOpt '}'  // Case 14
//	|       "++" Expression                                    // Case 15
//	|       "--" Expression                                    // Case 16
//	|       '&' Expression                                     // Case 17
//	|       '*' Expression                                     // Case 18
//	|       '+' Expression                                     // Case 19
//	|       '-' Expression                                     // Case 20
//	|       '~' Expression                                     // Case 21
//	|       '!' Expression                                     // Case 22
//	|       "sizeof" Expression                                // Case 23
//	|       "sizeof" '(' TypeName ')'                          // Case 24
//	|       '(' TypeName ')' Expression                        // Case 25
//	|       Expression '*' Expression                          // Case 26
//	|       Expression '/' Expression                          // Case 27
//	|       Expression '%' Expression                          // Case 28
//	|       Expression '+' Expression                          // Case 29
//	|       Expression '-' Expression                          // Case 30
//	|       Expression "<<" Expression                         // Case 31
//	|       Expression ">>" Expression                         // Case 32
//	|       Expression '<' Expression                          // Case 33
//	|       Expression '>' Expression                          // Case 34
//	|       Expression "<=" Expression                         // Case 35
//	|       Expression ">=" Expression                         // Case 36
//	|       Expression "==" Expression                         // Case 37
//	|       Expression "!=" Expression                         // Case 38
//	|       Expression '&' Expression                          // Case 39
//	|       Expression '^' Expression                          // Case 40
//	|       Expression '|' Expression                          // Case 41
//	|       Expression "&&" Expression                         // Case 42
//	|       Expression "||" Expression                         // Case 43
//	|       Expression '?' ExpressionList ':' Expression       // Case 44
//	|       Expression '=' Expression                          // Case 45
//	|       Expression "*=" Expression                         // Case 46
//	|       Expression "/=" Expression                         // Case 47
//	|       Expression "%=" Expression                         // Case 48
//	|       Expression "+=" Expression                         // Case 49
//	|       Expression "-=" Expression                         // Case 50
//	|       Expression "<<=" Expression                        // Case 51
//	|       Expression ">>=" Expression                        // Case 52
//	|       Expression "&=" Expression                         // Case 53
//	|       Expression "^=" Expression                         // Case 54
//	|       Expression "|=" Expression                         // Case 55
//	|       "_Alignof" '(' TypeName ')'                        // Case 56
//	|       '(' CompoundStatement ')'                          // Case 57
//	|       "&&" IDENTIFIER                                    // Case 58
//	|       Expression '?' ':' Expression                      // Case 59
type Expression struct {
	BinOpType                 Type        // The type operands of binary expression are coerced into, if different from Type.
	Type                      Type        // Type of expression.
	Value                     interface{} // Non nil for certain constant expressions.
	scope                     *Bindings   // Case 0: IDENTIFIER resolution scope.
	ArgumentExpressionListOpt *ArgumentExpressionListOpt
	Case                      int
	CommaOpt                  *CommaOpt
	CompoundStatement         *CompoundStatement
	Expression                *Expression
	Expression2               *Expression
	ExpressionList            *ExpressionList
	InitializerList           *InitializerList
	Token                     xc.Token
	Token2                    xc.Token
	Token3                    xc.Token
	Token4                    xc.Token
	TypeName                  *TypeName
}

func (n *Expression) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Expression) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Expression) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 8, 9, 10, 11, 12, 13, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 59:
		return n.Expression.Pos()
	case 0, 1, 2, 3, 4, 5, 6, 7, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 56, 57, 58:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// ExpressionList represents data reduced by productions:
//
//	ExpressionList:
//	        Expression
//	|       ExpressionList ',' Expression  // Case 1
type ExpressionList struct {
	Type           Type        // Type of expression.
	Value          interface{} // Non nil for certain constant expressions.
	Case           int
	Expression     *Expression
	ExpressionList *ExpressionList
	Token          xc.Token
}

func (n *ExpressionList) reverse() *ExpressionList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.ExpressionList
	for nb != nil {
		nc := nb.ExpressionList
		nb.ExpressionList = na
		na = nb
		nb = nc
	}
	n.ExpressionList = nil
	return na
}

func (n *ExpressionList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *ExpressionList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ExpressionList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Expression.Pos()
	case 1:
		return n.ExpressionList.Pos()
	default:
		panic("internal error")
	}
}

// ExpressionListOpt represents data reduced by productions:
//
//	ExpressionListOpt:
//	        /* empty */
//	|       ExpressionList  // Case 1
type ExpressionListOpt struct {
	ExpressionList *ExpressionList
}

func (n *ExpressionListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ExpressionListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ExpressionListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.ExpressionList.Pos()
}

// ExpressionOpt represents data reduced by productions:
//
//	ExpressionOpt:
//	        /* empty */
//	|       Expression   // Case 1
type ExpressionOpt struct {
	Expression *Expression
}

func (n *ExpressionOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ExpressionOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ExpressionOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Expression.Pos()
}

// ExpressionStatement represents data reduced by production:
//
//	ExpressionStatement:
//	        ExpressionListOpt ';'
type ExpressionStatement struct {
	ExpressionListOpt *ExpressionListOpt
	Token             xc.Token
}

func (n *ExpressionStatement) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ExpressionStatement) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ExpressionStatement) Pos() token.Pos {
	if n == nil {
		return 0
	}

	if p := n.ExpressionListOpt.Pos(); p != 0 {
		return p
	}

	return n.Token.Pos()
}

// ExternalDeclaration represents data reduced by productions:
//
//	ExternalDeclaration:
//	        FunctionDefinition
//	|       Declaration                  // Case 1
//	|       BasicAssemblerStatement ';'  // Case 2
//	|       ';'                          // Case 3
type ExternalDeclaration struct {
	BasicAssemblerStatement *BasicAssemblerStatement
	Case                    int
	Declaration             *Declaration
	FunctionDefinition      *FunctionDefinition
	Token                   xc.Token
}

func (n *ExternalDeclaration) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ExternalDeclaration) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ExternalDeclaration) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 2:
		return n.BasicAssemblerStatement.Pos()
	case 1:
		return n.Declaration.Pos()
	case 0:
		return n.FunctionDefinition.Pos()
	case 3:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// FunctionBody represents data reduced by productions:
//
//	FunctionBody:
//	        CompoundStatement
//	|       AssemblerStatement ';'  // Case 1
type FunctionBody struct {
	scope              *Bindings // Scope of the FunctionBody.
	AssemblerStatement *AssemblerStatement
	Case               int
	CompoundStatement  *CompoundStatement
	Token              xc.Token
}

func (n *FunctionBody) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *FunctionBody) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *FunctionBody) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 1:
		return n.AssemblerStatement.Pos()
	case 0:
		return n.CompoundStatement.Pos()
	default:
		panic("internal error")
	}
}

// FunctionDefinition represents data reduced by productions:
//
//	FunctionDefinition:
//	        DeclarationSpecifiers Declarator DeclarationListOpt FunctionBody
//	|       Declarator DeclarationListOpt FunctionBody                        // Case 1
type FunctionDefinition struct {
	Case                  int
	DeclarationListOpt    *DeclarationListOpt
	DeclarationSpecifiers *DeclarationSpecifiers
	Declarator            *Declarator
	FunctionBody          *FunctionBody
}

func (n *FunctionDefinition) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *FunctionDefinition) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *FunctionDefinition) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.DeclarationSpecifiers.Pos()
	case 1:
		return n.Declarator.Pos()
	default:
		panic("internal error")
	}
}

// FunctionSpecifier represents data reduced by productions:
//
//	FunctionSpecifier:
//	        "inline"
//	|       "_Noreturn"  // Case 1
type FunctionSpecifier struct {
	attr  int // tsInline, tsTypedefName, ...
	Case  int
	Token xc.Token
}

func (n *FunctionSpecifier) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *FunctionSpecifier) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *FunctionSpecifier) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// GroupList represents data reduced by productions:
//
//	GroupList:
//	        GroupPart
//	|       GroupList GroupPart  // Case 1
type GroupList struct {
	Case      int
	GroupList *GroupList
	GroupPart Node
}

func (n *GroupList) reverse() *GroupList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.GroupList
	for nb != nil {
		nc := nb.GroupList
		nb.GroupList = na
		na = nb
		nb = nc
	}
	n.GroupList = nil
	return na
}

func (n *GroupList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *GroupList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *GroupList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 1:
		return n.GroupList.Pos()
	case 0:
		return n.GroupPart.Pos()
	default:
		panic("internal error")
	}
}

// GroupListOpt represents data reduced by productions:
//
//	GroupListOpt:
//	        /* empty */
//	|       GroupList    // Case 1
type GroupListOpt struct {
	GroupList *GroupList
}

func (n *GroupListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *GroupListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *GroupListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.GroupList.Pos()
}

// IdentifierList represents data reduced by productions:
//
//	IdentifierList:
//	        IDENTIFIER
//	|       IdentifierList ',' IDENTIFIER  // Case 1
type IdentifierList struct {
	Case           int
	IdentifierList *IdentifierList
	Token          xc.Token
	Token2         xc.Token
}

func (n *IdentifierList) reverse() *IdentifierList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.IdentifierList
	for nb != nil {
		nc := nb.IdentifierList
		nb.IdentifierList = na
		na = nb
		nb = nc
	}
	n.IdentifierList = nil
	return na
}

func (n *IdentifierList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *IdentifierList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *IdentifierList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 1:
		return n.IdentifierList.Pos()
	case 0:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// IdentifierListOpt represents data reduced by productions:
//
//	IdentifierListOpt:
//	        /* empty */
//	|       IdentifierList  // Case 1
type IdentifierListOpt struct {
	params         []Parameter
	IdentifierList *IdentifierList
}

func (n *IdentifierListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *IdentifierListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *IdentifierListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.IdentifierList.Pos()
}

// IdentifierOpt represents data reduced by productions:
//
//	IdentifierOpt:
//	        /* empty */
//	|       IDENTIFIER   // Case 1
type IdentifierOpt struct {
	Token xc.Token
}

func (n *IdentifierOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *IdentifierOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *IdentifierOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// IfGroup represents data reduced by productions:
//
//	IfGroup:
//	        PPIF PPTokenList '\n' GroupListOpt
//	|       PPIFDEF IDENTIFIER '\n' GroupListOpt   // Case 1
//	|       PPIFNDEF IDENTIFIER '\n' GroupListOpt  // Case 2
type IfGroup struct {
	Case         int
	GroupListOpt *GroupListOpt
	PPTokenList  PPTokenList
	Token        xc.Token
	Token2       xc.Token
	Token3       xc.Token
}

func (n *IfGroup) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *IfGroup) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *IfGroup) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// IfSection represents data reduced by production:
//
//	IfSection:
//	        IfGroup ElifGroupListOpt ElseGroupOpt EndifLine
type IfSection struct {
	ElifGroupListOpt *ElifGroupListOpt
	ElseGroupOpt     *ElseGroupOpt
	EndifLine        *EndifLine
	IfGroup          *IfGroup
}

func (n *IfSection) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *IfSection) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *IfSection) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.IfGroup.Pos()
}

// InitDeclarator represents data reduced by productions:
//
//	InitDeclarator:
//	        Declarator
//	|       Declarator '=' Initializer  // Case 1
type InitDeclarator struct {
	Case        int
	Declarator  *Declarator
	Initializer *Initializer
	Token       xc.Token
}

func (n *InitDeclarator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *InitDeclarator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *InitDeclarator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Declarator.Pos()
}

// InitDeclaratorList represents data reduced by productions:
//
//	InitDeclaratorList:
//	        InitDeclarator
//	|       InitDeclaratorList ',' InitDeclarator  // Case 1
type InitDeclaratorList struct {
	Case               int
	InitDeclarator     *InitDeclarator
	InitDeclaratorList *InitDeclaratorList
	Token              xc.Token
}

func (n *InitDeclaratorList) reverse() *InitDeclaratorList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.InitDeclaratorList
	for nb != nil {
		nc := nb.InitDeclaratorList
		nb.InitDeclaratorList = na
		na = nb
		nb = nc
	}
	n.InitDeclaratorList = nil
	return na
}

func (n *InitDeclaratorList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *InitDeclaratorList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *InitDeclaratorList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.InitDeclarator.Pos()
	case 1:
		return n.InitDeclaratorList.Pos()
	default:
		panic("internal error")
	}
}

// InitDeclaratorListOpt represents data reduced by productions:
//
//	InitDeclaratorListOpt:
//	        /* empty */
//	|       InitDeclaratorList  // Case 1
type InitDeclaratorListOpt struct {
	InitDeclaratorList *InitDeclaratorList
}

func (n *InitDeclaratorListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *InitDeclaratorListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *InitDeclaratorListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.InitDeclaratorList.Pos()
}

// Initializer represents data reduced by productions:
//
//	Initializer:
//	        Expression
//	|       '{' InitializerList CommaOpt '}'  // Case 1
//	|       IDENTIFIER ':' Initializer        // Case 2
type Initializer struct {
	Case            int
	CommaOpt        *CommaOpt
	Expression      *Expression
	Initializer     *Initializer
	InitializerList *InitializerList
	Token           xc.Token
	Token2          xc.Token
}

func (n *Initializer) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Initializer) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Initializer) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Expression.Pos()
	case 1, 2:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// InitializerList represents data reduced by productions:
//
//	InitializerList:
//	        DesignationOpt Initializer
//	|       InitializerList ',' DesignationOpt Initializer  // Case 1
//	|       /* empty */                                     // Case 2
type InitializerList struct {
	Case            int
	DesignationOpt  *DesignationOpt
	Initializer     *Initializer
	InitializerList *InitializerList
	Token           xc.Token
}

func (n *InitializerList) reverse() *InitializerList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.InitializerList
	for nb != nil {
		nc := nb.InitializerList
		nb.InitializerList = na
		na = nb
		nb = nc
	}
	n.InitializerList = nil
	return na
}

func (n *InitializerList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *InitializerList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *InitializerList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 2:
		return 0
	case 0:
		if p := n.DesignationOpt.Pos(); p != 0 {
			return p
		}

		return n.Initializer.Pos()
	case 1:
		if p := n.InitializerList.Pos(); p != 0 {
			return p
		}

		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// IterationStatement represents data reduced by productions:
//
//	IterationStatement:
//	        "while" '(' ExpressionList ')' Statement
//	|       "do" Statement "while" '(' ExpressionList ')' ';'                                      // Case 1
//	|       "for" '(' ExpressionListOpt ';' ExpressionListOpt ';' ExpressionListOpt ')' Statement  // Case 2
//	|       "for" '(' Declaration ExpressionListOpt ';' ExpressionListOpt ')' Statement            // Case 3
type IterationStatement struct {
	Case               int
	Declaration        *Declaration
	ExpressionList     *ExpressionList
	ExpressionListOpt  *ExpressionListOpt
	ExpressionListOpt2 *ExpressionListOpt
	ExpressionListOpt3 *ExpressionListOpt
	Statement          *Statement
	Token              xc.Token
	Token2             xc.Token
	Token3             xc.Token
	Token4             xc.Token
	Token5             xc.Token
}

func (n *IterationStatement) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *IterationStatement) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *IterationStatement) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// JumpStatement represents data reduced by productions:
//
//	JumpStatement:
//	        "goto" IDENTIFIER ';'
//	|       "continue" ';'                  // Case 1
//	|       "break" ';'                     // Case 2
//	|       "return" ExpressionListOpt ';'  // Case 3
//	|       "goto" Expression ';'           // Case 4
type JumpStatement struct {
	Case              int
	Expression        *Expression
	ExpressionListOpt *ExpressionListOpt
	Token             xc.Token
	Token2            xc.Token
	Token3            xc.Token
}

func (n *JumpStatement) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *JumpStatement) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *JumpStatement) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// LabeledStatement represents data reduced by productions:
//
//	LabeledStatement:
//	        IDENTIFIER ':' Statement
//	|       "case" ConstantExpression ':' Statement  // Case 1
//	|       "default" ':' Statement                  // Case 2
type LabeledStatement struct {
	Case               int
	ConstantExpression *ConstantExpression
	Statement          *Statement
	Token              xc.Token
	Token2             xc.Token
}

func (n *LabeledStatement) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *LabeledStatement) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *LabeledStatement) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// ParameterDeclaration represents data reduced by productions:
//
//	ParameterDeclaration:
//	        DeclarationSpecifiers Declarator
//	|       DeclarationSpecifiers AbstractDeclaratorOpt  // Case 1
type ParameterDeclaration struct {
	declarator            *Declarator
	AbstractDeclaratorOpt *AbstractDeclaratorOpt
	Case                  int
	DeclarationSpecifiers *DeclarationSpecifiers
	Declarator            *Declarator
}

func (n *ParameterDeclaration) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ParameterDeclaration) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ParameterDeclaration) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.DeclarationSpecifiers.Pos()
}

// ParameterList represents data reduced by productions:
//
//	ParameterList:
//	        ParameterDeclaration
//	|       ParameterList ',' ParameterDeclaration  // Case 1
type ParameterList struct {
	Case                 int
	ParameterDeclaration *ParameterDeclaration
	ParameterList        *ParameterList
	Token                xc.Token
}

func (n *ParameterList) reverse() *ParameterList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.ParameterList
	for nb != nil {
		nc := nb.ParameterList
		nb.ParameterList = na
		na = nb
		nb = nc
	}
	n.ParameterList = nil
	return na
}

func (n *ParameterList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *ParameterList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ParameterList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.ParameterDeclaration.Pos()
	case 1:
		return n.ParameterList.Pos()
	default:
		panic("internal error")
	}
}

// ParameterTypeList represents data reduced by productions:
//
//	ParameterTypeList:
//	        ParameterList
//	|       ParameterList ',' "..."  // Case 1
type ParameterTypeList struct {
	params        []Parameter
	Case          int
	ParameterList *ParameterList
	Token         xc.Token
	Token2        xc.Token
}

func (n *ParameterTypeList) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ParameterTypeList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ParameterTypeList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.ParameterList.Pos()
}

// ParameterTypeListOpt represents data reduced by productions:
//
//	ParameterTypeListOpt:
//	        /* empty */
//	|       ParameterTypeList  // Case 1
type ParameterTypeListOpt struct {
	ParameterTypeList *ParameterTypeList
}

func (n *ParameterTypeListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *ParameterTypeListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *ParameterTypeListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.ParameterTypeList.Pos()
}

// Pointer represents data reduced by productions:
//
//	Pointer:
//	        '*' TypeQualifierListOpt
//	|       '*' TypeQualifierListOpt Pointer  // Case 1
type Pointer struct {
	Case                 int
	Pointer              *Pointer
	Token                xc.Token
	TypeQualifierListOpt *TypeQualifierListOpt
}

func (n *Pointer) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Pointer) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Pointer) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// PointerOpt represents data reduced by productions:
//
//	PointerOpt:
//	        /* empty */
//	|       Pointer      // Case 1
type PointerOpt struct {
	Pointer *Pointer
}

func (n *PointerOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *PointerOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *PointerOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Pointer.Pos()
}

// PreprocessingFile represents data reduced by production:
//
//	PreprocessingFile:
//	        GroupList
type PreprocessingFile struct {
	path      string
	GroupList *GroupList
}

func (n *PreprocessingFile) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *PreprocessingFile) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *PreprocessingFile) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.GroupList.Pos()
}

// SelectionStatement represents data reduced by productions:
//
//	SelectionStatement:
//	        "if" '(' ExpressionList ')' Statement
//	|       "if" '(' ExpressionList ')' Statement "else" Statement  // Case 1
//	|       "switch" '(' ExpressionList ')' Statement               // Case 2
type SelectionStatement struct {
	Case           int
	ExpressionList *ExpressionList
	Statement      *Statement
	Statement2     *Statement
	Token          xc.Token
	Token2         xc.Token
	Token3         xc.Token
	Token4         xc.Token
}

func (n *SelectionStatement) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *SelectionStatement) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *SelectionStatement) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// SpecifierQualifierList represents data reduced by productions:
//
//	SpecifierQualifierList:
//	        TypeSpecifier SpecifierQualifierListOpt
//	|       TypeQualifier SpecifierQualifierListOpt  // Case 1
type SpecifierQualifierList struct {
	attr                      int // tsInline, tsTypedefName, ...
	typeSpecifier             int // Encoded combination of tsVoid, tsInt, ...
	Case                      int
	SpecifierQualifierListOpt *SpecifierQualifierListOpt
	TypeQualifier             *TypeQualifier
	TypeSpecifier             *TypeSpecifier
}

func (n *SpecifierQualifierList) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *SpecifierQualifierList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *SpecifierQualifierList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 1:
		return n.TypeQualifier.Pos()
	case 0:
		return n.TypeSpecifier.Pos()
	default:
		panic("internal error")
	}
}

// SpecifierQualifierListOpt represents data reduced by productions:
//
//	SpecifierQualifierListOpt:
//	        /* empty */
//	|       SpecifierQualifierList  // Case 1
type SpecifierQualifierListOpt struct {
	attr                   int // tsInline, tsTypedefName, ...
	typeSpecifier          int // Encoded combination of tsVoid, tsInt, ...
	SpecifierQualifierList *SpecifierQualifierList
}

func (n *SpecifierQualifierListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *SpecifierQualifierListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *SpecifierQualifierListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.SpecifierQualifierList.Pos()
}

// Statement represents data reduced by productions:
//
//	Statement:
//	        LabeledStatement
//	|       CompoundStatement    // Case 1
//	|       ExpressionStatement  // Case 2
//	|       SelectionStatement   // Case 3
//	|       IterationStatement   // Case 4
//	|       JumpStatement        // Case 5
//	|       AssemblerStatement   // Case 6
type Statement struct {
	AssemblerStatement  *AssemblerStatement
	Case                int
	CompoundStatement   *CompoundStatement
	ExpressionStatement *ExpressionStatement
	IterationStatement  *IterationStatement
	JumpStatement       *JumpStatement
	LabeledStatement    *LabeledStatement
	SelectionStatement  *SelectionStatement
}

func (n *Statement) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *Statement) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *Statement) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 6:
		return n.AssemblerStatement.Pos()
	case 1:
		return n.CompoundStatement.Pos()
	case 2:
		return n.ExpressionStatement.Pos()
	case 4:
		return n.IterationStatement.Pos()
	case 5:
		return n.JumpStatement.Pos()
	case 0:
		return n.LabeledStatement.Pos()
	case 3:
		return n.SelectionStatement.Pos()
	default:
		panic("internal error")
	}
}

// StaticAssertDeclaration represents data reduced by production:
//
//	StaticAssertDeclaration:
//	        "_Static_assert" '(' ConstantExpression ',' STRINGLITERAL ')' ';'
type StaticAssertDeclaration struct {
	ConstantExpression *ConstantExpression
	Token              xc.Token
	Token2             xc.Token
	Token3             xc.Token
	Token4             xc.Token
	Token5             xc.Token
	Token6             xc.Token
}

func (n *StaticAssertDeclaration) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *StaticAssertDeclaration) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *StaticAssertDeclaration) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// StorageClassSpecifier represents data reduced by productions:
//
//	StorageClassSpecifier:
//	        "typedef"
//	|       "extern"    // Case 1
//	|       "static"    // Case 2
//	|       "auto"      // Case 3
//	|       "register"  // Case 4
type StorageClassSpecifier struct {
	attr  int
	Case  int
	Token xc.Token
}

func (n *StorageClassSpecifier) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *StorageClassSpecifier) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *StorageClassSpecifier) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// StructDeclaration represents data reduced by productions:
//
//	StructDeclaration:
//	        SpecifierQualifierList StructDeclaratorList ';'
//	|       SpecifierQualifierList ';'                       // Case 1
//	|       StaticAssertDeclaration                          // Case 2
type StructDeclaration struct {
	Case                    int
	SpecifierQualifierList  *SpecifierQualifierList
	StaticAssertDeclaration *StaticAssertDeclaration
	StructDeclaratorList    *StructDeclaratorList
	Token                   xc.Token
}

func (n *StructDeclaration) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *StructDeclaration) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *StructDeclaration) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0, 1:
		return n.SpecifierQualifierList.Pos()
	case 2:
		return n.StaticAssertDeclaration.Pos()
	default:
		panic("internal error")
	}
}

// StructDeclarationList represents data reduced by productions:
//
//	StructDeclarationList:
//	        StructDeclaration
//	|       StructDeclarationList StructDeclaration  // Case 1
type StructDeclarationList struct {
	Case                  int
	StructDeclaration     *StructDeclaration
	StructDeclarationList *StructDeclarationList
}

func (n *StructDeclarationList) reverse() *StructDeclarationList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.StructDeclarationList
	for nb != nil {
		nc := nb.StructDeclarationList
		nb.StructDeclarationList = na
		na = nb
		nb = nc
	}
	n.StructDeclarationList = nil
	return na
}

func (n *StructDeclarationList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *StructDeclarationList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *StructDeclarationList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.StructDeclaration.Pos()
	case 1:
		return n.StructDeclarationList.Pos()
	default:
		panic("internal error")
	}
}

// StructDeclarator represents data reduced by productions:
//
//	StructDeclarator:
//	        Declarator
//	|       DeclaratorOpt ':' ConstantExpression  // Case 1
type StructDeclarator struct {
	Case               int
	ConstantExpression *ConstantExpression
	Declarator         *Declarator
	DeclaratorOpt      *DeclaratorOpt
	Token              xc.Token
}

func (n *StructDeclarator) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *StructDeclarator) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *StructDeclarator) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.Declarator.Pos()
	case 1:
		if p := n.DeclaratorOpt.Pos(); p != 0 {
			return p
		}

		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// StructDeclaratorList represents data reduced by productions:
//
//	StructDeclaratorList:
//	        StructDeclarator
//	|       StructDeclaratorList ',' StructDeclarator  // Case 1
type StructDeclaratorList struct {
	Case                 int
	StructDeclarator     *StructDeclarator
	StructDeclaratorList *StructDeclaratorList
	Token                xc.Token
}

func (n *StructDeclaratorList) reverse() *StructDeclaratorList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.StructDeclaratorList
	for nb != nil {
		nc := nb.StructDeclaratorList
		nb.StructDeclaratorList = na
		na = nb
		nb = nc
	}
	n.StructDeclaratorList = nil
	return na
}

func (n *StructDeclaratorList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *StructDeclaratorList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *StructDeclaratorList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.StructDeclarator.Pos()
	case 1:
		return n.StructDeclaratorList.Pos()
	default:
		panic("internal error")
	}
}

// StructOrUnion represents data reduced by productions:
//
//	StructOrUnion:
//	        "struct"
//	|       "union"   // Case 1
type StructOrUnion struct {
	Case  int
	Token xc.Token
}

func (n *StructOrUnion) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *StructOrUnion) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *StructOrUnion) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// StructOrUnionSpecifier represents data reduced by productions:
//
//	StructOrUnionSpecifier:
//	        StructOrUnion IdentifierOpt '{' StructDeclarationList '}'
//	|       StructOrUnion IDENTIFIER                                   // Case 1
//	|       StructOrUnion IdentifierOpt '{' '}'                        // Case 2
type StructOrUnionSpecifier struct {
	alignOf               int
	declarator            *Declarator // Synthetic declarator when tagged struct/union defined inline.
	scope                 *Bindings
	sizeOf                int
	Case                  int
	IdentifierOpt         *IdentifierOpt
	StructDeclarationList *StructDeclarationList
	StructOrUnion         *StructOrUnion
	Token                 xc.Token
	Token2                xc.Token
}

func (n *StructOrUnionSpecifier) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *StructOrUnionSpecifier) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *StructOrUnionSpecifier) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.StructOrUnion.Pos()
}

// TranslationUnit represents data reduced by productions:
//
//	TranslationUnit:
//	        ExternalDeclaration
//	|       TranslationUnit ExternalDeclaration  // Case 1
type TranslationUnit struct {
	Comments            map[token.Pos]int // Position -> comment ID. Enable using the KeepComments option.
	Declarations        *Bindings
	Macros              map[int]*Macro // Ident ID -> preprocessor macro defined by ident.
	Model               *Model         // Model used to parse the TranslationUnit.
	Case                int
	ExternalDeclaration *ExternalDeclaration
	TranslationUnit     *TranslationUnit
}

func (n *TranslationUnit) reverse() *TranslationUnit {
	if n == nil {
		return nil
	}

	na := n
	nb := na.TranslationUnit
	for nb != nil {
		nc := nb.TranslationUnit
		nb.TranslationUnit = na
		na = nb
		nb = nc
	}
	n.TranslationUnit = nil
	return na
}

func (n *TranslationUnit) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *TranslationUnit) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *TranslationUnit) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.ExternalDeclaration.Pos()
	case 1:
		return n.TranslationUnit.Pos()
	default:
		panic("internal error")
	}
}

// TypeName represents data reduced by production:
//
//	TypeName:
//	        SpecifierQualifierList AbstractDeclaratorOpt
type TypeName struct {
	Type                   Type
	declarator             *Declarator
	scope                  *Bindings
	AbstractDeclaratorOpt  *AbstractDeclaratorOpt
	SpecifierQualifierList *SpecifierQualifierList
}

func (n *TypeName) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *TypeName) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *TypeName) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.SpecifierQualifierList.Pos()
}

// TypeQualifier represents data reduced by productions:
//
//	TypeQualifier:
//	        "const"
//	|       "restrict"  // Case 1
//	|       "volatile"  // Case 2
type TypeQualifier struct {
	attr  int // tsInline, tsTypedefName, ...
	Case  int
	Token xc.Token
}

func (n *TypeQualifier) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *TypeQualifier) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *TypeQualifier) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}

// TypeQualifierList represents data reduced by productions:
//
//	TypeQualifierList:
//	        TypeQualifier
//	|       TypeQualifierList TypeQualifier  // Case 1
type TypeQualifierList struct {
	attr              int // tsInline, tsTypedefName, ...
	Case              int
	TypeQualifier     *TypeQualifier
	TypeQualifierList *TypeQualifierList
}

func (n *TypeQualifierList) reverse() *TypeQualifierList {
	if n == nil {
		return nil
	}

	na := n
	nb := na.TypeQualifierList
	for nb != nil {
		nc := nb.TypeQualifierList
		nb.TypeQualifierList = na
		na = nb
		nb = nc
	}
	n.TypeQualifierList = nil
	return na
}

func (n *TypeQualifierList) fragment() interface{} { return n.reverse() }

// String implements fmt.Stringer.
func (n *TypeQualifierList) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *TypeQualifierList) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 0:
		return n.TypeQualifier.Pos()
	case 1:
		return n.TypeQualifierList.Pos()
	default:
		panic("internal error")
	}
}

// TypeQualifierListOpt represents data reduced by productions:
//
//	TypeQualifierListOpt:
//	        /* empty */
//	|       TypeQualifierList  // Case 1
type TypeQualifierListOpt struct {
	TypeQualifierList *TypeQualifierList
}

func (n *TypeQualifierListOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *TypeQualifierListOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *TypeQualifierListOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.TypeQualifierList.Pos()
}

// TypeSpecifier represents data reduced by productions:
//
//	TypeSpecifier:
//	        "void"
//	|       "char"                       // Case 1
//	|       "short"                      // Case 2
//	|       "int"                        // Case 3
//	|       "long"                       // Case 4
//	|       "float"                      // Case 5
//	|       "double"                     // Case 6
//	|       "signed"                     // Case 7
//	|       "unsigned"                   // Case 8
//	|       "_Bool"                      // Case 9
//	|       "_Complex"                   // Case 10
//	|       StructOrUnionSpecifier       // Case 11
//	|       EnumSpecifier                // Case 12
//	|       TYPEDEFNAME                  // Case 13
//	|       "typeof" '(' Expression ')'  // Case 14
//	|       "typeof" '(' TypeName ')'    // Case 15
type TypeSpecifier struct {
	scope                  *Bindings // If case TYPEDEFNAME.
	typeSpecifier          int       // Encoded combination of tsVoid, tsInt, ...
	Type                   Type      // Type of typeof.
	Case                   int
	EnumSpecifier          *EnumSpecifier
	Expression             *Expression
	StructOrUnionSpecifier *StructOrUnionSpecifier
	Token                  xc.Token
	Token2                 xc.Token
	Token3                 xc.Token
	TypeName               *TypeName
}

func (n *TypeSpecifier) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *TypeSpecifier) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *TypeSpecifier) Pos() token.Pos {
	if n == nil {
		return 0
	}

	switch n.Case {
	case 12:
		return n.EnumSpecifier.Pos()
	case 11:
		return n.StructOrUnionSpecifier.Pos()
	case 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 14, 15:
		return n.Token.Pos()
	default:
		panic("internal error")
	}
}

// VolatileOpt represents data reduced by productions:
//
//	VolatileOpt:
//	        /* empty */
//	|       "volatile"   // Case 1
type VolatileOpt struct {
	Token xc.Token
}

func (n *VolatileOpt) fragment() interface{} { return n }

// String implements fmt.Stringer.
func (n *VolatileOpt) String() string {
	return PrettyString(n)
}

// Pos reports the position of the first component of n or zero if it's empty.
func (n *VolatileOpt) Pos() token.Pos {
	if n == nil {
		return 0
	}

	return n.Token.Pos()
}
