// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package swf

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCountClosedWorkflowExecutions = "CountClosedWorkflowExecutions"

// CountClosedWorkflowExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the CountClosedWorkflowExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CountClosedWorkflowExecutions for more information on using the CountClosedWorkflowExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CountClosedWorkflowExecutionsRequest method.
//    req, resp := client.CountClosedWorkflowExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) CountClosedWorkflowExecutionsRequest(input *CountClosedWorkflowExecutionsInput) (req *request.Request, output *WorkflowExecutionCount) {
	op := &request.Operation{
		Name:       opCountClosedWorkflowExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CountClosedWorkflowExecutionsInput{}
	}

	output = &WorkflowExecutionCount{}
	req = c.newRequest(op, input, output)
	return
}

// CountClosedWorkflowExecutions API operation for Amazon Simple Workflow Service.
//
// Returns the number of closed workflow executions within the given domain
// that meet the specified filtering criteria.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. tagFilter.tag: String constraint. The key is swf:tagFilter.tag.
//    typeFilter.name: String constraint. The key is swf:typeFilter.name. typeFilter.version:
//    String constraint. The key is swf:typeFilter.version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation CountClosedWorkflowExecutions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) CountClosedWorkflowExecutions(input *CountClosedWorkflowExecutionsInput) (*WorkflowExecutionCount, error) {
	req, out := c.CountClosedWorkflowExecutionsRequest(input)
	return out, req.Send()
}

// CountClosedWorkflowExecutionsWithContext is the same as CountClosedWorkflowExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See CountClosedWorkflowExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) CountClosedWorkflowExecutionsWithContext(ctx aws.Context, input *CountClosedWorkflowExecutionsInput, opts ...request.Option) (*WorkflowExecutionCount, error) {
	req, out := c.CountClosedWorkflowExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCountOpenWorkflowExecutions = "CountOpenWorkflowExecutions"

// CountOpenWorkflowExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the CountOpenWorkflowExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CountOpenWorkflowExecutions for more information on using the CountOpenWorkflowExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CountOpenWorkflowExecutionsRequest method.
//    req, resp := client.CountOpenWorkflowExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) CountOpenWorkflowExecutionsRequest(input *CountOpenWorkflowExecutionsInput) (req *request.Request, output *WorkflowExecutionCount) {
	op := &request.Operation{
		Name:       opCountOpenWorkflowExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CountOpenWorkflowExecutionsInput{}
	}

	output = &WorkflowExecutionCount{}
	req = c.newRequest(op, input, output)
	return
}

// CountOpenWorkflowExecutions API operation for Amazon Simple Workflow Service.
//
// Returns the number of open workflow executions within the given domain that
// meet the specified filtering criteria.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. tagFilter.tag: String constraint. The key is swf:tagFilter.tag.
//    typeFilter.name: String constraint. The key is swf:typeFilter.name. typeFilter.version:
//    String constraint. The key is swf:typeFilter.version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation CountOpenWorkflowExecutions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) CountOpenWorkflowExecutions(input *CountOpenWorkflowExecutionsInput) (*WorkflowExecutionCount, error) {
	req, out := c.CountOpenWorkflowExecutionsRequest(input)
	return out, req.Send()
}

// CountOpenWorkflowExecutionsWithContext is the same as CountOpenWorkflowExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See CountOpenWorkflowExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) CountOpenWorkflowExecutionsWithContext(ctx aws.Context, input *CountOpenWorkflowExecutionsInput, opts ...request.Option) (*WorkflowExecutionCount, error) {
	req, out := c.CountOpenWorkflowExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCountPendingActivityTasks = "CountPendingActivityTasks"

// CountPendingActivityTasksRequest generates a "aws/request.Request" representing the
// client's request for the CountPendingActivityTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CountPendingActivityTasks for more information on using the CountPendingActivityTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CountPendingActivityTasksRequest method.
//    req, resp := client.CountPendingActivityTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) CountPendingActivityTasksRequest(input *CountPendingActivityTasksInput) (req *request.Request, output *PendingTaskCount) {
	op := &request.Operation{
		Name:       opCountPendingActivityTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CountPendingActivityTasksInput{}
	}

	output = &PendingTaskCount{}
	req = c.newRequest(op, input, output)
	return
}

// CountPendingActivityTasks API operation for Amazon Simple Workflow Service.
//
// Returns the estimated number of activity tasks in the specified task list.
// The count returned is an approximation and isn't guaranteed to be exact.
// If you specify a task list that no activity task was ever scheduled in then
// 0 is returned.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the taskList.name parameter by using a Condition element with
//    the swf:taskList.name key to allow the action to access only certain task
//    lists.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation CountPendingActivityTasks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) CountPendingActivityTasks(input *CountPendingActivityTasksInput) (*PendingTaskCount, error) {
	req, out := c.CountPendingActivityTasksRequest(input)
	return out, req.Send()
}

// CountPendingActivityTasksWithContext is the same as CountPendingActivityTasks with the addition of
// the ability to pass a context and additional request options.
//
// See CountPendingActivityTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) CountPendingActivityTasksWithContext(ctx aws.Context, input *CountPendingActivityTasksInput, opts ...request.Option) (*PendingTaskCount, error) {
	req, out := c.CountPendingActivityTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCountPendingDecisionTasks = "CountPendingDecisionTasks"

// CountPendingDecisionTasksRequest generates a "aws/request.Request" representing the
// client's request for the CountPendingDecisionTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CountPendingDecisionTasks for more information on using the CountPendingDecisionTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CountPendingDecisionTasksRequest method.
//    req, resp := client.CountPendingDecisionTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) CountPendingDecisionTasksRequest(input *CountPendingDecisionTasksInput) (req *request.Request, output *PendingTaskCount) {
	op := &request.Operation{
		Name:       opCountPendingDecisionTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CountPendingDecisionTasksInput{}
	}

	output = &PendingTaskCount{}
	req = c.newRequest(op, input, output)
	return
}

// CountPendingDecisionTasks API operation for Amazon Simple Workflow Service.
//
// Returns the estimated number of decision tasks in the specified task list.
// The count returned is an approximation and isn't guaranteed to be exact.
// If you specify a task list that no decision task was ever scheduled in then
// 0 is returned.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the taskList.name parameter by using a Condition element with
//    the swf:taskList.name key to allow the action to access only certain task
//    lists.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation CountPendingDecisionTasks for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) CountPendingDecisionTasks(input *CountPendingDecisionTasksInput) (*PendingTaskCount, error) {
	req, out := c.CountPendingDecisionTasksRequest(input)
	return out, req.Send()
}

// CountPendingDecisionTasksWithContext is the same as CountPendingDecisionTasks with the addition of
// the ability to pass a context and additional request options.
//
// See CountPendingDecisionTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) CountPendingDecisionTasksWithContext(ctx aws.Context, input *CountPendingDecisionTasksInput, opts ...request.Option) (*PendingTaskCount, error) {
	req, out := c.CountPendingDecisionTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeprecateActivityType = "DeprecateActivityType"

// DeprecateActivityTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeprecateActivityType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeprecateActivityType for more information on using the DeprecateActivityType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeprecateActivityTypeRequest method.
//    req, resp := client.DeprecateActivityTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) DeprecateActivityTypeRequest(input *DeprecateActivityTypeInput) (req *request.Request, output *DeprecateActivityTypeOutput) {
	op := &request.Operation{
		Name:       opDeprecateActivityType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeprecateActivityTypeInput{}
	}

	output = &DeprecateActivityTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeprecateActivityType API operation for Amazon Simple Workflow Service.
//
// Deprecates the specified activity type. After an activity type has been deprecated,
// you cannot create new tasks of that activity type. Tasks of this type that
// were scheduled before the type was deprecated continue to run.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. activityType.name: String constraint. The key is
//    swf:activityType.name. activityType.version: String constraint. The key
//    is swf:activityType.version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation DeprecateActivityType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeTypeDeprecatedFault "TypeDeprecatedFault"
//   Returned when the specified activity or workflow type was already deprecated.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) DeprecateActivityType(input *DeprecateActivityTypeInput) (*DeprecateActivityTypeOutput, error) {
	req, out := c.DeprecateActivityTypeRequest(input)
	return out, req.Send()
}

// DeprecateActivityTypeWithContext is the same as DeprecateActivityType with the addition of
// the ability to pass a context and additional request options.
//
// See DeprecateActivityType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) DeprecateActivityTypeWithContext(ctx aws.Context, input *DeprecateActivityTypeInput, opts ...request.Option) (*DeprecateActivityTypeOutput, error) {
	req, out := c.DeprecateActivityTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeprecateDomain = "DeprecateDomain"

// DeprecateDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeprecateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeprecateDomain for more information on using the DeprecateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeprecateDomainRequest method.
//    req, resp := client.DeprecateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) DeprecateDomainRequest(input *DeprecateDomainInput) (req *request.Request, output *DeprecateDomainOutput) {
	op := &request.Operation{
		Name:       opDeprecateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeprecateDomainInput{}
	}

	output = &DeprecateDomainOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeprecateDomain API operation for Amazon Simple Workflow Service.
//
// Deprecates the specified domain. After a domain has been deprecated it cannot
// be used to create new workflow executions or register new types. However,
// you can still use visibility actions on this domain. Deprecating a domain
// also deprecates all activity and workflow types registered in the domain.
// Executions that were started before the domain was deprecated continues to
// run.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation DeprecateDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeDomainDeprecatedFault "DomainDeprecatedFault"
//   Returned when the specified domain has been deprecated.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) DeprecateDomain(input *DeprecateDomainInput) (*DeprecateDomainOutput, error) {
	req, out := c.DeprecateDomainRequest(input)
	return out, req.Send()
}

// DeprecateDomainWithContext is the same as DeprecateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeprecateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) DeprecateDomainWithContext(ctx aws.Context, input *DeprecateDomainInput, opts ...request.Option) (*DeprecateDomainOutput, error) {
	req, out := c.DeprecateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeprecateWorkflowType = "DeprecateWorkflowType"

// DeprecateWorkflowTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeprecateWorkflowType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeprecateWorkflowType for more information on using the DeprecateWorkflowType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeprecateWorkflowTypeRequest method.
//    req, resp := client.DeprecateWorkflowTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) DeprecateWorkflowTypeRequest(input *DeprecateWorkflowTypeInput) (req *request.Request, output *DeprecateWorkflowTypeOutput) {
	op := &request.Operation{
		Name:       opDeprecateWorkflowType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeprecateWorkflowTypeInput{}
	}

	output = &DeprecateWorkflowTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeprecateWorkflowType API operation for Amazon Simple Workflow Service.
//
// Deprecates the specified workflow type. After a workflow type has been deprecated,
// you cannot create new executions of that type. Executions that were started
// before the type was deprecated continues to run. A deprecated workflow type
// may still be used when calling visibility actions.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. workflowType.name: String constraint. The key is
//    swf:workflowType.name. workflowType.version: String constraint. The key
//    is swf:workflowType.version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation DeprecateWorkflowType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeTypeDeprecatedFault "TypeDeprecatedFault"
//   Returned when the specified activity or workflow type was already deprecated.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) DeprecateWorkflowType(input *DeprecateWorkflowTypeInput) (*DeprecateWorkflowTypeOutput, error) {
	req, out := c.DeprecateWorkflowTypeRequest(input)
	return out, req.Send()
}

// DeprecateWorkflowTypeWithContext is the same as DeprecateWorkflowType with the addition of
// the ability to pass a context and additional request options.
//
// See DeprecateWorkflowType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) DeprecateWorkflowTypeWithContext(ctx aws.Context, input *DeprecateWorkflowTypeInput, opts ...request.Option) (*DeprecateWorkflowTypeOutput, error) {
	req, out := c.DeprecateWorkflowTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeActivityType = "DescribeActivityType"

// DescribeActivityTypeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeActivityType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeActivityType for more information on using the DescribeActivityType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeActivityTypeRequest method.
//    req, resp := client.DescribeActivityTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) DescribeActivityTypeRequest(input *DescribeActivityTypeInput) (req *request.Request, output *DescribeActivityTypeOutput) {
	op := &request.Operation{
		Name:       opDescribeActivityType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeActivityTypeInput{}
	}

	output = &DescribeActivityTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeActivityType API operation for Amazon Simple Workflow Service.
//
// Returns information about the specified activity type. This includes configuration
// settings provided when the type was registered and other general information
// about the type.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. activityType.name: String constraint. The key is
//    swf:activityType.name. activityType.version: String constraint. The key
//    is swf:activityType.version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation DescribeActivityType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) DescribeActivityType(input *DescribeActivityTypeInput) (*DescribeActivityTypeOutput, error) {
	req, out := c.DescribeActivityTypeRequest(input)
	return out, req.Send()
}

// DescribeActivityTypeWithContext is the same as DescribeActivityType with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeActivityType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) DescribeActivityTypeWithContext(ctx aws.Context, input *DescribeActivityTypeInput, opts ...request.Option) (*DescribeActivityTypeOutput, error) {
	req, out := c.DescribeActivityTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomain = "DescribeDomain"

// DescribeDomainRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomain for more information on using the DescribeDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDomainRequest method.
//    req, resp := client.DescribeDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) DescribeDomainRequest(input *DescribeDomainInput) (req *request.Request, output *DescribeDomainOutput) {
	op := &request.Operation{
		Name:       opDescribeDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDomainInput{}
	}

	output = &DescribeDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomain API operation for Amazon Simple Workflow Service.
//
// Returns information about the specified domain, including description and
// status.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation DescribeDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) DescribeDomain(input *DescribeDomainInput) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	return out, req.Send()
}

// DescribeDomainWithContext is the same as DescribeDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) DescribeDomainWithContext(ctx aws.Context, input *DescribeDomainInput, opts ...request.Option) (*DescribeDomainOutput, error) {
	req, out := c.DescribeDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkflowExecution = "DescribeWorkflowExecution"

// DescribeWorkflowExecutionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkflowExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkflowExecution for more information on using the DescribeWorkflowExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkflowExecutionRequest method.
//    req, resp := client.DescribeWorkflowExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) DescribeWorkflowExecutionRequest(input *DescribeWorkflowExecutionInput) (req *request.Request, output *DescribeWorkflowExecutionOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkflowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkflowExecutionInput{}
	}

	output = &DescribeWorkflowExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkflowExecution API operation for Amazon Simple Workflow Service.
//
// Returns information about the specified workflow execution including its
// type and some statistics.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation DescribeWorkflowExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) DescribeWorkflowExecution(input *DescribeWorkflowExecutionInput) (*DescribeWorkflowExecutionOutput, error) {
	req, out := c.DescribeWorkflowExecutionRequest(input)
	return out, req.Send()
}

// DescribeWorkflowExecutionWithContext is the same as DescribeWorkflowExecution with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkflowExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) DescribeWorkflowExecutionWithContext(ctx aws.Context, input *DescribeWorkflowExecutionInput, opts ...request.Option) (*DescribeWorkflowExecutionOutput, error) {
	req, out := c.DescribeWorkflowExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkflowType = "DescribeWorkflowType"

// DescribeWorkflowTypeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkflowType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkflowType for more information on using the DescribeWorkflowType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkflowTypeRequest method.
//    req, resp := client.DescribeWorkflowTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) DescribeWorkflowTypeRequest(input *DescribeWorkflowTypeInput) (req *request.Request, output *DescribeWorkflowTypeOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkflowType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkflowTypeInput{}
	}

	output = &DescribeWorkflowTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkflowType API operation for Amazon Simple Workflow Service.
//
// Returns information about the specified workflow type. This includes configuration
// settings specified when the type was registered and other information such
// as creation date, current status, etc.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. workflowType.name: String constraint. The key is
//    swf:workflowType.name. workflowType.version: String constraint. The key
//    is swf:workflowType.version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation DescribeWorkflowType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) DescribeWorkflowType(input *DescribeWorkflowTypeInput) (*DescribeWorkflowTypeOutput, error) {
	req, out := c.DescribeWorkflowTypeRequest(input)
	return out, req.Send()
}

// DescribeWorkflowTypeWithContext is the same as DescribeWorkflowType with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkflowType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) DescribeWorkflowTypeWithContext(ctx aws.Context, input *DescribeWorkflowTypeInput, opts ...request.Option) (*DescribeWorkflowTypeOutput, error) {
	req, out := c.DescribeWorkflowTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkflowExecutionHistory = "GetWorkflowExecutionHistory"

// GetWorkflowExecutionHistoryRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkflowExecutionHistory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkflowExecutionHistory for more information on using the GetWorkflowExecutionHistory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWorkflowExecutionHistoryRequest method.
//    req, resp := client.GetWorkflowExecutionHistoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) GetWorkflowExecutionHistoryRequest(input *GetWorkflowExecutionHistoryInput) (req *request.Request, output *GetWorkflowExecutionHistoryOutput) {
	op := &request.Operation{
		Name:       opGetWorkflowExecutionHistory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetWorkflowExecutionHistoryInput{}
	}

	output = &GetWorkflowExecutionHistoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkflowExecutionHistory API operation for Amazon Simple Workflow Service.
//
// Returns the history of the specified workflow execution. The results may
// be split into multiple pages. To retrieve subsequent pages, make the call
// again using the nextPageToken returned by the initial call.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation GetWorkflowExecutionHistory for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) GetWorkflowExecutionHistory(input *GetWorkflowExecutionHistoryInput) (*GetWorkflowExecutionHistoryOutput, error) {
	req, out := c.GetWorkflowExecutionHistoryRequest(input)
	return out, req.Send()
}

// GetWorkflowExecutionHistoryWithContext is the same as GetWorkflowExecutionHistory with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkflowExecutionHistory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) GetWorkflowExecutionHistoryWithContext(ctx aws.Context, input *GetWorkflowExecutionHistoryInput, opts ...request.Option) (*GetWorkflowExecutionHistoryOutput, error) {
	req, out := c.GetWorkflowExecutionHistoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetWorkflowExecutionHistoryPages iterates over the pages of a GetWorkflowExecutionHistory operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetWorkflowExecutionHistory method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetWorkflowExecutionHistory operation.
//    pageNum := 0
//    err := client.GetWorkflowExecutionHistoryPages(params,
//        func(page *swf.GetWorkflowExecutionHistoryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SWF) GetWorkflowExecutionHistoryPages(input *GetWorkflowExecutionHistoryInput, fn func(*GetWorkflowExecutionHistoryOutput, bool) bool) error {
	return c.GetWorkflowExecutionHistoryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetWorkflowExecutionHistoryPagesWithContext same as GetWorkflowExecutionHistoryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) GetWorkflowExecutionHistoryPagesWithContext(ctx aws.Context, input *GetWorkflowExecutionHistoryInput, fn func(*GetWorkflowExecutionHistoryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetWorkflowExecutionHistoryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetWorkflowExecutionHistoryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetWorkflowExecutionHistoryOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListActivityTypes = "ListActivityTypes"

// ListActivityTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListActivityTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListActivityTypes for more information on using the ListActivityTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListActivityTypesRequest method.
//    req, resp := client.ListActivityTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) ListActivityTypesRequest(input *ListActivityTypesInput) (req *request.Request, output *ListActivityTypesOutput) {
	op := &request.Operation{
		Name:       opListActivityTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListActivityTypesInput{}
	}

	output = &ListActivityTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListActivityTypes API operation for Amazon Simple Workflow Service.
//
// Returns information about all activities registered in the specified domain
// that match the specified name and registration status. The result includes
// information like creation date, current status of the activity, etc. The
// results may be split into multiple pages. To retrieve subsequent pages, make
// the call again using the nextPageToken returned by the initial call.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation ListActivityTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
func (c *SWF) ListActivityTypes(input *ListActivityTypesInput) (*ListActivityTypesOutput, error) {
	req, out := c.ListActivityTypesRequest(input)
	return out, req.Send()
}

// ListActivityTypesWithContext is the same as ListActivityTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListActivityTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) ListActivityTypesWithContext(ctx aws.Context, input *ListActivityTypesInput, opts ...request.Option) (*ListActivityTypesOutput, error) {
	req, out := c.ListActivityTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListActivityTypesPages iterates over the pages of a ListActivityTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListActivityTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListActivityTypes operation.
//    pageNum := 0
//    err := client.ListActivityTypesPages(params,
//        func(page *swf.ListActivityTypesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SWF) ListActivityTypesPages(input *ListActivityTypesInput, fn func(*ListActivityTypesOutput, bool) bool) error {
	return c.ListActivityTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListActivityTypesPagesWithContext same as ListActivityTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) ListActivityTypesPagesWithContext(ctx aws.Context, input *ListActivityTypesInput, fn func(*ListActivityTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListActivityTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListActivityTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListActivityTypesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListClosedWorkflowExecutions = "ListClosedWorkflowExecutions"

// ListClosedWorkflowExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListClosedWorkflowExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClosedWorkflowExecutions for more information on using the ListClosedWorkflowExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListClosedWorkflowExecutionsRequest method.
//    req, resp := client.ListClosedWorkflowExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) ListClosedWorkflowExecutionsRequest(input *ListClosedWorkflowExecutionsInput) (req *request.Request, output *WorkflowExecutionInfos) {
	op := &request.Operation{
		Name:       opListClosedWorkflowExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClosedWorkflowExecutionsInput{}
	}

	output = &WorkflowExecutionInfos{}
	req = c.newRequest(op, input, output)
	return
}

// ListClosedWorkflowExecutions API operation for Amazon Simple Workflow Service.
//
// Returns a list of closed workflow executions in the specified domain that
// meet the filtering criteria. The results may be split into multiple pages.
// To retrieve subsequent pages, make the call again using the nextPageToken
// returned by the initial call.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. tagFilter.tag: String constraint. The key is swf:tagFilter.tag.
//    typeFilter.name: String constraint. The key is swf:typeFilter.name. typeFilter.version:
//    String constraint. The key is swf:typeFilter.version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation ListClosedWorkflowExecutions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) ListClosedWorkflowExecutions(input *ListClosedWorkflowExecutionsInput) (*WorkflowExecutionInfos, error) {
	req, out := c.ListClosedWorkflowExecutionsRequest(input)
	return out, req.Send()
}

// ListClosedWorkflowExecutionsWithContext is the same as ListClosedWorkflowExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListClosedWorkflowExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) ListClosedWorkflowExecutionsWithContext(ctx aws.Context, input *ListClosedWorkflowExecutionsInput, opts ...request.Option) (*WorkflowExecutionInfos, error) {
	req, out := c.ListClosedWorkflowExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClosedWorkflowExecutionsPages iterates over the pages of a ListClosedWorkflowExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClosedWorkflowExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListClosedWorkflowExecutions operation.
//    pageNum := 0
//    err := client.ListClosedWorkflowExecutionsPages(params,
//        func(page *swf.WorkflowExecutionInfos, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SWF) ListClosedWorkflowExecutionsPages(input *ListClosedWorkflowExecutionsInput, fn func(*WorkflowExecutionInfos, bool) bool) error {
	return c.ListClosedWorkflowExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClosedWorkflowExecutionsPagesWithContext same as ListClosedWorkflowExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) ListClosedWorkflowExecutionsPagesWithContext(ctx aws.Context, input *ListClosedWorkflowExecutionsInput, fn func(*WorkflowExecutionInfos, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClosedWorkflowExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClosedWorkflowExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*WorkflowExecutionInfos), !p.HasNextPage())
	}
	return p.Err()
}

const opListDomains = "ListDomains"

// ListDomainsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomains for more information on using the ListDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDomainsRequest method.
//    req, resp := client.ListDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) ListDomainsRequest(input *ListDomainsInput) (req *request.Request, output *ListDomainsOutput) {
	op := &request.Operation{
		Name:       opListDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsInput{}
	}

	output = &ListDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomains API operation for Amazon Simple Workflow Service.
//
// Returns the list of domains registered in the account. The results may be
// split into multiple pages. To retrieve subsequent pages, make the call again
// using the nextPageToken returned by the initial call.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains. The element must be set to arn:aws:swf::AccountID:domain/*,
//    where AccountID is the account ID, with no dashes.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation ListDomains for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) ListDomains(input *ListDomainsInput) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	return out, req.Send()
}

// ListDomainsWithContext is the same as ListDomains with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) ListDomainsWithContext(ctx aws.Context, input *ListDomainsInput, opts ...request.Option) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainsPages iterates over the pages of a ListDomains operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomains method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDomains operation.
//    pageNum := 0
//    err := client.ListDomainsPages(params,
//        func(page *swf.ListDomainsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SWF) ListDomainsPages(input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool) error {
	return c.ListDomainsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainsPagesWithContext same as ListDomainsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) ListDomainsPagesWithContext(ctx aws.Context, input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDomainsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDomainsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDomainsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListOpenWorkflowExecutions = "ListOpenWorkflowExecutions"

// ListOpenWorkflowExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the ListOpenWorkflowExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOpenWorkflowExecutions for more information on using the ListOpenWorkflowExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOpenWorkflowExecutionsRequest method.
//    req, resp := client.ListOpenWorkflowExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) ListOpenWorkflowExecutionsRequest(input *ListOpenWorkflowExecutionsInput) (req *request.Request, output *WorkflowExecutionInfos) {
	op := &request.Operation{
		Name:       opListOpenWorkflowExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOpenWorkflowExecutionsInput{}
	}

	output = &WorkflowExecutionInfos{}
	req = c.newRequest(op, input, output)
	return
}

// ListOpenWorkflowExecutions API operation for Amazon Simple Workflow Service.
//
// Returns a list of open workflow executions in the specified domain that meet
// the filtering criteria. The results may be split into multiple pages. To
// retrieve subsequent pages, make the call again using the nextPageToken returned
// by the initial call.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. tagFilter.tag: String constraint. The key is swf:tagFilter.tag.
//    typeFilter.name: String constraint. The key is swf:typeFilter.name. typeFilter.version:
//    String constraint. The key is swf:typeFilter.version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation ListOpenWorkflowExecutions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) ListOpenWorkflowExecutions(input *ListOpenWorkflowExecutionsInput) (*WorkflowExecutionInfos, error) {
	req, out := c.ListOpenWorkflowExecutionsRequest(input)
	return out, req.Send()
}

// ListOpenWorkflowExecutionsWithContext is the same as ListOpenWorkflowExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See ListOpenWorkflowExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) ListOpenWorkflowExecutionsWithContext(ctx aws.Context, input *ListOpenWorkflowExecutionsInput, opts ...request.Option) (*WorkflowExecutionInfos, error) {
	req, out := c.ListOpenWorkflowExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOpenWorkflowExecutionsPages iterates over the pages of a ListOpenWorkflowExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOpenWorkflowExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOpenWorkflowExecutions operation.
//    pageNum := 0
//    err := client.ListOpenWorkflowExecutionsPages(params,
//        func(page *swf.WorkflowExecutionInfos, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SWF) ListOpenWorkflowExecutionsPages(input *ListOpenWorkflowExecutionsInput, fn func(*WorkflowExecutionInfos, bool) bool) error {
	return c.ListOpenWorkflowExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOpenWorkflowExecutionsPagesWithContext same as ListOpenWorkflowExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) ListOpenWorkflowExecutionsPagesWithContext(ctx aws.Context, input *ListOpenWorkflowExecutionsInput, fn func(*WorkflowExecutionInfos, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOpenWorkflowExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOpenWorkflowExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*WorkflowExecutionInfos), !p.HasNextPage())
	}
	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Simple Workflow Service.
//
// List tags for a given domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   Returned by any operation if a system imposed limitation has been reached.
//   To address this fault you should either clean up unused resources or increase
//   the limit by contacting AWS.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWorkflowTypes = "ListWorkflowTypes"

// ListWorkflowTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkflowTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkflowTypes for more information on using the ListWorkflowTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorkflowTypesRequest method.
//    req, resp := client.ListWorkflowTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) ListWorkflowTypesRequest(input *ListWorkflowTypesInput) (req *request.Request, output *ListWorkflowTypesOutput) {
	op := &request.Operation{
		Name:       opListWorkflowTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkflowTypesInput{}
	}

	output = &ListWorkflowTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkflowTypes API operation for Amazon Simple Workflow Service.
//
// Returns information about workflow types in the specified domain. The results
// may be split into multiple pages that can be retrieved by making the call
// repeatedly.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation ListWorkflowTypes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
func (c *SWF) ListWorkflowTypes(input *ListWorkflowTypesInput) (*ListWorkflowTypesOutput, error) {
	req, out := c.ListWorkflowTypesRequest(input)
	return out, req.Send()
}

// ListWorkflowTypesWithContext is the same as ListWorkflowTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkflowTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) ListWorkflowTypesWithContext(ctx aws.Context, input *ListWorkflowTypesInput, opts ...request.Option) (*ListWorkflowTypesOutput, error) {
	req, out := c.ListWorkflowTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkflowTypesPages iterates over the pages of a ListWorkflowTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkflowTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorkflowTypes operation.
//    pageNum := 0
//    err := client.ListWorkflowTypesPages(params,
//        func(page *swf.ListWorkflowTypesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SWF) ListWorkflowTypesPages(input *ListWorkflowTypesInput, fn func(*ListWorkflowTypesOutput, bool) bool) error {
	return c.ListWorkflowTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkflowTypesPagesWithContext same as ListWorkflowTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) ListWorkflowTypesPagesWithContext(ctx aws.Context, input *ListWorkflowTypesInput, fn func(*ListWorkflowTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkflowTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkflowTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListWorkflowTypesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opPollForActivityTask = "PollForActivityTask"

// PollForActivityTaskRequest generates a "aws/request.Request" representing the
// client's request for the PollForActivityTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PollForActivityTask for more information on using the PollForActivityTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PollForActivityTaskRequest method.
//    req, resp := client.PollForActivityTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) PollForActivityTaskRequest(input *PollForActivityTaskInput) (req *request.Request, output *PollForActivityTaskOutput) {
	op := &request.Operation{
		Name:       opPollForActivityTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PollForActivityTaskInput{}
	}

	output = &PollForActivityTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PollForActivityTask API operation for Amazon Simple Workflow Service.
//
// Used by workers to get an ActivityTask from the specified activity taskList.
// This initiates a long poll, where the service holds the HTTP connection open
// and responds as soon as a task becomes available. The maximum time the service
// holds on to the request before responding is 60 seconds. If no task is available
// within 60 seconds, the poll returns an empty result. An empty result, in
// this context, means that an ActivityTask is returned, but that the value
// of taskToken is an empty string. If a task is returned, the worker should
// use its type to identify and process it correctly.
//
// Workers should set their client side socket timeout to at least 70 seconds
// (10 seconds higher than the maximum time service may hold the poll request).
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the taskList.name parameter by using a Condition element with
//    the swf:taskList.name key to allow the action to access only certain task
//    lists.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation PollForActivityTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   Returned by any operation if a system imposed limitation has been reached.
//   To address this fault you should either clean up unused resources or increase
//   the limit by contacting AWS.
//
func (c *SWF) PollForActivityTask(input *PollForActivityTaskInput) (*PollForActivityTaskOutput, error) {
	req, out := c.PollForActivityTaskRequest(input)
	return out, req.Send()
}

// PollForActivityTaskWithContext is the same as PollForActivityTask with the addition of
// the ability to pass a context and additional request options.
//
// See PollForActivityTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) PollForActivityTaskWithContext(ctx aws.Context, input *PollForActivityTaskInput, opts ...request.Option) (*PollForActivityTaskOutput, error) {
	req, out := c.PollForActivityTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPollForDecisionTask = "PollForDecisionTask"

// PollForDecisionTaskRequest generates a "aws/request.Request" representing the
// client's request for the PollForDecisionTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PollForDecisionTask for more information on using the PollForDecisionTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PollForDecisionTaskRequest method.
//    req, resp := client.PollForDecisionTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) PollForDecisionTaskRequest(input *PollForDecisionTaskInput) (req *request.Request, output *PollForDecisionTaskOutput) {
	op := &request.Operation{
		Name:       opPollForDecisionTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &PollForDecisionTaskInput{}
	}

	output = &PollForDecisionTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PollForDecisionTask API operation for Amazon Simple Workflow Service.
//
// Used by deciders to get a DecisionTask from the specified decision taskList.
// A decision task may be returned for any open workflow execution that is using
// the specified task list. The task includes a paginated view of the history
// of the workflow execution. The decider should use the workflow type and the
// history to determine how to properly handle the task.
//
// This action initiates a long poll, where the service holds the HTTP connection
// open and responds as soon a task becomes available. If no decision task is
// available in the specified task list before the timeout of 60 seconds expires,
// an empty result is returned. An empty result, in this context, means that
// a DecisionTask is returned, but that the value of taskToken is an empty string.
//
// Deciders should set their client side socket timeout to at least 70 seconds
// (10 seconds higher than the timeout).
//
// Because the number of workflow history events for a single workflow execution
// might be very large, the result returned might be split up across a number
// of pages. To retrieve subsequent pages, make additional calls to PollForDecisionTask
// using the nextPageToken returned by the initial call. Note that you do not
// call GetWorkflowExecutionHistory with this nextPageToken. Instead, call PollForDecisionTask
// again.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the taskList.name parameter by using a Condition element with
//    the swf:taskList.name key to allow the action to access only certain task
//    lists.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation PollForDecisionTask for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   Returned by any operation if a system imposed limitation has been reached.
//   To address this fault you should either clean up unused resources or increase
//   the limit by contacting AWS.
//
func (c *SWF) PollForDecisionTask(input *PollForDecisionTaskInput) (*PollForDecisionTaskOutput, error) {
	req, out := c.PollForDecisionTaskRequest(input)
	return out, req.Send()
}

// PollForDecisionTaskWithContext is the same as PollForDecisionTask with the addition of
// the ability to pass a context and additional request options.
//
// See PollForDecisionTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) PollForDecisionTaskWithContext(ctx aws.Context, input *PollForDecisionTaskInput, opts ...request.Option) (*PollForDecisionTaskOutput, error) {
	req, out := c.PollForDecisionTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// PollForDecisionTaskPages iterates over the pages of a PollForDecisionTask operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See PollForDecisionTask method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a PollForDecisionTask operation.
//    pageNum := 0
//    err := client.PollForDecisionTaskPages(params,
//        func(page *swf.PollForDecisionTaskOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SWF) PollForDecisionTaskPages(input *PollForDecisionTaskInput, fn func(*PollForDecisionTaskOutput, bool) bool) error {
	return c.PollForDecisionTaskPagesWithContext(aws.BackgroundContext(), input, fn)
}

// PollForDecisionTaskPagesWithContext same as PollForDecisionTaskPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) PollForDecisionTaskPagesWithContext(ctx aws.Context, input *PollForDecisionTaskInput, fn func(*PollForDecisionTaskOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *PollForDecisionTaskInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.PollForDecisionTaskRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*PollForDecisionTaskOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opRecordActivityTaskHeartbeat = "RecordActivityTaskHeartbeat"

// RecordActivityTaskHeartbeatRequest generates a "aws/request.Request" representing the
// client's request for the RecordActivityTaskHeartbeat operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RecordActivityTaskHeartbeat for more information on using the RecordActivityTaskHeartbeat
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RecordActivityTaskHeartbeatRequest method.
//    req, resp := client.RecordActivityTaskHeartbeatRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) RecordActivityTaskHeartbeatRequest(input *RecordActivityTaskHeartbeatInput) (req *request.Request, output *RecordActivityTaskHeartbeatOutput) {
	op := &request.Operation{
		Name:       opRecordActivityTaskHeartbeat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RecordActivityTaskHeartbeatInput{}
	}

	output = &RecordActivityTaskHeartbeatOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RecordActivityTaskHeartbeat API operation for Amazon Simple Workflow Service.
//
// Used by activity workers to report to the service that the ActivityTask represented
// by the specified taskToken is still making progress. The worker can also
// specify details of the progress, for example percent complete, using the
// details parameter. This action can also be used by the worker as a mechanism
// to check if cancellation is being requested for the activity task. If a cancellation
// is being attempted for the specified task, then the boolean cancelRequested
// flag returned by the service is set to true.
//
// This action resets the taskHeartbeatTimeout clock. The taskHeartbeatTimeout
// is specified in RegisterActivityType.
//
// This action doesn't in itself create an event in the workflow execution history.
// However, if the task times out, the workflow execution history contains a
// ActivityTaskTimedOut event that contains the information from the last heartbeat
// generated by the activity worker.
//
// The taskStartToCloseTimeout of an activity type is the maximum duration of
// an activity task, regardless of the number of RecordActivityTaskHeartbeat
// requests received. The taskStartToCloseTimeout is also specified in RegisterActivityType.
//
// This operation is only useful for long-lived activities to report liveliness
// of the task and to determine if a cancellation is being attempted.
//
// If the cancelRequested flag returns true, a cancellation is being attempted.
// If the worker can cancel the activity, it should respond with RespondActivityTaskCanceled.
// Otherwise, it should ignore the cancellation request.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation RecordActivityTaskHeartbeat for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) RecordActivityTaskHeartbeat(input *RecordActivityTaskHeartbeatInput) (*RecordActivityTaskHeartbeatOutput, error) {
	req, out := c.RecordActivityTaskHeartbeatRequest(input)
	return out, req.Send()
}

// RecordActivityTaskHeartbeatWithContext is the same as RecordActivityTaskHeartbeat with the addition of
// the ability to pass a context and additional request options.
//
// See RecordActivityTaskHeartbeat for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) RecordActivityTaskHeartbeatWithContext(ctx aws.Context, input *RecordActivityTaskHeartbeatInput, opts ...request.Option) (*RecordActivityTaskHeartbeatOutput, error) {
	req, out := c.RecordActivityTaskHeartbeatRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterActivityType = "RegisterActivityType"

// RegisterActivityTypeRequest generates a "aws/request.Request" representing the
// client's request for the RegisterActivityType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterActivityType for more information on using the RegisterActivityType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterActivityTypeRequest method.
//    req, resp := client.RegisterActivityTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) RegisterActivityTypeRequest(input *RegisterActivityTypeInput) (req *request.Request, output *RegisterActivityTypeOutput) {
	op := &request.Operation{
		Name:       opRegisterActivityType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterActivityTypeInput{}
	}

	output = &RegisterActivityTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterActivityType API operation for Amazon Simple Workflow Service.
//
// Registers a new activity type along with its configuration settings in the
// specified domain.
//
// A TypeAlreadyExists fault is returned if the type already exists in the domain.
// You cannot change any configuration settings of the type after its registration,
// and it must be registered as a new version.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. defaultTaskList.name: String constraint. The key
//    is swf:defaultTaskList.name. name: String constraint. The key is swf:name.
//    version: String constraint. The key is swf:version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation RegisterActivityType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTypeAlreadyExistsFault "TypeAlreadyExistsFault"
//   Returned if the type already exists in the specified domain. You may get
//   this fault if you are registering a type that is either already registered
//   or deprecated, or if you undeprecate a type that is currently registered.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   Returned by any operation if a system imposed limitation has been reached.
//   To address this fault you should either clean up unused resources or increase
//   the limit by contacting AWS.
//
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) RegisterActivityType(input *RegisterActivityTypeInput) (*RegisterActivityTypeOutput, error) {
	req, out := c.RegisterActivityTypeRequest(input)
	return out, req.Send()
}

// RegisterActivityTypeWithContext is the same as RegisterActivityType with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterActivityType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) RegisterActivityTypeWithContext(ctx aws.Context, input *RegisterActivityTypeInput, opts ...request.Option) (*RegisterActivityTypeOutput, error) {
	req, out := c.RegisterActivityTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterDomain = "RegisterDomain"

// RegisterDomainRequest generates a "aws/request.Request" representing the
// client's request for the RegisterDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterDomain for more information on using the RegisterDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterDomainRequest method.
//    req, resp := client.RegisterDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) RegisterDomainRequest(input *RegisterDomainInput) (req *request.Request, output *RegisterDomainOutput) {
	op := &request.Operation{
		Name:       opRegisterDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterDomainInput{}
	}

	output = &RegisterDomainOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterDomain API operation for Amazon Simple Workflow Service.
//
// Registers a new domain.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * You cannot use an IAM policy to control domain access for this action.
//    The name of the domain being registered is available as the resource of
//    this action.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation RegisterDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDomainAlreadyExistsFault "DomainAlreadyExistsFault"
//   Returned if the domain already exists. You may get this fault if you are
//   registering a domain that is either already registered or deprecated, or
//   if you undeprecate a domain that is currently registered.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   Returned by any operation if a system imposed limitation has been reached.
//   To address this fault you should either clean up unused resources or increase
//   the limit by contacting AWS.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
//   * ErrCodeTooManyTagsFault "TooManyTagsFault"
//   You've exceeded the number of tags allowed for a domain.
//
func (c *SWF) RegisterDomain(input *RegisterDomainInput) (*RegisterDomainOutput, error) {
	req, out := c.RegisterDomainRequest(input)
	return out, req.Send()
}

// RegisterDomainWithContext is the same as RegisterDomain with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) RegisterDomainWithContext(ctx aws.Context, input *RegisterDomainInput, opts ...request.Option) (*RegisterDomainOutput, error) {
	req, out := c.RegisterDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterWorkflowType = "RegisterWorkflowType"

// RegisterWorkflowTypeRequest generates a "aws/request.Request" representing the
// client's request for the RegisterWorkflowType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterWorkflowType for more information on using the RegisterWorkflowType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterWorkflowTypeRequest method.
//    req, resp := client.RegisterWorkflowTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) RegisterWorkflowTypeRequest(input *RegisterWorkflowTypeInput) (req *request.Request, output *RegisterWorkflowTypeOutput) {
	op := &request.Operation{
		Name:       opRegisterWorkflowType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterWorkflowTypeInput{}
	}

	output = &RegisterWorkflowTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterWorkflowType API operation for Amazon Simple Workflow Service.
//
// Registers a new workflow type and its configuration settings in the specified
// domain.
//
// The retention period for the workflow history is set by the RegisterDomain
// action.
//
// If the type already exists, then a TypeAlreadyExists fault is returned. You
// cannot change the configuration settings of a workflow type once it is registered
// and it must be registered as a new version.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. defaultTaskList.name: String constraint. The key
//    is swf:defaultTaskList.name. name: String constraint. The key is swf:name.
//    version: String constraint. The key is swf:version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation RegisterWorkflowType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTypeAlreadyExistsFault "TypeAlreadyExistsFault"
//   Returned if the type already exists in the specified domain. You may get
//   this fault if you are registering a type that is either already registered
//   or deprecated, or if you undeprecate a type that is currently registered.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   Returned by any operation if a system imposed limitation has been reached.
//   To address this fault you should either clean up unused resources or increase
//   the limit by contacting AWS.
//
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) RegisterWorkflowType(input *RegisterWorkflowTypeInput) (*RegisterWorkflowTypeOutput, error) {
	req, out := c.RegisterWorkflowTypeRequest(input)
	return out, req.Send()
}

// RegisterWorkflowTypeWithContext is the same as RegisterWorkflowType with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterWorkflowType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) RegisterWorkflowTypeWithContext(ctx aws.Context, input *RegisterWorkflowTypeInput, opts ...request.Option) (*RegisterWorkflowTypeOutput, error) {
	req, out := c.RegisterWorkflowTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRequestCancelWorkflowExecution = "RequestCancelWorkflowExecution"

// RequestCancelWorkflowExecutionRequest generates a "aws/request.Request" representing the
// client's request for the RequestCancelWorkflowExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RequestCancelWorkflowExecution for more information on using the RequestCancelWorkflowExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RequestCancelWorkflowExecutionRequest method.
//    req, resp := client.RequestCancelWorkflowExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) RequestCancelWorkflowExecutionRequest(input *RequestCancelWorkflowExecutionInput) (req *request.Request, output *RequestCancelWorkflowExecutionOutput) {
	op := &request.Operation{
		Name:       opRequestCancelWorkflowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestCancelWorkflowExecutionInput{}
	}

	output = &RequestCancelWorkflowExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RequestCancelWorkflowExecution API operation for Amazon Simple Workflow Service.
//
// Records a WorkflowExecutionCancelRequested event in the currently running
// workflow execution identified by the given domain, workflowId, and runId.
// This logically requests the cancellation of the workflow execution as a whole.
// It is up to the decider to take appropriate actions when it receives an execution
// history with this event.
//
// If the runId isn't specified, the WorkflowExecutionCancelRequested event
// is recorded in the history of the current open workflow execution with the
// specified workflowId in the domain.
//
// Because this action allows the workflow to properly clean up and gracefully
// close, it should be used instead of TerminateWorkflowExecution when possible.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation RequestCancelWorkflowExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) RequestCancelWorkflowExecution(input *RequestCancelWorkflowExecutionInput) (*RequestCancelWorkflowExecutionOutput, error) {
	req, out := c.RequestCancelWorkflowExecutionRequest(input)
	return out, req.Send()
}

// RequestCancelWorkflowExecutionWithContext is the same as RequestCancelWorkflowExecution with the addition of
// the ability to pass a context and additional request options.
//
// See RequestCancelWorkflowExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) RequestCancelWorkflowExecutionWithContext(ctx aws.Context, input *RequestCancelWorkflowExecutionInput, opts ...request.Option) (*RequestCancelWorkflowExecutionOutput, error) {
	req, out := c.RequestCancelWorkflowExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRespondActivityTaskCanceled = "RespondActivityTaskCanceled"

// RespondActivityTaskCanceledRequest generates a "aws/request.Request" representing the
// client's request for the RespondActivityTaskCanceled operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RespondActivityTaskCanceled for more information on using the RespondActivityTaskCanceled
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RespondActivityTaskCanceledRequest method.
//    req, resp := client.RespondActivityTaskCanceledRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) RespondActivityTaskCanceledRequest(input *RespondActivityTaskCanceledInput) (req *request.Request, output *RespondActivityTaskCanceledOutput) {
	op := &request.Operation{
		Name:       opRespondActivityTaskCanceled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RespondActivityTaskCanceledInput{}
	}

	output = &RespondActivityTaskCanceledOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RespondActivityTaskCanceled API operation for Amazon Simple Workflow Service.
//
// Used by workers to tell the service that the ActivityTask identified by the
// taskToken was successfully canceled. Additional details can be provided using
// the details argument.
//
// These details (if provided) appear in the ActivityTaskCanceled event added
// to the workflow history.
//
// Only use this operation if the canceled flag of a RecordActivityTaskHeartbeat
// request returns true and if the activity can be safely undone or abandoned.
//
// A task is considered open from the time that it is scheduled until it is
// closed. Therefore a task is reported as open while a worker is processing
// it. A task is closed after it has been specified in a call to RespondActivityTaskCompleted,
// RespondActivityTaskCanceled, RespondActivityTaskFailed, or the task has timed
// out (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation RespondActivityTaskCanceled for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) RespondActivityTaskCanceled(input *RespondActivityTaskCanceledInput) (*RespondActivityTaskCanceledOutput, error) {
	req, out := c.RespondActivityTaskCanceledRequest(input)
	return out, req.Send()
}

// RespondActivityTaskCanceledWithContext is the same as RespondActivityTaskCanceled with the addition of
// the ability to pass a context and additional request options.
//
// See RespondActivityTaskCanceled for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) RespondActivityTaskCanceledWithContext(ctx aws.Context, input *RespondActivityTaskCanceledInput, opts ...request.Option) (*RespondActivityTaskCanceledOutput, error) {
	req, out := c.RespondActivityTaskCanceledRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRespondActivityTaskCompleted = "RespondActivityTaskCompleted"

// RespondActivityTaskCompletedRequest generates a "aws/request.Request" representing the
// client's request for the RespondActivityTaskCompleted operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RespondActivityTaskCompleted for more information on using the RespondActivityTaskCompleted
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RespondActivityTaskCompletedRequest method.
//    req, resp := client.RespondActivityTaskCompletedRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) RespondActivityTaskCompletedRequest(input *RespondActivityTaskCompletedInput) (req *request.Request, output *RespondActivityTaskCompletedOutput) {
	op := &request.Operation{
		Name:       opRespondActivityTaskCompleted,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RespondActivityTaskCompletedInput{}
	}

	output = &RespondActivityTaskCompletedOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RespondActivityTaskCompleted API operation for Amazon Simple Workflow Service.
//
// Used by workers to tell the service that the ActivityTask identified by the
// taskToken completed successfully with a result (if provided). The result
// appears in the ActivityTaskCompleted event in the workflow history.
//
// If the requested task doesn't complete successfully, use RespondActivityTaskFailed
// instead. If the worker finds that the task is canceled through the canceled
// flag returned by RecordActivityTaskHeartbeat, it should cancel the task,
// clean up and then call RespondActivityTaskCanceled.
//
// A task is considered open from the time that it is scheduled until it is
// closed. Therefore a task is reported as open while a worker is processing
// it. A task is closed after it has been specified in a call to RespondActivityTaskCompleted,
// RespondActivityTaskCanceled, RespondActivityTaskFailed, or the task has timed
// out (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation RespondActivityTaskCompleted for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) RespondActivityTaskCompleted(input *RespondActivityTaskCompletedInput) (*RespondActivityTaskCompletedOutput, error) {
	req, out := c.RespondActivityTaskCompletedRequest(input)
	return out, req.Send()
}

// RespondActivityTaskCompletedWithContext is the same as RespondActivityTaskCompleted with the addition of
// the ability to pass a context and additional request options.
//
// See RespondActivityTaskCompleted for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) RespondActivityTaskCompletedWithContext(ctx aws.Context, input *RespondActivityTaskCompletedInput, opts ...request.Option) (*RespondActivityTaskCompletedOutput, error) {
	req, out := c.RespondActivityTaskCompletedRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRespondActivityTaskFailed = "RespondActivityTaskFailed"

// RespondActivityTaskFailedRequest generates a "aws/request.Request" representing the
// client's request for the RespondActivityTaskFailed operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RespondActivityTaskFailed for more information on using the RespondActivityTaskFailed
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RespondActivityTaskFailedRequest method.
//    req, resp := client.RespondActivityTaskFailedRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) RespondActivityTaskFailedRequest(input *RespondActivityTaskFailedInput) (req *request.Request, output *RespondActivityTaskFailedOutput) {
	op := &request.Operation{
		Name:       opRespondActivityTaskFailed,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RespondActivityTaskFailedInput{}
	}

	output = &RespondActivityTaskFailedOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RespondActivityTaskFailed API operation for Amazon Simple Workflow Service.
//
// Used by workers to tell the service that the ActivityTask identified by the
// taskToken has failed with reason (if specified). The reason and details appear
// in the ActivityTaskFailed event added to the workflow history.
//
// A task is considered open from the time that it is scheduled until it is
// closed. Therefore a task is reported as open while a worker is processing
// it. A task is closed after it has been specified in a call to RespondActivityTaskCompleted,
// RespondActivityTaskCanceled, RespondActivityTaskFailed, or the task has timed
// out (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-basic.html#swf-dev-timeout-types).
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation RespondActivityTaskFailed for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) RespondActivityTaskFailed(input *RespondActivityTaskFailedInput) (*RespondActivityTaskFailedOutput, error) {
	req, out := c.RespondActivityTaskFailedRequest(input)
	return out, req.Send()
}

// RespondActivityTaskFailedWithContext is the same as RespondActivityTaskFailed with the addition of
// the ability to pass a context and additional request options.
//
// See RespondActivityTaskFailed for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) RespondActivityTaskFailedWithContext(ctx aws.Context, input *RespondActivityTaskFailedInput, opts ...request.Option) (*RespondActivityTaskFailedOutput, error) {
	req, out := c.RespondActivityTaskFailedRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRespondDecisionTaskCompleted = "RespondDecisionTaskCompleted"

// RespondDecisionTaskCompletedRequest generates a "aws/request.Request" representing the
// client's request for the RespondDecisionTaskCompleted operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RespondDecisionTaskCompleted for more information on using the RespondDecisionTaskCompleted
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RespondDecisionTaskCompletedRequest method.
//    req, resp := client.RespondDecisionTaskCompletedRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) RespondDecisionTaskCompletedRequest(input *RespondDecisionTaskCompletedInput) (req *request.Request, output *RespondDecisionTaskCompletedOutput) {
	op := &request.Operation{
		Name:       opRespondDecisionTaskCompleted,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RespondDecisionTaskCompletedInput{}
	}

	output = &RespondDecisionTaskCompletedOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RespondDecisionTaskCompleted API operation for Amazon Simple Workflow Service.
//
// Used by deciders to tell the service that the DecisionTask identified by
// the taskToken has successfully completed. The decisions argument specifies
// the list of decisions made while processing the task.
//
// A DecisionTaskCompleted event is added to the workflow history. The executionContext
// specified is attached to the event in the workflow execution history.
//
// Access Control
//
// If an IAM policy grants permission to use RespondDecisionTaskCompleted, it
// can express permissions for the list of decisions in the decisions parameter.
// Each of the decisions has one or more parameters, much like a regular API
// call. To allow for policies to be as readable as possible, you can express
// permissions on decisions as if they were actual API calls, including applying
// conditions to some parameters. For more information, see Using IAM to Manage
// Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation RespondDecisionTaskCompleted for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) RespondDecisionTaskCompleted(input *RespondDecisionTaskCompletedInput) (*RespondDecisionTaskCompletedOutput, error) {
	req, out := c.RespondDecisionTaskCompletedRequest(input)
	return out, req.Send()
}

// RespondDecisionTaskCompletedWithContext is the same as RespondDecisionTaskCompleted with the addition of
// the ability to pass a context and additional request options.
//
// See RespondDecisionTaskCompleted for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) RespondDecisionTaskCompletedWithContext(ctx aws.Context, input *RespondDecisionTaskCompletedInput, opts ...request.Option) (*RespondDecisionTaskCompletedOutput, error) {
	req, out := c.RespondDecisionTaskCompletedRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSignalWorkflowExecution = "SignalWorkflowExecution"

// SignalWorkflowExecutionRequest generates a "aws/request.Request" representing the
// client's request for the SignalWorkflowExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SignalWorkflowExecution for more information on using the SignalWorkflowExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SignalWorkflowExecutionRequest method.
//    req, resp := client.SignalWorkflowExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) SignalWorkflowExecutionRequest(input *SignalWorkflowExecutionInput) (req *request.Request, output *SignalWorkflowExecutionOutput) {
	op := &request.Operation{
		Name:       opSignalWorkflowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SignalWorkflowExecutionInput{}
	}

	output = &SignalWorkflowExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SignalWorkflowExecution API operation for Amazon Simple Workflow Service.
//
// Records a WorkflowExecutionSignaled event in the workflow execution history
// and creates a decision task for the workflow execution identified by the
// given domain, workflowId and runId. The event is recorded with the specified
// user defined signalName and input (if provided).
//
// If a runId isn't specified, then the WorkflowExecutionSignaled event is recorded
// in the history of the current open workflow with the matching workflowId
// in the domain.
//
// If the specified workflow execution isn't open, this method fails with UnknownResource.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation SignalWorkflowExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) SignalWorkflowExecution(input *SignalWorkflowExecutionInput) (*SignalWorkflowExecutionOutput, error) {
	req, out := c.SignalWorkflowExecutionRequest(input)
	return out, req.Send()
}

// SignalWorkflowExecutionWithContext is the same as SignalWorkflowExecution with the addition of
// the ability to pass a context and additional request options.
//
// See SignalWorkflowExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) SignalWorkflowExecutionWithContext(ctx aws.Context, input *SignalWorkflowExecutionInput, opts ...request.Option) (*SignalWorkflowExecutionOutput, error) {
	req, out := c.SignalWorkflowExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartWorkflowExecution = "StartWorkflowExecution"

// StartWorkflowExecutionRequest generates a "aws/request.Request" representing the
// client's request for the StartWorkflowExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartWorkflowExecution for more information on using the StartWorkflowExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartWorkflowExecutionRequest method.
//    req, resp := client.StartWorkflowExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) StartWorkflowExecutionRequest(input *StartWorkflowExecutionInput) (req *request.Request, output *StartWorkflowExecutionOutput) {
	op := &request.Operation{
		Name:       opStartWorkflowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartWorkflowExecutionInput{}
	}

	output = &StartWorkflowExecutionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartWorkflowExecution API operation for Amazon Simple Workflow Service.
//
// Starts an execution of the workflow type in the specified domain using the
// provided workflowId and input data.
//
// This action returns the newly started workflow execution.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. tagList.member.0: The key is swf:tagList.member.0.
//    tagList.member.1: The key is swf:tagList.member.1. tagList.member.2: The
//    key is swf:tagList.member.2. tagList.member.3: The key is swf:tagList.member.3.
//    tagList.member.4: The key is swf:tagList.member.4. taskList: String constraint.
//    The key is swf:taskList.name. workflowType.name: String constraint. The
//    key is swf:workflowType.name. workflowType.version: String constraint.
//    The key is swf:workflowType.version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation StartWorkflowExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeTypeDeprecatedFault "TypeDeprecatedFault"
//   Returned when the specified activity or workflow type was already deprecated.
//
//   * ErrCodeWorkflowExecutionAlreadyStartedFault "WorkflowExecutionAlreadyStartedFault"
//   Returned by StartWorkflowExecution when an open execution with the same workflowId
//   is already running in the specified domain.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   Returned by any operation if a system imposed limitation has been reached.
//   To address this fault you should either clean up unused resources or increase
//   the limit by contacting AWS.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
//   * ErrCodeDefaultUndefinedFault "DefaultUndefinedFault"
//   The StartWorkflowExecution API action was called without the required parameters
//   set.
//
//   Some workflow execution parameters, such as the decision taskList, must be
//   set to start the execution. However, these parameters might have been set
//   as defaults when the workflow type was registered. In this case, you can
//   omit these parameters from the StartWorkflowExecution call and Amazon SWF
//   uses the values defined in the workflow type.
//
//   If these parameters aren't set and no default parameters were defined in
//   the workflow type, this error is displayed.
//
func (c *SWF) StartWorkflowExecution(input *StartWorkflowExecutionInput) (*StartWorkflowExecutionOutput, error) {
	req, out := c.StartWorkflowExecutionRequest(input)
	return out, req.Send()
}

// StartWorkflowExecutionWithContext is the same as StartWorkflowExecution with the addition of
// the ability to pass a context and additional request options.
//
// See StartWorkflowExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) StartWorkflowExecutionWithContext(ctx aws.Context, input *StartWorkflowExecutionInput, opts ...request.Option) (*StartWorkflowExecutionOutput, error) {
	req, out := c.StartWorkflowExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Simple Workflow Service.
//
// Add a tag to a Amazon SWF domain.
//
// Amazon SWF supports a maximum of 50 tags per resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeTooManyTagsFault "TooManyTagsFault"
//   You've exceeded the number of tags allowed for a domain.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   Returned by any operation if a system imposed limitation has been reached.
//   To address this fault you should either clean up unused resources or increase
//   the limit by contacting AWS.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateWorkflowExecution = "TerminateWorkflowExecution"

// TerminateWorkflowExecutionRequest generates a "aws/request.Request" representing the
// client's request for the TerminateWorkflowExecution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateWorkflowExecution for more information on using the TerminateWorkflowExecution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TerminateWorkflowExecutionRequest method.
//    req, resp := client.TerminateWorkflowExecutionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) TerminateWorkflowExecutionRequest(input *TerminateWorkflowExecutionInput) (req *request.Request, output *TerminateWorkflowExecutionOutput) {
	op := &request.Operation{
		Name:       opTerminateWorkflowExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateWorkflowExecutionInput{}
	}

	output = &TerminateWorkflowExecutionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TerminateWorkflowExecution API operation for Amazon Simple Workflow Service.
//
// Records a WorkflowExecutionTerminated event and forces closure of the workflow
// execution identified by the given domain, runId, and workflowId. The child
// policy, registered with the workflow type or specified when starting this
// execution, is applied to any open child workflow executions of this workflow
// execution.
//
// If the identified workflow execution was in progress, it is terminated immediately.
//
// If a runId isn't specified, then the WorkflowExecutionTerminated event is
// recorded in the history of the current open workflow with the matching workflowId
// in the domain.
//
// You should consider using RequestCancelWorkflowExecution action instead because
// it allows the workflow to gracefully close while TerminateWorkflowExecution
// doesn't.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation TerminateWorkflowExecution for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) TerminateWorkflowExecution(input *TerminateWorkflowExecutionInput) (*TerminateWorkflowExecutionOutput, error) {
	req, out := c.TerminateWorkflowExecutionRequest(input)
	return out, req.Send()
}

// TerminateWorkflowExecutionWithContext is the same as TerminateWorkflowExecution with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateWorkflowExecution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) TerminateWorkflowExecutionWithContext(ctx aws.Context, input *TerminateWorkflowExecutionInput, opts ...request.Option) (*TerminateWorkflowExecutionOutput, error) {
	req, out := c.TerminateWorkflowExecutionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUndeprecateActivityType = "UndeprecateActivityType"

// UndeprecateActivityTypeRequest generates a "aws/request.Request" representing the
// client's request for the UndeprecateActivityType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UndeprecateActivityType for more information on using the UndeprecateActivityType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UndeprecateActivityTypeRequest method.
//    req, resp := client.UndeprecateActivityTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) UndeprecateActivityTypeRequest(input *UndeprecateActivityTypeInput) (req *request.Request, output *UndeprecateActivityTypeOutput) {
	op := &request.Operation{
		Name:       opUndeprecateActivityType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UndeprecateActivityTypeInput{}
	}

	output = &UndeprecateActivityTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UndeprecateActivityType API operation for Amazon Simple Workflow Service.
//
// Undeprecates a previously deprecated activity type. After an activity type
// has been undeprecated, you can create new tasks of that activity type.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. activityType.name: String constraint. The key is
//    swf:activityType.name. activityType.version: String constraint. The key
//    is swf:activityType.version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation UndeprecateActivityType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeTypeAlreadyExistsFault "TypeAlreadyExistsFault"
//   Returned if the type already exists in the specified domain. You may get
//   this fault if you are registering a type that is either already registered
//   or deprecated, or if you undeprecate a type that is currently registered.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) UndeprecateActivityType(input *UndeprecateActivityTypeInput) (*UndeprecateActivityTypeOutput, error) {
	req, out := c.UndeprecateActivityTypeRequest(input)
	return out, req.Send()
}

// UndeprecateActivityTypeWithContext is the same as UndeprecateActivityType with the addition of
// the ability to pass a context and additional request options.
//
// See UndeprecateActivityType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) UndeprecateActivityTypeWithContext(ctx aws.Context, input *UndeprecateActivityTypeInput, opts ...request.Option) (*UndeprecateActivityTypeOutput, error) {
	req, out := c.UndeprecateActivityTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUndeprecateDomain = "UndeprecateDomain"

// UndeprecateDomainRequest generates a "aws/request.Request" representing the
// client's request for the UndeprecateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UndeprecateDomain for more information on using the UndeprecateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UndeprecateDomainRequest method.
//    req, resp := client.UndeprecateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) UndeprecateDomainRequest(input *UndeprecateDomainInput) (req *request.Request, output *UndeprecateDomainOutput) {
	op := &request.Operation{
		Name:       opUndeprecateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UndeprecateDomainInput{}
	}

	output = &UndeprecateDomainOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UndeprecateDomain API operation for Amazon Simple Workflow Service.
//
// Undeprecates a previously deprecated domain. After a domain has been undeprecated
// it can be used to create new workflow executions or register new types.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation UndeprecateDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeDomainAlreadyExistsFault "DomainAlreadyExistsFault"
//   Returned if the domain already exists. You may get this fault if you are
//   registering a domain that is either already registered or deprecated, or
//   if you undeprecate a domain that is currently registered.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) UndeprecateDomain(input *UndeprecateDomainInput) (*UndeprecateDomainOutput, error) {
	req, out := c.UndeprecateDomainRequest(input)
	return out, req.Send()
}

// UndeprecateDomainWithContext is the same as UndeprecateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See UndeprecateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) UndeprecateDomainWithContext(ctx aws.Context, input *UndeprecateDomainInput, opts ...request.Option) (*UndeprecateDomainOutput, error) {
	req, out := c.UndeprecateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUndeprecateWorkflowType = "UndeprecateWorkflowType"

// UndeprecateWorkflowTypeRequest generates a "aws/request.Request" representing the
// client's request for the UndeprecateWorkflowType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UndeprecateWorkflowType for more information on using the UndeprecateWorkflowType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UndeprecateWorkflowTypeRequest method.
//    req, resp := client.UndeprecateWorkflowTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) UndeprecateWorkflowTypeRequest(input *UndeprecateWorkflowTypeInput) (req *request.Request, output *UndeprecateWorkflowTypeOutput) {
	op := &request.Operation{
		Name:       opUndeprecateWorkflowType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UndeprecateWorkflowTypeInput{}
	}

	output = &UndeprecateWorkflowTypeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UndeprecateWorkflowType API operation for Amazon Simple Workflow Service.
//
// Undeprecates a previously deprecated workflow type. After a workflow type
// has been undeprecated, you can create new executions of that type.
//
// This operation is eventually consistent. The results are best effort and
// may not exactly reflect recent updates and changes.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. workflowType.name: String constraint. The key is
//    swf:workflowType.name. workflowType.version: String constraint. The key
//    is swf:workflowType.version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation UndeprecateWorkflowType for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeTypeAlreadyExistsFault "TypeAlreadyExistsFault"
//   Returned if the type already exists in the specified domain. You may get
//   this fault if you are registering a type that is either already registered
//   or deprecated, or if you undeprecate a type that is currently registered.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) UndeprecateWorkflowType(input *UndeprecateWorkflowTypeInput) (*UndeprecateWorkflowTypeOutput, error) {
	req, out := c.UndeprecateWorkflowTypeRequest(input)
	return out, req.Send()
}

// UndeprecateWorkflowTypeWithContext is the same as UndeprecateWorkflowType with the addition of
// the ability to pass a context and additional request options.
//
// See UndeprecateWorkflowType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) UndeprecateWorkflowTypeWithContext(ctx aws.Context, input *UndeprecateWorkflowTypeInput, opts ...request.Option) (*UndeprecateWorkflowTypeOutput, error) {
	req, out := c.UndeprecateWorkflowTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SWF) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Simple Workflow Service.
//
// Remove a tag from a Amazon SWF domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Simple Workflow Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnknownResourceFault "UnknownResourceFault"
//   Returned when the named resource cannot be found with in the scope of this
//   operation (region or domain). This could happen if the named resource was
//   never created or is no longer available for this operation.
//
//   * ErrCodeLimitExceededFault "LimitExceededFault"
//   Returned by any operation if a system imposed limitation has been reached.
//   To address this fault you should either clean up unused resources or increase
//   the limit by contacting AWS.
//
//   * ErrCodeOperationNotPermittedFault "OperationNotPermittedFault"
//   Returned when the caller doesn't have sufficient permissions to invoke the
//   action.
//
func (c *SWF) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SWF) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Provides the details of the ActivityTaskCancelRequested event.
type ActivityTaskCancelRequestedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The unique ID of the task.
	//
	// ActivityId is a required field
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelActivityTask decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ActivityTaskCancelRequestedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTaskCancelRequestedEventAttributes) GoString() string {
	return s.String()
}

// SetActivityId sets the ActivityId field's value.
func (s *ActivityTaskCancelRequestedEventAttributes) SetActivityId(v string) *ActivityTaskCancelRequestedEventAttributes {
	s.ActivityId = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *ActivityTaskCancelRequestedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *ActivityTaskCancelRequestedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// Provides the details of the ActivityTaskCanceled event.
type ActivityTaskCanceledEventAttributes struct {
	_ struct{} `type:"structure"`

	// Details of the cancellation.
	Details *string `locationName:"details" type:"string"`

	// If set, contains the ID of the last ActivityTaskCancelRequested event recorded
	// for this activity task. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	LatestCancelRequestedEventId *int64 `locationName:"latestCancelRequestedEventId" type:"long"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the ActivityTaskStarted event recorded when this activity task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ActivityTaskCanceledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTaskCanceledEventAttributes) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *ActivityTaskCanceledEventAttributes) SetDetails(v string) *ActivityTaskCanceledEventAttributes {
	s.Details = &v
	return s
}

// SetLatestCancelRequestedEventId sets the LatestCancelRequestedEventId field's value.
func (s *ActivityTaskCanceledEventAttributes) SetLatestCancelRequestedEventId(v int64) *ActivityTaskCanceledEventAttributes {
	s.LatestCancelRequestedEventId = &v
	return s
}

// SetScheduledEventId sets the ScheduledEventId field's value.
func (s *ActivityTaskCanceledEventAttributes) SetScheduledEventId(v int64) *ActivityTaskCanceledEventAttributes {
	s.ScheduledEventId = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *ActivityTaskCanceledEventAttributes) SetStartedEventId(v int64) *ActivityTaskCanceledEventAttributes {
	s.StartedEventId = &v
	return s
}

// Provides the details of the ActivityTaskCompleted event.
type ActivityTaskCompletedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The results of the activity task.
	Result *string `locationName:"result" type:"string"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the ActivityTaskStarted event recorded when this activity task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ActivityTaskCompletedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTaskCompletedEventAttributes) GoString() string {
	return s.String()
}

// SetResult sets the Result field's value.
func (s *ActivityTaskCompletedEventAttributes) SetResult(v string) *ActivityTaskCompletedEventAttributes {
	s.Result = &v
	return s
}

// SetScheduledEventId sets the ScheduledEventId field's value.
func (s *ActivityTaskCompletedEventAttributes) SetScheduledEventId(v int64) *ActivityTaskCompletedEventAttributes {
	s.ScheduledEventId = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *ActivityTaskCompletedEventAttributes) SetStartedEventId(v int64) *ActivityTaskCompletedEventAttributes {
	s.StartedEventId = &v
	return s
}

// Provides the details of the ActivityTaskFailed event.
type ActivityTaskFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The details of the failure.
	Details *string `locationName:"details" type:"string"`

	// The reason provided for the failure.
	Reason *string `locationName:"reason" type:"string"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the ActivityTaskStarted event recorded when this activity task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ActivityTaskFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTaskFailedEventAttributes) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *ActivityTaskFailedEventAttributes) SetDetails(v string) *ActivityTaskFailedEventAttributes {
	s.Details = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ActivityTaskFailedEventAttributes) SetReason(v string) *ActivityTaskFailedEventAttributes {
	s.Reason = &v
	return s
}

// SetScheduledEventId sets the ScheduledEventId field's value.
func (s *ActivityTaskFailedEventAttributes) SetScheduledEventId(v int64) *ActivityTaskFailedEventAttributes {
	s.ScheduledEventId = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *ActivityTaskFailedEventAttributes) SetStartedEventId(v int64) *ActivityTaskFailedEventAttributes {
	s.StartedEventId = &v
	return s
}

// Provides the details of the ActivityTaskScheduled event.
type ActivityTaskScheduledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The unique ID of the activity task.
	//
	// ActivityId is a required field
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The type of the activity task.
	//
	// ActivityType is a required field
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// Data attached to the event that can be used by the decider in subsequent
	// workflow tasks. This data isn't sent to the activity.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision that
	// resulted in the scheduling of this activity task. This information can be
	// useful for diagnosing problems by tracing back the chain of events leading
	// up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The maximum time before which the worker processing this task must report
	// progress by calling RecordActivityTaskHeartbeat. If the timeout is exceeded,
	// the activity task is automatically timed out. If the worker subsequently
	// attempts to record a heartbeat or return a result, it is ignored.
	HeartbeatTimeout *string `locationName:"heartbeatTimeout" type:"string"`

	// The input provided to the activity task.
	Input *string `locationName:"input" type:"string"`

	// The maximum amount of time for this activity task.
	ScheduleToCloseTimeout *string `locationName:"scheduleToCloseTimeout" type:"string"`

	// The maximum amount of time the activity task can wait to be assigned to a
	// worker.
	ScheduleToStartTimeout *string `locationName:"scheduleToStartTimeout" type:"string"`

	// The maximum amount of time a worker may take to process the activity task.
	StartToCloseTimeout *string `locationName:"startToCloseTimeout" type:"string"`

	// The task list in which the activity task has been scheduled.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// The priority to assign to the scheduled activity task. If set, this overrides
	// any default priority value that was assigned when the activity type was registered.
	//
	// Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`
}

// String returns the string representation
func (s ActivityTaskScheduledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTaskScheduledEventAttributes) GoString() string {
	return s.String()
}

// SetActivityId sets the ActivityId field's value.
func (s *ActivityTaskScheduledEventAttributes) SetActivityId(v string) *ActivityTaskScheduledEventAttributes {
	s.ActivityId = &v
	return s
}

// SetActivityType sets the ActivityType field's value.
func (s *ActivityTaskScheduledEventAttributes) SetActivityType(v *ActivityType) *ActivityTaskScheduledEventAttributes {
	s.ActivityType = v
	return s
}

// SetControl sets the Control field's value.
func (s *ActivityTaskScheduledEventAttributes) SetControl(v string) *ActivityTaskScheduledEventAttributes {
	s.Control = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *ActivityTaskScheduledEventAttributes) SetDecisionTaskCompletedEventId(v int64) *ActivityTaskScheduledEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetHeartbeatTimeout sets the HeartbeatTimeout field's value.
func (s *ActivityTaskScheduledEventAttributes) SetHeartbeatTimeout(v string) *ActivityTaskScheduledEventAttributes {
	s.HeartbeatTimeout = &v
	return s
}

// SetInput sets the Input field's value.
func (s *ActivityTaskScheduledEventAttributes) SetInput(v string) *ActivityTaskScheduledEventAttributes {
	s.Input = &v
	return s
}

// SetScheduleToCloseTimeout sets the ScheduleToCloseTimeout field's value.
func (s *ActivityTaskScheduledEventAttributes) SetScheduleToCloseTimeout(v string) *ActivityTaskScheduledEventAttributes {
	s.ScheduleToCloseTimeout = &v
	return s
}

// SetScheduleToStartTimeout sets the ScheduleToStartTimeout field's value.
func (s *ActivityTaskScheduledEventAttributes) SetScheduleToStartTimeout(v string) *ActivityTaskScheduledEventAttributes {
	s.ScheduleToStartTimeout = &v
	return s
}

// SetStartToCloseTimeout sets the StartToCloseTimeout field's value.
func (s *ActivityTaskScheduledEventAttributes) SetStartToCloseTimeout(v string) *ActivityTaskScheduledEventAttributes {
	s.StartToCloseTimeout = &v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *ActivityTaskScheduledEventAttributes) SetTaskList(v *TaskList) *ActivityTaskScheduledEventAttributes {
	s.TaskList = v
	return s
}

// SetTaskPriority sets the TaskPriority field's value.
func (s *ActivityTaskScheduledEventAttributes) SetTaskPriority(v string) *ActivityTaskScheduledEventAttributes {
	s.TaskPriority = &v
	return s
}

// Provides the details of the ActivityTaskStarted event.
type ActivityTaskStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// Identity of the worker that was assigned this task. This aids diagnostics
	// when problems arise. The form of this identity is user defined.
	Identity *string `locationName:"identity" type:"string"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ActivityTaskStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTaskStartedEventAttributes) GoString() string {
	return s.String()
}

// SetIdentity sets the Identity field's value.
func (s *ActivityTaskStartedEventAttributes) SetIdentity(v string) *ActivityTaskStartedEventAttributes {
	s.Identity = &v
	return s
}

// SetScheduledEventId sets the ScheduledEventId field's value.
func (s *ActivityTaskStartedEventAttributes) SetScheduledEventId(v int64) *ActivityTaskStartedEventAttributes {
	s.ScheduledEventId = &v
	return s
}

// Provides the details of the ActivityTaskTimedOut event.
type ActivityTaskTimedOutEventAttributes struct {
	_ struct{} `type:"structure"`

	// Contains the content of the details parameter for the last call made by the
	// activity to RecordActivityTaskHeartbeat.
	Details *string `locationName:"details" type:"string"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the ActivityTaskStarted event recorded when this activity task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The type of the timeout that caused this event.
	//
	// TimeoutType is a required field
	TimeoutType *string `locationName:"timeoutType" type:"string" required:"true" enum:"ActivityTaskTimeoutType"`
}

// String returns the string representation
func (s ActivityTaskTimedOutEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTaskTimedOutEventAttributes) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *ActivityTaskTimedOutEventAttributes) SetDetails(v string) *ActivityTaskTimedOutEventAttributes {
	s.Details = &v
	return s
}

// SetScheduledEventId sets the ScheduledEventId field's value.
func (s *ActivityTaskTimedOutEventAttributes) SetScheduledEventId(v int64) *ActivityTaskTimedOutEventAttributes {
	s.ScheduledEventId = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *ActivityTaskTimedOutEventAttributes) SetStartedEventId(v int64) *ActivityTaskTimedOutEventAttributes {
	s.StartedEventId = &v
	return s
}

// SetTimeoutType sets the TimeoutType field's value.
func (s *ActivityTaskTimedOutEventAttributes) SetTimeoutType(v string) *ActivityTaskTimedOutEventAttributes {
	s.TimeoutType = &v
	return s
}

// Represents an activity type.
type ActivityType struct {
	_ struct{} `type:"structure"`

	// The name of this activity.
	//
	// The combination of activity type name and version must be unique within a
	// domain.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The version of this activity.
	//
	// The combination of activity type name and version must be unique with in
	// a domain.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ActivityType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivityType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivityType"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ActivityType) SetName(v string) *ActivityType {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ActivityType) SetVersion(v string) *ActivityType {
	s.Version = &v
	return s
}

// Configuration settings registered with the activity type.
type ActivityTypeConfiguration struct {
	_ struct{} `type:"structure"`

	// The default maximum time, in seconds, before which a worker processing a
	// task must report progress by calling RecordActivityTaskHeartbeat.
	//
	// You can specify this value only when registering an activity type. The registered
	// default value can be overridden when you schedule a task through the ScheduleActivityTask
	// Decision. If the activity worker subsequently attempts to record a heartbeat
	// or returns a result, the activity worker receives an UnknownResource fault.
	// In this case, Amazon SWF no longer considers the activity task to be valid;
	// the activity worker should clean up the activity task.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultTaskHeartbeatTimeout *string `locationName:"defaultTaskHeartbeatTimeout" type:"string"`

	// The default task list specified for this activity type at registration. This
	// default is used if a task list isn't provided when a task is scheduled through
	// the ScheduleActivityTask Decision. You can override the default registered
	// task list when scheduling a task through the ScheduleActivityTask Decision.
	DefaultTaskList *TaskList `locationName:"defaultTaskList" type:"structure"`

	// The default task priority for tasks of this activity type, specified at registration.
	// If not set, then 0 is used as the default priority. This default can be overridden
	// when scheduling an activity task.
	//
	// Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	DefaultTaskPriority *string `locationName:"defaultTaskPriority" type:"string"`

	// The default maximum duration, specified when registering the activity type,
	// for tasks of this activity type. You can override this default when scheduling
	// a task through the ScheduleActivityTask Decision.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultTaskScheduleToCloseTimeout *string `locationName:"defaultTaskScheduleToCloseTimeout" type:"string"`

	// The default maximum duration, specified when registering the activity type,
	// that a task of an activity type can wait before being assigned to a worker.
	// You can override this default when scheduling a task through the ScheduleActivityTask
	// Decision.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultTaskScheduleToStartTimeout *string `locationName:"defaultTaskScheduleToStartTimeout" type:"string"`

	// The default maximum duration for tasks of an activity type specified when
	// registering the activity type. You can override this default when scheduling
	// a task through the ScheduleActivityTask Decision.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultTaskStartToCloseTimeout *string `locationName:"defaultTaskStartToCloseTimeout" type:"string"`
}

// String returns the string representation
func (s ActivityTypeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTypeConfiguration) GoString() string {
	return s.String()
}

// SetDefaultTaskHeartbeatTimeout sets the DefaultTaskHeartbeatTimeout field's value.
func (s *ActivityTypeConfiguration) SetDefaultTaskHeartbeatTimeout(v string) *ActivityTypeConfiguration {
	s.DefaultTaskHeartbeatTimeout = &v
	return s
}

// SetDefaultTaskList sets the DefaultTaskList field's value.
func (s *ActivityTypeConfiguration) SetDefaultTaskList(v *TaskList) *ActivityTypeConfiguration {
	s.DefaultTaskList = v
	return s
}

// SetDefaultTaskPriority sets the DefaultTaskPriority field's value.
func (s *ActivityTypeConfiguration) SetDefaultTaskPriority(v string) *ActivityTypeConfiguration {
	s.DefaultTaskPriority = &v
	return s
}

// SetDefaultTaskScheduleToCloseTimeout sets the DefaultTaskScheduleToCloseTimeout field's value.
func (s *ActivityTypeConfiguration) SetDefaultTaskScheduleToCloseTimeout(v string) *ActivityTypeConfiguration {
	s.DefaultTaskScheduleToCloseTimeout = &v
	return s
}

// SetDefaultTaskScheduleToStartTimeout sets the DefaultTaskScheduleToStartTimeout field's value.
func (s *ActivityTypeConfiguration) SetDefaultTaskScheduleToStartTimeout(v string) *ActivityTypeConfiguration {
	s.DefaultTaskScheduleToStartTimeout = &v
	return s
}

// SetDefaultTaskStartToCloseTimeout sets the DefaultTaskStartToCloseTimeout field's value.
func (s *ActivityTypeConfiguration) SetDefaultTaskStartToCloseTimeout(v string) *ActivityTypeConfiguration {
	s.DefaultTaskStartToCloseTimeout = &v
	return s
}

// Detailed information about an activity type.
type ActivityTypeInfo struct {
	_ struct{} `type:"structure"`

	// The ActivityType type structure representing the activity type.
	//
	// ActivityType is a required field
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// The date and time this activity type was created through RegisterActivityType.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// If DEPRECATED, the date and time DeprecateActivityType was called.
	DeprecationDate *time.Time `locationName:"deprecationDate" type:"timestamp"`

	// The description of the activity type provided in RegisterActivityType.
	Description *string `locationName:"description" type:"string"`

	// The current status of the activity type.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"RegistrationStatus"`
}

// String returns the string representation
func (s ActivityTypeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivityTypeInfo) GoString() string {
	return s.String()
}

// SetActivityType sets the ActivityType field's value.
func (s *ActivityTypeInfo) SetActivityType(v *ActivityType) *ActivityTypeInfo {
	s.ActivityType = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ActivityTypeInfo) SetCreationDate(v time.Time) *ActivityTypeInfo {
	s.CreationDate = &v
	return s
}

// SetDeprecationDate sets the DeprecationDate field's value.
func (s *ActivityTypeInfo) SetDeprecationDate(v time.Time) *ActivityTypeInfo {
	s.DeprecationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ActivityTypeInfo) SetDescription(v string) *ActivityTypeInfo {
	s.Description = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ActivityTypeInfo) SetStatus(v string) *ActivityTypeInfo {
	s.Status = &v
	return s
}

// Provides the details of the CancelTimer decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type CancelTimerDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The unique ID of the timer to cancel.
	//
	// TimerId is a required field
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelTimerDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelTimerDecisionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelTimerDecisionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelTimerDecisionAttributes"}
	if s.TimerId == nil {
		invalidParams.Add(request.NewErrParamRequired("TimerId"))
	}
	if s.TimerId != nil && len(*s.TimerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTimerId sets the TimerId field's value.
func (s *CancelTimerDecisionAttributes) SetTimerId(v string) *CancelTimerDecisionAttributes {
	s.TimerId = &v
	return s
}

// Provides the details of the CancelTimerFailed event.
type CancelTimerFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"CancelTimerFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelTimer decision to cancel this timer. This information
	// can be useful for diagnosing problems by tracing back the chain of events
	// leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The timerId provided in the CancelTimer decision that failed.
	//
	// TimerId is a required field
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelTimerFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelTimerFailedEventAttributes) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *CancelTimerFailedEventAttributes) SetCause(v string) *CancelTimerFailedEventAttributes {
	s.Cause = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *CancelTimerFailedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *CancelTimerFailedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetTimerId sets the TimerId field's value.
func (s *CancelTimerFailedEventAttributes) SetTimerId(v string) *CancelTimerFailedEventAttributes {
	s.TimerId = &v
	return s
}

// Provides the details of the CancelWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type CancelWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// Details of the cancellation.
	Details *string `locationName:"details" type:"string"`
}

// String returns the string representation
func (s CancelWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelWorkflowExecutionDecisionAttributes) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *CancelWorkflowExecutionDecisionAttributes) SetDetails(v string) *CancelWorkflowExecutionDecisionAttributes {
	s.Details = &v
	return s
}

// Provides the details of the CancelWorkflowExecutionFailed event.
type CancelWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"CancelWorkflowExecutionFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelWorkflowExecution decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s CancelWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *CancelWorkflowExecutionFailedEventAttributes) SetCause(v string) *CancelWorkflowExecutionFailedEventAttributes {
	s.Cause = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *CancelWorkflowExecutionFailedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *CancelWorkflowExecutionFailedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// Provide details of the ChildWorkflowExecutionCanceled event.
type ChildWorkflowExecutionCanceledEventAttributes struct {
	_ struct{} `type:"structure"`

	// Details of the cancellation (if provided).
	Details *string `locationName:"details" type:"string"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution Decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The child workflow execution that was canceled.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionCanceledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChildWorkflowExecutionCanceledEventAttributes) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *ChildWorkflowExecutionCanceledEventAttributes) SetDetails(v string) *ChildWorkflowExecutionCanceledEventAttributes {
	s.Details = &v
	return s
}

// SetInitiatedEventId sets the InitiatedEventId field's value.
func (s *ChildWorkflowExecutionCanceledEventAttributes) SetInitiatedEventId(v int64) *ChildWorkflowExecutionCanceledEventAttributes {
	s.InitiatedEventId = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *ChildWorkflowExecutionCanceledEventAttributes) SetStartedEventId(v int64) *ChildWorkflowExecutionCanceledEventAttributes {
	s.StartedEventId = &v
	return s
}

// SetWorkflowExecution sets the WorkflowExecution field's value.
func (s *ChildWorkflowExecutionCanceledEventAttributes) SetWorkflowExecution(v *WorkflowExecution) *ChildWorkflowExecutionCanceledEventAttributes {
	s.WorkflowExecution = v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *ChildWorkflowExecutionCanceledEventAttributes) SetWorkflowType(v *WorkflowType) *ChildWorkflowExecutionCanceledEventAttributes {
	s.WorkflowType = v
	return s
}

// Provides the details of the ChildWorkflowExecutionCompleted event.
type ChildWorkflowExecutionCompletedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution Decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The result of the child workflow execution.
	Result *string `locationName:"result" type:"string"`

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The child workflow execution that was completed.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionCompletedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChildWorkflowExecutionCompletedEventAttributes) GoString() string {
	return s.String()
}

// SetInitiatedEventId sets the InitiatedEventId field's value.
func (s *ChildWorkflowExecutionCompletedEventAttributes) SetInitiatedEventId(v int64) *ChildWorkflowExecutionCompletedEventAttributes {
	s.InitiatedEventId = &v
	return s
}

// SetResult sets the Result field's value.
func (s *ChildWorkflowExecutionCompletedEventAttributes) SetResult(v string) *ChildWorkflowExecutionCompletedEventAttributes {
	s.Result = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *ChildWorkflowExecutionCompletedEventAttributes) SetStartedEventId(v int64) *ChildWorkflowExecutionCompletedEventAttributes {
	s.StartedEventId = &v
	return s
}

// SetWorkflowExecution sets the WorkflowExecution field's value.
func (s *ChildWorkflowExecutionCompletedEventAttributes) SetWorkflowExecution(v *WorkflowExecution) *ChildWorkflowExecutionCompletedEventAttributes {
	s.WorkflowExecution = v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *ChildWorkflowExecutionCompletedEventAttributes) SetWorkflowType(v *WorkflowType) *ChildWorkflowExecutionCompletedEventAttributes {
	s.WorkflowType = v
	return s
}

// Provides the details of the ChildWorkflowExecutionFailed event.
type ChildWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The details of the failure (if provided).
	Details *string `locationName:"details" type:"string"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution Decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The reason for the failure (if provided).
	Reason *string `locationName:"reason" type:"string"`

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The child workflow execution that failed.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChildWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *ChildWorkflowExecutionFailedEventAttributes) SetDetails(v string) *ChildWorkflowExecutionFailedEventAttributes {
	s.Details = &v
	return s
}

// SetInitiatedEventId sets the InitiatedEventId field's value.
func (s *ChildWorkflowExecutionFailedEventAttributes) SetInitiatedEventId(v int64) *ChildWorkflowExecutionFailedEventAttributes {
	s.InitiatedEventId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *ChildWorkflowExecutionFailedEventAttributes) SetReason(v string) *ChildWorkflowExecutionFailedEventAttributes {
	s.Reason = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *ChildWorkflowExecutionFailedEventAttributes) SetStartedEventId(v int64) *ChildWorkflowExecutionFailedEventAttributes {
	s.StartedEventId = &v
	return s
}

// SetWorkflowExecution sets the WorkflowExecution field's value.
func (s *ChildWorkflowExecutionFailedEventAttributes) SetWorkflowExecution(v *WorkflowExecution) *ChildWorkflowExecutionFailedEventAttributes {
	s.WorkflowExecution = v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *ChildWorkflowExecutionFailedEventAttributes) SetWorkflowType(v *WorkflowType) *ChildWorkflowExecutionFailedEventAttributes {
	s.WorkflowType = v
	return s
}

// Provides the details of the ChildWorkflowExecutionStarted event.
type ChildWorkflowExecutionStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution Decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The child workflow execution that was started.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChildWorkflowExecutionStartedEventAttributes) GoString() string {
	return s.String()
}

// SetInitiatedEventId sets the InitiatedEventId field's value.
func (s *ChildWorkflowExecutionStartedEventAttributes) SetInitiatedEventId(v int64) *ChildWorkflowExecutionStartedEventAttributes {
	s.InitiatedEventId = &v
	return s
}

// SetWorkflowExecution sets the WorkflowExecution field's value.
func (s *ChildWorkflowExecutionStartedEventAttributes) SetWorkflowExecution(v *WorkflowExecution) *ChildWorkflowExecutionStartedEventAttributes {
	s.WorkflowExecution = v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *ChildWorkflowExecutionStartedEventAttributes) SetWorkflowType(v *WorkflowType) *ChildWorkflowExecutionStartedEventAttributes {
	s.WorkflowType = v
	return s
}

// Provides the details of the ChildWorkflowExecutionTerminated event.
type ChildWorkflowExecutionTerminatedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution Decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The child workflow execution that was terminated.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionTerminatedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChildWorkflowExecutionTerminatedEventAttributes) GoString() string {
	return s.String()
}

// SetInitiatedEventId sets the InitiatedEventId field's value.
func (s *ChildWorkflowExecutionTerminatedEventAttributes) SetInitiatedEventId(v int64) *ChildWorkflowExecutionTerminatedEventAttributes {
	s.InitiatedEventId = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *ChildWorkflowExecutionTerminatedEventAttributes) SetStartedEventId(v int64) *ChildWorkflowExecutionTerminatedEventAttributes {
	s.StartedEventId = &v
	return s
}

// SetWorkflowExecution sets the WorkflowExecution field's value.
func (s *ChildWorkflowExecutionTerminatedEventAttributes) SetWorkflowExecution(v *WorkflowExecution) *ChildWorkflowExecutionTerminatedEventAttributes {
	s.WorkflowExecution = v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *ChildWorkflowExecutionTerminatedEventAttributes) SetWorkflowType(v *WorkflowType) *ChildWorkflowExecutionTerminatedEventAttributes {
	s.WorkflowType = v
	return s
}

// Provides the details of the ChildWorkflowExecutionTimedOut event.
type ChildWorkflowExecutionTimedOutEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution Decision to start this child workflow execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The type of the timeout that caused the child workflow execution to time
	// out.
	//
	// TimeoutType is a required field
	TimeoutType *string `locationName:"timeoutType" type:"string" required:"true" enum:"WorkflowExecutionTimeoutType"`

	// The child workflow execution that timed out.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the child workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s ChildWorkflowExecutionTimedOutEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChildWorkflowExecutionTimedOutEventAttributes) GoString() string {
	return s.String()
}

// SetInitiatedEventId sets the InitiatedEventId field's value.
func (s *ChildWorkflowExecutionTimedOutEventAttributes) SetInitiatedEventId(v int64) *ChildWorkflowExecutionTimedOutEventAttributes {
	s.InitiatedEventId = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *ChildWorkflowExecutionTimedOutEventAttributes) SetStartedEventId(v int64) *ChildWorkflowExecutionTimedOutEventAttributes {
	s.StartedEventId = &v
	return s
}

// SetTimeoutType sets the TimeoutType field's value.
func (s *ChildWorkflowExecutionTimedOutEventAttributes) SetTimeoutType(v string) *ChildWorkflowExecutionTimedOutEventAttributes {
	s.TimeoutType = &v
	return s
}

// SetWorkflowExecution sets the WorkflowExecution field's value.
func (s *ChildWorkflowExecutionTimedOutEventAttributes) SetWorkflowExecution(v *WorkflowExecution) *ChildWorkflowExecutionTimedOutEventAttributes {
	s.WorkflowExecution = v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *ChildWorkflowExecutionTimedOutEventAttributes) SetWorkflowType(v *WorkflowType) *ChildWorkflowExecutionTimedOutEventAttributes {
	s.WorkflowType = v
	return s
}

// Used to filter the closed workflow executions in visibility APIs by their
// close status.
type CloseStatusFilter struct {
	_ struct{} `type:"structure"`

	// The close status that must match the close status of an execution for it
	// to meet the criteria of this filter.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"CloseStatus"`
}

// String returns the string representation
func (s CloseStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloseStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloseStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloseStatusFilter"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatus sets the Status field's value.
func (s *CloseStatusFilter) SetStatus(v string) *CloseStatusFilter {
	s.Status = &v
	return s
}

// Provides the details of the CompleteWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type CompleteWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The result of the workflow execution. The form of the result is implementation
	// defined.
	Result *string `locationName:"result" type:"string"`
}

// String returns the string representation
func (s CompleteWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteWorkflowExecutionDecisionAttributes) GoString() string {
	return s.String()
}

// SetResult sets the Result field's value.
func (s *CompleteWorkflowExecutionDecisionAttributes) SetResult(v string) *CompleteWorkflowExecutionDecisionAttributes {
	s.Result = &v
	return s
}

// Provides the details of the CompleteWorkflowExecutionFailed event.
type CompleteWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"CompleteWorkflowExecutionFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CompleteWorkflowExecution decision to complete this
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s CompleteWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *CompleteWorkflowExecutionFailedEventAttributes) SetCause(v string) *CompleteWorkflowExecutionFailedEventAttributes {
	s.Cause = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *CompleteWorkflowExecutionFailedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *CompleteWorkflowExecutionFailedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// Provides the details of the ContinueAsNewWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. tag – A tag used to identify the workflow execution
//    taskList – String constraint. The key is swf:taskList.name. workflowType.version
//    – String constraint. The key is swf:workflowType.version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type ContinueAsNewWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// If set, specifies the policy to use for the child workflow executions of
	// the new execution if it is terminated by calling the TerminateWorkflowExecution
	// action explicitly or due to an expired timeout. This policy overrides the
	// default child policy specified when registering the workflow type using RegisterWorkflowType.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// A child policy for this workflow execution must be specified either as a
	// default for the workflow type or through this parameter. If neither this
	// parameter is set nor a default child policy was specified at registration
	// time then a fault is returned.
	ChildPolicy *string `locationName:"childPolicy" type:"string" enum:"ChildPolicy"`

	// If set, specifies the total duration for this workflow execution. This overrides
	// the defaultExecutionStartToCloseTimeout specified when registering the workflow
	// type.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// An execution start-to-close timeout for this workflow execution must be specified
	// either as a default for the workflow type or through this field. If neither
	// this field is set nor a default execution start-to-close timeout was specified
	// at registration time then a fault is returned.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The input provided to the new workflow execution.
	Input *string `locationName:"input" type:"string"`

	// The IAM role to attach to the new (continued) execution.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The list of tags to associate with the new workflow execution. A maximum
	// of 5 tags can be specified. You can list workflow executions with a specific
	// tag by calling ListOpenWorkflowExecutions or ListClosedWorkflowExecutions
	// and specifying a TagFilter.
	TagList []*string `locationName:"tagList" type:"list"`

	// The task list to use for the decisions of the new (continued) workflow execution.
	TaskList *TaskList `locationName:"taskList" type:"structure"`

	// The task priority that, if set, specifies the priority for the decision tasks
	// for this workflow execution. This overrides the defaultTaskPriority specified
	// when registering the workflow type. Valid values are integers that range
	// from Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647).
	// Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// Specifies the maximum duration of decision tasks for the new workflow execution.
	// This parameter overrides the defaultTaskStartToCloseTimout specified when
	// registering the workflow type using RegisterWorkflowType.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// A task start-to-close timeout for the new workflow execution must be specified
	// either as a default for the workflow type or through this parameter. If neither
	// this parameter is set nor a default task start-to-close timeout was specified
	// at registration time then a fault is returned.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// The version of the workflow to start.
	WorkflowTypeVersion *string `locationName:"workflowTypeVersion" min:"1" type:"string"`
}

// String returns the string representation
func (s ContinueAsNewWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinueAsNewWorkflowExecutionDecisionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContinueAsNewWorkflowExecutionDecisionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContinueAsNewWorkflowExecutionDecisionAttributes"}
	if s.LambdaRole != nil && len(*s.LambdaRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaRole", 1))
	}
	if s.WorkflowTypeVersion != nil && len(*s.WorkflowTypeVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowTypeVersion", 1))
	}
	if s.TaskList != nil {
		if err := s.TaskList.Validate(); err != nil {
			invalidParams.AddNested("TaskList", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildPolicy sets the ChildPolicy field's value.
func (s *ContinueAsNewWorkflowExecutionDecisionAttributes) SetChildPolicy(v string) *ContinueAsNewWorkflowExecutionDecisionAttributes {
	s.ChildPolicy = &v
	return s
}

// SetExecutionStartToCloseTimeout sets the ExecutionStartToCloseTimeout field's value.
func (s *ContinueAsNewWorkflowExecutionDecisionAttributes) SetExecutionStartToCloseTimeout(v string) *ContinueAsNewWorkflowExecutionDecisionAttributes {
	s.ExecutionStartToCloseTimeout = &v
	return s
}

// SetInput sets the Input field's value.
func (s *ContinueAsNewWorkflowExecutionDecisionAttributes) SetInput(v string) *ContinueAsNewWorkflowExecutionDecisionAttributes {
	s.Input = &v
	return s
}

// SetLambdaRole sets the LambdaRole field's value.
func (s *ContinueAsNewWorkflowExecutionDecisionAttributes) SetLambdaRole(v string) *ContinueAsNewWorkflowExecutionDecisionAttributes {
	s.LambdaRole = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *ContinueAsNewWorkflowExecutionDecisionAttributes) SetTagList(v []*string) *ContinueAsNewWorkflowExecutionDecisionAttributes {
	s.TagList = v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *ContinueAsNewWorkflowExecutionDecisionAttributes) SetTaskList(v *TaskList) *ContinueAsNewWorkflowExecutionDecisionAttributes {
	s.TaskList = v
	return s
}

// SetTaskPriority sets the TaskPriority field's value.
func (s *ContinueAsNewWorkflowExecutionDecisionAttributes) SetTaskPriority(v string) *ContinueAsNewWorkflowExecutionDecisionAttributes {
	s.TaskPriority = &v
	return s
}

// SetTaskStartToCloseTimeout sets the TaskStartToCloseTimeout field's value.
func (s *ContinueAsNewWorkflowExecutionDecisionAttributes) SetTaskStartToCloseTimeout(v string) *ContinueAsNewWorkflowExecutionDecisionAttributes {
	s.TaskStartToCloseTimeout = &v
	return s
}

// SetWorkflowTypeVersion sets the WorkflowTypeVersion field's value.
func (s *ContinueAsNewWorkflowExecutionDecisionAttributes) SetWorkflowTypeVersion(v string) *ContinueAsNewWorkflowExecutionDecisionAttributes {
	s.WorkflowTypeVersion = &v
	return s
}

// Provides the details of the ContinueAsNewWorkflowExecutionFailed event.
type ContinueAsNewWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"ContinueAsNewWorkflowExecutionFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the ContinueAsNewWorkflowExecution decision that started
	// this execution. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ContinueAsNewWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContinueAsNewWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *ContinueAsNewWorkflowExecutionFailedEventAttributes) SetCause(v string) *ContinueAsNewWorkflowExecutionFailedEventAttributes {
	s.Cause = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *ContinueAsNewWorkflowExecutionFailedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *ContinueAsNewWorkflowExecutionFailedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

type CountClosedWorkflowExecutionsInput struct {
	_ struct{} `type:"structure"`

	// If specified, only workflow executions that match this close status are counted.
	// This filter has an affect only if executionStatus is specified as CLOSED.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	CloseStatusFilter *CloseStatusFilter `locationName:"closeStatusFilter" type:"structure"`

	// If specified, only workflow executions that meet the close time criteria
	// of the filter are counted.
	//
	// startTimeFilter and closeTimeFilter are mutually exclusive. You must specify
	// one of these in a request but not both.
	CloseTimeFilter *ExecutionTimeFilter `locationName:"closeTimeFilter" type:"structure"`

	// The name of the domain containing the workflow executions to count.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// If specified, only workflow executions matching the WorkflowId in the filter
	// are counted.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	ExecutionFilter *WorkflowExecutionFilter `locationName:"executionFilter" type:"structure"`

	// If specified, only workflow executions that meet the start time criteria
	// of the filter are counted.
	//
	// startTimeFilter and closeTimeFilter are mutually exclusive. You must specify
	// one of these in a request but not both.
	StartTimeFilter *ExecutionTimeFilter `locationName:"startTimeFilter" type:"structure"`

	// If specified, only executions that have a tag that matches the filter are
	// counted.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	TagFilter *TagFilter `locationName:"tagFilter" type:"structure"`

	// If specified, indicates the type of the workflow executions to be counted.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	TypeFilter *WorkflowTypeFilter `locationName:"typeFilter" type:"structure"`
}

// String returns the string representation
func (s CountClosedWorkflowExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CountClosedWorkflowExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CountClosedWorkflowExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CountClosedWorkflowExecutionsInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.CloseStatusFilter != nil {
		if err := s.CloseStatusFilter.Validate(); err != nil {
			invalidParams.AddNested("CloseStatusFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.CloseTimeFilter != nil {
		if err := s.CloseTimeFilter.Validate(); err != nil {
			invalidParams.AddNested("CloseTimeFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.ExecutionFilter != nil {
		if err := s.ExecutionFilter.Validate(); err != nil {
			invalidParams.AddNested("ExecutionFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.StartTimeFilter != nil {
		if err := s.StartTimeFilter.Validate(); err != nil {
			invalidParams.AddNested("StartTimeFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.TagFilter != nil {
		if err := s.TagFilter.Validate(); err != nil {
			invalidParams.AddNested("TagFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.TypeFilter != nil {
		if err := s.TypeFilter.Validate(); err != nil {
			invalidParams.AddNested("TypeFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloseStatusFilter sets the CloseStatusFilter field's value.
func (s *CountClosedWorkflowExecutionsInput) SetCloseStatusFilter(v *CloseStatusFilter) *CountClosedWorkflowExecutionsInput {
	s.CloseStatusFilter = v
	return s
}

// SetCloseTimeFilter sets the CloseTimeFilter field's value.
func (s *CountClosedWorkflowExecutionsInput) SetCloseTimeFilter(v *ExecutionTimeFilter) *CountClosedWorkflowExecutionsInput {
	s.CloseTimeFilter = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CountClosedWorkflowExecutionsInput) SetDomain(v string) *CountClosedWorkflowExecutionsInput {
	s.Domain = &v
	return s
}

// SetExecutionFilter sets the ExecutionFilter field's value.
func (s *CountClosedWorkflowExecutionsInput) SetExecutionFilter(v *WorkflowExecutionFilter) *CountClosedWorkflowExecutionsInput {
	s.ExecutionFilter = v
	return s
}

// SetStartTimeFilter sets the StartTimeFilter field's value.
func (s *CountClosedWorkflowExecutionsInput) SetStartTimeFilter(v *ExecutionTimeFilter) *CountClosedWorkflowExecutionsInput {
	s.StartTimeFilter = v
	return s
}

// SetTagFilter sets the TagFilter field's value.
func (s *CountClosedWorkflowExecutionsInput) SetTagFilter(v *TagFilter) *CountClosedWorkflowExecutionsInput {
	s.TagFilter = v
	return s
}

// SetTypeFilter sets the TypeFilter field's value.
func (s *CountClosedWorkflowExecutionsInput) SetTypeFilter(v *WorkflowTypeFilter) *CountClosedWorkflowExecutionsInput {
	s.TypeFilter = v
	return s
}

type CountOpenWorkflowExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the workflow executions to count.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// If specified, only workflow executions matching the WorkflowId in the filter
	// are counted.
	//
	// executionFilter, typeFilter and tagFilter are mutually exclusive. You can
	// specify at most one of these in a request.
	ExecutionFilter *WorkflowExecutionFilter `locationName:"executionFilter" type:"structure"`

	// Specifies the start time criteria that workflow executions must meet in order
	// to be counted.
	//
	// StartTimeFilter is a required field
	StartTimeFilter *ExecutionTimeFilter `locationName:"startTimeFilter" type:"structure" required:"true"`

	// If specified, only executions that have a tag that matches the filter are
	// counted.
	//
	// executionFilter, typeFilter and tagFilter are mutually exclusive. You can
	// specify at most one of these in a request.
	TagFilter *TagFilter `locationName:"tagFilter" type:"structure"`

	// Specifies the type of the workflow executions to be counted.
	//
	// executionFilter, typeFilter and tagFilter are mutually exclusive. You can
	// specify at most one of these in a request.
	TypeFilter *WorkflowTypeFilter `locationName:"typeFilter" type:"structure"`
}

// String returns the string representation
func (s CountOpenWorkflowExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CountOpenWorkflowExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CountOpenWorkflowExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CountOpenWorkflowExecutionsInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.StartTimeFilter == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTimeFilter"))
	}
	if s.ExecutionFilter != nil {
		if err := s.ExecutionFilter.Validate(); err != nil {
			invalidParams.AddNested("ExecutionFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.StartTimeFilter != nil {
		if err := s.StartTimeFilter.Validate(); err != nil {
			invalidParams.AddNested("StartTimeFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.TagFilter != nil {
		if err := s.TagFilter.Validate(); err != nil {
			invalidParams.AddNested("TagFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.TypeFilter != nil {
		if err := s.TypeFilter.Validate(); err != nil {
			invalidParams.AddNested("TypeFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *CountOpenWorkflowExecutionsInput) SetDomain(v string) *CountOpenWorkflowExecutionsInput {
	s.Domain = &v
	return s
}

// SetExecutionFilter sets the ExecutionFilter field's value.
func (s *CountOpenWorkflowExecutionsInput) SetExecutionFilter(v *WorkflowExecutionFilter) *CountOpenWorkflowExecutionsInput {
	s.ExecutionFilter = v
	return s
}

// SetStartTimeFilter sets the StartTimeFilter field's value.
func (s *CountOpenWorkflowExecutionsInput) SetStartTimeFilter(v *ExecutionTimeFilter) *CountOpenWorkflowExecutionsInput {
	s.StartTimeFilter = v
	return s
}

// SetTagFilter sets the TagFilter field's value.
func (s *CountOpenWorkflowExecutionsInput) SetTagFilter(v *TagFilter) *CountOpenWorkflowExecutionsInput {
	s.TagFilter = v
	return s
}

// SetTypeFilter sets the TypeFilter field's value.
func (s *CountOpenWorkflowExecutionsInput) SetTypeFilter(v *WorkflowTypeFilter) *CountOpenWorkflowExecutionsInput {
	s.TypeFilter = v
	return s
}

type CountPendingActivityTasksInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the task list.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The name of the task list.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`
}

// String returns the string representation
func (s CountPendingActivityTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CountPendingActivityTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CountPendingActivityTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CountPendingActivityTasksInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.TaskList == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskList"))
	}
	if s.TaskList != nil {
		if err := s.TaskList.Validate(); err != nil {
			invalidParams.AddNested("TaskList", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *CountPendingActivityTasksInput) SetDomain(v string) *CountPendingActivityTasksInput {
	s.Domain = &v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *CountPendingActivityTasksInput) SetTaskList(v *TaskList) *CountPendingActivityTasksInput {
	s.TaskList = v
	return s
}

type CountPendingDecisionTasksInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the task list.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The name of the task list.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`
}

// String returns the string representation
func (s CountPendingDecisionTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CountPendingDecisionTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CountPendingDecisionTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CountPendingDecisionTasksInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.TaskList == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskList"))
	}
	if s.TaskList != nil {
		if err := s.TaskList.Validate(); err != nil {
			invalidParams.AddNested("TaskList", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *CountPendingDecisionTasksInput) SetDomain(v string) *CountPendingDecisionTasksInput {
	s.Domain = &v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *CountPendingDecisionTasksInput) SetTaskList(v *TaskList) *CountPendingDecisionTasksInput {
	s.TaskList = v
	return s
}

// Specifies a decision made by the decider. A decision can be one of these
// types:
//
//    * CancelTimer – Cancels a previously started timer and records a TimerCanceled
//    event in the history.
//
//    * CancelWorkflowExecution – Closes the workflow execution and records
//    a WorkflowExecutionCanceled event in the history.
//
//    * CompleteWorkflowExecution – Closes the workflow execution and records
//    a WorkflowExecutionCompleted event in the history .
//
//    * ContinueAsNewWorkflowExecution – Closes the workflow execution and
//    starts a new workflow execution of the same type using the same workflow
//    ID and a unique run Id. A WorkflowExecutionContinuedAsNew event is recorded
//    in the history.
//
//    * FailWorkflowExecution – Closes the workflow execution and records
//    a WorkflowExecutionFailed event in the history.
//
//    * RecordMarker – Records a MarkerRecorded event in the history. Markers
//    can be used for adding custom information in the history for instance
//    to let deciders know that they don't need to look at the history beyond
//    the marker event.
//
//    * RequestCancelActivityTask – Attempts to cancel a previously scheduled
//    activity task. If the activity task was scheduled but has not been assigned
//    to a worker, then it is canceled. If the activity task was already assigned
//    to a worker, then the worker is informed that cancellation has been requested
//    in the response to RecordActivityTaskHeartbeat.
//
//    * RequestCancelExternalWorkflowExecution – Requests that a request be
//    made to cancel the specified external workflow execution and records a
//    RequestCancelExternalWorkflowExecutionInitiated event in the history.
//
//    * ScheduleActivityTask – Schedules an activity task.
//
//    * SignalExternalWorkflowExecution – Requests a signal to be delivered
//    to the specified external workflow execution and records a SignalExternalWorkflowExecutionInitiated
//    event in the history.
//
//    * StartChildWorkflowExecution – Requests that a child workflow execution
//    be started and records a StartChildWorkflowExecutionInitiated event in
//    the history. The child workflow execution is a separate workflow execution
//    with its own history.
//
//    * StartTimer – Starts a timer for this workflow execution and records
//    a TimerStarted event in the history. This timer fires after the specified
//    delay and record a TimerFired event.
//
// Access Control
//
// If you grant permission to use RespondDecisionTaskCompleted, you can use
// IAM policies to express permissions for the list of decisions returned by
// this action as if they were members of the API. Treating decisions as a pseudo
// API maintains a uniform conceptual model and helps keep policies readable.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// Decision Failure
//
// Decisions can fail for several reasons
//
//    * The ordering of decisions should follow a logical flow. Some decisions
//    might not make sense in the current context of the workflow execution
//    and therefore fails.
//
//    * A limit on your account was reached.
//
//    * The decision lacks sufficient permissions.
//
// One of the following events might be added to the history to indicate an
// error. The event attribute's cause parameter indicates the cause. If cause
// is set to OPERATION_NOT_PERMITTED, the decision failed because it lacked
// sufficient permissions. For details and example IAM policies, see Using IAM
// to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
//    * ScheduleActivityTaskFailed – A ScheduleActivityTask decision failed.
//    This could happen if the activity type specified in the decision isn't
//    registered, is in a deprecated state, or the decision isn't properly configured.
//
//    * RequestCancelActivityTaskFailed – A RequestCancelActivityTask decision
//    failed. This could happen if there is no open activity task with the specified
//    activityId.
//
//    * StartTimerFailed – A StartTimer decision failed. This could happen
//    if there is another open timer with the same timerId.
//
//    * CancelTimerFailed – A CancelTimer decision failed. This could happen
//    if there is no open timer with the specified timerId.
//
//    * StartChildWorkflowExecutionFailed – A StartChildWorkflowExecution
//    decision failed. This could happen if the workflow type specified isn't
//    registered, is deprecated, or the decision isn't properly configured.
//
//    * SignalExternalWorkflowExecutionFailed – A SignalExternalWorkflowExecution
//    decision failed. This could happen if the workflowID specified in the
//    decision was incorrect.
//
//    * RequestCancelExternalWorkflowExecutionFailed – A RequestCancelExternalWorkflowExecution
//    decision failed. This could happen if the workflowID specified in the
//    decision was incorrect.
//
//    * CancelWorkflowExecutionFailed – A CancelWorkflowExecution decision
//    failed. This could happen if there is an unhandled decision task pending
//    in the workflow execution.
//
//    * CompleteWorkflowExecutionFailed – A CompleteWorkflowExecution decision
//    failed. This could happen if there is an unhandled decision task pending
//    in the workflow execution.
//
//    * ContinueAsNewWorkflowExecutionFailed – A ContinueAsNewWorkflowExecution
//    decision failed. This could happen if there is an unhandled decision task
//    pending in the workflow execution or the ContinueAsNewWorkflowExecution
//    decision was not configured correctly.
//
//    * FailWorkflowExecutionFailed – A FailWorkflowExecution decision failed.
//    This could happen if there is an unhandled decision task pending in the
//    workflow execution.
//
// The preceding error events might occur due to an error in the decider logic,
// which might put the workflow execution in an unstable state The cause field
// in the event structure for the error event indicates the cause of the error.
//
// A workflow execution may be closed by the decider by returning one of the
// following decisions when completing a decision task: CompleteWorkflowExecution,
// FailWorkflowExecution, CancelWorkflowExecution and ContinueAsNewWorkflowExecution.
// An UnhandledDecision fault is returned if a workflow closing decision is
// specified and a signal or activity event had been added to the history while
// the decision task was being performed by the decider. Unlike the above situations
// which are logic issues, this fault is always possible because of race conditions
// in a distributed system. The right action here is to call RespondDecisionTaskCompleted
// without any decisions. This would result in another decision task with these
// new events included in the history. The decider should handle the new events
// and may decide to close the workflow execution.
//
// How to Code a Decision
//
// You code a decision by first setting the decision type field to one of the
// above decision values, and then set the corresponding attributes field shown
// below:
//
//    * ScheduleActivityTaskDecisionAttributes
//
//    * RequestCancelActivityTaskDecisionAttributes
//
//    * CompleteWorkflowExecutionDecisionAttributes
//
//    * FailWorkflowExecutionDecisionAttributes
//
//    * CancelWorkflowExecutionDecisionAttributes
//
//    * ContinueAsNewWorkflowExecutionDecisionAttributes
//
//    * RecordMarkerDecisionAttributes
//
//    * StartTimerDecisionAttributes
//
//    * CancelTimerDecisionAttributes
//
//    * SignalExternalWorkflowExecutionDecisionAttributes
//
//    * RequestCancelExternalWorkflowExecutionDecisionAttributes
//
//    * StartChildWorkflowExecutionDecisionAttributes
type Decision struct {
	_ struct{} `type:"structure"`

	// Provides the details of the CancelTimer decision. It isn't set for other
	// decision types.
	CancelTimerDecisionAttributes *CancelTimerDecisionAttributes `locationName:"cancelTimerDecisionAttributes" type:"structure"`

	// Provides the details of the CancelWorkflowExecution decision. It isn't set
	// for other decision types.
	CancelWorkflowExecutionDecisionAttributes *CancelWorkflowExecutionDecisionAttributes `locationName:"cancelWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides the details of the CompleteWorkflowExecution decision. It isn't
	// set for other decision types.
	CompleteWorkflowExecutionDecisionAttributes *CompleteWorkflowExecutionDecisionAttributes `locationName:"completeWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides the details of the ContinueAsNewWorkflowExecution decision. It isn't
	// set for other decision types.
	ContinueAsNewWorkflowExecutionDecisionAttributes *ContinueAsNewWorkflowExecutionDecisionAttributes `locationName:"continueAsNewWorkflowExecutionDecisionAttributes" type:"structure"`

	// Specifies the type of the decision.
	//
	// DecisionType is a required field
	DecisionType *string `locationName:"decisionType" type:"string" required:"true" enum:"DecisionType"`

	// Provides the details of the FailWorkflowExecution decision. It isn't set
	// for other decision types.
	FailWorkflowExecutionDecisionAttributes *FailWorkflowExecutionDecisionAttributes `locationName:"failWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides the details of the RecordMarker decision. It isn't set for other
	// decision types.
	RecordMarkerDecisionAttributes *RecordMarkerDecisionAttributes `locationName:"recordMarkerDecisionAttributes" type:"structure"`

	// Provides the details of the RequestCancelActivityTask decision. It isn't
	// set for other decision types.
	RequestCancelActivityTaskDecisionAttributes *RequestCancelActivityTaskDecisionAttributes `locationName:"requestCancelActivityTaskDecisionAttributes" type:"structure"`

	// Provides the details of the RequestCancelExternalWorkflowExecution decision.
	// It isn't set for other decision types.
	RequestCancelExternalWorkflowExecutionDecisionAttributes *RequestCancelExternalWorkflowExecutionDecisionAttributes `locationName:"requestCancelExternalWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides the details of the ScheduleActivityTask decision. It isn't set for
	// other decision types.
	ScheduleActivityTaskDecisionAttributes *ScheduleActivityTaskDecisionAttributes `locationName:"scheduleActivityTaskDecisionAttributes" type:"structure"`

	// Provides the details of the ScheduleLambdaFunction decision. It isn't set
	// for other decision types.
	ScheduleLambdaFunctionDecisionAttributes *ScheduleLambdaFunctionDecisionAttributes `locationName:"scheduleLambdaFunctionDecisionAttributes" type:"structure"`

	// Provides the details of the SignalExternalWorkflowExecution decision. It
	// isn't set for other decision types.
	SignalExternalWorkflowExecutionDecisionAttributes *SignalExternalWorkflowExecutionDecisionAttributes `locationName:"signalExternalWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides the details of the StartChildWorkflowExecution decision. It isn't
	// set for other decision types.
	StartChildWorkflowExecutionDecisionAttributes *StartChildWorkflowExecutionDecisionAttributes `locationName:"startChildWorkflowExecutionDecisionAttributes" type:"structure"`

	// Provides the details of the StartTimer decision. It isn't set for other decision
	// types.
	StartTimerDecisionAttributes *StartTimerDecisionAttributes `locationName:"startTimerDecisionAttributes" type:"structure"`
}

// String returns the string representation
func (s Decision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Decision) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Decision) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Decision"}
	if s.DecisionType == nil {
		invalidParams.Add(request.NewErrParamRequired("DecisionType"))
	}
	if s.CancelTimerDecisionAttributes != nil {
		if err := s.CancelTimerDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("CancelTimerDecisionAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.ContinueAsNewWorkflowExecutionDecisionAttributes != nil {
		if err := s.ContinueAsNewWorkflowExecutionDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("ContinueAsNewWorkflowExecutionDecisionAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.RecordMarkerDecisionAttributes != nil {
		if err := s.RecordMarkerDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("RecordMarkerDecisionAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.RequestCancelActivityTaskDecisionAttributes != nil {
		if err := s.RequestCancelActivityTaskDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("RequestCancelActivityTaskDecisionAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.RequestCancelExternalWorkflowExecutionDecisionAttributes != nil {
		if err := s.RequestCancelExternalWorkflowExecutionDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("RequestCancelExternalWorkflowExecutionDecisionAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.ScheduleActivityTaskDecisionAttributes != nil {
		if err := s.ScheduleActivityTaskDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("ScheduleActivityTaskDecisionAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.ScheduleLambdaFunctionDecisionAttributes != nil {
		if err := s.ScheduleLambdaFunctionDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("ScheduleLambdaFunctionDecisionAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.SignalExternalWorkflowExecutionDecisionAttributes != nil {
		if err := s.SignalExternalWorkflowExecutionDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("SignalExternalWorkflowExecutionDecisionAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.StartChildWorkflowExecutionDecisionAttributes != nil {
		if err := s.StartChildWorkflowExecutionDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("StartChildWorkflowExecutionDecisionAttributes", err.(request.ErrInvalidParams))
		}
	}
	if s.StartTimerDecisionAttributes != nil {
		if err := s.StartTimerDecisionAttributes.Validate(); err != nil {
			invalidParams.AddNested("StartTimerDecisionAttributes", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCancelTimerDecisionAttributes sets the CancelTimerDecisionAttributes field's value.
func (s *Decision) SetCancelTimerDecisionAttributes(v *CancelTimerDecisionAttributes) *Decision {
	s.CancelTimerDecisionAttributes = v
	return s
}

// SetCancelWorkflowExecutionDecisionAttributes sets the CancelWorkflowExecutionDecisionAttributes field's value.
func (s *Decision) SetCancelWorkflowExecutionDecisionAttributes(v *CancelWorkflowExecutionDecisionAttributes) *Decision {
	s.CancelWorkflowExecutionDecisionAttributes = v
	return s
}

// SetCompleteWorkflowExecutionDecisionAttributes sets the CompleteWorkflowExecutionDecisionAttributes field's value.
func (s *Decision) SetCompleteWorkflowExecutionDecisionAttributes(v *CompleteWorkflowExecutionDecisionAttributes) *Decision {
	s.CompleteWorkflowExecutionDecisionAttributes = v
	return s
}

// SetContinueAsNewWorkflowExecutionDecisionAttributes sets the ContinueAsNewWorkflowExecutionDecisionAttributes field's value.
func (s *Decision) SetContinueAsNewWorkflowExecutionDecisionAttributes(v *ContinueAsNewWorkflowExecutionDecisionAttributes) *Decision {
	s.ContinueAsNewWorkflowExecutionDecisionAttributes = v
	return s
}

// SetDecisionType sets the DecisionType field's value.
func (s *Decision) SetDecisionType(v string) *Decision {
	s.DecisionType = &v
	return s
}

// SetFailWorkflowExecutionDecisionAttributes sets the FailWorkflowExecutionDecisionAttributes field's value.
func (s *Decision) SetFailWorkflowExecutionDecisionAttributes(v *FailWorkflowExecutionDecisionAttributes) *Decision {
	s.FailWorkflowExecutionDecisionAttributes = v
	return s
}

// SetRecordMarkerDecisionAttributes sets the RecordMarkerDecisionAttributes field's value.
func (s *Decision) SetRecordMarkerDecisionAttributes(v *RecordMarkerDecisionAttributes) *Decision {
	s.RecordMarkerDecisionAttributes = v
	return s
}

// SetRequestCancelActivityTaskDecisionAttributes sets the RequestCancelActivityTaskDecisionAttributes field's value.
func (s *Decision) SetRequestCancelActivityTaskDecisionAttributes(v *RequestCancelActivityTaskDecisionAttributes) *Decision {
	s.RequestCancelActivityTaskDecisionAttributes = v
	return s
}

// SetRequestCancelExternalWorkflowExecutionDecisionAttributes sets the RequestCancelExternalWorkflowExecutionDecisionAttributes field's value.
func (s *Decision) SetRequestCancelExternalWorkflowExecutionDecisionAttributes(v *RequestCancelExternalWorkflowExecutionDecisionAttributes) *Decision {
	s.RequestCancelExternalWorkflowExecutionDecisionAttributes = v
	return s
}

// SetScheduleActivityTaskDecisionAttributes sets the ScheduleActivityTaskDecisionAttributes field's value.
func (s *Decision) SetScheduleActivityTaskDecisionAttributes(v *ScheduleActivityTaskDecisionAttributes) *Decision {
	s.ScheduleActivityTaskDecisionAttributes = v
	return s
}

// SetScheduleLambdaFunctionDecisionAttributes sets the ScheduleLambdaFunctionDecisionAttributes field's value.
func (s *Decision) SetScheduleLambdaFunctionDecisionAttributes(v *ScheduleLambdaFunctionDecisionAttributes) *Decision {
	s.ScheduleLambdaFunctionDecisionAttributes = v
	return s
}

// SetSignalExternalWorkflowExecutionDecisionAttributes sets the SignalExternalWorkflowExecutionDecisionAttributes field's value.
func (s *Decision) SetSignalExternalWorkflowExecutionDecisionAttributes(v *SignalExternalWorkflowExecutionDecisionAttributes) *Decision {
	s.SignalExternalWorkflowExecutionDecisionAttributes = v
	return s
}

// SetStartChildWorkflowExecutionDecisionAttributes sets the StartChildWorkflowExecutionDecisionAttributes field's value.
func (s *Decision) SetStartChildWorkflowExecutionDecisionAttributes(v *StartChildWorkflowExecutionDecisionAttributes) *Decision {
	s.StartChildWorkflowExecutionDecisionAttributes = v
	return s
}

// SetStartTimerDecisionAttributes sets the StartTimerDecisionAttributes field's value.
func (s *Decision) SetStartTimerDecisionAttributes(v *StartTimerDecisionAttributes) *Decision {
	s.StartTimerDecisionAttributes = v
	return s
}

// Provides the details of the DecisionTaskCompleted event.
type DecisionTaskCompletedEventAttributes struct {
	_ struct{} `type:"structure"`

	// User defined context for the workflow execution.
	ExecutionContext *string `locationName:"executionContext" type:"string"`

	// The ID of the DecisionTaskScheduled event that was recorded when this decision
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the DecisionTaskStarted event recorded when this decision task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s DecisionTaskCompletedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecisionTaskCompletedEventAttributes) GoString() string {
	return s.String()
}

// SetExecutionContext sets the ExecutionContext field's value.
func (s *DecisionTaskCompletedEventAttributes) SetExecutionContext(v string) *DecisionTaskCompletedEventAttributes {
	s.ExecutionContext = &v
	return s
}

// SetScheduledEventId sets the ScheduledEventId field's value.
func (s *DecisionTaskCompletedEventAttributes) SetScheduledEventId(v int64) *DecisionTaskCompletedEventAttributes {
	s.ScheduledEventId = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *DecisionTaskCompletedEventAttributes) SetStartedEventId(v int64) *DecisionTaskCompletedEventAttributes {
	s.StartedEventId = &v
	return s
}

// Provides details about the DecisionTaskScheduled event.
type DecisionTaskScheduledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The maximum duration for this decision task. The task is considered timed
	// out if it doesn't completed within this duration.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	StartToCloseTimeout *string `locationName:"startToCloseTimeout" type:"string"`

	// The name of the task list in which the decision task was scheduled.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// A task priority that, if set, specifies the priority for this decision task.
	// Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`
}

// String returns the string representation
func (s DecisionTaskScheduledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecisionTaskScheduledEventAttributes) GoString() string {
	return s.String()
}

// SetStartToCloseTimeout sets the StartToCloseTimeout field's value.
func (s *DecisionTaskScheduledEventAttributes) SetStartToCloseTimeout(v string) *DecisionTaskScheduledEventAttributes {
	s.StartToCloseTimeout = &v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *DecisionTaskScheduledEventAttributes) SetTaskList(v *TaskList) *DecisionTaskScheduledEventAttributes {
	s.TaskList = v
	return s
}

// SetTaskPriority sets the TaskPriority field's value.
func (s *DecisionTaskScheduledEventAttributes) SetTaskPriority(v string) *DecisionTaskScheduledEventAttributes {
	s.TaskPriority = &v
	return s
}

// Provides the details of the DecisionTaskStarted event.
type DecisionTaskStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// Identity of the decider making the request. This enables diagnostic tracing
	// when problems arise. The form of this identity is user defined.
	Identity *string `locationName:"identity" type:"string"`

	// The ID of the DecisionTaskScheduled event that was recorded when this decision
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s DecisionTaskStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecisionTaskStartedEventAttributes) GoString() string {
	return s.String()
}

// SetIdentity sets the Identity field's value.
func (s *DecisionTaskStartedEventAttributes) SetIdentity(v string) *DecisionTaskStartedEventAttributes {
	s.Identity = &v
	return s
}

// SetScheduledEventId sets the ScheduledEventId field's value.
func (s *DecisionTaskStartedEventAttributes) SetScheduledEventId(v int64) *DecisionTaskStartedEventAttributes {
	s.ScheduledEventId = &v
	return s
}

// Provides the details of the DecisionTaskTimedOut event.
type DecisionTaskTimedOutEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskScheduled event that was recorded when this decision
	// task was scheduled. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the DecisionTaskStarted event recorded when this decision task
	// was started. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The type of timeout that expired before the decision task could be completed.
	//
	// TimeoutType is a required field
	TimeoutType *string `locationName:"timeoutType" type:"string" required:"true" enum:"DecisionTaskTimeoutType"`
}

// String returns the string representation
func (s DecisionTaskTimedOutEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecisionTaskTimedOutEventAttributes) GoString() string {
	return s.String()
}

// SetScheduledEventId sets the ScheduledEventId field's value.
func (s *DecisionTaskTimedOutEventAttributes) SetScheduledEventId(v int64) *DecisionTaskTimedOutEventAttributes {
	s.ScheduledEventId = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *DecisionTaskTimedOutEventAttributes) SetStartedEventId(v int64) *DecisionTaskTimedOutEventAttributes {
	s.StartedEventId = &v
	return s
}

// SetTimeoutType sets the TimeoutType field's value.
func (s *DecisionTaskTimedOutEventAttributes) SetTimeoutType(v string) *DecisionTaskTimedOutEventAttributes {
	s.TimeoutType = &v
	return s
}

type DeprecateActivityTypeInput struct {
	_ struct{} `type:"structure"`

	// The activity type to deprecate.
	//
	// ActivityType is a required field
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// The name of the domain in which the activity type is registered.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeprecateActivityTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateActivityTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeprecateActivityTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeprecateActivityTypeInput"}
	if s.ActivityType == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivityType"))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.ActivityType != nil {
		if err := s.ActivityType.Validate(); err != nil {
			invalidParams.AddNested("ActivityType", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityType sets the ActivityType field's value.
func (s *DeprecateActivityTypeInput) SetActivityType(v *ActivityType) *DeprecateActivityTypeInput {
	s.ActivityType = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DeprecateActivityTypeInput) SetDomain(v string) *DeprecateActivityTypeInput {
	s.Domain = &v
	return s
}

type DeprecateActivityTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeprecateActivityTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateActivityTypeOutput) GoString() string {
	return s.String()
}

type DeprecateDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain to deprecate.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeprecateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeprecateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeprecateDomainInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeprecateDomainInput) SetName(v string) *DeprecateDomainInput {
	s.Name = &v
	return s
}

type DeprecateDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeprecateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateDomainOutput) GoString() string {
	return s.String()
}

type DeprecateWorkflowTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain in which the workflow type is registered.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The workflow type to deprecate.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeprecateWorkflowTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateWorkflowTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeprecateWorkflowTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeprecateWorkflowTypeInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.WorkflowType == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowType"))
	}
	if s.WorkflowType != nil {
		if err := s.WorkflowType.Validate(); err != nil {
			invalidParams.AddNested("WorkflowType", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DeprecateWorkflowTypeInput) SetDomain(v string) *DeprecateWorkflowTypeInput {
	s.Domain = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *DeprecateWorkflowTypeInput) SetWorkflowType(v *WorkflowType) *DeprecateWorkflowTypeInput {
	s.WorkflowType = v
	return s
}

type DeprecateWorkflowTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeprecateWorkflowTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateWorkflowTypeOutput) GoString() string {
	return s.String()
}

type DescribeActivityTypeInput struct {
	_ struct{} `type:"structure"`

	// The activity type to get information about. Activity types are identified
	// by the name and version that were supplied when the activity was registered.
	//
	// ActivityType is a required field
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// The name of the domain in which the activity type is registered.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeActivityTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivityTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeActivityTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeActivityTypeInput"}
	if s.ActivityType == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivityType"))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.ActivityType != nil {
		if err := s.ActivityType.Validate(); err != nil {
			invalidParams.AddNested("ActivityType", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityType sets the ActivityType field's value.
func (s *DescribeActivityTypeInput) SetActivityType(v *ActivityType) *DescribeActivityTypeInput {
	s.ActivityType = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DescribeActivityTypeInput) SetDomain(v string) *DescribeActivityTypeInput {
	s.Domain = &v
	return s
}

// Detailed information about an activity type.
type DescribeActivityTypeOutput struct {
	_ struct{} `type:"structure"`

	// The configuration settings registered with the activity type.
	//
	// Configuration is a required field
	Configuration *ActivityTypeConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// General information about the activity type.
	//
	// The status of activity type (returned in the ActivityTypeInfo structure)
	// can be one of the following.
	//
	//    * REGISTERED – The type is registered and available. Workers supporting
	//    this type should be running.
	//
	//    * DEPRECATED – The type was deprecated using DeprecateActivityType,
	//    but is still in use. You should keep workers supporting this type running.
	//    You cannot create new tasks of this type.
	//
	// TypeInfo is a required field
	TypeInfo *ActivityTypeInfo `locationName:"typeInfo" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeActivityTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActivityTypeOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *DescribeActivityTypeOutput) SetConfiguration(v *ActivityTypeConfiguration) *DescribeActivityTypeOutput {
	s.Configuration = v
	return s
}

// SetTypeInfo sets the TypeInfo field's value.
func (s *DescribeActivityTypeOutput) SetTypeInfo(v *ActivityTypeInfo) *DescribeActivityTypeOutput {
	s.TypeInfo = v
	return s
}

type DescribeDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain to describe.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeDomainInput) SetName(v string) *DescribeDomainInput {
	s.Name = &v
	return s
}

// Contains details of a domain.
type DescribeDomainOutput struct {
	_ struct{} `type:"structure"`

	// The domain configuration. Currently, this includes only the domain's retention
	// period.
	//
	// Configuration is a required field
	Configuration *DomainConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// The basic information about a domain, such as its name, status, and description.
	//
	// DomainInfo is a required field
	DomainInfo *DomainInfo `locationName:"domainInfo" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *DescribeDomainOutput) SetConfiguration(v *DomainConfiguration) *DescribeDomainOutput {
	s.Configuration = v
	return s
}

// SetDomainInfo sets the DomainInfo field's value.
func (s *DescribeDomainOutput) SetDomainInfo(v *DomainInfo) *DescribeDomainOutput {
	s.DomainInfo = v
	return s
}

type DescribeWorkflowExecutionInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the workflow execution.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The workflow execution to describe.
	//
	// Execution is a required field
	Execution *WorkflowExecution `locationName:"execution" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeWorkflowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkflowExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkflowExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkflowExecutionInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.Execution == nil {
		invalidParams.Add(request.NewErrParamRequired("Execution"))
	}
	if s.Execution != nil {
		if err := s.Execution.Validate(); err != nil {
			invalidParams.AddNested("Execution", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DescribeWorkflowExecutionInput) SetDomain(v string) *DescribeWorkflowExecutionInput {
	s.Domain = &v
	return s
}

// SetExecution sets the Execution field's value.
func (s *DescribeWorkflowExecutionInput) SetExecution(v *WorkflowExecution) *DescribeWorkflowExecutionInput {
	s.Execution = v
	return s
}

// Contains details about a workflow execution.
type DescribeWorkflowExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The configuration settings for this workflow execution including timeout
	// values, tasklist etc.
	//
	// ExecutionConfiguration is a required field
	ExecutionConfiguration *WorkflowExecutionConfiguration `locationName:"executionConfiguration" type:"structure" required:"true"`

	// Information about the workflow execution.
	//
	// ExecutionInfo is a required field
	ExecutionInfo *WorkflowExecutionInfo `locationName:"executionInfo" type:"structure" required:"true"`

	// The time when the last activity task was scheduled for this workflow execution.
	// You can use this information to determine if the workflow has not made progress
	// for an unusually long period of time and might require a corrective action.
	LatestActivityTaskTimestamp *time.Time `locationName:"latestActivityTaskTimestamp" type:"timestamp"`

	// The latest executionContext provided by the decider for this workflow execution.
	// A decider can provide an executionContext (a free-form string) when closing
	// a decision task using RespondDecisionTaskCompleted.
	LatestExecutionContext *string `locationName:"latestExecutionContext" type:"string"`

	// The number of tasks for this workflow execution. This includes open and closed
	// tasks of all types.
	//
	// OpenCounts is a required field
	OpenCounts *WorkflowExecutionOpenCounts `locationName:"openCounts" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeWorkflowExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkflowExecutionOutput) GoString() string {
	return s.String()
}

// SetExecutionConfiguration sets the ExecutionConfiguration field's value.
func (s *DescribeWorkflowExecutionOutput) SetExecutionConfiguration(v *WorkflowExecutionConfiguration) *DescribeWorkflowExecutionOutput {
	s.ExecutionConfiguration = v
	return s
}

// SetExecutionInfo sets the ExecutionInfo field's value.
func (s *DescribeWorkflowExecutionOutput) SetExecutionInfo(v *WorkflowExecutionInfo) *DescribeWorkflowExecutionOutput {
	s.ExecutionInfo = v
	return s
}

// SetLatestActivityTaskTimestamp sets the LatestActivityTaskTimestamp field's value.
func (s *DescribeWorkflowExecutionOutput) SetLatestActivityTaskTimestamp(v time.Time) *DescribeWorkflowExecutionOutput {
	s.LatestActivityTaskTimestamp = &v
	return s
}

// SetLatestExecutionContext sets the LatestExecutionContext field's value.
func (s *DescribeWorkflowExecutionOutput) SetLatestExecutionContext(v string) *DescribeWorkflowExecutionOutput {
	s.LatestExecutionContext = &v
	return s
}

// SetOpenCounts sets the OpenCounts field's value.
func (s *DescribeWorkflowExecutionOutput) SetOpenCounts(v *WorkflowExecutionOpenCounts) *DescribeWorkflowExecutionOutput {
	s.OpenCounts = v
	return s
}

type DescribeWorkflowTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain in which this workflow type is registered.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The workflow type to describe.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeWorkflowTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkflowTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkflowTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkflowTypeInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.WorkflowType == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowType"))
	}
	if s.WorkflowType != nil {
		if err := s.WorkflowType.Validate(); err != nil {
			invalidParams.AddNested("WorkflowType", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DescribeWorkflowTypeInput) SetDomain(v string) *DescribeWorkflowTypeInput {
	s.Domain = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *DescribeWorkflowTypeInput) SetWorkflowType(v *WorkflowType) *DescribeWorkflowTypeInput {
	s.WorkflowType = v
	return s
}

// Contains details about a workflow type.
type DescribeWorkflowTypeOutput struct {
	_ struct{} `type:"structure"`

	// Configuration settings of the workflow type registered through RegisterWorkflowType
	//
	// Configuration is a required field
	Configuration *WorkflowTypeConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// General information about the workflow type.
	//
	// The status of the workflow type (returned in the WorkflowTypeInfo structure)
	// can be one of the following.
	//
	//    * REGISTERED – The type is registered and available. Workers supporting
	//    this type should be running.
	//
	//    * DEPRECATED – The type was deprecated using DeprecateWorkflowType,
	//    but is still in use. You should keep workers supporting this type running.
	//    You cannot create new workflow executions of this type.
	//
	// TypeInfo is a required field
	TypeInfo *WorkflowTypeInfo `locationName:"typeInfo" type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeWorkflowTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkflowTypeOutput) GoString() string {
	return s.String()
}

// SetConfiguration sets the Configuration field's value.
func (s *DescribeWorkflowTypeOutput) SetConfiguration(v *WorkflowTypeConfiguration) *DescribeWorkflowTypeOutput {
	s.Configuration = v
	return s
}

// SetTypeInfo sets the TypeInfo field's value.
func (s *DescribeWorkflowTypeOutput) SetTypeInfo(v *WorkflowTypeInfo) *DescribeWorkflowTypeOutput {
	s.TypeInfo = v
	return s
}

// Contains the configuration settings of a domain.
type DomainConfiguration struct {
	_ struct{} `type:"structure"`

	// The retention period for workflow executions in this domain.
	//
	// WorkflowExecutionRetentionPeriodInDays is a required field
	WorkflowExecutionRetentionPeriodInDays *string `locationName:"workflowExecutionRetentionPeriodInDays" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DomainConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainConfiguration) GoString() string {
	return s.String()
}

// SetWorkflowExecutionRetentionPeriodInDays sets the WorkflowExecutionRetentionPeriodInDays field's value.
func (s *DomainConfiguration) SetWorkflowExecutionRetentionPeriodInDays(v string) *DomainConfiguration {
	s.WorkflowExecutionRetentionPeriodInDays = &v
	return s
}

// Contains general information about a domain.
type DomainInfo struct {
	_ struct{} `type:"structure"`

	// The ARN of the domain.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The description of the domain provided through RegisterDomain.
	Description *string `locationName:"description" type:"string"`

	// The name of the domain. This name is unique within the account.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of the domain:
	//
	//    * REGISTERED – The domain is properly registered and available. You
	//    can use this domain for registering types and creating new workflow executions.
	//
	//    * DEPRECATED – The domain was deprecated using DeprecateDomain, but
	//    is still in use. You should not create new workflow executions in this
	//    domain.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"RegistrationStatus"`
}

// String returns the string representation
func (s DomainInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainInfo) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DomainInfo) SetArn(v string) *DomainInfo {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DomainInfo) SetDescription(v string) *DomainInfo {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *DomainInfo) SetName(v string) *DomainInfo {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainInfo) SetStatus(v string) *DomainInfo {
	s.Status = &v
	return s
}

// Used to filter the workflow executions in visibility APIs by various time-based
// rules. Each parameter, if specified, defines a rule that must be satisfied
// by each returned query result. The parameter values are in the Unix Time
// format (https://en.wikipedia.org/wiki/Unix_time). For example: "oldestDate":
// 1325376070.
type ExecutionTimeFilter struct {
	_ struct{} `type:"structure"`

	// Specifies the latest start or close date and time to return.
	LatestDate *time.Time `locationName:"latestDate" type:"timestamp"`

	// Specifies the oldest start or close date and time to return.
	//
	// OldestDate is a required field
	OldestDate *time.Time `locationName:"oldestDate" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s ExecutionTimeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionTimeFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecutionTimeFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecutionTimeFilter"}
	if s.OldestDate == nil {
		invalidParams.Add(request.NewErrParamRequired("OldestDate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLatestDate sets the LatestDate field's value.
func (s *ExecutionTimeFilter) SetLatestDate(v time.Time) *ExecutionTimeFilter {
	s.LatestDate = &v
	return s
}

// SetOldestDate sets the OldestDate field's value.
func (s *ExecutionTimeFilter) SetOldestDate(v time.Time) *ExecutionTimeFilter {
	s.OldestDate = &v
	return s
}

// Provides the details of the ExternalWorkflowExecutionCancelRequested event.
type ExternalWorkflowExecutionCancelRequestedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the RequestCancelExternalWorkflowExecutionInitiated event corresponding
	// to the RequestCancelExternalWorkflowExecution decision to cancel this external
	// workflow execution. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The external workflow execution to which the cancellation request was delivered.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`
}

// String returns the string representation
func (s ExternalWorkflowExecutionCancelRequestedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExternalWorkflowExecutionCancelRequestedEventAttributes) GoString() string {
	return s.String()
}

// SetInitiatedEventId sets the InitiatedEventId field's value.
func (s *ExternalWorkflowExecutionCancelRequestedEventAttributes) SetInitiatedEventId(v int64) *ExternalWorkflowExecutionCancelRequestedEventAttributes {
	s.InitiatedEventId = &v
	return s
}

// SetWorkflowExecution sets the WorkflowExecution field's value.
func (s *ExternalWorkflowExecutionCancelRequestedEventAttributes) SetWorkflowExecution(v *WorkflowExecution) *ExternalWorkflowExecutionCancelRequestedEventAttributes {
	s.WorkflowExecution = v
	return s
}

// Provides the details of the ExternalWorkflowExecutionSignaled event.
type ExternalWorkflowExecutionSignaledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the SignalExternalWorkflowExecutionInitiated event corresponding
	// to the SignalExternalWorkflowExecution decision to request this signal. This
	// information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The external workflow execution that the signal was delivered to.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`
}

// String returns the string representation
func (s ExternalWorkflowExecutionSignaledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExternalWorkflowExecutionSignaledEventAttributes) GoString() string {
	return s.String()
}

// SetInitiatedEventId sets the InitiatedEventId field's value.
func (s *ExternalWorkflowExecutionSignaledEventAttributes) SetInitiatedEventId(v int64) *ExternalWorkflowExecutionSignaledEventAttributes {
	s.InitiatedEventId = &v
	return s
}

// SetWorkflowExecution sets the WorkflowExecution field's value.
func (s *ExternalWorkflowExecutionSignaledEventAttributes) SetWorkflowExecution(v *WorkflowExecution) *ExternalWorkflowExecutionSignaledEventAttributes {
	s.WorkflowExecution = v
	return s
}

// Provides the details of the FailWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type FailWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// Details of the failure.
	Details *string `locationName:"details" type:"string"`

	// A descriptive reason for the failure that may help in diagnostics.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation
func (s FailWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailWorkflowExecutionDecisionAttributes) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *FailWorkflowExecutionDecisionAttributes) SetDetails(v string) *FailWorkflowExecutionDecisionAttributes {
	s.Details = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *FailWorkflowExecutionDecisionAttributes) SetReason(v string) *FailWorkflowExecutionDecisionAttributes {
	s.Reason = &v
	return s
}

// Provides the details of the FailWorkflowExecutionFailed event.
type FailWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"FailWorkflowExecutionFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the FailWorkflowExecution decision to fail this execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s FailWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *FailWorkflowExecutionFailedEventAttributes) SetCause(v string) *FailWorkflowExecutionFailedEventAttributes {
	s.Cause = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *FailWorkflowExecutionFailedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *FailWorkflowExecutionFailedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

type GetWorkflowExecutionHistoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the workflow execution.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// Specifies the workflow execution for which to return the history.
	//
	// Execution is a required field
	Execution *WorkflowExecution `locationName:"execution" type:"structure" required:"true"`

	// The maximum number of results that are returned per call. Use nextPageToken
	// to obtain further pages of results.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If NextPageToken is returned there are more results available. The value
	// of NextPageToken is a unique pagination token for each page. Make the call
	// again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged. Each pagination token expires after 60 seconds. Using
	// an expired pagination token will return a 400 error: "Specified token has
	// exceeded its maximum lifetime".
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// When set to true, returns the events in reverse order. By default the results
	// are returned in ascending order of the eventTimeStamp of the events.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`
}

// String returns the string representation
func (s GetWorkflowExecutionHistoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWorkflowExecutionHistoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkflowExecutionHistoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkflowExecutionHistoryInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.Execution == nil {
		invalidParams.Add(request.NewErrParamRequired("Execution"))
	}
	if s.Execution != nil {
		if err := s.Execution.Validate(); err != nil {
			invalidParams.AddNested("Execution", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *GetWorkflowExecutionHistoryInput) SetDomain(v string) *GetWorkflowExecutionHistoryInput {
	s.Domain = &v
	return s
}

// SetExecution sets the Execution field's value.
func (s *GetWorkflowExecutionHistoryInput) SetExecution(v *WorkflowExecution) *GetWorkflowExecutionHistoryInput {
	s.Execution = v
	return s
}

// SetMaximumPageSize sets the MaximumPageSize field's value.
func (s *GetWorkflowExecutionHistoryInput) SetMaximumPageSize(v int64) *GetWorkflowExecutionHistoryInput {
	s.MaximumPageSize = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetWorkflowExecutionHistoryInput) SetNextPageToken(v string) *GetWorkflowExecutionHistoryInput {
	s.NextPageToken = &v
	return s
}

// SetReverseOrder sets the ReverseOrder field's value.
func (s *GetWorkflowExecutionHistoryInput) SetReverseOrder(v bool) *GetWorkflowExecutionHistoryInput {
	s.ReverseOrder = &v
	return s
}

// Paginated representation of a workflow history for a workflow execution.
// This is the up to date, complete and authoritative record of the events related
// to all tasks and events in the life of the workflow execution.
type GetWorkflowExecutionHistoryOutput struct {
	_ struct{} `type:"structure"`

	// The list of history events.
	//
	// Events is a required field
	Events []*HistoryEvent `locationName:"events" type:"list" required:"true"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s GetWorkflowExecutionHistoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWorkflowExecutionHistoryOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *GetWorkflowExecutionHistoryOutput) SetEvents(v []*HistoryEvent) *GetWorkflowExecutionHistoryOutput {
	s.Events = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *GetWorkflowExecutionHistoryOutput) SetNextPageToken(v string) *GetWorkflowExecutionHistoryOutput {
	s.NextPageToken = &v
	return s
}

// Event within a workflow execution. A history event can be one of these types:
//
//    * ActivityTaskCancelRequested – A RequestCancelActivityTask decision
//    was received by the system.
//
//    * ActivityTaskCanceled – The activity task was successfully canceled.
//
//    * ActivityTaskCompleted – An activity worker successfully completed
//    an activity task by calling RespondActivityTaskCompleted.
//
//    * ActivityTaskFailed – An activity worker failed an activity task by
//    calling RespondActivityTaskFailed.
//
//    * ActivityTaskScheduled – An activity task was scheduled for execution.
//
//    * ActivityTaskStarted – The scheduled activity task was dispatched to
//    a worker.
//
//    * ActivityTaskTimedOut – The activity task timed out.
//
//    * CancelTimerFailed – Failed to process CancelTimer decision. This happens
//    when the decision isn't configured properly, for example no timer exists
//    with the specified timer Id.
//
//    * CancelWorkflowExecutionFailed – A request to cancel a workflow execution
//    failed.
//
//    * ChildWorkflowExecutionCanceled – A child workflow execution, started
//    by this workflow execution, was canceled and closed.
//
//    * ChildWorkflowExecutionCompleted – A child workflow execution, started
//    by this workflow execution, completed successfully and was closed.
//
//    * ChildWorkflowExecutionFailed – A child workflow execution, started
//    by this workflow execution, failed to complete successfully and was closed.
//
//    * ChildWorkflowExecutionStarted – A child workflow execution was successfully
//    started.
//
//    * ChildWorkflowExecutionTerminated – A child workflow execution, started
//    by this workflow execution, was terminated.
//
//    * ChildWorkflowExecutionTimedOut – A child workflow execution, started
//    by this workflow execution, timed out and was closed.
//
//    * CompleteWorkflowExecutionFailed – The workflow execution failed to
//    complete.
//
//    * ContinueAsNewWorkflowExecutionFailed – The workflow execution failed
//    to complete after being continued as a new workflow execution.
//
//    * DecisionTaskCompleted – The decider successfully completed a decision
//    task by calling RespondDecisionTaskCompleted.
//
//    * DecisionTaskScheduled – A decision task was scheduled for the workflow
//    execution.
//
//    * DecisionTaskStarted – The decision task was dispatched to a decider.
//
//    * DecisionTaskTimedOut – The decision task timed out.
//
//    * ExternalWorkflowExecutionCancelRequested – Request to cancel an external
//    workflow execution was successfully delivered to the target execution.
//
//    * ExternalWorkflowExecutionSignaled – A signal, requested by this workflow
//    execution, was successfully delivered to the target external workflow
//    execution.
//
//    * FailWorkflowExecutionFailed – A request to mark a workflow execution
//    as failed, itself failed.
//
//    * MarkerRecorded – A marker was recorded in the workflow history as
//    the result of a RecordMarker decision.
//
//    * RecordMarkerFailed – A RecordMarker decision was returned as failed.
//
//    * RequestCancelActivityTaskFailed – Failed to process RequestCancelActivityTask
//    decision. This happens when the decision isn't configured properly.
//
//    * RequestCancelExternalWorkflowExecutionFailed – Request to cancel an
//    external workflow execution failed.
//
//    * RequestCancelExternalWorkflowExecutionInitiated – A request was made
//    to request the cancellation of an external workflow execution.
//
//    * ScheduleActivityTaskFailed – Failed to process ScheduleActivityTask
//    decision. This happens when the decision isn't configured properly, for
//    example the activity type specified isn't registered.
//
//    * SignalExternalWorkflowExecutionFailed – The request to signal an external
//    workflow execution failed.
//
//    * SignalExternalWorkflowExecutionInitiated – A request to signal an
//    external workflow was made.
//
//    * StartActivityTaskFailed – A scheduled activity task failed to start.
//
//    * StartChildWorkflowExecutionFailed – Failed to process StartChildWorkflowExecution
//    decision. This happens when the decision isn't configured properly, for
//    example the workflow type specified isn't registered.
//
//    * StartChildWorkflowExecutionInitiated – A request was made to start
//    a child workflow execution.
//
//    * StartTimerFailed – Failed to process StartTimer decision. This happens
//    when the decision isn't configured properly, for example a timer already
//    exists with the specified timer Id.
//
//    * TimerCanceled – A timer, previously started for this workflow execution,
//    was successfully canceled.
//
//    * TimerFired – A timer, previously started for this workflow execution,
//    fired.
//
//    * TimerStarted – A timer was started for the workflow execution due
//    to a StartTimer decision.
//
//    * WorkflowExecutionCancelRequested – A request to cancel this workflow
//    execution was made.
//
//    * WorkflowExecutionCanceled – The workflow execution was successfully
//    canceled and closed.
//
//    * WorkflowExecutionCompleted – The workflow execution was closed due
//    to successful completion.
//
//    * WorkflowExecutionContinuedAsNew – The workflow execution was closed
//    and a new execution of the same type was created with the same workflowId.
//
//    * WorkflowExecutionFailed – The workflow execution closed due to a failure.
//
//    * WorkflowExecutionSignaled – An external signal was received for the
//    workflow execution.
//
//    * WorkflowExecutionStarted – The workflow execution was started.
//
//    * WorkflowExecutionTerminated – The workflow execution was terminated.
//
//    * WorkflowExecutionTimedOut – The workflow execution was closed because
//    a time out was exceeded.
type HistoryEvent struct {
	_ struct{} `type:"structure"`

	// If the event is of type ActivityTaskcancelRequested then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	ActivityTaskCancelRequestedEventAttributes *ActivityTaskCancelRequestedEventAttributes `locationName:"activityTaskCancelRequestedEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskCanceled then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	ActivityTaskCanceledEventAttributes *ActivityTaskCanceledEventAttributes `locationName:"activityTaskCanceledEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskCompleted then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	ActivityTaskCompletedEventAttributes *ActivityTaskCompletedEventAttributes `locationName:"activityTaskCompletedEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskFailed then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	ActivityTaskFailedEventAttributes *ActivityTaskFailedEventAttributes `locationName:"activityTaskFailedEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskScheduled then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	ActivityTaskScheduledEventAttributes *ActivityTaskScheduledEventAttributes `locationName:"activityTaskScheduledEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskStarted then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	ActivityTaskStartedEventAttributes *ActivityTaskStartedEventAttributes `locationName:"activityTaskStartedEventAttributes" type:"structure"`

	// If the event is of type ActivityTaskTimedOut then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	ActivityTaskTimedOutEventAttributes *ActivityTaskTimedOutEventAttributes `locationName:"activityTaskTimedOutEventAttributes" type:"structure"`

	// If the event is of type CancelTimerFailed then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	CancelTimerFailedEventAttributes *CancelTimerFailedEventAttributes `locationName:"cancelTimerFailedEventAttributes" type:"structure"`

	// If the event is of type CancelWorkflowExecutionFailed then this member is
	// set and provides detailed information about the event. It isn't set for other
	// event types.
	CancelWorkflowExecutionFailedEventAttributes *CancelWorkflowExecutionFailedEventAttributes `locationName:"cancelWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionCanceled then this member is
	// set and provides detailed information about the event. It isn't set for other
	// event types.
	ChildWorkflowExecutionCanceledEventAttributes *ChildWorkflowExecutionCanceledEventAttributes `locationName:"childWorkflowExecutionCanceledEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionCompleted then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	ChildWorkflowExecutionCompletedEventAttributes *ChildWorkflowExecutionCompletedEventAttributes `locationName:"childWorkflowExecutionCompletedEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionFailed then this member is
	// set and provides detailed information about the event. It isn't set for other
	// event types.
	ChildWorkflowExecutionFailedEventAttributes *ChildWorkflowExecutionFailedEventAttributes `locationName:"childWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionStarted then this member is
	// set and provides detailed information about the event. It isn't set for other
	// event types.
	ChildWorkflowExecutionStartedEventAttributes *ChildWorkflowExecutionStartedEventAttributes `locationName:"childWorkflowExecutionStartedEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionTerminated then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	ChildWorkflowExecutionTerminatedEventAttributes *ChildWorkflowExecutionTerminatedEventAttributes `locationName:"childWorkflowExecutionTerminatedEventAttributes" type:"structure"`

	// If the event is of type ChildWorkflowExecutionTimedOut then this member is
	// set and provides detailed information about the event. It isn't set for other
	// event types.
	ChildWorkflowExecutionTimedOutEventAttributes *ChildWorkflowExecutionTimedOutEventAttributes `locationName:"childWorkflowExecutionTimedOutEventAttributes" type:"structure"`

	// If the event is of type CompleteWorkflowExecutionFailed then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	CompleteWorkflowExecutionFailedEventAttributes *CompleteWorkflowExecutionFailedEventAttributes `locationName:"completeWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type ContinueAsNewWorkflowExecutionFailed then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	ContinueAsNewWorkflowExecutionFailedEventAttributes *ContinueAsNewWorkflowExecutionFailedEventAttributes `locationName:"continueAsNewWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type DecisionTaskCompleted then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	DecisionTaskCompletedEventAttributes *DecisionTaskCompletedEventAttributes `locationName:"decisionTaskCompletedEventAttributes" type:"structure"`

	// If the event is of type DecisionTaskScheduled then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	DecisionTaskScheduledEventAttributes *DecisionTaskScheduledEventAttributes `locationName:"decisionTaskScheduledEventAttributes" type:"structure"`

	// If the event is of type DecisionTaskStarted then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	DecisionTaskStartedEventAttributes *DecisionTaskStartedEventAttributes `locationName:"decisionTaskStartedEventAttributes" type:"structure"`

	// If the event is of type DecisionTaskTimedOut then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	DecisionTaskTimedOutEventAttributes *DecisionTaskTimedOutEventAttributes `locationName:"decisionTaskTimedOutEventAttributes" type:"structure"`

	// The system generated ID of the event. This ID uniquely identifies the event
	// with in the workflow execution history.
	//
	// EventId is a required field
	EventId *int64 `locationName:"eventId" type:"long" required:"true"`

	// The date and time when the event occurred.
	//
	// EventTimestamp is a required field
	EventTimestamp *time.Time `locationName:"eventTimestamp" type:"timestamp" required:"true"`

	// The type of the history event.
	//
	// EventType is a required field
	EventType *string `locationName:"eventType" type:"string" required:"true" enum:"EventType"`

	// If the event is of type ExternalWorkflowExecutionCancelRequested then this
	// member is set and provides detailed information about the event. It isn't
	// set for other event types.
	ExternalWorkflowExecutionCancelRequestedEventAttributes *ExternalWorkflowExecutionCancelRequestedEventAttributes `locationName:"externalWorkflowExecutionCancelRequestedEventAttributes" type:"structure"`

	// If the event is of type ExternalWorkflowExecutionSignaled then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	ExternalWorkflowExecutionSignaledEventAttributes *ExternalWorkflowExecutionSignaledEventAttributes `locationName:"externalWorkflowExecutionSignaledEventAttributes" type:"structure"`

	// If the event is of type FailWorkflowExecutionFailed then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	FailWorkflowExecutionFailedEventAttributes *FailWorkflowExecutionFailedEventAttributes `locationName:"failWorkflowExecutionFailedEventAttributes" type:"structure"`

	// Provides the details of the LambdaFunctionCompleted event. It isn't set for
	// other event types.
	LambdaFunctionCompletedEventAttributes *LambdaFunctionCompletedEventAttributes `locationName:"lambdaFunctionCompletedEventAttributes" type:"structure"`

	// Provides the details of the LambdaFunctionFailed event. It isn't set for
	// other event types.
	LambdaFunctionFailedEventAttributes *LambdaFunctionFailedEventAttributes `locationName:"lambdaFunctionFailedEventAttributes" type:"structure"`

	// Provides the details of the LambdaFunctionScheduled event. It isn't set for
	// other event types.
	LambdaFunctionScheduledEventAttributes *LambdaFunctionScheduledEventAttributes `locationName:"lambdaFunctionScheduledEventAttributes" type:"structure"`

	// Provides the details of the LambdaFunctionStarted event. It isn't set for
	// other event types.
	LambdaFunctionStartedEventAttributes *LambdaFunctionStartedEventAttributes `locationName:"lambdaFunctionStartedEventAttributes" type:"structure"`

	// Provides the details of the LambdaFunctionTimedOut event. It isn't set for
	// other event types.
	LambdaFunctionTimedOutEventAttributes *LambdaFunctionTimedOutEventAttributes `locationName:"lambdaFunctionTimedOutEventAttributes" type:"structure"`

	// If the event is of type MarkerRecorded then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	MarkerRecordedEventAttributes *MarkerRecordedEventAttributes `locationName:"markerRecordedEventAttributes" type:"structure"`

	// If the event is of type DecisionTaskFailed then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	RecordMarkerFailedEventAttributes *RecordMarkerFailedEventAttributes `locationName:"recordMarkerFailedEventAttributes" type:"structure"`

	// If the event is of type RequestCancelActivityTaskFailed then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	RequestCancelActivityTaskFailedEventAttributes *RequestCancelActivityTaskFailedEventAttributes `locationName:"requestCancelActivityTaskFailedEventAttributes" type:"structure"`

	// If the event is of type RequestCancelExternalWorkflowExecutionFailed then
	// this member is set and provides detailed information about the event. It
	// isn't set for other event types.
	RequestCancelExternalWorkflowExecutionFailedEventAttributes *RequestCancelExternalWorkflowExecutionFailedEventAttributes `locationName:"requestCancelExternalWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type RequestCancelExternalWorkflowExecutionInitiated then
	// this member is set and provides detailed information about the event. It
	// isn't set for other event types.
	RequestCancelExternalWorkflowExecutionInitiatedEventAttributes *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes `locationName:"requestCancelExternalWorkflowExecutionInitiatedEventAttributes" type:"structure"`

	// If the event is of type ScheduleActivityTaskFailed then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	ScheduleActivityTaskFailedEventAttributes *ScheduleActivityTaskFailedEventAttributes `locationName:"scheduleActivityTaskFailedEventAttributes" type:"structure"`

	// Provides the details of the ScheduleLambdaFunctionFailed event. It isn't
	// set for other event types.
	ScheduleLambdaFunctionFailedEventAttributes *ScheduleLambdaFunctionFailedEventAttributes `locationName:"scheduleLambdaFunctionFailedEventAttributes" type:"structure"`

	// If the event is of type SignalExternalWorkflowExecutionFailed then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	SignalExternalWorkflowExecutionFailedEventAttributes *SignalExternalWorkflowExecutionFailedEventAttributes `locationName:"signalExternalWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type SignalExternalWorkflowExecutionInitiated then this
	// member is set and provides detailed information about the event. It isn't
	// set for other event types.
	SignalExternalWorkflowExecutionInitiatedEventAttributes *SignalExternalWorkflowExecutionInitiatedEventAttributes `locationName:"signalExternalWorkflowExecutionInitiatedEventAttributes" type:"structure"`

	// If the event is of type StartChildWorkflowExecutionFailed then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	StartChildWorkflowExecutionFailedEventAttributes *StartChildWorkflowExecutionFailedEventAttributes `locationName:"startChildWorkflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type StartChildWorkflowExecutionInitiated then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	StartChildWorkflowExecutionInitiatedEventAttributes *StartChildWorkflowExecutionInitiatedEventAttributes `locationName:"startChildWorkflowExecutionInitiatedEventAttributes" type:"structure"`

	// Provides the details of the StartLambdaFunctionFailed event. It isn't set
	// for other event types.
	StartLambdaFunctionFailedEventAttributes *StartLambdaFunctionFailedEventAttributes `locationName:"startLambdaFunctionFailedEventAttributes" type:"structure"`

	// If the event is of type StartTimerFailed then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	StartTimerFailedEventAttributes *StartTimerFailedEventAttributes `locationName:"startTimerFailedEventAttributes" type:"structure"`

	// If the event is of type TimerCanceled then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	TimerCanceledEventAttributes *TimerCanceledEventAttributes `locationName:"timerCanceledEventAttributes" type:"structure"`

	// If the event is of type TimerFired then this member is set and provides detailed
	// information about the event. It isn't set for other event types.
	TimerFiredEventAttributes *TimerFiredEventAttributes `locationName:"timerFiredEventAttributes" type:"structure"`

	// If the event is of type TimerStarted then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	TimerStartedEventAttributes *TimerStartedEventAttributes `locationName:"timerStartedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionCancelRequested then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	WorkflowExecutionCancelRequestedEventAttributes *WorkflowExecutionCancelRequestedEventAttributes `locationName:"workflowExecutionCancelRequestedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionCanceled then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	WorkflowExecutionCanceledEventAttributes *WorkflowExecutionCanceledEventAttributes `locationName:"workflowExecutionCanceledEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionCompleted then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	WorkflowExecutionCompletedEventAttributes *WorkflowExecutionCompletedEventAttributes `locationName:"workflowExecutionCompletedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionContinuedAsNew then this member
	// is set and provides detailed information about the event. It isn't set for
	// other event types.
	WorkflowExecutionContinuedAsNewEventAttributes *WorkflowExecutionContinuedAsNewEventAttributes `locationName:"workflowExecutionContinuedAsNewEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionFailed then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	WorkflowExecutionFailedEventAttributes *WorkflowExecutionFailedEventAttributes `locationName:"workflowExecutionFailedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionSignaled then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	WorkflowExecutionSignaledEventAttributes *WorkflowExecutionSignaledEventAttributes `locationName:"workflowExecutionSignaledEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionStarted then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	WorkflowExecutionStartedEventAttributes *WorkflowExecutionStartedEventAttributes `locationName:"workflowExecutionStartedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionTerminated then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	WorkflowExecutionTerminatedEventAttributes *WorkflowExecutionTerminatedEventAttributes `locationName:"workflowExecutionTerminatedEventAttributes" type:"structure"`

	// If the event is of type WorkflowExecutionTimedOut then this member is set
	// and provides detailed information about the event. It isn't set for other
	// event types.
	WorkflowExecutionTimedOutEventAttributes *WorkflowExecutionTimedOutEventAttributes `locationName:"workflowExecutionTimedOutEventAttributes" type:"structure"`
}

// String returns the string representation
func (s HistoryEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HistoryEvent) GoString() string {
	return s.String()
}

// SetActivityTaskCancelRequestedEventAttributes sets the ActivityTaskCancelRequestedEventAttributes field's value.
func (s *HistoryEvent) SetActivityTaskCancelRequestedEventAttributes(v *ActivityTaskCancelRequestedEventAttributes) *HistoryEvent {
	s.ActivityTaskCancelRequestedEventAttributes = v
	return s
}

// SetActivityTaskCanceledEventAttributes sets the ActivityTaskCanceledEventAttributes field's value.
func (s *HistoryEvent) SetActivityTaskCanceledEventAttributes(v *ActivityTaskCanceledEventAttributes) *HistoryEvent {
	s.ActivityTaskCanceledEventAttributes = v
	return s
}

// SetActivityTaskCompletedEventAttributes sets the ActivityTaskCompletedEventAttributes field's value.
func (s *HistoryEvent) SetActivityTaskCompletedEventAttributes(v *ActivityTaskCompletedEventAttributes) *HistoryEvent {
	s.ActivityTaskCompletedEventAttributes = v
	return s
}

// SetActivityTaskFailedEventAttributes sets the ActivityTaskFailedEventAttributes field's value.
func (s *HistoryEvent) SetActivityTaskFailedEventAttributes(v *ActivityTaskFailedEventAttributes) *HistoryEvent {
	s.ActivityTaskFailedEventAttributes = v
	return s
}

// SetActivityTaskScheduledEventAttributes sets the ActivityTaskScheduledEventAttributes field's value.
func (s *HistoryEvent) SetActivityTaskScheduledEventAttributes(v *ActivityTaskScheduledEventAttributes) *HistoryEvent {
	s.ActivityTaskScheduledEventAttributes = v
	return s
}

// SetActivityTaskStartedEventAttributes sets the ActivityTaskStartedEventAttributes field's value.
func (s *HistoryEvent) SetActivityTaskStartedEventAttributes(v *ActivityTaskStartedEventAttributes) *HistoryEvent {
	s.ActivityTaskStartedEventAttributes = v
	return s
}

// SetActivityTaskTimedOutEventAttributes sets the ActivityTaskTimedOutEventAttributes field's value.
func (s *HistoryEvent) SetActivityTaskTimedOutEventAttributes(v *ActivityTaskTimedOutEventAttributes) *HistoryEvent {
	s.ActivityTaskTimedOutEventAttributes = v
	return s
}

// SetCancelTimerFailedEventAttributes sets the CancelTimerFailedEventAttributes field's value.
func (s *HistoryEvent) SetCancelTimerFailedEventAttributes(v *CancelTimerFailedEventAttributes) *HistoryEvent {
	s.CancelTimerFailedEventAttributes = v
	return s
}

// SetCancelWorkflowExecutionFailedEventAttributes sets the CancelWorkflowExecutionFailedEventAttributes field's value.
func (s *HistoryEvent) SetCancelWorkflowExecutionFailedEventAttributes(v *CancelWorkflowExecutionFailedEventAttributes) *HistoryEvent {
	s.CancelWorkflowExecutionFailedEventAttributes = v
	return s
}

// SetChildWorkflowExecutionCanceledEventAttributes sets the ChildWorkflowExecutionCanceledEventAttributes field's value.
func (s *HistoryEvent) SetChildWorkflowExecutionCanceledEventAttributes(v *ChildWorkflowExecutionCanceledEventAttributes) *HistoryEvent {
	s.ChildWorkflowExecutionCanceledEventAttributes = v
	return s
}

// SetChildWorkflowExecutionCompletedEventAttributes sets the ChildWorkflowExecutionCompletedEventAttributes field's value.
func (s *HistoryEvent) SetChildWorkflowExecutionCompletedEventAttributes(v *ChildWorkflowExecutionCompletedEventAttributes) *HistoryEvent {
	s.ChildWorkflowExecutionCompletedEventAttributes = v
	return s
}

// SetChildWorkflowExecutionFailedEventAttributes sets the ChildWorkflowExecutionFailedEventAttributes field's value.
func (s *HistoryEvent) SetChildWorkflowExecutionFailedEventAttributes(v *ChildWorkflowExecutionFailedEventAttributes) *HistoryEvent {
	s.ChildWorkflowExecutionFailedEventAttributes = v
	return s
}

// SetChildWorkflowExecutionStartedEventAttributes sets the ChildWorkflowExecutionStartedEventAttributes field's value.
func (s *HistoryEvent) SetChildWorkflowExecutionStartedEventAttributes(v *ChildWorkflowExecutionStartedEventAttributes) *HistoryEvent {
	s.ChildWorkflowExecutionStartedEventAttributes = v
	return s
}

// SetChildWorkflowExecutionTerminatedEventAttributes sets the ChildWorkflowExecutionTerminatedEventAttributes field's value.
func (s *HistoryEvent) SetChildWorkflowExecutionTerminatedEventAttributes(v *ChildWorkflowExecutionTerminatedEventAttributes) *HistoryEvent {
	s.ChildWorkflowExecutionTerminatedEventAttributes = v
	return s
}

// SetChildWorkflowExecutionTimedOutEventAttributes sets the ChildWorkflowExecutionTimedOutEventAttributes field's value.
func (s *HistoryEvent) SetChildWorkflowExecutionTimedOutEventAttributes(v *ChildWorkflowExecutionTimedOutEventAttributes) *HistoryEvent {
	s.ChildWorkflowExecutionTimedOutEventAttributes = v
	return s
}

// SetCompleteWorkflowExecutionFailedEventAttributes sets the CompleteWorkflowExecutionFailedEventAttributes field's value.
func (s *HistoryEvent) SetCompleteWorkflowExecutionFailedEventAttributes(v *CompleteWorkflowExecutionFailedEventAttributes) *HistoryEvent {
	s.CompleteWorkflowExecutionFailedEventAttributes = v
	return s
}

// SetContinueAsNewWorkflowExecutionFailedEventAttributes sets the ContinueAsNewWorkflowExecutionFailedEventAttributes field's value.
func (s *HistoryEvent) SetContinueAsNewWorkflowExecutionFailedEventAttributes(v *ContinueAsNewWorkflowExecutionFailedEventAttributes) *HistoryEvent {
	s.ContinueAsNewWorkflowExecutionFailedEventAttributes = v
	return s
}

// SetDecisionTaskCompletedEventAttributes sets the DecisionTaskCompletedEventAttributes field's value.
func (s *HistoryEvent) SetDecisionTaskCompletedEventAttributes(v *DecisionTaskCompletedEventAttributes) *HistoryEvent {
	s.DecisionTaskCompletedEventAttributes = v
	return s
}

// SetDecisionTaskScheduledEventAttributes sets the DecisionTaskScheduledEventAttributes field's value.
func (s *HistoryEvent) SetDecisionTaskScheduledEventAttributes(v *DecisionTaskScheduledEventAttributes) *HistoryEvent {
	s.DecisionTaskScheduledEventAttributes = v
	return s
}

// SetDecisionTaskStartedEventAttributes sets the DecisionTaskStartedEventAttributes field's value.
func (s *HistoryEvent) SetDecisionTaskStartedEventAttributes(v *DecisionTaskStartedEventAttributes) *HistoryEvent {
	s.DecisionTaskStartedEventAttributes = v
	return s
}

// SetDecisionTaskTimedOutEventAttributes sets the DecisionTaskTimedOutEventAttributes field's value.
func (s *HistoryEvent) SetDecisionTaskTimedOutEventAttributes(v *DecisionTaskTimedOutEventAttributes) *HistoryEvent {
	s.DecisionTaskTimedOutEventAttributes = v
	return s
}

// SetEventId sets the EventId field's value.
func (s *HistoryEvent) SetEventId(v int64) *HistoryEvent {
	s.EventId = &v
	return s
}

// SetEventTimestamp sets the EventTimestamp field's value.
func (s *HistoryEvent) SetEventTimestamp(v time.Time) *HistoryEvent {
	s.EventTimestamp = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *HistoryEvent) SetEventType(v string) *HistoryEvent {
	s.EventType = &v
	return s
}

// SetExternalWorkflowExecutionCancelRequestedEventAttributes sets the ExternalWorkflowExecutionCancelRequestedEventAttributes field's value.
func (s *HistoryEvent) SetExternalWorkflowExecutionCancelRequestedEventAttributes(v *ExternalWorkflowExecutionCancelRequestedEventAttributes) *HistoryEvent {
	s.ExternalWorkflowExecutionCancelRequestedEventAttributes = v
	return s
}

// SetExternalWorkflowExecutionSignaledEventAttributes sets the ExternalWorkflowExecutionSignaledEventAttributes field's value.
func (s *HistoryEvent) SetExternalWorkflowExecutionSignaledEventAttributes(v *ExternalWorkflowExecutionSignaledEventAttributes) *HistoryEvent {
	s.ExternalWorkflowExecutionSignaledEventAttributes = v
	return s
}

// SetFailWorkflowExecutionFailedEventAttributes sets the FailWorkflowExecutionFailedEventAttributes field's value.
func (s *HistoryEvent) SetFailWorkflowExecutionFailedEventAttributes(v *FailWorkflowExecutionFailedEventAttributes) *HistoryEvent {
	s.FailWorkflowExecutionFailedEventAttributes = v
	return s
}

// SetLambdaFunctionCompletedEventAttributes sets the LambdaFunctionCompletedEventAttributes field's value.
func (s *HistoryEvent) SetLambdaFunctionCompletedEventAttributes(v *LambdaFunctionCompletedEventAttributes) *HistoryEvent {
	s.LambdaFunctionCompletedEventAttributes = v
	return s
}

// SetLambdaFunctionFailedEventAttributes sets the LambdaFunctionFailedEventAttributes field's value.
func (s *HistoryEvent) SetLambdaFunctionFailedEventAttributes(v *LambdaFunctionFailedEventAttributes) *HistoryEvent {
	s.LambdaFunctionFailedEventAttributes = v
	return s
}

// SetLambdaFunctionScheduledEventAttributes sets the LambdaFunctionScheduledEventAttributes field's value.
func (s *HistoryEvent) SetLambdaFunctionScheduledEventAttributes(v *LambdaFunctionScheduledEventAttributes) *HistoryEvent {
	s.LambdaFunctionScheduledEventAttributes = v
	return s
}

// SetLambdaFunctionStartedEventAttributes sets the LambdaFunctionStartedEventAttributes field's value.
func (s *HistoryEvent) SetLambdaFunctionStartedEventAttributes(v *LambdaFunctionStartedEventAttributes) *HistoryEvent {
	s.LambdaFunctionStartedEventAttributes = v
	return s
}

// SetLambdaFunctionTimedOutEventAttributes sets the LambdaFunctionTimedOutEventAttributes field's value.
func (s *HistoryEvent) SetLambdaFunctionTimedOutEventAttributes(v *LambdaFunctionTimedOutEventAttributes) *HistoryEvent {
	s.LambdaFunctionTimedOutEventAttributes = v
	return s
}

// SetMarkerRecordedEventAttributes sets the MarkerRecordedEventAttributes field's value.
func (s *HistoryEvent) SetMarkerRecordedEventAttributes(v *MarkerRecordedEventAttributes) *HistoryEvent {
	s.MarkerRecordedEventAttributes = v
	return s
}

// SetRecordMarkerFailedEventAttributes sets the RecordMarkerFailedEventAttributes field's value.
func (s *HistoryEvent) SetRecordMarkerFailedEventAttributes(v *RecordMarkerFailedEventAttributes) *HistoryEvent {
	s.RecordMarkerFailedEventAttributes = v
	return s
}

// SetRequestCancelActivityTaskFailedEventAttributes sets the RequestCancelActivityTaskFailedEventAttributes field's value.
func (s *HistoryEvent) SetRequestCancelActivityTaskFailedEventAttributes(v *RequestCancelActivityTaskFailedEventAttributes) *HistoryEvent {
	s.RequestCancelActivityTaskFailedEventAttributes = v
	return s
}

// SetRequestCancelExternalWorkflowExecutionFailedEventAttributes sets the RequestCancelExternalWorkflowExecutionFailedEventAttributes field's value.
func (s *HistoryEvent) SetRequestCancelExternalWorkflowExecutionFailedEventAttributes(v *RequestCancelExternalWorkflowExecutionFailedEventAttributes) *HistoryEvent {
	s.RequestCancelExternalWorkflowExecutionFailedEventAttributes = v
	return s
}

// SetRequestCancelExternalWorkflowExecutionInitiatedEventAttributes sets the RequestCancelExternalWorkflowExecutionInitiatedEventAttributes field's value.
func (s *HistoryEvent) SetRequestCancelExternalWorkflowExecutionInitiatedEventAttributes(v *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) *HistoryEvent {
	s.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes = v
	return s
}

// SetScheduleActivityTaskFailedEventAttributes sets the ScheduleActivityTaskFailedEventAttributes field's value.
func (s *HistoryEvent) SetScheduleActivityTaskFailedEventAttributes(v *ScheduleActivityTaskFailedEventAttributes) *HistoryEvent {
	s.ScheduleActivityTaskFailedEventAttributes = v
	return s
}

// SetScheduleLambdaFunctionFailedEventAttributes sets the ScheduleLambdaFunctionFailedEventAttributes field's value.
func (s *HistoryEvent) SetScheduleLambdaFunctionFailedEventAttributes(v *ScheduleLambdaFunctionFailedEventAttributes) *HistoryEvent {
	s.ScheduleLambdaFunctionFailedEventAttributes = v
	return s
}

// SetSignalExternalWorkflowExecutionFailedEventAttributes sets the SignalExternalWorkflowExecutionFailedEventAttributes field's value.
func (s *HistoryEvent) SetSignalExternalWorkflowExecutionFailedEventAttributes(v *SignalExternalWorkflowExecutionFailedEventAttributes) *HistoryEvent {
	s.SignalExternalWorkflowExecutionFailedEventAttributes = v
	return s
}

// SetSignalExternalWorkflowExecutionInitiatedEventAttributes sets the SignalExternalWorkflowExecutionInitiatedEventAttributes field's value.
func (s *HistoryEvent) SetSignalExternalWorkflowExecutionInitiatedEventAttributes(v *SignalExternalWorkflowExecutionInitiatedEventAttributes) *HistoryEvent {
	s.SignalExternalWorkflowExecutionInitiatedEventAttributes = v
	return s
}

// SetStartChildWorkflowExecutionFailedEventAttributes sets the StartChildWorkflowExecutionFailedEventAttributes field's value.
func (s *HistoryEvent) SetStartChildWorkflowExecutionFailedEventAttributes(v *StartChildWorkflowExecutionFailedEventAttributes) *HistoryEvent {
	s.StartChildWorkflowExecutionFailedEventAttributes = v
	return s
}

// SetStartChildWorkflowExecutionInitiatedEventAttributes sets the StartChildWorkflowExecutionInitiatedEventAttributes field's value.
func (s *HistoryEvent) SetStartChildWorkflowExecutionInitiatedEventAttributes(v *StartChildWorkflowExecutionInitiatedEventAttributes) *HistoryEvent {
	s.StartChildWorkflowExecutionInitiatedEventAttributes = v
	return s
}

// SetStartLambdaFunctionFailedEventAttributes sets the StartLambdaFunctionFailedEventAttributes field's value.
func (s *HistoryEvent) SetStartLambdaFunctionFailedEventAttributes(v *StartLambdaFunctionFailedEventAttributes) *HistoryEvent {
	s.StartLambdaFunctionFailedEventAttributes = v
	return s
}

// SetStartTimerFailedEventAttributes sets the StartTimerFailedEventAttributes field's value.
func (s *HistoryEvent) SetStartTimerFailedEventAttributes(v *StartTimerFailedEventAttributes) *HistoryEvent {
	s.StartTimerFailedEventAttributes = v
	return s
}

// SetTimerCanceledEventAttributes sets the TimerCanceledEventAttributes field's value.
func (s *HistoryEvent) SetTimerCanceledEventAttributes(v *TimerCanceledEventAttributes) *HistoryEvent {
	s.TimerCanceledEventAttributes = v
	return s
}

// SetTimerFiredEventAttributes sets the TimerFiredEventAttributes field's value.
func (s *HistoryEvent) SetTimerFiredEventAttributes(v *TimerFiredEventAttributes) *HistoryEvent {
	s.TimerFiredEventAttributes = v
	return s
}

// SetTimerStartedEventAttributes sets the TimerStartedEventAttributes field's value.
func (s *HistoryEvent) SetTimerStartedEventAttributes(v *TimerStartedEventAttributes) *HistoryEvent {
	s.TimerStartedEventAttributes = v
	return s
}

// SetWorkflowExecutionCancelRequestedEventAttributes sets the WorkflowExecutionCancelRequestedEventAttributes field's value.
func (s *HistoryEvent) SetWorkflowExecutionCancelRequestedEventAttributes(v *WorkflowExecutionCancelRequestedEventAttributes) *HistoryEvent {
	s.WorkflowExecutionCancelRequestedEventAttributes = v
	return s
}

// SetWorkflowExecutionCanceledEventAttributes sets the WorkflowExecutionCanceledEventAttributes field's value.
func (s *HistoryEvent) SetWorkflowExecutionCanceledEventAttributes(v *WorkflowExecutionCanceledEventAttributes) *HistoryEvent {
	s.WorkflowExecutionCanceledEventAttributes = v
	return s
}

// SetWorkflowExecutionCompletedEventAttributes sets the WorkflowExecutionCompletedEventAttributes field's value.
func (s *HistoryEvent) SetWorkflowExecutionCompletedEventAttributes(v *WorkflowExecutionCompletedEventAttributes) *HistoryEvent {
	s.WorkflowExecutionCompletedEventAttributes = v
	return s
}

// SetWorkflowExecutionContinuedAsNewEventAttributes sets the WorkflowExecutionContinuedAsNewEventAttributes field's value.
func (s *HistoryEvent) SetWorkflowExecutionContinuedAsNewEventAttributes(v *WorkflowExecutionContinuedAsNewEventAttributes) *HistoryEvent {
	s.WorkflowExecutionContinuedAsNewEventAttributes = v
	return s
}

// SetWorkflowExecutionFailedEventAttributes sets the WorkflowExecutionFailedEventAttributes field's value.
func (s *HistoryEvent) SetWorkflowExecutionFailedEventAttributes(v *WorkflowExecutionFailedEventAttributes) *HistoryEvent {
	s.WorkflowExecutionFailedEventAttributes = v
	return s
}

// SetWorkflowExecutionSignaledEventAttributes sets the WorkflowExecutionSignaledEventAttributes field's value.
func (s *HistoryEvent) SetWorkflowExecutionSignaledEventAttributes(v *WorkflowExecutionSignaledEventAttributes) *HistoryEvent {
	s.WorkflowExecutionSignaledEventAttributes = v
	return s
}

// SetWorkflowExecutionStartedEventAttributes sets the WorkflowExecutionStartedEventAttributes field's value.
func (s *HistoryEvent) SetWorkflowExecutionStartedEventAttributes(v *WorkflowExecutionStartedEventAttributes) *HistoryEvent {
	s.WorkflowExecutionStartedEventAttributes = v
	return s
}

// SetWorkflowExecutionTerminatedEventAttributes sets the WorkflowExecutionTerminatedEventAttributes field's value.
func (s *HistoryEvent) SetWorkflowExecutionTerminatedEventAttributes(v *WorkflowExecutionTerminatedEventAttributes) *HistoryEvent {
	s.WorkflowExecutionTerminatedEventAttributes = v
	return s
}

// SetWorkflowExecutionTimedOutEventAttributes sets the WorkflowExecutionTimedOutEventAttributes field's value.
func (s *HistoryEvent) SetWorkflowExecutionTimedOutEventAttributes(v *WorkflowExecutionTimedOutEventAttributes) *HistoryEvent {
	s.WorkflowExecutionTimedOutEventAttributes = v
	return s
}

// Provides the details of the LambdaFunctionCompleted event. It isn't set for
// other event types.
type LambdaFunctionCompletedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The results of the Lambda task.
	Result *string `locationName:"result" type:"string"`

	// The ID of the LambdaFunctionScheduled event that was recorded when this Lambda
	// task was scheduled. To help diagnose issues, use this information to trace
	// back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the LambdaFunctionStarted event recorded when this activity task
	// started. To help diagnose issues, use this information to trace back the
	// chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionCompletedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionCompletedEventAttributes) GoString() string {
	return s.String()
}

// SetResult sets the Result field's value.
func (s *LambdaFunctionCompletedEventAttributes) SetResult(v string) *LambdaFunctionCompletedEventAttributes {
	s.Result = &v
	return s
}

// SetScheduledEventId sets the ScheduledEventId field's value.
func (s *LambdaFunctionCompletedEventAttributes) SetScheduledEventId(v int64) *LambdaFunctionCompletedEventAttributes {
	s.ScheduledEventId = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *LambdaFunctionCompletedEventAttributes) SetStartedEventId(v int64) *LambdaFunctionCompletedEventAttributes {
	s.StartedEventId = &v
	return s
}

// Provides the details of the LambdaFunctionFailed event. It isn't set for
// other event types.
type LambdaFunctionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The details of the failure.
	Details *string `locationName:"details" type:"string"`

	// The reason provided for the failure.
	Reason *string `locationName:"reason" type:"string"`

	// The ID of the LambdaFunctionScheduled event that was recorded when this activity
	// task was scheduled. To help diagnose issues, use this information to trace
	// back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the LambdaFunctionStarted event recorded when this activity task
	// started. To help diagnose issues, use this information to trace back the
	// chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionFailedEventAttributes) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *LambdaFunctionFailedEventAttributes) SetDetails(v string) *LambdaFunctionFailedEventAttributes {
	s.Details = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *LambdaFunctionFailedEventAttributes) SetReason(v string) *LambdaFunctionFailedEventAttributes {
	s.Reason = &v
	return s
}

// SetScheduledEventId sets the ScheduledEventId field's value.
func (s *LambdaFunctionFailedEventAttributes) SetScheduledEventId(v int64) *LambdaFunctionFailedEventAttributes {
	s.ScheduledEventId = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *LambdaFunctionFailedEventAttributes) SetStartedEventId(v int64) *LambdaFunctionFailedEventAttributes {
	s.StartedEventId = &v
	return s
}

// Provides the details of the LambdaFunctionScheduled event. It isn't set for
// other event types.
type LambdaFunctionScheduledEventAttributes struct {
	_ struct{} `type:"structure"`

	// Data attached to the event that the decider can use in subsequent workflow
	// tasks. This data isn't sent to the Lambda task.
	Control *string `locationName:"control" type:"string"`

	// The ID of the LambdaFunctionCompleted event corresponding to the decision
	// that resulted in scheduling this activity task. To help diagnose issues,
	// use this information to trace back the chain of events leading up to this
	// event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The unique ID of the Lambda task.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The input provided to the Lambda task.
	Input *string `locationName:"input" type:"string"`

	// The name of the Lambda function.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The maximum amount of time a worker can take to process the Lambda task.
	StartToCloseTimeout *string `locationName:"startToCloseTimeout" type:"string"`
}

// String returns the string representation
func (s LambdaFunctionScheduledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionScheduledEventAttributes) GoString() string {
	return s.String()
}

// SetControl sets the Control field's value.
func (s *LambdaFunctionScheduledEventAttributes) SetControl(v string) *LambdaFunctionScheduledEventAttributes {
	s.Control = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *LambdaFunctionScheduledEventAttributes) SetDecisionTaskCompletedEventId(v int64) *LambdaFunctionScheduledEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetId sets the Id field's value.
func (s *LambdaFunctionScheduledEventAttributes) SetId(v string) *LambdaFunctionScheduledEventAttributes {
	s.Id = &v
	return s
}

// SetInput sets the Input field's value.
func (s *LambdaFunctionScheduledEventAttributes) SetInput(v string) *LambdaFunctionScheduledEventAttributes {
	s.Input = &v
	return s
}

// SetName sets the Name field's value.
func (s *LambdaFunctionScheduledEventAttributes) SetName(v string) *LambdaFunctionScheduledEventAttributes {
	s.Name = &v
	return s
}

// SetStartToCloseTimeout sets the StartToCloseTimeout field's value.
func (s *LambdaFunctionScheduledEventAttributes) SetStartToCloseTimeout(v string) *LambdaFunctionScheduledEventAttributes {
	s.StartToCloseTimeout = &v
	return s
}

// Provides the details of the LambdaFunctionStarted event. It isn't set for
// other event types.
type LambdaFunctionStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the LambdaFunctionScheduled event that was recorded when this activity
	// task was scheduled. To help diagnose issues, use this information to trace
	// back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s LambdaFunctionStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionStartedEventAttributes) GoString() string {
	return s.String()
}

// SetScheduledEventId sets the ScheduledEventId field's value.
func (s *LambdaFunctionStartedEventAttributes) SetScheduledEventId(v int64) *LambdaFunctionStartedEventAttributes {
	s.ScheduledEventId = &v
	return s
}

// Provides details of the LambdaFunctionTimedOut event.
type LambdaFunctionTimedOutEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the LambdaFunctionScheduled event that was recorded when this activity
	// task was scheduled. To help diagnose issues, use this information to trace
	// back the chain of events leading up to this event.
	//
	// ScheduledEventId is a required field
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long" required:"true"`

	// The ID of the ActivityTaskStarted event that was recorded when this activity
	// task started. To help diagnose issues, use this information to trace back
	// the chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The type of the timeout that caused this event.
	TimeoutType *string `locationName:"timeoutType" type:"string" enum:"LambdaFunctionTimeoutType"`
}

// String returns the string representation
func (s LambdaFunctionTimedOutEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaFunctionTimedOutEventAttributes) GoString() string {
	return s.String()
}

// SetScheduledEventId sets the ScheduledEventId field's value.
func (s *LambdaFunctionTimedOutEventAttributes) SetScheduledEventId(v int64) *LambdaFunctionTimedOutEventAttributes {
	s.ScheduledEventId = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *LambdaFunctionTimedOutEventAttributes) SetStartedEventId(v int64) *LambdaFunctionTimedOutEventAttributes {
	s.StartedEventId = &v
	return s
}

// SetTimeoutType sets the TimeoutType field's value.
func (s *LambdaFunctionTimedOutEventAttributes) SetTimeoutType(v string) *LambdaFunctionTimedOutEventAttributes {
	s.TimeoutType = &v
	return s
}

type ListActivityTypesInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain in which the activity types have been registered.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The maximum number of results that are returned per call. Use nextPageToken
	// to obtain further pages of results.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If specified, only lists the activity types that have this name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// If NextPageToken is returned there are more results available. The value
	// of NextPageToken is a unique pagination token for each page. Make the call
	// again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged. Each pagination token expires after 60 seconds. Using
	// an expired pagination token will return a 400 error: "Specified token has
	// exceeded its maximum lifetime".
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// Specifies the registration status of the activity types to list.
	//
	// RegistrationStatus is a required field
	RegistrationStatus *string `locationName:"registrationStatus" type:"string" required:"true" enum:"RegistrationStatus"`

	// When set to true, returns the results in reverse order. By default, the results
	// are returned in ascending alphabetical order by name of the activity types.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`
}

// String returns the string representation
func (s ListActivityTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActivityTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListActivityTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListActivityTypesInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RegistrationStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistrationStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *ListActivityTypesInput) SetDomain(v string) *ListActivityTypesInput {
	s.Domain = &v
	return s
}

// SetMaximumPageSize sets the MaximumPageSize field's value.
func (s *ListActivityTypesInput) SetMaximumPageSize(v int64) *ListActivityTypesInput {
	s.MaximumPageSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListActivityTypesInput) SetName(v string) *ListActivityTypesInput {
	s.Name = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListActivityTypesInput) SetNextPageToken(v string) *ListActivityTypesInput {
	s.NextPageToken = &v
	return s
}

// SetRegistrationStatus sets the RegistrationStatus field's value.
func (s *ListActivityTypesInput) SetRegistrationStatus(v string) *ListActivityTypesInput {
	s.RegistrationStatus = &v
	return s
}

// SetReverseOrder sets the ReverseOrder field's value.
func (s *ListActivityTypesInput) SetReverseOrder(v bool) *ListActivityTypesInput {
	s.ReverseOrder = &v
	return s
}

// Contains a paginated list of activity type information structures.
type ListActivityTypesOutput struct {
	_ struct{} `type:"structure"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// List of activity type information.
	//
	// TypeInfos is a required field
	TypeInfos []*ActivityTypeInfo `locationName:"typeInfos" type:"list" required:"true"`
}

// String returns the string representation
func (s ListActivityTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActivityTypesOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListActivityTypesOutput) SetNextPageToken(v string) *ListActivityTypesOutput {
	s.NextPageToken = &v
	return s
}

// SetTypeInfos sets the TypeInfos field's value.
func (s *ListActivityTypesOutput) SetTypeInfos(v []*ActivityTypeInfo) *ListActivityTypesOutput {
	s.TypeInfos = v
	return s
}

type ListClosedWorkflowExecutionsInput struct {
	_ struct{} `type:"structure"`

	// If specified, only workflow executions that match this close status are listed.
	// For example, if TERMINATED is specified, then only TERMINATED workflow executions
	// are listed.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	CloseStatusFilter *CloseStatusFilter `locationName:"closeStatusFilter" type:"structure"`

	// If specified, the workflow executions are included in the returned results
	// based on whether their close times are within the range specified by this
	// filter. Also, if this parameter is specified, the returned results are ordered
	// by their close times.
	//
	// startTimeFilter and closeTimeFilter are mutually exclusive. You must specify
	// one of these in a request but not both.
	CloseTimeFilter *ExecutionTimeFilter `locationName:"closeTimeFilter" type:"structure"`

	// The name of the domain that contains the workflow executions to list.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// If specified, only workflow executions matching the workflow ID specified
	// in the filter are returned.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	ExecutionFilter *WorkflowExecutionFilter `locationName:"executionFilter" type:"structure"`

	// The maximum number of results that are returned per call. Use nextPageToken
	// to obtain further pages of results.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If NextPageToken is returned there are more results available. The value
	// of NextPageToken is a unique pagination token for each page. Make the call
	// again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged. Each pagination token expires after 60 seconds. Using
	// an expired pagination token will return a 400 error: "Specified token has
	// exceeded its maximum lifetime".
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// When set to true, returns the results in reverse order. By default the results
	// are returned in descending order of the start or the close time of the executions.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`

	// If specified, the workflow executions are included in the returned results
	// based on whether their start times are within the range specified by this
	// filter. Also, if this parameter is specified, the returned results are ordered
	// by their start times.
	//
	// startTimeFilter and closeTimeFilter are mutually exclusive. You must specify
	// one of these in a request but not both.
	StartTimeFilter *ExecutionTimeFilter `locationName:"startTimeFilter" type:"structure"`

	// If specified, only executions that have the matching tag are listed.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	TagFilter *TagFilter `locationName:"tagFilter" type:"structure"`

	// If specified, only executions of the type specified in the filter are returned.
	//
	// closeStatusFilter, executionFilter, typeFilter and tagFilter are mutually
	// exclusive. You can specify at most one of these in a request.
	TypeFilter *WorkflowTypeFilter `locationName:"typeFilter" type:"structure"`
}

// String returns the string representation
func (s ListClosedWorkflowExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClosedWorkflowExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClosedWorkflowExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClosedWorkflowExecutionsInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.CloseStatusFilter != nil {
		if err := s.CloseStatusFilter.Validate(); err != nil {
			invalidParams.AddNested("CloseStatusFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.CloseTimeFilter != nil {
		if err := s.CloseTimeFilter.Validate(); err != nil {
			invalidParams.AddNested("CloseTimeFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.ExecutionFilter != nil {
		if err := s.ExecutionFilter.Validate(); err != nil {
			invalidParams.AddNested("ExecutionFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.StartTimeFilter != nil {
		if err := s.StartTimeFilter.Validate(); err != nil {
			invalidParams.AddNested("StartTimeFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.TagFilter != nil {
		if err := s.TagFilter.Validate(); err != nil {
			invalidParams.AddNested("TagFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.TypeFilter != nil {
		if err := s.TypeFilter.Validate(); err != nil {
			invalidParams.AddNested("TypeFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloseStatusFilter sets the CloseStatusFilter field's value.
func (s *ListClosedWorkflowExecutionsInput) SetCloseStatusFilter(v *CloseStatusFilter) *ListClosedWorkflowExecutionsInput {
	s.CloseStatusFilter = v
	return s
}

// SetCloseTimeFilter sets the CloseTimeFilter field's value.
func (s *ListClosedWorkflowExecutionsInput) SetCloseTimeFilter(v *ExecutionTimeFilter) *ListClosedWorkflowExecutionsInput {
	s.CloseTimeFilter = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *ListClosedWorkflowExecutionsInput) SetDomain(v string) *ListClosedWorkflowExecutionsInput {
	s.Domain = &v
	return s
}

// SetExecutionFilter sets the ExecutionFilter field's value.
func (s *ListClosedWorkflowExecutionsInput) SetExecutionFilter(v *WorkflowExecutionFilter) *ListClosedWorkflowExecutionsInput {
	s.ExecutionFilter = v
	return s
}

// SetMaximumPageSize sets the MaximumPageSize field's value.
func (s *ListClosedWorkflowExecutionsInput) SetMaximumPageSize(v int64) *ListClosedWorkflowExecutionsInput {
	s.MaximumPageSize = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListClosedWorkflowExecutionsInput) SetNextPageToken(v string) *ListClosedWorkflowExecutionsInput {
	s.NextPageToken = &v
	return s
}

// SetReverseOrder sets the ReverseOrder field's value.
func (s *ListClosedWorkflowExecutionsInput) SetReverseOrder(v bool) *ListClosedWorkflowExecutionsInput {
	s.ReverseOrder = &v
	return s
}

// SetStartTimeFilter sets the StartTimeFilter field's value.
func (s *ListClosedWorkflowExecutionsInput) SetStartTimeFilter(v *ExecutionTimeFilter) *ListClosedWorkflowExecutionsInput {
	s.StartTimeFilter = v
	return s
}

// SetTagFilter sets the TagFilter field's value.
func (s *ListClosedWorkflowExecutionsInput) SetTagFilter(v *TagFilter) *ListClosedWorkflowExecutionsInput {
	s.TagFilter = v
	return s
}

// SetTypeFilter sets the TypeFilter field's value.
func (s *ListClosedWorkflowExecutionsInput) SetTypeFilter(v *WorkflowTypeFilter) *ListClosedWorkflowExecutionsInput {
	s.TypeFilter = v
	return s
}

type ListDomainsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results that are returned per call. Use nextPageToken
	// to obtain further pages of results.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If NextPageToken is returned there are more results available. The value
	// of NextPageToken is a unique pagination token for each page. Make the call
	// again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged. Each pagination token expires after 60 seconds. Using
	// an expired pagination token will return a 400 error: "Specified token has
	// exceeded its maximum lifetime".
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// Specifies the registration status of the domains to list.
	//
	// RegistrationStatus is a required field
	RegistrationStatus *string `locationName:"registrationStatus" type:"string" required:"true" enum:"RegistrationStatus"`

	// When set to true, returns the results in reverse order. By default, the results
	// are returned in ascending alphabetical order by name of the domains.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`
}

// String returns the string representation
func (s ListDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainsInput"}
	if s.RegistrationStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistrationStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaximumPageSize sets the MaximumPageSize field's value.
func (s *ListDomainsInput) SetMaximumPageSize(v int64) *ListDomainsInput {
	s.MaximumPageSize = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListDomainsInput) SetNextPageToken(v string) *ListDomainsInput {
	s.NextPageToken = &v
	return s
}

// SetRegistrationStatus sets the RegistrationStatus field's value.
func (s *ListDomainsInput) SetRegistrationStatus(v string) *ListDomainsInput {
	s.RegistrationStatus = &v
	return s
}

// SetReverseOrder sets the ReverseOrder field's value.
func (s *ListDomainsInput) SetReverseOrder(v bool) *ListDomainsInput {
	s.ReverseOrder = &v
	return s
}

// Contains a paginated collection of DomainInfo structures.
type ListDomainsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DomainInfo structures.
	//
	// DomainInfos is a required field
	DomainInfos []*DomainInfo `locationName:"domainInfos" type:"list" required:"true"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s ListDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainsOutput) GoString() string {
	return s.String()
}

// SetDomainInfos sets the DomainInfos field's value.
func (s *ListDomainsOutput) SetDomainInfos(v []*DomainInfo) *ListDomainsOutput {
	s.DomainInfos = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListDomainsOutput) SetNextPageToken(v string) *ListDomainsOutput {
	s.NextPageToken = &v
	return s
}

type ListOpenWorkflowExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the workflow executions to list.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// If specified, only workflow executions matching the workflow ID specified
	// in the filter are returned.
	//
	// executionFilter, typeFilter and tagFilter are mutually exclusive. You can
	// specify at most one of these in a request.
	ExecutionFilter *WorkflowExecutionFilter `locationName:"executionFilter" type:"structure"`

	// The maximum number of results that are returned per call. Use nextPageToken
	// to obtain further pages of results.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If NextPageToken is returned there are more results available. The value
	// of NextPageToken is a unique pagination token for each page. Make the call
	// again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged. Each pagination token expires after 60 seconds. Using
	// an expired pagination token will return a 400 error: "Specified token has
	// exceeded its maximum lifetime".
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// When set to true, returns the results in reverse order. By default the results
	// are returned in descending order of the start time of the executions.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`

	// Workflow executions are included in the returned results based on whether
	// their start times are within the range specified by this filter.
	//
	// StartTimeFilter is a required field
	StartTimeFilter *ExecutionTimeFilter `locationName:"startTimeFilter" type:"structure" required:"true"`

	// If specified, only executions that have the matching tag are listed.
	//
	// executionFilter, typeFilter and tagFilter are mutually exclusive. You can
	// specify at most one of these in a request.
	TagFilter *TagFilter `locationName:"tagFilter" type:"structure"`

	// If specified, only executions of the type specified in the filter are returned.
	//
	// executionFilter, typeFilter and tagFilter are mutually exclusive. You can
	// specify at most one of these in a request.
	TypeFilter *WorkflowTypeFilter `locationName:"typeFilter" type:"structure"`
}

// String returns the string representation
func (s ListOpenWorkflowExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOpenWorkflowExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOpenWorkflowExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOpenWorkflowExecutionsInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.StartTimeFilter == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTimeFilter"))
	}
	if s.ExecutionFilter != nil {
		if err := s.ExecutionFilter.Validate(); err != nil {
			invalidParams.AddNested("ExecutionFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.StartTimeFilter != nil {
		if err := s.StartTimeFilter.Validate(); err != nil {
			invalidParams.AddNested("StartTimeFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.TagFilter != nil {
		if err := s.TagFilter.Validate(); err != nil {
			invalidParams.AddNested("TagFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.TypeFilter != nil {
		if err := s.TypeFilter.Validate(); err != nil {
			invalidParams.AddNested("TypeFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *ListOpenWorkflowExecutionsInput) SetDomain(v string) *ListOpenWorkflowExecutionsInput {
	s.Domain = &v
	return s
}

// SetExecutionFilter sets the ExecutionFilter field's value.
func (s *ListOpenWorkflowExecutionsInput) SetExecutionFilter(v *WorkflowExecutionFilter) *ListOpenWorkflowExecutionsInput {
	s.ExecutionFilter = v
	return s
}

// SetMaximumPageSize sets the MaximumPageSize field's value.
func (s *ListOpenWorkflowExecutionsInput) SetMaximumPageSize(v int64) *ListOpenWorkflowExecutionsInput {
	s.MaximumPageSize = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListOpenWorkflowExecutionsInput) SetNextPageToken(v string) *ListOpenWorkflowExecutionsInput {
	s.NextPageToken = &v
	return s
}

// SetReverseOrder sets the ReverseOrder field's value.
func (s *ListOpenWorkflowExecutionsInput) SetReverseOrder(v bool) *ListOpenWorkflowExecutionsInput {
	s.ReverseOrder = &v
	return s
}

// SetStartTimeFilter sets the StartTimeFilter field's value.
func (s *ListOpenWorkflowExecutionsInput) SetStartTimeFilter(v *ExecutionTimeFilter) *ListOpenWorkflowExecutionsInput {
	s.StartTimeFilter = v
	return s
}

// SetTagFilter sets the TagFilter field's value.
func (s *ListOpenWorkflowExecutionsInput) SetTagFilter(v *TagFilter) *ListOpenWorkflowExecutionsInput {
	s.TagFilter = v
	return s
}

// SetTypeFilter sets the TypeFilter field's value.
func (s *ListOpenWorkflowExecutionsInput) SetTypeFilter(v *WorkflowTypeFilter) *ListOpenWorkflowExecutionsInput {
	s.TypeFilter = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the Amazon SWF domain.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// An array of tags associated with the domain.
	Tags []*ResourceTag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*ResourceTag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListWorkflowTypesInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain in which the workflow types have been registered.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The maximum number of results that are returned per call. Use nextPageToken
	// to obtain further pages of results.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If specified, lists the workflow type with this name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// If NextPageToken is returned there are more results available. The value
	// of NextPageToken is a unique pagination token for each page. Make the call
	// again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged. Each pagination token expires after 60 seconds. Using
	// an expired pagination token will return a 400 error: "Specified token has
	// exceeded its maximum lifetime".
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// Specifies the registration status of the workflow types to list.
	//
	// RegistrationStatus is a required field
	RegistrationStatus *string `locationName:"registrationStatus" type:"string" required:"true" enum:"RegistrationStatus"`

	// When set to true, returns the results in reverse order. By default the results
	// are returned in ascending alphabetical order of the name of the workflow
	// types.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`
}

// String returns the string representation
func (s ListWorkflowTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkflowTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkflowTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkflowTypesInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RegistrationStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("RegistrationStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *ListWorkflowTypesInput) SetDomain(v string) *ListWorkflowTypesInput {
	s.Domain = &v
	return s
}

// SetMaximumPageSize sets the MaximumPageSize field's value.
func (s *ListWorkflowTypesInput) SetMaximumPageSize(v int64) *ListWorkflowTypesInput {
	s.MaximumPageSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListWorkflowTypesInput) SetName(v string) *ListWorkflowTypesInput {
	s.Name = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListWorkflowTypesInput) SetNextPageToken(v string) *ListWorkflowTypesInput {
	s.NextPageToken = &v
	return s
}

// SetRegistrationStatus sets the RegistrationStatus field's value.
func (s *ListWorkflowTypesInput) SetRegistrationStatus(v string) *ListWorkflowTypesInput {
	s.RegistrationStatus = &v
	return s
}

// SetReverseOrder sets the ReverseOrder field's value.
func (s *ListWorkflowTypesInput) SetReverseOrder(v bool) *ListWorkflowTypesInput {
	s.ReverseOrder = &v
	return s
}

// Contains a paginated list of information structures about workflow types.
type ListWorkflowTypesOutput struct {
	_ struct{} `type:"structure"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// The list of workflow type information.
	//
	// TypeInfos is a required field
	TypeInfos []*WorkflowTypeInfo `locationName:"typeInfos" type:"list" required:"true"`
}

// String returns the string representation
func (s ListWorkflowTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorkflowTypesOutput) GoString() string {
	return s.String()
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *ListWorkflowTypesOutput) SetNextPageToken(v string) *ListWorkflowTypesOutput {
	s.NextPageToken = &v
	return s
}

// SetTypeInfos sets the TypeInfos field's value.
func (s *ListWorkflowTypesOutput) SetTypeInfos(v []*WorkflowTypeInfo) *ListWorkflowTypesOutput {
	s.TypeInfos = v
	return s
}

// Provides the details of the MarkerRecorded event.
type MarkerRecordedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RecordMarker decision that requested this marker. This
	// information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The details of the marker.
	Details *string `locationName:"details" type:"string"`

	// The name of the marker.
	//
	// MarkerName is a required field
	MarkerName *string `locationName:"markerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MarkerRecordedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MarkerRecordedEventAttributes) GoString() string {
	return s.String()
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *MarkerRecordedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *MarkerRecordedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *MarkerRecordedEventAttributes) SetDetails(v string) *MarkerRecordedEventAttributes {
	s.Details = &v
	return s
}

// SetMarkerName sets the MarkerName field's value.
func (s *MarkerRecordedEventAttributes) SetMarkerName(v string) *MarkerRecordedEventAttributes {
	s.MarkerName = &v
	return s
}

// Contains the count of tasks in a task list.
type PendingTaskCount struct {
	_ struct{} `type:"structure"`

	// The number of tasks in the task list.
	//
	// Count is a required field
	Count *int64 `locationName:"count" type:"integer" required:"true"`

	// If set to true, indicates that the actual count was more than the maximum
	// supported by this API and the count returned is the truncated value.
	Truncated *bool `locationName:"truncated" type:"boolean"`
}

// String returns the string representation
func (s PendingTaskCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingTaskCount) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *PendingTaskCount) SetCount(v int64) *PendingTaskCount {
	s.Count = &v
	return s
}

// SetTruncated sets the Truncated field's value.
func (s *PendingTaskCount) SetTruncated(v bool) *PendingTaskCount {
	s.Truncated = &v
	return s
}

type PollForActivityTaskInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain that contains the task lists being polled.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// Identity of the worker making the request, recorded in the ActivityTaskStarted
	// event in the workflow history. This enables diagnostic tracing when problems
	// arise. The form of this identity is user defined.
	Identity *string `locationName:"identity" type:"string"`

	// Specifies the task list to poll for activity tasks.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not be the literal string arn.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`
}

// String returns the string representation
func (s PollForActivityTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForActivityTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PollForActivityTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PollForActivityTaskInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.TaskList == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskList"))
	}
	if s.TaskList != nil {
		if err := s.TaskList.Validate(); err != nil {
			invalidParams.AddNested("TaskList", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *PollForActivityTaskInput) SetDomain(v string) *PollForActivityTaskInput {
	s.Domain = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *PollForActivityTaskInput) SetIdentity(v string) *PollForActivityTaskInput {
	s.Identity = &v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *PollForActivityTaskInput) SetTaskList(v *TaskList) *PollForActivityTaskInput {
	s.TaskList = v
	return s
}

// Unit of work sent to an activity worker.
type PollForActivityTaskOutput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the task.
	//
	// ActivityId is a required field
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The type of this activity task.
	//
	// ActivityType is a required field
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// The inputs provided when the activity task was scheduled. The form of the
	// input is user defined and should be meaningful to the activity implementation.
	Input *string `locationName:"input" type:"string"`

	// The ID of the ActivityTaskStarted event recorded in the history.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The opaque string used as a handle on the task. This token is used by workers
	// to communicate progress and response information back to the system about
	// the task.
	//
	// TaskToken is a required field
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`

	// The workflow execution that started this activity task.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`
}

// String returns the string representation
func (s PollForActivityTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForActivityTaskOutput) GoString() string {
	return s.String()
}

// SetActivityId sets the ActivityId field's value.
func (s *PollForActivityTaskOutput) SetActivityId(v string) *PollForActivityTaskOutput {
	s.ActivityId = &v
	return s
}

// SetActivityType sets the ActivityType field's value.
func (s *PollForActivityTaskOutput) SetActivityType(v *ActivityType) *PollForActivityTaskOutput {
	s.ActivityType = v
	return s
}

// SetInput sets the Input field's value.
func (s *PollForActivityTaskOutput) SetInput(v string) *PollForActivityTaskOutput {
	s.Input = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *PollForActivityTaskOutput) SetStartedEventId(v int64) *PollForActivityTaskOutput {
	s.StartedEventId = &v
	return s
}

// SetTaskToken sets the TaskToken field's value.
func (s *PollForActivityTaskOutput) SetTaskToken(v string) *PollForActivityTaskOutput {
	s.TaskToken = &v
	return s
}

// SetWorkflowExecution sets the WorkflowExecution field's value.
func (s *PollForActivityTaskOutput) SetWorkflowExecution(v *WorkflowExecution) *PollForActivityTaskOutput {
	s.WorkflowExecution = v
	return s
}

type PollForDecisionTaskInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the task lists to poll.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// Identity of the decider making the request, which is recorded in the DecisionTaskStarted
	// event in the workflow history. This enables diagnostic tracing when problems
	// arise. The form of this identity is user defined.
	Identity *string `locationName:"identity" type:"string"`

	// The maximum number of results that are returned per call. Use nextPageToken
	// to obtain further pages of results.
	//
	// This is an upper limit only; the actual number of results returned per call
	// may be fewer than the specified maximum.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If NextPageToken is returned there are more results available. The value
	// of NextPageToken is a unique pagination token for each page. Make the call
	// again using the returned token to retrieve the next page. Keep all other
	// arguments unchanged. Each pagination token expires after 60 seconds. Using
	// an expired pagination token will return a 400 error: "Specified token has
	// exceeded its maximum lifetime".
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	//
	// The nextPageToken returned by this action cannot be used with GetWorkflowExecutionHistory
	// to get the next page. You must call PollForDecisionTask again (with the nextPageToken)
	// to retrieve the next page of history records. Calling PollForDecisionTask
	// with a nextPageToken doesn't return a new decision task.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// When set to true, returns the events in reverse order. By default the results
	// are returned in ascending order of the eventTimestamp of the events.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`

	// Specifies the task list to poll for decision tasks.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not be the literal string arn.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`
}

// String returns the string representation
func (s PollForDecisionTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForDecisionTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PollForDecisionTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PollForDecisionTaskInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.TaskList == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskList"))
	}
	if s.TaskList != nil {
		if err := s.TaskList.Validate(); err != nil {
			invalidParams.AddNested("TaskList", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *PollForDecisionTaskInput) SetDomain(v string) *PollForDecisionTaskInput {
	s.Domain = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *PollForDecisionTaskInput) SetIdentity(v string) *PollForDecisionTaskInput {
	s.Identity = &v
	return s
}

// SetMaximumPageSize sets the MaximumPageSize field's value.
func (s *PollForDecisionTaskInput) SetMaximumPageSize(v int64) *PollForDecisionTaskInput {
	s.MaximumPageSize = &v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *PollForDecisionTaskInput) SetNextPageToken(v string) *PollForDecisionTaskInput {
	s.NextPageToken = &v
	return s
}

// SetReverseOrder sets the ReverseOrder field's value.
func (s *PollForDecisionTaskInput) SetReverseOrder(v bool) *PollForDecisionTaskInput {
	s.ReverseOrder = &v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *PollForDecisionTaskInput) SetTaskList(v *TaskList) *PollForDecisionTaskInput {
	s.TaskList = v
	return s
}

// A structure that represents a decision task. Decision tasks are sent to deciders
// in order for them to make decisions.
type PollForDecisionTaskOutput struct {
	_ struct{} `type:"structure"`

	// A paginated list of history events of the workflow execution. The decider
	// uses this during the processing of the decision task.
	//
	// Events is a required field
	Events []*HistoryEvent `locationName:"events" type:"list" required:"true"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// The ID of the DecisionTaskStarted event of the previous decision task of
	// this workflow execution that was processed by the decider. This can be used
	// to determine the events in the history new since the last decision task received
	// by the decider.
	PreviousStartedEventId *int64 `locationName:"previousStartedEventId" type:"long"`

	// The ID of the DecisionTaskStarted event recorded in the history.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The opaque string used as a handle on the task. This token is used by workers
	// to communicate progress and response information back to the system about
	// the task.
	//
	// TaskToken is a required field
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`

	// The workflow execution for which this decision task was created.
	//
	// WorkflowExecution is a required field
	WorkflowExecution *WorkflowExecution `locationName:"workflowExecution" type:"structure" required:"true"`

	// The type of the workflow execution for which this decision task was created.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s PollForDecisionTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForDecisionTaskOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *PollForDecisionTaskOutput) SetEvents(v []*HistoryEvent) *PollForDecisionTaskOutput {
	s.Events = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *PollForDecisionTaskOutput) SetNextPageToken(v string) *PollForDecisionTaskOutput {
	s.NextPageToken = &v
	return s
}

// SetPreviousStartedEventId sets the PreviousStartedEventId field's value.
func (s *PollForDecisionTaskOutput) SetPreviousStartedEventId(v int64) *PollForDecisionTaskOutput {
	s.PreviousStartedEventId = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *PollForDecisionTaskOutput) SetStartedEventId(v int64) *PollForDecisionTaskOutput {
	s.StartedEventId = &v
	return s
}

// SetTaskToken sets the TaskToken field's value.
func (s *PollForDecisionTaskOutput) SetTaskToken(v string) *PollForDecisionTaskOutput {
	s.TaskToken = &v
	return s
}

// SetWorkflowExecution sets the WorkflowExecution field's value.
func (s *PollForDecisionTaskOutput) SetWorkflowExecution(v *WorkflowExecution) *PollForDecisionTaskOutput {
	s.WorkflowExecution = v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *PollForDecisionTaskOutput) SetWorkflowType(v *WorkflowType) *PollForDecisionTaskOutput {
	s.WorkflowType = v
	return s
}

type RecordActivityTaskHeartbeatInput struct {
	_ struct{} `type:"structure"`

	// If specified, contains details about the progress of the task.
	Details *string `locationName:"details" type:"string"`

	// The taskToken of the ActivityTask.
	//
	// taskToken is generated by the service and should be treated as an opaque
	// value. If the task is passed to another process, its taskToken must also
	// be passed. This enables it to provide its progress and respond with results.
	//
	// TaskToken is a required field
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RecordActivityTaskHeartbeatInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordActivityTaskHeartbeatInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordActivityTaskHeartbeatInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecordActivityTaskHeartbeatInput"}
	if s.TaskToken == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskToken"))
	}
	if s.TaskToken != nil && len(*s.TaskToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetails sets the Details field's value.
func (s *RecordActivityTaskHeartbeatInput) SetDetails(v string) *RecordActivityTaskHeartbeatInput {
	s.Details = &v
	return s
}

// SetTaskToken sets the TaskToken field's value.
func (s *RecordActivityTaskHeartbeatInput) SetTaskToken(v string) *RecordActivityTaskHeartbeatInput {
	s.TaskToken = &v
	return s
}

// Status information about an activity task.
type RecordActivityTaskHeartbeatOutput struct {
	_ struct{} `type:"structure"`

	// Set to true if cancellation of the task is requested.
	//
	// CancelRequested is a required field
	CancelRequested *bool `locationName:"cancelRequested" type:"boolean" required:"true"`
}

// String returns the string representation
func (s RecordActivityTaskHeartbeatOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordActivityTaskHeartbeatOutput) GoString() string {
	return s.String()
}

// SetCancelRequested sets the CancelRequested field's value.
func (s *RecordActivityTaskHeartbeatOutput) SetCancelRequested(v bool) *RecordActivityTaskHeartbeatOutput {
	s.CancelRequested = &v
	return s
}

// Provides the details of the RecordMarker decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type RecordMarkerDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The details of the marker.
	Details *string `locationName:"details" type:"string"`

	// The name of the marker.
	//
	// MarkerName is a required field
	MarkerName *string `locationName:"markerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RecordMarkerDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordMarkerDecisionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordMarkerDecisionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecordMarkerDecisionAttributes"}
	if s.MarkerName == nil {
		invalidParams.Add(request.NewErrParamRequired("MarkerName"))
	}
	if s.MarkerName != nil && len(*s.MarkerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MarkerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetails sets the Details field's value.
func (s *RecordMarkerDecisionAttributes) SetDetails(v string) *RecordMarkerDecisionAttributes {
	s.Details = &v
	return s
}

// SetMarkerName sets the MarkerName field's value.
func (s *RecordMarkerDecisionAttributes) SetMarkerName(v string) *RecordMarkerDecisionAttributes {
	s.MarkerName = &v
	return s
}

// Provides the details of the RecordMarkerFailed event.
type RecordMarkerFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"RecordMarkerFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RecordMarkerFailed decision for this cancellation request.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The marker's name.
	//
	// MarkerName is a required field
	MarkerName *string `locationName:"markerName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RecordMarkerFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordMarkerFailedEventAttributes) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *RecordMarkerFailedEventAttributes) SetCause(v string) *RecordMarkerFailedEventAttributes {
	s.Cause = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *RecordMarkerFailedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *RecordMarkerFailedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetMarkerName sets the MarkerName field's value.
func (s *RecordMarkerFailedEventAttributes) SetMarkerName(v string) *RecordMarkerFailedEventAttributes {
	s.MarkerName = &v
	return s
}

type RegisterActivityTypeInput struct {
	_ struct{} `type:"structure"`

	// If set, specifies the default maximum time before which a worker processing
	// a task of this type must report progress by calling RecordActivityTaskHeartbeat.
	// If the timeout is exceeded, the activity task is automatically timed out.
	// This default can be overridden when scheduling an activity task using the
	// ScheduleActivityTask Decision. If the activity worker subsequently attempts
	// to record a heartbeat or returns a result, the activity worker receives an
	// UnknownResource fault. In this case, Amazon SWF no longer considers the activity
	// task to be valid; the activity worker should clean up the activity task.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultTaskHeartbeatTimeout *string `locationName:"defaultTaskHeartbeatTimeout" type:"string"`

	// If set, specifies the default task list to use for scheduling tasks of this
	// activity type. This default task list is used if a task list isn't provided
	// when a task is scheduled through the ScheduleActivityTask Decision.
	DefaultTaskList *TaskList `locationName:"defaultTaskList" type:"structure"`

	// The default task priority to assign to the activity type. If not assigned,
	// then 0 is used. Valid values are integers that range from Java's Integer.MIN_VALUE
	// (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate
	// higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the in the Amazon SWF Developer Guide..
	DefaultTaskPriority *string `locationName:"defaultTaskPriority" type:"string"`

	// If set, specifies the default maximum duration for a task of this activity
	// type. This default can be overridden when scheduling an activity task using
	// the ScheduleActivityTask Decision.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultTaskScheduleToCloseTimeout *string `locationName:"defaultTaskScheduleToCloseTimeout" type:"string"`

	// If set, specifies the default maximum duration that a task of this activity
	// type can wait before being assigned to a worker. This default can be overridden
	// when scheduling an activity task using the ScheduleActivityTask Decision.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultTaskScheduleToStartTimeout *string `locationName:"defaultTaskScheduleToStartTimeout" type:"string"`

	// If set, specifies the default maximum duration that a worker can take to
	// process tasks of this activity type. This default can be overridden when
	// scheduling an activity task using the ScheduleActivityTask Decision.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultTaskStartToCloseTimeout *string `locationName:"defaultTaskStartToCloseTimeout" type:"string"`

	// A textual description of the activity type.
	Description *string `locationName:"description" type:"string"`

	// The name of the domain in which this activity is to be registered.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The name of the activity type within the domain.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not be the literal string arn.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The version of the activity type.
	//
	// The activity type consists of the name and version, the combination of which
	// must be unique within the domain.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not be the literal string arn.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterActivityTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterActivityTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterActivityTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterActivityTypeInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}
	if s.DefaultTaskList != nil {
		if err := s.DefaultTaskList.Validate(); err != nil {
			invalidParams.AddNested("DefaultTaskList", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultTaskHeartbeatTimeout sets the DefaultTaskHeartbeatTimeout field's value.
func (s *RegisterActivityTypeInput) SetDefaultTaskHeartbeatTimeout(v string) *RegisterActivityTypeInput {
	s.DefaultTaskHeartbeatTimeout = &v
	return s
}

// SetDefaultTaskList sets the DefaultTaskList field's value.
func (s *RegisterActivityTypeInput) SetDefaultTaskList(v *TaskList) *RegisterActivityTypeInput {
	s.DefaultTaskList = v
	return s
}

// SetDefaultTaskPriority sets the DefaultTaskPriority field's value.
func (s *RegisterActivityTypeInput) SetDefaultTaskPriority(v string) *RegisterActivityTypeInput {
	s.DefaultTaskPriority = &v
	return s
}

// SetDefaultTaskScheduleToCloseTimeout sets the DefaultTaskScheduleToCloseTimeout field's value.
func (s *RegisterActivityTypeInput) SetDefaultTaskScheduleToCloseTimeout(v string) *RegisterActivityTypeInput {
	s.DefaultTaskScheduleToCloseTimeout = &v
	return s
}

// SetDefaultTaskScheduleToStartTimeout sets the DefaultTaskScheduleToStartTimeout field's value.
func (s *RegisterActivityTypeInput) SetDefaultTaskScheduleToStartTimeout(v string) *RegisterActivityTypeInput {
	s.DefaultTaskScheduleToStartTimeout = &v
	return s
}

// SetDefaultTaskStartToCloseTimeout sets the DefaultTaskStartToCloseTimeout field's value.
func (s *RegisterActivityTypeInput) SetDefaultTaskStartToCloseTimeout(v string) *RegisterActivityTypeInput {
	s.DefaultTaskStartToCloseTimeout = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RegisterActivityTypeInput) SetDescription(v string) *RegisterActivityTypeInput {
	s.Description = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *RegisterActivityTypeInput) SetDomain(v string) *RegisterActivityTypeInput {
	s.Domain = &v
	return s
}

// SetName sets the Name field's value.
func (s *RegisterActivityTypeInput) SetName(v string) *RegisterActivityTypeInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *RegisterActivityTypeInput) SetVersion(v string) *RegisterActivityTypeInput {
	s.Version = &v
	return s
}

type RegisterActivityTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterActivityTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterActivityTypeOutput) GoString() string {
	return s.String()
}

type RegisterDomainInput struct {
	_ struct{} `type:"structure"`

	// A text description of the domain.
	Description *string `locationName:"description" type:"string"`

	// Name of the domain to register. The name must be unique in the region that
	// the domain is registered in.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not be the literal string arn.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Tags to be added when registering a domain.
	//
	// Tags may only contain unicode letters, digits, whitespace, or these symbols:
	// _ . : / = + - @.
	Tags []*ResourceTag `locationName:"tags" type:"list"`

	// The duration (in days) that records and histories of workflow executions
	// on the domain should be kept by the service. After the retention period,
	// the workflow execution isn't available in the results of visibility calls.
	//
	// If you pass the value NONE or 0 (zero), then the workflow execution history
	// isn't retained. As soon as the workflow execution completes, the execution
	// record and its history are deleted.
	//
	// The maximum workflow execution retention period is 90 days. For more information
	// about Amazon SWF service limits, see: Amazon SWF Service Limits (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dg-limits.html)
	// in the Amazon SWF Developer Guide.
	//
	// WorkflowExecutionRetentionPeriodInDays is a required field
	WorkflowExecutionRetentionPeriodInDays *string `locationName:"workflowExecutionRetentionPeriodInDays" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterDomainInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.WorkflowExecutionRetentionPeriodInDays == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowExecutionRetentionPeriodInDays"))
	}
	if s.WorkflowExecutionRetentionPeriodInDays != nil && len(*s.WorkflowExecutionRetentionPeriodInDays) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowExecutionRetentionPeriodInDays", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *RegisterDomainInput) SetDescription(v string) *RegisterDomainInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *RegisterDomainInput) SetName(v string) *RegisterDomainInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RegisterDomainInput) SetTags(v []*ResourceTag) *RegisterDomainInput {
	s.Tags = v
	return s
}

// SetWorkflowExecutionRetentionPeriodInDays sets the WorkflowExecutionRetentionPeriodInDays field's value.
func (s *RegisterDomainInput) SetWorkflowExecutionRetentionPeriodInDays(v string) *RegisterDomainInput {
	s.WorkflowExecutionRetentionPeriodInDays = &v
	return s
}

type RegisterDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterDomainOutput) GoString() string {
	return s.String()
}

type RegisterWorkflowTypeInput struct {
	_ struct{} `type:"structure"`

	// If set, specifies the default policy to use for the child workflow executions
	// when a workflow execution of this type is terminated, by calling the TerminateWorkflowExecution
	// action explicitly or due to an expired timeout. This default can be overridden
	// when starting a workflow execution using the StartWorkflowExecution action
	// or the StartChildWorkflowExecution Decision.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	DefaultChildPolicy *string `locationName:"defaultChildPolicy" type:"string" enum:"ChildPolicy"`

	// If set, specifies the default maximum duration for executions of this workflow
	// type. You can override this default when starting an execution through the
	// StartWorkflowExecution Action or StartChildWorkflowExecution Decision.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. Unlike some of the other timeout parameters in Amazon SWF, you cannot
	// specify a value of "NONE" for defaultExecutionStartToCloseTimeout; there
	// is a one-year max limit on the time that a workflow execution can run. Exceeding
	// this limit always causes the workflow execution to time out.
	DefaultExecutionStartToCloseTimeout *string `locationName:"defaultExecutionStartToCloseTimeout" type:"string"`

	// The default IAM role attached to this workflow type.
	//
	// Executions of this workflow type need IAM roles to invoke Lambda functions.
	// If you don't specify an IAM role when you start this workflow type, the default
	// Lambda role is attached to the execution. For more information, see https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html)
	// in the Amazon SWF Developer Guide.
	DefaultLambdaRole *string `locationName:"defaultLambdaRole" min:"1" type:"string"`

	// If set, specifies the default task list to use for scheduling decision tasks
	// for executions of this workflow type. This default is used only if a task
	// list isn't provided when starting the execution through the StartWorkflowExecution
	// Action or StartChildWorkflowExecution Decision.
	DefaultTaskList *TaskList `locationName:"defaultTaskList" type:"structure"`

	// The default task priority to assign to the workflow type. If not assigned,
	// then 0 is used. Valid values are integers that range from Java's Integer.MIN_VALUE
	// (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate
	// higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	DefaultTaskPriority *string `locationName:"defaultTaskPriority" type:"string"`

	// If set, specifies the default maximum duration of decision tasks for this
	// workflow type. This default can be overridden when starting a workflow execution
	// using the StartWorkflowExecution action or the StartChildWorkflowExecution
	// Decision.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultTaskStartToCloseTimeout *string `locationName:"defaultTaskStartToCloseTimeout" type:"string"`

	// Textual description of the workflow type.
	Description *string `locationName:"description" type:"string"`

	// The name of the domain in which to register the workflow type.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The name of the workflow type.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not be the literal string arn.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The version of the workflow type.
	//
	// The workflow type consists of the name and version, the combination of which
	// must be unique within the domain. To get a list of all currently registered
	// workflow types, use the ListWorkflowTypes action.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not be the literal string arn.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterWorkflowTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterWorkflowTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterWorkflowTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterWorkflowTypeInput"}
	if s.DefaultLambdaRole != nil && len(*s.DefaultLambdaRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultLambdaRole", 1))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}
	if s.DefaultTaskList != nil {
		if err := s.DefaultTaskList.Validate(); err != nil {
			invalidParams.AddNested("DefaultTaskList", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultChildPolicy sets the DefaultChildPolicy field's value.
func (s *RegisterWorkflowTypeInput) SetDefaultChildPolicy(v string) *RegisterWorkflowTypeInput {
	s.DefaultChildPolicy = &v
	return s
}

// SetDefaultExecutionStartToCloseTimeout sets the DefaultExecutionStartToCloseTimeout field's value.
func (s *RegisterWorkflowTypeInput) SetDefaultExecutionStartToCloseTimeout(v string) *RegisterWorkflowTypeInput {
	s.DefaultExecutionStartToCloseTimeout = &v
	return s
}

// SetDefaultLambdaRole sets the DefaultLambdaRole field's value.
func (s *RegisterWorkflowTypeInput) SetDefaultLambdaRole(v string) *RegisterWorkflowTypeInput {
	s.DefaultLambdaRole = &v
	return s
}

// SetDefaultTaskList sets the DefaultTaskList field's value.
func (s *RegisterWorkflowTypeInput) SetDefaultTaskList(v *TaskList) *RegisterWorkflowTypeInput {
	s.DefaultTaskList = v
	return s
}

// SetDefaultTaskPriority sets the DefaultTaskPriority field's value.
func (s *RegisterWorkflowTypeInput) SetDefaultTaskPriority(v string) *RegisterWorkflowTypeInput {
	s.DefaultTaskPriority = &v
	return s
}

// SetDefaultTaskStartToCloseTimeout sets the DefaultTaskStartToCloseTimeout field's value.
func (s *RegisterWorkflowTypeInput) SetDefaultTaskStartToCloseTimeout(v string) *RegisterWorkflowTypeInput {
	s.DefaultTaskStartToCloseTimeout = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RegisterWorkflowTypeInput) SetDescription(v string) *RegisterWorkflowTypeInput {
	s.Description = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *RegisterWorkflowTypeInput) SetDomain(v string) *RegisterWorkflowTypeInput {
	s.Domain = &v
	return s
}

// SetName sets the Name field's value.
func (s *RegisterWorkflowTypeInput) SetName(v string) *RegisterWorkflowTypeInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *RegisterWorkflowTypeInput) SetVersion(v string) *RegisterWorkflowTypeInput {
	s.Version = &v
	return s
}

type RegisterWorkflowTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterWorkflowTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterWorkflowTypeOutput) GoString() string {
	return s.String()
}

// Provides the details of the RequestCancelActivityTask decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type RequestCancelActivityTaskDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The activityId of the activity task to be canceled.
	//
	// ActivityId is a required field
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestCancelActivityTaskDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCancelActivityTaskDecisionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestCancelActivityTaskDecisionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequestCancelActivityTaskDecisionAttributes"}
	if s.ActivityId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivityId"))
	}
	if s.ActivityId != nil && len(*s.ActivityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActivityId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityId sets the ActivityId field's value.
func (s *RequestCancelActivityTaskDecisionAttributes) SetActivityId(v string) *RequestCancelActivityTaskDecisionAttributes {
	s.ActivityId = &v
	return s
}

// Provides the details of the RequestCancelActivityTaskFailed event.
type RequestCancelActivityTaskFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The activityId provided in the RequestCancelActivityTask decision that failed.
	//
	// ActivityId is a required field
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"RequestCancelActivityTaskFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelActivityTask decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s RequestCancelActivityTaskFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCancelActivityTaskFailedEventAttributes) GoString() string {
	return s.String()
}

// SetActivityId sets the ActivityId field's value.
func (s *RequestCancelActivityTaskFailedEventAttributes) SetActivityId(v string) *RequestCancelActivityTaskFailedEventAttributes {
	s.ActivityId = &v
	return s
}

// SetCause sets the Cause field's value.
func (s *RequestCancelActivityTaskFailedEventAttributes) SetCause(v string) *RequestCancelActivityTaskFailedEventAttributes {
	s.Cause = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *RequestCancelActivityTaskFailedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *RequestCancelActivityTaskFailedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// Provides the details of the RequestCancelExternalWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type RequestCancelExternalWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string `locationName:"control" type:"string"`

	// The runId of the external workflow execution to cancel.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the external workflow execution to cancel.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestCancelExternalWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCancelExternalWorkflowExecutionDecisionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestCancelExternalWorkflowExecutionDecisionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequestCancelExternalWorkflowExecutionDecisionAttributes"}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControl sets the Control field's value.
func (s *RequestCancelExternalWorkflowExecutionDecisionAttributes) SetControl(v string) *RequestCancelExternalWorkflowExecutionDecisionAttributes {
	s.Control = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *RequestCancelExternalWorkflowExecutionDecisionAttributes) SetRunId(v string) *RequestCancelExternalWorkflowExecutionDecisionAttributes {
	s.RunId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *RequestCancelExternalWorkflowExecutionDecisionAttributes) SetWorkflowId(v string) *RequestCancelExternalWorkflowExecutionDecisionAttributes {
	s.WorkflowId = &v
	return s
}

// Provides the details of the RequestCancelExternalWorkflowExecutionFailed
// event.
type RequestCancelExternalWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"RequestCancelExternalWorkflowExecutionFailedCause"`

	// The data attached to the event that the decider can use in subsequent workflow
	// tasks. This data isn't sent to the workflow execution.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelExternalWorkflowExecution decision for
	// this cancellation request. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The ID of the RequestCancelExternalWorkflowExecutionInitiated event corresponding
	// to the RequestCancelExternalWorkflowExecution decision to cancel this external
	// workflow execution. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The runId of the external workflow execution.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the external workflow to which the cancel request was to
	// be delivered.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestCancelExternalWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCancelExternalWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *RequestCancelExternalWorkflowExecutionFailedEventAttributes) SetCause(v string) *RequestCancelExternalWorkflowExecutionFailedEventAttributes {
	s.Cause = &v
	return s
}

// SetControl sets the Control field's value.
func (s *RequestCancelExternalWorkflowExecutionFailedEventAttributes) SetControl(v string) *RequestCancelExternalWorkflowExecutionFailedEventAttributes {
	s.Control = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *RequestCancelExternalWorkflowExecutionFailedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *RequestCancelExternalWorkflowExecutionFailedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetInitiatedEventId sets the InitiatedEventId field's value.
func (s *RequestCancelExternalWorkflowExecutionFailedEventAttributes) SetInitiatedEventId(v int64) *RequestCancelExternalWorkflowExecutionFailedEventAttributes {
	s.InitiatedEventId = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *RequestCancelExternalWorkflowExecutionFailedEventAttributes) SetRunId(v string) *RequestCancelExternalWorkflowExecutionFailedEventAttributes {
	s.RunId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *RequestCancelExternalWorkflowExecutionFailedEventAttributes) SetWorkflowId(v string) *RequestCancelExternalWorkflowExecutionFailedEventAttributes {
	s.WorkflowId = &v
	return s
}

// Provides the details of the RequestCancelExternalWorkflowExecutionInitiated
// event.
type RequestCancelExternalWorkflowExecutionInitiatedEventAttributes struct {
	_ struct{} `type:"structure"`

	// Data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelExternalWorkflowExecution decision for
	// this cancellation request. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The runId of the external workflow execution to be canceled.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the external workflow execution to be canceled.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) GoString() string {
	return s.String()
}

// SetControl sets the Control field's value.
func (s *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) SetControl(v string) *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes {
	s.Control = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) SetRunId(v string) *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes {
	s.RunId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes) SetWorkflowId(v string) *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes {
	s.WorkflowId = &v
	return s
}

type RequestCancelWorkflowExecutionInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the workflow execution to cancel.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The runId of the workflow execution to cancel.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the workflow execution to cancel.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RequestCancelWorkflowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCancelWorkflowExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RequestCancelWorkflowExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RequestCancelWorkflowExecutionInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *RequestCancelWorkflowExecutionInput) SetDomain(v string) *RequestCancelWorkflowExecutionInput {
	s.Domain = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *RequestCancelWorkflowExecutionInput) SetRunId(v string) *RequestCancelWorkflowExecutionInput {
	s.RunId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *RequestCancelWorkflowExecutionInput) SetWorkflowId(v string) *RequestCancelWorkflowExecutionInput {
	s.WorkflowId = &v
	return s
}

type RequestCancelWorkflowExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RequestCancelWorkflowExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestCancelWorkflowExecutionOutput) GoString() string {
	return s.String()
}

// Tags are key-value pairs that can be associated with Amazon SWF state machines
// and activities.
//
// Tags may only contain unicode letters, digits, whitespace, or these symbols:
// _ . : / = + - @.
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// The key of a tag.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value of a tag.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceTag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceTag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *ResourceTag) SetKey(v string) *ResourceTag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceTag) SetValue(v string) *ResourceTag {
	s.Value = &v
	return s
}

type RespondActivityTaskCanceledInput struct {
	_ struct{} `type:"structure"`

	// Information about the cancellation.
	Details *string `locationName:"details" type:"string"`

	// The taskToken of the ActivityTask.
	//
	// taskToken is generated by the service and should be treated as an opaque
	// value. If the task is passed to another process, its taskToken must also
	// be passed. This enables it to provide its progress and respond with results.
	//
	// TaskToken is a required field
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RespondActivityTaskCanceledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondActivityTaskCanceledInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RespondActivityTaskCanceledInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RespondActivityTaskCanceledInput"}
	if s.TaskToken == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskToken"))
	}
	if s.TaskToken != nil && len(*s.TaskToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetails sets the Details field's value.
func (s *RespondActivityTaskCanceledInput) SetDetails(v string) *RespondActivityTaskCanceledInput {
	s.Details = &v
	return s
}

// SetTaskToken sets the TaskToken field's value.
func (s *RespondActivityTaskCanceledInput) SetTaskToken(v string) *RespondActivityTaskCanceledInput {
	s.TaskToken = &v
	return s
}

type RespondActivityTaskCanceledOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RespondActivityTaskCanceledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondActivityTaskCanceledOutput) GoString() string {
	return s.String()
}

type RespondActivityTaskCompletedInput struct {
	_ struct{} `type:"structure"`

	// The result of the activity task. It is a free form string that is implementation
	// specific.
	Result *string `locationName:"result" type:"string"`

	// The taskToken of the ActivityTask.
	//
	// taskToken is generated by the service and should be treated as an opaque
	// value. If the task is passed to another process, its taskToken must also
	// be passed. This enables it to provide its progress and respond with results.
	//
	// TaskToken is a required field
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RespondActivityTaskCompletedInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondActivityTaskCompletedInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RespondActivityTaskCompletedInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RespondActivityTaskCompletedInput"}
	if s.TaskToken == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskToken"))
	}
	if s.TaskToken != nil && len(*s.TaskToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResult sets the Result field's value.
func (s *RespondActivityTaskCompletedInput) SetResult(v string) *RespondActivityTaskCompletedInput {
	s.Result = &v
	return s
}

// SetTaskToken sets the TaskToken field's value.
func (s *RespondActivityTaskCompletedInput) SetTaskToken(v string) *RespondActivityTaskCompletedInput {
	s.TaskToken = &v
	return s
}

type RespondActivityTaskCompletedOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RespondActivityTaskCompletedOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondActivityTaskCompletedOutput) GoString() string {
	return s.String()
}

type RespondActivityTaskFailedInput struct {
	_ struct{} `type:"structure"`

	// Detailed information about the failure.
	Details *string `locationName:"details" type:"string"`

	// Description of the error that may assist in diagnostics.
	Reason *string `locationName:"reason" type:"string"`

	// The taskToken of the ActivityTask.
	//
	// taskToken is generated by the service and should be treated as an opaque
	// value. If the task is passed to another process, its taskToken must also
	// be passed. This enables it to provide its progress and respond with results.
	//
	// TaskToken is a required field
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RespondActivityTaskFailedInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondActivityTaskFailedInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RespondActivityTaskFailedInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RespondActivityTaskFailedInput"}
	if s.TaskToken == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskToken"))
	}
	if s.TaskToken != nil && len(*s.TaskToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetails sets the Details field's value.
func (s *RespondActivityTaskFailedInput) SetDetails(v string) *RespondActivityTaskFailedInput {
	s.Details = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *RespondActivityTaskFailedInput) SetReason(v string) *RespondActivityTaskFailedInput {
	s.Reason = &v
	return s
}

// SetTaskToken sets the TaskToken field's value.
func (s *RespondActivityTaskFailedInput) SetTaskToken(v string) *RespondActivityTaskFailedInput {
	s.TaskToken = &v
	return s
}

type RespondActivityTaskFailedOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RespondActivityTaskFailedOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondActivityTaskFailedOutput) GoString() string {
	return s.String()
}

// Input data for a TaskCompleted response to a decision task.
type RespondDecisionTaskCompletedInput struct {
	_ struct{} `type:"structure"`

	// The list of decisions (possibly empty) made by the decider while processing
	// this decision task. See the docs for the Decision structure for details.
	Decisions []*Decision `locationName:"decisions" type:"list"`

	// User defined context to add to workflow execution.
	ExecutionContext *string `locationName:"executionContext" type:"string"`

	// The taskToken from the DecisionTask.
	//
	// taskToken is generated by the service and should be treated as an opaque
	// value. If the task is passed to another process, its taskToken must also
	// be passed. This enables it to provide its progress and respond with results.
	//
	// TaskToken is a required field
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RespondDecisionTaskCompletedInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondDecisionTaskCompletedInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RespondDecisionTaskCompletedInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RespondDecisionTaskCompletedInput"}
	if s.TaskToken == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskToken"))
	}
	if s.TaskToken != nil && len(*s.TaskToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskToken", 1))
	}
	if s.Decisions != nil {
		for i, v := range s.Decisions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Decisions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecisions sets the Decisions field's value.
func (s *RespondDecisionTaskCompletedInput) SetDecisions(v []*Decision) *RespondDecisionTaskCompletedInput {
	s.Decisions = v
	return s
}

// SetExecutionContext sets the ExecutionContext field's value.
func (s *RespondDecisionTaskCompletedInput) SetExecutionContext(v string) *RespondDecisionTaskCompletedInput {
	s.ExecutionContext = &v
	return s
}

// SetTaskToken sets the TaskToken field's value.
func (s *RespondDecisionTaskCompletedInput) SetTaskToken(v string) *RespondDecisionTaskCompletedInput {
	s.TaskToken = &v
	return s
}

type RespondDecisionTaskCompletedOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RespondDecisionTaskCompletedOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RespondDecisionTaskCompletedOutput) GoString() string {
	return s.String()
}

// Provides the details of the ScheduleActivityTask decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. activityType.name – String constraint. The key
//    is swf:activityType.name. activityType.version – String constraint.
//    The key is swf:activityType.version. taskList – String constraint. The
//    key is swf:taskList.name.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type ScheduleActivityTaskDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The activityId of the activity task.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not contain the literal string arn.
	//
	// ActivityId is a required field
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The type of the activity task to schedule.
	//
	// ActivityType is a required field
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// Data attached to the event that can be used by the decider in subsequent
	// workflow tasks. This data isn't sent to the activity.
	Control *string `locationName:"control" type:"string"`

	// If set, specifies the maximum time before which a worker processing a task
	// of this type must report progress by calling RecordActivityTaskHeartbeat.
	// If the timeout is exceeded, the activity task is automatically timed out.
	// If the worker subsequently attempts to record a heartbeat or returns a result,
	// it is ignored. This overrides the default heartbeat timeout specified when
	// registering the activity type using RegisterActivityType.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	HeartbeatTimeout *string `locationName:"heartbeatTimeout" type:"string"`

	// The input provided to the activity task.
	Input *string `locationName:"input" type:"string"`

	// The maximum duration for this activity task.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// A schedule-to-close timeout for this activity task must be specified either
	// as a default for the activity type or through this field. If neither this
	// field is set nor a default schedule-to-close timeout was specified at registration
	// time then a fault is returned.
	ScheduleToCloseTimeout *string `locationName:"scheduleToCloseTimeout" type:"string"`

	// If set, specifies the maximum duration the activity task can wait to be assigned
	// to a worker. This overrides the default schedule-to-start timeout specified
	// when registering the activity type using RegisterActivityType.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// A schedule-to-start timeout for this activity task must be specified either
	// as a default for the activity type or through this field. If neither this
	// field is set nor a default schedule-to-start timeout was specified at registration
	// time then a fault is returned.
	ScheduleToStartTimeout *string `locationName:"scheduleToStartTimeout" type:"string"`

	// If set, specifies the maximum duration a worker may take to process this
	// activity task. This overrides the default start-to-close timeout specified
	// when registering the activity type using RegisterActivityType.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// A start-to-close timeout for this activity task must be specified either
	// as a default for the activity type or through this field. If neither this
	// field is set nor a default start-to-close timeout was specified at registration
	// time then a fault is returned.
	StartToCloseTimeout *string `locationName:"startToCloseTimeout" type:"string"`

	// If set, specifies the name of the task list in which to schedule the activity
	// task. If not specified, the defaultTaskList registered with the activity
	// type is used.
	//
	// A task list for this activity task must be specified either as a default
	// for the activity type or through this field. If neither this field is set
	// nor a default task list was specified at registration time then a fault is
	// returned.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not contain the literal string arn.
	TaskList *TaskList `locationName:"taskList" type:"structure"`

	// If set, specifies the priority with which the activity task is to be assigned
	// to a worker. This overrides the defaultTaskPriority specified when registering
	// the activity type using RegisterActivityType. Valid values are integers that
	// range from Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647).
	// Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`
}

// String returns the string representation
func (s ScheduleActivityTaskDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleActivityTaskDecisionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleActivityTaskDecisionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleActivityTaskDecisionAttributes"}
	if s.ActivityId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivityId"))
	}
	if s.ActivityId != nil && len(*s.ActivityId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActivityId", 1))
	}
	if s.ActivityType == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivityType"))
	}
	if s.ActivityType != nil {
		if err := s.ActivityType.Validate(); err != nil {
			invalidParams.AddNested("ActivityType", err.(request.ErrInvalidParams))
		}
	}
	if s.TaskList != nil {
		if err := s.TaskList.Validate(); err != nil {
			invalidParams.AddNested("TaskList", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityId sets the ActivityId field's value.
func (s *ScheduleActivityTaskDecisionAttributes) SetActivityId(v string) *ScheduleActivityTaskDecisionAttributes {
	s.ActivityId = &v
	return s
}

// SetActivityType sets the ActivityType field's value.
func (s *ScheduleActivityTaskDecisionAttributes) SetActivityType(v *ActivityType) *ScheduleActivityTaskDecisionAttributes {
	s.ActivityType = v
	return s
}

// SetControl sets the Control field's value.
func (s *ScheduleActivityTaskDecisionAttributes) SetControl(v string) *ScheduleActivityTaskDecisionAttributes {
	s.Control = &v
	return s
}

// SetHeartbeatTimeout sets the HeartbeatTimeout field's value.
func (s *ScheduleActivityTaskDecisionAttributes) SetHeartbeatTimeout(v string) *ScheduleActivityTaskDecisionAttributes {
	s.HeartbeatTimeout = &v
	return s
}

// SetInput sets the Input field's value.
func (s *ScheduleActivityTaskDecisionAttributes) SetInput(v string) *ScheduleActivityTaskDecisionAttributes {
	s.Input = &v
	return s
}

// SetScheduleToCloseTimeout sets the ScheduleToCloseTimeout field's value.
func (s *ScheduleActivityTaskDecisionAttributes) SetScheduleToCloseTimeout(v string) *ScheduleActivityTaskDecisionAttributes {
	s.ScheduleToCloseTimeout = &v
	return s
}

// SetScheduleToStartTimeout sets the ScheduleToStartTimeout field's value.
func (s *ScheduleActivityTaskDecisionAttributes) SetScheduleToStartTimeout(v string) *ScheduleActivityTaskDecisionAttributes {
	s.ScheduleToStartTimeout = &v
	return s
}

// SetStartToCloseTimeout sets the StartToCloseTimeout field's value.
func (s *ScheduleActivityTaskDecisionAttributes) SetStartToCloseTimeout(v string) *ScheduleActivityTaskDecisionAttributes {
	s.StartToCloseTimeout = &v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *ScheduleActivityTaskDecisionAttributes) SetTaskList(v *TaskList) *ScheduleActivityTaskDecisionAttributes {
	s.TaskList = v
	return s
}

// SetTaskPriority sets the TaskPriority field's value.
func (s *ScheduleActivityTaskDecisionAttributes) SetTaskPriority(v string) *ScheduleActivityTaskDecisionAttributes {
	s.TaskPriority = &v
	return s
}

// Provides the details of the ScheduleActivityTaskFailed event.
type ScheduleActivityTaskFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The activityId provided in the ScheduleActivityTask decision that failed.
	//
	// ActivityId is a required field
	ActivityId *string `locationName:"activityId" min:"1" type:"string" required:"true"`

	// The activity type provided in the ScheduleActivityTask decision that failed.
	//
	// ActivityType is a required field
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"ScheduleActivityTaskFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision that
	// resulted in the scheduling of this activity task. This information can be
	// useful for diagnosing problems by tracing back the chain of events leading
	// up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`
}

// String returns the string representation
func (s ScheduleActivityTaskFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleActivityTaskFailedEventAttributes) GoString() string {
	return s.String()
}

// SetActivityId sets the ActivityId field's value.
func (s *ScheduleActivityTaskFailedEventAttributes) SetActivityId(v string) *ScheduleActivityTaskFailedEventAttributes {
	s.ActivityId = &v
	return s
}

// SetActivityType sets the ActivityType field's value.
func (s *ScheduleActivityTaskFailedEventAttributes) SetActivityType(v *ActivityType) *ScheduleActivityTaskFailedEventAttributes {
	s.ActivityType = v
	return s
}

// SetCause sets the Cause field's value.
func (s *ScheduleActivityTaskFailedEventAttributes) SetCause(v string) *ScheduleActivityTaskFailedEventAttributes {
	s.Cause = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *ScheduleActivityTaskFailedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *ScheduleActivityTaskFailedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// Decision attributes specified in scheduleLambdaFunctionDecisionAttributes
// within the list of decisions decisions passed to RespondDecisionTaskCompleted.
type ScheduleLambdaFunctionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The data attached to the event that the decider can use in subsequent workflow
	// tasks. This data isn't sent to the Lambda task.
	Control *string `locationName:"control" type:"string"`

	// A string that identifies the Lambda function execution in the event history.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The optional input data to be supplied to the Lambda function.
	Input *string `locationName:"input" type:"string"`

	// The name, or ARN, of the Lambda function to schedule.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The timeout value, in seconds, after which the Lambda function is considered
	// to be failed once it has started. This can be any integer from 1-300 (1s-5m).
	// If no value is supplied, than a default value of 300s is assumed.
	StartToCloseTimeout *string `locationName:"startToCloseTimeout" type:"string"`
}

// String returns the string representation
func (s ScheduleLambdaFunctionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleLambdaFunctionDecisionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleLambdaFunctionDecisionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleLambdaFunctionDecisionAttributes"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControl sets the Control field's value.
func (s *ScheduleLambdaFunctionDecisionAttributes) SetControl(v string) *ScheduleLambdaFunctionDecisionAttributes {
	s.Control = &v
	return s
}

// SetId sets the Id field's value.
func (s *ScheduleLambdaFunctionDecisionAttributes) SetId(v string) *ScheduleLambdaFunctionDecisionAttributes {
	s.Id = &v
	return s
}

// SetInput sets the Input field's value.
func (s *ScheduleLambdaFunctionDecisionAttributes) SetInput(v string) *ScheduleLambdaFunctionDecisionAttributes {
	s.Input = &v
	return s
}

// SetName sets the Name field's value.
func (s *ScheduleLambdaFunctionDecisionAttributes) SetName(v string) *ScheduleLambdaFunctionDecisionAttributes {
	s.Name = &v
	return s
}

// SetStartToCloseTimeout sets the StartToCloseTimeout field's value.
func (s *ScheduleLambdaFunctionDecisionAttributes) SetStartToCloseTimeout(v string) *ScheduleLambdaFunctionDecisionAttributes {
	s.StartToCloseTimeout = &v
	return s
}

// Provides the details of the ScheduleLambdaFunctionFailed event. It isn't
// set for other event types.
type ScheduleLambdaFunctionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. To help diagnose issues, use this information to
	// trace back the chain of events leading up to this event.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"ScheduleLambdaFunctionFailedCause"`

	// The ID of the LambdaFunctionCompleted event corresponding to the decision
	// that resulted in scheduling this Lambda task. To help diagnose issues, use
	// this information to trace back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The ID provided in the ScheduleLambdaFunction decision that failed.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The name of the Lambda function.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ScheduleLambdaFunctionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleLambdaFunctionFailedEventAttributes) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *ScheduleLambdaFunctionFailedEventAttributes) SetCause(v string) *ScheduleLambdaFunctionFailedEventAttributes {
	s.Cause = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *ScheduleLambdaFunctionFailedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *ScheduleLambdaFunctionFailedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ScheduleLambdaFunctionFailedEventAttributes) SetId(v string) *ScheduleLambdaFunctionFailedEventAttributes {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ScheduleLambdaFunctionFailedEventAttributes) SetName(v string) *ScheduleLambdaFunctionFailedEventAttributes {
	s.Name = &v
	return s
}

// Provides the details of the SignalExternalWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type SignalExternalWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The data attached to the event that can be used by the decider in subsequent
	// decision tasks.
	Control *string `locationName:"control" type:"string"`

	// The input data to be provided with the signal. The target workflow execution
	// uses the signal name and input data to process the signal.
	Input *string `locationName:"input" type:"string"`

	// The runId of the workflow execution to be signaled.
	RunId *string `locationName:"runId" type:"string"`

	// The name of the signal.The target workflow execution uses the signal name
	// and input to process the signal.
	//
	// SignalName is a required field
	SignalName *string `locationName:"signalName" min:"1" type:"string" required:"true"`

	// The workflowId of the workflow execution to be signaled.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalExternalWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalExternalWorkflowExecutionDecisionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignalExternalWorkflowExecutionDecisionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SignalExternalWorkflowExecutionDecisionAttributes"}
	if s.SignalName == nil {
		invalidParams.Add(request.NewErrParamRequired("SignalName"))
	}
	if s.SignalName != nil && len(*s.SignalName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SignalName", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControl sets the Control field's value.
func (s *SignalExternalWorkflowExecutionDecisionAttributes) SetControl(v string) *SignalExternalWorkflowExecutionDecisionAttributes {
	s.Control = &v
	return s
}

// SetInput sets the Input field's value.
func (s *SignalExternalWorkflowExecutionDecisionAttributes) SetInput(v string) *SignalExternalWorkflowExecutionDecisionAttributes {
	s.Input = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *SignalExternalWorkflowExecutionDecisionAttributes) SetRunId(v string) *SignalExternalWorkflowExecutionDecisionAttributes {
	s.RunId = &v
	return s
}

// SetSignalName sets the SignalName field's value.
func (s *SignalExternalWorkflowExecutionDecisionAttributes) SetSignalName(v string) *SignalExternalWorkflowExecutionDecisionAttributes {
	s.SignalName = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *SignalExternalWorkflowExecutionDecisionAttributes) SetWorkflowId(v string) *SignalExternalWorkflowExecutionDecisionAttributes {
	s.WorkflowId = &v
	return s
}

// Provides the details of the SignalExternalWorkflowExecutionFailed event.
type SignalExternalWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"SignalExternalWorkflowExecutionFailedCause"`

	// The data attached to the event that the decider can use in subsequent workflow
	// tasks. This data isn't sent to the workflow execution.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the SignalExternalWorkflowExecution decision for this signal.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The ID of the SignalExternalWorkflowExecutionInitiated event corresponding
	// to the SignalExternalWorkflowExecution decision to request this signal. This
	// information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The runId of the external workflow execution that the signal was being delivered
	// to.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the external workflow execution that the signal was being
	// delivered to.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalExternalWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalExternalWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *SignalExternalWorkflowExecutionFailedEventAttributes) SetCause(v string) *SignalExternalWorkflowExecutionFailedEventAttributes {
	s.Cause = &v
	return s
}

// SetControl sets the Control field's value.
func (s *SignalExternalWorkflowExecutionFailedEventAttributes) SetControl(v string) *SignalExternalWorkflowExecutionFailedEventAttributes {
	s.Control = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *SignalExternalWorkflowExecutionFailedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *SignalExternalWorkflowExecutionFailedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetInitiatedEventId sets the InitiatedEventId field's value.
func (s *SignalExternalWorkflowExecutionFailedEventAttributes) SetInitiatedEventId(v int64) *SignalExternalWorkflowExecutionFailedEventAttributes {
	s.InitiatedEventId = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *SignalExternalWorkflowExecutionFailedEventAttributes) SetRunId(v string) *SignalExternalWorkflowExecutionFailedEventAttributes {
	s.RunId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *SignalExternalWorkflowExecutionFailedEventAttributes) SetWorkflowId(v string) *SignalExternalWorkflowExecutionFailedEventAttributes {
	s.WorkflowId = &v
	return s
}

// Provides the details of the SignalExternalWorkflowExecutionInitiated event.
type SignalExternalWorkflowExecutionInitiatedEventAttributes struct {
	_ struct{} `type:"structure"`

	// Data attached to the event that can be used by the decider in subsequent
	// decision tasks.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the SignalExternalWorkflowExecution decision for this signal.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The input provided to the signal.
	Input *string `locationName:"input" type:"string"`

	// The runId of the external workflow execution to send the signal to.
	RunId *string `locationName:"runId" type:"string"`

	// The name of the signal.
	//
	// SignalName is a required field
	SignalName *string `locationName:"signalName" min:"1" type:"string" required:"true"`

	// The workflowId of the external workflow execution.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalExternalWorkflowExecutionInitiatedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalExternalWorkflowExecutionInitiatedEventAttributes) GoString() string {
	return s.String()
}

// SetControl sets the Control field's value.
func (s *SignalExternalWorkflowExecutionInitiatedEventAttributes) SetControl(v string) *SignalExternalWorkflowExecutionInitiatedEventAttributes {
	s.Control = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *SignalExternalWorkflowExecutionInitiatedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *SignalExternalWorkflowExecutionInitiatedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetInput sets the Input field's value.
func (s *SignalExternalWorkflowExecutionInitiatedEventAttributes) SetInput(v string) *SignalExternalWorkflowExecutionInitiatedEventAttributes {
	s.Input = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *SignalExternalWorkflowExecutionInitiatedEventAttributes) SetRunId(v string) *SignalExternalWorkflowExecutionInitiatedEventAttributes {
	s.RunId = &v
	return s
}

// SetSignalName sets the SignalName field's value.
func (s *SignalExternalWorkflowExecutionInitiatedEventAttributes) SetSignalName(v string) *SignalExternalWorkflowExecutionInitiatedEventAttributes {
	s.SignalName = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *SignalExternalWorkflowExecutionInitiatedEventAttributes) SetWorkflowId(v string) *SignalExternalWorkflowExecutionInitiatedEventAttributes {
	s.WorkflowId = &v
	return s
}

type SignalWorkflowExecutionInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain containing the workflow execution to signal.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// Data to attach to the WorkflowExecutionSignaled event in the target workflow
	// execution's history.
	Input *string `locationName:"input" type:"string"`

	// The runId of the workflow execution to signal.
	RunId *string `locationName:"runId" type:"string"`

	// The name of the signal. This name must be meaningful to the target workflow.
	//
	// SignalName is a required field
	SignalName *string `locationName:"signalName" min:"1" type:"string" required:"true"`

	// The workflowId of the workflow execution to signal.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SignalWorkflowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalWorkflowExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignalWorkflowExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SignalWorkflowExecutionInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.SignalName == nil {
		invalidParams.Add(request.NewErrParamRequired("SignalName"))
	}
	if s.SignalName != nil && len(*s.SignalName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SignalName", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *SignalWorkflowExecutionInput) SetDomain(v string) *SignalWorkflowExecutionInput {
	s.Domain = &v
	return s
}

// SetInput sets the Input field's value.
func (s *SignalWorkflowExecutionInput) SetInput(v string) *SignalWorkflowExecutionInput {
	s.Input = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *SignalWorkflowExecutionInput) SetRunId(v string) *SignalWorkflowExecutionInput {
	s.RunId = &v
	return s
}

// SetSignalName sets the SignalName field's value.
func (s *SignalWorkflowExecutionInput) SetSignalName(v string) *SignalWorkflowExecutionInput {
	s.SignalName = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *SignalWorkflowExecutionInput) SetWorkflowId(v string) *SignalWorkflowExecutionInput {
	s.WorkflowId = &v
	return s
}

type SignalWorkflowExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SignalWorkflowExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalWorkflowExecutionOutput) GoString() string {
	return s.String()
}

// Provides the details of the StartChildWorkflowExecution decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * Constrain the following parameters by using a Condition element with
//    the appropriate keys. tagList.member.N – The key is "swf:tagList.N"
//    where N is the tag number from 0 to 4, inclusive. taskList – String
//    constraint. The key is swf:taskList.name. workflowType.name – String
//    constraint. The key is swf:workflowType.name. workflowType.version –
//    String constraint. The key is swf:workflowType.version.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type StartChildWorkflowExecutionDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// If set, specifies the policy to use for the child workflow executions if
	// the workflow execution being started is terminated by calling the TerminateWorkflowExecution
	// action explicitly or due to an expired timeout. This policy overrides the
	// default child policy specified when registering the workflow type using RegisterWorkflowType.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// A child policy for this workflow execution must be specified either as a
	// default for the workflow type or through this parameter. If neither this
	// parameter is set nor a default child policy was specified at registration
	// time then a fault is returned.
	ChildPolicy *string `locationName:"childPolicy" type:"string" enum:"ChildPolicy"`

	// The data attached to the event that can be used by the decider in subsequent
	// workflow tasks. This data isn't sent to the child workflow execution.
	Control *string `locationName:"control" type:"string"`

	// The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout
	// specified when registering the workflow type.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// An execution start-to-close timeout for this workflow execution must be specified
	// either as a default for the workflow type or through this parameter. If neither
	// this parameter is set nor a default execution start-to-close timeout was
	// specified at registration time then a fault is returned.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The input to be provided to the workflow execution.
	Input *string `locationName:"input" type:"string"`

	// The IAM role attached to the child workflow execution.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The list of tags to associate with the child workflow execution. A maximum
	// of 5 tags can be specified. You can list workflow executions with a specific
	// tag by calling ListOpenWorkflowExecutions or ListClosedWorkflowExecutions
	// and specifying a TagFilter.
	TagList []*string `locationName:"tagList" type:"list"`

	// The name of the task list to be used for decision tasks of the child workflow
	// execution.
	//
	// A task list for this workflow execution must be specified either as a default
	// for the workflow type or through this parameter. If neither this parameter
	// is set nor a default task list was specified at registration time then a
	// fault is returned.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not contain the literal string arn.
	TaskList *TaskList `locationName:"taskList" type:"structure"`

	// A task priority that, if set, specifies the priority for a decision task
	// of this workflow execution. This overrides the defaultTaskPriority specified
	// when registering the workflow type. Valid values are integers that range
	// from Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647).
	// Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// Specifies the maximum duration of decision tasks for this workflow execution.
	// This parameter overrides the defaultTaskStartToCloseTimout specified when
	// registering the workflow type using RegisterWorkflowType.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// A task start-to-close timeout for this workflow execution must be specified
	// either as a default for the workflow type or through this parameter. If neither
	// this parameter is set nor a default task start-to-close timeout was specified
	// at registration time then a fault is returned.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// The workflowId of the workflow execution.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not contain the literal string arn.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`

	// The type of the workflow execution to be started.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s StartChildWorkflowExecutionDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartChildWorkflowExecutionDecisionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartChildWorkflowExecutionDecisionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartChildWorkflowExecutionDecisionAttributes"}
	if s.LambdaRole != nil && len(*s.LambdaRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaRole", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}
	if s.WorkflowType == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowType"))
	}
	if s.TaskList != nil {
		if err := s.TaskList.Validate(); err != nil {
			invalidParams.AddNested("TaskList", err.(request.ErrInvalidParams))
		}
	}
	if s.WorkflowType != nil {
		if err := s.WorkflowType.Validate(); err != nil {
			invalidParams.AddNested("WorkflowType", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildPolicy sets the ChildPolicy field's value.
func (s *StartChildWorkflowExecutionDecisionAttributes) SetChildPolicy(v string) *StartChildWorkflowExecutionDecisionAttributes {
	s.ChildPolicy = &v
	return s
}

// SetControl sets the Control field's value.
func (s *StartChildWorkflowExecutionDecisionAttributes) SetControl(v string) *StartChildWorkflowExecutionDecisionAttributes {
	s.Control = &v
	return s
}

// SetExecutionStartToCloseTimeout sets the ExecutionStartToCloseTimeout field's value.
func (s *StartChildWorkflowExecutionDecisionAttributes) SetExecutionStartToCloseTimeout(v string) *StartChildWorkflowExecutionDecisionAttributes {
	s.ExecutionStartToCloseTimeout = &v
	return s
}

// SetInput sets the Input field's value.
func (s *StartChildWorkflowExecutionDecisionAttributes) SetInput(v string) *StartChildWorkflowExecutionDecisionAttributes {
	s.Input = &v
	return s
}

// SetLambdaRole sets the LambdaRole field's value.
func (s *StartChildWorkflowExecutionDecisionAttributes) SetLambdaRole(v string) *StartChildWorkflowExecutionDecisionAttributes {
	s.LambdaRole = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *StartChildWorkflowExecutionDecisionAttributes) SetTagList(v []*string) *StartChildWorkflowExecutionDecisionAttributes {
	s.TagList = v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *StartChildWorkflowExecutionDecisionAttributes) SetTaskList(v *TaskList) *StartChildWorkflowExecutionDecisionAttributes {
	s.TaskList = v
	return s
}

// SetTaskPriority sets the TaskPriority field's value.
func (s *StartChildWorkflowExecutionDecisionAttributes) SetTaskPriority(v string) *StartChildWorkflowExecutionDecisionAttributes {
	s.TaskPriority = &v
	return s
}

// SetTaskStartToCloseTimeout sets the TaskStartToCloseTimeout field's value.
func (s *StartChildWorkflowExecutionDecisionAttributes) SetTaskStartToCloseTimeout(v string) *StartChildWorkflowExecutionDecisionAttributes {
	s.TaskStartToCloseTimeout = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *StartChildWorkflowExecutionDecisionAttributes) SetWorkflowId(v string) *StartChildWorkflowExecutionDecisionAttributes {
	s.WorkflowId = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *StartChildWorkflowExecutionDecisionAttributes) SetWorkflowType(v *WorkflowType) *StartChildWorkflowExecutionDecisionAttributes {
	s.WorkflowType = v
	return s
}

// Provides the details of the StartChildWorkflowExecutionFailed event.
type StartChildWorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// When cause is set to OPERATION_NOT_PERMITTED, the decision fails because
	// it lacks sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"StartChildWorkflowExecutionFailedCause"`

	// The data attached to the event that the decider can use in subsequent workflow
	// tasks. This data isn't sent to the child workflow execution.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartChildWorkflowExecution Decision to request this
	// child workflow execution. This information can be useful for diagnosing problems
	// by tracing back the chain of events.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// When the cause is WORKFLOW_ALREADY_RUNNING, initiatedEventId is the ID of
	// the StartChildWorkflowExecutionInitiated event that corresponds to the StartChildWorkflowExecution
	// Decision to start the workflow execution. You can use this information to
	// diagnose problems by tracing back the chain of events leading up to this
	// event.
	//
	// When the cause isn't WORKFLOW_ALREADY_RUNNING, initiatedEventId is set to
	// 0 because the StartChildWorkflowExecutionInitiated event doesn't exist.
	//
	// InitiatedEventId is a required field
	InitiatedEventId *int64 `locationName:"initiatedEventId" type:"long" required:"true"`

	// The workflowId of the child workflow execution.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`

	// The workflow type provided in the StartChildWorkflowExecution Decision that
	// failed.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s StartChildWorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartChildWorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *StartChildWorkflowExecutionFailedEventAttributes) SetCause(v string) *StartChildWorkflowExecutionFailedEventAttributes {
	s.Cause = &v
	return s
}

// SetControl sets the Control field's value.
func (s *StartChildWorkflowExecutionFailedEventAttributes) SetControl(v string) *StartChildWorkflowExecutionFailedEventAttributes {
	s.Control = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *StartChildWorkflowExecutionFailedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *StartChildWorkflowExecutionFailedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetInitiatedEventId sets the InitiatedEventId field's value.
func (s *StartChildWorkflowExecutionFailedEventAttributes) SetInitiatedEventId(v int64) *StartChildWorkflowExecutionFailedEventAttributes {
	s.InitiatedEventId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *StartChildWorkflowExecutionFailedEventAttributes) SetWorkflowId(v string) *StartChildWorkflowExecutionFailedEventAttributes {
	s.WorkflowId = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *StartChildWorkflowExecutionFailedEventAttributes) SetWorkflowType(v *WorkflowType) *StartChildWorkflowExecutionFailedEventAttributes {
	s.WorkflowType = v
	return s
}

// Provides the details of the StartChildWorkflowExecutionInitiated event.
type StartChildWorkflowExecutionInitiatedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The policy to use for the child workflow executions if this execution gets
	// terminated by explicitly calling the TerminateWorkflowExecution action or
	// due to an expired timeout.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// ChildPolicy is a required field
	ChildPolicy *string `locationName:"childPolicy" type:"string" required:"true" enum:"ChildPolicy"`

	// Data attached to the event that can be used by the decider in subsequent
	// decision tasks. This data isn't sent to the activity.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartChildWorkflowExecution Decision to request this
	// child workflow execution. This information can be useful for diagnosing problems
	// by tracing back the cause of events.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The maximum duration for the child workflow execution. If the workflow execution
	// isn't closed within this duration, it is timed out and force-terminated.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The inputs provided to the child workflow execution.
	Input *string `locationName:"input" type:"string"`

	// The IAM role to attach to the child workflow execution.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The list of tags to associated with the child workflow execution.
	TagList []*string `locationName:"tagList" type:"list"`

	// The name of the task list used for the decision tasks of the child workflow
	// execution.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// The priority assigned for the decision tasks for this workflow execution.
	// Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// The maximum duration allowed for the decision tasks for this workflow execution.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// The workflowId of the child workflow execution.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`

	// The type of the child workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s StartChildWorkflowExecutionInitiatedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartChildWorkflowExecutionInitiatedEventAttributes) GoString() string {
	return s.String()
}

// SetChildPolicy sets the ChildPolicy field's value.
func (s *StartChildWorkflowExecutionInitiatedEventAttributes) SetChildPolicy(v string) *StartChildWorkflowExecutionInitiatedEventAttributes {
	s.ChildPolicy = &v
	return s
}

// SetControl sets the Control field's value.
func (s *StartChildWorkflowExecutionInitiatedEventAttributes) SetControl(v string) *StartChildWorkflowExecutionInitiatedEventAttributes {
	s.Control = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *StartChildWorkflowExecutionInitiatedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *StartChildWorkflowExecutionInitiatedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetExecutionStartToCloseTimeout sets the ExecutionStartToCloseTimeout field's value.
func (s *StartChildWorkflowExecutionInitiatedEventAttributes) SetExecutionStartToCloseTimeout(v string) *StartChildWorkflowExecutionInitiatedEventAttributes {
	s.ExecutionStartToCloseTimeout = &v
	return s
}

// SetInput sets the Input field's value.
func (s *StartChildWorkflowExecutionInitiatedEventAttributes) SetInput(v string) *StartChildWorkflowExecutionInitiatedEventAttributes {
	s.Input = &v
	return s
}

// SetLambdaRole sets the LambdaRole field's value.
func (s *StartChildWorkflowExecutionInitiatedEventAttributes) SetLambdaRole(v string) *StartChildWorkflowExecutionInitiatedEventAttributes {
	s.LambdaRole = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *StartChildWorkflowExecutionInitiatedEventAttributes) SetTagList(v []*string) *StartChildWorkflowExecutionInitiatedEventAttributes {
	s.TagList = v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *StartChildWorkflowExecutionInitiatedEventAttributes) SetTaskList(v *TaskList) *StartChildWorkflowExecutionInitiatedEventAttributes {
	s.TaskList = v
	return s
}

// SetTaskPriority sets the TaskPriority field's value.
func (s *StartChildWorkflowExecutionInitiatedEventAttributes) SetTaskPriority(v string) *StartChildWorkflowExecutionInitiatedEventAttributes {
	s.TaskPriority = &v
	return s
}

// SetTaskStartToCloseTimeout sets the TaskStartToCloseTimeout field's value.
func (s *StartChildWorkflowExecutionInitiatedEventAttributes) SetTaskStartToCloseTimeout(v string) *StartChildWorkflowExecutionInitiatedEventAttributes {
	s.TaskStartToCloseTimeout = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *StartChildWorkflowExecutionInitiatedEventAttributes) SetWorkflowId(v string) *StartChildWorkflowExecutionInitiatedEventAttributes {
	s.WorkflowId = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *StartChildWorkflowExecutionInitiatedEventAttributes) SetWorkflowType(v *WorkflowType) *StartChildWorkflowExecutionInitiatedEventAttributes {
	s.WorkflowType = v
	return s
}

// Provides the details of the StartLambdaFunctionFailed event. It isn't set
// for other event types.
type StartLambdaFunctionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. To help diagnose issues, use this information to
	// trace back the chain of events leading up to this event.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because the
	// IAM role attached to the execution lacked sufficient permissions. For details
	// and example IAM policies, see Lambda Tasks (https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html)
	// in the Amazon SWF Developer Guide.
	Cause *string `locationName:"cause" type:"string" enum:"StartLambdaFunctionFailedCause"`

	// A description that can help diagnose the cause of the fault.
	Message *string `locationName:"message" type:"string"`

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. To help diagnose issues, use this information to trace
	// back the chain of events leading up to this event.
	ScheduledEventId *int64 `locationName:"scheduledEventId" type:"long"`
}

// String returns the string representation
func (s StartLambdaFunctionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartLambdaFunctionFailedEventAttributes) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *StartLambdaFunctionFailedEventAttributes) SetCause(v string) *StartLambdaFunctionFailedEventAttributes {
	s.Cause = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *StartLambdaFunctionFailedEventAttributes) SetMessage(v string) *StartLambdaFunctionFailedEventAttributes {
	s.Message = &v
	return s
}

// SetScheduledEventId sets the ScheduledEventId field's value.
func (s *StartLambdaFunctionFailedEventAttributes) SetScheduledEventId(v int64) *StartLambdaFunctionFailedEventAttributes {
	s.ScheduledEventId = &v
	return s
}

// Provides the details of the StartTimer decision.
//
// Access Control
//
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type StartTimerDecisionAttributes struct {
	_ struct{} `type:"structure"`

	// The data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string `locationName:"control" type:"string"`

	// The duration to wait before firing the timer.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0.
	//
	// StartToFireTimeout is a required field
	StartToFireTimeout *string `locationName:"startToFireTimeout" min:"1" type:"string" required:"true"`

	// The unique ID of the timer.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not contain the literal string arn.
	//
	// TimerId is a required field
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartTimerDecisionAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTimerDecisionAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTimerDecisionAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTimerDecisionAttributes"}
	if s.StartToFireTimeout == nil {
		invalidParams.Add(request.NewErrParamRequired("StartToFireTimeout"))
	}
	if s.StartToFireTimeout != nil && len(*s.StartToFireTimeout) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartToFireTimeout", 1))
	}
	if s.TimerId == nil {
		invalidParams.Add(request.NewErrParamRequired("TimerId"))
	}
	if s.TimerId != nil && len(*s.TimerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControl sets the Control field's value.
func (s *StartTimerDecisionAttributes) SetControl(v string) *StartTimerDecisionAttributes {
	s.Control = &v
	return s
}

// SetStartToFireTimeout sets the StartToFireTimeout field's value.
func (s *StartTimerDecisionAttributes) SetStartToFireTimeout(v string) *StartTimerDecisionAttributes {
	s.StartToFireTimeout = &v
	return s
}

// SetTimerId sets the TimerId field's value.
func (s *StartTimerDecisionAttributes) SetTimerId(v string) *StartTimerDecisionAttributes {
	s.TimerId = &v
	return s
}

// Provides the details of the StartTimerFailed event.
type StartTimerFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The cause of the failure. This information is generated by the system and
	// can be useful for diagnostic purposes.
	//
	// If cause is set to OPERATION_NOT_PERMITTED, the decision failed because it
	// lacked sufficient permissions. For details and example IAM policies, see
	// Using IAM to Manage Access to Amazon SWF Workflows (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// Cause is a required field
	Cause *string `locationName:"cause" type:"string" required:"true" enum:"StartTimerFailedCause"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartTimer decision for this activity task. This information
	// can be useful for diagnosing problems by tracing back the chain of events
	// leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The timerId provided in the StartTimer decision that failed.
	//
	// TimerId is a required field
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartTimerFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTimerFailedEventAttributes) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *StartTimerFailedEventAttributes) SetCause(v string) *StartTimerFailedEventAttributes {
	s.Cause = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *StartTimerFailedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *StartTimerFailedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetTimerId sets the TimerId field's value.
func (s *StartTimerFailedEventAttributes) SetTimerId(v string) *StartTimerFailedEventAttributes {
	s.TimerId = &v
	return s
}

type StartWorkflowExecutionInput struct {
	_ struct{} `type:"structure"`

	// If set, specifies the policy to use for the child workflow executions of
	// this workflow execution if it is terminated, by calling the TerminateWorkflowExecution
	// action explicitly or due to an expired timeout. This policy overrides the
	// default child policy specified when registering the workflow type using RegisterWorkflowType.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// A child policy for this workflow execution must be specified either as a
	// default for the workflow type or through this parameter. If neither this
	// parameter is set nor a default child policy was specified at registration
	// time then a fault is returned.
	ChildPolicy *string `locationName:"childPolicy" type:"string" enum:"ChildPolicy"`

	// The name of the domain in which the workflow execution is created.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout
	// specified when registering the workflow type.
	//
	// The duration is specified in seconds; an integer greater than or equal to
	// 0. Exceeding this limit causes the workflow execution to time out. Unlike
	// some of the other timeout parameters in Amazon SWF, you cannot specify a
	// value of "NONE" for this timeout; there is a one-year max limit on the time
	// that a workflow execution can run.
	//
	// An execution start-to-close timeout must be specified either through this
	// parameter or as a default when the workflow type is registered. If neither
	// this parameter nor a default execution start-to-close timeout is specified,
	// a fault is returned.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The input for the workflow execution. This is a free form string which should
	// be meaningful to the workflow you are starting. This input is made available
	// to the new workflow execution in the WorkflowExecutionStarted history event.
	Input *string `locationName:"input" type:"string"`

	// The IAM role to attach to this workflow execution.
	//
	// Executions of this workflow type need IAM roles to invoke Lambda functions.
	// If you don't attach an IAM role, any attempt to schedule a Lambda task fails.
	// This results in a ScheduleLambdaFunctionFailed history event. For more information,
	// see https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html)
	// in the Amazon SWF Developer Guide.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The list of tags to associate with the workflow execution. You can specify
	// a maximum of 5 tags. You can list workflow executions with a specific tag
	// by calling ListOpenWorkflowExecutions or ListClosedWorkflowExecutions and
	// specifying a TagFilter.
	TagList []*string `locationName:"tagList" type:"list"`

	// The task list to use for the decision tasks generated for this workflow execution.
	// This overrides the defaultTaskList specified when registering the workflow
	// type.
	//
	// A task list for this workflow execution must be specified either as a default
	// for the workflow type or through this parameter. If neither this parameter
	// is set nor a default task list was specified at registration time then a
	// fault is returned.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not be the literal string arn.
	TaskList *TaskList `locationName:"taskList" type:"structure"`

	// The task priority to use for this workflow execution. This overrides any
	// default priority that was assigned when the workflow type was registered.
	// If not set, then the default task priority for the workflow type is used.
	// Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// Specifies the maximum duration of decision tasks for this workflow execution.
	// This parameter overrides the defaultTaskStartToCloseTimout specified when
	// registering the workflow type using RegisterWorkflowType.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// A task start-to-close timeout for this workflow execution must be specified
	// either as a default for the workflow type or through this parameter. If neither
	// this parameter is set nor a default task start-to-close timeout was specified
	// at registration time then a fault is returned.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// The user defined identifier associated with the workflow execution. You can
	// use this to associate a custom identifier with the workflow execution. You
	// may specify the same identifier if a workflow execution is logically a restart
	// of a previous execution. You cannot have two open workflow executions with
	// the same workflowId at the same time within the same domain.
	//
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters (\u0000-\u001f
	// | \u007f-\u009f). Also, it must not be the literal string arn.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`

	// The type of the workflow to start.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s StartWorkflowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartWorkflowExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartWorkflowExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartWorkflowExecutionInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.LambdaRole != nil && len(*s.LambdaRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaRole", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}
	if s.WorkflowType == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowType"))
	}
	if s.TaskList != nil {
		if err := s.TaskList.Validate(); err != nil {
			invalidParams.AddNested("TaskList", err.(request.ErrInvalidParams))
		}
	}
	if s.WorkflowType != nil {
		if err := s.WorkflowType.Validate(); err != nil {
			invalidParams.AddNested("WorkflowType", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildPolicy sets the ChildPolicy field's value.
func (s *StartWorkflowExecutionInput) SetChildPolicy(v string) *StartWorkflowExecutionInput {
	s.ChildPolicy = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *StartWorkflowExecutionInput) SetDomain(v string) *StartWorkflowExecutionInput {
	s.Domain = &v
	return s
}

// SetExecutionStartToCloseTimeout sets the ExecutionStartToCloseTimeout field's value.
func (s *StartWorkflowExecutionInput) SetExecutionStartToCloseTimeout(v string) *StartWorkflowExecutionInput {
	s.ExecutionStartToCloseTimeout = &v
	return s
}

// SetInput sets the Input field's value.
func (s *StartWorkflowExecutionInput) SetInput(v string) *StartWorkflowExecutionInput {
	s.Input = &v
	return s
}

// SetLambdaRole sets the LambdaRole field's value.
func (s *StartWorkflowExecutionInput) SetLambdaRole(v string) *StartWorkflowExecutionInput {
	s.LambdaRole = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *StartWorkflowExecutionInput) SetTagList(v []*string) *StartWorkflowExecutionInput {
	s.TagList = v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *StartWorkflowExecutionInput) SetTaskList(v *TaskList) *StartWorkflowExecutionInput {
	s.TaskList = v
	return s
}

// SetTaskPriority sets the TaskPriority field's value.
func (s *StartWorkflowExecutionInput) SetTaskPriority(v string) *StartWorkflowExecutionInput {
	s.TaskPriority = &v
	return s
}

// SetTaskStartToCloseTimeout sets the TaskStartToCloseTimeout field's value.
func (s *StartWorkflowExecutionInput) SetTaskStartToCloseTimeout(v string) *StartWorkflowExecutionInput {
	s.TaskStartToCloseTimeout = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *StartWorkflowExecutionInput) SetWorkflowId(v string) *StartWorkflowExecutionInput {
	s.WorkflowId = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *StartWorkflowExecutionInput) SetWorkflowType(v *WorkflowType) *StartWorkflowExecutionInput {
	s.WorkflowType = v
	return s
}

// Specifies the runId of a workflow execution.
type StartWorkflowExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The runId of a workflow execution. This ID is generated by the service and
	// can be used to uniquely identify the workflow execution within a domain.
	RunId *string `locationName:"runId" min:"1" type:"string"`
}

// String returns the string representation
func (s StartWorkflowExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartWorkflowExecutionOutput) GoString() string {
	return s.String()
}

// SetRunId sets the RunId field's value.
func (s *StartWorkflowExecutionOutput) SetRunId(v string) *StartWorkflowExecutionOutput {
	s.RunId = &v
	return s
}

// Used to filter the workflow executions in visibility APIs based on a tag.
type TagFilter struct {
	_ struct{} `type:"structure"`

	// Specifies the tag that must be associated with the execution for it to meet
	// the filter criteria.
	//
	// Tags may only contain unicode letters, digits, whitespace, or these symbols:
	// _ . : / = + - @.
	//
	// Tag is a required field
	Tag *string `locationName:"tag" type:"string" required:"true"`
}

// String returns the string representation
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagFilter"}
	if s.Tag == nil {
		invalidParams.Add(request.NewErrParamRequired("Tag"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTag sets the Tag field's value.
func (s *TagFilter) SetTag(v string) *TagFilter {
	s.Tag = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the Amazon SWF domain.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The list of tags to add to a domain.
	//
	// Tags may only contain unicode letters, digits, whitespace, or these symbols:
	// _ . : / = + - @.
	//
	// Tags is a required field
	Tags []*ResourceTag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*ResourceTag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Represents a task list.
type TaskList struct {
	_ struct{} `type:"structure"`

	// The name of the task list.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TaskList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaskList) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TaskList) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TaskList"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *TaskList) SetName(v string) *TaskList {
	s.Name = &v
	return s
}

type TerminateWorkflowExecutionInput struct {
	_ struct{} `type:"structure"`

	// If set, specifies the policy to use for the child workflow executions of
	// the workflow execution being terminated. This policy overrides the child
	// policy specified for the workflow execution at registration time or when
	// starting the execution.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// A child policy for this workflow execution must be specified either as a
	// default for the workflow type or through this parameter. If neither this
	// parameter is set nor a default child policy was specified at registration
	// time then a fault is returned.
	ChildPolicy *string `locationName:"childPolicy" type:"string" enum:"ChildPolicy"`

	// Details for terminating the workflow execution.
	Details *string `locationName:"details" type:"string"`

	// The domain of the workflow execution to terminate.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// A descriptive reason for terminating the workflow execution.
	Reason *string `locationName:"reason" type:"string"`

	// The runId of the workflow execution to terminate.
	RunId *string `locationName:"runId" type:"string"`

	// The workflowId of the workflow execution to terminate.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TerminateWorkflowExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateWorkflowExecutionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateWorkflowExecutionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateWorkflowExecutionInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChildPolicy sets the ChildPolicy field's value.
func (s *TerminateWorkflowExecutionInput) SetChildPolicy(v string) *TerminateWorkflowExecutionInput {
	s.ChildPolicy = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *TerminateWorkflowExecutionInput) SetDetails(v string) *TerminateWorkflowExecutionInput {
	s.Details = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *TerminateWorkflowExecutionInput) SetDomain(v string) *TerminateWorkflowExecutionInput {
	s.Domain = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *TerminateWorkflowExecutionInput) SetReason(v string) *TerminateWorkflowExecutionInput {
	s.Reason = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *TerminateWorkflowExecutionInput) SetRunId(v string) *TerminateWorkflowExecutionInput {
	s.RunId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *TerminateWorkflowExecutionInput) SetWorkflowId(v string) *TerminateWorkflowExecutionInput {
	s.WorkflowId = &v
	return s
}

type TerminateWorkflowExecutionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TerminateWorkflowExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateWorkflowExecutionOutput) GoString() string {
	return s.String()
}

// Provides the details of the TimerCanceled event.
type TimerCanceledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelTimer decision to cancel this timer. This information
	// can be useful for diagnosing problems by tracing back the chain of events
	// leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The ID of the TimerStarted event that was recorded when this timer was started.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The unique ID of the timer that was canceled.
	//
	// TimerId is a required field
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TimerCanceledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimerCanceledEventAttributes) GoString() string {
	return s.String()
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *TimerCanceledEventAttributes) SetDecisionTaskCompletedEventId(v int64) *TimerCanceledEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *TimerCanceledEventAttributes) SetStartedEventId(v int64) *TimerCanceledEventAttributes {
	s.StartedEventId = &v
	return s
}

// SetTimerId sets the TimerId field's value.
func (s *TimerCanceledEventAttributes) SetTimerId(v string) *TimerCanceledEventAttributes {
	s.TimerId = &v
	return s
}

// Provides the details of the TimerFired event.
type TimerFiredEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the TimerStarted event that was recorded when this timer was started.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// StartedEventId is a required field
	StartedEventId *int64 `locationName:"startedEventId" type:"long" required:"true"`

	// The unique ID of the timer that fired.
	//
	// TimerId is a required field
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TimerFiredEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimerFiredEventAttributes) GoString() string {
	return s.String()
}

// SetStartedEventId sets the StartedEventId field's value.
func (s *TimerFiredEventAttributes) SetStartedEventId(v int64) *TimerFiredEventAttributes {
	s.StartedEventId = &v
	return s
}

// SetTimerId sets the TimerId field's value.
func (s *TimerFiredEventAttributes) SetTimerId(v string) *TimerFiredEventAttributes {
	s.TimerId = &v
	return s
}

// Provides the details of the TimerStarted event.
type TimerStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// Data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string `locationName:"control" type:"string"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartTimer decision for this activity task. This information
	// can be useful for diagnosing problems by tracing back the chain of events
	// leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The duration of time after which the timer fires.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0.
	//
	// StartToFireTimeout is a required field
	StartToFireTimeout *string `locationName:"startToFireTimeout" min:"1" type:"string" required:"true"`

	// The unique ID of the timer that was started.
	//
	// TimerId is a required field
	TimerId *string `locationName:"timerId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TimerStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimerStartedEventAttributes) GoString() string {
	return s.String()
}

// SetControl sets the Control field's value.
func (s *TimerStartedEventAttributes) SetControl(v string) *TimerStartedEventAttributes {
	s.Control = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *TimerStartedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *TimerStartedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetStartToFireTimeout sets the StartToFireTimeout field's value.
func (s *TimerStartedEventAttributes) SetStartToFireTimeout(v string) *TimerStartedEventAttributes {
	s.StartToFireTimeout = &v
	return s
}

// SetTimerId sets the TimerId field's value.
func (s *TimerStartedEventAttributes) SetTimerId(v string) *TimerStartedEventAttributes {
	s.TimerId = &v
	return s
}

type UndeprecateActivityTypeInput struct {
	_ struct{} `type:"structure"`

	// The activity type to undeprecate.
	//
	// ActivityType is a required field
	ActivityType *ActivityType `locationName:"activityType" type:"structure" required:"true"`

	// The name of the domain of the deprecated activity type.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UndeprecateActivityTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UndeprecateActivityTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UndeprecateActivityTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UndeprecateActivityTypeInput"}
	if s.ActivityType == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivityType"))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.ActivityType != nil {
		if err := s.ActivityType.Validate(); err != nil {
			invalidParams.AddNested("ActivityType", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivityType sets the ActivityType field's value.
func (s *UndeprecateActivityTypeInput) SetActivityType(v *ActivityType) *UndeprecateActivityTypeInput {
	s.ActivityType = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *UndeprecateActivityTypeInput) SetDomain(v string) *UndeprecateActivityTypeInput {
	s.Domain = &v
	return s
}

type UndeprecateActivityTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UndeprecateActivityTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UndeprecateActivityTypeOutput) GoString() string {
	return s.String()
}

type UndeprecateDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain of the deprecated workflow type.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UndeprecateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UndeprecateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UndeprecateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UndeprecateDomainInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UndeprecateDomainInput) SetName(v string) *UndeprecateDomainInput {
	s.Name = &v
	return s
}

type UndeprecateDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UndeprecateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UndeprecateDomainOutput) GoString() string {
	return s.String()
}

type UndeprecateWorkflowTypeInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain of the deprecated workflow type.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The name of the domain of the deprecated workflow type.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s UndeprecateWorkflowTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UndeprecateWorkflowTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UndeprecateWorkflowTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UndeprecateWorkflowTypeInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.WorkflowType == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowType"))
	}
	if s.WorkflowType != nil {
		if err := s.WorkflowType.Validate(); err != nil {
			invalidParams.AddNested("WorkflowType", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *UndeprecateWorkflowTypeInput) SetDomain(v string) *UndeprecateWorkflowTypeInput {
	s.Domain = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *UndeprecateWorkflowTypeInput) SetWorkflowType(v *WorkflowType) *UndeprecateWorkflowTypeInput {
	s.WorkflowType = v
	return s
}

type UndeprecateWorkflowTypeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UndeprecateWorkflowTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UndeprecateWorkflowTypeOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the Amazon SWF domain.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The list of tags to remove from the Amazon SWF domain.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Represents a workflow execution.
type WorkflowExecution struct {
	_ struct{} `type:"structure"`

	// A system-generated unique identifier for the workflow execution.
	//
	// RunId is a required field
	RunId *string `locationName:"runId" min:"1" type:"string" required:"true"`

	// The user defined identifier associated with the workflow execution.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WorkflowExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecution) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkflowExecution) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkflowExecution"}
	if s.RunId == nil {
		invalidParams.Add(request.NewErrParamRequired("RunId"))
	}
	if s.RunId != nil && len(*s.RunId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RunId", 1))
	}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRunId sets the RunId field's value.
func (s *WorkflowExecution) SetRunId(v string) *WorkflowExecution {
	s.RunId = &v
	return s
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *WorkflowExecution) SetWorkflowId(v string) *WorkflowExecution {
	s.WorkflowId = &v
	return s
}

// Provides the details of the WorkflowExecutionCancelRequested event.
type WorkflowExecutionCancelRequestedEventAttributes struct {
	_ struct{} `type:"structure"`

	// If set, indicates that the request to cancel the workflow execution was automatically
	// generated, and specifies the cause. This happens if the parent workflow execution
	// times out or is terminated, and the child policy is set to cancel child executions.
	Cause *string `locationName:"cause" type:"string" enum:"WorkflowExecutionCancelRequestedCause"`

	// The ID of the RequestCancelExternalWorkflowExecutionInitiated event corresponding
	// to the RequestCancelExternalWorkflowExecution decision to cancel this workflow
	// execution.The source event with this ID can be found in the history of the
	// source workflow execution. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	ExternalInitiatedEventId *int64 `locationName:"externalInitiatedEventId" type:"long"`

	// The external workflow execution for which the cancellation was requested.
	ExternalWorkflowExecution *WorkflowExecution `locationName:"externalWorkflowExecution" type:"structure"`
}

// String returns the string representation
func (s WorkflowExecutionCancelRequestedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionCancelRequestedEventAttributes) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *WorkflowExecutionCancelRequestedEventAttributes) SetCause(v string) *WorkflowExecutionCancelRequestedEventAttributes {
	s.Cause = &v
	return s
}

// SetExternalInitiatedEventId sets the ExternalInitiatedEventId field's value.
func (s *WorkflowExecutionCancelRequestedEventAttributes) SetExternalInitiatedEventId(v int64) *WorkflowExecutionCancelRequestedEventAttributes {
	s.ExternalInitiatedEventId = &v
	return s
}

// SetExternalWorkflowExecution sets the ExternalWorkflowExecution field's value.
func (s *WorkflowExecutionCancelRequestedEventAttributes) SetExternalWorkflowExecution(v *WorkflowExecution) *WorkflowExecutionCancelRequestedEventAttributes {
	s.ExternalWorkflowExecution = v
	return s
}

// Provides the details of the WorkflowExecutionCanceled event.
type WorkflowExecutionCanceledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelWorkflowExecution decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The details of the cancellation.
	Details *string `locationName:"details" type:"string"`
}

// String returns the string representation
func (s WorkflowExecutionCanceledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionCanceledEventAttributes) GoString() string {
	return s.String()
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *WorkflowExecutionCanceledEventAttributes) SetDecisionTaskCompletedEventId(v int64) *WorkflowExecutionCanceledEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *WorkflowExecutionCanceledEventAttributes) SetDetails(v string) *WorkflowExecutionCanceledEventAttributes {
	s.Details = &v
	return s
}

// Provides the details of the WorkflowExecutionCompleted event.
type WorkflowExecutionCompletedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CompleteWorkflowExecution decision to complete this
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The result produced by the workflow execution upon successful completion.
	Result *string `locationName:"result" type:"string"`
}

// String returns the string representation
func (s WorkflowExecutionCompletedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionCompletedEventAttributes) GoString() string {
	return s.String()
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *WorkflowExecutionCompletedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *WorkflowExecutionCompletedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetResult sets the Result field's value.
func (s *WorkflowExecutionCompletedEventAttributes) SetResult(v string) *WorkflowExecutionCompletedEventAttributes {
	s.Result = &v
	return s
}

// The configuration settings for a workflow execution including timeout values,
// tasklist etc. These configuration settings are determined from the defaults
// specified when registering the workflow type and those specified when starting
// the workflow execution.
type WorkflowExecutionConfiguration struct {
	_ struct{} `type:"structure"`

	// The policy to use for the child workflow executions if this workflow execution
	// is terminated, by calling the TerminateWorkflowExecution action explicitly
	// or due to an expired timeout.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// ChildPolicy is a required field
	ChildPolicy *string `locationName:"childPolicy" type:"string" required:"true" enum:"ChildPolicy"`

	// The total duration for this workflow execution.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// ExecutionStartToCloseTimeout is a required field
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" min:"1" type:"string" required:"true"`

	// The IAM role attached to the child workflow execution.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The task list used for the decision tasks generated for this workflow execution.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// The priority assigned to decision tasks for this workflow execution. Valid
	// values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// The maximum duration allowed for decision tasks for this workflow execution.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	//
	// TaskStartToCloseTimeout is a required field
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionConfiguration) GoString() string {
	return s.String()
}

// SetChildPolicy sets the ChildPolicy field's value.
func (s *WorkflowExecutionConfiguration) SetChildPolicy(v string) *WorkflowExecutionConfiguration {
	s.ChildPolicy = &v
	return s
}

// SetExecutionStartToCloseTimeout sets the ExecutionStartToCloseTimeout field's value.
func (s *WorkflowExecutionConfiguration) SetExecutionStartToCloseTimeout(v string) *WorkflowExecutionConfiguration {
	s.ExecutionStartToCloseTimeout = &v
	return s
}

// SetLambdaRole sets the LambdaRole field's value.
func (s *WorkflowExecutionConfiguration) SetLambdaRole(v string) *WorkflowExecutionConfiguration {
	s.LambdaRole = &v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *WorkflowExecutionConfiguration) SetTaskList(v *TaskList) *WorkflowExecutionConfiguration {
	s.TaskList = v
	return s
}

// SetTaskPriority sets the TaskPriority field's value.
func (s *WorkflowExecutionConfiguration) SetTaskPriority(v string) *WorkflowExecutionConfiguration {
	s.TaskPriority = &v
	return s
}

// SetTaskStartToCloseTimeout sets the TaskStartToCloseTimeout field's value.
func (s *WorkflowExecutionConfiguration) SetTaskStartToCloseTimeout(v string) *WorkflowExecutionConfiguration {
	s.TaskStartToCloseTimeout = &v
	return s
}

// Provides the details of the WorkflowExecutionContinuedAsNew event.
type WorkflowExecutionContinuedAsNewEventAttributes struct {
	_ struct{} `type:"structure"`

	// The policy to use for the child workflow executions of the new execution
	// if it is terminated by calling the TerminateWorkflowExecution action explicitly
	// or due to an expired timeout.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// ChildPolicy is a required field
	ChildPolicy *string `locationName:"childPolicy" type:"string" required:"true" enum:"ChildPolicy"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the ContinueAsNewWorkflowExecution decision that started
	// this execution. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The total duration allowed for the new workflow execution.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The input provided to the new workflow execution.
	Input *string `locationName:"input" type:"string"`

	// The IAM role to attach to the new (continued) workflow execution.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The runId of the new workflow execution.
	//
	// NewExecutionRunId is a required field
	NewExecutionRunId *string `locationName:"newExecutionRunId" min:"1" type:"string" required:"true"`

	// The list of tags associated with the new workflow execution.
	TagList []*string `locationName:"tagList" type:"list"`

	// The task list to use for the decisions of the new (continued) workflow execution.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// The priority of the task to use for the decisions of the new (continued)
	// workflow execution.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// The maximum duration of decision tasks for the new workflow execution.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// The workflow type of this execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionContinuedAsNewEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionContinuedAsNewEventAttributes) GoString() string {
	return s.String()
}

// SetChildPolicy sets the ChildPolicy field's value.
func (s *WorkflowExecutionContinuedAsNewEventAttributes) SetChildPolicy(v string) *WorkflowExecutionContinuedAsNewEventAttributes {
	s.ChildPolicy = &v
	return s
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *WorkflowExecutionContinuedAsNewEventAttributes) SetDecisionTaskCompletedEventId(v int64) *WorkflowExecutionContinuedAsNewEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetExecutionStartToCloseTimeout sets the ExecutionStartToCloseTimeout field's value.
func (s *WorkflowExecutionContinuedAsNewEventAttributes) SetExecutionStartToCloseTimeout(v string) *WorkflowExecutionContinuedAsNewEventAttributes {
	s.ExecutionStartToCloseTimeout = &v
	return s
}

// SetInput sets the Input field's value.
func (s *WorkflowExecutionContinuedAsNewEventAttributes) SetInput(v string) *WorkflowExecutionContinuedAsNewEventAttributes {
	s.Input = &v
	return s
}

// SetLambdaRole sets the LambdaRole field's value.
func (s *WorkflowExecutionContinuedAsNewEventAttributes) SetLambdaRole(v string) *WorkflowExecutionContinuedAsNewEventAttributes {
	s.LambdaRole = &v
	return s
}

// SetNewExecutionRunId sets the NewExecutionRunId field's value.
func (s *WorkflowExecutionContinuedAsNewEventAttributes) SetNewExecutionRunId(v string) *WorkflowExecutionContinuedAsNewEventAttributes {
	s.NewExecutionRunId = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *WorkflowExecutionContinuedAsNewEventAttributes) SetTagList(v []*string) *WorkflowExecutionContinuedAsNewEventAttributes {
	s.TagList = v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *WorkflowExecutionContinuedAsNewEventAttributes) SetTaskList(v *TaskList) *WorkflowExecutionContinuedAsNewEventAttributes {
	s.TaskList = v
	return s
}

// SetTaskPriority sets the TaskPriority field's value.
func (s *WorkflowExecutionContinuedAsNewEventAttributes) SetTaskPriority(v string) *WorkflowExecutionContinuedAsNewEventAttributes {
	s.TaskPriority = &v
	return s
}

// SetTaskStartToCloseTimeout sets the TaskStartToCloseTimeout field's value.
func (s *WorkflowExecutionContinuedAsNewEventAttributes) SetTaskStartToCloseTimeout(v string) *WorkflowExecutionContinuedAsNewEventAttributes {
	s.TaskStartToCloseTimeout = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *WorkflowExecutionContinuedAsNewEventAttributes) SetWorkflowType(v *WorkflowType) *WorkflowExecutionContinuedAsNewEventAttributes {
	s.WorkflowType = v
	return s
}

// Contains the count of workflow executions returned from CountOpenWorkflowExecutions
// or CountClosedWorkflowExecutions
type WorkflowExecutionCount struct {
	_ struct{} `type:"structure"`

	// The number of workflow executions.
	//
	// Count is a required field
	Count *int64 `locationName:"count" type:"integer" required:"true"`

	// If set to true, indicates that the actual count was more than the maximum
	// supported by this API and the count returned is the truncated value.
	Truncated *bool `locationName:"truncated" type:"boolean"`
}

// String returns the string representation
func (s WorkflowExecutionCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionCount) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *WorkflowExecutionCount) SetCount(v int64) *WorkflowExecutionCount {
	s.Count = &v
	return s
}

// SetTruncated sets the Truncated field's value.
func (s *WorkflowExecutionCount) SetTruncated(v bool) *WorkflowExecutionCount {
	s.Truncated = &v
	return s
}

// Provides the details of the WorkflowExecutionFailed event.
type WorkflowExecutionFailedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the FailWorkflowExecution decision to fail this execution.
	// This information can be useful for diagnosing problems by tracing back the
	// chain of events leading up to this event.
	//
	// DecisionTaskCompletedEventId is a required field
	DecisionTaskCompletedEventId *int64 `locationName:"decisionTaskCompletedEventId" type:"long" required:"true"`

	// The details of the failure.
	Details *string `locationName:"details" type:"string"`

	// The descriptive reason provided for the failure.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation
func (s WorkflowExecutionFailedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionFailedEventAttributes) GoString() string {
	return s.String()
}

// SetDecisionTaskCompletedEventId sets the DecisionTaskCompletedEventId field's value.
func (s *WorkflowExecutionFailedEventAttributes) SetDecisionTaskCompletedEventId(v int64) *WorkflowExecutionFailedEventAttributes {
	s.DecisionTaskCompletedEventId = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *WorkflowExecutionFailedEventAttributes) SetDetails(v string) *WorkflowExecutionFailedEventAttributes {
	s.Details = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *WorkflowExecutionFailedEventAttributes) SetReason(v string) *WorkflowExecutionFailedEventAttributes {
	s.Reason = &v
	return s
}

// Used to filter the workflow executions in visibility APIs by their workflowId.
type WorkflowExecutionFilter struct {
	_ struct{} `type:"structure"`

	// The workflowId to pass of match the criteria of this filter.
	//
	// WorkflowId is a required field
	WorkflowId *string `locationName:"workflowId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkflowExecutionFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkflowExecutionFilter"}
	if s.WorkflowId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkflowId"))
	}
	if s.WorkflowId != nil && len(*s.WorkflowId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkflowId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkflowId sets the WorkflowId field's value.
func (s *WorkflowExecutionFilter) SetWorkflowId(v string) *WorkflowExecutionFilter {
	s.WorkflowId = &v
	return s
}

// Contains information about a workflow execution.
type WorkflowExecutionInfo struct {
	_ struct{} `type:"structure"`

	// Set to true if a cancellation is requested for this workflow execution.
	CancelRequested *bool `locationName:"cancelRequested" type:"boolean"`

	// If the execution status is closed then this specifies how the execution was
	// closed:
	//
	//    * COMPLETED – the execution was successfully completed.
	//
	//    * CANCELED – the execution was canceled.Cancellation allows the implementation
	//    to gracefully clean up before the execution is closed.
	//
	//    * TERMINATED – the execution was force terminated.
	//
	//    * FAILED – the execution failed to complete.
	//
	//    * TIMED_OUT – the execution did not complete in the alloted time and
	//    was automatically timed out.
	//
	//    * CONTINUED_AS_NEW – the execution is logically continued. This means
	//    the current execution was completed and a new execution was started to
	//    carry on the workflow.
	CloseStatus *string `locationName:"closeStatus" type:"string" enum:"CloseStatus"`

	// The time when the workflow execution was closed. Set only if the execution
	// status is CLOSED.
	CloseTimestamp *time.Time `locationName:"closeTimestamp" type:"timestamp"`

	// The workflow execution this information is about.
	//
	// Execution is a required field
	Execution *WorkflowExecution `locationName:"execution" type:"structure" required:"true"`

	// The current status of the execution.
	//
	// ExecutionStatus is a required field
	ExecutionStatus *string `locationName:"executionStatus" type:"string" required:"true" enum:"ExecutionStatus"`

	// If this workflow execution is a child of another execution then contains
	// the workflow execution that started this execution.
	Parent *WorkflowExecution `locationName:"parent" type:"structure"`

	// The time when the execution was started.
	//
	// StartTimestamp is a required field
	StartTimestamp *time.Time `locationName:"startTimestamp" type:"timestamp" required:"true"`

	// The list of tags associated with the workflow execution. Tags can be used
	// to identify and list workflow executions of interest through the visibility
	// APIs. A workflow execution can have a maximum of 5 tags.
	TagList []*string `locationName:"tagList" type:"list"`

	// The type of the workflow execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionInfo) GoString() string {
	return s.String()
}

// SetCancelRequested sets the CancelRequested field's value.
func (s *WorkflowExecutionInfo) SetCancelRequested(v bool) *WorkflowExecutionInfo {
	s.CancelRequested = &v
	return s
}

// SetCloseStatus sets the CloseStatus field's value.
func (s *WorkflowExecutionInfo) SetCloseStatus(v string) *WorkflowExecutionInfo {
	s.CloseStatus = &v
	return s
}

// SetCloseTimestamp sets the CloseTimestamp field's value.
func (s *WorkflowExecutionInfo) SetCloseTimestamp(v time.Time) *WorkflowExecutionInfo {
	s.CloseTimestamp = &v
	return s
}

// SetExecution sets the Execution field's value.
func (s *WorkflowExecutionInfo) SetExecution(v *WorkflowExecution) *WorkflowExecutionInfo {
	s.Execution = v
	return s
}

// SetExecutionStatus sets the ExecutionStatus field's value.
func (s *WorkflowExecutionInfo) SetExecutionStatus(v string) *WorkflowExecutionInfo {
	s.ExecutionStatus = &v
	return s
}

// SetParent sets the Parent field's value.
func (s *WorkflowExecutionInfo) SetParent(v *WorkflowExecution) *WorkflowExecutionInfo {
	s.Parent = v
	return s
}

// SetStartTimestamp sets the StartTimestamp field's value.
func (s *WorkflowExecutionInfo) SetStartTimestamp(v time.Time) *WorkflowExecutionInfo {
	s.StartTimestamp = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *WorkflowExecutionInfo) SetTagList(v []*string) *WorkflowExecutionInfo {
	s.TagList = v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *WorkflowExecutionInfo) SetWorkflowType(v *WorkflowType) *WorkflowExecutionInfo {
	s.WorkflowType = v
	return s
}

// Contains a paginated list of information about workflow executions.
type WorkflowExecutionInfos struct {
	_ struct{} `type:"structure"`

	// The list of workflow information structures.
	//
	// ExecutionInfos is a required field
	ExecutionInfos []*WorkflowExecutionInfo `locationName:"executionInfos" type:"list" required:"true"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`
}

// String returns the string representation
func (s WorkflowExecutionInfos) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionInfos) GoString() string {
	return s.String()
}

// SetExecutionInfos sets the ExecutionInfos field's value.
func (s *WorkflowExecutionInfos) SetExecutionInfos(v []*WorkflowExecutionInfo) *WorkflowExecutionInfos {
	s.ExecutionInfos = v
	return s
}

// SetNextPageToken sets the NextPageToken field's value.
func (s *WorkflowExecutionInfos) SetNextPageToken(v string) *WorkflowExecutionInfos {
	s.NextPageToken = &v
	return s
}

// Contains the counts of open tasks, child workflow executions and timers for
// a workflow execution.
type WorkflowExecutionOpenCounts struct {
	_ struct{} `type:"structure"`

	// The count of activity tasks whose status is OPEN.
	//
	// OpenActivityTasks is a required field
	OpenActivityTasks *int64 `locationName:"openActivityTasks" type:"integer" required:"true"`

	// The count of child workflow executions whose status is OPEN.
	//
	// OpenChildWorkflowExecutions is a required field
	OpenChildWorkflowExecutions *int64 `locationName:"openChildWorkflowExecutions" type:"integer" required:"true"`

	// The count of decision tasks whose status is OPEN. A workflow execution can
	// have at most one open decision task.
	//
	// OpenDecisionTasks is a required field
	OpenDecisionTasks *int64 `locationName:"openDecisionTasks" type:"integer" required:"true"`

	// The count of Lambda tasks whose status is OPEN.
	OpenLambdaFunctions *int64 `locationName:"openLambdaFunctions" type:"integer"`

	// The count of timers started by this workflow execution that have not fired
	// yet.
	//
	// OpenTimers is a required field
	OpenTimers *int64 `locationName:"openTimers" type:"integer" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionOpenCounts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionOpenCounts) GoString() string {
	return s.String()
}

// SetOpenActivityTasks sets the OpenActivityTasks field's value.
func (s *WorkflowExecutionOpenCounts) SetOpenActivityTasks(v int64) *WorkflowExecutionOpenCounts {
	s.OpenActivityTasks = &v
	return s
}

// SetOpenChildWorkflowExecutions sets the OpenChildWorkflowExecutions field's value.
func (s *WorkflowExecutionOpenCounts) SetOpenChildWorkflowExecutions(v int64) *WorkflowExecutionOpenCounts {
	s.OpenChildWorkflowExecutions = &v
	return s
}

// SetOpenDecisionTasks sets the OpenDecisionTasks field's value.
func (s *WorkflowExecutionOpenCounts) SetOpenDecisionTasks(v int64) *WorkflowExecutionOpenCounts {
	s.OpenDecisionTasks = &v
	return s
}

// SetOpenLambdaFunctions sets the OpenLambdaFunctions field's value.
func (s *WorkflowExecutionOpenCounts) SetOpenLambdaFunctions(v int64) *WorkflowExecutionOpenCounts {
	s.OpenLambdaFunctions = &v
	return s
}

// SetOpenTimers sets the OpenTimers field's value.
func (s *WorkflowExecutionOpenCounts) SetOpenTimers(v int64) *WorkflowExecutionOpenCounts {
	s.OpenTimers = &v
	return s
}

// Provides the details of the WorkflowExecutionSignaled event.
type WorkflowExecutionSignaledEventAttributes struct {
	_ struct{} `type:"structure"`

	// The ID of the SignalExternalWorkflowExecutionInitiated event corresponding
	// to the SignalExternalWorkflow decision to signal this workflow execution.The
	// source event with this ID can be found in the history of the source workflow
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event. This field is set only
	// if the signal was initiated by another workflow execution.
	ExternalInitiatedEventId *int64 `locationName:"externalInitiatedEventId" type:"long"`

	// The workflow execution that sent the signal. This is set only of the signal
	// was sent by another workflow execution.
	ExternalWorkflowExecution *WorkflowExecution `locationName:"externalWorkflowExecution" type:"structure"`

	// The inputs provided with the signal. The decider can use the signal name
	// and inputs to determine how to process the signal.
	Input *string `locationName:"input" type:"string"`

	// The name of the signal received. The decider can use the signal name and
	// inputs to determine how to the process the signal.
	//
	// SignalName is a required field
	SignalName *string `locationName:"signalName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionSignaledEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionSignaledEventAttributes) GoString() string {
	return s.String()
}

// SetExternalInitiatedEventId sets the ExternalInitiatedEventId field's value.
func (s *WorkflowExecutionSignaledEventAttributes) SetExternalInitiatedEventId(v int64) *WorkflowExecutionSignaledEventAttributes {
	s.ExternalInitiatedEventId = &v
	return s
}

// SetExternalWorkflowExecution sets the ExternalWorkflowExecution field's value.
func (s *WorkflowExecutionSignaledEventAttributes) SetExternalWorkflowExecution(v *WorkflowExecution) *WorkflowExecutionSignaledEventAttributes {
	s.ExternalWorkflowExecution = v
	return s
}

// SetInput sets the Input field's value.
func (s *WorkflowExecutionSignaledEventAttributes) SetInput(v string) *WorkflowExecutionSignaledEventAttributes {
	s.Input = &v
	return s
}

// SetSignalName sets the SignalName field's value.
func (s *WorkflowExecutionSignaledEventAttributes) SetSignalName(v string) *WorkflowExecutionSignaledEventAttributes {
	s.SignalName = &v
	return s
}

// Provides details of WorkflowExecutionStarted event.
type WorkflowExecutionStartedEventAttributes struct {
	_ struct{} `type:"structure"`

	// The policy to use for the child workflow executions if this workflow execution
	// is terminated, by calling the TerminateWorkflowExecution action explicitly
	// or due to an expired timeout.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// ChildPolicy is a required field
	ChildPolicy *string `locationName:"childPolicy" type:"string" required:"true" enum:"ChildPolicy"`

	// If this workflow execution was started due to a ContinueAsNewWorkflowExecution
	// decision, then it contains the runId of the previous workflow execution that
	// was closed and continued as this execution.
	ContinuedExecutionRunId *string `locationName:"continuedExecutionRunId" type:"string"`

	// The maximum duration for this workflow execution.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	ExecutionStartToCloseTimeout *string `locationName:"executionStartToCloseTimeout" type:"string"`

	// The input provided to the workflow execution.
	Input *string `locationName:"input" type:"string"`

	// The IAM role attached to the workflow execution.
	LambdaRole *string `locationName:"lambdaRole" min:"1" type:"string"`

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to
	// the StartChildWorkflowExecution Decision to start this workflow execution.
	// The source event with this ID can be found in the history of the source workflow
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	ParentInitiatedEventId *int64 `locationName:"parentInitiatedEventId" type:"long"`

	// The source workflow execution that started this workflow execution. The member
	// isn't set if the workflow execution was not started by a workflow.
	ParentWorkflowExecution *WorkflowExecution `locationName:"parentWorkflowExecution" type:"structure"`

	// The list of tags associated with this workflow execution. An execution can
	// have up to 5 tags.
	TagList []*string `locationName:"tagList" type:"list"`

	// The name of the task list for scheduling the decision tasks for this workflow
	// execution.
	//
	// TaskList is a required field
	TaskList *TaskList `locationName:"taskList" type:"structure" required:"true"`

	// The priority of the decision tasks in the workflow execution.
	TaskPriority *string `locationName:"taskPriority" type:"string"`

	// The maximum duration of decision tasks for this workflow type.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	TaskStartToCloseTimeout *string `locationName:"taskStartToCloseTimeout" type:"string"`

	// The workflow type of this execution.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s WorkflowExecutionStartedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionStartedEventAttributes) GoString() string {
	return s.String()
}

// SetChildPolicy sets the ChildPolicy field's value.
func (s *WorkflowExecutionStartedEventAttributes) SetChildPolicy(v string) *WorkflowExecutionStartedEventAttributes {
	s.ChildPolicy = &v
	return s
}

// SetContinuedExecutionRunId sets the ContinuedExecutionRunId field's value.
func (s *WorkflowExecutionStartedEventAttributes) SetContinuedExecutionRunId(v string) *WorkflowExecutionStartedEventAttributes {
	s.ContinuedExecutionRunId = &v
	return s
}

// SetExecutionStartToCloseTimeout sets the ExecutionStartToCloseTimeout field's value.
func (s *WorkflowExecutionStartedEventAttributes) SetExecutionStartToCloseTimeout(v string) *WorkflowExecutionStartedEventAttributes {
	s.ExecutionStartToCloseTimeout = &v
	return s
}

// SetInput sets the Input field's value.
func (s *WorkflowExecutionStartedEventAttributes) SetInput(v string) *WorkflowExecutionStartedEventAttributes {
	s.Input = &v
	return s
}

// SetLambdaRole sets the LambdaRole field's value.
func (s *WorkflowExecutionStartedEventAttributes) SetLambdaRole(v string) *WorkflowExecutionStartedEventAttributes {
	s.LambdaRole = &v
	return s
}

// SetParentInitiatedEventId sets the ParentInitiatedEventId field's value.
func (s *WorkflowExecutionStartedEventAttributes) SetParentInitiatedEventId(v int64) *WorkflowExecutionStartedEventAttributes {
	s.ParentInitiatedEventId = &v
	return s
}

// SetParentWorkflowExecution sets the ParentWorkflowExecution field's value.
func (s *WorkflowExecutionStartedEventAttributes) SetParentWorkflowExecution(v *WorkflowExecution) *WorkflowExecutionStartedEventAttributes {
	s.ParentWorkflowExecution = v
	return s
}

// SetTagList sets the TagList field's value.
func (s *WorkflowExecutionStartedEventAttributes) SetTagList(v []*string) *WorkflowExecutionStartedEventAttributes {
	s.TagList = v
	return s
}

// SetTaskList sets the TaskList field's value.
func (s *WorkflowExecutionStartedEventAttributes) SetTaskList(v *TaskList) *WorkflowExecutionStartedEventAttributes {
	s.TaskList = v
	return s
}

// SetTaskPriority sets the TaskPriority field's value.
func (s *WorkflowExecutionStartedEventAttributes) SetTaskPriority(v string) *WorkflowExecutionStartedEventAttributes {
	s.TaskPriority = &v
	return s
}

// SetTaskStartToCloseTimeout sets the TaskStartToCloseTimeout field's value.
func (s *WorkflowExecutionStartedEventAttributes) SetTaskStartToCloseTimeout(v string) *WorkflowExecutionStartedEventAttributes {
	s.TaskStartToCloseTimeout = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *WorkflowExecutionStartedEventAttributes) SetWorkflowType(v *WorkflowType) *WorkflowExecutionStartedEventAttributes {
	s.WorkflowType = v
	return s
}

// Provides the details of the WorkflowExecutionTerminated event.
type WorkflowExecutionTerminatedEventAttributes struct {
	_ struct{} `type:"structure"`

	// If set, indicates that the workflow execution was automatically terminated,
	// and specifies the cause. This happens if the parent workflow execution times
	// out or is terminated and the child policy is set to terminate child executions.
	Cause *string `locationName:"cause" type:"string" enum:"WorkflowExecutionTerminatedCause"`

	// The policy used for the child workflow executions of this workflow execution.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// ChildPolicy is a required field
	ChildPolicy *string `locationName:"childPolicy" type:"string" required:"true" enum:"ChildPolicy"`

	// The details provided for the termination.
	Details *string `locationName:"details" type:"string"`

	// The reason provided for the termination.
	Reason *string `locationName:"reason" type:"string"`
}

// String returns the string representation
func (s WorkflowExecutionTerminatedEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionTerminatedEventAttributes) GoString() string {
	return s.String()
}

// SetCause sets the Cause field's value.
func (s *WorkflowExecutionTerminatedEventAttributes) SetCause(v string) *WorkflowExecutionTerminatedEventAttributes {
	s.Cause = &v
	return s
}

// SetChildPolicy sets the ChildPolicy field's value.
func (s *WorkflowExecutionTerminatedEventAttributes) SetChildPolicy(v string) *WorkflowExecutionTerminatedEventAttributes {
	s.ChildPolicy = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *WorkflowExecutionTerminatedEventAttributes) SetDetails(v string) *WorkflowExecutionTerminatedEventAttributes {
	s.Details = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *WorkflowExecutionTerminatedEventAttributes) SetReason(v string) *WorkflowExecutionTerminatedEventAttributes {
	s.Reason = &v
	return s
}

// Provides the details of the WorkflowExecutionTimedOut event.
type WorkflowExecutionTimedOutEventAttributes struct {
	_ struct{} `type:"structure"`

	// The policy used for the child workflow executions of this workflow execution.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	//
	// ChildPolicy is a required field
	ChildPolicy *string `locationName:"childPolicy" type:"string" required:"true" enum:"ChildPolicy"`

	// The type of timeout that caused this event.
	//
	// TimeoutType is a required field
	TimeoutType *string `locationName:"timeoutType" type:"string" required:"true" enum:"WorkflowExecutionTimeoutType"`
}

// String returns the string representation
func (s WorkflowExecutionTimedOutEventAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowExecutionTimedOutEventAttributes) GoString() string {
	return s.String()
}

// SetChildPolicy sets the ChildPolicy field's value.
func (s *WorkflowExecutionTimedOutEventAttributes) SetChildPolicy(v string) *WorkflowExecutionTimedOutEventAttributes {
	s.ChildPolicy = &v
	return s
}

// SetTimeoutType sets the TimeoutType field's value.
func (s *WorkflowExecutionTimedOutEventAttributes) SetTimeoutType(v string) *WorkflowExecutionTimedOutEventAttributes {
	s.TimeoutType = &v
	return s
}

// Represents a workflow type.
type WorkflowType struct {
	_ struct{} `type:"structure"`

	// The name of the workflow type.
	//
	// The combination of workflow type name and version must be unique with in
	// a domain.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The version of the workflow type.
	//
	// The combination of workflow type name and version must be unique with in
	// a domain.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WorkflowType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowType) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkflowType) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkflowType"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *WorkflowType) SetName(v string) *WorkflowType {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *WorkflowType) SetVersion(v string) *WorkflowType {
	s.Version = &v
	return s
}

// The configuration settings of a workflow type.
type WorkflowTypeConfiguration struct {
	_ struct{} `type:"structure"`

	// The default policy to use for the child workflow executions when a workflow
	// execution of this type is terminated, by calling the TerminateWorkflowExecution
	// action explicitly or due to an expired timeout. This default can be overridden
	// when starting a workflow execution using the StartWorkflowExecution action
	// or the StartChildWorkflowExecution Decision.
	//
	// The supported child policies are:
	//
	//    * TERMINATE – The child executions are terminated.
	//
	//    * REQUEST_CANCEL – A request to cancel is attempted for each child execution
	//    by recording a WorkflowExecutionCancelRequested event in its history.
	//    It is up to the decider to take appropriate actions when it receives an
	//    execution history with this event.
	//
	//    * ABANDON – No action is taken. The child executions continue to run.
	DefaultChildPolicy *string `locationName:"defaultChildPolicy" type:"string" enum:"ChildPolicy"`

	// The default maximum duration, specified when registering the workflow type,
	// for executions of this workflow type. This default can be overridden when
	// starting a workflow execution using the StartWorkflowExecution action or
	// the StartChildWorkflowExecution Decision.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultExecutionStartToCloseTimeout *string `locationName:"defaultExecutionStartToCloseTimeout" type:"string"`

	// The default IAM role attached to this workflow type.
	//
	// Executions of this workflow type need IAM roles to invoke Lambda functions.
	// If you don't specify an IAM role when starting this workflow type, the default
	// Lambda role is attached to the execution. For more information, see https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html)
	// in the Amazon SWF Developer Guide.
	DefaultLambdaRole *string `locationName:"defaultLambdaRole" min:"1" type:"string"`

	// The default task list, specified when registering the workflow type, for
	// decisions tasks scheduled for workflow executions of this type. This default
	// can be overridden when starting a workflow execution using the StartWorkflowExecution
	// action or the StartChildWorkflowExecution Decision.
	DefaultTaskList *TaskList `locationName:"defaultTaskList" type:"structure"`

	// The default task priority, specified when registering the workflow type,
	// for all decision tasks of this workflow type. This default can be overridden
	// when starting a workflow execution using the StartWorkflowExecution action
	// or the StartChildWorkflowExecution decision.
	//
	// Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority.
	//
	// For more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	DefaultTaskPriority *string `locationName:"defaultTaskPriority" type:"string"`

	// The default maximum duration, specified when registering the workflow type,
	// that a decision task for executions of this workflow type might take before
	// returning completion or failure. If the task doesn'tdo close in the specified
	// time then the task is automatically timed out and rescheduled. If the decider
	// eventually reports a completion or failure, it is ignored. This default can
	// be overridden when starting a workflow execution using the StartWorkflowExecution
	// action or the StartChildWorkflowExecution Decision.
	//
	// The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration.
	DefaultTaskStartToCloseTimeout *string `locationName:"defaultTaskStartToCloseTimeout" type:"string"`
}

// String returns the string representation
func (s WorkflowTypeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowTypeConfiguration) GoString() string {
	return s.String()
}

// SetDefaultChildPolicy sets the DefaultChildPolicy field's value.
func (s *WorkflowTypeConfiguration) SetDefaultChildPolicy(v string) *WorkflowTypeConfiguration {
	s.DefaultChildPolicy = &v
	return s
}

// SetDefaultExecutionStartToCloseTimeout sets the DefaultExecutionStartToCloseTimeout field's value.
func (s *WorkflowTypeConfiguration) SetDefaultExecutionStartToCloseTimeout(v string) *WorkflowTypeConfiguration {
	s.DefaultExecutionStartToCloseTimeout = &v
	return s
}

// SetDefaultLambdaRole sets the DefaultLambdaRole field's value.
func (s *WorkflowTypeConfiguration) SetDefaultLambdaRole(v string) *WorkflowTypeConfiguration {
	s.DefaultLambdaRole = &v
	return s
}

// SetDefaultTaskList sets the DefaultTaskList field's value.
func (s *WorkflowTypeConfiguration) SetDefaultTaskList(v *TaskList) *WorkflowTypeConfiguration {
	s.DefaultTaskList = v
	return s
}

// SetDefaultTaskPriority sets the DefaultTaskPriority field's value.
func (s *WorkflowTypeConfiguration) SetDefaultTaskPriority(v string) *WorkflowTypeConfiguration {
	s.DefaultTaskPriority = &v
	return s
}

// SetDefaultTaskStartToCloseTimeout sets the DefaultTaskStartToCloseTimeout field's value.
func (s *WorkflowTypeConfiguration) SetDefaultTaskStartToCloseTimeout(v string) *WorkflowTypeConfiguration {
	s.DefaultTaskStartToCloseTimeout = &v
	return s
}

// Used to filter workflow execution query results by type. Each parameter,
// if specified, defines a rule that must be satisfied by each returned result.
type WorkflowTypeFilter struct {
	_ struct{} `type:"structure"`

	// Name of the workflow type.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Version of the workflow type.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s WorkflowTypeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowTypeFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkflowTypeFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkflowTypeFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *WorkflowTypeFilter) SetName(v string) *WorkflowTypeFilter {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *WorkflowTypeFilter) SetVersion(v string) *WorkflowTypeFilter {
	s.Version = &v
	return s
}

// Contains information about a workflow type.
type WorkflowTypeInfo struct {
	_ struct{} `type:"structure"`

	// The date when this type was registered.
	//
	// CreationDate is a required field
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" required:"true"`

	// If the type is in deprecated state, then it is set to the date when the type
	// was deprecated.
	DeprecationDate *time.Time `locationName:"deprecationDate" type:"timestamp"`

	// The description of the type registered through RegisterWorkflowType.
	Description *string `locationName:"description" type:"string"`

	// The current status of the workflow type.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"RegistrationStatus"`

	// The workflow type this information is about.
	//
	// WorkflowType is a required field
	WorkflowType *WorkflowType `locationName:"workflowType" type:"structure" required:"true"`
}

// String returns the string representation
func (s WorkflowTypeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkflowTypeInfo) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *WorkflowTypeInfo) SetCreationDate(v time.Time) *WorkflowTypeInfo {
	s.CreationDate = &v
	return s
}

// SetDeprecationDate sets the DeprecationDate field's value.
func (s *WorkflowTypeInfo) SetDeprecationDate(v time.Time) *WorkflowTypeInfo {
	s.DeprecationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkflowTypeInfo) SetDescription(v string) *WorkflowTypeInfo {
	s.Description = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkflowTypeInfo) SetStatus(v string) *WorkflowTypeInfo {
	s.Status = &v
	return s
}

// SetWorkflowType sets the WorkflowType field's value.
func (s *WorkflowTypeInfo) SetWorkflowType(v *WorkflowType) *WorkflowTypeInfo {
	s.WorkflowType = v
	return s
}

const (
	// ActivityTaskTimeoutTypeStartToClose is a ActivityTaskTimeoutType enum value
	ActivityTaskTimeoutTypeStartToClose = "START_TO_CLOSE"

	// ActivityTaskTimeoutTypeScheduleToStart is a ActivityTaskTimeoutType enum value
	ActivityTaskTimeoutTypeScheduleToStart = "SCHEDULE_TO_START"

	// ActivityTaskTimeoutTypeScheduleToClose is a ActivityTaskTimeoutType enum value
	ActivityTaskTimeoutTypeScheduleToClose = "SCHEDULE_TO_CLOSE"

	// ActivityTaskTimeoutTypeHeartbeat is a ActivityTaskTimeoutType enum value
	ActivityTaskTimeoutTypeHeartbeat = "HEARTBEAT"
)

const (
	// CancelTimerFailedCauseTimerIdUnknown is a CancelTimerFailedCause enum value
	CancelTimerFailedCauseTimerIdUnknown = "TIMER_ID_UNKNOWN"

	// CancelTimerFailedCauseOperationNotPermitted is a CancelTimerFailedCause enum value
	CancelTimerFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// CancelWorkflowExecutionFailedCauseUnhandledDecision is a CancelWorkflowExecutionFailedCause enum value
	CancelWorkflowExecutionFailedCauseUnhandledDecision = "UNHANDLED_DECISION"

	// CancelWorkflowExecutionFailedCauseOperationNotPermitted is a CancelWorkflowExecutionFailedCause enum value
	CancelWorkflowExecutionFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// ChildPolicyTerminate is a ChildPolicy enum value
	ChildPolicyTerminate = "TERMINATE"

	// ChildPolicyRequestCancel is a ChildPolicy enum value
	ChildPolicyRequestCancel = "REQUEST_CANCEL"

	// ChildPolicyAbandon is a ChildPolicy enum value
	ChildPolicyAbandon = "ABANDON"
)

const (
	// CloseStatusCompleted is a CloseStatus enum value
	CloseStatusCompleted = "COMPLETED"

	// CloseStatusFailed is a CloseStatus enum value
	CloseStatusFailed = "FAILED"

	// CloseStatusCanceled is a CloseStatus enum value
	CloseStatusCanceled = "CANCELED"

	// CloseStatusTerminated is a CloseStatus enum value
	CloseStatusTerminated = "TERMINATED"

	// CloseStatusContinuedAsNew is a CloseStatus enum value
	CloseStatusContinuedAsNew = "CONTINUED_AS_NEW"

	// CloseStatusTimedOut is a CloseStatus enum value
	CloseStatusTimedOut = "TIMED_OUT"
)

const (
	// CompleteWorkflowExecutionFailedCauseUnhandledDecision is a CompleteWorkflowExecutionFailedCause enum value
	CompleteWorkflowExecutionFailedCauseUnhandledDecision = "UNHANDLED_DECISION"

	// CompleteWorkflowExecutionFailedCauseOperationNotPermitted is a CompleteWorkflowExecutionFailedCause enum value
	CompleteWorkflowExecutionFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// ContinueAsNewWorkflowExecutionFailedCauseUnhandledDecision is a ContinueAsNewWorkflowExecutionFailedCause enum value
	ContinueAsNewWorkflowExecutionFailedCauseUnhandledDecision = "UNHANDLED_DECISION"

	// ContinueAsNewWorkflowExecutionFailedCauseWorkflowTypeDeprecated is a ContinueAsNewWorkflowExecutionFailedCause enum value
	ContinueAsNewWorkflowExecutionFailedCauseWorkflowTypeDeprecated = "WORKFLOW_TYPE_DEPRECATED"

	// ContinueAsNewWorkflowExecutionFailedCauseWorkflowTypeDoesNotExist is a ContinueAsNewWorkflowExecutionFailedCause enum value
	ContinueAsNewWorkflowExecutionFailedCauseWorkflowTypeDoesNotExist = "WORKFLOW_TYPE_DOES_NOT_EXIST"

	// ContinueAsNewWorkflowExecutionFailedCauseDefaultExecutionStartToCloseTimeoutUndefined is a ContinueAsNewWorkflowExecutionFailedCause enum value
	ContinueAsNewWorkflowExecutionFailedCauseDefaultExecutionStartToCloseTimeoutUndefined = "DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED"

	// ContinueAsNewWorkflowExecutionFailedCauseDefaultTaskStartToCloseTimeoutUndefined is a ContinueAsNewWorkflowExecutionFailedCause enum value
	ContinueAsNewWorkflowExecutionFailedCauseDefaultTaskStartToCloseTimeoutUndefined = "DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED"

	// ContinueAsNewWorkflowExecutionFailedCauseDefaultTaskListUndefined is a ContinueAsNewWorkflowExecutionFailedCause enum value
	ContinueAsNewWorkflowExecutionFailedCauseDefaultTaskListUndefined = "DEFAULT_TASK_LIST_UNDEFINED"

	// ContinueAsNewWorkflowExecutionFailedCauseDefaultChildPolicyUndefined is a ContinueAsNewWorkflowExecutionFailedCause enum value
	ContinueAsNewWorkflowExecutionFailedCauseDefaultChildPolicyUndefined = "DEFAULT_CHILD_POLICY_UNDEFINED"

	// ContinueAsNewWorkflowExecutionFailedCauseContinueAsNewWorkflowExecutionRateExceeded is a ContinueAsNewWorkflowExecutionFailedCause enum value
	ContinueAsNewWorkflowExecutionFailedCauseContinueAsNewWorkflowExecutionRateExceeded = "CONTINUE_AS_NEW_WORKFLOW_EXECUTION_RATE_EXCEEDED"

	// ContinueAsNewWorkflowExecutionFailedCauseOperationNotPermitted is a ContinueAsNewWorkflowExecutionFailedCause enum value
	ContinueAsNewWorkflowExecutionFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// DecisionTaskTimeoutTypeStartToClose is a DecisionTaskTimeoutType enum value
	DecisionTaskTimeoutTypeStartToClose = "START_TO_CLOSE"
)

const (
	// DecisionTypeScheduleActivityTask is a DecisionType enum value
	DecisionTypeScheduleActivityTask = "ScheduleActivityTask"

	// DecisionTypeRequestCancelActivityTask is a DecisionType enum value
	DecisionTypeRequestCancelActivityTask = "RequestCancelActivityTask"

	// DecisionTypeCompleteWorkflowExecution is a DecisionType enum value
	DecisionTypeCompleteWorkflowExecution = "CompleteWorkflowExecution"

	// DecisionTypeFailWorkflowExecution is a DecisionType enum value
	DecisionTypeFailWorkflowExecution = "FailWorkflowExecution"

	// DecisionTypeCancelWorkflowExecution is a DecisionType enum value
	DecisionTypeCancelWorkflowExecution = "CancelWorkflowExecution"

	// DecisionTypeContinueAsNewWorkflowExecution is a DecisionType enum value
	DecisionTypeContinueAsNewWorkflowExecution = "ContinueAsNewWorkflowExecution"

	// DecisionTypeRecordMarker is a DecisionType enum value
	DecisionTypeRecordMarker = "RecordMarker"

	// DecisionTypeStartTimer is a DecisionType enum value
	DecisionTypeStartTimer = "StartTimer"

	// DecisionTypeCancelTimer is a DecisionType enum value
	DecisionTypeCancelTimer = "CancelTimer"

	// DecisionTypeSignalExternalWorkflowExecution is a DecisionType enum value
	DecisionTypeSignalExternalWorkflowExecution = "SignalExternalWorkflowExecution"

	// DecisionTypeRequestCancelExternalWorkflowExecution is a DecisionType enum value
	DecisionTypeRequestCancelExternalWorkflowExecution = "RequestCancelExternalWorkflowExecution"

	// DecisionTypeStartChildWorkflowExecution is a DecisionType enum value
	DecisionTypeStartChildWorkflowExecution = "StartChildWorkflowExecution"

	// DecisionTypeScheduleLambdaFunction is a DecisionType enum value
	DecisionTypeScheduleLambdaFunction = "ScheduleLambdaFunction"
)

const (
	// EventTypeWorkflowExecutionStarted is a EventType enum value
	EventTypeWorkflowExecutionStarted = "WorkflowExecutionStarted"

	// EventTypeWorkflowExecutionCancelRequested is a EventType enum value
	EventTypeWorkflowExecutionCancelRequested = "WorkflowExecutionCancelRequested"

	// EventTypeWorkflowExecutionCompleted is a EventType enum value
	EventTypeWorkflowExecutionCompleted = "WorkflowExecutionCompleted"

	// EventTypeCompleteWorkflowExecutionFailed is a EventType enum value
	EventTypeCompleteWorkflowExecutionFailed = "CompleteWorkflowExecutionFailed"

	// EventTypeWorkflowExecutionFailed is a EventType enum value
	EventTypeWorkflowExecutionFailed = "WorkflowExecutionFailed"

	// EventTypeFailWorkflowExecutionFailed is a EventType enum value
	EventTypeFailWorkflowExecutionFailed = "FailWorkflowExecutionFailed"

	// EventTypeWorkflowExecutionTimedOut is a EventType enum value
	EventTypeWorkflowExecutionTimedOut = "WorkflowExecutionTimedOut"

	// EventTypeWorkflowExecutionCanceled is a EventType enum value
	EventTypeWorkflowExecutionCanceled = "WorkflowExecutionCanceled"

	// EventTypeCancelWorkflowExecutionFailed is a EventType enum value
	EventTypeCancelWorkflowExecutionFailed = "CancelWorkflowExecutionFailed"

	// EventTypeWorkflowExecutionContinuedAsNew is a EventType enum value
	EventTypeWorkflowExecutionContinuedAsNew = "WorkflowExecutionContinuedAsNew"

	// EventTypeContinueAsNewWorkflowExecutionFailed is a EventType enum value
	EventTypeContinueAsNewWorkflowExecutionFailed = "ContinueAsNewWorkflowExecutionFailed"

	// EventTypeWorkflowExecutionTerminated is a EventType enum value
	EventTypeWorkflowExecutionTerminated = "WorkflowExecutionTerminated"

	// EventTypeDecisionTaskScheduled is a EventType enum value
	EventTypeDecisionTaskScheduled = "DecisionTaskScheduled"

	// EventTypeDecisionTaskStarted is a EventType enum value
	EventTypeDecisionTaskStarted = "DecisionTaskStarted"

	// EventTypeDecisionTaskCompleted is a EventType enum value
	EventTypeDecisionTaskCompleted = "DecisionTaskCompleted"

	// EventTypeDecisionTaskTimedOut is a EventType enum value
	EventTypeDecisionTaskTimedOut = "DecisionTaskTimedOut"

	// EventTypeActivityTaskScheduled is a EventType enum value
	EventTypeActivityTaskScheduled = "ActivityTaskScheduled"

	// EventTypeScheduleActivityTaskFailed is a EventType enum value
	EventTypeScheduleActivityTaskFailed = "ScheduleActivityTaskFailed"

	// EventTypeActivityTaskStarted is a EventType enum value
	EventTypeActivityTaskStarted = "ActivityTaskStarted"

	// EventTypeActivityTaskCompleted is a EventType enum value
	EventTypeActivityTaskCompleted = "ActivityTaskCompleted"

	// EventTypeActivityTaskFailed is a EventType enum value
	EventTypeActivityTaskFailed = "ActivityTaskFailed"

	// EventTypeActivityTaskTimedOut is a EventType enum value
	EventTypeActivityTaskTimedOut = "ActivityTaskTimedOut"

	// EventTypeActivityTaskCanceled is a EventType enum value
	EventTypeActivityTaskCanceled = "ActivityTaskCanceled"

	// EventTypeActivityTaskCancelRequested is a EventType enum value
	EventTypeActivityTaskCancelRequested = "ActivityTaskCancelRequested"

	// EventTypeRequestCancelActivityTaskFailed is a EventType enum value
	EventTypeRequestCancelActivityTaskFailed = "RequestCancelActivityTaskFailed"

	// EventTypeWorkflowExecutionSignaled is a EventType enum value
	EventTypeWorkflowExecutionSignaled = "WorkflowExecutionSignaled"

	// EventTypeMarkerRecorded is a EventType enum value
	EventTypeMarkerRecorded = "MarkerRecorded"

	// EventTypeRecordMarkerFailed is a EventType enum value
	EventTypeRecordMarkerFailed = "RecordMarkerFailed"

	// EventTypeTimerStarted is a EventType enum value
	EventTypeTimerStarted = "TimerStarted"

	// EventTypeStartTimerFailed is a EventType enum value
	EventTypeStartTimerFailed = "StartTimerFailed"

	// EventTypeTimerFired is a EventType enum value
	EventTypeTimerFired = "TimerFired"

	// EventTypeTimerCanceled is a EventType enum value
	EventTypeTimerCanceled = "TimerCanceled"

	// EventTypeCancelTimerFailed is a EventType enum value
	EventTypeCancelTimerFailed = "CancelTimerFailed"

	// EventTypeStartChildWorkflowExecutionInitiated is a EventType enum value
	EventTypeStartChildWorkflowExecutionInitiated = "StartChildWorkflowExecutionInitiated"

	// EventTypeStartChildWorkflowExecutionFailed is a EventType enum value
	EventTypeStartChildWorkflowExecutionFailed = "StartChildWorkflowExecutionFailed"

	// EventTypeChildWorkflowExecutionStarted is a EventType enum value
	EventTypeChildWorkflowExecutionStarted = "ChildWorkflowExecutionStarted"

	// EventTypeChildWorkflowExecutionCompleted is a EventType enum value
	EventTypeChildWorkflowExecutionCompleted = "ChildWorkflowExecutionCompleted"

	// EventTypeChildWorkflowExecutionFailed is a EventType enum value
	EventTypeChildWorkflowExecutionFailed = "ChildWorkflowExecutionFailed"

	// EventTypeChildWorkflowExecutionTimedOut is a EventType enum value
	EventTypeChildWorkflowExecutionTimedOut = "ChildWorkflowExecutionTimedOut"

	// EventTypeChildWorkflowExecutionCanceled is a EventType enum value
	EventTypeChildWorkflowExecutionCanceled = "ChildWorkflowExecutionCanceled"

	// EventTypeChildWorkflowExecutionTerminated is a EventType enum value
	EventTypeChildWorkflowExecutionTerminated = "ChildWorkflowExecutionTerminated"

	// EventTypeSignalExternalWorkflowExecutionInitiated is a EventType enum value
	EventTypeSignalExternalWorkflowExecutionInitiated = "SignalExternalWorkflowExecutionInitiated"

	// EventTypeSignalExternalWorkflowExecutionFailed is a EventType enum value
	EventTypeSignalExternalWorkflowExecutionFailed = "SignalExternalWorkflowExecutionFailed"

	// EventTypeExternalWorkflowExecutionSignaled is a EventType enum value
	EventTypeExternalWorkflowExecutionSignaled = "ExternalWorkflowExecutionSignaled"

	// EventTypeRequestCancelExternalWorkflowExecutionInitiated is a EventType enum value
	EventTypeRequestCancelExternalWorkflowExecutionInitiated = "RequestCancelExternalWorkflowExecutionInitiated"

	// EventTypeRequestCancelExternalWorkflowExecutionFailed is a EventType enum value
	EventTypeRequestCancelExternalWorkflowExecutionFailed = "RequestCancelExternalWorkflowExecutionFailed"

	// EventTypeExternalWorkflowExecutionCancelRequested is a EventType enum value
	EventTypeExternalWorkflowExecutionCancelRequested = "ExternalWorkflowExecutionCancelRequested"

	// EventTypeLambdaFunctionScheduled is a EventType enum value
	EventTypeLambdaFunctionScheduled = "LambdaFunctionScheduled"

	// EventTypeLambdaFunctionStarted is a EventType enum value
	EventTypeLambdaFunctionStarted = "LambdaFunctionStarted"

	// EventTypeLambdaFunctionCompleted is a EventType enum value
	EventTypeLambdaFunctionCompleted = "LambdaFunctionCompleted"

	// EventTypeLambdaFunctionFailed is a EventType enum value
	EventTypeLambdaFunctionFailed = "LambdaFunctionFailed"

	// EventTypeLambdaFunctionTimedOut is a EventType enum value
	EventTypeLambdaFunctionTimedOut = "LambdaFunctionTimedOut"

	// EventTypeScheduleLambdaFunctionFailed is a EventType enum value
	EventTypeScheduleLambdaFunctionFailed = "ScheduleLambdaFunctionFailed"

	// EventTypeStartLambdaFunctionFailed is a EventType enum value
	EventTypeStartLambdaFunctionFailed = "StartLambdaFunctionFailed"
)

const (
	// ExecutionStatusOpen is a ExecutionStatus enum value
	ExecutionStatusOpen = "OPEN"

	// ExecutionStatusClosed is a ExecutionStatus enum value
	ExecutionStatusClosed = "CLOSED"
)

const (
	// FailWorkflowExecutionFailedCauseUnhandledDecision is a FailWorkflowExecutionFailedCause enum value
	FailWorkflowExecutionFailedCauseUnhandledDecision = "UNHANDLED_DECISION"

	// FailWorkflowExecutionFailedCauseOperationNotPermitted is a FailWorkflowExecutionFailedCause enum value
	FailWorkflowExecutionFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// LambdaFunctionTimeoutTypeStartToClose is a LambdaFunctionTimeoutType enum value
	LambdaFunctionTimeoutTypeStartToClose = "START_TO_CLOSE"
)

const (
	// RecordMarkerFailedCauseOperationNotPermitted is a RecordMarkerFailedCause enum value
	RecordMarkerFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// RegistrationStatusRegistered is a RegistrationStatus enum value
	RegistrationStatusRegistered = "REGISTERED"

	// RegistrationStatusDeprecated is a RegistrationStatus enum value
	RegistrationStatusDeprecated = "DEPRECATED"
)

const (
	// RequestCancelActivityTaskFailedCauseActivityIdUnknown is a RequestCancelActivityTaskFailedCause enum value
	RequestCancelActivityTaskFailedCauseActivityIdUnknown = "ACTIVITY_ID_UNKNOWN"

	// RequestCancelActivityTaskFailedCauseOperationNotPermitted is a RequestCancelActivityTaskFailedCause enum value
	RequestCancelActivityTaskFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// RequestCancelExternalWorkflowExecutionFailedCauseUnknownExternalWorkflowExecution is a RequestCancelExternalWorkflowExecutionFailedCause enum value
	RequestCancelExternalWorkflowExecutionFailedCauseUnknownExternalWorkflowExecution = "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION"

	// RequestCancelExternalWorkflowExecutionFailedCauseRequestCancelExternalWorkflowExecutionRateExceeded is a RequestCancelExternalWorkflowExecutionFailedCause enum value
	RequestCancelExternalWorkflowExecutionFailedCauseRequestCancelExternalWorkflowExecutionRateExceeded = "REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED"

	// RequestCancelExternalWorkflowExecutionFailedCauseOperationNotPermitted is a RequestCancelExternalWorkflowExecutionFailedCause enum value
	RequestCancelExternalWorkflowExecutionFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// ScheduleActivityTaskFailedCauseActivityTypeDeprecated is a ScheduleActivityTaskFailedCause enum value
	ScheduleActivityTaskFailedCauseActivityTypeDeprecated = "ACTIVITY_TYPE_DEPRECATED"

	// ScheduleActivityTaskFailedCauseActivityTypeDoesNotExist is a ScheduleActivityTaskFailedCause enum value
	ScheduleActivityTaskFailedCauseActivityTypeDoesNotExist = "ACTIVITY_TYPE_DOES_NOT_EXIST"

	// ScheduleActivityTaskFailedCauseActivityIdAlreadyInUse is a ScheduleActivityTaskFailedCause enum value
	ScheduleActivityTaskFailedCauseActivityIdAlreadyInUse = "ACTIVITY_ID_ALREADY_IN_USE"

	// ScheduleActivityTaskFailedCauseOpenActivitiesLimitExceeded is a ScheduleActivityTaskFailedCause enum value
	ScheduleActivityTaskFailedCauseOpenActivitiesLimitExceeded = "OPEN_ACTIVITIES_LIMIT_EXCEEDED"

	// ScheduleActivityTaskFailedCauseActivityCreationRateExceeded is a ScheduleActivityTaskFailedCause enum value
	ScheduleActivityTaskFailedCauseActivityCreationRateExceeded = "ACTIVITY_CREATION_RATE_EXCEEDED"

	// ScheduleActivityTaskFailedCauseDefaultScheduleToCloseTimeoutUndefined is a ScheduleActivityTaskFailedCause enum value
	ScheduleActivityTaskFailedCauseDefaultScheduleToCloseTimeoutUndefined = "DEFAULT_SCHEDULE_TO_CLOSE_TIMEOUT_UNDEFINED"

	// ScheduleActivityTaskFailedCauseDefaultTaskListUndefined is a ScheduleActivityTaskFailedCause enum value
	ScheduleActivityTaskFailedCauseDefaultTaskListUndefined = "DEFAULT_TASK_LIST_UNDEFINED"

	// ScheduleActivityTaskFailedCauseDefaultScheduleToStartTimeoutUndefined is a ScheduleActivityTaskFailedCause enum value
	ScheduleActivityTaskFailedCauseDefaultScheduleToStartTimeoutUndefined = "DEFAULT_SCHEDULE_TO_START_TIMEOUT_UNDEFINED"

	// ScheduleActivityTaskFailedCauseDefaultStartToCloseTimeoutUndefined is a ScheduleActivityTaskFailedCause enum value
	ScheduleActivityTaskFailedCauseDefaultStartToCloseTimeoutUndefined = "DEFAULT_START_TO_CLOSE_TIMEOUT_UNDEFINED"

	// ScheduleActivityTaskFailedCauseDefaultHeartbeatTimeoutUndefined is a ScheduleActivityTaskFailedCause enum value
	ScheduleActivityTaskFailedCauseDefaultHeartbeatTimeoutUndefined = "DEFAULT_HEARTBEAT_TIMEOUT_UNDEFINED"

	// ScheduleActivityTaskFailedCauseOperationNotPermitted is a ScheduleActivityTaskFailedCause enum value
	ScheduleActivityTaskFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// ScheduleLambdaFunctionFailedCauseIdAlreadyInUse is a ScheduleLambdaFunctionFailedCause enum value
	ScheduleLambdaFunctionFailedCauseIdAlreadyInUse = "ID_ALREADY_IN_USE"

	// ScheduleLambdaFunctionFailedCauseOpenLambdaFunctionsLimitExceeded is a ScheduleLambdaFunctionFailedCause enum value
	ScheduleLambdaFunctionFailedCauseOpenLambdaFunctionsLimitExceeded = "OPEN_LAMBDA_FUNCTIONS_LIMIT_EXCEEDED"

	// ScheduleLambdaFunctionFailedCauseLambdaFunctionCreationRateExceeded is a ScheduleLambdaFunctionFailedCause enum value
	ScheduleLambdaFunctionFailedCauseLambdaFunctionCreationRateExceeded = "LAMBDA_FUNCTION_CREATION_RATE_EXCEEDED"

	// ScheduleLambdaFunctionFailedCauseLambdaServiceNotAvailableInRegion is a ScheduleLambdaFunctionFailedCause enum value
	ScheduleLambdaFunctionFailedCauseLambdaServiceNotAvailableInRegion = "LAMBDA_SERVICE_NOT_AVAILABLE_IN_REGION"
)

const (
	// SignalExternalWorkflowExecutionFailedCauseUnknownExternalWorkflowExecution is a SignalExternalWorkflowExecutionFailedCause enum value
	SignalExternalWorkflowExecutionFailedCauseUnknownExternalWorkflowExecution = "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION"

	// SignalExternalWorkflowExecutionFailedCauseSignalExternalWorkflowExecutionRateExceeded is a SignalExternalWorkflowExecutionFailedCause enum value
	SignalExternalWorkflowExecutionFailedCauseSignalExternalWorkflowExecutionRateExceeded = "SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED"

	// SignalExternalWorkflowExecutionFailedCauseOperationNotPermitted is a SignalExternalWorkflowExecutionFailedCause enum value
	SignalExternalWorkflowExecutionFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// StartChildWorkflowExecutionFailedCauseWorkflowTypeDoesNotExist is a StartChildWorkflowExecutionFailedCause enum value
	StartChildWorkflowExecutionFailedCauseWorkflowTypeDoesNotExist = "WORKFLOW_TYPE_DOES_NOT_EXIST"

	// StartChildWorkflowExecutionFailedCauseWorkflowTypeDeprecated is a StartChildWorkflowExecutionFailedCause enum value
	StartChildWorkflowExecutionFailedCauseWorkflowTypeDeprecated = "WORKFLOW_TYPE_DEPRECATED"

	// StartChildWorkflowExecutionFailedCauseOpenChildrenLimitExceeded is a StartChildWorkflowExecutionFailedCause enum value
	StartChildWorkflowExecutionFailedCauseOpenChildrenLimitExceeded = "OPEN_CHILDREN_LIMIT_EXCEEDED"

	// StartChildWorkflowExecutionFailedCauseOpenWorkflowsLimitExceeded is a StartChildWorkflowExecutionFailedCause enum value
	StartChildWorkflowExecutionFailedCauseOpenWorkflowsLimitExceeded = "OPEN_WORKFLOWS_LIMIT_EXCEEDED"

	// StartChildWorkflowExecutionFailedCauseChildCreationRateExceeded is a StartChildWorkflowExecutionFailedCause enum value
	StartChildWorkflowExecutionFailedCauseChildCreationRateExceeded = "CHILD_CREATION_RATE_EXCEEDED"

	// StartChildWorkflowExecutionFailedCauseWorkflowAlreadyRunning is a StartChildWorkflowExecutionFailedCause enum value
	StartChildWorkflowExecutionFailedCauseWorkflowAlreadyRunning = "WORKFLOW_ALREADY_RUNNING"

	// StartChildWorkflowExecutionFailedCauseDefaultExecutionStartToCloseTimeoutUndefined is a StartChildWorkflowExecutionFailedCause enum value
	StartChildWorkflowExecutionFailedCauseDefaultExecutionStartToCloseTimeoutUndefined = "DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED"

	// StartChildWorkflowExecutionFailedCauseDefaultTaskListUndefined is a StartChildWorkflowExecutionFailedCause enum value
	StartChildWorkflowExecutionFailedCauseDefaultTaskListUndefined = "DEFAULT_TASK_LIST_UNDEFINED"

	// StartChildWorkflowExecutionFailedCauseDefaultTaskStartToCloseTimeoutUndefined is a StartChildWorkflowExecutionFailedCause enum value
	StartChildWorkflowExecutionFailedCauseDefaultTaskStartToCloseTimeoutUndefined = "DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED"

	// StartChildWorkflowExecutionFailedCauseDefaultChildPolicyUndefined is a StartChildWorkflowExecutionFailedCause enum value
	StartChildWorkflowExecutionFailedCauseDefaultChildPolicyUndefined = "DEFAULT_CHILD_POLICY_UNDEFINED"

	// StartChildWorkflowExecutionFailedCauseOperationNotPermitted is a StartChildWorkflowExecutionFailedCause enum value
	StartChildWorkflowExecutionFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// StartLambdaFunctionFailedCauseAssumeRoleFailed is a StartLambdaFunctionFailedCause enum value
	StartLambdaFunctionFailedCauseAssumeRoleFailed = "ASSUME_ROLE_FAILED"
)

const (
	// StartTimerFailedCauseTimerIdAlreadyInUse is a StartTimerFailedCause enum value
	StartTimerFailedCauseTimerIdAlreadyInUse = "TIMER_ID_ALREADY_IN_USE"

	// StartTimerFailedCauseOpenTimersLimitExceeded is a StartTimerFailedCause enum value
	StartTimerFailedCauseOpenTimersLimitExceeded = "OPEN_TIMERS_LIMIT_EXCEEDED"

	// StartTimerFailedCauseTimerCreationRateExceeded is a StartTimerFailedCause enum value
	StartTimerFailedCauseTimerCreationRateExceeded = "TIMER_CREATION_RATE_EXCEEDED"

	// StartTimerFailedCauseOperationNotPermitted is a StartTimerFailedCause enum value
	StartTimerFailedCauseOperationNotPermitted = "OPERATION_NOT_PERMITTED"
)

const (
	// WorkflowExecutionCancelRequestedCauseChildPolicyApplied is a WorkflowExecutionCancelRequestedCause enum value
	WorkflowExecutionCancelRequestedCauseChildPolicyApplied = "CHILD_POLICY_APPLIED"
)

const (
	// WorkflowExecutionTerminatedCauseChildPolicyApplied is a WorkflowExecutionTerminatedCause enum value
	WorkflowExecutionTerminatedCauseChildPolicyApplied = "CHILD_POLICY_APPLIED"

	// WorkflowExecutionTerminatedCauseEventLimitExceeded is a WorkflowExecutionTerminatedCause enum value
	WorkflowExecutionTerminatedCauseEventLimitExceeded = "EVENT_LIMIT_EXCEEDED"

	// WorkflowExecutionTerminatedCauseOperatorInitiated is a WorkflowExecutionTerminatedCause enum value
	WorkflowExecutionTerminatedCauseOperatorInitiated = "OPERATOR_INITIATED"
)

const (
	// WorkflowExecutionTimeoutTypeStartToClose is a WorkflowExecutionTimeoutType enum value
	WorkflowExecutionTimeoutTypeStartToClose = "START_TO_CLOSE"
)
