// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/backend.proto

package serviceconfig // import "google.golang.org/genproto/googleapis/api/serviceconfig"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Path Translation specifies how to combine the backend address with the
// request path in order to produce the appropriate forwarding URL for the
// request.
//
// Path Translation is applicable only to HTTP-based backends. Backends which
// do not accept requests over HTTP/HTTPS should leave `path_translation`
// unspecified.
type BackendRule_PathTranslation int32

const (
	BackendRule_PATH_TRANSLATION_UNSPECIFIED BackendRule_PathTranslation = 0
	// Use the backend address as-is, with no modification to the path. If the
	// URL pattern contains variables, the variable names and values will be
	// appended to the query string. If a query string parameter and a URL
	// pattern variable have the same name, this may result in duplicate keys in
	// the query string.
	//
	// # Examples
	//
	// Given the following operation config:
	//
	//     Method path:        /api/company/{cid}/user/{uid}
	//     Backend address:    https://example.cloudfunctions.net/getUser
	//
	// Requests to the following request paths will call the backend at the
	// translated path:
	//
	//     Request path: /api/company/widgetworks/user/johndoe
	//     Translated:
	//     https://example.cloudfunctions.net/getUser?cid=widgetworks&uid=johndoe
	//
	//     Request path: /api/company/widgetworks/user/johndoe?timezone=EST
	//     Translated:
	//     https://example.cloudfunctions.net/getUser?timezone=EST&cid=widgetworks&uid=johndoe
	BackendRule_CONSTANT_ADDRESS BackendRule_PathTranslation = 1
	// The request path will be appended to the backend address.
	//
	// # Examples
	//
	// Given the following operation config:
	//
	//     Method path:        /api/company/{cid}/user/{uid}
	//     Backend address:    https://example.appspot.com
	//
	// Requests to the following request paths will call the backend at the
	// translated path:
	//
	//     Request path: /api/company/widgetworks/user/johndoe
	//     Translated:
	//     https://example.appspot.com/api/company/widgetworks/user/johndoe
	//
	//     Request path: /api/company/widgetworks/user/johndoe?timezone=EST
	//     Translated:
	//     https://example.appspot.com/api/company/widgetworks/user/johndoe?timezone=EST
	BackendRule_APPEND_PATH_TO_ADDRESS BackendRule_PathTranslation = 2
)

var BackendRule_PathTranslation_name = map[int32]string{
	0: "PATH_TRANSLATION_UNSPECIFIED",
	1: "CONSTANT_ADDRESS",
	2: "APPEND_PATH_TO_ADDRESS",
}
var BackendRule_PathTranslation_value = map[string]int32{
	"PATH_TRANSLATION_UNSPECIFIED": 0,
	"CONSTANT_ADDRESS":             1,
	"APPEND_PATH_TO_ADDRESS":       2,
}

func (x BackendRule_PathTranslation) String() string {
	return proto.EnumName(BackendRule_PathTranslation_name, int32(x))
}
func (BackendRule_PathTranslation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_backend_151dd2805952955b, []int{1, 0}
}

// `Backend` defines the backend configuration for a service.
type Backend struct {
	// A list of API backend rules that apply to individual API methods.
	//
	// **NOTE:** All service configuration rules follow "last one wins" order.
	Rules                []*BackendRule `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Backend) Reset()         { *m = Backend{} }
func (m *Backend) String() string { return proto.CompactTextString(m) }
func (*Backend) ProtoMessage()    {}
func (*Backend) Descriptor() ([]byte, []int) {
	return fileDescriptor_backend_151dd2805952955b, []int{0}
}
func (m *Backend) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Backend.Unmarshal(m, b)
}
func (m *Backend) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Backend.Marshal(b, m, deterministic)
}
func (dst *Backend) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Backend.Merge(dst, src)
}
func (m *Backend) XXX_Size() int {
	return xxx_messageInfo_Backend.Size(m)
}
func (m *Backend) XXX_DiscardUnknown() {
	xxx_messageInfo_Backend.DiscardUnknown(m)
}

var xxx_messageInfo_Backend proto.InternalMessageInfo

func (m *Backend) GetRules() []*BackendRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

// A backend rule provides configuration for an individual API element.
type BackendRule struct {
	// Selects the methods to which this rule applies.
	//
	// Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
	Selector string `protobuf:"bytes,1,opt,name=selector,proto3" json:"selector,omitempty"`
	// The address of the API backend.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// The number of seconds to wait for a response from a request.  The default
	// deadline for gRPC is infinite (no deadline) and HTTP requests is 5 seconds.
	Deadline float64 `protobuf:"fixed64,3,opt,name=deadline,proto3" json:"deadline,omitempty"`
	// Minimum deadline in seconds needed for this method. Calls having deadline
	// value lower than this will be rejected.
	MinDeadline float64 `protobuf:"fixed64,4,opt,name=min_deadline,json=minDeadline,proto3" json:"min_deadline,omitempty"`
	// The number of seconds to wait for the completion of a long running
	// operation. The default is no deadline.
	OperationDeadline float64                     `protobuf:"fixed64,5,opt,name=operation_deadline,json=operationDeadline,proto3" json:"operation_deadline,omitempty"`
	PathTranslation   BackendRule_PathTranslation `protobuf:"varint,6,opt,name=path_translation,json=pathTranslation,proto3,enum=google.api.BackendRule_PathTranslation" json:"path_translation,omitempty"`
	// Authentication settings used by the backend.
	//
	// These are typically used to provide service management functionality to
	// a backend served on a publicly-routable URL. The `authentication`
	// details should match the authentication behavior used by the backend.
	//
	// For example, specifying `jwt_audience` implies that the backend expects
	// authentication via a JWT.
	//
	// Types that are valid to be assigned to Authentication:
	//	*BackendRule_JwtAudience
	Authentication       isBackendRule_Authentication `protobuf_oneof:"authentication"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *BackendRule) Reset()         { *m = BackendRule{} }
func (m *BackendRule) String() string { return proto.CompactTextString(m) }
func (*BackendRule) ProtoMessage()    {}
func (*BackendRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_backend_151dd2805952955b, []int{1}
}
func (m *BackendRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BackendRule.Unmarshal(m, b)
}
func (m *BackendRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BackendRule.Marshal(b, m, deterministic)
}
func (dst *BackendRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackendRule.Merge(dst, src)
}
func (m *BackendRule) XXX_Size() int {
	return xxx_messageInfo_BackendRule.Size(m)
}
func (m *BackendRule) XXX_DiscardUnknown() {
	xxx_messageInfo_BackendRule.DiscardUnknown(m)
}

var xxx_messageInfo_BackendRule proto.InternalMessageInfo

func (m *BackendRule) GetSelector() string {
	if m != nil {
		return m.Selector
	}
	return ""
}

func (m *BackendRule) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *BackendRule) GetDeadline() float64 {
	if m != nil {
		return m.Deadline
	}
	return 0
}

func (m *BackendRule) GetMinDeadline() float64 {
	if m != nil {
		return m.MinDeadline
	}
	return 0
}

func (m *BackendRule) GetOperationDeadline() float64 {
	if m != nil {
		return m.OperationDeadline
	}
	return 0
}

func (m *BackendRule) GetPathTranslation() BackendRule_PathTranslation {
	if m != nil {
		return m.PathTranslation
	}
	return BackendRule_PATH_TRANSLATION_UNSPECIFIED
}

type isBackendRule_Authentication interface {
	isBackendRule_Authentication()
}

type BackendRule_JwtAudience struct {
	JwtAudience string `protobuf:"bytes,7,opt,name=jwt_audience,json=jwtAudience,proto3,oneof"`
}

func (*BackendRule_JwtAudience) isBackendRule_Authentication() {}

func (m *BackendRule) GetAuthentication() isBackendRule_Authentication {
	if m != nil {
		return m.Authentication
	}
	return nil
}

func (m *BackendRule) GetJwtAudience() string {
	if x, ok := m.GetAuthentication().(*BackendRule_JwtAudience); ok {
		return x.JwtAudience
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*BackendRule) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _BackendRule_OneofMarshaler, _BackendRule_OneofUnmarshaler, _BackendRule_OneofSizer, []interface{}{
		(*BackendRule_JwtAudience)(nil),
	}
}

func _BackendRule_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*BackendRule)
	// authentication
	switch x := m.Authentication.(type) {
	case *BackendRule_JwtAudience:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.JwtAudience)
	case nil:
	default:
		return fmt.Errorf("BackendRule.Authentication has unexpected type %T", x)
	}
	return nil
}

func _BackendRule_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*BackendRule)
	switch tag {
	case 7: // authentication.jwt_audience
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Authentication = &BackendRule_JwtAudience{x}
		return true, err
	default:
		return false, nil
	}
}

func _BackendRule_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*BackendRule)
	// authentication
	switch x := m.Authentication.(type) {
	case *BackendRule_JwtAudience:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.JwtAudience)))
		n += len(x.JwtAudience)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*Backend)(nil), "google.api.Backend")
	proto.RegisterType((*BackendRule)(nil), "google.api.BackendRule")
	proto.RegisterEnum("google.api.BackendRule_PathTranslation", BackendRule_PathTranslation_name, BackendRule_PathTranslation_value)
}

func init() { proto.RegisterFile("google/api/backend.proto", fileDescriptor_backend_151dd2805952955b) }

var fileDescriptor_backend_151dd2805952955b = []byte{
	// 408 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x92, 0x41, 0x6f, 0xd3, 0x30,
	0x14, 0xc7, 0x97, 0x76, 0x5b, 0xe1, 0xb5, 0xea, 0x82, 0x85, 0x20, 0x9a, 0x38, 0x84, 0x72, 0xa0,
	0x97, 0xa5, 0xd2, 0xb8, 0x20, 0x71, 0x4a, 0x97, 0xc0, 0x2a, 0xa1, 0x34, 0x72, 0xc2, 0x85, 0x4b,
	0xe4, 0x25, 0x8f, 0xd4, 0x23, 0xb5, 0x23, 0xc7, 0x65, 0xdf, 0x07, 0xbe, 0x28, 0xaa, 0x93, 0x65,
	0x2d, 0x12, 0xc7, 0xff, 0xfb, 0xfd, 0x9e, 0xad, 0xbf, 0xf4, 0xc0, 0x29, 0xa5, 0x2c, 0x2b, 0x5c,
	0xb0, 0x9a, 0x2f, 0xee, 0x58, 0xfe, 0x13, 0x45, 0xe1, 0xd5, 0x4a, 0x6a, 0x49, 0xa0, 0x25, 0x1e,
	0xab, 0xf9, 0xec, 0x23, 0x8c, 0x96, 0x2d, 0x24, 0x57, 0x70, 0xa6, 0x76, 0x15, 0x36, 0x8e, 0xe5,
	0x0e, 0xe7, 0xe3, 0xeb, 0xd7, 0xde, 0x93, 0xe6, 0x75, 0x0e, 0xdd, 0x55, 0x48, 0x5b, 0x6b, 0xf6,
	0x67, 0x08, 0xe3, 0x83, 0x31, 0xb9, 0x84, 0x67, 0x0d, 0x56, 0x98, 0x6b, 0xa9, 0x1c, 0xcb, 0xb5,
	0xe6, 0xcf, 0x69, 0x9f, 0x89, 0x03, 0x23, 0x56, 0x14, 0x0a, 0x9b, 0xc6, 0x19, 0x18, 0xf4, 0x18,
	0xf7, 0x5b, 0x05, 0xb2, 0xa2, 0xe2, 0x02, 0x9d, 0xa1, 0x6b, 0xcd, 0x2d, 0xda, 0x67, 0xf2, 0x16,
	0x26, 0x5b, 0x2e, 0xb2, 0x9e, 0x9f, 0x1a, 0x3e, 0xde, 0x72, 0x11, 0x3c, 0x2a, 0x57, 0x40, 0x64,
	0x8d, 0x8a, 0x69, 0x2e, 0x0f, 0xc4, 0x33, 0x23, 0xbe, 0xe8, 0x49, 0xaf, 0x53, 0xb0, 0x6b, 0xa6,
	0x37, 0x99, 0x56, 0x4c, 0x34, 0x95, 0x61, 0xce, 0xb9, 0x6b, 0xcd, 0xa7, 0xd7, 0xef, 0xff, 0xd3,
	0xd6, 0x8b, 0x99, 0xde, 0xa4, 0x4f, 0x3a, 0xbd, 0xa8, 0x8f, 0x07, 0xe4, 0x1d, 0x4c, 0xee, 0x1f,
	0x74, 0xc6, 0x76, 0x05, 0x47, 0x91, 0xa3, 0x33, 0xda, 0x17, 0xbc, 0x3d, 0xa1, 0xe3, 0xfb, 0x07,
	0xed, 0x77, 0xc3, 0x19, 0xc2, 0xc5, 0x3f, 0x0f, 0x11, 0x17, 0xde, 0xc4, 0x7e, 0x7a, 0x9b, 0xa5,
	0xd4, 0x8f, 0x92, 0xaf, 0x7e, 0xba, 0x5a, 0x47, 0xd9, 0xb7, 0x28, 0x89, 0xc3, 0x9b, 0xd5, 0xe7,
	0x55, 0x18, 0xd8, 0x27, 0xe4, 0x25, 0xd8, 0x37, 0xeb, 0x28, 0x49, 0xfd, 0x28, 0xcd, 0xfc, 0x20,
	0xa0, 0x61, 0x92, 0xd8, 0x16, 0xb9, 0x84, 0x57, 0x7e, 0x1c, 0x87, 0x51, 0x90, 0xb5, 0xeb, 0xeb,
	0x9e, 0x0d, 0x96, 0x36, 0x4c, 0xd9, 0x4e, 0x6f, 0x50, 0x68, 0x9e, 0x9b, 0x5f, 0x96, 0x02, 0xa6,
	0xb9, 0xdc, 0x1e, 0x94, 0x5b, 0x4e, 0xba, 0x76, 0xf1, 0xfe, 0x16, 0x62, 0xeb, 0x7b, 0xd8, 0xb1,
	0x52, 0x56, 0x4c, 0x94, 0x9e, 0x54, 0xe5, 0xa2, 0x44, 0x61, 0x2e, 0x65, 0xd1, 0x22, 0x56, 0xf3,
	0xc6, 0x9c, 0x51, 0x83, 0xea, 0x17, 0xcf, 0x31, 0x97, 0xe2, 0x07, 0x2f, 0x3f, 0x1d, 0xa5, 0xdf,
	0x83, 0xd3, 0x2f, 0x7e, 0xbc, 0xba, 0x3b, 0x37, 0x8b, 0x1f, 0xfe, 0x06, 0x00, 0x00, 0xff, 0xff,
	0x2b, 0x64, 0x62, 0xc8, 0x7e, 0x02, 0x00, 0x00,
}
