// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ioteventsdataiface provides an interface to enable mocking the AWS IoT Events Data service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ioteventsdataiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/ioteventsdata"
)

// IoTEventsDataAPI provides an interface to enable mocking the
// ioteventsdata.IoTEventsData service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS IoT Events Data.
//    func myFunc(svc ioteventsdataiface.IoTEventsDataAPI) bool {
//        // Make svc.BatchPutMessage request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := ioteventsdata.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockIoTEventsDataClient struct {
//        ioteventsdataiface.IoTEventsDataAPI
//    }
//    func (m *mockIoTEventsDataClient) BatchPutMessage(input *ioteventsdata.BatchPutMessageInput) (*ioteventsdata.BatchPutMessageOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockIoTEventsDataClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type IoTEventsDataAPI interface {
	BatchPutMessage(*ioteventsdata.BatchPutMessageInput) (*ioteventsdata.BatchPutMessageOutput, error)
	BatchPutMessageWithContext(aws.Context, *ioteventsdata.BatchPutMessageInput, ...request.Option) (*ioteventsdata.BatchPutMessageOutput, error)
	BatchPutMessageRequest(*ioteventsdata.BatchPutMessageInput) (*request.Request, *ioteventsdata.BatchPutMessageOutput)

	BatchUpdateDetector(*ioteventsdata.BatchUpdateDetectorInput) (*ioteventsdata.BatchUpdateDetectorOutput, error)
	BatchUpdateDetectorWithContext(aws.Context, *ioteventsdata.BatchUpdateDetectorInput, ...request.Option) (*ioteventsdata.BatchUpdateDetectorOutput, error)
	BatchUpdateDetectorRequest(*ioteventsdata.BatchUpdateDetectorInput) (*request.Request, *ioteventsdata.BatchUpdateDetectorOutput)

	DescribeDetector(*ioteventsdata.DescribeDetectorInput) (*ioteventsdata.DescribeDetectorOutput, error)
	DescribeDetectorWithContext(aws.Context, *ioteventsdata.DescribeDetectorInput, ...request.Option) (*ioteventsdata.DescribeDetectorOutput, error)
	DescribeDetectorRequest(*ioteventsdata.DescribeDetectorInput) (*request.Request, *ioteventsdata.DescribeDetectorOutput)

	ListDetectors(*ioteventsdata.ListDetectorsInput) (*ioteventsdata.ListDetectorsOutput, error)
	ListDetectorsWithContext(aws.Context, *ioteventsdata.ListDetectorsInput, ...request.Option) (*ioteventsdata.ListDetectorsOutput, error)
	ListDetectorsRequest(*ioteventsdata.ListDetectorsInput) (*request.Request, *ioteventsdata.ListDetectorsOutput)
}

var _ IoTEventsDataAPI = (*ioteventsdata.IoTEventsData)(nil)
