---
layout: "api"
page_title: "SSH - Secrets Engines - HTTP API"
sidebar_current: "docs-http-secret-ssh"
description: |-
  This is the API documentation for the Vault SSH secrets engine.
---

# SSH Secrets Engine (API)

This is the API documentation for the Vault SSH secrets engine. For general
information about the usage and operation of the SSH secrets engine, please see
the [SSH documentation](/docs/secrets/ssh/index.html).

This documentation assumes the SSH secrets engine is enabled at the `/ssh` path
in Vault. Since it is possible to enable secrets engines at any location, please
update your API calls accordingly.

## Create/Update Key

This endpoint creates or updates a named key.

| Method   | Path                         | Produces               |
| :------- | :--------------------------- | :--------------------- |
| `POST`   | `/ssh/keys/:name`            | `204 (empty body)`     |

### Parameters

- `name` `(string: <required>)` – Specifies the name of the key to create. This
  is part of the request URL.

- `key` `(string: <required>)` – Specifies an SSH private key with appropriate
  privileges on remote hosts.

### Sample Payload

```json
{
  "key": "..."
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    --data @payload.json \
    https://vault.rocks/v1/ssh/keys/my-key
```

## Delete Key

This endpoint deletes a named key.

| Method   | Path                         | Produces               |
| :------- | :--------------------------- | :--------------------- |
| `DELETE` | `/ssh/keys/:name`            | `204 (empty body)`     |


### Parameters

- `name` `(string: <required>)` – Specifies the name of the key to delete. This
  is part of the request URL.

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request DELETE \
    https://vault.rocks/v1/ssh/keys/my-key
```

## Create Role

This endpoint creates or updates a named role.

| Method   | Path                         | Produces               |
| :------- | :--------------------------- | :--------------------- |
| `POST`   | `/ssh/roles/:name`           | `204 (empty body)`     |

### Parameters

- `name` `(string: <required>)` – Specifies the name of the role to create. This
  is part of the request URL.

- `key` `(string: "")` – Specifies the name of the registered key in Vault.
  Before creating the role, use the `keys/` endpoint to create a named key. This
  is required for "Dynamic Key" type.

- `admin_user` `(string: "")` – Specifies the admin user at remote host. The
  shared key being registered should be for this user and should have root or
  sudo privileges. Every time a dynamic	credential is generated for a client,
  Vault uses this admin username to login to remote host and install the
  generated credential. This is required for Dynamic Key type.

- `default_user` `(string: "")` – Specifies the default username for which a
  credential will be generated. When the endpoint `creds/` is used without a
  username, this value will be used as default username. Its recommended to
  create individual roles for each username to ensure absolute isolation between
  usernames. This is required for Dynamic Key type and OTP type.

    For the CA type, if you wish this to be a valid principal, it must also be
    in `allowed_users`.

- `cidr_list` `(string: "")` – Specifies a comma separated list of CIDR blocks
  for which the role is applicable for. It is possible that a same set of CIDR
  blocks are part of multiple roles. This is a required parameter, unless the
  role is registered under the `/config/zeroaddress` endpoint.

- `exclude_cidr_list` `(string: "")` – Specifies a comma-separated list of CIDR
  blocks. IP addresses belonging to these blocks are not accepted by the role.
  This is particularly useful when big CIDR blocks are being used by the role
  and certain parts need to be kept out.

- `port` `(int: 22)` – Specifies the port number for SSH connection. Port number
  does not play any role in OTP generation. For the `otp` secrets engine type, this is
  just a way to inform the client about the port number to use. The port number
  will be	returned to the client by Vault along with the OTP.

- `key_type` `(string: <required>)` – Specifies the type of credentials
  generated by this role. This can be either `otp`, `dynamic` or `ca`.

- `key_bits` `(int: 1024)` – Specifies the length of the RSA dynamic key in
  bits. This can be either 1024 or 2048.

- `install_script` `(string: "")` – Specifies the script used to install and
  uninstall public keys in the target machine. Defaults to the built-in script.

- `allowed_users` `(string: "")` – If this option is not specified, or if it is
  `*`, the client can request a credential for any valid user at the remote
  host, including the admin user. If only certain usernames are to be allowed,
  then this list enforces it. If this field is set, then credentials can only
  be created for `default_user` and usernames present in this list. Setting
  this option will enable all the users with access this role to fetch
  credentials for all other usernames in this list. Use with caution. N.B.: if
  the type is `ca`, an empty list does not allow any user; instead you must use
  `*` to enable this behavior.

- `allowed_domains` `(string: "")` – The list of domains for which a client can
  request a host certificate. If this option is explicitly set to `"*"`, then
  credentials can be created for any domain. See also `allow_bare_domains` and
  `allow_subdomains`.

- `key_option_specs` `(string: "")` – Specifies a comma separated option
  specification which will be prefixed to RSA keys in the remote host's
  authorized_keys file. N.B.: Vault does not check this string for validity.

- `ttl` `(string: "")` – Specifies the Time To Live value provided as a string
  duration with time suffix. Hour is the largest suffix.  If not set, uses the
  system default value or the value of `max_ttl`, whichever is shorter.

- `max_ttl` `(string: "")` – Specifies the maximum Time To Live provided as a
  string duration with time suffix. Hour is the largest suffix. If not set,
  defaults to the system maximum lease TTL.

- `allowed_critical_options` `(string: "")` – Specifies a comma-separated list
  of critical options that certificates can have when signed. To allow any
  critical options, set this to an empty string. Will default to allowing any
  critical options.

- `allowed_extensions` `(string: "")` – Specifies a comma-separated list of
  extensions that certificates can have when signed. To allow any critical
  options, set this to an empty string. Will default to allowing any extensions.

- `default_critical_options` `(map<string|string>: "")` – Specifies a map of
  critical options certificates should have if none are provided when signing.
  This field takes in key value pairs in JSON format. Note that these are not
  restricted by `allowed_critical_options`. Defaults to none.

- `default_extensions` `(map<string|string>: "")` – Specifies a map of
  extensions certificates should have if none are provided when signing. This
  field takes in key value pairs in JSON format. Note that these are not
  restricted by `allowed_extensions`. Defaults to none.

- `allow_user_certificates` `(bool: false)` – Specifies if certificates are
  allowed to be signed for use as a 'user'.

- `allow_host_certificates` `(bool: false)` – Specifies if certificates are
  allowed to be signed for use as a 'host'.

- `allow_bare_domains` `(bool: false)` – Specifies if host certificates that are
  requested are allowed to use the base domains listed in `allowed_domains`, e.g.
  "example.com". This is a separate option as in some cases this can be
  considered a security threat.

- `allow_subdomains` `(bool: false)` – Specifies if host certificates that are
  requested are allowed to be subdomains of those listed in `allowed_domains`,
  e.g. if "example.com" is part of `allowed_domains`, this allows
  "foo.example.com".

- `allow_user_key_ids` `(bool: false)` – Specifies if users can override the key
  ID for a signed certificate with the "key_id" field. When false, the key ID
  will always be the token display name. The key ID is logged by the SSH server
  and can be useful for auditing.

- `key_id_format` `(string: "")` – When supplied, this value specifies a custom
  format for the key id of a signed certificate. The following variables are
  available for use: '{{token_display_name}}' - The display name of the token used
  to make the request. '{{role_name}}' - The name of the role signing the request.
  '{{public_key_hash}}' - A SHA256 checksum of the public key that is being signed.
  e.g. "custom-keyid-{{token_display_name}}",

### Sample Payload

```json
{
  "key_type": "otp"
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    --data @payload.json \
    https://vault.rocks/v1/ssh/roles/my-role
```

## Read Role

This endpoint queries a named role.

| Method   | Path                         | Produces               |
| :------- | :--------------------------- | :--------------------- |
| `GET`    | `/ssh/roles/:name`           | `200 application/json` |

### Parameters

- `name` `(string: <required>)` – Specifies the name of the role to read. This
  is part of the request URL.

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    https://vault.rocks/v1/ssh/roles/my-role
```

### Sample Response

For a dynamic key role:

```json
{
  "admin_user": "username",
  "cidr_list": "x.x.x.x/y",
  "default_user": "username",
  "key": "<key name>",
  "key_type": "dynamic",
  "port": 22
}
```

For an OTP role:

```json
{
  "cidr_list": "x.x.x.x/y",
  "default_user": "username",
  "key_type": "otp",
  "port": 22
}
```

For a CA role:

```json
{
  "allow_bare_domains": false,
  "allow_host_certificates": true,
  "allow_subdomains": false,
  "allow_user_key_ids": false,
  "allow_user_certificates": true,
  "allowed_critical_options": "",
  "allowed_extensions": "",
  "default_critical_options": {},
  "default_extensions": {},
  "max_ttl": "768h",
  "ttl": "4h"
}
```

## List Roles

This endpoint returns a list of available roles. Only the role names are
returned, not any values.

| Method   | Path                         | Produces               |
| :------- | :--------------------------- | :--------------------- |
| `LIST`   | `/ssh/roles`                 | `200 application/json` |

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request LIST \
    https://vault.rocks/v1/ssh/roles
```

### Sample Response

```json
{
  "auth": null,
  "data": {
    "keys": ["dev", "prod"],
    "key_info": {
      "dev": {
        "key_type": "ca"
      },
      "prod": {
        "key_type": "dynamic"
      }
    }
  },
  "lease_duration": 2764800,
  "lease_id": "",
  "renewable": false
}
```

## Delete Role

This endpoint deletes a named role.

| Method   | Path                         | Produces               |
| :------- | :--------------------------- | :--------------------- |
| `DELETE` | `/ssh/roles/:name`           | `204 (empty body)`     |

### Parameters

- `name` `(string: <required>)` – Specifies the name of the role to delete. This
  is part of the request URL.

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request DELETE \
    --data @payload.json \
    https://vault.rocks/v1/ssh/roles/my-role
```

## List Zero-Address Roles

This endpoint returns the list of configured zero-address roles.

| Method   | Path                         | Produces               |
| :------- | :--------------------------- | :--------------------- |
| `GET`    | `/ssh/config/zeroaddress`    | `200 application/json` |

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    https://vault.rocks/v1/ssh/config/zeroaddress
```

### Sample Response

```json
{  
   "lease_id":"",
   "renewable":false,
   "lease_duration":0,
   "data":{  
      "roles":[  
         "otp_key_role"
      ]
   },
   "warnings":null,
   "auth":null
}
```

## Configure Zero-Address Roles

This endpoint configures zero-address roles.

| Method   | Path                         | Produces               |
| :------- | :--------------------------- | :--------------------- |
| `POST`   | `/ssh/config/zeroaddress`    | `204 (empty body)`     |

### Parameters

- `roles` `(string: <required>)` – Specifies a string containing comma separated
  list of role names which allows credentials to be requested for any IP
  address. CIDR blocks previously registered under these roles will be ignored.

### Sample Payload

```json
{
  "roles": ["otp_key_role"]
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    --data @payload.json \
    https://vault.rocks/v1/ssh/config/zeroaddress
```

## Delete Zero-Address Role

This endpoint deletes the zero-address roles configuration.

| Method   | Path                         | Produces               |
| :------- | :--------------------------- | :--------------------- |
| `DELETE` | `/ssh/config/zeroaddress`    | `204 (empty body)`     |

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request DELETE \
    https://vault.rocks/v1/ssh/config/zeroaddress
```

## Generate SSH Credentials

This endpoint creates credentials for a specific username and IP with the
parameters defined in the given role.

| Method   | Path                         | Produces               |
| :------- | :--------------------------- | :--------------------- |
| `POST`   | `/ssh/creds/:name`           | `200 application/json` |

### Parameters

- `name` `(string: <required>)` – Specifies the name of the role to create
  credentials against. This is part of the request URL.

- `username` `(string: "")` – Specifies the username on the remote host.

- `ip` `(string: <required>)` – Specifies the IP of the remote host.

### Sample Payload

```json
{
  "ip": "1.2.3.4"
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    --data @payload.json \
    https://vault.rocks/v1/ssh/creds/my-role
```

### Sample Response

For a dynamic key role:

```json
{
  "lease_id": "",
  "renewable": false,
  "lease_duration": 0,
  "data": {
    "admin_user": "rajanadar",
    "allowed_users": "",
    "cidr_list": "x.x.x.x/y",
    "default_user": "rajanadar",
    "exclude_cidr_list": "x.x.x.x/y",
    "install_script": "pretty_large_script",
    "key": "5d9ee6a1-c787-47a9-9738-da243f4f69bf",
    "key_bits": 1024,
    "key_option_specs": "",
    "key_type": "dynamic",
    "port": 22
   },
  "warnings": null,
  "auth": null
}
```

For an OTP role:

```json
{
  "lease_id": "sshs/creds/c3c2e60c-5a48-415a-9d5a-a41e0e6cdec5/3ee6ad28-383f-d482-2427-70498eba4d96",
  "renewable": false,
  "lease_duration": 2764800,
  "data": {
    "ip": "127.0.0.1",
    "key": "6d6411fd-f622-ea0a-7e2c-989a745cbbb2",
    "key_type": "otp",
    "port": 22,
    "username": "rajanadar"
   },
  "warnings": null,
  "auth": null
}
```

## List Roles by IP

This endpoint lists all of the roles with which the given IP is associated.

| Method   | Path                         | Produces               |
| :------- | :--------------------------- | :--------------------- |
| `POST`   | `/ssh/lookup`                | `200 application/json` |

### Parameters

- `ip` `(string: <required>)` – Specifies the IP of the remote host.

### Sample Payload

```json
{
  "ip": "1.2.3.4"
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    --data @payload.json \
    https://vault.rocks/v1/ssh/lookup
```

### Sample Response

An array of roles as a secret structure.

```json
{
  "lease_id": "",
  "renewable": false,
  "lease_duration": 0,
  "data": {
    "roles": [
      "fe6f61b7-7e4a-46a6-b2c8-0d530b8513df",
      "6d6411fd-f622-ea0a-7e2c-989a745cbbb2"
    ]
  },
  "warnings": null,
  "auth": null
}
```

## Verify SSH OTP

This endpoint verifies if the given OTP is valid. This is an unauthenticated
endpoint.

| Method   | Path                         | Produces               |
| :------- | :--------------------------- | :--------------------- |
| `POST`   | `/ssh/verify`                | `200 application/json` |

## Parameters

- `otp` `(string: <required>)` – Specifies the One-Time-Key that needs to be
  validated.

### Sample Payload

```json
{
  "otp": "bad2b3-..."
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    --data @payload.json \
    https://vault.rocks/v1/ssh/verify

### Sample Response

```json
{
  "lease_id":"",
  "renewable":false,
  "lease_duration":0,
  "data": {
    "ip":"127.0.0.1",
    "username":"rajanadar"
  },
  "warnings":null,
  "auth":null
}
```

## Submit CA Information

This endpoint allows submitting the CA information for the secrets engine via an SSH
key pair. _If you have already set a certificate and key, they will be
overridden._

| Method   | Path                         | Produces                   |
| :------- | :--------------------------- | :------------------------- |
| `POST`   | `/ssh/config/ca`             | `200/204 application/json` |

### Parameters

- `private_key` `(string: "")` – Specifies the private key part the SSH CA key
  pair; required if `generate_signing_key` is false.

- `public_key` `(string: "")` – Specifies the public key part of the SSH CA key
  pair; required if `generate_signing_key` is false.

- `generate_signing_key` `(bool: true)` – Specifies if Vault should generate
  the signing key pair internally. The generated public key will be returned so
  you can add it to your configuration.

### Sample Payload

```json
{
  "generate_signing_key": true
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    --data @payload.json \
    https://vault.rocks/v1/ssh/config/ca
```

### Sample Response

This will return a `204` response if `generate_signing_key` was unset or false.

This will return a `200` response if `generate_signing_key` was true:

```json
{
  "lease_id": "",
  "renewable": false,
  "lease_duration": 0,
  "data": {
    "public_key": "ssh-rsa AAAAHHNzaC1y...\n"
  },
  "warnings": null
}
```

## Delete CA Information

This endpoint deletes the CA information for the backend via an SSH key pair.

| Method   | Path                         | Produces               |
| :------- | :--------------------------- | :--------------------- |
| `DELETE` | `/ssh/config/ca`             | `204 (empty body)`     |

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request DELETE \
    https://vault.rocks/v1/ssh/config/ca
```

## Read Public Key (Unauthenticated)

This endpoint returns the configured/generated public key. This is an unauthenticated
endpoint.

| Method   | Path                         | Produces         |
| :------- | :--------------------------- | :--------------- |
| `GET`    | `/ssh/public_key`            | `200 text/plain` |

### Sample Request

```
$ curl https://vault.rocks/v1/ssh/public_key
```

### Sample Response

```text
    ssh-rsa AAAAHHNzaC1y...
```

## Read Public Key (Authenticated)

This endpoint reads the configured/generated public key.

| Method   | Path                         | Produces               |
| :------- | :--------------------------- | :--------------------- |
| `GET`    | `/ssh/config/ca`             | `200 application/json` |

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    https://vault.rocks/v1/ssh/config/ca
```

### Sample Response

```json
{
  "lease_id": "",
  "renewable": false,
  "lease_duration": 0,
  "data": {
    "public_key": "ssh-rsa AAAAHHNzaC1y...\n"
  },
  "warnings": null
}
```

## Sign SSH Key

This endpoint signs an SSH public key based on the supplied parameters, subject
to the restrictions contained in the role named in the endpoint.

| Method   | Path                         | Produces               |
| :------- | :--------------------------- | :--------------------- |
| `POST`   | `/ssh/sign/:name`            | `200 application/json` |

### Parameters

- `name` `(string: <required>)` – Specifies the name of the role to sign. This
  is part of the request URL.

- `public_key` `(string: <required>)` – Specifies the SSH public key that should
  be signed.

- `ttl` `(string: "")` – Specifies the Requested Time To Live. Cannot be greater
  than the role's `max_ttl` value. If not provided, the role's `ttl` value will
  be used. Note that the role values default to system values if not explicitly
  set.

- `valid_principals` `(string: "")` – Specifies valid principals, either
  usernames or hostnames, that the certificate should be signed for.

- `cert_type` `(string: "user")` – Specifies the type of certificate to be
  created; either "user" or "host".

- `key_id` `(string: "")` – Specifies the key id that the created certificate
  should have. If not specified, the display name of the token will be used.

- `critical_options` `(map<string|string>: "")` – Specifies a map of the
  critical options that the certificate should be signed for. Defaults to none.

- `extension` `(map<string|string>: "")` – Specifies a map of the extensions
  that the certificate should be signed for. Defaults to none.

### Sample Payload

```json
{
  "public_key": "ssh-rsa ..."
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    --data @payload.json \
    https://vault.rocks/v1/ssh/sign/my-key
```

### Sample Response

```json
{
  "lease_id": "ssh/sign/example/097bf207-96dd-0041-0e83-b23bd1923993",
  "renewable": false,
  "lease_duration": 21600,
  "data": {
    "serial_number": "f65ed2fd21443d5c",
    "signed_key": "ssh-rsa-cert-v01@openssh.com AAAAHHNzaC1y...\n"
  },
  "auth": null
}
```
