// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/remoteexecution/v1test/remote_execution.proto

package remoteexecution // import "google.golang.org/genproto/googleapis/devtools/remoteexecution/v1test"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import duration "github.com/golang/protobuf/ptypes/duration"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import status "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The current stage of execution.
type ExecuteOperationMetadata_Stage int32

const (
	ExecuteOperationMetadata_UNKNOWN ExecuteOperationMetadata_Stage = 0
	// Checking the result against the cache.
	ExecuteOperationMetadata_CACHE_CHECK ExecuteOperationMetadata_Stage = 1
	// Currently idle, awaiting a free machine to execute.
	ExecuteOperationMetadata_QUEUED ExecuteOperationMetadata_Stage = 2
	// Currently being executed by a worker.
	ExecuteOperationMetadata_EXECUTING ExecuteOperationMetadata_Stage = 3
	// Finished execution.
	ExecuteOperationMetadata_COMPLETED ExecuteOperationMetadata_Stage = 4
)

var ExecuteOperationMetadata_Stage_name = map[int32]string{
	0: "UNKNOWN",
	1: "CACHE_CHECK",
	2: "QUEUED",
	3: "EXECUTING",
	4: "COMPLETED",
}
var ExecuteOperationMetadata_Stage_value = map[string]int32{
	"UNKNOWN":     0,
	"CACHE_CHECK": 1,
	"QUEUED":      2,
	"EXECUTING":   3,
	"COMPLETED":   4,
}

func (x ExecuteOperationMetadata_Stage) String() string {
	return proto.EnumName(ExecuteOperationMetadata_Stage_name, int32(x))
}
func (ExecuteOperationMetadata_Stage) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{14, 0}
}

// An `Action` captures all the information about an execution which is required
// to reproduce it.
//
// `Action`s are the core component of the [Execution] service. A single
// `Action` represents a repeatable action that can be performed by the
// execution service. `Action`s can be succinctly identified by the digest of
// their wire format encoding and, once an `Action` has been executed, will be
// cached in the action cache. Future requests can then use the cached result
// rather than needing to run afresh.
//
// When a server completes execution of an
// [Action][google.devtools.remoteexecution.v1test.Action], it MAY choose to
// cache the [result][google.devtools.remoteexecution.v1test.ActionResult] in
// the [ActionCache][google.devtools.remoteexecution.v1test.ActionCache] unless
// `do_not_cache` is `true`. Clients SHOULD expect the server to do so. By
// default, future calls to [Execute][] the same `Action` will also serve their
// results from the cache. Clients must take care to understand the caching
// behaviour. Ideally, all `Action`s will be reproducible so that serving a
// result from cache is always desirable and correct.
type Action struct {
	// The digest of the [Command][google.devtools.remoteexecution.v1test.Command]
	// to run, which MUST be present in the
	// [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
	CommandDigest *Digest `protobuf:"bytes,1,opt,name=command_digest,json=commandDigest,proto3" json:"command_digest,omitempty"`
	// The digest of the root
	// [Directory][google.devtools.remoteexecution.v1test.Directory] for the input
	// files. The files in the directory tree are available in the correct
	// location on the build machine before the command is executed. The root
	// directory, as well as every subdirectory and content blob referred to, MUST
	// be in the
	// [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
	InputRootDigest *Digest `protobuf:"bytes,2,opt,name=input_root_digest,json=inputRootDigest,proto3" json:"input_root_digest,omitempty"`
	// A list of the output files that the client expects to retrieve from the
	// action. Only the listed files, as well as directories listed in
	// `output_directories`, will be returned to the client as output.
	// Other files that may be created during command execution are discarded.
	//
	// The paths are relative to the working directory of the action execution.
	// The paths are specified using a single forward slash (`/`) as a path
	// separator, even if the execution platform natively uses a different
	// separator. The path MUST NOT include a trailing slash, nor a leading slash,
	// being a relative path.
	//
	// In order to ensure consistent hashing of the same Action, the output paths
	// MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
	// bytes).
	OutputFiles []string `protobuf:"bytes,3,rep,name=output_files,json=outputFiles,proto3" json:"output_files,omitempty"`
	// A list of the output directories that the client expects to retrieve from
	// the action. Only the contents of the indicated directories (recursively
	// including the contents of their subdirectories) will be
	// returned, as well as files listed in `output_files`. Other files that may
	// be created during command execution are discarded.
	//
	// The paths are relative to the working directory of the action execution.
	// The paths are specified using a single forward slash (`/`) as a path
	// separator, even if the execution platform natively uses a different
	// separator. The path MUST NOT include a trailing slash, nor a leading slash,
	// being a relative path.
	// The special value of empty string is allowed, although not recommended, and
	// can be used to capture the entire working directory tree, including inputs.
	//
	// In order to ensure consistent hashing of the same Action, the output paths
	// MUST be sorted lexicographically by code point (or, equivalently, by UTF-8
	// bytes).
	OutputDirectories []string `protobuf:"bytes,4,rep,name=output_directories,json=outputDirectories,proto3" json:"output_directories,omitempty"`
	// The platform requirements for the execution environment. The server MAY
	// choose to execute the action on any worker satisfying the requirements, so
	// the client SHOULD ensure that running the action on any such worker will
	// have the same result.
	Platform *Platform `protobuf:"bytes,5,opt,name=platform,proto3" json:"platform,omitempty"`
	// A timeout after which the execution should be killed. If the timeout is
	// absent, then the client is specifying that the execution should continue
	// as long as the server will let it. The server SHOULD impose a timeout if
	// the client does not specify one, however, if the client does specify a
	// timeout that is longer than the server's maximum timeout, the server MUST
	// reject the request.
	//
	// The timeout is a part of the
	// [Action][google.devtools.remoteexecution.v1test.Action] message, and
	// therefore two `Actions` with different timeouts are different, even if they
	// are otherwise identical. This is because, if they were not, running an
	// `Action` with a lower timeout than is required might result in a cache hit
	// from an execution run with a longer timeout, hiding the fact that the
	// timeout is too short. By encoding it directly in the `Action`, a lower
	// timeout will result in a cache miss and the execution timeout will fail
	// immediately, rather than whenever the cache entry gets evicted.
	Timeout *duration.Duration `protobuf:"bytes,6,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// If true, then the `Action`'s result cannot be cached.
	DoNotCache           bool     `protobuf:"varint,7,opt,name=do_not_cache,json=doNotCache,proto3" json:"do_not_cache,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Action) Reset()         { *m = Action{} }
func (m *Action) String() string { return proto.CompactTextString(m) }
func (*Action) ProtoMessage()    {}
func (*Action) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{0}
}
func (m *Action) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Action.Unmarshal(m, b)
}
func (m *Action) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Action.Marshal(b, m, deterministic)
}
func (dst *Action) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Action.Merge(dst, src)
}
func (m *Action) XXX_Size() int {
	return xxx_messageInfo_Action.Size(m)
}
func (m *Action) XXX_DiscardUnknown() {
	xxx_messageInfo_Action.DiscardUnknown(m)
}

var xxx_messageInfo_Action proto.InternalMessageInfo

func (m *Action) GetCommandDigest() *Digest {
	if m != nil {
		return m.CommandDigest
	}
	return nil
}

func (m *Action) GetInputRootDigest() *Digest {
	if m != nil {
		return m.InputRootDigest
	}
	return nil
}

func (m *Action) GetOutputFiles() []string {
	if m != nil {
		return m.OutputFiles
	}
	return nil
}

func (m *Action) GetOutputDirectories() []string {
	if m != nil {
		return m.OutputDirectories
	}
	return nil
}

func (m *Action) GetPlatform() *Platform {
	if m != nil {
		return m.Platform
	}
	return nil
}

func (m *Action) GetTimeout() *duration.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *Action) GetDoNotCache() bool {
	if m != nil {
		return m.DoNotCache
	}
	return false
}

// A `Command` is the actual command executed by a worker running an
// [Action][google.devtools.remoteexecution.v1test.Action].
//
// Except as otherwise required, the environment (such as which system
// libraries or binaries are available, and what filesystems are mounted where)
// is defined by and specific to the implementation of the remote execution API.
type Command struct {
	// The arguments to the command. The first argument must be the path to the
	// executable, which must be either a relative path, in which case it is
	// evaluated with respect to the input root, or an absolute path.
	//
	// The working directory will always be the input root.
	Arguments []string `protobuf:"bytes,1,rep,name=arguments,proto3" json:"arguments,omitempty"`
	// The environment variables to set when running the program. The worker may
	// provide its own default environment variables; these defaults can be
	// overridden using this field. Additional variables can also be specified.
	//
	// In order to ensure that equivalent `Command`s always hash to the same
	// value, the environment variables MUST be lexicographically sorted by name.
	// Sorting of strings is done by code point, equivalently, by the UTF-8 bytes.
	EnvironmentVariables []*Command_EnvironmentVariable `protobuf:"bytes,2,rep,name=environment_variables,json=environmentVariables,proto3" json:"environment_variables,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *Command) Reset()         { *m = Command{} }
func (m *Command) String() string { return proto.CompactTextString(m) }
func (*Command) ProtoMessage()    {}
func (*Command) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{1}
}
func (m *Command) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Command.Unmarshal(m, b)
}
func (m *Command) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Command.Marshal(b, m, deterministic)
}
func (dst *Command) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Command.Merge(dst, src)
}
func (m *Command) XXX_Size() int {
	return xxx_messageInfo_Command.Size(m)
}
func (m *Command) XXX_DiscardUnknown() {
	xxx_messageInfo_Command.DiscardUnknown(m)
}

var xxx_messageInfo_Command proto.InternalMessageInfo

func (m *Command) GetArguments() []string {
	if m != nil {
		return m.Arguments
	}
	return nil
}

func (m *Command) GetEnvironmentVariables() []*Command_EnvironmentVariable {
	if m != nil {
		return m.EnvironmentVariables
	}
	return nil
}

// An `EnvironmentVariable` is one variable to set in the running program's
// environment.
type Command_EnvironmentVariable struct {
	// The variable name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The variable value.
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Command_EnvironmentVariable) Reset()         { *m = Command_EnvironmentVariable{} }
func (m *Command_EnvironmentVariable) String() string { return proto.CompactTextString(m) }
func (*Command_EnvironmentVariable) ProtoMessage()    {}
func (*Command_EnvironmentVariable) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{1, 0}
}
func (m *Command_EnvironmentVariable) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Command_EnvironmentVariable.Unmarshal(m, b)
}
func (m *Command_EnvironmentVariable) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Command_EnvironmentVariable.Marshal(b, m, deterministic)
}
func (dst *Command_EnvironmentVariable) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Command_EnvironmentVariable.Merge(dst, src)
}
func (m *Command_EnvironmentVariable) XXX_Size() int {
	return xxx_messageInfo_Command_EnvironmentVariable.Size(m)
}
func (m *Command_EnvironmentVariable) XXX_DiscardUnknown() {
	xxx_messageInfo_Command_EnvironmentVariable.DiscardUnknown(m)
}

var xxx_messageInfo_Command_EnvironmentVariable proto.InternalMessageInfo

func (m *Command_EnvironmentVariable) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Command_EnvironmentVariable) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// A `Platform` is a set of requirements, such as hardware, operating system, or
// compiler toolchain, for an
// [Action][google.devtools.remoteexecution.v1test.Action]'s execution
// environment. A `Platform` is represented as a series of key-value pairs
// representing the properties that are required of the platform.
//
// This message is currently being redeveloped since it is an overly simplistic
// model of platforms.
type Platform struct {
	// The properties that make up this platform. In order to ensure that
	// equivalent `Platform`s always hash to the same value, the properties MUST
	// be lexicographically sorted by name, and then by value. Sorting of strings
	// is done by code point, equivalently, by the UTF-8 bytes.
	Properties           []*Platform_Property `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Platform) Reset()         { *m = Platform{} }
func (m *Platform) String() string { return proto.CompactTextString(m) }
func (*Platform) ProtoMessage()    {}
func (*Platform) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{2}
}
func (m *Platform) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Platform.Unmarshal(m, b)
}
func (m *Platform) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Platform.Marshal(b, m, deterministic)
}
func (dst *Platform) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Platform.Merge(dst, src)
}
func (m *Platform) XXX_Size() int {
	return xxx_messageInfo_Platform.Size(m)
}
func (m *Platform) XXX_DiscardUnknown() {
	xxx_messageInfo_Platform.DiscardUnknown(m)
}

var xxx_messageInfo_Platform proto.InternalMessageInfo

func (m *Platform) GetProperties() []*Platform_Property {
	if m != nil {
		return m.Properties
	}
	return nil
}

// A single property for the environment. The server is responsible for
// specifying the property `name`s that it accepts. If an unknown `name` is
// provided in the requirements for an
// [Action][google.devtools.remoteexecution.v1test.Action], the server SHOULD
// reject the execution request. If permitted by the server, the same `name`
// may occur multiple times.
//
// The server is also responsible for specifying the interpretation of
// property `value`s. For instance, a property describing how much RAM must be
// available may be interpreted as allowing a worker with 16GB to fulfill a
// request for 8GB, while a property describing the OS environment on which
// the action must be performed may require an exact match with the worker's
// OS.
//
// The server MAY use the `value` of one or more properties to determine how
// it sets up the execution environment, such as by making specific system
// files available to the worker.
type Platform_Property struct {
	// The property name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The property value.
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Platform_Property) Reset()         { *m = Platform_Property{} }
func (m *Platform_Property) String() string { return proto.CompactTextString(m) }
func (*Platform_Property) ProtoMessage()    {}
func (*Platform_Property) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{2, 0}
}
func (m *Platform_Property) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Platform_Property.Unmarshal(m, b)
}
func (m *Platform_Property) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Platform_Property.Marshal(b, m, deterministic)
}
func (dst *Platform_Property) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Platform_Property.Merge(dst, src)
}
func (m *Platform_Property) XXX_Size() int {
	return xxx_messageInfo_Platform_Property.Size(m)
}
func (m *Platform_Property) XXX_DiscardUnknown() {
	xxx_messageInfo_Platform_Property.DiscardUnknown(m)
}

var xxx_messageInfo_Platform_Property proto.InternalMessageInfo

func (m *Platform_Property) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Platform_Property) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// A `Directory` represents a directory node in a file tree, containing zero or
// more children [FileNodes][google.devtools.remoteexecution.v1test.FileNode]
// and [DirectoryNodes][google.devtools.remoteexecution.v1test.DirectoryNode].
// Each `Node` contains its name in the directory, the digest of its content
// (either a file blob or a `Directory` proto), as well as possibly some
// metadata about the file or directory.
//
// In order to ensure that two equivalent directory trees hash to the same
// value, the following restrictions MUST be obeyed when constructing a
// a `Directory`:
//   - Every child in the directory must have a path of exactly one segment.
//     Multiple levels of directory hierarchy may not be collapsed.
//   - Each child in the directory must have a unique path segment (file name).
//   - The files and directories in the directory must each be sorted in
//     lexicographical order by path. The path strings must be sorted by code
//     point, equivalently, by UTF-8 bytes.
//
// A `Directory` that obeys the restrictions is said to be in canonical form.
//
// As an example, the following could be used for a file named `bar` and a
// directory named `foo` with an executable file named `baz` (hashes shortened
// for readability):
//
// ```json
// // (Directory proto)
// {
//   files: [
//     {
//       name: "bar",
//       digest: {
//         hash: "4a73bc9d03...",
//         size: 65534
//       }
//     }
//   ],
//   directories: [
//     {
//       name: "foo",
//       digest: {
//         hash: "4cf2eda940...",
//         size: 43
//       }
//     }
//   ]
// }
//
// // (Directory proto with hash "4cf2eda940..." and size 43)
// {
//   files: [
//     {
//       name: "baz",
//       digest: {
//         hash: "b2c941073e...",
//         size: 1294,
//       },
//       is_executable: true
//     }
//   ]
// }
// ```
type Directory struct {
	// The files in the directory.
	Files []*FileNode `protobuf:"bytes,1,rep,name=files,proto3" json:"files,omitempty"`
	// The subdirectories in the directory.
	Directories          []*DirectoryNode `protobuf:"bytes,2,rep,name=directories,proto3" json:"directories,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Directory) Reset()         { *m = Directory{} }
func (m *Directory) String() string { return proto.CompactTextString(m) }
func (*Directory) ProtoMessage()    {}
func (*Directory) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{3}
}
func (m *Directory) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Directory.Unmarshal(m, b)
}
func (m *Directory) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Directory.Marshal(b, m, deterministic)
}
func (dst *Directory) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Directory.Merge(dst, src)
}
func (m *Directory) XXX_Size() int {
	return xxx_messageInfo_Directory.Size(m)
}
func (m *Directory) XXX_DiscardUnknown() {
	xxx_messageInfo_Directory.DiscardUnknown(m)
}

var xxx_messageInfo_Directory proto.InternalMessageInfo

func (m *Directory) GetFiles() []*FileNode {
	if m != nil {
		return m.Files
	}
	return nil
}

func (m *Directory) GetDirectories() []*DirectoryNode {
	if m != nil {
		return m.Directories
	}
	return nil
}

// A `FileNode` represents a single file and associated metadata.
type FileNode struct {
	// The name of the file.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The digest of the file's content.
	Digest *Digest `protobuf:"bytes,2,opt,name=digest,proto3" json:"digest,omitempty"`
	// True if file is executable, false otherwise.
	IsExecutable         bool     `protobuf:"varint,4,opt,name=is_executable,json=isExecutable,proto3" json:"is_executable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FileNode) Reset()         { *m = FileNode{} }
func (m *FileNode) String() string { return proto.CompactTextString(m) }
func (*FileNode) ProtoMessage()    {}
func (*FileNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{4}
}
func (m *FileNode) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FileNode.Unmarshal(m, b)
}
func (m *FileNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FileNode.Marshal(b, m, deterministic)
}
func (dst *FileNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileNode.Merge(dst, src)
}
func (m *FileNode) XXX_Size() int {
	return xxx_messageInfo_FileNode.Size(m)
}
func (m *FileNode) XXX_DiscardUnknown() {
	xxx_messageInfo_FileNode.DiscardUnknown(m)
}

var xxx_messageInfo_FileNode proto.InternalMessageInfo

func (m *FileNode) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *FileNode) GetDigest() *Digest {
	if m != nil {
		return m.Digest
	}
	return nil
}

func (m *FileNode) GetIsExecutable() bool {
	if m != nil {
		return m.IsExecutable
	}
	return false
}

// A `DirectoryNode` represents a child of a
// [Directory][google.devtools.remoteexecution.v1test.Directory] which is itself
// a `Directory` and its associated metadata.
type DirectoryNode struct {
	// The name of the directory.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The digest of the
	// [Directory][google.devtools.remoteexecution.v1test.Directory] object
	// represented. See [Digest][google.devtools.remoteexecution.v1test.Digest]
	// for information about how to take the digest of a proto message.
	Digest               *Digest  `protobuf:"bytes,2,opt,name=digest,proto3" json:"digest,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DirectoryNode) Reset()         { *m = DirectoryNode{} }
func (m *DirectoryNode) String() string { return proto.CompactTextString(m) }
func (*DirectoryNode) ProtoMessage()    {}
func (*DirectoryNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{5}
}
func (m *DirectoryNode) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DirectoryNode.Unmarshal(m, b)
}
func (m *DirectoryNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DirectoryNode.Marshal(b, m, deterministic)
}
func (dst *DirectoryNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DirectoryNode.Merge(dst, src)
}
func (m *DirectoryNode) XXX_Size() int {
	return xxx_messageInfo_DirectoryNode.Size(m)
}
func (m *DirectoryNode) XXX_DiscardUnknown() {
	xxx_messageInfo_DirectoryNode.DiscardUnknown(m)
}

var xxx_messageInfo_DirectoryNode proto.InternalMessageInfo

func (m *DirectoryNode) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DirectoryNode) GetDigest() *Digest {
	if m != nil {
		return m.Digest
	}
	return nil
}

// A content digest. A digest for a given blob consists of the size of the blob
// and its hash. The hash algorithm to use is defined by the server, but servers
// SHOULD use SHA-256.
//
// The size is considered to be an integral part of the digest and cannot be
// separated. That is, even if the `hash` field is correctly specified but
// `size_bytes` is not, the server MUST reject the request.
//
// The reason for including the size in the digest is as follows: in a great
// many cases, the server needs to know the size of the blob it is about to work
// with prior to starting an operation with it, such as flattening Merkle tree
// structures or streaming it to a worker. Technically, the server could
// implement a separate metadata store, but this results in a significantly more
// complicated implementation as opposed to having the client specify the size
// up-front (or storing the size along with the digest in every message where
// digests are embedded). This does mean that the API leaks some implementation
// details of (what we consider to be) a reasonable server implementation, but
// we consider this to be a worthwhile tradeoff.
//
// When a `Digest` is used to refer to a proto message, it always refers to the
// message in binary encoded form. To ensure consistent hashing, clients and
// servers MUST ensure that they serialize messages according to the following
// rules, even if there are alternate valid encodings for the same message.
// - Fields are serialized in tag order.
// - There are no unknown fields.
// - There are no duplicate fields.
// - Fields are serialized according to the default semantics for their type.
//
// Most protocol buffer implementations will always follow these rules when
// serializing, but care should be taken to avoid shortcuts. For instance,
// concatenating two messages to merge them may produce duplicate fields.
type Digest struct {
	// The hash. In the case of SHA-256, it will always be a lowercase hex string
	// exactly 64 characters long.
	Hash string `protobuf:"bytes,1,opt,name=hash,proto3" json:"hash,omitempty"`
	// The size of the blob, in bytes.
	SizeBytes            int64    `protobuf:"varint,2,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Digest) Reset()         { *m = Digest{} }
func (m *Digest) String() string { return proto.CompactTextString(m) }
func (*Digest) ProtoMessage()    {}
func (*Digest) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{6}
}
func (m *Digest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Digest.Unmarshal(m, b)
}
func (m *Digest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Digest.Marshal(b, m, deterministic)
}
func (dst *Digest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Digest.Merge(dst, src)
}
func (m *Digest) XXX_Size() int {
	return xxx_messageInfo_Digest.Size(m)
}
func (m *Digest) XXX_DiscardUnknown() {
	xxx_messageInfo_Digest.DiscardUnknown(m)
}

var xxx_messageInfo_Digest proto.InternalMessageInfo

func (m *Digest) GetHash() string {
	if m != nil {
		return m.Hash
	}
	return ""
}

func (m *Digest) GetSizeBytes() int64 {
	if m != nil {
		return m.SizeBytes
	}
	return 0
}

// An ActionResult represents the result of an
// [Action][google.devtools.remoteexecution.v1test.Action] being run.
type ActionResult struct {
	// The output files of the action. For each output file requested in the
	// `output_files` field of the Action, if the corresponding file existed after
	// the action completed, a single entry will be present in the output list.
	//
	// If the action does not produce the requested output, or produces a
	// directory where a regular file is expected or vice versa, then that output
	// will be omitted from the list. The server is free to arrange the output
	// list as desired; clients MUST NOT assume that the output list is sorted.
	OutputFiles []*OutputFile `protobuf:"bytes,2,rep,name=output_files,json=outputFiles,proto3" json:"output_files,omitempty"`
	// The output directories of the action. For each output directory requested
	// in the `output_directories` field of the Action, if the corresponding
	// directory existed after the action completed, a single entry will be
	// present in the output list, which will contain the digest of
	// a [Tree][google.devtools.remoteexecution.v1test.Tree] message containing
	// the directory tree, and the path equal exactly to the corresponding Action
	// output_directories member.
	// As an example, suppose the Action had an output directory `a/b/dir` and the
	// execution produced the following contents in `a/b/dir`: a file named `bar`
	// and a directory named `foo` with an executable file named `baz`. Then,
	// output_directory will contain (hashes shortened for readability):
	//
	// ```json
	// // OutputDirectory proto:
	// {
	//   path: "a/b/dir"
	//   tree_digest: {
	//     hash: "4a73bc9d03...",
	//     size: 55
	//   }
	// }
	// // Tree proto with hash "4a73bc9d03..." and size 55:
	// {
	//   root: {
	//     files: [
	//       {
	//         name: "bar",
	//         digest: {
	//           hash: "4a73bc9d03...",
	//           size: 65534
	//         }
	//       }
	//     ],
	//     directories: [
	//       {
	//         name: "foo",
	//         digest: {
	//           hash: "4cf2eda940...",
	//           size: 43
	//         }
	//       }
	//     ]
	//   }
	//   children : {
	//     // (Directory proto with hash "4cf2eda940..." and size 43)
	//     files: [
	//       {
	//         name: "baz",
	//         digest: {
	//           hash: "b2c941073e...",
	//           size: 1294,
	//         },
	//         is_executable: true
	//       }
	//     ]
	//   }
	// }
	// ```
	OutputDirectories []*OutputDirectory `protobuf:"bytes,3,rep,name=output_directories,json=outputDirectories,proto3" json:"output_directories,omitempty"`
	// The exit code of the command.
	ExitCode int32 `protobuf:"varint,4,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	// The standard output buffer of the action. The server will determine, based
	// on the size of the buffer, whether to return it in raw form or to return
	// a digest in `stdout_digest` that points to the buffer. If neither is set,
	// then the buffer is empty. The client SHOULD NOT assume it will get one of
	// the raw buffer or a digest on any given request and should be prepared to
	// handle either.
	StdoutRaw []byte `protobuf:"bytes,5,opt,name=stdout_raw,json=stdoutRaw,proto3" json:"stdout_raw,omitempty"`
	// The digest for a blob containing the standard output of the action, which
	// can be retrieved from the
	// [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
	// See `stdout_raw` for when this will be set.
	StdoutDigest *Digest `protobuf:"bytes,6,opt,name=stdout_digest,json=stdoutDigest,proto3" json:"stdout_digest,omitempty"`
	// The standard error buffer of the action. The server will determine, based
	// on the size of the buffer, whether to return it in raw form or to return
	// a digest in `stderr_digest` that points to the buffer. If neither is set,
	// then the buffer is empty. The client SHOULD NOT assume it will get one of
	// the raw buffer or a digest on any given request and should be prepared to
	// handle either.
	StderrRaw []byte `protobuf:"bytes,7,opt,name=stderr_raw,json=stderrRaw,proto3" json:"stderr_raw,omitempty"`
	// The digest for a blob containing the standard error of the action, which
	// can be retrieved from the
	// [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
	// See `stderr_raw` for when this will be set.
	StderrDigest         *Digest  `protobuf:"bytes,8,opt,name=stderr_digest,json=stderrDigest,proto3" json:"stderr_digest,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ActionResult) Reset()         { *m = ActionResult{} }
func (m *ActionResult) String() string { return proto.CompactTextString(m) }
func (*ActionResult) ProtoMessage()    {}
func (*ActionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{7}
}
func (m *ActionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ActionResult.Unmarshal(m, b)
}
func (m *ActionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ActionResult.Marshal(b, m, deterministic)
}
func (dst *ActionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActionResult.Merge(dst, src)
}
func (m *ActionResult) XXX_Size() int {
	return xxx_messageInfo_ActionResult.Size(m)
}
func (m *ActionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_ActionResult.DiscardUnknown(m)
}

var xxx_messageInfo_ActionResult proto.InternalMessageInfo

func (m *ActionResult) GetOutputFiles() []*OutputFile {
	if m != nil {
		return m.OutputFiles
	}
	return nil
}

func (m *ActionResult) GetOutputDirectories() []*OutputDirectory {
	if m != nil {
		return m.OutputDirectories
	}
	return nil
}

func (m *ActionResult) GetExitCode() int32 {
	if m != nil {
		return m.ExitCode
	}
	return 0
}

func (m *ActionResult) GetStdoutRaw() []byte {
	if m != nil {
		return m.StdoutRaw
	}
	return nil
}

func (m *ActionResult) GetStdoutDigest() *Digest {
	if m != nil {
		return m.StdoutDigest
	}
	return nil
}

func (m *ActionResult) GetStderrRaw() []byte {
	if m != nil {
		return m.StderrRaw
	}
	return nil
}

func (m *ActionResult) GetStderrDigest() *Digest {
	if m != nil {
		return m.StderrDigest
	}
	return nil
}

// An `OutputFile` is similar to a
// [FileNode][google.devtools.remoteexecution.v1test.FileNode], but it is
// tailored for output as part of an `ActionResult`. It allows a full file path
// rather than only a name, and allows the server to include content inline.
//
// `OutputFile` is binary-compatible with `FileNode`.
type OutputFile struct {
	// The full path of the file relative to the input root, including the
	// filename. The path separator is a forward slash `/`. Since this is a
	// relative path, it MUST NOT begin with a leading forward slash.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// The digest of the file's content.
	Digest *Digest `protobuf:"bytes,2,opt,name=digest,proto3" json:"digest,omitempty"`
	// The raw content of the file.
	//
	// This field may be used by the server to provide the content of a file
	// inline in an
	// [ActionResult][google.devtools.remoteexecution.v1test.ActionResult] and
	// avoid requiring that the client make a separate call to
	// [ContentAddressableStorage.GetBlob] to retrieve it.
	//
	// The client SHOULD NOT assume that it will get raw content with any request,
	// and always be prepared to retrieve it via `digest`.
	Content []byte `protobuf:"bytes,3,opt,name=content,proto3" json:"content,omitempty"`
	// True if file is executable, false otherwise.
	IsExecutable         bool     `protobuf:"varint,4,opt,name=is_executable,json=isExecutable,proto3" json:"is_executable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OutputFile) Reset()         { *m = OutputFile{} }
func (m *OutputFile) String() string { return proto.CompactTextString(m) }
func (*OutputFile) ProtoMessage()    {}
func (*OutputFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{8}
}
func (m *OutputFile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputFile.Unmarshal(m, b)
}
func (m *OutputFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputFile.Marshal(b, m, deterministic)
}
func (dst *OutputFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputFile.Merge(dst, src)
}
func (m *OutputFile) XXX_Size() int {
	return xxx_messageInfo_OutputFile.Size(m)
}
func (m *OutputFile) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputFile.DiscardUnknown(m)
}

var xxx_messageInfo_OutputFile proto.InternalMessageInfo

func (m *OutputFile) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *OutputFile) GetDigest() *Digest {
	if m != nil {
		return m.Digest
	}
	return nil
}

func (m *OutputFile) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *OutputFile) GetIsExecutable() bool {
	if m != nil {
		return m.IsExecutable
	}
	return false
}

// A `Tree` contains all the
// [Directory][google.devtools.remoteexecution.v1test.Directory] protos in a
// single directory Merkle tree, compressed into one message.
type Tree struct {
	// The root directory in the tree.
	Root *Directory `protobuf:"bytes,1,opt,name=root,proto3" json:"root,omitempty"`
	// All the child directories: the directories referred to by the root and,
	// recursively, all its children. In order to reconstruct the directory tree,
	// the client must take the digests of each of the child directories and then
	// build up a tree starting from the `root`.
	Children             []*Directory `protobuf:"bytes,2,rep,name=children,proto3" json:"children,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Tree) Reset()         { *m = Tree{} }
func (m *Tree) String() string { return proto.CompactTextString(m) }
func (*Tree) ProtoMessage()    {}
func (*Tree) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{9}
}
func (m *Tree) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Tree.Unmarshal(m, b)
}
func (m *Tree) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Tree.Marshal(b, m, deterministic)
}
func (dst *Tree) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tree.Merge(dst, src)
}
func (m *Tree) XXX_Size() int {
	return xxx_messageInfo_Tree.Size(m)
}
func (m *Tree) XXX_DiscardUnknown() {
	xxx_messageInfo_Tree.DiscardUnknown(m)
}

var xxx_messageInfo_Tree proto.InternalMessageInfo

func (m *Tree) GetRoot() *Directory {
	if m != nil {
		return m.Root
	}
	return nil
}

func (m *Tree) GetChildren() []*Directory {
	if m != nil {
		return m.Children
	}
	return nil
}

// An `OutputDirectory` is the output in an `ActionResult` corresponding to a
// directory's full contents rather than a single file.
type OutputDirectory struct {
	// The full path of the directory relative to the working directory. The path
	// separator is a forward slash `/`. Since this is a relative path, it MUST
	// NOT begin with a leading forward slash. The empty string value is allowed,
	// and it denotes the entire working directory.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// DEPRECATED: This field is deprecated and should no longer be used.
	Digest *Digest `protobuf:"bytes,2,opt,name=digest,proto3" json:"digest,omitempty"`
	// The digest of the encoded
	// [Tree][google.devtools.remoteexecution.v1test.Tree] proto containing the
	// directory's contents.
	TreeDigest           *Digest  `protobuf:"bytes,3,opt,name=tree_digest,json=treeDigest,proto3" json:"tree_digest,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OutputDirectory) Reset()         { *m = OutputDirectory{} }
func (m *OutputDirectory) String() string { return proto.CompactTextString(m) }
func (*OutputDirectory) ProtoMessage()    {}
func (*OutputDirectory) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{10}
}
func (m *OutputDirectory) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputDirectory.Unmarshal(m, b)
}
func (m *OutputDirectory) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputDirectory.Marshal(b, m, deterministic)
}
func (dst *OutputDirectory) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputDirectory.Merge(dst, src)
}
func (m *OutputDirectory) XXX_Size() int {
	return xxx_messageInfo_OutputDirectory.Size(m)
}
func (m *OutputDirectory) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputDirectory.DiscardUnknown(m)
}

var xxx_messageInfo_OutputDirectory proto.InternalMessageInfo

func (m *OutputDirectory) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *OutputDirectory) GetDigest() *Digest {
	if m != nil {
		return m.Digest
	}
	return nil
}

func (m *OutputDirectory) GetTreeDigest() *Digest {
	if m != nil {
		return m.TreeDigest
	}
	return nil
}

// A request message for
// [Execution.Execute][google.devtools.remoteexecution.v1test.Execution.Execute].
type ExecuteRequest struct {
	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The action to be performed.
	Action *Action `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
	// If true, the action will be executed anew even if its result was already
	// present in the cache. If false, the result may be served from the
	// [ActionCache][google.devtools.remoteexecution.v1test.ActionCache].
	SkipCacheLookup bool `protobuf:"varint,3,opt,name=skip_cache_lookup,json=skipCacheLookup,proto3" json:"skip_cache_lookup,omitempty"`
	// DEPRECATED: This field should be ignored by clients and servers and will be
	// removed.
	TotalInputFileCount int32 `protobuf:"varint,4,opt,name=total_input_file_count,json=totalInputFileCount,proto3" json:"total_input_file_count,omitempty"`
	// DEPRECATED: This field should be ignored by clients and servers and will be
	// removed.
	TotalInputFileBytes  int64    `protobuf:"varint,5,opt,name=total_input_file_bytes,json=totalInputFileBytes,proto3" json:"total_input_file_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecuteRequest) Reset()         { *m = ExecuteRequest{} }
func (m *ExecuteRequest) String() string { return proto.CompactTextString(m) }
func (*ExecuteRequest) ProtoMessage()    {}
func (*ExecuteRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{11}
}
func (m *ExecuteRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteRequest.Unmarshal(m, b)
}
func (m *ExecuteRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteRequest.Marshal(b, m, deterministic)
}
func (dst *ExecuteRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteRequest.Merge(dst, src)
}
func (m *ExecuteRequest) XXX_Size() int {
	return xxx_messageInfo_ExecuteRequest.Size(m)
}
func (m *ExecuteRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteRequest proto.InternalMessageInfo

func (m *ExecuteRequest) GetInstanceName() string {
	if m != nil {
		return m.InstanceName
	}
	return ""
}

func (m *ExecuteRequest) GetAction() *Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *ExecuteRequest) GetSkipCacheLookup() bool {
	if m != nil {
		return m.SkipCacheLookup
	}
	return false
}

func (m *ExecuteRequest) GetTotalInputFileCount() int32 {
	if m != nil {
		return m.TotalInputFileCount
	}
	return 0
}

func (m *ExecuteRequest) GetTotalInputFileBytes() int64 {
	if m != nil {
		return m.TotalInputFileBytes
	}
	return 0
}

// A `LogFile` is a log stored in the CAS.
type LogFile struct {
	// The digest of the log contents.
	Digest *Digest `protobuf:"bytes,1,opt,name=digest,proto3" json:"digest,omitempty"`
	// This is a hint as to the purpose of the log, and is set to true if the log
	// is human-readable text that can be usefully displayed to a user, and false
	// otherwise. For instance, if a command-line client wishes to print the
	// server logs to the terminal for a failed action, this allows it to avoid
	// displaying a binary file.
	HumanReadable        bool     `protobuf:"varint,2,opt,name=human_readable,json=humanReadable,proto3" json:"human_readable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogFile) Reset()         { *m = LogFile{} }
func (m *LogFile) String() string { return proto.CompactTextString(m) }
func (*LogFile) ProtoMessage()    {}
func (*LogFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{12}
}
func (m *LogFile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogFile.Unmarshal(m, b)
}
func (m *LogFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogFile.Marshal(b, m, deterministic)
}
func (dst *LogFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogFile.Merge(dst, src)
}
func (m *LogFile) XXX_Size() int {
	return xxx_messageInfo_LogFile.Size(m)
}
func (m *LogFile) XXX_DiscardUnknown() {
	xxx_messageInfo_LogFile.DiscardUnknown(m)
}

var xxx_messageInfo_LogFile proto.InternalMessageInfo

func (m *LogFile) GetDigest() *Digest {
	if m != nil {
		return m.Digest
	}
	return nil
}

func (m *LogFile) GetHumanReadable() bool {
	if m != nil {
		return m.HumanReadable
	}
	return false
}

// The response message for
// [Execution.Execute][google.devtools.remoteexecution.v1test.Execution.Execute],
// which will be contained in the [response
// field][google.longrunning.Operation.response] of the
// [Operation][google.longrunning.Operation].
type ExecuteResponse struct {
	// The result of the action.
	Result *ActionResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	// True if the result was served from cache, false if it was executed.
	CachedResult bool `protobuf:"varint,2,opt,name=cached_result,json=cachedResult,proto3" json:"cached_result,omitempty"`
	// If the status has a code other than `OK`, it indicates that the action did
	// not finish execution. For example, if the operation times out during
	// execution, the status will have a `DEADLINE_EXCEEDED` code. Servers MUST
	// use this field for errors in execution, rather than the error field on the
	// `Operation` object.
	//
	// If the status code is other than `OK`, then the result MUST NOT be cached.
	// For an error status, the `result` field is optional; the server may
	// populate the output-, stdout-, and stderr-related fields if it has any
	// information available, such as the stdout and stderr of a timed-out action.
	Status *status.Status `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
	// An optional list of additional log outputs the server wishes to provide. A
	// server can use this to return execution-specific logs however it wishes.
	// This is intended primarily to make it easier for users to debug issues that
	// may be outside of the actual job execution, such as by identifying the
	// worker executing the action or by providing logs from the worker's setup
	// phase. The keys SHOULD be human readable so that a client can display them
	// to a user.
	ServerLogs           map[string]*LogFile `protobuf:"bytes,4,rep,name=server_logs,json=serverLogs,proto3" json:"server_logs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ExecuteResponse) Reset()         { *m = ExecuteResponse{} }
func (m *ExecuteResponse) String() string { return proto.CompactTextString(m) }
func (*ExecuteResponse) ProtoMessage()    {}
func (*ExecuteResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{13}
}
func (m *ExecuteResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteResponse.Unmarshal(m, b)
}
func (m *ExecuteResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteResponse.Marshal(b, m, deterministic)
}
func (dst *ExecuteResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteResponse.Merge(dst, src)
}
func (m *ExecuteResponse) XXX_Size() int {
	return xxx_messageInfo_ExecuteResponse.Size(m)
}
func (m *ExecuteResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteResponse proto.InternalMessageInfo

func (m *ExecuteResponse) GetResult() *ActionResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *ExecuteResponse) GetCachedResult() bool {
	if m != nil {
		return m.CachedResult
	}
	return false
}

func (m *ExecuteResponse) GetStatus() *status.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *ExecuteResponse) GetServerLogs() map[string]*LogFile {
	if m != nil {
		return m.ServerLogs
	}
	return nil
}

// Metadata about an ongoing
// [execution][google.devtools.remoteexecution.v1test.Execution.Execute], which
// will be contained in the [metadata
// field][google.longrunning.Operation.response] of the
// [Operation][google.longrunning.Operation].
type ExecuteOperationMetadata struct {
	Stage ExecuteOperationMetadata_Stage `protobuf:"varint,1,opt,name=stage,proto3,enum=google.devtools.remoteexecution.v1test.ExecuteOperationMetadata_Stage" json:"stage,omitempty"`
	// The digest of the [Action][google.devtools.remoteexecution.v1test.Action]
	// being executed.
	ActionDigest *Digest `protobuf:"bytes,2,opt,name=action_digest,json=actionDigest,proto3" json:"action_digest,omitempty"`
	// If set, the client can use this name with
	// [ByteStream.Read][google.bytestream.ByteStream.Read] to stream the
	// standard output.
	StdoutStreamName string `protobuf:"bytes,3,opt,name=stdout_stream_name,json=stdoutStreamName,proto3" json:"stdout_stream_name,omitempty"`
	// If set, the client can use this name with
	// [ByteStream.Read][google.bytestream.ByteStream.Read] to stream the
	// standard error.
	StderrStreamName     string   `protobuf:"bytes,4,opt,name=stderr_stream_name,json=stderrStreamName,proto3" json:"stderr_stream_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecuteOperationMetadata) Reset()         { *m = ExecuteOperationMetadata{} }
func (m *ExecuteOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*ExecuteOperationMetadata) ProtoMessage()    {}
func (*ExecuteOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{14}
}
func (m *ExecuteOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecuteOperationMetadata.Unmarshal(m, b)
}
func (m *ExecuteOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecuteOperationMetadata.Marshal(b, m, deterministic)
}
func (dst *ExecuteOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecuteOperationMetadata.Merge(dst, src)
}
func (m *ExecuteOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_ExecuteOperationMetadata.Size(m)
}
func (m *ExecuteOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecuteOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ExecuteOperationMetadata proto.InternalMessageInfo

func (m *ExecuteOperationMetadata) GetStage() ExecuteOperationMetadata_Stage {
	if m != nil {
		return m.Stage
	}
	return ExecuteOperationMetadata_UNKNOWN
}

func (m *ExecuteOperationMetadata) GetActionDigest() *Digest {
	if m != nil {
		return m.ActionDigest
	}
	return nil
}

func (m *ExecuteOperationMetadata) GetStdoutStreamName() string {
	if m != nil {
		return m.StdoutStreamName
	}
	return ""
}

func (m *ExecuteOperationMetadata) GetStderrStreamName() string {
	if m != nil {
		return m.StderrStreamName
	}
	return ""
}

// A request message for
// [ActionCache.GetActionResult][google.devtools.remoteexecution.v1test.ActionCache.GetActionResult].
type GetActionResultRequest struct {
	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The digest of the [Action][google.devtools.remoteexecution.v1test.Action]
	// whose result is requested.
	ActionDigest         *Digest  `protobuf:"bytes,2,opt,name=action_digest,json=actionDigest,proto3" json:"action_digest,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetActionResultRequest) Reset()         { *m = GetActionResultRequest{} }
func (m *GetActionResultRequest) String() string { return proto.CompactTextString(m) }
func (*GetActionResultRequest) ProtoMessage()    {}
func (*GetActionResultRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{15}
}
func (m *GetActionResultRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetActionResultRequest.Unmarshal(m, b)
}
func (m *GetActionResultRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetActionResultRequest.Marshal(b, m, deterministic)
}
func (dst *GetActionResultRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetActionResultRequest.Merge(dst, src)
}
func (m *GetActionResultRequest) XXX_Size() int {
	return xxx_messageInfo_GetActionResultRequest.Size(m)
}
func (m *GetActionResultRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetActionResultRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetActionResultRequest proto.InternalMessageInfo

func (m *GetActionResultRequest) GetInstanceName() string {
	if m != nil {
		return m.InstanceName
	}
	return ""
}

func (m *GetActionResultRequest) GetActionDigest() *Digest {
	if m != nil {
		return m.ActionDigest
	}
	return nil
}

// A request message for
// [ActionCache.UpdateActionResult][google.devtools.remoteexecution.v1test.ActionCache.UpdateActionResult].
type UpdateActionResultRequest struct {
	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The digest of the [Action][google.devtools.remoteexecution.v1test.Action]
	// whose result is being uploaded.
	ActionDigest *Digest `protobuf:"bytes,2,opt,name=action_digest,json=actionDigest,proto3" json:"action_digest,omitempty"`
	// The [ActionResult][google.devtools.remoteexecution.v1test.ActionResult]
	// to store in the cache.
	ActionResult         *ActionResult `protobuf:"bytes,3,opt,name=action_result,json=actionResult,proto3" json:"action_result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *UpdateActionResultRequest) Reset()         { *m = UpdateActionResultRequest{} }
func (m *UpdateActionResultRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateActionResultRequest) ProtoMessage()    {}
func (*UpdateActionResultRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{16}
}
func (m *UpdateActionResultRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateActionResultRequest.Unmarshal(m, b)
}
func (m *UpdateActionResultRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateActionResultRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateActionResultRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateActionResultRequest.Merge(dst, src)
}
func (m *UpdateActionResultRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateActionResultRequest.Size(m)
}
func (m *UpdateActionResultRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateActionResultRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateActionResultRequest proto.InternalMessageInfo

func (m *UpdateActionResultRequest) GetInstanceName() string {
	if m != nil {
		return m.InstanceName
	}
	return ""
}

func (m *UpdateActionResultRequest) GetActionDigest() *Digest {
	if m != nil {
		return m.ActionDigest
	}
	return nil
}

func (m *UpdateActionResultRequest) GetActionResult() *ActionResult {
	if m != nil {
		return m.ActionResult
	}
	return nil
}

// A request message for
// [ContentAddressableStorage.FindMissingBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.FindMissingBlobs].
type FindMissingBlobsRequest struct {
	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// A list of the blobs to check.
	BlobDigests          []*Digest `protobuf:"bytes,2,rep,name=blob_digests,json=blobDigests,proto3" json:"blob_digests,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *FindMissingBlobsRequest) Reset()         { *m = FindMissingBlobsRequest{} }
func (m *FindMissingBlobsRequest) String() string { return proto.CompactTextString(m) }
func (*FindMissingBlobsRequest) ProtoMessage()    {}
func (*FindMissingBlobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{17}
}
func (m *FindMissingBlobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FindMissingBlobsRequest.Unmarshal(m, b)
}
func (m *FindMissingBlobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FindMissingBlobsRequest.Marshal(b, m, deterministic)
}
func (dst *FindMissingBlobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FindMissingBlobsRequest.Merge(dst, src)
}
func (m *FindMissingBlobsRequest) XXX_Size() int {
	return xxx_messageInfo_FindMissingBlobsRequest.Size(m)
}
func (m *FindMissingBlobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FindMissingBlobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FindMissingBlobsRequest proto.InternalMessageInfo

func (m *FindMissingBlobsRequest) GetInstanceName() string {
	if m != nil {
		return m.InstanceName
	}
	return ""
}

func (m *FindMissingBlobsRequest) GetBlobDigests() []*Digest {
	if m != nil {
		return m.BlobDigests
	}
	return nil
}

// A response message for
// [ContentAddressableStorage.FindMissingBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.FindMissingBlobs].
type FindMissingBlobsResponse struct {
	// A list of the blobs requested *not* present in the storage.
	MissingBlobDigests   []*Digest `protobuf:"bytes,2,rep,name=missing_blob_digests,json=missingBlobDigests,proto3" json:"missing_blob_digests,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *FindMissingBlobsResponse) Reset()         { *m = FindMissingBlobsResponse{} }
func (m *FindMissingBlobsResponse) String() string { return proto.CompactTextString(m) }
func (*FindMissingBlobsResponse) ProtoMessage()    {}
func (*FindMissingBlobsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{18}
}
func (m *FindMissingBlobsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FindMissingBlobsResponse.Unmarshal(m, b)
}
func (m *FindMissingBlobsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FindMissingBlobsResponse.Marshal(b, m, deterministic)
}
func (dst *FindMissingBlobsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FindMissingBlobsResponse.Merge(dst, src)
}
func (m *FindMissingBlobsResponse) XXX_Size() int {
	return xxx_messageInfo_FindMissingBlobsResponse.Size(m)
}
func (m *FindMissingBlobsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FindMissingBlobsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FindMissingBlobsResponse proto.InternalMessageInfo

func (m *FindMissingBlobsResponse) GetMissingBlobDigests() []*Digest {
	if m != nil {
		return m.MissingBlobDigests
	}
	return nil
}

// A single request message for
// [ContentAddressableStorage.BatchUpdateBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.BatchUpdateBlobs].
type UpdateBlobRequest struct {
	// The digest of the blob. This MUST be the digest of `data`.
	ContentDigest *Digest `protobuf:"bytes,1,opt,name=content_digest,json=contentDigest,proto3" json:"content_digest,omitempty"`
	// The raw binary data.
	Data                 []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateBlobRequest) Reset()         { *m = UpdateBlobRequest{} }
func (m *UpdateBlobRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateBlobRequest) ProtoMessage()    {}
func (*UpdateBlobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{19}
}
func (m *UpdateBlobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateBlobRequest.Unmarshal(m, b)
}
func (m *UpdateBlobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateBlobRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateBlobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateBlobRequest.Merge(dst, src)
}
func (m *UpdateBlobRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateBlobRequest.Size(m)
}
func (m *UpdateBlobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateBlobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateBlobRequest proto.InternalMessageInfo

func (m *UpdateBlobRequest) GetContentDigest() *Digest {
	if m != nil {
		return m.ContentDigest
	}
	return nil
}

func (m *UpdateBlobRequest) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// A request message for
// [ContentAddressableStorage.BatchUpdateBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.BatchUpdateBlobs].
type BatchUpdateBlobsRequest struct {
	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The individual upload requests.
	Requests             []*UpdateBlobRequest `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *BatchUpdateBlobsRequest) Reset()         { *m = BatchUpdateBlobsRequest{} }
func (m *BatchUpdateBlobsRequest) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateBlobsRequest) ProtoMessage()    {}
func (*BatchUpdateBlobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{20}
}
func (m *BatchUpdateBlobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateBlobsRequest.Unmarshal(m, b)
}
func (m *BatchUpdateBlobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateBlobsRequest.Marshal(b, m, deterministic)
}
func (dst *BatchUpdateBlobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateBlobsRequest.Merge(dst, src)
}
func (m *BatchUpdateBlobsRequest) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateBlobsRequest.Size(m)
}
func (m *BatchUpdateBlobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateBlobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateBlobsRequest proto.InternalMessageInfo

func (m *BatchUpdateBlobsRequest) GetInstanceName() string {
	if m != nil {
		return m.InstanceName
	}
	return ""
}

func (m *BatchUpdateBlobsRequest) GetRequests() []*UpdateBlobRequest {
	if m != nil {
		return m.Requests
	}
	return nil
}

// A response message for
// [ContentAddressableStorage.BatchUpdateBlobs][google.devtools.remoteexecution.v1test.ContentAddressableStorage.BatchUpdateBlobs].
type BatchUpdateBlobsResponse struct {
	// The responses to the requests.
	Responses            []*BatchUpdateBlobsResponse_Response `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *BatchUpdateBlobsResponse) Reset()         { *m = BatchUpdateBlobsResponse{} }
func (m *BatchUpdateBlobsResponse) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateBlobsResponse) ProtoMessage()    {}
func (*BatchUpdateBlobsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{21}
}
func (m *BatchUpdateBlobsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateBlobsResponse.Unmarshal(m, b)
}
func (m *BatchUpdateBlobsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateBlobsResponse.Marshal(b, m, deterministic)
}
func (dst *BatchUpdateBlobsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateBlobsResponse.Merge(dst, src)
}
func (m *BatchUpdateBlobsResponse) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateBlobsResponse.Size(m)
}
func (m *BatchUpdateBlobsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateBlobsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateBlobsResponse proto.InternalMessageInfo

func (m *BatchUpdateBlobsResponse) GetResponses() []*BatchUpdateBlobsResponse_Response {
	if m != nil {
		return m.Responses
	}
	return nil
}

// A response corresponding to a single blob that the client tried to upload.
type BatchUpdateBlobsResponse_Response struct {
	// The digest to which this response corresponds.
	BlobDigest *Digest `protobuf:"bytes,1,opt,name=blob_digest,json=blobDigest,proto3" json:"blob_digest,omitempty"`
	// The result of attempting to upload that blob.
	Status               *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *BatchUpdateBlobsResponse_Response) Reset()         { *m = BatchUpdateBlobsResponse_Response{} }
func (m *BatchUpdateBlobsResponse_Response) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateBlobsResponse_Response) ProtoMessage()    {}
func (*BatchUpdateBlobsResponse_Response) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{21, 0}
}
func (m *BatchUpdateBlobsResponse_Response) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateBlobsResponse_Response.Unmarshal(m, b)
}
func (m *BatchUpdateBlobsResponse_Response) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateBlobsResponse_Response.Marshal(b, m, deterministic)
}
func (dst *BatchUpdateBlobsResponse_Response) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateBlobsResponse_Response.Merge(dst, src)
}
func (m *BatchUpdateBlobsResponse_Response) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateBlobsResponse_Response.Size(m)
}
func (m *BatchUpdateBlobsResponse_Response) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateBlobsResponse_Response.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateBlobsResponse_Response proto.InternalMessageInfo

func (m *BatchUpdateBlobsResponse_Response) GetBlobDigest() *Digest {
	if m != nil {
		return m.BlobDigest
	}
	return nil
}

func (m *BatchUpdateBlobsResponse_Response) GetStatus() *status.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

// A request message for
// [ContentAddressableStorage.GetTree][google.devtools.remoteexecution.v1test.ContentAddressableStorage.GetTree].
type GetTreeRequest struct {
	// The instance of the execution system to operate against. A server may
	// support multiple instances of the execution system (with their own workers,
	// storage, caches, etc.). The server MAY require use of this field to select
	// between them in an implementation-defined fashion, otherwise it can be
	// omitted.
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// The digest of the root, which must be an encoded
	// [Directory][google.devtools.remoteexecution.v1test.Directory] message
	// stored in the
	// [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
	RootDigest *Digest `protobuf:"bytes,2,opt,name=root_digest,json=rootDigest,proto3" json:"root_digest,omitempty"`
	// A maximum page size to request. If present, the server will request no more
	// than this many items. Regardless of whether a page size is specified, the
	// server may place its own limit on the number of items to be returned and
	// require the client to retrieve more items using a subsequent request.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, which must be a value received in a previous
	// [GetTreeResponse][google.devtools.remoteexecution.v1test.GetTreeResponse].
	// If present, the server will use it to return the following page of results.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTreeRequest) Reset()         { *m = GetTreeRequest{} }
func (m *GetTreeRequest) String() string { return proto.CompactTextString(m) }
func (*GetTreeRequest) ProtoMessage()    {}
func (*GetTreeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{22}
}
func (m *GetTreeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTreeRequest.Unmarshal(m, b)
}
func (m *GetTreeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTreeRequest.Marshal(b, m, deterministic)
}
func (dst *GetTreeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTreeRequest.Merge(dst, src)
}
func (m *GetTreeRequest) XXX_Size() int {
	return xxx_messageInfo_GetTreeRequest.Size(m)
}
func (m *GetTreeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTreeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTreeRequest proto.InternalMessageInfo

func (m *GetTreeRequest) GetInstanceName() string {
	if m != nil {
		return m.InstanceName
	}
	return ""
}

func (m *GetTreeRequest) GetRootDigest() *Digest {
	if m != nil {
		return m.RootDigest
	}
	return nil
}

func (m *GetTreeRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *GetTreeRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// A response message for
// [ContentAddressableStorage.GetTree][google.devtools.remoteexecution.v1test.ContentAddressableStorage.GetTree].
type GetTreeResponse struct {
	// The directories descended from the requested root.
	Directories []*Directory `protobuf:"bytes,1,rep,name=directories,proto3" json:"directories,omitempty"`
	// If present, signifies that there are more results which the client can
	// retrieve by passing this as the page_token in a subsequent
	// [request][google.devtools.remoteexecution.v1test.GetTreeRequest].
	// If empty, signifies that this is the last page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTreeResponse) Reset()         { *m = GetTreeResponse{} }
func (m *GetTreeResponse) String() string { return proto.CompactTextString(m) }
func (*GetTreeResponse) ProtoMessage()    {}
func (*GetTreeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{23}
}
func (m *GetTreeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTreeResponse.Unmarshal(m, b)
}
func (m *GetTreeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTreeResponse.Marshal(b, m, deterministic)
}
func (dst *GetTreeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTreeResponse.Merge(dst, src)
}
func (m *GetTreeResponse) XXX_Size() int {
	return xxx_messageInfo_GetTreeResponse.Size(m)
}
func (m *GetTreeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTreeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetTreeResponse proto.InternalMessageInfo

func (m *GetTreeResponse) GetDirectories() []*Directory {
	if m != nil {
		return m.Directories
	}
	return nil
}

func (m *GetTreeResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Details for the tool used to call the API.
type ToolDetails struct {
	// Name of the tool, e.g. bazel.
	ToolName string `protobuf:"bytes,1,opt,name=tool_name,json=toolName,proto3" json:"tool_name,omitempty"`
	// Version of the tool used for the request, e.g. 5.0.3.
	ToolVersion          string   `protobuf:"bytes,2,opt,name=tool_version,json=toolVersion,proto3" json:"tool_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ToolDetails) Reset()         { *m = ToolDetails{} }
func (m *ToolDetails) String() string { return proto.CompactTextString(m) }
func (*ToolDetails) ProtoMessage()    {}
func (*ToolDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{24}
}
func (m *ToolDetails) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ToolDetails.Unmarshal(m, b)
}
func (m *ToolDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ToolDetails.Marshal(b, m, deterministic)
}
func (dst *ToolDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ToolDetails.Merge(dst, src)
}
func (m *ToolDetails) XXX_Size() int {
	return xxx_messageInfo_ToolDetails.Size(m)
}
func (m *ToolDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_ToolDetails.DiscardUnknown(m)
}

var xxx_messageInfo_ToolDetails proto.InternalMessageInfo

func (m *ToolDetails) GetToolName() string {
	if m != nil {
		return m.ToolName
	}
	return ""
}

func (m *ToolDetails) GetToolVersion() string {
	if m != nil {
		return m.ToolVersion
	}
	return ""
}

// An optional Metadata to attach to any RPC request to tell the server about an
// external context of the request. The server may use this for logging or other
// purposes. To use it, the client attaches the header to the call using the
// canonical proto serialization:
// name: google.devtools.remoteexecution.v1test.requestmetadata-bin
// contents: the base64 encoded binary RequestMetadata message.
type RequestMetadata struct {
	// The details for the tool invoking the requests.
	ToolDetails *ToolDetails `protobuf:"bytes,1,opt,name=tool_details,json=toolDetails,proto3" json:"tool_details,omitempty"`
	// An identifier that ties multiple requests to the same action.
	// For example, multiple requests to the CAS, Action Cache, and Execution
	// API are used in order to compile foo.cc.
	ActionId string `protobuf:"bytes,2,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	// An identifier that ties multiple actions together to a final result.
	// For example, multiple actions are required to build and run foo_test.
	ToolInvocationId string `protobuf:"bytes,3,opt,name=tool_invocation_id,json=toolInvocationId,proto3" json:"tool_invocation_id,omitempty"`
	// An identifier to tie multiple tool invocations together. For example,
	// runs of foo_test, bar_test and baz_test on a post-submit of a given patch.
	CorrelatedInvocationsId string   `protobuf:"bytes,4,opt,name=correlated_invocations_id,json=correlatedInvocationsId,proto3" json:"correlated_invocations_id,omitempty"`
	XXX_NoUnkeyedLiteral    struct{} `json:"-"`
	XXX_unrecognized        []byte   `json:"-"`
	XXX_sizecache           int32    `json:"-"`
}

func (m *RequestMetadata) Reset()         { *m = RequestMetadata{} }
func (m *RequestMetadata) String() string { return proto.CompactTextString(m) }
func (*RequestMetadata) ProtoMessage()    {}
func (*RequestMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_remote_execution_3cbae0ca1c4e63f2, []int{25}
}
func (m *RequestMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RequestMetadata.Unmarshal(m, b)
}
func (m *RequestMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RequestMetadata.Marshal(b, m, deterministic)
}
func (dst *RequestMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestMetadata.Merge(dst, src)
}
func (m *RequestMetadata) XXX_Size() int {
	return xxx_messageInfo_RequestMetadata.Size(m)
}
func (m *RequestMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_RequestMetadata proto.InternalMessageInfo

func (m *RequestMetadata) GetToolDetails() *ToolDetails {
	if m != nil {
		return m.ToolDetails
	}
	return nil
}

func (m *RequestMetadata) GetActionId() string {
	if m != nil {
		return m.ActionId
	}
	return ""
}

func (m *RequestMetadata) GetToolInvocationId() string {
	if m != nil {
		return m.ToolInvocationId
	}
	return ""
}

func (m *RequestMetadata) GetCorrelatedInvocationsId() string {
	if m != nil {
		return m.CorrelatedInvocationsId
	}
	return ""
}

func init() {
	proto.RegisterType((*Action)(nil), "google.devtools.remoteexecution.v1test.Action")
	proto.RegisterType((*Command)(nil), "google.devtools.remoteexecution.v1test.Command")
	proto.RegisterType((*Command_EnvironmentVariable)(nil), "google.devtools.remoteexecution.v1test.Command.EnvironmentVariable")
	proto.RegisterType((*Platform)(nil), "google.devtools.remoteexecution.v1test.Platform")
	proto.RegisterType((*Platform_Property)(nil), "google.devtools.remoteexecution.v1test.Platform.Property")
	proto.RegisterType((*Directory)(nil), "google.devtools.remoteexecution.v1test.Directory")
	proto.RegisterType((*FileNode)(nil), "google.devtools.remoteexecution.v1test.FileNode")
	proto.RegisterType((*DirectoryNode)(nil), "google.devtools.remoteexecution.v1test.DirectoryNode")
	proto.RegisterType((*Digest)(nil), "google.devtools.remoteexecution.v1test.Digest")
	proto.RegisterType((*ActionResult)(nil), "google.devtools.remoteexecution.v1test.ActionResult")
	proto.RegisterType((*OutputFile)(nil), "google.devtools.remoteexecution.v1test.OutputFile")
	proto.RegisterType((*Tree)(nil), "google.devtools.remoteexecution.v1test.Tree")
	proto.RegisterType((*OutputDirectory)(nil), "google.devtools.remoteexecution.v1test.OutputDirectory")
	proto.RegisterType((*ExecuteRequest)(nil), "google.devtools.remoteexecution.v1test.ExecuteRequest")
	proto.RegisterType((*LogFile)(nil), "google.devtools.remoteexecution.v1test.LogFile")
	proto.RegisterType((*ExecuteResponse)(nil), "google.devtools.remoteexecution.v1test.ExecuteResponse")
	proto.RegisterMapType((map[string]*LogFile)(nil), "google.devtools.remoteexecution.v1test.ExecuteResponse.ServerLogsEntry")
	proto.RegisterType((*ExecuteOperationMetadata)(nil), "google.devtools.remoteexecution.v1test.ExecuteOperationMetadata")
	proto.RegisterType((*GetActionResultRequest)(nil), "google.devtools.remoteexecution.v1test.GetActionResultRequest")
	proto.RegisterType((*UpdateActionResultRequest)(nil), "google.devtools.remoteexecution.v1test.UpdateActionResultRequest")
	proto.RegisterType((*FindMissingBlobsRequest)(nil), "google.devtools.remoteexecution.v1test.FindMissingBlobsRequest")
	proto.RegisterType((*FindMissingBlobsResponse)(nil), "google.devtools.remoteexecution.v1test.FindMissingBlobsResponse")
	proto.RegisterType((*UpdateBlobRequest)(nil), "google.devtools.remoteexecution.v1test.UpdateBlobRequest")
	proto.RegisterType((*BatchUpdateBlobsRequest)(nil), "google.devtools.remoteexecution.v1test.BatchUpdateBlobsRequest")
	proto.RegisterType((*BatchUpdateBlobsResponse)(nil), "google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse")
	proto.RegisterType((*BatchUpdateBlobsResponse_Response)(nil), "google.devtools.remoteexecution.v1test.BatchUpdateBlobsResponse.Response")
	proto.RegisterType((*GetTreeRequest)(nil), "google.devtools.remoteexecution.v1test.GetTreeRequest")
	proto.RegisterType((*GetTreeResponse)(nil), "google.devtools.remoteexecution.v1test.GetTreeResponse")
	proto.RegisterType((*ToolDetails)(nil), "google.devtools.remoteexecution.v1test.ToolDetails")
	proto.RegisterType((*RequestMetadata)(nil), "google.devtools.remoteexecution.v1test.RequestMetadata")
	proto.RegisterEnum("google.devtools.remoteexecution.v1test.ExecuteOperationMetadata_Stage", ExecuteOperationMetadata_Stage_name, ExecuteOperationMetadata_Stage_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ExecutionClient is the client API for Execution service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ExecutionClient interface {
	// Execute an action remotely.
	//
	// In order to execute an action, the client must first upload all of the
	// inputs, as well as the
	// [Command][google.devtools.remoteexecution.v1test.Command] to run, into the
	// [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
	// It then calls `Execute` with an
	// [Action][google.devtools.remoteexecution.v1test.Action] referring to them.
	// The server will run the action and eventually return the result.
	//
	// The input `Action`'s fields MUST meet the various canonicalization
	// requirements specified in the documentation for their types so that it has
	// the same digest as other logically equivalent `Action`s. The server MAY
	// enforce the requirements and return errors if a non-canonical input is
	// received. It MAY also proceed without verifying some or all of the
	// requirements, such as for performance reasons. If the server does not
	// verify the requirement, then it will treat the `Action` as distinct from
	// another logically equivalent action if they hash differently.
	//
	// Returns a [google.longrunning.Operation][google.longrunning.Operation]
	// describing the resulting execution, with eventual `response`
	// [ExecuteResponse][google.devtools.remoteexecution.v1test.ExecuteResponse].
	// The `metadata` on the operation is of type
	// [ExecuteOperationMetadata][google.devtools.remoteexecution.v1test.ExecuteOperationMetadata].
	//
	// To query the operation, you can use the
	// [Operations API][google.longrunning.Operations.GetOperation]. If you wish
	// to allow the server to stream operations updates, rather than requiring
	// client polling, you can use the
	// [Watcher API][google.watcher.v1.Watcher.Watch] with the Operation's `name`
	// as the `target`.
	//
	// When using the Watcher API, the initial `data` will be the `Operation` at
	// the time of the request. Updates will be provided periodically by the
	// server until the `Operation` completes, at which point the response message
	// will (assuming no error) be at `data.response`.
	//
	// The server NEED NOT implement other methods or functionality of the
	// Operation and Watcher APIs.
	//
	// Errors discovered during creation of the `Operation` will be reported
	// as gRPC Status errors, while errors that occurred while running the
	// action will be reported in the `status` field of the `ExecuteResponse`. The
	// server MUST NOT set the `error` field of the `Operation` proto.
	// The possible errors include:
	// * `INVALID_ARGUMENT`: One or more arguments are invalid.
	// * `FAILED_PRECONDITION`: One or more errors occurred in setting up the
	//   action requested, such as a missing input or command or no worker being
	//   available. The client may be able to fix the errors and retry.
	// * `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to run
	//   the action.
	// * `UNAVAILABLE`: Due to a transient condition, such as all workers being
	//   occupied (and the server does not support a queue), the action could not
	//   be started. The client should retry.
	// * `INTERNAL`: An internal error occurred in the execution engine or the
	//   worker.
	// * `DEADLINE_EXCEEDED`: The execution timed out.
	//
	// In the case of a missing input or command, the server SHOULD additionally
	// send a [PreconditionFailure][google.rpc.PreconditionFailure] error detail
	// where, for each requested blob not present in the CAS, there is a
	// `Violation` with a `type` of `MISSING` and a `subject` of
	// `"blobs/{hash}/{size}"` indicating the digest of the missing blob.
	Execute(ctx context.Context, in *ExecuteRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type executionClient struct {
	cc *grpc.ClientConn
}

func NewExecutionClient(cc *grpc.ClientConn) ExecutionClient {
	return &executionClient{cc}
}

func (c *executionClient) Execute(ctx context.Context, in *ExecuteRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.devtools.remoteexecution.v1test.Execution/Execute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ExecutionServer is the server API for Execution service.
type ExecutionServer interface {
	// Execute an action remotely.
	//
	// In order to execute an action, the client must first upload all of the
	// inputs, as well as the
	// [Command][google.devtools.remoteexecution.v1test.Command] to run, into the
	// [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage].
	// It then calls `Execute` with an
	// [Action][google.devtools.remoteexecution.v1test.Action] referring to them.
	// The server will run the action and eventually return the result.
	//
	// The input `Action`'s fields MUST meet the various canonicalization
	// requirements specified in the documentation for their types so that it has
	// the same digest as other logically equivalent `Action`s. The server MAY
	// enforce the requirements and return errors if a non-canonical input is
	// received. It MAY also proceed without verifying some or all of the
	// requirements, such as for performance reasons. If the server does not
	// verify the requirement, then it will treat the `Action` as distinct from
	// another logically equivalent action if they hash differently.
	//
	// Returns a [google.longrunning.Operation][google.longrunning.Operation]
	// describing the resulting execution, with eventual `response`
	// [ExecuteResponse][google.devtools.remoteexecution.v1test.ExecuteResponse].
	// The `metadata` on the operation is of type
	// [ExecuteOperationMetadata][google.devtools.remoteexecution.v1test.ExecuteOperationMetadata].
	//
	// To query the operation, you can use the
	// [Operations API][google.longrunning.Operations.GetOperation]. If you wish
	// to allow the server to stream operations updates, rather than requiring
	// client polling, you can use the
	// [Watcher API][google.watcher.v1.Watcher.Watch] with the Operation's `name`
	// as the `target`.
	//
	// When using the Watcher API, the initial `data` will be the `Operation` at
	// the time of the request. Updates will be provided periodically by the
	// server until the `Operation` completes, at which point the response message
	// will (assuming no error) be at `data.response`.
	//
	// The server NEED NOT implement other methods or functionality of the
	// Operation and Watcher APIs.
	//
	// Errors discovered during creation of the `Operation` will be reported
	// as gRPC Status errors, while errors that occurred while running the
	// action will be reported in the `status` field of the `ExecuteResponse`. The
	// server MUST NOT set the `error` field of the `Operation` proto.
	// The possible errors include:
	// * `INVALID_ARGUMENT`: One or more arguments are invalid.
	// * `FAILED_PRECONDITION`: One or more errors occurred in setting up the
	//   action requested, such as a missing input or command or no worker being
	//   available. The client may be able to fix the errors and retry.
	// * `RESOURCE_EXHAUSTED`: There is insufficient quota of some resource to run
	//   the action.
	// * `UNAVAILABLE`: Due to a transient condition, such as all workers being
	//   occupied (and the server does not support a queue), the action could not
	//   be started. The client should retry.
	// * `INTERNAL`: An internal error occurred in the execution engine or the
	//   worker.
	// * `DEADLINE_EXCEEDED`: The execution timed out.
	//
	// In the case of a missing input or command, the server SHOULD additionally
	// send a [PreconditionFailure][google.rpc.PreconditionFailure] error detail
	// where, for each requested blob not present in the CAS, there is a
	// `Violation` with a `type` of `MISSING` and a `subject` of
	// `"blobs/{hash}/{size}"` indicating the digest of the missing blob.
	Execute(context.Context, *ExecuteRequest) (*longrunning.Operation, error)
}

func RegisterExecutionServer(s *grpc.Server, srv ExecutionServer) {
	s.RegisterService(&_Execution_serviceDesc, srv)
}

func _Execution_Execute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExecutionServer).Execute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteexecution.v1test.Execution/Execute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExecutionServer).Execute(ctx, req.(*ExecuteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Execution_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.remoteexecution.v1test.Execution",
	HandlerType: (*ExecutionServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Execute",
			Handler:    _Execution_Execute_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/remoteexecution/v1test/remote_execution.proto",
}

// ActionCacheClient is the client API for ActionCache service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ActionCacheClient interface {
	// Retrieve a cached execution result.
	//
	// Errors:
	// * `NOT_FOUND`: The requested `ActionResult` is not in the cache.
	GetActionResult(ctx context.Context, in *GetActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error)
	// Upload a new execution result.
	//
	// This method is intended for servers which implement the distributed cache
	// independently of the
	// [Execution][google.devtools.remoteexecution.v1test.Execution] API. As a
	// result, it is OPTIONAL for servers to implement.
	//
	// Errors:
	// * `NOT_IMPLEMENTED`: This method is not supported by the server.
	// * `RESOURCE_EXHAUSTED`: There is insufficient storage space to add the
	//   entry to the cache.
	UpdateActionResult(ctx context.Context, in *UpdateActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error)
}

type actionCacheClient struct {
	cc *grpc.ClientConn
}

func NewActionCacheClient(cc *grpc.ClientConn) ActionCacheClient {
	return &actionCacheClient{cc}
}

func (c *actionCacheClient) GetActionResult(ctx context.Context, in *GetActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error) {
	out := new(ActionResult)
	err := c.cc.Invoke(ctx, "/google.devtools.remoteexecution.v1test.ActionCache/GetActionResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *actionCacheClient) UpdateActionResult(ctx context.Context, in *UpdateActionResultRequest, opts ...grpc.CallOption) (*ActionResult, error) {
	out := new(ActionResult)
	err := c.cc.Invoke(ctx, "/google.devtools.remoteexecution.v1test.ActionCache/UpdateActionResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ActionCacheServer is the server API for ActionCache service.
type ActionCacheServer interface {
	// Retrieve a cached execution result.
	//
	// Errors:
	// * `NOT_FOUND`: The requested `ActionResult` is not in the cache.
	GetActionResult(context.Context, *GetActionResultRequest) (*ActionResult, error)
	// Upload a new execution result.
	//
	// This method is intended for servers which implement the distributed cache
	// independently of the
	// [Execution][google.devtools.remoteexecution.v1test.Execution] API. As a
	// result, it is OPTIONAL for servers to implement.
	//
	// Errors:
	// * `NOT_IMPLEMENTED`: This method is not supported by the server.
	// * `RESOURCE_EXHAUSTED`: There is insufficient storage space to add the
	//   entry to the cache.
	UpdateActionResult(context.Context, *UpdateActionResultRequest) (*ActionResult, error)
}

func RegisterActionCacheServer(s *grpc.Server, srv ActionCacheServer) {
	s.RegisterService(&_ActionCache_serviceDesc, srv)
}

func _ActionCache_GetActionResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetActionResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionCacheServer).GetActionResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteexecution.v1test.ActionCache/GetActionResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionCacheServer).GetActionResult(ctx, req.(*GetActionResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ActionCache_UpdateActionResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateActionResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ActionCacheServer).UpdateActionResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteexecution.v1test.ActionCache/UpdateActionResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ActionCacheServer).UpdateActionResult(ctx, req.(*UpdateActionResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ActionCache_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.remoteexecution.v1test.ActionCache",
	HandlerType: (*ActionCacheServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetActionResult",
			Handler:    _ActionCache_GetActionResult_Handler,
		},
		{
			MethodName: "UpdateActionResult",
			Handler:    _ActionCache_UpdateActionResult_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/remoteexecution/v1test/remote_execution.proto",
}

// ContentAddressableStorageClient is the client API for ContentAddressableStorage service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ContentAddressableStorageClient interface {
	// Determine if blobs are present in the CAS.
	//
	// Clients can use this API before uploading blobs to determine which ones are
	// already present in the CAS and do not need to be uploaded again.
	//
	// There are no method-specific errors.
	FindMissingBlobs(ctx context.Context, in *FindMissingBlobsRequest, opts ...grpc.CallOption) (*FindMissingBlobsResponse, error)
	// Upload many blobs at once.
	//
	// The client MUST NOT upload blobs with a combined total size of more than 10
	// MiB using this API. Such requests should either be split into smaller
	// chunks or uploaded using the
	// [ByteStream API][google.bytestream.ByteStream], as appropriate.
	//
	// This request is equivalent to calling [UpdateBlob][] on each individual
	// blob, in parallel. The requests may succeed or fail independently.
	//
	// Errors:
	// * `INVALID_ARGUMENT`: The client attempted to upload more than 10 MiB of
	//   data.
	//
	// Individual requests may return the following errors, additionally:
	// * `RESOURCE_EXHAUSTED`: There is insufficient disk quota to store the blob.
	// * `INVALID_ARGUMENT`: The
	// [Digest][google.devtools.remoteexecution.v1test.Digest] does not match the
	// provided data.
	BatchUpdateBlobs(ctx context.Context, in *BatchUpdateBlobsRequest, opts ...grpc.CallOption) (*BatchUpdateBlobsResponse, error)
	// Fetch the entire directory tree rooted at a node.
	//
	// This request must be targeted at a
	// [Directory][google.devtools.remoteexecution.v1test.Directory] stored in the
	// [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage]
	// (CAS). The server will enumerate the `Directory` tree recursively and
	// return every node descended from the root.
	// The exact traversal order is unspecified and, unless retrieving subsequent
	// pages from an earlier request, is not guaranteed to be stable across
	// multiple invocations of `GetTree`.
	//
	// If part of the tree is missing from the CAS, the server will return the
	// portion present and omit the rest.
	//
	// * `NOT_FOUND`: The requested tree root is not present in the CAS.
	GetTree(ctx context.Context, in *GetTreeRequest, opts ...grpc.CallOption) (*GetTreeResponse, error)
}

type contentAddressableStorageClient struct {
	cc *grpc.ClientConn
}

func NewContentAddressableStorageClient(cc *grpc.ClientConn) ContentAddressableStorageClient {
	return &contentAddressableStorageClient{cc}
}

func (c *contentAddressableStorageClient) FindMissingBlobs(ctx context.Context, in *FindMissingBlobsRequest, opts ...grpc.CallOption) (*FindMissingBlobsResponse, error) {
	out := new(FindMissingBlobsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.remoteexecution.v1test.ContentAddressableStorage/FindMissingBlobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contentAddressableStorageClient) BatchUpdateBlobs(ctx context.Context, in *BatchUpdateBlobsRequest, opts ...grpc.CallOption) (*BatchUpdateBlobsResponse, error) {
	out := new(BatchUpdateBlobsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.remoteexecution.v1test.ContentAddressableStorage/BatchUpdateBlobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *contentAddressableStorageClient) GetTree(ctx context.Context, in *GetTreeRequest, opts ...grpc.CallOption) (*GetTreeResponse, error) {
	out := new(GetTreeResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.remoteexecution.v1test.ContentAddressableStorage/GetTree", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ContentAddressableStorageServer is the server API for ContentAddressableStorage service.
type ContentAddressableStorageServer interface {
	// Determine if blobs are present in the CAS.
	//
	// Clients can use this API before uploading blobs to determine which ones are
	// already present in the CAS and do not need to be uploaded again.
	//
	// There are no method-specific errors.
	FindMissingBlobs(context.Context, *FindMissingBlobsRequest) (*FindMissingBlobsResponse, error)
	// Upload many blobs at once.
	//
	// The client MUST NOT upload blobs with a combined total size of more than 10
	// MiB using this API. Such requests should either be split into smaller
	// chunks or uploaded using the
	// [ByteStream API][google.bytestream.ByteStream], as appropriate.
	//
	// This request is equivalent to calling [UpdateBlob][] on each individual
	// blob, in parallel. The requests may succeed or fail independently.
	//
	// Errors:
	// * `INVALID_ARGUMENT`: The client attempted to upload more than 10 MiB of
	//   data.
	//
	// Individual requests may return the following errors, additionally:
	// * `RESOURCE_EXHAUSTED`: There is insufficient disk quota to store the blob.
	// * `INVALID_ARGUMENT`: The
	// [Digest][google.devtools.remoteexecution.v1test.Digest] does not match the
	// provided data.
	BatchUpdateBlobs(context.Context, *BatchUpdateBlobsRequest) (*BatchUpdateBlobsResponse, error)
	// Fetch the entire directory tree rooted at a node.
	//
	// This request must be targeted at a
	// [Directory][google.devtools.remoteexecution.v1test.Directory] stored in the
	// [ContentAddressableStorage][google.devtools.remoteexecution.v1test.ContentAddressableStorage]
	// (CAS). The server will enumerate the `Directory` tree recursively and
	// return every node descended from the root.
	// The exact traversal order is unspecified and, unless retrieving subsequent
	// pages from an earlier request, is not guaranteed to be stable across
	// multiple invocations of `GetTree`.
	//
	// If part of the tree is missing from the CAS, the server will return the
	// portion present and omit the rest.
	//
	// * `NOT_FOUND`: The requested tree root is not present in the CAS.
	GetTree(context.Context, *GetTreeRequest) (*GetTreeResponse, error)
}

func RegisterContentAddressableStorageServer(s *grpc.Server, srv ContentAddressableStorageServer) {
	s.RegisterService(&_ContentAddressableStorage_serviceDesc, srv)
}

func _ContentAddressableStorage_FindMissingBlobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindMissingBlobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContentAddressableStorageServer).FindMissingBlobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteexecution.v1test.ContentAddressableStorage/FindMissingBlobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContentAddressableStorageServer).FindMissingBlobs(ctx, req.(*FindMissingBlobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContentAddressableStorage_BatchUpdateBlobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateBlobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContentAddressableStorageServer).BatchUpdateBlobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteexecution.v1test.ContentAddressableStorage/BatchUpdateBlobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContentAddressableStorageServer).BatchUpdateBlobs(ctx, req.(*BatchUpdateBlobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ContentAddressableStorage_GetTree_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTreeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ContentAddressableStorageServer).GetTree(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteexecution.v1test.ContentAddressableStorage/GetTree",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ContentAddressableStorageServer).GetTree(ctx, req.(*GetTreeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ContentAddressableStorage_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.remoteexecution.v1test.ContentAddressableStorage",
	HandlerType: (*ContentAddressableStorageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FindMissingBlobs",
			Handler:    _ContentAddressableStorage_FindMissingBlobs_Handler,
		},
		{
			MethodName: "BatchUpdateBlobs",
			Handler:    _ContentAddressableStorage_BatchUpdateBlobs_Handler,
		},
		{
			MethodName: "GetTree",
			Handler:    _ContentAddressableStorage_GetTree_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/remoteexecution/v1test/remote_execution.proto",
}

func init() {
	proto.RegisterFile("google/devtools/remoteexecution/v1test/remote_execution.proto", fileDescriptor_remote_execution_3cbae0ca1c4e63f2)
}

var fileDescriptor_remote_execution_3cbae0ca1c4e63f2 = []byte{
	// 2025 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0xdd, 0x6f, 0x23, 0x57,
	0x15, 0x67, 0xec, 0x24, 0xb6, 0x8f, 0x9d, 0x75, 0xf6, 0x76, 0xe9, 0x7a, 0xdd, 0x2e, 0x4a, 0xa7,
	0xa2, 0x8a, 0xa2, 0x62, 0xb3, 0xde, 0x96, 0x85, 0x54, 0xa5, 0x6c, 0x1c, 0x27, 0x8d, 0x9a, 0xaf,
	0x4e, 0xe2, 0x74, 0xbb, 0xaa, 0x34, 0x9d, 0x78, 0x6e, 0xc6, 0xa3, 0xd8, 0x73, 0xcd, 0xbd, 0xd7,
	0x69, 0xd2, 0x65, 0x79, 0xe0, 0x05, 0x09, 0x04, 0x12, 0x54, 0x08, 0x24, 0x78, 0x42, 0x42, 0x48,
	0x88, 0x27, 0xfe, 0x00, 0x24, 0xf8, 0x03, 0x78, 0x80, 0x17, 0x9e, 0x11, 0x2f, 0xbc, 0xf1, 0xdc,
	0x07, 0x84, 0xee, 0xc7, 0x7c, 0xd8, 0xc9, 0xb2, 0x63, 0x67, 0x57, 0xe2, 0xcd, 0x73, 0xce, 0x3d,
	0xbf, 0xf3, 0x79, 0xcf, 0x39, 0x33, 0x86, 0xb7, 0x3d, 0x42, 0xbc, 0x1e, 0xae, 0xbb, 0xf8, 0x94,
	0x13, 0xd2, 0x63, 0x75, 0x8a, 0xfb, 0x84, 0x63, 0x7c, 0x86, 0x3b, 0x43, 0xee, 0x93, 0xa0, 0x7e,
	0x7a, 0x87, 0x63, 0xc6, 0x35, 0xd9, 0x8e, 0xe8, 0xb5, 0x01, 0x25, 0x9c, 0xa0, 0xd7, 0x94, 0x78,
	0x2d, 0x14, 0xaf, 0x8d, 0x89, 0xd7, 0x94, 0x78, 0xf5, 0x65, 0xad, 0xc6, 0x19, 0xf8, 0x75, 0x27,
	0x08, 0x08, 0x77, 0x04, 0x97, 0x29, 0x94, 0xea, 0xab, 0x9a, 0xdb, 0x23, 0x81, 0x47, 0x87, 0x41,
	0xe0, 0x07, 0x5e, 0x9d, 0x0c, 0x30, 0x1d, 0x39, 0xf4, 0x25, 0x7d, 0x48, 0x3e, 0x1d, 0x0d, 0x8f,
	0xeb, 0xee, 0x50, 0x1d, 0xd0, 0xfc, 0x9b, 0x9a, 0x4f, 0x07, 0x9d, 0x3a, 0xe3, 0x0e, 0x1f, 0x6a,
	0x41, 0xf3, 0x0f, 0x59, 0x98, 0xbb, 0xdf, 0x11, 0x27, 0x51, 0x1b, 0xae, 0x75, 0x48, 0xbf, 0xef,
	0x04, 0xae, 0xed, 0xfa, 0x1e, 0x66, 0xbc, 0x62, 0x2c, 0x1a, 0x4b, 0xc5, 0x46, 0xad, 0x96, 0xce,
	0x8f, 0xda, 0x9a, 0x94, 0xb2, 0xe6, 0x35, 0x8a, 0x7a, 0x44, 0x0f, 0xe1, 0xba, 0x1f, 0x0c, 0x86,
	0xdc, 0xa6, 0x84, 0xf0, 0x10, 0x39, 0x33, 0x15, 0x72, 0x59, 0x02, 0x59, 0x84, 0x70, 0x8d, 0xfd,
	0x0a, 0x94, 0xc8, 0x90, 0x0b, 0xf0, 0x63, 0xbf, 0x87, 0x59, 0x25, 0xbb, 0x98, 0x5d, 0x2a, 0x58,
	0x45, 0x45, 0x5b, 0x17, 0x24, 0xf4, 0x15, 0x40, 0xfa, 0x88, 0xeb, 0x53, 0xdc, 0xe1, 0x84, 0xfa,
	0x98, 0x55, 0x66, 0xe4, 0xc1, 0xeb, 0x8a, 0xb3, 0x16, 0x33, 0xd0, 0x16, 0xe4, 0x07, 0x3d, 0x87,
	0x1f, 0x13, 0xda, 0xaf, 0xcc, 0x4a, 0x23, 0xbf, 0x9a, 0xd6, 0xc8, 0x3d, 0x2d, 0x67, 0x45, 0x08,
	0xe8, 0x2e, 0xe4, 0xb8, 0xdf, 0xc7, 0x64, 0xc8, 0x2b, 0x73, 0x12, 0xec, 0x56, 0x08, 0x16, 0x26,
	0xaa, 0xb6, 0xa6, 0x13, 0x65, 0x85, 0x27, 0xd1, 0x22, 0x94, 0x5c, 0x62, 0x07, 0x84, 0xdb, 0x1d,
	0xa7, 0xd3, 0xc5, 0x95, 0xdc, 0xa2, 0xb1, 0x94, 0xb7, 0xc0, 0x25, 0x3b, 0x84, 0x37, 0x05, 0xc5,
	0xfc, 0x87, 0x01, 0xb9, 0xa6, 0x0a, 0x32, 0x7a, 0x19, 0x0a, 0x0e, 0xf5, 0x86, 0x7d, 0x1c, 0x70,
	0x56, 0x31, 0xa4, 0x5b, 0x31, 0x01, 0x9d, 0xc1, 0x17, 0x71, 0x70, 0xea, 0x53, 0x12, 0x88, 0x67,
	0xfb, 0xd4, 0xa1, 0xbe, 0x73, 0x24, 0x22, 0x95, 0x59, 0xcc, 0x2e, 0x15, 0x1b, 0xcd, 0xb4, 0xbe,
	0x69, 0x6d, 0xb5, 0x56, 0x0c, 0x76, 0xa8, 0xb1, 0xac, 0x1b, 0xf8, 0x22, 0x91, 0x55, 0xdf, 0x81,
	0x17, 0x2e, 0x39, 0x8c, 0x10, 0xcc, 0x04, 0x4e, 0x1f, 0xcb, 0xd2, 0x2a, 0x58, 0xf2, 0x37, 0xba,
	0x01, 0xb3, 0xa7, 0x4e, 0x6f, 0x88, 0x65, 0x55, 0x14, 0x2c, 0xf5, 0x60, 0xfe, 0xd2, 0x80, 0x7c,
	0x18, 0x52, 0xf4, 0x21, 0xc0, 0x80, 0x8a, 0xaa, 0xe7, 0x22, 0x7b, 0x86, 0x34, 0xfe, 0x1b, 0x93,
	0x26, 0xa6, 0xb6, 0xa7, 0x20, 0xce, 0xad, 0x04, 0x58, 0xf5, 0x0d, 0xc8, 0x87, 0xf4, 0x09, 0xac,
	0xfb, 0xbd, 0x01, 0x85, 0xb0, 0x6e, 0xce, 0xd1, 0x3a, 0xcc, 0xaa, 0x02, 0x54, 0x96, 0xa5, 0x2e,
	0x19, 0x51, 0xa2, 0x3b, 0xc4, 0xc5, 0x96, 0x12, 0x47, 0x1f, 0x40, 0x31, 0x59, 0xa5, 0x2a, 0x49,
	0x6f, 0xa6, 0xbf, 0x25, 0xda, 0x1e, 0x09, 0x99, 0x44, 0x32, 0x7f, 0x68, 0x40, 0x3e, 0x54, 0x76,
	0xa9, 0x97, 0xeb, 0x30, 0x77, 0xa5, 0xab, 0xa9, 0xa5, 0xd1, 0xab, 0x30, 0xef, 0x33, 0xdd, 0x09,
	0x45, 0xc2, 0x2b, 0x33, 0xb2, 0x7a, 0x4b, 0x3e, 0x6b, 0x45, 0x34, 0xf3, 0x04, 0xe6, 0x47, 0x6c,
	0x7d, 0x9e, 0x16, 0x99, 0x6f, 0xc1, 0x9c, 0xee, 0x16, 0x08, 0x66, 0xba, 0x0e, 0xeb, 0x86, 0x5a,
	0xc4, 0x6f, 0x74, 0x1b, 0x80, 0xf9, 0x9f, 0x62, 0xfb, 0xe8, 0x9c, 0xcb, 0x80, 0x1b, 0x4b, 0x59,
	0xab, 0x20, 0x28, 0xab, 0x82, 0x60, 0xfe, 0x35, 0x0b, 0x25, 0xd5, 0x1e, 0x2d, 0xcc, 0x86, 0x3d,
	0x8e, 0xda, 0x63, 0x1d, 0x47, 0xa5, 0xa8, 0x91, 0xd6, 0xb6, 0xdd, 0xa8, 0x33, 0x8d, 0x76, 0xa9,
	0xe3, 0x4b, 0xbb, 0x54, 0x56, 0x82, 0xdf, 0x9b, 0x0c, 0x3c, 0x8a, 0xec, 0x65, 0xed, 0xed, 0x25,
	0x28, 0xe0, 0x33, 0x9f, 0xdb, 0x1d, 0xe2, 0xaa, 0xd4, 0xcc, 0x5a, 0x79, 0x41, 0x68, 0x8a, 0x2c,
	0x88, 0x58, 0x70, 0x97, 0x88, 0x56, 0xed, 0x7c, 0x22, 0xbb, 0x5f, 0xc9, 0x2a, 0x28, 0x8a, 0xe5,
	0x7c, 0x82, 0xf6, 0x61, 0x5e, 0xb3, 0x75, 0x5e, 0xe6, 0xa6, 0xca, 0x4b, 0x49, 0x81, 0xe8, 0x9c,
	0x28, 0x9d, 0x98, 0x52, 0xa9, 0x33, 0x17, 0xe9, 0xc4, 0x94, 0xc6, 0x3a, 0x05, 0x5b, 0xeb, 0xcc,
	0x4f, 0xad, 0x13, 0x53, 0xaa, 0x9e, 0xcc, 0xdf, 0x1a, 0x00, 0x71, 0x22, 0x44, 0x59, 0x0c, 0x1c,
	0x1e, 0x95, 0x85, 0xf8, 0xfd, 0xcc, 0xae, 0x43, 0x05, 0x72, 0x1d, 0x12, 0x70, 0x1c, 0xf0, 0x4a,
	0x56, 0xfa, 0x16, 0x3e, 0xa6, 0xbb, 0x28, 0xbf, 0x32, 0x60, 0xe6, 0x80, 0x62, 0x8c, 0x5a, 0x30,
	0x23, 0xc6, 0xa7, 0x9e, 0xc8, 0x77, 0x26, 0xee, 0x08, 0x96, 0x14, 0x47, 0xdb, 0x90, 0xef, 0x74,
	0xfd, 0x9e, 0x4b, 0x71, 0xa0, 0x2b, 0x77, 0x0a, 0xa8, 0x08, 0xc2, 0xfc, 0xa3, 0x01, 0xe5, 0xb1,
	0xa2, 0x7b, 0xae, 0xd1, 0xdc, 0x85, 0x22, 0xa7, 0x18, 0x87, 0xb5, 0x90, 0x9d, 0x0a, 0x0c, 0x04,
	0x84, 0xae, 0x84, 0xcf, 0x32, 0x70, 0x4d, 0x85, 0x1b, 0x5b, 0xf8, 0xdb, 0xc3, 0xb0, 0x81, 0x05,
	0x8c, 0x3b, 0x41, 0x07, 0xdb, 0x89, 0x9e, 0x54, 0x0a, 0x89, 0x3b, 0xba, 0x37, 0x39, 0xb2, 0x2b,
	0x4c, 0xea, 0x90, 0xee, 0x25, 0x5a, 0x1a, 0x2d, 0xc3, 0x75, 0x76, 0xe2, 0x0f, 0xd4, 0xa0, 0xb7,
	0x7b, 0x84, 0x9c, 0x0c, 0x07, 0xd2, 0xad, 0xbc, 0x55, 0x16, 0x0c, 0x39, 0xee, 0xb7, 0x24, 0x19,
	0xdd, 0x85, 0x17, 0x39, 0xe1, 0x4e, 0xcf, 0x56, 0xdb, 0x94, 0x68, 0x3f, 0x76, 0x87, 0x0c, 0x03,
	0xae, 0xef, 0xf1, 0x0b, 0x92, 0xbb, 0x19, 0xe8, 0xb2, 0x6e, 0x0a, 0xd6, 0xa5, 0x42, 0xaa, 0xd5,
	0xcd, 0xca, 0x56, 0x37, 0x26, 0xa4, 0x9a, 0xde, 0x19, 0xe4, 0xb6, 0x88, 0x27, 0xef, 0x46, 0x9c,
	0x39, 0xe3, 0x4a, 0x99, 0xfb, 0x32, 0x5c, 0xeb, 0x0e, 0xfb, 0x4e, 0x60, 0x53, 0xec, 0xb8, 0xb2,
	0xdc, 0x33, 0xd2, 0xcb, 0x79, 0x49, 0xb5, 0x34, 0xd1, 0xfc, 0x41, 0x16, 0xca, 0x51, 0x3e, 0xd8,
	0x80, 0x04, 0x0c, 0xa3, 0x2d, 0x98, 0xa3, 0xb2, 0xf7, 0x6a, 0x13, 0xde, 0x98, 0x30, 0xd6, 0x52,
	0xd6, 0xd2, 0x18, 0x22, 0xbd, 0x32, 0xd8, 0xae, 0xad, 0x41, 0x95, 0x1d, 0x25, 0x45, 0xd4, 0x4d,
	0x7e, 0x19, 0xe6, 0xd4, 0x92, 0xac, 0x4b, 0x0c, 0x85, 0x2a, 0xe9, 0xa0, 0x53, 0xdb, 0x97, 0x1c,
	0x4b, 0x9f, 0x40, 0x5d, 0x28, 0x32, 0x4c, 0x4f, 0x31, 0xb5, 0x7b, 0xc4, 0x53, 0x8b, 0x65, 0xb1,
	0xb1, 0x91, 0xd6, 0xc6, 0x31, 0x67, 0x6b, 0xfb, 0x12, 0x6a, 0x8b, 0x78, 0xac, 0x15, 0x70, 0x7a,
	0x6e, 0x01, 0x8b, 0x08, 0xd5, 0x00, 0xca, 0x63, 0x6c, 0xb4, 0x00, 0xd9, 0x13, 0x7c, 0xae, 0x4b,
	0x54, 0xfc, 0x44, 0xad, 0xe4, 0xb6, 0x52, 0x6c, 0xd4, 0xd3, 0x1a, 0xa2, 0x13, 0xae, 0xd7, 0x9b,
	0x95, 0xcc, 0xd7, 0x0d, 0xf3, 0xf3, 0x0c, 0x54, 0xb4, 0x7d, 0xbb, 0xe1, 0xfb, 0xc6, 0x36, 0xe6,
	0x8e, 0xeb, 0x70, 0x07, 0x7d, 0x04, 0xb3, 0x8c, 0x3b, 0x9e, 0xba, 0x1e, 0xd7, 0x1a, 0xeb, 0x13,
	0x3a, 0x7c, 0x01, 0x50, 0x84, 0xd5, 0xc3, 0x96, 0x02, 0x15, 0x6d, 0x5f, 0xdd, 0x90, 0xab, 0xbd,
	0x2f, 0x94, 0x14, 0x88, 0x1e, 0x35, 0xaf, 0x03, 0xd2, 0xf3, 0x8b, 0x71, 0x8a, 0x9d, 0xbe, 0xba,
	0xde, 0x59, 0x19, 0xbb, 0x05, 0xc5, 0xd9, 0x97, 0x0c, 0x79, 0xc5, 0xd5, 0x69, 0x31, 0x79, 0x92,
	0xa7, 0x67, 0xa2, 0xd3, 0x98, 0xd2, 0xf8, 0xb4, 0xb9, 0x0b, 0xb3, 0xd2, 0x01, 0x54, 0x84, 0x5c,
	0x7b, 0xe7, 0xbd, 0x9d, 0xdd, 0x0f, 0x76, 0x16, 0xbe, 0x80, 0xca, 0x50, 0x6c, 0xde, 0x6f, 0xbe,
	0xdb, 0xb2, 0x9b, 0xef, 0xb6, 0x9a, 0xef, 0x2d, 0x18, 0x08, 0x60, 0xee, 0xfd, 0x76, 0xab, 0xdd,
	0x5a, 0x5b, 0xc8, 0xa0, 0x79, 0x28, 0xb4, 0x1e, 0xb4, 0x9a, 0xed, 0x83, 0xcd, 0x9d, 0x8d, 0x85,
	0xac, 0x78, 0x6c, 0xee, 0x6e, 0xef, 0x6d, 0xb5, 0x0e, 0x5a, 0x6b, 0x0b, 0x33, 0xe6, 0x4f, 0x0d,
	0x78, 0x71, 0x03, 0xf3, 0x91, 0x1a, 0x9e, 0xa4, 0x43, 0x3d, 0x8f, 0x08, 0x9a, 0xff, 0x36, 0xe0,
	0x56, 0x7b, 0xe0, 0x3a, 0x1c, 0xff, 0x5f, 0xd9, 0x85, 0x3e, 0x8c, 0x40, 0xf5, 0xa5, 0xce, 0x5e,
	0xa1, 0x53, 0x68, 0x68, 0xf5, 0x64, 0xfe, 0xc4, 0x80, 0x9b, 0xeb, 0x7e, 0xe0, 0x6e, 0xfb, 0x8c,
	0xf9, 0x81, 0xb7, 0xda, 0x23, 0x47, 0x6c, 0x22, 0x87, 0xdf, 0x87, 0xd2, 0x51, 0x8f, 0x1c, 0x69,
	0x77, 0xc3, 0x85, 0x71, 0x52, 0x7f, 0x8b, 0x02, 0x43, 0xfd, 0x66, 0xe6, 0x77, 0xa0, 0x72, 0xd1,
	0x24, 0xdd, 0x2d, 0x3f, 0x86, 0x1b, 0x7d, 0x45, 0xb7, 0x9f, 0x81, 0x5a, 0xd4, 0x8f, 0x75, 0x84,
	0xda, 0xbf, 0x0b, 0xd7, 0x55, 0x0d, 0x08, 0x62, 0x18, 0x0a, 0xf9, 0xed, 0x40, 0x2e, 0x36, 0x57,
	0xfe, 0x76, 0x20, 0x51, 0xe2, 0x8d, 0x5d, 0x34, 0x07, 0x59, 0x24, 0x25, 0x4b, 0xfe, 0x36, 0x7f,
	0x66, 0xc0, 0xcd, 0x55, 0x87, 0x77, 0xba, 0xb1, 0x15, 0x93, 0x65, 0xa4, 0x0d, 0x79, 0xaa, 0xce,
	0x87, 0x61, 0x49, 0xfd, 0x26, 0x79, 0xc1, 0x71, 0x2b, 0x82, 0x32, 0x7f, 0x94, 0x81, 0xca, 0x45,
	0xbb, 0x74, 0x5a, 0x3c, 0x28, 0x50, 0xfd, 0x3b, 0x7c, 0x49, 0xdc, 0x4c, 0xab, 0xf4, 0x49, 0xa0,
	0xb5, 0xf0, 0x87, 0x15, 0x63, 0x57, 0xbf, 0x6f, 0x40, 0x3e, 0xd2, 0xba, 0x0b, 0xc5, 0x44, 0x11,
	0x4c, 0x99, 0x12, 0x88, 0x4b, 0x2f, 0x31, 0x18, 0x33, 0x4f, 0x1b, 0x8c, 0xe6, 0x9f, 0x0d, 0xb8,
	0xb6, 0x81, 0xb9, 0x58, 0x5f, 0x27, 0x4a, 0xcf, 0x2e, 0x14, 0xaf, 0xfe, 0xa5, 0x08, 0x68, 0xfc,
	0x91, 0xe8, 0x25, 0x28, 0x0c, 0x1c, 0x0f, 0xdb, 0xe2, 0xad, 0x4e, 0x76, 0x86, 0x59, 0x2b, 0x2f,
	0x08, 0xfb, 0xfe, 0xa7, 0xf2, 0x9d, 0x47, 0x32, 0x39, 0x39, 0xc1, 0x81, 0x6e, 0xef, 0xf2, 0xf8,
	0x81, 0x20, 0x98, 0x3f, 0x36, 0xa0, 0x1c, 0x39, 0xa1, 0xa3, 0xba, 0x3f, 0xfa, 0x92, 0x6e, 0x4c,
	0xbb, 0x47, 0x27, 0x51, 0xd0, 0x6b, 0x50, 0x0e, 0xf0, 0x19, 0xb7, 0x13, 0xc6, 0xa8, 0xef, 0x0d,
	0xf3, 0x82, 0xbc, 0x17, 0x19, 0xb4, 0x0d, 0xc5, 0x03, 0x42, 0x7a, 0x6b, 0x98, 0x3b, 0x7e, 0x4f,
	0xbe, 0xcf, 0x09, 0x6d, 0xc9, 0x68, 0xe6, 0x05, 0x41, 0x46, 0xf2, 0x15, 0x28, 0x49, 0xe6, 0x29,
	0xa6, 0x2c, 0xdc, 0x55, 0x0b, 0x56, 0x51, 0xd0, 0x0e, 0x15, 0x49, 0x74, 0xf4, 0xb2, 0xce, 0x4e,
	0x34, 0xda, 0x0f, 0xb5, 0x98, 0xab, 0x74, 0xe8, 0xb2, 0xb9, 0x9b, 0xd6, 0xc1, 0x84, 0x79, 0x4a,
	0x57, 0xc2, 0x56, 0xdd, 0xa5, 0x7d, 0x57, 0xdb, 0x92, 0x57, 0x84, 0x4d, 0x57, 0x8c, 0x5b, 0xa9,
	0xd4, 0x0f, 0x4e, 0x49, 0xc7, 0x09, 0x4f, 0xe9, 0xe1, 0x2c, 0x38, 0x9b, 0x11, 0x63, 0xd3, 0x45,
	0x2b, 0x70, 0xab, 0x43, 0x28, 0xc5, 0x3d, 0x87, 0x63, 0x37, 0x21, 0xc3, 0x84, 0x90, 0x4a, 0xe2,
	0xcd, 0xf8, 0x40, 0x2c, 0xca, 0x36, 0xdd, 0xc6, 0x6f, 0x0c, 0x28, 0xb4, 0x42, 0xa3, 0xd1, 0xcf,
	0x0d, 0xc8, 0xe9, 0x9d, 0x04, 0x7d, 0x6d, 0xe2, 0xad, 0x4d, 0x06, 0xae, 0x7a, 0x3b, 0x94, 0x4b,
	0x7c, 0xa2, 0xad, 0x45, 0x1b, 0x8e, 0xf9, 0xe6, 0xf7, 0xfe, 0xf6, 0xcf, 0xcf, 0x32, 0x75, 0x73,
	0x39, 0xfc, 0x5c, 0xfc, 0x68, 0xe4, 0x12, 0xbc, 0xbd, 0xbc, 0xfc, 0xb8, 0xae, 0xe2, 0xc0, 0x56,
	0x94, 0x2a, 0xbc, 0x62, 0x2c, 0x37, 0x3e, 0xcf, 0x42, 0x51, 0x0d, 0x26, 0xf9, 0x16, 0x80, 0xfe,
	0xa5, 0x4a, 0x71, 0xe4, 0x6b, 0xc4, 0x37, 0xd3, 0x5a, 0x7c, 0xf9, 0x2a, 0x51, 0x9d, 0x6a, 0x42,
	0x9a, 0x1f, 0x4b, 0x87, 0x1e, 0xa2, 0x07, 0x4f, 0x75, 0x48, 0x09, 0xb0, 0xfa, 0xa3, 0x91, 0x99,
	0x5f, 0xeb, 0x3a, 0xac, 0xfb, 0x78, 0x9c, 0x18, 0x7f, 0x86, 0x79, 0x8c, 0xfe, 0x63, 0x00, 0xba,
	0xb8, 0x68, 0xa0, 0xfb, 0x93, 0xf5, 0xe9, 0x67, 0xe7, 0x31, 0x91, 0x1e, 0xfb, 0xd5, 0xe7, 0xe6,
	0xf1, 0xca, 0xe8, 0x02, 0xd3, 0xf8, 0xc5, 0x2c, 0xdc, 0x6a, 0xaa, 0x51, 0x78, 0xdf, 0x75, 0x29,
	0x66, 0x4c, 0xbc, 0x1f, 0xed, 0x73, 0x42, 0xc5, 0x92, 0xf9, 0x17, 0x03, 0x16, 0xc6, 0x37, 0x00,
	0xf4, 0x4e, 0xfa, 0x8f, 0x8e, 0x97, 0xae, 0x33, 0xd5, 0x6f, 0x4d, 0x0f, 0xa0, 0x3a, 0xa3, 0x79,
	0x4f, 0x86, 0xe9, 0x8e, 0xf9, 0xfa, 0xff, 0x08, 0x93, 0x98, 0x26, 0x6c, 0xe5, 0x38, 0x86, 0x58,
	0x31, 0x96, 0xa5, 0x43, 0xe3, 0x63, 0x2e, 0xbd, 0x43, 0x4f, 0xd8, 0x06, 0xd2, 0x3b, 0xf4, 0xa4,
	0x09, 0x3b, 0x81, 0x43, 0x47, 0x31, 0x84, 0x70, 0xe8, 0xef, 0x06, 0xe4, 0xf4, 0xdc, 0x48, 0xdf,
	0x56, 0x46, 0xa7, 0x65, 0xf5, 0xde, 0xc4, 0x72, 0xda, 0xea, 0x8f, 0xa4, 0xd5, 0x87, 0xe8, 0xe0,
	0x69, 0x56, 0xd7, 0x1f, 0x25, 0x26, 0x6d, 0x58, 0xa3, 0x49, 0x52, 0xb2, 0x42, 0x3d, 0xa5, 0x65,
	0xf5, 0x4f, 0x06, 0x2c, 0x77, 0x48, 0x3f, 0xa5, 0x71, 0xab, 0x37, 0x2c, 0x49, 0x8f, 0x3a, 0xee,
	0x1e, 0x25, 0x9c, 0xec, 0x19, 0x0f, 0xdb, 0x5a, 0xde, 0x23, 0x3d, 0x27, 0xf0, 0x6a, 0x84, 0x7a,
	0x75, 0x0f, 0x07, 0xf2, 0x6f, 0x91, 0xba, 0x62, 0x39, 0x03, 0x9f, 0x3d, 0xed, 0xaf, 0xb7, 0xb7,
	0xc6, 0xc8, 0xbf, 0xce, 0x64, 0xad, 0xd6, 0x83, 0xdf, 0x65, 0x6e, 0x6f, 0x28, 0xf4, 0x31, 0xe5,
	0xb5, 0xc3, 0x3b, 0x07, 0x98, 0xf1, 0xa3, 0x39, 0xa9, 0xe7, 0xee, 0x7f, 0x03, 0x00, 0x00, 0xff,
	0xff, 0xf0, 0x8a, 0x2f, 0x43, 0xe1, 0x1b, 0x00, 0x00,
}
