// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/kms/v1/resources.proto

package kms // import "google.golang.org/genproto/googleapis/cloud/kms/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import duration "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] specifies how
// cryptographic operations are performed.
type ProtectionLevel int32

const (
	// Not specified.
	ProtectionLevel_PROTECTION_LEVEL_UNSPECIFIED ProtectionLevel = 0
	// Crypto operations are performed in software.
	ProtectionLevel_SOFTWARE ProtectionLevel = 1
	// Crypto operations are performed in a Hardware Security Module.
	ProtectionLevel_HSM ProtectionLevel = 2
)

var ProtectionLevel_name = map[int32]string{
	0: "PROTECTION_LEVEL_UNSPECIFIED",
	1: "SOFTWARE",
	2: "HSM",
}
var ProtectionLevel_value = map[string]int32{
	"PROTECTION_LEVEL_UNSPECIFIED": 0,
	"SOFTWARE":                     1,
	"HSM":                          2,
}

func (x ProtectionLevel) String() string {
	return proto.EnumName(ProtectionLevel_name, int32(x))
}
func (ProtectionLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_resources_0e872c1c601eedcd, []int{0}
}

// [CryptoKeyPurpose][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose]
// describes the cryptographic capabilities of a
// [CryptoKey][google.cloud.kms.v1.CryptoKey]. A given key can only be used
// for the operations allowed by its purpose.
type CryptoKey_CryptoKeyPurpose int32

const (
	// Not specified.
	CryptoKey_CRYPTO_KEY_PURPOSE_UNSPECIFIED CryptoKey_CryptoKeyPurpose = 0
	// [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
	// with [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] and
	// [Decrypt][google.cloud.kms.v1.KeyManagementService.Decrypt].
	CryptoKey_ENCRYPT_DECRYPT CryptoKey_CryptoKeyPurpose = 1
	// [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
	// with
	// [AsymmetricSign][google.cloud.kms.v1.KeyManagementService.AsymmetricSign]
	// and
	// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
	CryptoKey_ASYMMETRIC_SIGN CryptoKey_CryptoKeyPurpose = 5
	// [CryptoKeys][google.cloud.kms.v1.CryptoKey] with this purpose may be used
	// with
	// [AsymmetricDecrypt][google.cloud.kms.v1.KeyManagementService.AsymmetricDecrypt]
	// and
	// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
	CryptoKey_ASYMMETRIC_DECRYPT CryptoKey_CryptoKeyPurpose = 6
)

var CryptoKey_CryptoKeyPurpose_name = map[int32]string{
	0: "CRYPTO_KEY_PURPOSE_UNSPECIFIED",
	1: "ENCRYPT_DECRYPT",
	5: "ASYMMETRIC_SIGN",
	6: "ASYMMETRIC_DECRYPT",
}
var CryptoKey_CryptoKeyPurpose_value = map[string]int32{
	"CRYPTO_KEY_PURPOSE_UNSPECIFIED": 0,
	"ENCRYPT_DECRYPT":                1,
	"ASYMMETRIC_SIGN":                5,
	"ASYMMETRIC_DECRYPT":             6,
}

func (x CryptoKey_CryptoKeyPurpose) String() string {
	return proto.EnumName(CryptoKey_CryptoKeyPurpose_name, int32(x))
}
func (CryptoKey_CryptoKeyPurpose) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_resources_0e872c1c601eedcd, []int{1, 0}
}

// Attestion formats provided by the HSM.
type KeyOperationAttestation_AttestationFormat int32

const (
	KeyOperationAttestation_ATTESTATION_FORMAT_UNSPECIFIED KeyOperationAttestation_AttestationFormat = 0
	// Cavium HSM attestation compressed with gzip. Note that this format is
	// defined by Cavium and subject to change at any time.
	KeyOperationAttestation_CAVIUM_V1_COMPRESSED KeyOperationAttestation_AttestationFormat = 3
	// Cavium HSM attestation V2 compressed with gzip. This is a new format
	// Introduced in Cavium's version 3.2-08
	KeyOperationAttestation_CAVIUM_V2_COMPRESSED KeyOperationAttestation_AttestationFormat = 4
)

var KeyOperationAttestation_AttestationFormat_name = map[int32]string{
	0: "ATTESTATION_FORMAT_UNSPECIFIED",
	3: "CAVIUM_V1_COMPRESSED",
	4: "CAVIUM_V2_COMPRESSED",
}
var KeyOperationAttestation_AttestationFormat_value = map[string]int32{
	"ATTESTATION_FORMAT_UNSPECIFIED": 0,
	"CAVIUM_V1_COMPRESSED":           3,
	"CAVIUM_V2_COMPRESSED":           4,
}

func (x KeyOperationAttestation_AttestationFormat) String() string {
	return proto.EnumName(KeyOperationAttestation_AttestationFormat_name, int32(x))
}
func (KeyOperationAttestation_AttestationFormat) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_resources_0e872c1c601eedcd, []int{3, 0}
}

// The algorithm of the
// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], indicating what
// parameters must be used for each cryptographic operation.
//
// The
// [GOOGLE_SYMMETRIC_ENCRYPTION][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.GOOGLE_SYMMETRIC_ENCRYPTION]
// algorithm is usable with
// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
//
// Algorithms beginning with "RSA_SIGN_" are usable with
// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
// [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN].
//
// The fields in the name after "RSA_SIGN_" correspond to the following
// parameters: padding algorithm, modulus bit length, and digest algorithm.
//
// For PSS, the salt length used is equal to the length of digest
// algorithm. For example,
// [RSA_SIGN_PSS_2048_SHA256][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm.RSA_SIGN_PSS_2048_SHA256]
// will use PSS with a salt length of 256 bits or 32 bytes.
//
// Algorithms beginning with "RSA_DECRYPT_" are usable with
// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
// [ASYMMETRIC_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_DECRYPT].
//
// The fields in the name after "RSA_DECRYPT_" correspond to the following
// parameters: padding algorithm, modulus bit length, and digest algorithm.
//
// Algorithms beginning with "EC_SIGN_" are usable with
// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose]
// [ASYMMETRIC_SIGN][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ASYMMETRIC_SIGN].
//
// The fields in the name after "EC_SIGN_" correspond to the following
// parameters: elliptic curve, digest algorithm.
type CryptoKeyVersion_CryptoKeyVersionAlgorithm int32

const (
	// Not specified.
	CryptoKeyVersion_CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED CryptoKeyVersion_CryptoKeyVersionAlgorithm = 0
	// Creates symmetric encryption keys.
	CryptoKeyVersion_GOOGLE_SYMMETRIC_ENCRYPTION CryptoKeyVersion_CryptoKeyVersionAlgorithm = 1
	// RSASSA-PSS 2048 bit key with a SHA256 digest.
	CryptoKeyVersion_RSA_SIGN_PSS_2048_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 2
	// RSASSA-PSS 3072 bit key with a SHA256 digest.
	CryptoKeyVersion_RSA_SIGN_PSS_3072_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 3
	// RSASSA-PSS 4096 bit key with a SHA256 digest.
	CryptoKeyVersion_RSA_SIGN_PSS_4096_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 4
	// RSASSA-PKCS1-v1_5 with a 2048 bit key and a SHA256 digest.
	CryptoKeyVersion_RSA_SIGN_PKCS1_2048_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 5
	// RSASSA-PKCS1-v1_5 with a 3072 bit key and a SHA256 digest.
	CryptoKeyVersion_RSA_SIGN_PKCS1_3072_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 6
	// RSASSA-PKCS1-v1_5 with a 4096 bit key and a SHA256 digest.
	CryptoKeyVersion_RSA_SIGN_PKCS1_4096_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 7
	// RSAES-OAEP 2048 bit key with a SHA256 digest.
	CryptoKeyVersion_RSA_DECRYPT_OAEP_2048_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 8
	// RSAES-OAEP 3072 bit key with a SHA256 digest.
	CryptoKeyVersion_RSA_DECRYPT_OAEP_3072_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 9
	// RSAES-OAEP 4096 bit key with a SHA256 digest.
	CryptoKeyVersion_RSA_DECRYPT_OAEP_4096_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 10
	// ECDSA on the NIST P-256 curve with a SHA256 digest.
	CryptoKeyVersion_EC_SIGN_P256_SHA256 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 12
	// ECDSA on the NIST P-384 curve with a SHA384 digest.
	CryptoKeyVersion_EC_SIGN_P384_SHA384 CryptoKeyVersion_CryptoKeyVersionAlgorithm = 13
)

var CryptoKeyVersion_CryptoKeyVersionAlgorithm_name = map[int32]string{
	0:  "CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED",
	1:  "GOOGLE_SYMMETRIC_ENCRYPTION",
	2:  "RSA_SIGN_PSS_2048_SHA256",
	3:  "RSA_SIGN_PSS_3072_SHA256",
	4:  "RSA_SIGN_PSS_4096_SHA256",
	5:  "RSA_SIGN_PKCS1_2048_SHA256",
	6:  "RSA_SIGN_PKCS1_3072_SHA256",
	7:  "RSA_SIGN_PKCS1_4096_SHA256",
	8:  "RSA_DECRYPT_OAEP_2048_SHA256",
	9:  "RSA_DECRYPT_OAEP_3072_SHA256",
	10: "RSA_DECRYPT_OAEP_4096_SHA256",
	12: "EC_SIGN_P256_SHA256",
	13: "EC_SIGN_P384_SHA384",
}
var CryptoKeyVersion_CryptoKeyVersionAlgorithm_value = map[string]int32{
	"CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED": 0,
	"GOOGLE_SYMMETRIC_ENCRYPTION":              1,
	"RSA_SIGN_PSS_2048_SHA256":                 2,
	"RSA_SIGN_PSS_3072_SHA256":                 3,
	"RSA_SIGN_PSS_4096_SHA256":                 4,
	"RSA_SIGN_PKCS1_2048_SHA256":               5,
	"RSA_SIGN_PKCS1_3072_SHA256":               6,
	"RSA_SIGN_PKCS1_4096_SHA256":               7,
	"RSA_DECRYPT_OAEP_2048_SHA256":             8,
	"RSA_DECRYPT_OAEP_3072_SHA256":             9,
	"RSA_DECRYPT_OAEP_4096_SHA256":             10,
	"EC_SIGN_P256_SHA256":                      12,
	"EC_SIGN_P384_SHA384":                      13,
}

func (x CryptoKeyVersion_CryptoKeyVersionAlgorithm) String() string {
	return proto.EnumName(CryptoKeyVersion_CryptoKeyVersionAlgorithm_name, int32(x))
}
func (CryptoKeyVersion_CryptoKeyVersionAlgorithm) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_resources_0e872c1c601eedcd, []int{4, 0}
}

// The state of a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion],
// indicating if it can be used.
type CryptoKeyVersion_CryptoKeyVersionState int32

const (
	// Not specified.
	CryptoKeyVersion_CRYPTO_KEY_VERSION_STATE_UNSPECIFIED CryptoKeyVersion_CryptoKeyVersionState = 0
	// This version is still being generated. It may not be used, enabled,
	// disabled, or destroyed yet. Cloud KMS will automatically mark this
	// version
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
	// as soon as the version is ready.
	CryptoKeyVersion_PENDING_GENERATION CryptoKeyVersion_CryptoKeyVersionState = 5
	// This version may be used for cryptographic operations.
	CryptoKeyVersion_ENABLED CryptoKeyVersion_CryptoKeyVersionState = 1
	// This version may not be used, but the key material is still available,
	// and the version can be placed back into the
	// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
	// state.
	CryptoKeyVersion_DISABLED CryptoKeyVersion_CryptoKeyVersionState = 2
	// This version is destroyed, and the key material is no longer stored.
	// A version may not leave this state once entered.
	CryptoKeyVersion_DESTROYED CryptoKeyVersion_CryptoKeyVersionState = 3
	// This version is scheduled for destruction, and will be destroyed soon.
	// Call
	// [RestoreCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.RestoreCryptoKeyVersion]
	// to put it back into the
	// [DISABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DISABLED]
	// state.
	CryptoKeyVersion_DESTROY_SCHEDULED CryptoKeyVersion_CryptoKeyVersionState = 4
)

var CryptoKeyVersion_CryptoKeyVersionState_name = map[int32]string{
	0: "CRYPTO_KEY_VERSION_STATE_UNSPECIFIED",
	5: "PENDING_GENERATION",
	1: "ENABLED",
	2: "DISABLED",
	3: "DESTROYED",
	4: "DESTROY_SCHEDULED",
}
var CryptoKeyVersion_CryptoKeyVersionState_value = map[string]int32{
	"CRYPTO_KEY_VERSION_STATE_UNSPECIFIED": 0,
	"PENDING_GENERATION":                   5,
	"ENABLED":                              1,
	"DISABLED":                             2,
	"DESTROYED":                            3,
	"DESTROY_SCHEDULED":                    4,
}

func (x CryptoKeyVersion_CryptoKeyVersionState) String() string {
	return proto.EnumName(CryptoKeyVersion_CryptoKeyVersionState_name, int32(x))
}
func (CryptoKeyVersion_CryptoKeyVersionState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_resources_0e872c1c601eedcd, []int{4, 1}
}

// A view for [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]s.
// Controls the level of detail returned for
// [CryptoKeyVersions][google.cloud.kms.v1.CryptoKeyVersion] in
// [KeyManagementService.ListCryptoKeyVersions][google.cloud.kms.v1.KeyManagementService.ListCryptoKeyVersions]
// and
// [KeyManagementService.ListCryptoKeys][google.cloud.kms.v1.KeyManagementService.ListCryptoKeys].
type CryptoKeyVersion_CryptoKeyVersionView int32

const (
	// Default view for each
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Does not
	// include the
	// [attestation][google.cloud.kms.v1.CryptoKeyVersion.attestation] field.
	CryptoKeyVersion_CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED CryptoKeyVersion_CryptoKeyVersionView = 0
	// Provides all fields in each
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], including the
	// [attestation][google.cloud.kms.v1.CryptoKeyVersion.attestation].
	CryptoKeyVersion_FULL CryptoKeyVersion_CryptoKeyVersionView = 1
)

var CryptoKeyVersion_CryptoKeyVersionView_name = map[int32]string{
	0: "CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED",
	1: "FULL",
}
var CryptoKeyVersion_CryptoKeyVersionView_value = map[string]int32{
	"CRYPTO_KEY_VERSION_VIEW_UNSPECIFIED": 0,
	"FULL":                                1,
}

func (x CryptoKeyVersion_CryptoKeyVersionView) String() string {
	return proto.EnumName(CryptoKeyVersion_CryptoKeyVersionView_name, int32(x))
}
func (CryptoKeyVersion_CryptoKeyVersionView) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_resources_0e872c1c601eedcd, []int{4, 2}
}

// A [KeyRing][google.cloud.kms.v1.KeyRing] is a toplevel logical grouping of
// [CryptoKeys][google.cloud.kms.v1.CryptoKey].
type KeyRing struct {
	// Output only. The resource name for the
	// [KeyRing][google.cloud.kms.v1.KeyRing] in the format
	// `projects/*/locations/*/keyRings/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time at which this [KeyRing][google.cloud.kms.v1.KeyRing]
	// was created.
	CreateTime           *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *KeyRing) Reset()         { *m = KeyRing{} }
func (m *KeyRing) String() string { return proto.CompactTextString(m) }
func (*KeyRing) ProtoMessage()    {}
func (*KeyRing) Descriptor() ([]byte, []int) {
	return fileDescriptor_resources_0e872c1c601eedcd, []int{0}
}
func (m *KeyRing) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeyRing.Unmarshal(m, b)
}
func (m *KeyRing) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeyRing.Marshal(b, m, deterministic)
}
func (dst *KeyRing) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyRing.Merge(dst, src)
}
func (m *KeyRing) XXX_Size() int {
	return xxx_messageInfo_KeyRing.Size(m)
}
func (m *KeyRing) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyRing.DiscardUnknown(m)
}

var xxx_messageInfo_KeyRing proto.InternalMessageInfo

func (m *KeyRing) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *KeyRing) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

// A [CryptoKey][google.cloud.kms.v1.CryptoKey] represents a logical key that
// can be used for cryptographic operations.
//
// A [CryptoKey][google.cloud.kms.v1.CryptoKey] is made up of one or more
// [versions][google.cloud.kms.v1.CryptoKeyVersion], which represent the actual
// key material used in cryptographic operations.
type CryptoKey struct {
	// Output only. The resource name for this
	// [CryptoKey][google.cloud.kms.v1.CryptoKey] in the format
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. A copy of the "primary"
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] that will be used
	// by [Encrypt][google.cloud.kms.v1.KeyManagementService.Encrypt] when this
	// [CryptoKey][google.cloud.kms.v1.CryptoKey] is given in
	// [EncryptRequest.name][google.cloud.kms.v1.EncryptRequest.name].
	//
	// The [CryptoKey][google.cloud.kms.v1.CryptoKey]'s primary version can be
	// updated via
	// [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion].
	//
	// All keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
	// have a primary. For other keys, this field will be omitted.
	Primary *CryptoKeyVersion `protobuf:"bytes,2,opt,name=primary,proto3" json:"primary,omitempty"`
	// The immutable purpose of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
	Purpose CryptoKey_CryptoKeyPurpose `protobuf:"varint,3,opt,name=purpose,proto3,enum=google.cloud.kms.v1.CryptoKey_CryptoKeyPurpose" json:"purpose,omitempty"`
	// Output only. The time at which this
	// [CryptoKey][google.cloud.kms.v1.CryptoKey] was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// At [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time],
	// the Key Management Service will automatically:
	//
	// 1. Create a new version of this [CryptoKey][google.cloud.kms.v1.CryptoKey].
	// 2. Mark the new version as primary.
	//
	// Key rotations performed manually via
	// [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
	// and
	// [UpdateCryptoKeyPrimaryVersion][google.cloud.kms.v1.KeyManagementService.UpdateCryptoKeyPrimaryVersion]
	// do not affect
	// [next_rotation_time][google.cloud.kms.v1.CryptoKey.next_rotation_time].
	//
	// Keys with [purpose][google.cloud.kms.v1.CryptoKey.purpose]
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT]
	// support automatic rotation. For other keys, this field must be omitted.
	NextRotationTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=next_rotation_time,json=nextRotationTime,proto3" json:"next_rotation_time,omitempty"`
	// Controls the rate of automatic rotation.
	//
	// Types that are valid to be assigned to RotationSchedule:
	//	*CryptoKey_RotationPeriod
	RotationSchedule isCryptoKey_RotationSchedule `protobuf_oneof:"rotation_schedule"`
	// A template describing settings for new
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] instances. The
	// properties of new [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// instances created by either
	// [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
	// or auto-rotation are controlled by this template.
	VersionTemplate *CryptoKeyVersionTemplate `protobuf:"bytes,11,opt,name=version_template,json=versionTemplate,proto3" json:"version_template,omitempty"`
	// Labels with user-defined metadata. For more information, see
	// [Labeling Keys](/kms/docs/labeling-keys).
	Labels               map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CryptoKey) Reset()         { *m = CryptoKey{} }
func (m *CryptoKey) String() string { return proto.CompactTextString(m) }
func (*CryptoKey) ProtoMessage()    {}
func (*CryptoKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_resources_0e872c1c601eedcd, []int{1}
}
func (m *CryptoKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CryptoKey.Unmarshal(m, b)
}
func (m *CryptoKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CryptoKey.Marshal(b, m, deterministic)
}
func (dst *CryptoKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CryptoKey.Merge(dst, src)
}
func (m *CryptoKey) XXX_Size() int {
	return xxx_messageInfo_CryptoKey.Size(m)
}
func (m *CryptoKey) XXX_DiscardUnknown() {
	xxx_messageInfo_CryptoKey.DiscardUnknown(m)
}

var xxx_messageInfo_CryptoKey proto.InternalMessageInfo

func (m *CryptoKey) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CryptoKey) GetPrimary() *CryptoKeyVersion {
	if m != nil {
		return m.Primary
	}
	return nil
}

func (m *CryptoKey) GetPurpose() CryptoKey_CryptoKeyPurpose {
	if m != nil {
		return m.Purpose
	}
	return CryptoKey_CRYPTO_KEY_PURPOSE_UNSPECIFIED
}

func (m *CryptoKey) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *CryptoKey) GetNextRotationTime() *timestamp.Timestamp {
	if m != nil {
		return m.NextRotationTime
	}
	return nil
}

type isCryptoKey_RotationSchedule interface {
	isCryptoKey_RotationSchedule()
}

type CryptoKey_RotationPeriod struct {
	RotationPeriod *duration.Duration `protobuf:"bytes,8,opt,name=rotation_period,json=rotationPeriod,proto3,oneof"`
}

func (*CryptoKey_RotationPeriod) isCryptoKey_RotationSchedule() {}

func (m *CryptoKey) GetRotationSchedule() isCryptoKey_RotationSchedule {
	if m != nil {
		return m.RotationSchedule
	}
	return nil
}

func (m *CryptoKey) GetRotationPeriod() *duration.Duration {
	if x, ok := m.GetRotationSchedule().(*CryptoKey_RotationPeriod); ok {
		return x.RotationPeriod
	}
	return nil
}

func (m *CryptoKey) GetVersionTemplate() *CryptoKeyVersionTemplate {
	if m != nil {
		return m.VersionTemplate
	}
	return nil
}

func (m *CryptoKey) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CryptoKey) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CryptoKey_OneofMarshaler, _CryptoKey_OneofUnmarshaler, _CryptoKey_OneofSizer, []interface{}{
		(*CryptoKey_RotationPeriod)(nil),
	}
}

func _CryptoKey_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CryptoKey)
	// rotation_schedule
	switch x := m.RotationSchedule.(type) {
	case *CryptoKey_RotationPeriod:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RotationPeriod); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CryptoKey.RotationSchedule has unexpected type %T", x)
	}
	return nil
}

func _CryptoKey_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CryptoKey)
	switch tag {
	case 8: // rotation_schedule.rotation_period
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(duration.Duration)
		err := b.DecodeMessage(msg)
		m.RotationSchedule = &CryptoKey_RotationPeriod{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CryptoKey_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CryptoKey)
	// rotation_schedule
	switch x := m.RotationSchedule.(type) {
	case *CryptoKey_RotationPeriod:
		s := proto.Size(x.RotationPeriod)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A [CryptoKeyVersionTemplate][google.cloud.kms.v1.CryptoKeyVersionTemplate]
// specifies the properties to use when creating a new
// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion], either manually
// with
// [CreateCryptoKeyVersion][google.cloud.kms.v1.KeyManagementService.CreateCryptoKeyVersion]
// or automatically as a result of auto-rotation.
type CryptoKeyVersionTemplate struct {
	// [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel] to use when creating
	// a [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] based on this
	// template. Immutable. Defaults to
	// [SOFTWARE][google.cloud.kms.v1.ProtectionLevel.SOFTWARE].
	ProtectionLevel ProtectionLevel `protobuf:"varint,1,opt,name=protection_level,json=protectionLevel,proto3,enum=google.cloud.kms.v1.ProtectionLevel" json:"protection_level,omitempty"`
	// Required.
	// [Algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
	// to use when creating a
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] based on this
	// template.
	//
	// For backwards compatibility, GOOGLE_SYMMETRIC_ENCRYPTION is implied if both
	// this field is omitted and
	// [CryptoKey.purpose][google.cloud.kms.v1.CryptoKey.purpose] is
	// [ENCRYPT_DECRYPT][google.cloud.kms.v1.CryptoKey.CryptoKeyPurpose.ENCRYPT_DECRYPT].
	Algorithm            CryptoKeyVersion_CryptoKeyVersionAlgorithm `protobuf:"varint,3,opt,name=algorithm,proto3,enum=google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionAlgorithm" json:"algorithm,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *CryptoKeyVersionTemplate) Reset()         { *m = CryptoKeyVersionTemplate{} }
func (m *CryptoKeyVersionTemplate) String() string { return proto.CompactTextString(m) }
func (*CryptoKeyVersionTemplate) ProtoMessage()    {}
func (*CryptoKeyVersionTemplate) Descriptor() ([]byte, []int) {
	return fileDescriptor_resources_0e872c1c601eedcd, []int{2}
}
func (m *CryptoKeyVersionTemplate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CryptoKeyVersionTemplate.Unmarshal(m, b)
}
func (m *CryptoKeyVersionTemplate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CryptoKeyVersionTemplate.Marshal(b, m, deterministic)
}
func (dst *CryptoKeyVersionTemplate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CryptoKeyVersionTemplate.Merge(dst, src)
}
func (m *CryptoKeyVersionTemplate) XXX_Size() int {
	return xxx_messageInfo_CryptoKeyVersionTemplate.Size(m)
}
func (m *CryptoKeyVersionTemplate) XXX_DiscardUnknown() {
	xxx_messageInfo_CryptoKeyVersionTemplate.DiscardUnknown(m)
}

var xxx_messageInfo_CryptoKeyVersionTemplate proto.InternalMessageInfo

func (m *CryptoKeyVersionTemplate) GetProtectionLevel() ProtectionLevel {
	if m != nil {
		return m.ProtectionLevel
	}
	return ProtectionLevel_PROTECTION_LEVEL_UNSPECIFIED
}

func (m *CryptoKeyVersionTemplate) GetAlgorithm() CryptoKeyVersion_CryptoKeyVersionAlgorithm {
	if m != nil {
		return m.Algorithm
	}
	return CryptoKeyVersion_CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
}

// Contains an HSM-generated attestation about a key operation.
type KeyOperationAttestation struct {
	// Output only. The format of the attestation data.
	Format KeyOperationAttestation_AttestationFormat `protobuf:"varint,4,opt,name=format,proto3,enum=google.cloud.kms.v1.KeyOperationAttestation_AttestationFormat" json:"format,omitempty"`
	// Output only. The attestation data provided by the HSM when the key
	// operation was performed.
	Content              []byte   `protobuf:"bytes,5,opt,name=content,proto3" json:"content,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KeyOperationAttestation) Reset()         { *m = KeyOperationAttestation{} }
func (m *KeyOperationAttestation) String() string { return proto.CompactTextString(m) }
func (*KeyOperationAttestation) ProtoMessage()    {}
func (*KeyOperationAttestation) Descriptor() ([]byte, []int) {
	return fileDescriptor_resources_0e872c1c601eedcd, []int{3}
}
func (m *KeyOperationAttestation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KeyOperationAttestation.Unmarshal(m, b)
}
func (m *KeyOperationAttestation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KeyOperationAttestation.Marshal(b, m, deterministic)
}
func (dst *KeyOperationAttestation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KeyOperationAttestation.Merge(dst, src)
}
func (m *KeyOperationAttestation) XXX_Size() int {
	return xxx_messageInfo_KeyOperationAttestation.Size(m)
}
func (m *KeyOperationAttestation) XXX_DiscardUnknown() {
	xxx_messageInfo_KeyOperationAttestation.DiscardUnknown(m)
}

var xxx_messageInfo_KeyOperationAttestation proto.InternalMessageInfo

func (m *KeyOperationAttestation) GetFormat() KeyOperationAttestation_AttestationFormat {
	if m != nil {
		return m.Format
	}
	return KeyOperationAttestation_ATTESTATION_FORMAT_UNSPECIFIED
}

func (m *KeyOperationAttestation) GetContent() []byte {
	if m != nil {
		return m.Content
	}
	return nil
}

// A [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] represents an
// individual cryptographic key, and the associated key material.
//
// An
// [ENABLED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.ENABLED]
// version can be used for cryptographic operations.
//
// For security reasons, the raw cryptographic key material represented by a
// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] can never be viewed
// or exported. It can only be used to encrypt, decrypt, or sign data when an
// authorized user or application invokes Cloud KMS.
type CryptoKeyVersion struct {
	// Output only. The resource name for this
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] in the format
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The current state of the
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	State CryptoKeyVersion_CryptoKeyVersionState `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionState" json:"state,omitempty"`
	// Output only. The [ProtectionLevel][google.cloud.kms.v1.ProtectionLevel]
	// describing how crypto operations are performed with this
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion].
	ProtectionLevel ProtectionLevel `protobuf:"varint,7,opt,name=protection_level,json=protectionLevel,proto3,enum=google.cloud.kms.v1.ProtectionLevel" json:"protection_level,omitempty"`
	// Output only. The
	// [CryptoKeyVersionAlgorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
	// that this [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]
	// supports.
	Algorithm CryptoKeyVersion_CryptoKeyVersionAlgorithm `protobuf:"varint,10,opt,name=algorithm,proto3,enum=google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionAlgorithm" json:"algorithm,omitempty"`
	// Output only. Statement that was generated and signed by the HSM at key
	// creation time. Use this statement to verify attributes of the key as stored
	// on the HSM, independently of Google. Only provided for key versions with
	// [protection_level][google.cloud.kms.v1.CryptoKeyVersion.protection_level]
	// [HSM][google.cloud.kms.v1.ProtectionLevel.HSM].
	Attestation *KeyOperationAttestation `protobuf:"bytes,8,opt,name=attestation,proto3" json:"attestation,omitempty"`
	// Output only. The time at which this
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion] was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time this
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material was
	// generated.
	GenerateTime *timestamp.Timestamp `protobuf:"bytes,11,opt,name=generate_time,json=generateTime,proto3" json:"generate_time,omitempty"`
	// Output only. The time this
	// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]'s key material is
	// scheduled for destruction. Only present if
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
	// [DESTROY_SCHEDULED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROY_SCHEDULED].
	DestroyTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=destroy_time,json=destroyTime,proto3" json:"destroy_time,omitempty"`
	// Output only. The time this CryptoKeyVersion's key material was
	// destroyed. Only present if
	// [state][google.cloud.kms.v1.CryptoKeyVersion.state] is
	// [DESTROYED][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionState.DESTROYED].
	DestroyEventTime     *timestamp.Timestamp `protobuf:"bytes,6,opt,name=destroy_event_time,json=destroyEventTime,proto3" json:"destroy_event_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CryptoKeyVersion) Reset()         { *m = CryptoKeyVersion{} }
func (m *CryptoKeyVersion) String() string { return proto.CompactTextString(m) }
func (*CryptoKeyVersion) ProtoMessage()    {}
func (*CryptoKeyVersion) Descriptor() ([]byte, []int) {
	return fileDescriptor_resources_0e872c1c601eedcd, []int{4}
}
func (m *CryptoKeyVersion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CryptoKeyVersion.Unmarshal(m, b)
}
func (m *CryptoKeyVersion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CryptoKeyVersion.Marshal(b, m, deterministic)
}
func (dst *CryptoKeyVersion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CryptoKeyVersion.Merge(dst, src)
}
func (m *CryptoKeyVersion) XXX_Size() int {
	return xxx_messageInfo_CryptoKeyVersion.Size(m)
}
func (m *CryptoKeyVersion) XXX_DiscardUnknown() {
	xxx_messageInfo_CryptoKeyVersion.DiscardUnknown(m)
}

var xxx_messageInfo_CryptoKeyVersion proto.InternalMessageInfo

func (m *CryptoKeyVersion) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CryptoKeyVersion) GetState() CryptoKeyVersion_CryptoKeyVersionState {
	if m != nil {
		return m.State
	}
	return CryptoKeyVersion_CRYPTO_KEY_VERSION_STATE_UNSPECIFIED
}

func (m *CryptoKeyVersion) GetProtectionLevel() ProtectionLevel {
	if m != nil {
		return m.ProtectionLevel
	}
	return ProtectionLevel_PROTECTION_LEVEL_UNSPECIFIED
}

func (m *CryptoKeyVersion) GetAlgorithm() CryptoKeyVersion_CryptoKeyVersionAlgorithm {
	if m != nil {
		return m.Algorithm
	}
	return CryptoKeyVersion_CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
}

func (m *CryptoKeyVersion) GetAttestation() *KeyOperationAttestation {
	if m != nil {
		return m.Attestation
	}
	return nil
}

func (m *CryptoKeyVersion) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *CryptoKeyVersion) GetGenerateTime() *timestamp.Timestamp {
	if m != nil {
		return m.GenerateTime
	}
	return nil
}

func (m *CryptoKeyVersion) GetDestroyTime() *timestamp.Timestamp {
	if m != nil {
		return m.DestroyTime
	}
	return nil
}

func (m *CryptoKeyVersion) GetDestroyEventTime() *timestamp.Timestamp {
	if m != nil {
		return m.DestroyEventTime
	}
	return nil
}

// The public key for a given
// [CryptoKeyVersion][google.cloud.kms.v1.CryptoKeyVersion]. Obtained via
// [GetPublicKey][google.cloud.kms.v1.KeyManagementService.GetPublicKey].
type PublicKey struct {
	// The public key, encoded in PEM format. For more information, see the
	// [RFC 7468](https://tools.ietf.org/html/rfc7468) sections for
	// [General Considerations](https://tools.ietf.org/html/rfc7468#section-2) and
	// [Textual Encoding of Subject Public Key Info]
	// (https://tools.ietf.org/html/rfc7468#section-13).
	Pem string `protobuf:"bytes,1,opt,name=pem,proto3" json:"pem,omitempty"`
	// The
	// [Algorithm][google.cloud.kms.v1.CryptoKeyVersion.CryptoKeyVersionAlgorithm]
	// associated with this key.
	Algorithm            CryptoKeyVersion_CryptoKeyVersionAlgorithm `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionAlgorithm" json:"algorithm,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *PublicKey) Reset()         { *m = PublicKey{} }
func (m *PublicKey) String() string { return proto.CompactTextString(m) }
func (*PublicKey) ProtoMessage()    {}
func (*PublicKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_resources_0e872c1c601eedcd, []int{5}
}
func (m *PublicKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PublicKey.Unmarshal(m, b)
}
func (m *PublicKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PublicKey.Marshal(b, m, deterministic)
}
func (dst *PublicKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PublicKey.Merge(dst, src)
}
func (m *PublicKey) XXX_Size() int {
	return xxx_messageInfo_PublicKey.Size(m)
}
func (m *PublicKey) XXX_DiscardUnknown() {
	xxx_messageInfo_PublicKey.DiscardUnknown(m)
}

var xxx_messageInfo_PublicKey proto.InternalMessageInfo

func (m *PublicKey) GetPem() string {
	if m != nil {
		return m.Pem
	}
	return ""
}

func (m *PublicKey) GetAlgorithm() CryptoKeyVersion_CryptoKeyVersionAlgorithm {
	if m != nil {
		return m.Algorithm
	}
	return CryptoKeyVersion_CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED
}

func init() {
	proto.RegisterType((*KeyRing)(nil), "google.cloud.kms.v1.KeyRing")
	proto.RegisterType((*CryptoKey)(nil), "google.cloud.kms.v1.CryptoKey")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.kms.v1.CryptoKey.LabelsEntry")
	proto.RegisterType((*CryptoKeyVersionTemplate)(nil), "google.cloud.kms.v1.CryptoKeyVersionTemplate")
	proto.RegisterType((*KeyOperationAttestation)(nil), "google.cloud.kms.v1.KeyOperationAttestation")
	proto.RegisterType((*CryptoKeyVersion)(nil), "google.cloud.kms.v1.CryptoKeyVersion")
	proto.RegisterType((*PublicKey)(nil), "google.cloud.kms.v1.PublicKey")
	proto.RegisterEnum("google.cloud.kms.v1.ProtectionLevel", ProtectionLevel_name, ProtectionLevel_value)
	proto.RegisterEnum("google.cloud.kms.v1.CryptoKey_CryptoKeyPurpose", CryptoKey_CryptoKeyPurpose_name, CryptoKey_CryptoKeyPurpose_value)
	proto.RegisterEnum("google.cloud.kms.v1.KeyOperationAttestation_AttestationFormat", KeyOperationAttestation_AttestationFormat_name, KeyOperationAttestation_AttestationFormat_value)
	proto.RegisterEnum("google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionAlgorithm", CryptoKeyVersion_CryptoKeyVersionAlgorithm_name, CryptoKeyVersion_CryptoKeyVersionAlgorithm_value)
	proto.RegisterEnum("google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionState", CryptoKeyVersion_CryptoKeyVersionState_name, CryptoKeyVersion_CryptoKeyVersionState_value)
	proto.RegisterEnum("google.cloud.kms.v1.CryptoKeyVersion_CryptoKeyVersionView", CryptoKeyVersion_CryptoKeyVersionView_name, CryptoKeyVersion_CryptoKeyVersionView_value)
}

func init() {
	proto.RegisterFile("google/cloud/kms/v1/resources.proto", fileDescriptor_resources_0e872c1c601eedcd)
}

var fileDescriptor_resources_0e872c1c601eedcd = []byte{
	// 1203 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0x5d, 0x6e, 0xdb, 0x46,
	0x17, 0x0d, 0x25, 0xcb, 0xb2, 0xae, 0x9c, 0x98, 0x1e, 0xe7, 0x47, 0xf1, 0x17, 0x24, 0x86, 0x92,
	0x0f, 0x35, 0x82, 0x54, 0x8a, 0x65, 0x27, 0x75, 0x1a, 0xb4, 0x01, 0x2d, 0x8d, 0x65, 0x56, 0x3f,
	0x64, 0x87, 0xb4, 0x52, 0x07, 0x29, 0x08, 0x5a, 0x9e, 0x28, 0x82, 0xc5, 0x1f, 0x90, 0x94, 0x1a,
	0x01, 0xdd, 0x46, 0x5f, 0xba, 0x81, 0x02, 0x5d, 0x43, 0x57, 0x90, 0x55, 0x74, 0x19, 0x79, 0x2c,
	0x38, 0x1c, 0xda, 0x94, 0xcc, 0xd4, 0x49, 0x91, 0x27, 0xcd, 0xdc, 0x73, 0xcf, 0x99, 0xd1, 0xbd,
	0x97, 0x87, 0x84, 0xfb, 0x03, 0xc7, 0x19, 0x8c, 0x68, 0xb5, 0x3f, 0x72, 0xc6, 0x27, 0xd5, 0x53,
	0xcb, 0xaf, 0x4e, 0xb6, 0xaa, 0x1e, 0xf5, 0x9d, 0xb1, 0xd7, 0xa7, 0x7e, 0xc5, 0xf5, 0x9c, 0xc0,
	0x41, 0x6b, 0x51, 0x52, 0x85, 0x25, 0x55, 0x4e, 0x2d, 0xbf, 0x32, 0xd9, 0x5a, 0xbf, 0xc3, 0x99,
	0xa6, 0x3b, 0xac, 0x9a, 0xb6, 0xed, 0x04, 0x66, 0x30, 0x74, 0x6c, 0x4e, 0x59, 0xbf, 0xcb, 0x51,
	0xb6, 0x3b, 0x1e, 0xbf, 0xa9, 0x9e, 0x8c, 0x3d, 0x96, 0xc0, 0xf1, 0x7b, 0xf3, 0x78, 0x30, 0xb4,
	0xa8, 0x1f, 0x98, 0x96, 0x1b, 0x25, 0x94, 0x5f, 0x41, 0xbe, 0x45, 0xa7, 0x64, 0x68, 0x0f, 0x10,
	0x82, 0x05, 0xdb, 0xb4, 0x68, 0x49, 0xd8, 0x10, 0x36, 0x0b, 0x84, 0xad, 0xd1, 0x73, 0x28, 0xf6,
	0x3d, 0x6a, 0x06, 0xd4, 0x08, 0x89, 0xa5, 0xcc, 0x86, 0xb0, 0x59, 0xac, 0xad, 0x57, 0xf8, 0x45,
	0x63, 0xd5, 0x8a, 0x1e, 0xab, 0x12, 0x88, 0xd2, 0xc3, 0x40, 0xf9, 0xef, 0x1c, 0x14, 0xea, 0xde,
	0xd4, 0x0d, 0x9c, 0x16, 0x9d, 0xa6, 0xca, 0xbf, 0x80, 0xbc, 0xeb, 0x0d, 0x2d, 0xd3, 0x9b, 0x72,
	0xe9, 0xff, 0x57, 0x52, 0x6a, 0x50, 0x39, 0x13, 0xe9, 0x51, 0xcf, 0x1f, 0x3a, 0x36, 0x89, 0x59,
	0x48, 0x86, 0xbc, 0x3b, 0xf6, 0x5c, 0xc7, 0xa7, 0xa5, 0xec, 0x86, 0xb0, 0x79, 0xad, 0x56, 0xfd,
	0x77, 0x81, 0xf3, 0x95, 0x1a, 0xd1, 0x48, 0xcc, 0x9f, 0xff, 0xab, 0xb9, 0xcf, 0xf9, 0xab, 0xe8,
	0x00, 0x90, 0x4d, 0xdf, 0x05, 0x86, 0xc7, 0xfb, 0x13, 0x69, 0xe4, 0x2f, 0xd5, 0x10, 0x43, 0x16,
	0xe1, 0x24, 0xa6, 0xd4, 0x80, 0x95, 0x33, 0x11, 0x97, 0x7a, 0x43, 0xe7, 0xa4, 0xb4, 0xc4, 0x64,
	0x6e, 0x5f, 0x90, 0x69, 0xf0, 0x5e, 0x1f, 0x5c, 0x21, 0xd7, 0x62, 0x8e, 0xca, 0x28, 0xe8, 0x27,
	0x10, 0x27, 0x51, 0xad, 0x8c, 0x80, 0x5a, 0xee, 0xc8, 0x0c, 0x68, 0xa9, 0xc8, 0x64, 0xbe, 0xfe,
	0xa4, 0x0a, 0xeb, 0x9c, 0x44, 0x56, 0x26, 0xb3, 0x01, 0xb4, 0x07, 0x8b, 0x23, 0xf3, 0x98, 0x8e,
	0xfc, 0x12, 0x6c, 0x64, 0x37, 0x8b, 0xb5, 0x87, 0x97, 0x14, 0xbc, 0xcd, 0x92, 0xb1, 0x1d, 0x78,
	0x53, 0xc2, 0x99, 0xeb, 0xcf, 0xa0, 0x98, 0x08, 0x23, 0x11, 0xb2, 0xa7, 0x74, 0xca, 0x07, 0x23,
	0x5c, 0xa2, 0xeb, 0x90, 0x9b, 0x98, 0xa3, 0x71, 0x34, 0x70, 0x05, 0x12, 0x6d, 0xbe, 0xcd, 0xec,
	0x0a, 0xe5, 0x77, 0x20, 0xce, 0xb7, 0x10, 0x95, 0xe1, 0x6e, 0x9d, 0x1c, 0xa9, 0xba, 0x62, 0xb4,
	0xf0, 0x91, 0xa1, 0x1e, 0x12, 0x55, 0xd1, 0xb0, 0x71, 0xd8, 0xd5, 0x54, 0x5c, 0x97, 0xf7, 0x65,
	0xdc, 0x10, 0xaf, 0xa0, 0x35, 0x58, 0xc1, 0x5d, 0x96, 0x65, 0x34, 0x30, 0xfb, 0x15, 0x85, 0x30,
	0x28, 0x69, 0x47, 0x9d, 0x0e, 0xd6, 0x89, 0x5c, 0x37, 0x34, 0xb9, 0xd9, 0x15, 0x73, 0xe8, 0x26,
	0xa0, 0x44, 0x30, 0x4e, 0x5e, 0xdc, 0x5b, 0x83, 0xd5, 0xb3, 0xc6, 0xf8, 0xfd, 0xb7, 0xf4, 0x64,
	0x3c, 0xa2, 0xe5, 0xf7, 0x02, 0x94, 0x3e, 0x56, 0x3b, 0xa4, 0x80, 0x18, 0xf6, 0x8a, 0xf6, 0x19,
	0x67, 0x44, 0x27, 0x74, 0xc4, 0xfe, 0xe4, 0xb5, 0xda, 0x83, 0xd4, 0xa2, 0xa9, 0x67, 0xc9, 0xed,
	0x30, 0x97, 0xac, 0xb8, 0xb3, 0x01, 0xf4, 0x33, 0x14, 0xcc, 0xd1, 0xc0, 0xf1, 0x86, 0xc1, 0x5b,
	0x8b, 0xcf, 0xfb, 0x8b, 0x4f, 0x6a, 0xe7, 0x85, 0x80, 0x14, 0xcb, 0x90, 0x73, 0xc5, 0xf2, 0x07,
	0x01, 0x6e, 0xb5, 0xe8, 0x54, 0x71, 0x69, 0x34, 0x57, 0x52, 0x10, 0x84, 0x63, 0x1a, 0x2e, 0x51,
	0x0f, 0x16, 0xdf, 0x38, 0x9e, 0x65, 0x06, 0xa5, 0x05, 0x76, 0xee, 0xf7, 0xa9, 0xe7, 0x7e, 0x84,
	0x5d, 0x49, 0xac, 0xf7, 0x99, 0x0a, 0xe1, 0x6a, 0xa8, 0x04, 0xf9, 0xbe, 0x63, 0x07, 0xd4, 0x0e,
	0xd8, 0x13, 0xb7, 0x4c, 0xe2, 0x6d, 0xf9, 0x14, 0x56, 0x2f, 0xd0, 0xc2, 0x56, 0x4b, 0xba, 0x8e,
	0x35, 0x5d, 0xd2, 0x65, 0xa5, 0x6b, 0xec, 0x2b, 0xa4, 0x23, 0xe9, 0x73, 0xad, 0x2e, 0xc1, 0xf5,
	0xba, 0xd4, 0x93, 0x0f, 0x3b, 0x46, 0x6f, 0xcb, 0xa8, 0x2b, 0x1d, 0x95, 0x60, 0x4d, 0xc3, 0x0d,
	0x31, 0x9b, 0x44, 0x6a, 0x49, 0x64, 0xa1, 0xfc, 0x07, 0x24, 0xe6, 0x8a, 0xd7, 0x28, 0xd5, 0xb1,
	0x7e, 0x84, 0x5c, 0x78, 0xa3, 0xd8, 0x6e, 0x9e, 0xff, 0xb7, 0xf2, 0x6b, 0xa1, 0x04, 0x89, 0x94,
	0x52, 0xc7, 0x24, 0xff, 0xc5, 0xc6, 0x04, 0xbe, 0xf4, 0x98, 0xa0, 0x2e, 0x14, 0xcd, 0xf3, 0xc6,
	0x70, 0x77, 0x7a, 0xf4, 0x39, 0xf3, 0x40, 0x92, 0x02, 0xf3, 0xc6, 0xbb, 0xf0, 0x59, 0xc6, 0xfb,
	0x02, 0xae, 0x0e, 0xa8, 0x1d, 0x1e, 0xc1, 0xe9, 0xc5, 0x4b, 0xe9, 0xcb, 0x31, 0x81, 0x09, 0x7c,
	0x07, 0xcb, 0x27, 0xd4, 0x0f, 0x3c, 0x67, 0xfa, 0xa9, 0xbe, 0x5f, 0xe4, 0xf9, 0xb1, 0xf1, 0xc7,
	0x74, 0x3a, 0xa1, 0x76, 0x10, 0x89, 0x2c, 0x5e, 0x6e, 0xfc, 0x9c, 0x85, 0x43, 0x12, 0x7b, 0x5b,
	0xfe, 0x95, 0x85, 0xdb, 0x1f, 0xad, 0x3f, 0x7a, 0x04, 0x9b, 0x09, 0x8f, 0xeb, 0x61, 0xa2, 0x85,
	0xf3, 0x2f, 0xb5, 0x9b, 0x0a, 0x91, 0xf5, 0x83, 0xce, 0xdc, 0x23, 0x70, 0x0f, 0xfe, 0xd7, 0x54,
	0x94, 0x66, 0x1b, 0x1b, 0xe7, 0x4e, 0xc6, 0xed, 0x4f, 0x56, 0xba, 0xa2, 0x80, 0xee, 0x40, 0x89,
	0x68, 0x12, 0xb3, 0x3c, 0x43, 0xd5, 0x34, 0xa3, 0xf6, 0x78, 0x67, 0xd7, 0xd0, 0x0e, 0xa4, 0xda,
	0x93, 0xa7, 0x62, 0xe6, 0x02, 0xba, 0xfd, 0xf8, 0x9b, 0x5a, 0x8c, 0x66, 0x2f, 0xa0, 0x3b, 0x8f,
	0x9f, 0x3d, 0x8d, 0xd1, 0x05, 0x74, 0x17, 0xd6, 0xcf, 0xd1, 0x56, 0x5d, 0xdb, 0x9a, 0xd1, 0xce,
	0xa5, 0xe0, 0x49, 0xf5, 0xc5, 0x14, 0x3c, 0xa9, 0x9f, 0x47, 0x1b, 0x70, 0x27, 0xc4, 0xb9, 0x2f,
	0x1b, 0x8a, 0x84, 0xd5, 0x99, 0x13, 0x96, 0x52, 0x33, 0x92, 0x67, 0x14, 0x52, 0x33, 0x92, 0xa7,
	0x00, 0xba, 0x05, 0x6b, 0xb8, 0xce, 0x2f, 0x51, 0x7b, 0x72, 0x06, 0x2c, 0xcf, 0x00, 0xdb, 0xbb,
	0x3b, 0x21, 0xb0, 0xbd, 0xbb, 0x23, 0x5e, 0x2d, 0xff, 0x2e, 0xc0, 0x8d, 0xd4, 0xc7, 0x1c, 0x6d,
	0xc2, 0x83, 0x94, 0xd6, 0x85, 0x16, 0x36, 0xff, 0x92, 0xba, 0x09, 0x48, 0xc5, 0xdd, 0x86, 0xdc,
	0x6d, 0x1a, 0x4d, 0xdc, 0xc5, 0x84, 0x99, 0x9c, 0x98, 0x43, 0x45, 0xc8, 0xe3, 0xae, 0xb4, 0xd7,
	0xc6, 0x0d, 0x51, 0x40, 0xcb, 0xb0, 0xd4, 0x90, 0xb5, 0x68, 0x97, 0x41, 0x57, 0xa1, 0xd0, 0xc0,
	0x9a, 0x4e, 0x94, 0x23, 0xe6, 0x70, 0x37, 0x60, 0x95, 0x6f, 0x0d, 0xad, 0x7e, 0x80, 0x1b, 0x87,
	0x6d, 0x66, 0x6f, 0x32, 0x5c, 0x9f, 0xbf, 0x5b, 0x6f, 0x48, 0x7f, 0x41, 0x5f, 0xc1, 0xfd, 0x94,
	0xab, 0xf5, 0x64, 0xfc, 0x72, 0xee, 0x66, 0x4b, 0xb0, 0xb0, 0x7f, 0xd8, 0x6e, 0x8b, 0x42, 0xf9,
	0x57, 0x28, 0xa8, 0xe3, 0xe3, 0xd1, 0xb0, 0x1f, 0x7e, 0xd3, 0x89, 0x90, 0x75, 0xa9, 0x15, 0xbf,
	0xb9, 0x5d, 0x6a, 0xcd, 0x7a, 0x4f, 0xe6, 0x4b, 0x7b, 0xcf, 0xc3, 0x1f, 0x60, 0x65, 0xce, 0xfe,
	0xc2, 0x66, 0xaa, 0x44, 0xd1, 0x71, 0x9d, 0xbd, 0x11, 0xda, 0xb8, 0x87, 0xdb, 0x73, 0x97, 0x5f,
	0x86, 0x25, 0x4d, 0xd9, 0xd7, 0x5f, 0x4a, 0x04, 0x8b, 0x02, 0xca, 0x43, 0xf6, 0x40, 0xeb, 0x88,
	0x99, 0xbd, 0xdf, 0x04, 0xb8, 0xd5, 0x77, 0xac, 0xb4, 0xdb, 0xed, 0xad, 0xb6, 0x2c, 0x9f, 0xc4,
	0x9f, 0xe7, 0xe1, 0x89, 0x8e, 0x2a, 0xbc, 0x7a, 0xca, 0x33, 0x07, 0xce, 0xc8, 0xb4, 0x07, 0x15,
	0xc7, 0x1b, 0x54, 0x07, 0xd4, 0x66, 0x0f, 0x77, 0x35, 0x82, 0x4c, 0x77, 0xe8, 0xcf, 0x7c, 0xe3,
	0x3f, 0x3f, 0xb5, 0xfc, 0x0f, 0x82, 0xf0, 0x67, 0x66, 0xad, 0x19, 0x71, 0xeb, 0xec, 0x94, 0x96,
	0xe5, 0x57, 0x7a, 0x5b, 0xef, 0xe3, 0xe8, 0x6b, 0x16, 0x7d, 0xdd, 0xb2, 0xfc, 0xd7, 0xbd, 0xad,
	0xe3, 0x45, 0xa6, 0xb8, 0xfd, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xbe, 0x5a, 0x5e, 0x75, 0x34,
	0x0c, 0x00, 0x00,
}
