// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateIpGroups = "AssociateIpGroups"

// AssociateIpGroupsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateIpGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateIpGroups for more information on using the AssociateIpGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateIpGroupsRequest method.
//    req, resp := client.AssociateIpGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups
func (c *WorkSpaces) AssociateIpGroupsRequest(input *AssociateIpGroupsInput) (req *request.Request, output *AssociateIpGroupsOutput) {
	op := &request.Operation{
		Name:       opAssociateIpGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateIpGroupsInput{}
	}

	output = &AssociateIpGroupsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateIpGroups API operation for Amazon WorkSpaces.
//
// Associates the specified IP access control group with the specified directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation AssociateIpGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
//   * ErrCodeOperationNotSupportedException "OperationNotSupportedException"
//   This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups
func (c *WorkSpaces) AssociateIpGroups(input *AssociateIpGroupsInput) (*AssociateIpGroupsOutput, error) {
	req, out := c.AssociateIpGroupsRequest(input)
	return out, req.Send()
}

// AssociateIpGroupsWithContext is the same as AssociateIpGroups with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateIpGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) AssociateIpGroupsWithContext(ctx aws.Context, input *AssociateIpGroupsInput, opts ...request.Option) (*AssociateIpGroupsOutput, error) {
	req, out := c.AssociateIpGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeIpRules = "AuthorizeIpRules"

// AuthorizeIpRulesRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeIpRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeIpRules for more information on using the AuthorizeIpRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AuthorizeIpRulesRequest method.
//    req, resp := client.AuthorizeIpRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules
func (c *WorkSpaces) AuthorizeIpRulesRequest(input *AuthorizeIpRulesInput) (req *request.Request, output *AuthorizeIpRulesOutput) {
	op := &request.Operation{
		Name:       opAuthorizeIpRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeIpRulesInput{}
	}

	output = &AuthorizeIpRulesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AuthorizeIpRules API operation for Amazon WorkSpaces.
//
// Adds one or more rules to the specified IP access control group.
//
// This action gives users permission to access their WorkSpaces from the CIDR
// address ranges specified in the rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation AuthorizeIpRules for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules
func (c *WorkSpaces) AuthorizeIpRules(input *AuthorizeIpRulesInput) (*AuthorizeIpRulesOutput, error) {
	req, out := c.AuthorizeIpRulesRequest(input)
	return out, req.Send()
}

// AuthorizeIpRulesWithContext is the same as AuthorizeIpRules with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeIpRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) AuthorizeIpRulesWithContext(ctx aws.Context, input *AuthorizeIpRulesInput, opts ...request.Option) (*AuthorizeIpRulesOutput, error) {
	req, out := c.AuthorizeIpRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyWorkspaceImage = "CopyWorkspaceImage"

// CopyWorkspaceImageRequest generates a "aws/request.Request" representing the
// client's request for the CopyWorkspaceImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyWorkspaceImage for more information on using the CopyWorkspaceImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyWorkspaceImageRequest method.
//    req, resp := client.CopyWorkspaceImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CopyWorkspaceImage
func (c *WorkSpaces) CopyWorkspaceImageRequest(input *CopyWorkspaceImageInput) (req *request.Request, output *CopyWorkspaceImageOutput) {
	op := &request.Operation{
		Name:       opCopyWorkspaceImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyWorkspaceImageInput{}
	}

	output = &CopyWorkspaceImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyWorkspaceImage API operation for Amazon WorkSpaces.
//
// Copies the specified image from the specified Region to the current Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CopyWorkspaceImage for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   The specified resource is not available.
//
//   * ErrCodeOperationNotSupportedException "OperationNotSupportedException"
//   This operation is not supported.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CopyWorkspaceImage
func (c *WorkSpaces) CopyWorkspaceImage(input *CopyWorkspaceImageInput) (*CopyWorkspaceImageOutput, error) {
	req, out := c.CopyWorkspaceImageRequest(input)
	return out, req.Send()
}

// CopyWorkspaceImageWithContext is the same as CopyWorkspaceImage with the addition of
// the ability to pass a context and additional request options.
//
// See CopyWorkspaceImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CopyWorkspaceImageWithContext(ctx aws.Context, input *CopyWorkspaceImageInput, opts ...request.Option) (*CopyWorkspaceImageOutput, error) {
	req, out := c.CopyWorkspaceImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIpGroup = "CreateIpGroup"

// CreateIpGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateIpGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIpGroup for more information on using the CreateIpGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIpGroupRequest method.
//    req, resp := client.CreateIpGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup
func (c *WorkSpaces) CreateIpGroupRequest(input *CreateIpGroupInput) (req *request.Request, output *CreateIpGroupOutput) {
	op := &request.Operation{
		Name:       opCreateIpGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIpGroupInput{}
	}

	output = &CreateIpGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIpGroup API operation for Amazon WorkSpaces.
//
// Creates an IP access control group.
//
// An IP access control group provides you with the ability to control the IP
// addresses from which users are allowed to access their WorkSpaces. To specify
// the CIDR address ranges, add rules to your IP access control group and then
// associate the group with your directory. You can add rules when you create
// the group or at any time using AuthorizeIpRules.
//
// There is a default IP access control group associated with your directory.
// If you don't associate an IP access control group with your directory, the
// default group is used. The default group includes a default rule that allows
// users to access their WorkSpaces from anywhere. You cannot modify the default
// IP access control group for your directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateIpGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeResourceCreationFailedException "ResourceCreationFailedException"
//   The resource could not be created.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup
func (c *WorkSpaces) CreateIpGroup(input *CreateIpGroupInput) (*CreateIpGroupOutput, error) {
	req, out := c.CreateIpGroupRequest(input)
	return out, req.Send()
}

// CreateIpGroupWithContext is the same as CreateIpGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIpGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateIpGroupWithContext(ctx aws.Context, input *CreateIpGroupInput, opts ...request.Option) (*CreateIpGroupOutput, error) {
	req, out := c.CreateIpGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTags for more information on using the CreateTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTagsRequest method.
//    req, resp := client.CreateTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags
func (c *WorkSpaces) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTags API operation for Amazon WorkSpaces.
//
// Creates the specified tags for the specified WorkSpaces resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags
func (c *WorkSpaces) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	return out, req.Send()
}

// CreateTagsWithContext is the same as CreateTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateTagsWithContext(ctx aws.Context, input *CreateTagsInput, opts ...request.Option) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkspaces = "CreateWorkspaces"

// CreateWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkspaces for more information on using the CreateWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkspacesRequest method.
//    req, resp := client.CreateWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces
func (c *WorkSpaces) CreateWorkspacesRequest(input *CreateWorkspacesInput) (req *request.Request, output *CreateWorkspacesOutput) {
	op := &request.Operation{
		Name:       opCreateWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkspacesInput{}
	}

	output = &CreateWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkspaces API operation for Amazon WorkSpaces.
//
// Creates one or more WorkSpaces.
//
// This operation is asynchronous and returns before the WorkSpaces are created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateWorkspaces for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces
func (c *WorkSpaces) CreateWorkspaces(input *CreateWorkspacesInput) (*CreateWorkspacesOutput, error) {
	req, out := c.CreateWorkspacesRequest(input)
	return out, req.Send()
}

// CreateWorkspacesWithContext is the same as CreateWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateWorkspacesWithContext(ctx aws.Context, input *CreateWorkspacesInput, opts ...request.Option) (*CreateWorkspacesOutput, error) {
	req, out := c.CreateWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIpGroup = "DeleteIpGroup"

// DeleteIpGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIpGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIpGroup for more information on using the DeleteIpGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIpGroupRequest method.
//    req, resp := client.DeleteIpGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup
func (c *WorkSpaces) DeleteIpGroupRequest(input *DeleteIpGroupInput) (req *request.Request, output *DeleteIpGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteIpGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIpGroupInput{}
	}

	output = &DeleteIpGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIpGroup API operation for Amazon WorkSpaces.
//
// Deletes the specified IP access control group.
//
// You cannot delete an IP access control group that is associated with a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteIpGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeResourceAssociatedException "ResourceAssociatedException"
//   The resource is associated with a directory.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup
func (c *WorkSpaces) DeleteIpGroup(input *DeleteIpGroupInput) (*DeleteIpGroupOutput, error) {
	req, out := c.DeleteIpGroupRequest(input)
	return out, req.Send()
}

// DeleteIpGroupWithContext is the same as DeleteIpGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIpGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteIpGroupWithContext(ctx aws.Context, input *DeleteIpGroupInput, opts ...request.Option) (*DeleteIpGroupOutput, error) {
	req, out := c.DeleteIpGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags
func (c *WorkSpaces) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for Amazon WorkSpaces.
//
// Deletes the specified tags from the specified WorkSpaces resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags
func (c *WorkSpaces) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkspaceImage = "DeleteWorkspaceImage"

// DeleteWorkspaceImageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkspaceImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkspaceImage for more information on using the DeleteWorkspaceImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWorkspaceImageRequest method.
//    req, resp := client.DeleteWorkspaceImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImage
func (c *WorkSpaces) DeleteWorkspaceImageRequest(input *DeleteWorkspaceImageInput) (req *request.Request, output *DeleteWorkspaceImageOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkspaceImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkspaceImageInput{}
	}

	output = &DeleteWorkspaceImageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkspaceImage API operation for Amazon WorkSpaces.
//
// Deletes the specified image from your account. To delete an image, you must
// first delete any bundles that are associated with the image and un-share
// the image if it is shared with other accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteWorkspaceImage for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceAssociatedException "ResourceAssociatedException"
//   The resource is associated with a directory.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImage
func (c *WorkSpaces) DeleteWorkspaceImage(input *DeleteWorkspaceImageInput) (*DeleteWorkspaceImageOutput, error) {
	req, out := c.DeleteWorkspaceImageRequest(input)
	return out, req.Send()
}

// DeleteWorkspaceImageWithContext is the same as DeleteWorkspaceImage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkspaceImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteWorkspaceImageWithContext(ctx aws.Context, input *DeleteWorkspaceImageInput, opts ...request.Option) (*DeleteWorkspaceImageOutput, error) {
	req, out := c.DeleteWorkspaceImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccount = "DescribeAccount"

// DescribeAccountRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccount for more information on using the DescribeAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountRequest method.
//    req, resp := client.DescribeAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccount
func (c *WorkSpaces) DescribeAccountRequest(input *DescribeAccountInput) (req *request.Request, output *DescribeAccountOutput) {
	op := &request.Operation{
		Name:       opDescribeAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountInput{}
	}

	output = &DescribeAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccount API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes the configuration of bring your own license
// (BYOL) for the specified account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccount
func (c *WorkSpaces) DescribeAccount(input *DescribeAccountInput) (*DescribeAccountOutput, error) {
	req, out := c.DescribeAccountRequest(input)
	return out, req.Send()
}

// DescribeAccountWithContext is the same as DescribeAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeAccountWithContext(ctx aws.Context, input *DescribeAccountInput, opts ...request.Option) (*DescribeAccountOutput, error) {
	req, out := c.DescribeAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountModifications = "DescribeAccountModifications"

// DescribeAccountModificationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountModifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountModifications for more information on using the DescribeAccountModifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountModificationsRequest method.
//    req, resp := client.DescribeAccountModificationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountModifications
func (c *WorkSpaces) DescribeAccountModificationsRequest(input *DescribeAccountModificationsInput) (req *request.Request, output *DescribeAccountModificationsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountModifications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountModificationsInput{}
	}

	output = &DescribeAccountModificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountModifications API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes modifications to the configuration of bring
// your own license (BYOL) for the specified account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeAccountModifications for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountModifications
func (c *WorkSpaces) DescribeAccountModifications(input *DescribeAccountModificationsInput) (*DescribeAccountModificationsOutput, error) {
	req, out := c.DescribeAccountModificationsRequest(input)
	return out, req.Send()
}

// DescribeAccountModificationsWithContext is the same as DescribeAccountModifications with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountModifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeAccountModificationsWithContext(ctx aws.Context, input *DescribeAccountModificationsInput, opts ...request.Option) (*DescribeAccountModificationsOutput, error) {
	req, out := c.DescribeAccountModificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeClientProperties = "DescribeClientProperties"

// DescribeClientPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClientProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClientProperties for more information on using the DescribeClientProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClientPropertiesRequest method.
//    req, resp := client.DescribeClientPropertiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientProperties
func (c *WorkSpaces) DescribeClientPropertiesRequest(input *DescribeClientPropertiesInput) (req *request.Request, output *DescribeClientPropertiesOutput) {
	op := &request.Operation{
		Name:       opDescribeClientProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClientPropertiesInput{}
	}

	output = &DescribeClientPropertiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClientProperties API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeClientProperties for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientProperties
func (c *WorkSpaces) DescribeClientProperties(input *DescribeClientPropertiesInput) (*DescribeClientPropertiesOutput, error) {
	req, out := c.DescribeClientPropertiesRequest(input)
	return out, req.Send()
}

// DescribeClientPropertiesWithContext is the same as DescribeClientProperties with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClientProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeClientPropertiesWithContext(ctx aws.Context, input *DescribeClientPropertiesInput, opts ...request.Option) (*DescribeClientPropertiesOutput, error) {
	req, out := c.DescribeClientPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIpGroups = "DescribeIpGroups"

// DescribeIpGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIpGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIpGroups for more information on using the DescribeIpGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIpGroupsRequest method.
//    req, resp := client.DescribeIpGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups
func (c *WorkSpaces) DescribeIpGroupsRequest(input *DescribeIpGroupsInput) (req *request.Request, output *DescribeIpGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeIpGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIpGroupsInput{}
	}

	output = &DescribeIpGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIpGroups API operation for Amazon WorkSpaces.
//
// Describes one or more of your IP access control groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeIpGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups
func (c *WorkSpaces) DescribeIpGroups(input *DescribeIpGroupsInput) (*DescribeIpGroupsOutput, error) {
	req, out := c.DescribeIpGroupsRequest(input)
	return out, req.Send()
}

// DescribeIpGroupsWithContext is the same as DescribeIpGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIpGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeIpGroupsWithContext(ctx aws.Context, input *DescribeIpGroupsInput, opts ...request.Option) (*DescribeIpGroupsOutput, error) {
	req, out := c.DescribeIpGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTags for more information on using the DescribeTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags
func (c *WorkSpaces) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for Amazon WorkSpaces.
//
// Describes the specified tags for the specified WorkSpaces resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags
func (c *WorkSpaces) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	return out, req.Send()
}

// DescribeTagsWithContext is the same as DescribeTags with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeTagsWithContext(ctx aws.Context, input *DescribeTagsInput, opts ...request.Option) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspaceBundles = "DescribeWorkspaceBundles"

// DescribeWorkspaceBundlesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceBundles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceBundles for more information on using the DescribeWorkspaceBundles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspaceBundlesRequest method.
//    req, resp := client.DescribeWorkspaceBundlesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles
func (c *WorkSpaces) DescribeWorkspaceBundlesRequest(input *DescribeWorkspaceBundlesInput) (req *request.Request, output *DescribeWorkspaceBundlesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceBundles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspaceBundlesInput{}
	}

	output = &DescribeWorkspaceBundlesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceBundles API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes the available WorkSpace bundles.
//
// You can filter the results using either bundle ID or owner, but not both.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceBundles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles
func (c *WorkSpaces) DescribeWorkspaceBundles(input *DescribeWorkspaceBundlesInput) (*DescribeWorkspaceBundlesOutput, error) {
	req, out := c.DescribeWorkspaceBundlesRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceBundlesWithContext is the same as DescribeWorkspaceBundles with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceBundles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceBundlesWithContext(ctx aws.Context, input *DescribeWorkspaceBundlesInput, opts ...request.Option) (*DescribeWorkspaceBundlesOutput, error) {
	req, out := c.DescribeWorkspaceBundlesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeWorkspaceBundlesPages iterates over the pages of a DescribeWorkspaceBundles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeWorkspaceBundles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeWorkspaceBundles operation.
//    pageNum := 0
//    err := client.DescribeWorkspaceBundlesPages(params,
//        func(page *workspaces.DescribeWorkspaceBundlesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkSpaces) DescribeWorkspaceBundlesPages(input *DescribeWorkspaceBundlesInput, fn func(*DescribeWorkspaceBundlesOutput, bool) bool) error {
	return c.DescribeWorkspaceBundlesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeWorkspaceBundlesPagesWithContext same as DescribeWorkspaceBundlesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceBundlesPagesWithContext(ctx aws.Context, input *DescribeWorkspaceBundlesInput, fn func(*DescribeWorkspaceBundlesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeWorkspaceBundlesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeWorkspaceBundlesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeWorkspaceBundlesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeWorkspaceDirectories = "DescribeWorkspaceDirectories"

// DescribeWorkspaceDirectoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceDirectories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceDirectories for more information on using the DescribeWorkspaceDirectories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspaceDirectoriesRequest method.
//    req, resp := client.DescribeWorkspaceDirectoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories
func (c *WorkSpaces) DescribeWorkspaceDirectoriesRequest(input *DescribeWorkspaceDirectoriesInput) (req *request.Request, output *DescribeWorkspaceDirectoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceDirectories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspaceDirectoriesInput{}
	}

	output = &DescribeWorkspaceDirectoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceDirectories API operation for Amazon WorkSpaces.
//
// Describes the available AWS Directory Service directories that are registered
// with Amazon WorkSpaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceDirectories for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories
func (c *WorkSpaces) DescribeWorkspaceDirectories(input *DescribeWorkspaceDirectoriesInput) (*DescribeWorkspaceDirectoriesOutput, error) {
	req, out := c.DescribeWorkspaceDirectoriesRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceDirectoriesWithContext is the same as DescribeWorkspaceDirectories with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceDirectories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceDirectoriesWithContext(ctx aws.Context, input *DescribeWorkspaceDirectoriesInput, opts ...request.Option) (*DescribeWorkspaceDirectoriesOutput, error) {
	req, out := c.DescribeWorkspaceDirectoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeWorkspaceDirectoriesPages iterates over the pages of a DescribeWorkspaceDirectories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeWorkspaceDirectories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeWorkspaceDirectories operation.
//    pageNum := 0
//    err := client.DescribeWorkspaceDirectoriesPages(params,
//        func(page *workspaces.DescribeWorkspaceDirectoriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkSpaces) DescribeWorkspaceDirectoriesPages(input *DescribeWorkspaceDirectoriesInput, fn func(*DescribeWorkspaceDirectoriesOutput, bool) bool) error {
	return c.DescribeWorkspaceDirectoriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeWorkspaceDirectoriesPagesWithContext same as DescribeWorkspaceDirectoriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceDirectoriesPagesWithContext(ctx aws.Context, input *DescribeWorkspaceDirectoriesInput, fn func(*DescribeWorkspaceDirectoriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeWorkspaceDirectoriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeWorkspaceDirectoriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeWorkspaceDirectoriesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeWorkspaceImages = "DescribeWorkspaceImages"

// DescribeWorkspaceImagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceImages for more information on using the DescribeWorkspaceImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspaceImagesRequest method.
//    req, resp := client.DescribeWorkspaceImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages
func (c *WorkSpaces) DescribeWorkspaceImagesRequest(input *DescribeWorkspaceImagesInput) (req *request.Request, output *DescribeWorkspaceImagesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspaceImagesInput{}
	}

	output = &DescribeWorkspaceImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceImages API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes one or more specified images, if the image
// identifiers are provided. Otherwise, all images in the account are described.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceImages for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages
func (c *WorkSpaces) DescribeWorkspaceImages(input *DescribeWorkspaceImagesInput) (*DescribeWorkspaceImagesOutput, error) {
	req, out := c.DescribeWorkspaceImagesRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceImagesWithContext is the same as DescribeWorkspaceImages with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceImagesWithContext(ctx aws.Context, input *DescribeWorkspaceImagesInput, opts ...request.Option) (*DescribeWorkspaceImagesOutput, error) {
	req, out := c.DescribeWorkspaceImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspaces = "DescribeWorkspaces"

// DescribeWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaces for more information on using the DescribeWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspacesRequest method.
//    req, resp := client.DescribeWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces
func (c *WorkSpaces) DescribeWorkspacesRequest(input *DescribeWorkspacesInput) (req *request.Request, output *DescribeWorkspacesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspacesInput{}
	}

	output = &DescribeWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaces API operation for Amazon WorkSpaces.
//
// Describes the specified WorkSpaces.
//
// You can filter the results by using the bundle identifier, directory identifier,
// or owner, but you can specify only one filter at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaces for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   The specified resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces
func (c *WorkSpaces) DescribeWorkspaces(input *DescribeWorkspacesInput) (*DescribeWorkspacesOutput, error) {
	req, out := c.DescribeWorkspacesRequest(input)
	return out, req.Send()
}

// DescribeWorkspacesWithContext is the same as DescribeWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspacesWithContext(ctx aws.Context, input *DescribeWorkspacesInput, opts ...request.Option) (*DescribeWorkspacesOutput, error) {
	req, out := c.DescribeWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeWorkspacesPages iterates over the pages of a DescribeWorkspaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeWorkspaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeWorkspaces operation.
//    pageNum := 0
//    err := client.DescribeWorkspacesPages(params,
//        func(page *workspaces.DescribeWorkspacesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkSpaces) DescribeWorkspacesPages(input *DescribeWorkspacesInput, fn func(*DescribeWorkspacesOutput, bool) bool) error {
	return c.DescribeWorkspacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeWorkspacesPagesWithContext same as DescribeWorkspacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspacesPagesWithContext(ctx aws.Context, input *DescribeWorkspacesInput, fn func(*DescribeWorkspacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeWorkspacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeWorkspacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeWorkspacesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeWorkspacesConnectionStatus = "DescribeWorkspacesConnectionStatus"

// DescribeWorkspacesConnectionStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspacesConnectionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspacesConnectionStatus for more information on using the DescribeWorkspacesConnectionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspacesConnectionStatusRequest method.
//    req, resp := client.DescribeWorkspacesConnectionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus
func (c *WorkSpaces) DescribeWorkspacesConnectionStatusRequest(input *DescribeWorkspacesConnectionStatusInput) (req *request.Request, output *DescribeWorkspacesConnectionStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspacesConnectionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspacesConnectionStatusInput{}
	}

	output = &DescribeWorkspacesConnectionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspacesConnectionStatus API operation for Amazon WorkSpaces.
//
// Describes the connection status of the specified WorkSpaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspacesConnectionStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus
func (c *WorkSpaces) DescribeWorkspacesConnectionStatus(input *DescribeWorkspacesConnectionStatusInput) (*DescribeWorkspacesConnectionStatusOutput, error) {
	req, out := c.DescribeWorkspacesConnectionStatusRequest(input)
	return out, req.Send()
}

// DescribeWorkspacesConnectionStatusWithContext is the same as DescribeWorkspacesConnectionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspacesConnectionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspacesConnectionStatusWithContext(ctx aws.Context, input *DescribeWorkspacesConnectionStatusInput, opts ...request.Option) (*DescribeWorkspacesConnectionStatusOutput, error) {
	req, out := c.DescribeWorkspacesConnectionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateIpGroups = "DisassociateIpGroups"

// DisassociateIpGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateIpGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateIpGroups for more information on using the DisassociateIpGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateIpGroupsRequest method.
//    req, resp := client.DisassociateIpGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups
func (c *WorkSpaces) DisassociateIpGroupsRequest(input *DisassociateIpGroupsInput) (req *request.Request, output *DisassociateIpGroupsOutput) {
	op := &request.Operation{
		Name:       opDisassociateIpGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateIpGroupsInput{}
	}

	output = &DisassociateIpGroupsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateIpGroups API operation for Amazon WorkSpaces.
//
// Disassociates the specified IP access control group from the specified directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DisassociateIpGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups
func (c *WorkSpaces) DisassociateIpGroups(input *DisassociateIpGroupsInput) (*DisassociateIpGroupsOutput, error) {
	req, out := c.DisassociateIpGroupsRequest(input)
	return out, req.Send()
}

// DisassociateIpGroupsWithContext is the same as DisassociateIpGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateIpGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DisassociateIpGroupsWithContext(ctx aws.Context, input *DisassociateIpGroupsInput, opts ...request.Option) (*DisassociateIpGroupsOutput, error) {
	req, out := c.DisassociateIpGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportWorkspaceImage = "ImportWorkspaceImage"

// ImportWorkspaceImageRequest generates a "aws/request.Request" representing the
// client's request for the ImportWorkspaceImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportWorkspaceImage for more information on using the ImportWorkspaceImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportWorkspaceImageRequest method.
//    req, resp := client.ImportWorkspaceImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportWorkspaceImage
func (c *WorkSpaces) ImportWorkspaceImageRequest(input *ImportWorkspaceImageInput) (req *request.Request, output *ImportWorkspaceImageOutput) {
	op := &request.Operation{
		Name:       opImportWorkspaceImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportWorkspaceImageInput{}
	}

	output = &ImportWorkspaceImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportWorkspaceImage API operation for Amazon WorkSpaces.
//
// Imports the specified Windows 7 or Windows 10 bring your own license (BYOL)
// image into Amazon WorkSpaces. The image must be an already licensed EC2 image
// that is in your AWS account, and you must own the image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ImportWorkspaceImage for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The specified resource already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeOperationNotSupportedException "OperationNotSupportedException"
//   This operation is not supported.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportWorkspaceImage
func (c *WorkSpaces) ImportWorkspaceImage(input *ImportWorkspaceImageInput) (*ImportWorkspaceImageOutput, error) {
	req, out := c.ImportWorkspaceImageRequest(input)
	return out, req.Send()
}

// ImportWorkspaceImageWithContext is the same as ImportWorkspaceImage with the addition of
// the ability to pass a context and additional request options.
//
// See ImportWorkspaceImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ImportWorkspaceImageWithContext(ctx aws.Context, input *ImportWorkspaceImageInput, opts ...request.Option) (*ImportWorkspaceImageOutput, error) {
	req, out := c.ImportWorkspaceImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAvailableManagementCidrRanges = "ListAvailableManagementCidrRanges"

// ListAvailableManagementCidrRangesRequest generates a "aws/request.Request" representing the
// client's request for the ListAvailableManagementCidrRanges operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAvailableManagementCidrRanges for more information on using the ListAvailableManagementCidrRanges
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAvailableManagementCidrRangesRequest method.
//    req, resp := client.ListAvailableManagementCidrRangesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAvailableManagementCidrRanges
func (c *WorkSpaces) ListAvailableManagementCidrRangesRequest(input *ListAvailableManagementCidrRangesInput) (req *request.Request, output *ListAvailableManagementCidrRangesOutput) {
	op := &request.Operation{
		Name:       opListAvailableManagementCidrRanges,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAvailableManagementCidrRangesInput{}
	}

	output = &ListAvailableManagementCidrRangesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAvailableManagementCidrRanges API operation for Amazon WorkSpaces.
//
// Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that
// you can use for the network management interface when you enable bring your
// own license (BYOL).
//
// The management network interface is connected to a secure Amazon WorkSpaces
// management network. It is used for interactive streaming of the WorkSpace
// desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage
// the WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ListAvailableManagementCidrRanges for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAvailableManagementCidrRanges
func (c *WorkSpaces) ListAvailableManagementCidrRanges(input *ListAvailableManagementCidrRangesInput) (*ListAvailableManagementCidrRangesOutput, error) {
	req, out := c.ListAvailableManagementCidrRangesRequest(input)
	return out, req.Send()
}

// ListAvailableManagementCidrRangesWithContext is the same as ListAvailableManagementCidrRanges with the addition of
// the ability to pass a context and additional request options.
//
// See ListAvailableManagementCidrRanges for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ListAvailableManagementCidrRangesWithContext(ctx aws.Context, input *ListAvailableManagementCidrRangesInput, opts ...request.Option) (*ListAvailableManagementCidrRangesOutput, error) {
	req, out := c.ListAvailableManagementCidrRangesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyAccount = "ModifyAccount"

// ModifyAccountRequest generates a "aws/request.Request" representing the
// client's request for the ModifyAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyAccount for more information on using the ModifyAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyAccountRequest method.
//    req, resp := client.ModifyAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyAccount
func (c *WorkSpaces) ModifyAccountRequest(input *ModifyAccountInput) (req *request.Request, output *ModifyAccountOutput) {
	op := &request.Operation{
		Name:       opModifyAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyAccountInput{}
	}

	output = &ModifyAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyAccount API operation for Amazon WorkSpaces.
//
// Modifies the configuration of bring your own license (BYOL) for the specified
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyAccount for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   The specified resource is not available.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyAccount
func (c *WorkSpaces) ModifyAccount(input *ModifyAccountInput) (*ModifyAccountOutput, error) {
	req, out := c.ModifyAccountRequest(input)
	return out, req.Send()
}

// ModifyAccountWithContext is the same as ModifyAccount with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyAccountWithContext(ctx aws.Context, input *ModifyAccountInput, opts ...request.Option) (*ModifyAccountOutput, error) {
	req, out := c.ModifyAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyClientProperties = "ModifyClientProperties"

// ModifyClientPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyClientProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyClientProperties for more information on using the ModifyClientProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyClientPropertiesRequest method.
//    req, resp := client.ModifyClientPropertiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyClientProperties
func (c *WorkSpaces) ModifyClientPropertiesRequest(input *ModifyClientPropertiesInput) (req *request.Request, output *ModifyClientPropertiesOutput) {
	op := &request.Operation{
		Name:       opModifyClientProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClientPropertiesInput{}
	}

	output = &ModifyClientPropertiesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyClientProperties API operation for Amazon WorkSpaces.
//
// Modifies the properties of the specified Amazon WorkSpaces clients.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyClientProperties for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyClientProperties
func (c *WorkSpaces) ModifyClientProperties(input *ModifyClientPropertiesInput) (*ModifyClientPropertiesOutput, error) {
	req, out := c.ModifyClientPropertiesRequest(input)
	return out, req.Send()
}

// ModifyClientPropertiesWithContext is the same as ModifyClientProperties with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyClientProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyClientPropertiesWithContext(ctx aws.Context, input *ModifyClientPropertiesInput, opts ...request.Option) (*ModifyClientPropertiesOutput, error) {
	req, out := c.ModifyClientPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyWorkspaceProperties = "ModifyWorkspaceProperties"

// ModifyWorkspacePropertiesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyWorkspaceProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyWorkspaceProperties for more information on using the ModifyWorkspaceProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyWorkspacePropertiesRequest method.
//    req, resp := client.ModifyWorkspacePropertiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties
func (c *WorkSpaces) ModifyWorkspacePropertiesRequest(input *ModifyWorkspacePropertiesInput) (req *request.Request, output *ModifyWorkspacePropertiesOutput) {
	op := &request.Operation{
		Name:       opModifyWorkspaceProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyWorkspacePropertiesInput{}
	}

	output = &ModifyWorkspacePropertiesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyWorkspaceProperties API operation for Amazon WorkSpaces.
//
// Modifies the specified WorkSpace properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyWorkspaceProperties for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeOperationInProgressException "OperationInProgressException"
//   The properties of this WorkSpace are currently being modified. Try again
//   in a moment.
//
//   * ErrCodeUnsupportedWorkspaceConfigurationException "UnsupportedWorkspaceConfigurationException"
//   The configuration of this WorkSpace is not supported for this operation.
//   For more information, see the Amazon WorkSpaces Administration Guide (https://docs.aws.amazon.com/workspaces/latest/adminguide/).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   The specified resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties
func (c *WorkSpaces) ModifyWorkspaceProperties(input *ModifyWorkspacePropertiesInput) (*ModifyWorkspacePropertiesOutput, error) {
	req, out := c.ModifyWorkspacePropertiesRequest(input)
	return out, req.Send()
}

// ModifyWorkspacePropertiesWithContext is the same as ModifyWorkspaceProperties with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyWorkspaceProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyWorkspacePropertiesWithContext(ctx aws.Context, input *ModifyWorkspacePropertiesInput, opts ...request.Option) (*ModifyWorkspacePropertiesOutput, error) {
	req, out := c.ModifyWorkspacePropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyWorkspaceState = "ModifyWorkspaceState"

// ModifyWorkspaceStateRequest generates a "aws/request.Request" representing the
// client's request for the ModifyWorkspaceState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyWorkspaceState for more information on using the ModifyWorkspaceState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyWorkspaceStateRequest method.
//    req, resp := client.ModifyWorkspaceStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState
func (c *WorkSpaces) ModifyWorkspaceStateRequest(input *ModifyWorkspaceStateInput) (req *request.Request, output *ModifyWorkspaceStateOutput) {
	op := &request.Operation{
		Name:       opModifyWorkspaceState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyWorkspaceStateInput{}
	}

	output = &ModifyWorkspaceStateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyWorkspaceState API operation for Amazon WorkSpaces.
//
// Sets the state of the specified WorkSpace.
//
// To maintain a WorkSpace without being interrupted, set the WorkSpace state
// to ADMIN_MAINTENANCE. WorkSpaces in this state do not respond to requests
// to reboot, stop, start, rebuild, or restore. An AutoStop WorkSpace in this
// state is not stopped. Users cannot log into a WorkSpace in the ADMIN_MAINTENANCE
// state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyWorkspaceState for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState
func (c *WorkSpaces) ModifyWorkspaceState(input *ModifyWorkspaceStateInput) (*ModifyWorkspaceStateOutput, error) {
	req, out := c.ModifyWorkspaceStateRequest(input)
	return out, req.Send()
}

// ModifyWorkspaceStateWithContext is the same as ModifyWorkspaceState with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyWorkspaceState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyWorkspaceStateWithContext(ctx aws.Context, input *ModifyWorkspaceStateInput, opts ...request.Option) (*ModifyWorkspaceStateOutput, error) {
	req, out := c.ModifyWorkspaceStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootWorkspaces = "RebootWorkspaces"

// RebootWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the RebootWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootWorkspaces for more information on using the RebootWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootWorkspacesRequest method.
//    req, resp := client.RebootWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces
func (c *WorkSpaces) RebootWorkspacesRequest(input *RebootWorkspacesInput) (req *request.Request, output *RebootWorkspacesOutput) {
	op := &request.Operation{
		Name:       opRebootWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootWorkspacesInput{}
	}

	output = &RebootWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootWorkspaces API operation for Amazon WorkSpaces.
//
// Reboots the specified WorkSpaces.
//
// You cannot reboot a WorkSpace unless its state is AVAILABLE or UNHEALTHY.
//
// This operation is asynchronous and returns before the WorkSpaces have rebooted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RebootWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces
func (c *WorkSpaces) RebootWorkspaces(input *RebootWorkspacesInput) (*RebootWorkspacesOutput, error) {
	req, out := c.RebootWorkspacesRequest(input)
	return out, req.Send()
}

// RebootWorkspacesWithContext is the same as RebootWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See RebootWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RebootWorkspacesWithContext(ctx aws.Context, input *RebootWorkspacesInput, opts ...request.Option) (*RebootWorkspacesOutput, error) {
	req, out := c.RebootWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebuildWorkspaces = "RebuildWorkspaces"

// RebuildWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the RebuildWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebuildWorkspaces for more information on using the RebuildWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebuildWorkspacesRequest method.
//    req, resp := client.RebuildWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces
func (c *WorkSpaces) RebuildWorkspacesRequest(input *RebuildWorkspacesInput) (req *request.Request, output *RebuildWorkspacesOutput) {
	op := &request.Operation{
		Name:       opRebuildWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebuildWorkspacesInput{}
	}

	output = &RebuildWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebuildWorkspaces API operation for Amazon WorkSpaces.
//
// Rebuilds the specified WorkSpace.
//
// You cannot rebuild a WorkSpace unless its state is AVAILABLE, ERROR, or UNHEALTHY.
//
// Rebuilding a WorkSpace is a potentially destructive action that can result
// in the loss of data. For more information, see Rebuild a WorkSpace (https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html).
//
// This operation is asynchronous and returns before the WorkSpaces have been
// completely rebuilt.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RebuildWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces
func (c *WorkSpaces) RebuildWorkspaces(input *RebuildWorkspacesInput) (*RebuildWorkspacesOutput, error) {
	req, out := c.RebuildWorkspacesRequest(input)
	return out, req.Send()
}

// RebuildWorkspacesWithContext is the same as RebuildWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See RebuildWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RebuildWorkspacesWithContext(ctx aws.Context, input *RebuildWorkspacesInput, opts ...request.Option) (*RebuildWorkspacesOutput, error) {
	req, out := c.RebuildWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeIpRules = "RevokeIpRules"

// RevokeIpRulesRequest generates a "aws/request.Request" representing the
// client's request for the RevokeIpRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeIpRules for more information on using the RevokeIpRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeIpRulesRequest method.
//    req, resp := client.RevokeIpRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules
func (c *WorkSpaces) RevokeIpRulesRequest(input *RevokeIpRulesInput) (req *request.Request, output *RevokeIpRulesOutput) {
	op := &request.Operation{
		Name:       opRevokeIpRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeIpRulesInput{}
	}

	output = &RevokeIpRulesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokeIpRules API operation for Amazon WorkSpaces.
//
// Removes one or more rules from the specified IP access control group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RevokeIpRules for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules
func (c *WorkSpaces) RevokeIpRules(input *RevokeIpRulesInput) (*RevokeIpRulesOutput, error) {
	req, out := c.RevokeIpRulesRequest(input)
	return out, req.Send()
}

// RevokeIpRulesWithContext is the same as RevokeIpRules with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeIpRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RevokeIpRulesWithContext(ctx aws.Context, input *RevokeIpRulesInput, opts ...request.Option) (*RevokeIpRulesOutput, error) {
	req, out := c.RevokeIpRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartWorkspaces = "StartWorkspaces"

// StartWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the StartWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartWorkspaces for more information on using the StartWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartWorkspacesRequest method.
//    req, resp := client.StartWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces
func (c *WorkSpaces) StartWorkspacesRequest(input *StartWorkspacesInput) (req *request.Request, output *StartWorkspacesOutput) {
	op := &request.Operation{
		Name:       opStartWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartWorkspacesInput{}
	}

	output = &StartWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartWorkspaces API operation for Amazon WorkSpaces.
//
// Starts the specified WorkSpaces.
//
// You cannot start a WorkSpace unless it has a running mode of AutoStop and
// a state of STOPPED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation StartWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces
func (c *WorkSpaces) StartWorkspaces(input *StartWorkspacesInput) (*StartWorkspacesOutput, error) {
	req, out := c.StartWorkspacesRequest(input)
	return out, req.Send()
}

// StartWorkspacesWithContext is the same as StartWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See StartWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) StartWorkspacesWithContext(ctx aws.Context, input *StartWorkspacesInput, opts ...request.Option) (*StartWorkspacesOutput, error) {
	req, out := c.StartWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopWorkspaces = "StopWorkspaces"

// StopWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the StopWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopWorkspaces for more information on using the StopWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopWorkspacesRequest method.
//    req, resp := client.StopWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces
func (c *WorkSpaces) StopWorkspacesRequest(input *StopWorkspacesInput) (req *request.Request, output *StopWorkspacesOutput) {
	op := &request.Operation{
		Name:       opStopWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopWorkspacesInput{}
	}

	output = &StopWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopWorkspaces API operation for Amazon WorkSpaces.
//
// Stops the specified WorkSpaces.
//
// You cannot stop a WorkSpace unless it has a running mode of AutoStop and
// a state of AVAILABLE, IMPAIRED, UNHEALTHY, or ERROR.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation StopWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces
func (c *WorkSpaces) StopWorkspaces(input *StopWorkspacesInput) (*StopWorkspacesOutput, error) {
	req, out := c.StopWorkspacesRequest(input)
	return out, req.Send()
}

// StopWorkspacesWithContext is the same as StopWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See StopWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) StopWorkspacesWithContext(ctx aws.Context, input *StopWorkspacesInput, opts ...request.Option) (*StopWorkspacesOutput, error) {
	req, out := c.StopWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateWorkspaces = "TerminateWorkspaces"

// TerminateWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the TerminateWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateWorkspaces for more information on using the TerminateWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TerminateWorkspacesRequest method.
//    req, resp := client.TerminateWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces
func (c *WorkSpaces) TerminateWorkspacesRequest(input *TerminateWorkspacesInput) (req *request.Request, output *TerminateWorkspacesOutput) {
	op := &request.Operation{
		Name:       opTerminateWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateWorkspacesInput{}
	}

	output = &TerminateWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TerminateWorkspaces API operation for Amazon WorkSpaces.
//
// Terminates the specified WorkSpaces.
//
// Terminating a WorkSpace is a permanent action and cannot be undone. The user's
// data is destroyed. If you need to archive any user data, contact Amazon Web
// Services before terminating the WorkSpace.
//
// You can terminate a WorkSpace that is in any state except SUSPENDED.
//
// This operation is asynchronous and returns before the WorkSpaces have been
// completely terminated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation TerminateWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces
func (c *WorkSpaces) TerminateWorkspaces(input *TerminateWorkspacesInput) (*TerminateWorkspacesOutput, error) {
	req, out := c.TerminateWorkspacesRequest(input)
	return out, req.Send()
}

// TerminateWorkspacesWithContext is the same as TerminateWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) TerminateWorkspacesWithContext(ctx aws.Context, input *TerminateWorkspacesInput, opts ...request.Option) (*TerminateWorkspacesOutput, error) {
	req, out := c.TerminateWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRulesOfIpGroup = "UpdateRulesOfIpGroup"

// UpdateRulesOfIpGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRulesOfIpGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRulesOfIpGroup for more information on using the UpdateRulesOfIpGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRulesOfIpGroupRequest method.
//    req, resp := client.UpdateRulesOfIpGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup
func (c *WorkSpaces) UpdateRulesOfIpGroupRequest(input *UpdateRulesOfIpGroupInput) (req *request.Request, output *UpdateRulesOfIpGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateRulesOfIpGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRulesOfIpGroupInput{}
	}

	output = &UpdateRulesOfIpGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRulesOfIpGroup API operation for Amazon WorkSpaces.
//
// Replaces the current rules of the specified IP access control group with
// the specified rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation UpdateRulesOfIpGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The state of the resource is not valid for this operation.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup
func (c *WorkSpaces) UpdateRulesOfIpGroup(input *UpdateRulesOfIpGroupInput) (*UpdateRulesOfIpGroupOutput, error) {
	req, out := c.UpdateRulesOfIpGroupRequest(input)
	return out, req.Send()
}

// UpdateRulesOfIpGroupWithContext is the same as UpdateRulesOfIpGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRulesOfIpGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) UpdateRulesOfIpGroupWithContext(ctx aws.Context, input *UpdateRulesOfIpGroupInput, opts ...request.Option) (*UpdateRulesOfIpGroupOutput, error) {
	req, out := c.UpdateRulesOfIpGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes a modification to the configuration of bring your own license (BYOL)
// for the specified account.
type AccountModification struct {
	_ struct{} `type:"structure"`

	// The IP address range, specified as an IPv4 CIDR block, for the management
	// network interface used for the account.
	DedicatedTenancyManagementCidrRange *string `type:"string"`

	// The status of BYOL (whether BYOL is being enabled or disabled).
	DedicatedTenancySupport *string `type:"string" enum:"DedicatedTenancySupportResultEnum"`

	// The error code that is returned if the configuration of BYOL cannot be modified.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the configuration of BYOL
	// cannot be modified.
	ErrorMessage *string `type:"string"`

	// The state of the modification to the configuration of BYOL.
	ModificationState *string `type:"string" enum:"DedicatedTenancyModificationStateEnum"`

	// The timestamp when the modification of the BYOL configuration was started.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s AccountModification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountModification) GoString() string {
	return s.String()
}

// SetDedicatedTenancyManagementCidrRange sets the DedicatedTenancyManagementCidrRange field's value.
func (s *AccountModification) SetDedicatedTenancyManagementCidrRange(v string) *AccountModification {
	s.DedicatedTenancyManagementCidrRange = &v
	return s
}

// SetDedicatedTenancySupport sets the DedicatedTenancySupport field's value.
func (s *AccountModification) SetDedicatedTenancySupport(v string) *AccountModification {
	s.DedicatedTenancySupport = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *AccountModification) SetErrorCode(v string) *AccountModification {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *AccountModification) SetErrorMessage(v string) *AccountModification {
	s.ErrorMessage = &v
	return s
}

// SetModificationState sets the ModificationState field's value.
func (s *AccountModification) SetModificationState(v string) *AccountModification {
	s.ModificationState = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AccountModification) SetStartTime(v time.Time) *AccountModification {
	s.StartTime = &v
	return s
}

type AssociateIpGroupsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The identifiers of one or more IP access control groups.
	//
	// GroupIds is a required field
	GroupIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s AssociateIpGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateIpGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateIpGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateIpGroupsInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.GroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *AssociateIpGroupsInput) SetDirectoryId(v string) *AssociateIpGroupsInput {
	s.DirectoryId = &v
	return s
}

// SetGroupIds sets the GroupIds field's value.
func (s *AssociateIpGroupsInput) SetGroupIds(v []*string) *AssociateIpGroupsInput {
	s.GroupIds = v
	return s
}

type AssociateIpGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateIpGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateIpGroupsOutput) GoString() string {
	return s.String()
}

type AuthorizeIpRulesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`

	// The rules to add to the group.
	//
	// UserRules is a required field
	UserRules []*IpRuleItem `type:"list" required:"true"`
}

// String returns the string representation
func (s AuthorizeIpRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeIpRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeIpRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizeIpRulesInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.UserRules == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *AuthorizeIpRulesInput) SetGroupId(v string) *AuthorizeIpRulesInput {
	s.GroupId = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *AuthorizeIpRulesInput) SetUserRules(v []*IpRuleItem) *AuthorizeIpRulesInput {
	s.UserRules = v
	return s
}

type AuthorizeIpRulesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AuthorizeIpRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthorizeIpRulesOutput) GoString() string {
	return s.String()
}

// Describes an Amazon WorkSpaces client.
type ClientProperties struct {
	_ struct{} `type:"structure"`

	// Specifies whether users can cache their credentials on the Amazon WorkSpaces
	// client. When enabled, users can choose to reconnect to their WorkSpaces without
	// re-entering their credentials.
	ReconnectEnabled *string `type:"string" enum:"ReconnectEnum"`
}

// String returns the string representation
func (s ClientProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClientProperties) GoString() string {
	return s.String()
}

// SetReconnectEnabled sets the ReconnectEnabled field's value.
func (s *ClientProperties) SetReconnectEnabled(v string) *ClientProperties {
	s.ReconnectEnabled = &v
	return s
}

// Information about the Amazon WorkSpaces client.
type ClientPropertiesResult struct {
	_ struct{} `type:"structure"`

	// Information about the Amazon WorkSpaces client.
	ClientProperties *ClientProperties `type:"structure"`

	// The resource identifier, in the form of a directory ID.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ClientPropertiesResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClientPropertiesResult) GoString() string {
	return s.String()
}

// SetClientProperties sets the ClientProperties field's value.
func (s *ClientPropertiesResult) SetClientProperties(v *ClientProperties) *ClientPropertiesResult {
	s.ClientProperties = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ClientPropertiesResult) SetResourceId(v string) *ClientPropertiesResult {
	s.ResourceId = &v
	return s
}

// Describes the compute type.
type ComputeType struct {
	_ struct{} `type:"structure"`

	// The compute type.
	Name *string `type:"string" enum:"Compute"`
}

// String returns the string representation
func (s ComputeType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeType) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ComputeType) SetName(v string) *ComputeType {
	s.Name = &v
	return s
}

type CopyWorkspaceImageInput struct {
	_ struct{} `type:"structure"`

	// A description of the image.
	Description *string `min:"1" type:"string"`

	// The name of the image.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The identifier of the source image.
	//
	// SourceImageId is a required field
	SourceImageId *string `type:"string" required:"true"`

	// The identifier of the source Region.
	//
	// SourceRegion is a required field
	SourceRegion *string `min:"1" type:"string" required:"true"`

	// The tags for the image.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CopyWorkspaceImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyWorkspaceImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyWorkspaceImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyWorkspaceImageInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SourceImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceImageId"))
	}
	if s.SourceRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceRegion"))
	}
	if s.SourceRegion != nil && len(*s.SourceRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceRegion", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CopyWorkspaceImageInput) SetDescription(v string) *CopyWorkspaceImageInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CopyWorkspaceImageInput) SetName(v string) *CopyWorkspaceImageInput {
	s.Name = &v
	return s
}

// SetSourceImageId sets the SourceImageId field's value.
func (s *CopyWorkspaceImageInput) SetSourceImageId(v string) *CopyWorkspaceImageInput {
	s.SourceImageId = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *CopyWorkspaceImageInput) SetSourceRegion(v string) *CopyWorkspaceImageInput {
	s.SourceRegion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyWorkspaceImageInput) SetTags(v []*Tag) *CopyWorkspaceImageInput {
	s.Tags = v
	return s
}

type CopyWorkspaceImageOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the image.
	ImageId *string `type:"string"`
}

// String returns the string representation
func (s CopyWorkspaceImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CopyWorkspaceImageOutput) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *CopyWorkspaceImageOutput) SetImageId(v string) *CopyWorkspaceImageOutput {
	s.ImageId = &v
	return s
}

type CreateIpGroupInput struct {
	_ struct{} `type:"structure"`

	// The description of the group.
	GroupDesc *string `type:"string"`

	// The name of the group.
	//
	// GroupName is a required field
	GroupName *string `type:"string" required:"true"`

	// The tags. Each WorkSpaces resource can have a maximum of 50 tags.
	Tags []*Tag `type:"list"`

	// The rules to add to the group.
	UserRules []*IpRuleItem `type:"list"`
}

// String returns the string representation
func (s CreateIpGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIpGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIpGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIpGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupDesc sets the GroupDesc field's value.
func (s *CreateIpGroupInput) SetGroupDesc(v string) *CreateIpGroupInput {
	s.GroupDesc = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateIpGroupInput) SetGroupName(v string) *CreateIpGroupInput {
	s.GroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIpGroupInput) SetTags(v []*Tag) *CreateIpGroupInput {
	s.Tags = v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *CreateIpGroupInput) SetUserRules(v []*IpRuleItem) *CreateIpGroupInput {
	s.UserRules = v
	return s
}

type CreateIpGroupOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	GroupId *string `type:"string"`
}

// String returns the string representation
func (s CreateIpGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIpGroupOutput) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *CreateIpGroupOutput) SetGroupId(v string) *CreateIpGroupOutput {
	s.GroupId = &v
	return s
}

type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpaces resource. The supported resource types are
	// WorkSpaces, registered directories, images, custom bundles, and IP access
	// control groups.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The tags. Each WorkSpaces resource can have a maximum of 50 tags.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateTagsInput) SetResourceId(v string) *CreateTagsInput {
	s.ResourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTagsInput) SetTags(v []*Tag) *CreateTagsInput {
	s.Tags = v
	return s
}

type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

type CreateWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to create. You can specify up to 25 WorkSpaces.
	//
	// Workspaces is a required field
	Workspaces []*WorkspaceRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkspacesInput"}
	if s.Workspaces == nil {
		invalidParams.Add(request.NewErrParamRequired("Workspaces"))
	}
	if s.Workspaces != nil && len(s.Workspaces) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Workspaces", 1))
	}
	if s.Workspaces != nil {
		for i, v := range s.Workspaces {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Workspaces", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaces sets the Workspaces field's value.
func (s *CreateWorkspacesInput) SetWorkspaces(v []*WorkspaceRequest) *CreateWorkspacesInput {
	s.Workspaces = v
	return s
}

type CreateWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be created.
	FailedRequests []*FailedCreateWorkspaceRequest `type:"list"`

	// Information about the WorkSpaces that were created.
	//
	// Because this operation is asynchronous, the identifier returned is not immediately
	// available for use with other operations. For example, if you call DescribeWorkspaces
	// before the WorkSpace is created, the information returned can be incomplete.
	PendingRequests []*Workspace `type:"list"`
}

// String returns the string representation
func (s CreateWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *CreateWorkspacesOutput) SetFailedRequests(v []*FailedCreateWorkspaceRequest) *CreateWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// SetPendingRequests sets the PendingRequests field's value.
func (s *CreateWorkspacesOutput) SetPendingRequests(v []*Workspace) *CreateWorkspacesOutput {
	s.PendingRequests = v
	return s
}

// Describes the default values used to create a WorkSpace.
type DefaultWorkspaceCreationProperties struct {
	_ struct{} `type:"structure"`

	// The identifier of any security groups to apply to WorkSpaces when they are
	// created.
	CustomSecurityGroupId *string `type:"string"`

	// The organizational unit (OU) in the directory for the WorkSpace machine accounts.
	DefaultOu *string `type:"string"`

	// The public IP address to attach to all WorkSpaces that are created or rebuilt.
	EnableInternetAccess *bool `type:"boolean"`

	// Specifies whether the directory is enabled for Amazon WorkDocs.
	EnableWorkDocs *bool `type:"boolean"`

	// Specifies whether the WorkSpace user is an administrator on the WorkSpace.
	UserEnabledAsLocalAdministrator *bool `type:"boolean"`
}

// String returns the string representation
func (s DefaultWorkspaceCreationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultWorkspaceCreationProperties) GoString() string {
	return s.String()
}

// SetCustomSecurityGroupId sets the CustomSecurityGroupId field's value.
func (s *DefaultWorkspaceCreationProperties) SetCustomSecurityGroupId(v string) *DefaultWorkspaceCreationProperties {
	s.CustomSecurityGroupId = &v
	return s
}

// SetDefaultOu sets the DefaultOu field's value.
func (s *DefaultWorkspaceCreationProperties) SetDefaultOu(v string) *DefaultWorkspaceCreationProperties {
	s.DefaultOu = &v
	return s
}

// SetEnableInternetAccess sets the EnableInternetAccess field's value.
func (s *DefaultWorkspaceCreationProperties) SetEnableInternetAccess(v bool) *DefaultWorkspaceCreationProperties {
	s.EnableInternetAccess = &v
	return s
}

// SetEnableWorkDocs sets the EnableWorkDocs field's value.
func (s *DefaultWorkspaceCreationProperties) SetEnableWorkDocs(v bool) *DefaultWorkspaceCreationProperties {
	s.EnableWorkDocs = &v
	return s
}

// SetUserEnabledAsLocalAdministrator sets the UserEnabledAsLocalAdministrator field's value.
func (s *DefaultWorkspaceCreationProperties) SetUserEnabledAsLocalAdministrator(v bool) *DefaultWorkspaceCreationProperties {
	s.UserEnabledAsLocalAdministrator = &v
	return s
}

type DeleteIpGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the IP access control group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIpGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIpGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIpGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIpGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DeleteIpGroupInput) SetGroupId(v string) *DeleteIpGroupInput {
	s.GroupId = &v
	return s
}

type DeleteIpGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIpGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIpGroupOutput) GoString() string {
	return s.String()
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpaces resource. The supported resource types are
	// WorkSpaces, registered directories, images, custom bundles, and IP access
	// control groups.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteTagsInput) SetResourceId(v string) *DeleteTagsInput {
	s.ResourceId = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DeleteTagsInput) SetTagKeys(v []*string) *DeleteTagsInput {
	s.TagKeys = v
	return s
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DeleteWorkspaceImageInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the image.
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWorkspaceImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWorkspaceImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkspaceImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkspaceImageInput"}
	if s.ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageId sets the ImageId field's value.
func (s *DeleteWorkspaceImageInput) SetImageId(v string) *DeleteWorkspaceImageInput {
	s.ImageId = &v
	return s
}

type DeleteWorkspaceImageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteWorkspaceImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWorkspaceImageOutput) GoString() string {
	return s.String()
}

type DescribeAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountInput) GoString() string {
	return s.String()
}

type DescribeAccountModificationsInput struct {
	_ struct{} `type:"structure"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAccountModificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountModificationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountModificationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountModificationsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountModificationsInput) SetNextToken(v string) *DescribeAccountModificationsInput {
	s.NextToken = &v
	return s
}

type DescribeAccountModificationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of modifications to the configuration of BYOL.
	AccountModifications []*AccountModification `type:"list"`

	// The token to use to retrieve the next set of results, or null if no more
	// results are available.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAccountModificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountModificationsOutput) GoString() string {
	return s.String()
}

// SetAccountModifications sets the AccountModifications field's value.
func (s *DescribeAccountModificationsOutput) SetAccountModifications(v []*AccountModification) *DescribeAccountModificationsOutput {
	s.AccountModifications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountModificationsOutput) SetNextToken(v string) *DescribeAccountModificationsOutput {
	s.NextToken = &v
	return s
}

type DescribeAccountOutput struct {
	_ struct{} `type:"structure"`

	// The IP address range, specified as an IPv4 CIDR block, used for the management
	// network interface.
	//
	// The management network interface is connected to a secure Amazon WorkSpaces
	// management network. It is used for interactive streaming of the WorkSpace
	// desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage
	// the WorkSpace.
	DedicatedTenancyManagementCidrRange *string `type:"string"`

	// The status of BYOL (whether BYOL is enabled or disabled).
	DedicatedTenancySupport *string `type:"string" enum:"DedicatedTenancySupportResultEnum"`
}

// String returns the string representation
func (s DescribeAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountOutput) GoString() string {
	return s.String()
}

// SetDedicatedTenancyManagementCidrRange sets the DedicatedTenancyManagementCidrRange field's value.
func (s *DescribeAccountOutput) SetDedicatedTenancyManagementCidrRange(v string) *DescribeAccountOutput {
	s.DedicatedTenancyManagementCidrRange = &v
	return s
}

// SetDedicatedTenancySupport sets the DedicatedTenancySupport field's value.
func (s *DescribeAccountOutput) SetDedicatedTenancySupport(v string) *DescribeAccountOutput {
	s.DedicatedTenancySupport = &v
	return s
}

type DescribeClientPropertiesInput struct {
	_ struct{} `type:"structure"`

	// The resource identifier, in the form of directory IDs.
	//
	// ResourceIds is a required field
	ResourceIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeClientPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClientPropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClientPropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClientPropertiesInput"}
	if s.ResourceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIds"))
	}
	if s.ResourceIds != nil && len(s.ResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceIds sets the ResourceIds field's value.
func (s *DescribeClientPropertiesInput) SetResourceIds(v []*string) *DescribeClientPropertiesInput {
	s.ResourceIds = v
	return s
}

type DescribeClientPropertiesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified Amazon WorkSpaces clients.
	ClientPropertiesList []*ClientPropertiesResult `type:"list"`
}

// String returns the string representation
func (s DescribeClientPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClientPropertiesOutput) GoString() string {
	return s.String()
}

// SetClientPropertiesList sets the ClientPropertiesList field's value.
func (s *DescribeClientPropertiesOutput) SetClientPropertiesList(v []*ClientPropertiesResult) *DescribeClientPropertiesOutput {
	s.ClientPropertiesList = v
	return s
}

type DescribeIpGroupsInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of one or more IP access control groups.
	GroupIds []*string `type:"list"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeIpGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIpGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIpGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIpGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupIds sets the GroupIds field's value.
func (s *DescribeIpGroupsInput) SetGroupIds(v []*string) *DescribeIpGroupsInput {
	s.GroupIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeIpGroupsInput) SetMaxResults(v int64) *DescribeIpGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeIpGroupsInput) SetNextToken(v string) *DescribeIpGroupsInput {
	s.NextToken = &v
	return s
}

type DescribeIpGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results, or null if no more
	// results are available.
	NextToken *string `min:"1" type:"string"`

	// Information about the IP access control groups.
	Result []*IpGroup `type:"list"`
}

// String returns the string representation
func (s DescribeIpGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeIpGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeIpGroupsOutput) SetNextToken(v string) *DescribeIpGroupsOutput {
	s.NextToken = &v
	return s
}

// SetResult sets the Result field's value.
func (s *DescribeIpGroupsOutput) SetResult(v []*IpGroup) *DescribeIpGroupsOutput {
	s.Result = v
	return s
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpaces resource. The supported resource types are
	// WorkSpaces, registered directories, images, custom bundles, and IP access
	// control groups.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeTagsInput) SetResourceId(v string) *DescribeTagsInput {
	s.ResourceId = &v
	return s
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// The tags.
	TagList []*Tag `type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *DescribeTagsOutput) SetTagList(v []*Tag) *DescribeTagsOutput {
	s.TagList = v
	return s
}

type DescribeWorkspaceBundlesInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of the bundles. You cannot combine this parameter with any
	// other filter.
	BundleIds []*string `min:"1" type:"list"`

	// The token for the next set of results. (You received this token from a previous
	// call.)
	NextToken *string `min:"1" type:"string"`

	// The owner of the bundles. You cannot combine this parameter with any other
	// filter.
	//
	// Specify AMAZON to describe the bundles provided by AWS or null to describe
	// the bundles that belong to your account.
	Owner *string `type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceBundlesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspaceBundlesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceBundlesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceBundlesInput"}
	if s.BundleIds != nil && len(s.BundleIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BundleIds", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleIds sets the BundleIds field's value.
func (s *DescribeWorkspaceBundlesInput) SetBundleIds(v []*string) *DescribeWorkspaceBundlesInput {
	s.BundleIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceBundlesInput) SetNextToken(v string) *DescribeWorkspaceBundlesInput {
	s.NextToken = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *DescribeWorkspaceBundlesInput) SetOwner(v string) *DescribeWorkspaceBundlesInput {
	s.Owner = &v
	return s
}

type DescribeWorkspaceBundlesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the bundles.
	Bundles []*WorkspaceBundle `type:"list"`

	// The token to use to retrieve the next set of results, or null if there are
	// no more results available. This token is valid for one day and must be used
	// within that time frame.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceBundlesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspaceBundlesOutput) GoString() string {
	return s.String()
}

// SetBundles sets the Bundles field's value.
func (s *DescribeWorkspaceBundlesOutput) SetBundles(v []*WorkspaceBundle) *DescribeWorkspaceBundlesOutput {
	s.Bundles = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceBundlesOutput) SetNextToken(v string) *DescribeWorkspaceBundlesOutput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceDirectoriesInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of the directories. If the value is null, all directories
	// are retrieved.
	DirectoryIds []*string `min:"1" type:"list"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceDirectoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspaceDirectoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceDirectoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceDirectoriesInput"}
	if s.DirectoryIds != nil && len(s.DirectoryIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryIds", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryIds sets the DirectoryIds field's value.
func (s *DescribeWorkspaceDirectoriesInput) SetDirectoryIds(v []*string) *DescribeWorkspaceDirectoriesInput {
	s.DirectoryIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceDirectoriesInput) SetNextToken(v string) *DescribeWorkspaceDirectoriesInput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceDirectoriesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the directories.
	Directories []*WorkspaceDirectory `type:"list"`

	// The token to use to retrieve the next set of results, or null if no more
	// results are available.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceDirectoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspaceDirectoriesOutput) GoString() string {
	return s.String()
}

// SetDirectories sets the Directories field's value.
func (s *DescribeWorkspaceDirectoriesOutput) SetDirectories(v []*WorkspaceDirectory) *DescribeWorkspaceDirectoriesOutput {
	s.Directories = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceDirectoriesOutput) SetNextToken(v string) *DescribeWorkspaceDirectoriesOutput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceImagesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the image.
	ImageIds []*string `min:"1" type:"list"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspaceImagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceImagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceImagesInput"}
	if s.ImageIds != nil && len(s.ImageIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageIds", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageIds sets the ImageIds field's value.
func (s *DescribeWorkspaceImagesInput) SetImageIds(v []*string) *DescribeWorkspaceImagesInput {
	s.ImageIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeWorkspaceImagesInput) SetMaxResults(v int64) *DescribeWorkspaceImagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceImagesInput) SetNextToken(v string) *DescribeWorkspaceImagesInput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceImagesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the images.
	Images []*WorkspaceImage `type:"list"`

	// The token to use to retrieve the next set of results, or null if no more
	// results are available.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspaceImagesOutput) GoString() string {
	return s.String()
}

// SetImages sets the Images field's value.
func (s *DescribeWorkspaceImagesOutput) SetImages(v []*WorkspaceImage) *DescribeWorkspaceImagesOutput {
	s.Images = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceImagesOutput) SetNextToken(v string) *DescribeWorkspaceImagesOutput {
	s.NextToken = &v
	return s
}

type DescribeWorkspacesConnectionStatusInput struct {
	_ struct{} `type:"structure"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.
	WorkspaceIds []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeWorkspacesConnectionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspacesConnectionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspacesConnectionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspacesConnectionStatusInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.WorkspaceIds != nil && len(s.WorkspaceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesConnectionStatusInput) SetNextToken(v string) *DescribeWorkspacesConnectionStatusInput {
	s.NextToken = &v
	return s
}

// SetWorkspaceIds sets the WorkspaceIds field's value.
func (s *DescribeWorkspacesConnectionStatusInput) SetWorkspaceIds(v []*string) *DescribeWorkspacesConnectionStatusInput {
	s.WorkspaceIds = v
	return s
}

type DescribeWorkspacesConnectionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results, or null if no more
	// results are available.
	NextToken *string `min:"1" type:"string"`

	// Information about the connection status of the WorkSpace.
	WorkspacesConnectionStatus []*WorkspaceConnectionStatus `type:"list"`
}

// String returns the string representation
func (s DescribeWorkspacesConnectionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspacesConnectionStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesConnectionStatusOutput) SetNextToken(v string) *DescribeWorkspacesConnectionStatusOutput {
	s.NextToken = &v
	return s
}

// SetWorkspacesConnectionStatus sets the WorkspacesConnectionStatus field's value.
func (s *DescribeWorkspacesConnectionStatusOutput) SetWorkspacesConnectionStatus(v []*WorkspaceConnectionStatus) *DescribeWorkspacesConnectionStatusOutput {
	s.WorkspacesConnectionStatus = v
	return s
}

type DescribeWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle. All WorkSpaces that are created from this bundle
	// are retrieved. You cannot combine this parameter with any other filter.
	BundleId *string `type:"string"`

	// The identifier of the directory. In addition, you can optionally specify
	// a specific directory user (see UserName). You cannot combine this parameter
	// with any other filter.
	DirectoryId *string `type:"string"`

	// The maximum number of items to return.
	Limit *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The name of the directory user. You must specify this parameter with DirectoryId.
	UserName *string `min:"1" type:"string"`

	// The identifiers of the WorkSpaces. You cannot combine this parameter with
	// any other filter.
	//
	// Because the CreateWorkspaces operation is asynchronous, the identifier it
	// returns is not immediately available. If you immediately call DescribeWorkspaces
	// with this identifier, no information is returned.
	WorkspaceIds []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspacesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.WorkspaceIds != nil && len(s.WorkspaceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *DescribeWorkspacesInput) SetBundleId(v string) *DescribeWorkspacesInput {
	s.BundleId = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DescribeWorkspacesInput) SetDirectoryId(v string) *DescribeWorkspacesInput {
	s.DirectoryId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeWorkspacesInput) SetLimit(v int64) *DescribeWorkspacesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesInput) SetNextToken(v string) *DescribeWorkspacesInput {
	s.NextToken = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribeWorkspacesInput) SetUserName(v string) *DescribeWorkspacesInput {
	s.UserName = &v
	return s
}

// SetWorkspaceIds sets the WorkspaceIds field's value.
func (s *DescribeWorkspacesInput) SetWorkspaceIds(v []*string) *DescribeWorkspacesInput {
	s.WorkspaceIds = v
	return s
}

type DescribeWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next set of results, or null if no more
	// results are available.
	NextToken *string `min:"1" type:"string"`

	// Information about the WorkSpaces.
	//
	// Because CreateWorkspaces is an asynchronous operation, some of the returned
	// information could be incomplete.
	Workspaces []*Workspace `type:"list"`
}

// String returns the string representation
func (s DescribeWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspacesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesOutput) SetNextToken(v string) *DescribeWorkspacesOutput {
	s.NextToken = &v
	return s
}

// SetWorkspaces sets the Workspaces field's value.
func (s *DescribeWorkspacesOutput) SetWorkspaces(v []*Workspace) *DescribeWorkspacesOutput {
	s.Workspaces = v
	return s
}

type DisassociateIpGroupsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The identifiers of one or more IP access control groups.
	//
	// GroupIds is a required field
	GroupIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DisassociateIpGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateIpGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateIpGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateIpGroupsInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.GroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DisassociateIpGroupsInput) SetDirectoryId(v string) *DisassociateIpGroupsInput {
	s.DirectoryId = &v
	return s
}

// SetGroupIds sets the GroupIds field's value.
func (s *DisassociateIpGroupsInput) SetGroupIds(v []*string) *DisassociateIpGroupsInput {
	s.GroupIds = v
	return s
}

type DisassociateIpGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateIpGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateIpGroupsOutput) GoString() string {
	return s.String()
}

// Describes a WorkSpace that cannot be created.
type FailedCreateWorkspaceRequest struct {
	_ struct{} `type:"structure"`

	// The error code that is returned if the WorkSpace cannot be created.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the WorkSpace cannot be
	// created.
	ErrorMessage *string `type:"string"`

	// Information about the WorkSpace.
	WorkspaceRequest *WorkspaceRequest `type:"structure"`
}

// String returns the string representation
func (s FailedCreateWorkspaceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedCreateWorkspaceRequest) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedCreateWorkspaceRequest) SetErrorCode(v string) *FailedCreateWorkspaceRequest {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedCreateWorkspaceRequest) SetErrorMessage(v string) *FailedCreateWorkspaceRequest {
	s.ErrorMessage = &v
	return s
}

// SetWorkspaceRequest sets the WorkspaceRequest field's value.
func (s *FailedCreateWorkspaceRequest) SetWorkspaceRequest(v *WorkspaceRequest) *FailedCreateWorkspaceRequest {
	s.WorkspaceRequest = v
	return s
}

// Describes a WorkSpace that could not be rebooted. (RebootWorkspaces), rebuilt
// (RebuildWorkspaces), terminated (TerminateWorkspaces), started (StartWorkspaces),
// or stopped (StopWorkspaces).
type FailedWorkspaceChangeRequest struct {
	_ struct{} `type:"structure"`

	// The error code that is returned if the WorkSpace cannot be rebooted.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the WorkSpace cannot be
	// rebooted.
	ErrorMessage *string `type:"string"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s FailedWorkspaceChangeRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedWorkspaceChangeRequest) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedWorkspaceChangeRequest) SetErrorCode(v string) *FailedWorkspaceChangeRequest {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedWorkspaceChangeRequest) SetErrorMessage(v string) *FailedWorkspaceChangeRequest {
	s.ErrorMessage = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *FailedWorkspaceChangeRequest) SetWorkspaceId(v string) *FailedWorkspaceChangeRequest {
	s.WorkspaceId = &v
	return s
}

type ImportWorkspaceImageInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the EC2 image.
	//
	// Ec2ImageId is a required field
	Ec2ImageId *string `type:"string" required:"true"`

	// The description of the WorkSpace image.
	//
	// ImageDescription is a required field
	ImageDescription *string `min:"1" type:"string" required:"true"`

	// The name of the WorkSpace image.
	//
	// ImageName is a required field
	ImageName *string `min:"1" type:"string" required:"true"`

	// The ingestion process to be used when importing the image.
	//
	// IngestionProcess is a required field
	IngestionProcess *string `type:"string" required:"true" enum:"WorkspaceImageIngestionProcess"`

	// The tags. Each WorkSpaces resource can have a maximum of 50 tags.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ImportWorkspaceImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportWorkspaceImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportWorkspaceImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportWorkspaceImageInput"}
	if s.Ec2ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("Ec2ImageId"))
	}
	if s.ImageDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageDescription"))
	}
	if s.ImageDescription != nil && len(*s.ImageDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageDescription", 1))
	}
	if s.ImageName == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageName"))
	}
	if s.ImageName != nil && len(*s.ImageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageName", 1))
	}
	if s.IngestionProcess == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionProcess"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEc2ImageId sets the Ec2ImageId field's value.
func (s *ImportWorkspaceImageInput) SetEc2ImageId(v string) *ImportWorkspaceImageInput {
	s.Ec2ImageId = &v
	return s
}

// SetImageDescription sets the ImageDescription field's value.
func (s *ImportWorkspaceImageInput) SetImageDescription(v string) *ImportWorkspaceImageInput {
	s.ImageDescription = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *ImportWorkspaceImageInput) SetImageName(v string) *ImportWorkspaceImageInput {
	s.ImageName = &v
	return s
}

// SetIngestionProcess sets the IngestionProcess field's value.
func (s *ImportWorkspaceImageInput) SetIngestionProcess(v string) *ImportWorkspaceImageInput {
	s.IngestionProcess = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportWorkspaceImageInput) SetTags(v []*Tag) *ImportWorkspaceImageInput {
	s.Tags = v
	return s
}

type ImportWorkspaceImageOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace image.
	ImageId *string `type:"string"`
}

// String returns the string representation
func (s ImportWorkspaceImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportWorkspaceImageOutput) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *ImportWorkspaceImageOutput) SetImageId(v string) *ImportWorkspaceImageOutput {
	s.ImageId = &v
	return s
}

// Describes an IP access control group.
type IpGroup struct {
	_ struct{} `type:"structure"`

	// The description of the group.
	GroupDesc *string `locationName:"groupDesc" type:"string"`

	// The identifier of the group.
	GroupId *string `locationName:"groupId" type:"string"`

	// The name of the group.
	GroupName *string `locationName:"groupName" type:"string"`

	// The rules.
	UserRules []*IpRuleItem `locationName:"userRules" type:"list"`
}

// String returns the string representation
func (s IpGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpGroup) GoString() string {
	return s.String()
}

// SetGroupDesc sets the GroupDesc field's value.
func (s *IpGroup) SetGroupDesc(v string) *IpGroup {
	s.GroupDesc = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *IpGroup) SetGroupId(v string) *IpGroup {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *IpGroup) SetGroupName(v string) *IpGroup {
	s.GroupName = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *IpGroup) SetUserRules(v []*IpRuleItem) *IpGroup {
	s.UserRules = v
	return s
}

// Describes a rule for an IP access control group.
type IpRuleItem struct {
	_ struct{} `type:"structure"`

	// The IP address range, in CIDR notation.
	IpRule *string `locationName:"ipRule" type:"string"`

	// The description.
	RuleDesc *string `locationName:"ruleDesc" type:"string"`
}

// String returns the string representation
func (s IpRuleItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpRuleItem) GoString() string {
	return s.String()
}

// SetIpRule sets the IpRule field's value.
func (s *IpRuleItem) SetIpRule(v string) *IpRuleItem {
	s.IpRule = &v
	return s
}

// SetRuleDesc sets the RuleDesc field's value.
func (s *IpRuleItem) SetRuleDesc(v string) *IpRuleItem {
	s.RuleDesc = &v
	return s
}

type ListAvailableManagementCidrRangesInput struct {
	_ struct{} `type:"structure"`

	// The IP address range to search. Specify an IP address range that is compatible
	// with your network and in CIDR notation (that is, specify the range as an
	// IPv4 CIDR block).
	//
	// ManagementCidrRangeConstraint is a required field
	ManagementCidrRangeConstraint *string `type:"string" required:"true"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAvailableManagementCidrRangesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableManagementCidrRangesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAvailableManagementCidrRangesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAvailableManagementCidrRangesInput"}
	if s.ManagementCidrRangeConstraint == nil {
		invalidParams.Add(request.NewErrParamRequired("ManagementCidrRangeConstraint"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetManagementCidrRangeConstraint sets the ManagementCidrRangeConstraint field's value.
func (s *ListAvailableManagementCidrRangesInput) SetManagementCidrRangeConstraint(v string) *ListAvailableManagementCidrRangesInput {
	s.ManagementCidrRangeConstraint = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAvailableManagementCidrRangesInput) SetMaxResults(v int64) *ListAvailableManagementCidrRangesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAvailableManagementCidrRangesInput) SetNextToken(v string) *ListAvailableManagementCidrRangesInput {
	s.NextToken = &v
	return s
}

type ListAvailableManagementCidrRangesOutput struct {
	_ struct{} `type:"structure"`

	// The list of available IP address ranges, specified as IPv4 CIDR blocks.
	ManagementCidrRanges []*string `type:"list"`

	// The token to use to retrieve the next set of results, or null if no more
	// results are available.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAvailableManagementCidrRangesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableManagementCidrRangesOutput) GoString() string {
	return s.String()
}

// SetManagementCidrRanges sets the ManagementCidrRanges field's value.
func (s *ListAvailableManagementCidrRangesOutput) SetManagementCidrRanges(v []*string) *ListAvailableManagementCidrRangesOutput {
	s.ManagementCidrRanges = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAvailableManagementCidrRangesOutput) SetNextToken(v string) *ListAvailableManagementCidrRangesOutput {
	s.NextToken = &v
	return s
}

// Describes a WorkSpace modification.
type ModificationState struct {
	_ struct{} `type:"structure"`

	// The resource.
	Resource *string `type:"string" enum:"ModificationResourceEnum"`

	// The modification state.
	State *string `type:"string" enum:"ModificationStateEnum"`
}

// String returns the string representation
func (s ModificationState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModificationState) GoString() string {
	return s.String()
}

// SetResource sets the Resource field's value.
func (s *ModificationState) SetResource(v string) *ModificationState {
	s.Resource = &v
	return s
}

// SetState sets the State field's value.
func (s *ModificationState) SetState(v string) *ModificationState {
	s.State = &v
	return s
}

type ModifyAccountInput struct {
	_ struct{} `type:"structure"`

	// The IP address range, specified as an IPv4 CIDR block, for the management
	// network interface. Specify an IP address range that is compatible with your
	// network and in CIDR notation (that is, specify the range as an IPv4 CIDR
	// block). The CIDR block size must be /16 (for example, 203.0.113.25/16). It
	// must also be specified as available by the ListAvailableManagementCidrRanges
	// operation.
	DedicatedTenancyManagementCidrRange *string `type:"string"`

	// The status of BYOL.
	DedicatedTenancySupport *string `type:"string" enum:"DedicatedTenancySupportEnum"`
}

// String returns the string representation
func (s ModifyAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyAccountInput) GoString() string {
	return s.String()
}

// SetDedicatedTenancyManagementCidrRange sets the DedicatedTenancyManagementCidrRange field's value.
func (s *ModifyAccountInput) SetDedicatedTenancyManagementCidrRange(v string) *ModifyAccountInput {
	s.DedicatedTenancyManagementCidrRange = &v
	return s
}

// SetDedicatedTenancySupport sets the DedicatedTenancySupport field's value.
func (s *ModifyAccountInput) SetDedicatedTenancySupport(v string) *ModifyAccountInput {
	s.DedicatedTenancySupport = &v
	return s
}

type ModifyAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyAccountOutput) GoString() string {
	return s.String()
}

type ModifyClientPropertiesInput struct {
	_ struct{} `type:"structure"`

	// Information about the Amazon WorkSpaces client.
	//
	// ClientProperties is a required field
	ClientProperties *ClientProperties `type:"structure" required:"true"`

	// The resource identifiers, in the form of directory IDs.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyClientPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClientPropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClientPropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClientPropertiesInput"}
	if s.ClientProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientProperties"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientProperties sets the ClientProperties field's value.
func (s *ModifyClientPropertiesInput) SetClientProperties(v *ClientProperties) *ModifyClientPropertiesInput {
	s.ClientProperties = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ModifyClientPropertiesInput) SetResourceId(v string) *ModifyClientPropertiesInput {
	s.ResourceId = &v
	return s
}

type ModifyClientPropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyClientPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyClientPropertiesOutput) GoString() string {
	return s.String()
}

type ModifyWorkspacePropertiesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`

	// The properties of the WorkSpace.
	//
	// WorkspaceProperties is a required field
	WorkspaceProperties *WorkspaceProperties `type:"structure" required:"true"`
}

// String returns the string representation
func (s ModifyWorkspacePropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyWorkspacePropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyWorkspacePropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyWorkspacePropertiesInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceProperties"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ModifyWorkspacePropertiesInput) SetWorkspaceId(v string) *ModifyWorkspacePropertiesInput {
	s.WorkspaceId = &v
	return s
}

// SetWorkspaceProperties sets the WorkspaceProperties field's value.
func (s *ModifyWorkspacePropertiesInput) SetWorkspaceProperties(v *WorkspaceProperties) *ModifyWorkspacePropertiesInput {
	s.WorkspaceProperties = v
	return s
}

type ModifyWorkspacePropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyWorkspacePropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyWorkspacePropertiesOutput) GoString() string {
	return s.String()
}

type ModifyWorkspaceStateInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`

	// The WorkSpace state.
	//
	// WorkspaceState is a required field
	WorkspaceState *string `type:"string" required:"true" enum:"TargetWorkspaceState"`
}

// String returns the string representation
func (s ModifyWorkspaceStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyWorkspaceStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyWorkspaceStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyWorkspaceStateInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceState == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceState"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ModifyWorkspaceStateInput) SetWorkspaceId(v string) *ModifyWorkspaceStateInput {
	s.WorkspaceId = &v
	return s
}

// SetWorkspaceState sets the WorkspaceState field's value.
func (s *ModifyWorkspaceStateInput) SetWorkspaceState(v string) *ModifyWorkspaceStateInput {
	s.WorkspaceState = &v
	return s
}

type ModifyWorkspaceStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyWorkspaceStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyWorkspaceStateOutput) GoString() string {
	return s.String()
}

// The operating system that the image is running.
type OperatingSystem struct {
	_ struct{} `type:"structure"`

	// The operating system.
	Type *string `type:"string" enum:"OperatingSystemType"`
}

// String returns the string representation
func (s OperatingSystem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OperatingSystem) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *OperatingSystem) SetType(v string) *OperatingSystem {
	s.Type = &v
	return s
}

// Describes the information used to reboot a WorkSpace.
type RebootRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebootRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootRequest"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *RebootRequest) SetWorkspaceId(v string) *RebootRequest {
	s.WorkspaceId = &v
	return s
}

type RebootWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.
	//
	// RebootWorkspaceRequests is a required field
	RebootWorkspaceRequests []*RebootRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RebootWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootWorkspacesInput"}
	if s.RebootWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("RebootWorkspaceRequests"))
	}
	if s.RebootWorkspaceRequests != nil && len(s.RebootWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RebootWorkspaceRequests", 1))
	}
	if s.RebootWorkspaceRequests != nil {
		for i, v := range s.RebootWorkspaceRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RebootWorkspaceRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRebootWorkspaceRequests sets the RebootWorkspaceRequests field's value.
func (s *RebootWorkspacesInput) SetRebootWorkspaceRequests(v []*RebootRequest) *RebootWorkspacesInput {
	s.RebootWorkspaceRequests = v
	return s
}

type RebootWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be rebooted.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s RebootWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *RebootWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *RebootWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// Describes the information used to rebuild a WorkSpace.
type RebuildRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebuildRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebuildRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebuildRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebuildRequest"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *RebuildRequest) SetWorkspaceId(v string) *RebuildRequest {
	s.WorkspaceId = &v
	return s
}

type RebuildWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpace to rebuild. You can specify a single WorkSpace.
	//
	// RebuildWorkspaceRequests is a required field
	RebuildWorkspaceRequests []*RebuildRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RebuildWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebuildWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebuildWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebuildWorkspacesInput"}
	if s.RebuildWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("RebuildWorkspaceRequests"))
	}
	if s.RebuildWorkspaceRequests != nil && len(s.RebuildWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RebuildWorkspaceRequests", 1))
	}
	if s.RebuildWorkspaceRequests != nil {
		for i, v := range s.RebuildWorkspaceRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RebuildWorkspaceRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRebuildWorkspaceRequests sets the RebuildWorkspaceRequests field's value.
func (s *RebuildWorkspacesInput) SetRebuildWorkspaceRequests(v []*RebuildRequest) *RebuildWorkspacesInput {
	s.RebuildWorkspaceRequests = v
	return s
}

type RebuildWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpace that could not be rebuilt.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s RebuildWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebuildWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *RebuildWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *RebuildWorkspacesOutput {
	s.FailedRequests = v
	return s
}

type RevokeIpRulesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`

	// The rules to remove from the group.
	//
	// UserRules is a required field
	UserRules []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RevokeIpRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeIpRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeIpRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeIpRulesInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.UserRules == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *RevokeIpRulesInput) SetGroupId(v string) *RevokeIpRulesInput {
	s.GroupId = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *RevokeIpRulesInput) SetUserRules(v []*string) *RevokeIpRulesInput {
	s.UserRules = v
	return s
}

type RevokeIpRulesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokeIpRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeIpRulesOutput) GoString() string {
	return s.String()
}

// Describes the root volume for a WorkSpace bundle.
type RootStorage struct {
	_ struct{} `type:"structure"`

	// The size of the root volume.
	Capacity *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RootStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RootStorage) GoString() string {
	return s.String()
}

// SetCapacity sets the Capacity field's value.
func (s *RootStorage) SetCapacity(v string) *RootStorage {
	s.Capacity = &v
	return s
}

// Information used to start a WorkSpace.
type StartRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s StartRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartRequest) GoString() string {
	return s.String()
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *StartRequest) SetWorkspaceId(v string) *StartRequest {
	s.WorkspaceId = &v
	return s
}

type StartWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to start. You can specify up to 25 WorkSpaces.
	//
	// StartWorkspaceRequests is a required field
	StartWorkspaceRequests []*StartRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s StartWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartWorkspacesInput"}
	if s.StartWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("StartWorkspaceRequests"))
	}
	if s.StartWorkspaceRequests != nil && len(s.StartWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartWorkspaceRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStartWorkspaceRequests sets the StartWorkspaceRequests field's value.
func (s *StartWorkspacesInput) SetStartWorkspaceRequests(v []*StartRequest) *StartWorkspacesInput {
	s.StartWorkspaceRequests = v
	return s
}

type StartWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be started.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s StartWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *StartWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *StartWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// Describes the information used to stop a WorkSpace.
type StopRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s StopRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopRequest) GoString() string {
	return s.String()
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *StopRequest) SetWorkspaceId(v string) *StopRequest {
	s.WorkspaceId = &v
	return s
}

type StopWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to stop. You can specify up to 25 WorkSpaces.
	//
	// StopWorkspaceRequests is a required field
	StopWorkspaceRequests []*StopRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s StopWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopWorkspacesInput"}
	if s.StopWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("StopWorkspaceRequests"))
	}
	if s.StopWorkspaceRequests != nil && len(s.StopWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StopWorkspaceRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStopWorkspaceRequests sets the StopWorkspaceRequests field's value.
func (s *StopWorkspacesInput) SetStopWorkspaceRequests(v []*StopRequest) *StopWorkspacesInput {
	s.StopWorkspaceRequests = v
	return s
}

type StopWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be stopped.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s StopWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *StopWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *StopWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// Describes a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Describes the information used to terminate a WorkSpace.
type TerminateRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TerminateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateRequest"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *TerminateRequest) SetWorkspaceId(v string) *TerminateRequest {
	s.WorkspaceId = &v
	return s
}

type TerminateWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.
	//
	// TerminateWorkspaceRequests is a required field
	TerminateWorkspaceRequests []*TerminateRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TerminateWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateWorkspacesInput"}
	if s.TerminateWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("TerminateWorkspaceRequests"))
	}
	if s.TerminateWorkspaceRequests != nil && len(s.TerminateWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TerminateWorkspaceRequests", 1))
	}
	if s.TerminateWorkspaceRequests != nil {
		for i, v := range s.TerminateWorkspaceRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TerminateWorkspaceRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTerminateWorkspaceRequests sets the TerminateWorkspaceRequests field's value.
func (s *TerminateWorkspacesInput) SetTerminateWorkspaceRequests(v []*TerminateRequest) *TerminateWorkspacesInput {
	s.TerminateWorkspaceRequests = v
	return s
}

type TerminateWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be terminated.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s TerminateWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *TerminateWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *TerminateWorkspacesOutput {
	s.FailedRequests = v
	return s
}

type UpdateRulesOfIpGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`

	// One or more rules.
	//
	// UserRules is a required field
	UserRules []*IpRuleItem `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateRulesOfIpGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRulesOfIpGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRulesOfIpGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRulesOfIpGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.UserRules == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *UpdateRulesOfIpGroupInput) SetGroupId(v string) *UpdateRulesOfIpGroupInput {
	s.GroupId = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *UpdateRulesOfIpGroupInput) SetUserRules(v []*IpRuleItem) *UpdateRulesOfIpGroupInput {
	s.UserRules = v
	return s
}

type UpdateRulesOfIpGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRulesOfIpGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRulesOfIpGroupOutput) GoString() string {
	return s.String()
}

// Describes the user storage for a WorkSpace bundle.
type UserStorage struct {
	_ struct{} `type:"structure"`

	// The size of the user storage.
	Capacity *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserStorage) GoString() string {
	return s.String()
}

// SetCapacity sets the Capacity field's value.
func (s *UserStorage) SetCapacity(v string) *UserStorage {
	s.Capacity = &v
	return s
}

// Describes a WorkSpace.
type Workspace struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle used to create the WorkSpace.
	BundleId *string `type:"string"`

	// The name of the WorkSpace, as seen by the operating system.
	ComputerName *string `type:"string"`

	// The identifier of the AWS Directory Service directory for the WorkSpace.
	DirectoryId *string `type:"string"`

	// The error code that is returned if the WorkSpace cannot be created.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the WorkSpace cannot be
	// created.
	ErrorMessage *string `type:"string"`

	// The IP address of the WorkSpace.
	IpAddress *string `type:"string"`

	// The modification states of the WorkSpace.
	ModificationStates []*ModificationState `type:"list"`

	// Indicates whether the data stored on the root volume is encrypted.
	RootVolumeEncryptionEnabled *bool `type:"boolean"`

	// The operational state of the WorkSpace.
	State *string `type:"string" enum:"WorkspaceState"`

	// The identifier of the subnet for the WorkSpace.
	SubnetId *string `type:"string"`

	// The user for the WorkSpace.
	UserName *string `min:"1" type:"string"`

	// Indicates whether the data stored on the user volume is encrypted.
	UserVolumeEncryptionEnabled *bool `type:"boolean"`

	// The KMS key used to encrypt data stored on your WorkSpace.
	VolumeEncryptionKey *string `type:"string"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`

	// The properties of the WorkSpace.
	WorkspaceProperties *WorkspaceProperties `type:"structure"`
}

// String returns the string representation
func (s Workspace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Workspace) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *Workspace) SetBundleId(v string) *Workspace {
	s.BundleId = &v
	return s
}

// SetComputerName sets the ComputerName field's value.
func (s *Workspace) SetComputerName(v string) *Workspace {
	s.ComputerName = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *Workspace) SetDirectoryId(v string) *Workspace {
	s.DirectoryId = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Workspace) SetErrorCode(v string) *Workspace {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *Workspace) SetErrorMessage(v string) *Workspace {
	s.ErrorMessage = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *Workspace) SetIpAddress(v string) *Workspace {
	s.IpAddress = &v
	return s
}

// SetModificationStates sets the ModificationStates field's value.
func (s *Workspace) SetModificationStates(v []*ModificationState) *Workspace {
	s.ModificationStates = v
	return s
}

// SetRootVolumeEncryptionEnabled sets the RootVolumeEncryptionEnabled field's value.
func (s *Workspace) SetRootVolumeEncryptionEnabled(v bool) *Workspace {
	s.RootVolumeEncryptionEnabled = &v
	return s
}

// SetState sets the State field's value.
func (s *Workspace) SetState(v string) *Workspace {
	s.State = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *Workspace) SetSubnetId(v string) *Workspace {
	s.SubnetId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *Workspace) SetUserName(v string) *Workspace {
	s.UserName = &v
	return s
}

// SetUserVolumeEncryptionEnabled sets the UserVolumeEncryptionEnabled field's value.
func (s *Workspace) SetUserVolumeEncryptionEnabled(v bool) *Workspace {
	s.UserVolumeEncryptionEnabled = &v
	return s
}

// SetVolumeEncryptionKey sets the VolumeEncryptionKey field's value.
func (s *Workspace) SetVolumeEncryptionKey(v string) *Workspace {
	s.VolumeEncryptionKey = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *Workspace) SetWorkspaceId(v string) *Workspace {
	s.WorkspaceId = &v
	return s
}

// SetWorkspaceProperties sets the WorkspaceProperties field's value.
func (s *Workspace) SetWorkspaceProperties(v *WorkspaceProperties) *Workspace {
	s.WorkspaceProperties = v
	return s
}

// Describes a WorkSpace bundle.
type WorkspaceBundle struct {
	_ struct{} `type:"structure"`

	// The bundle identifier.
	BundleId *string `type:"string"`

	// The compute type. For more information, see Amazon WorkSpaces Bundles (http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles).
	ComputeType *ComputeType `type:"structure"`

	// A description.
	Description *string `type:"string"`

	// The name of the bundle.
	Name *string `min:"1" type:"string"`

	// The owner of the bundle. This is the account identifier of the owner, or
	// AMAZON if the bundle is provided by AWS.
	Owner *string `type:"string"`

	// The size of the root volume.
	RootStorage *RootStorage `type:"structure"`

	// The size of the user storage.
	UserStorage *UserStorage `type:"structure"`
}

// String returns the string representation
func (s WorkspaceBundle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceBundle) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *WorkspaceBundle) SetBundleId(v string) *WorkspaceBundle {
	s.BundleId = &v
	return s
}

// SetComputeType sets the ComputeType field's value.
func (s *WorkspaceBundle) SetComputeType(v *ComputeType) *WorkspaceBundle {
	s.ComputeType = v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkspaceBundle) SetDescription(v string) *WorkspaceBundle {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkspaceBundle) SetName(v string) *WorkspaceBundle {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *WorkspaceBundle) SetOwner(v string) *WorkspaceBundle {
	s.Owner = &v
	return s
}

// SetRootStorage sets the RootStorage field's value.
func (s *WorkspaceBundle) SetRootStorage(v *RootStorage) *WorkspaceBundle {
	s.RootStorage = v
	return s
}

// SetUserStorage sets the UserStorage field's value.
func (s *WorkspaceBundle) SetUserStorage(v *UserStorage) *WorkspaceBundle {
	s.UserStorage = v
	return s
}

// Describes the connection status of a WorkSpace.
type WorkspaceConnectionStatus struct {
	_ struct{} `type:"structure"`

	// The connection state of the WorkSpace. The connection state is unknown if
	// the WorkSpace is stopped.
	ConnectionState *string `type:"string" enum:"ConnectionState"`

	// The timestamp of the connection status check.
	ConnectionStateCheckTimestamp *time.Time `type:"timestamp"`

	// The timestamp of the last known user connection.
	LastKnownUserConnectionTimestamp *time.Time `type:"timestamp"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s WorkspaceConnectionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceConnectionStatus) GoString() string {
	return s.String()
}

// SetConnectionState sets the ConnectionState field's value.
func (s *WorkspaceConnectionStatus) SetConnectionState(v string) *WorkspaceConnectionStatus {
	s.ConnectionState = &v
	return s
}

// SetConnectionStateCheckTimestamp sets the ConnectionStateCheckTimestamp field's value.
func (s *WorkspaceConnectionStatus) SetConnectionStateCheckTimestamp(v time.Time) *WorkspaceConnectionStatus {
	s.ConnectionStateCheckTimestamp = &v
	return s
}

// SetLastKnownUserConnectionTimestamp sets the LastKnownUserConnectionTimestamp field's value.
func (s *WorkspaceConnectionStatus) SetLastKnownUserConnectionTimestamp(v time.Time) *WorkspaceConnectionStatus {
	s.LastKnownUserConnectionTimestamp = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *WorkspaceConnectionStatus) SetWorkspaceId(v string) *WorkspaceConnectionStatus {
	s.WorkspaceId = &v
	return s
}

// Describes an AWS Directory Service directory that is used with Amazon WorkSpaces.
type WorkspaceDirectory struct {
	_ struct{} `type:"structure"`

	// The directory alias.
	Alias *string `type:"string"`

	// The user name for the service account.
	CustomerUserName *string `min:"1" type:"string"`

	// The directory identifier.
	DirectoryId *string `type:"string"`

	// The name of the directory.
	DirectoryName *string `type:"string"`

	// The directory type.
	DirectoryType *string `type:"string" enum:"WorkspaceDirectoryType"`

	// The IP addresses of the DNS servers for the directory.
	DnsIpAddresses []*string `type:"list"`

	// The identifier of the IAM role. This is the role that allows Amazon WorkSpaces
	// to make calls to other services, such as Amazon EC2, on your behalf.
	IamRoleId *string `type:"string"`

	// The identifiers of the IP access control groups associated with the directory.
	IpGroupIds []*string `locationName:"ipGroupIds" type:"list"`

	// The registration code for the directory. This is the code that users enter
	// in their Amazon WorkSpaces client application to connect to the directory.
	RegistrationCode *string `min:"1" type:"string"`

	// The state of the directory's registration with Amazon WorkSpaces
	State *string `type:"string" enum:"WorkspaceDirectoryState"`

	// The identifiers of the subnets used with the directory.
	SubnetIds []*string `type:"list"`

	// The default creation properties for all WorkSpaces in the directory.
	WorkspaceCreationProperties *DefaultWorkspaceCreationProperties `type:"structure"`

	// The identifier of the security group that is assigned to new WorkSpaces.
	WorkspaceSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s WorkspaceDirectory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceDirectory) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *WorkspaceDirectory) SetAlias(v string) *WorkspaceDirectory {
	s.Alias = &v
	return s
}

// SetCustomerUserName sets the CustomerUserName field's value.
func (s *WorkspaceDirectory) SetCustomerUserName(v string) *WorkspaceDirectory {
	s.CustomerUserName = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *WorkspaceDirectory) SetDirectoryId(v string) *WorkspaceDirectory {
	s.DirectoryId = &v
	return s
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *WorkspaceDirectory) SetDirectoryName(v string) *WorkspaceDirectory {
	s.DirectoryName = &v
	return s
}

// SetDirectoryType sets the DirectoryType field's value.
func (s *WorkspaceDirectory) SetDirectoryType(v string) *WorkspaceDirectory {
	s.DirectoryType = &v
	return s
}

// SetDnsIpAddresses sets the DnsIpAddresses field's value.
func (s *WorkspaceDirectory) SetDnsIpAddresses(v []*string) *WorkspaceDirectory {
	s.DnsIpAddresses = v
	return s
}

// SetIamRoleId sets the IamRoleId field's value.
func (s *WorkspaceDirectory) SetIamRoleId(v string) *WorkspaceDirectory {
	s.IamRoleId = &v
	return s
}

// SetIpGroupIds sets the IpGroupIds field's value.
func (s *WorkspaceDirectory) SetIpGroupIds(v []*string) *WorkspaceDirectory {
	s.IpGroupIds = v
	return s
}

// SetRegistrationCode sets the RegistrationCode field's value.
func (s *WorkspaceDirectory) SetRegistrationCode(v string) *WorkspaceDirectory {
	s.RegistrationCode = &v
	return s
}

// SetState sets the State field's value.
func (s *WorkspaceDirectory) SetState(v string) *WorkspaceDirectory {
	s.State = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *WorkspaceDirectory) SetSubnetIds(v []*string) *WorkspaceDirectory {
	s.SubnetIds = v
	return s
}

// SetWorkspaceCreationProperties sets the WorkspaceCreationProperties field's value.
func (s *WorkspaceDirectory) SetWorkspaceCreationProperties(v *DefaultWorkspaceCreationProperties) *WorkspaceDirectory {
	s.WorkspaceCreationProperties = v
	return s
}

// SetWorkspaceSecurityGroupId sets the WorkspaceSecurityGroupId field's value.
func (s *WorkspaceDirectory) SetWorkspaceSecurityGroupId(v string) *WorkspaceDirectory {
	s.WorkspaceSecurityGroupId = &v
	return s
}

// Describes a WorkSpace image.
type WorkspaceImage struct {
	_ struct{} `type:"structure"`

	// The description of the image.
	Description *string `min:"1" type:"string"`

	// The error code that is returned for the image.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned for the image.
	ErrorMessage *string `type:"string"`

	// The identifier of the image.
	ImageId *string `type:"string"`

	// The name of the image.
	Name *string `min:"1" type:"string"`

	// The operating system that the image is running.
	OperatingSystem *OperatingSystem `type:"structure"`

	// Specifies whether the image is running on dedicated hardware. When bring
	// your own license (BYOL) is enabled, this value is set to DEDICATED.
	RequiredTenancy *string `type:"string" enum:"WorkspaceImageRequiredTenancy"`

	// The status of the image.
	State *string `type:"string" enum:"WorkspaceImageState"`
}

// String returns the string representation
func (s WorkspaceImage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceImage) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *WorkspaceImage) SetDescription(v string) *WorkspaceImage {
	s.Description = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *WorkspaceImage) SetErrorCode(v string) *WorkspaceImage {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *WorkspaceImage) SetErrorMessage(v string) *WorkspaceImage {
	s.ErrorMessage = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *WorkspaceImage) SetImageId(v string) *WorkspaceImage {
	s.ImageId = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkspaceImage) SetName(v string) *WorkspaceImage {
	s.Name = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *WorkspaceImage) SetOperatingSystem(v *OperatingSystem) *WorkspaceImage {
	s.OperatingSystem = v
	return s
}

// SetRequiredTenancy sets the RequiredTenancy field's value.
func (s *WorkspaceImage) SetRequiredTenancy(v string) *WorkspaceImage {
	s.RequiredTenancy = &v
	return s
}

// SetState sets the State field's value.
func (s *WorkspaceImage) SetState(v string) *WorkspaceImage {
	s.State = &v
	return s
}

// Describes a WorkSpace.
type WorkspaceProperties struct {
	_ struct{} `type:"structure"`

	// The compute type. For more information, see Amazon WorkSpaces Bundles (http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles).
	ComputeTypeName *string `type:"string" enum:"Compute"`

	// The size of the root volume.
	RootVolumeSizeGib *int64 `type:"integer"`

	// The running mode. For more information, see Manage the WorkSpace Running
	// Mode (https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html).
	RunningMode *string `type:"string" enum:"RunningMode"`

	// The time after a user logs off when WorkSpaces are automatically stopped.
	// Configured in 60 minute intervals.
	RunningModeAutoStopTimeoutInMinutes *int64 `type:"integer"`

	// The size of the user storage.
	UserVolumeSizeGib *int64 `type:"integer"`
}

// String returns the string representation
func (s WorkspaceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceProperties) GoString() string {
	return s.String()
}

// SetComputeTypeName sets the ComputeTypeName field's value.
func (s *WorkspaceProperties) SetComputeTypeName(v string) *WorkspaceProperties {
	s.ComputeTypeName = &v
	return s
}

// SetRootVolumeSizeGib sets the RootVolumeSizeGib field's value.
func (s *WorkspaceProperties) SetRootVolumeSizeGib(v int64) *WorkspaceProperties {
	s.RootVolumeSizeGib = &v
	return s
}

// SetRunningMode sets the RunningMode field's value.
func (s *WorkspaceProperties) SetRunningMode(v string) *WorkspaceProperties {
	s.RunningMode = &v
	return s
}

// SetRunningModeAutoStopTimeoutInMinutes sets the RunningModeAutoStopTimeoutInMinutes field's value.
func (s *WorkspaceProperties) SetRunningModeAutoStopTimeoutInMinutes(v int64) *WorkspaceProperties {
	s.RunningModeAutoStopTimeoutInMinutes = &v
	return s
}

// SetUserVolumeSizeGib sets the UserVolumeSizeGib field's value.
func (s *WorkspaceProperties) SetUserVolumeSizeGib(v int64) *WorkspaceProperties {
	s.UserVolumeSizeGib = &v
	return s
}

// Describes the information used to create a WorkSpace.
type WorkspaceRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle for the WorkSpace. You can use DescribeWorkspaceBundles
	// to list the available bundles.
	//
	// BundleId is a required field
	BundleId *string `type:"string" required:"true"`

	// The identifier of the AWS Directory Service directory for the WorkSpace.
	// You can use DescribeWorkspaceDirectories to list the available directories.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// Indicates whether the data stored on the root volume is encrypted.
	RootVolumeEncryptionEnabled *bool `type:"boolean"`

	// The tags for the WorkSpace.
	Tags []*Tag `type:"list"`

	// The username of the user for the WorkSpace. This username must exist in the
	// AWS Directory Service directory for the WorkSpace.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`

	// Indicates whether the data stored on the user volume is encrypted.
	UserVolumeEncryptionEnabled *bool `type:"boolean"`

	// The KMS key used to encrypt data stored on your WorkSpace.
	VolumeEncryptionKey *string `type:"string"`

	// The WorkSpace properties.
	WorkspaceProperties *WorkspaceProperties `type:"structure"`
}

// String returns the string representation
func (s WorkspaceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkspaceRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkspaceRequest"}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *WorkspaceRequest) SetBundleId(v string) *WorkspaceRequest {
	s.BundleId = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *WorkspaceRequest) SetDirectoryId(v string) *WorkspaceRequest {
	s.DirectoryId = &v
	return s
}

// SetRootVolumeEncryptionEnabled sets the RootVolumeEncryptionEnabled field's value.
func (s *WorkspaceRequest) SetRootVolumeEncryptionEnabled(v bool) *WorkspaceRequest {
	s.RootVolumeEncryptionEnabled = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *WorkspaceRequest) SetTags(v []*Tag) *WorkspaceRequest {
	s.Tags = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *WorkspaceRequest) SetUserName(v string) *WorkspaceRequest {
	s.UserName = &v
	return s
}

// SetUserVolumeEncryptionEnabled sets the UserVolumeEncryptionEnabled field's value.
func (s *WorkspaceRequest) SetUserVolumeEncryptionEnabled(v bool) *WorkspaceRequest {
	s.UserVolumeEncryptionEnabled = &v
	return s
}

// SetVolumeEncryptionKey sets the VolumeEncryptionKey field's value.
func (s *WorkspaceRequest) SetVolumeEncryptionKey(v string) *WorkspaceRequest {
	s.VolumeEncryptionKey = &v
	return s
}

// SetWorkspaceProperties sets the WorkspaceProperties field's value.
func (s *WorkspaceRequest) SetWorkspaceProperties(v *WorkspaceProperties) *WorkspaceRequest {
	s.WorkspaceProperties = v
	return s
}

const (
	// ComputeValue is a Compute enum value
	ComputeValue = "VALUE"

	// ComputeStandard is a Compute enum value
	ComputeStandard = "STANDARD"

	// ComputePerformance is a Compute enum value
	ComputePerformance = "PERFORMANCE"

	// ComputePower is a Compute enum value
	ComputePower = "POWER"

	// ComputeGraphics is a Compute enum value
	ComputeGraphics = "GRAPHICS"

	// ComputePowerpro is a Compute enum value
	ComputePowerpro = "POWERPRO"

	// ComputeGraphicspro is a Compute enum value
	ComputeGraphicspro = "GRAPHICSPRO"
)

const (
	// ConnectionStateConnected is a ConnectionState enum value
	ConnectionStateConnected = "CONNECTED"

	// ConnectionStateDisconnected is a ConnectionState enum value
	ConnectionStateDisconnected = "DISCONNECTED"

	// ConnectionStateUnknown is a ConnectionState enum value
	ConnectionStateUnknown = "UNKNOWN"
)

const (
	// DedicatedTenancyModificationStateEnumPending is a DedicatedTenancyModificationStateEnum enum value
	DedicatedTenancyModificationStateEnumPending = "PENDING"

	// DedicatedTenancyModificationStateEnumCompleted is a DedicatedTenancyModificationStateEnum enum value
	DedicatedTenancyModificationStateEnumCompleted = "COMPLETED"

	// DedicatedTenancyModificationStateEnumFailed is a DedicatedTenancyModificationStateEnum enum value
	DedicatedTenancyModificationStateEnumFailed = "FAILED"
)

const (
	// DedicatedTenancySupportEnumEnabled is a DedicatedTenancySupportEnum enum value
	DedicatedTenancySupportEnumEnabled = "ENABLED"
)

const (
	// DedicatedTenancySupportResultEnumEnabled is a DedicatedTenancySupportResultEnum enum value
	DedicatedTenancySupportResultEnumEnabled = "ENABLED"

	// DedicatedTenancySupportResultEnumDisabled is a DedicatedTenancySupportResultEnum enum value
	DedicatedTenancySupportResultEnumDisabled = "DISABLED"
)

const (
	// ModificationResourceEnumRootVolume is a ModificationResourceEnum enum value
	ModificationResourceEnumRootVolume = "ROOT_VOLUME"

	// ModificationResourceEnumUserVolume is a ModificationResourceEnum enum value
	ModificationResourceEnumUserVolume = "USER_VOLUME"

	// ModificationResourceEnumComputeType is a ModificationResourceEnum enum value
	ModificationResourceEnumComputeType = "COMPUTE_TYPE"
)

const (
	// ModificationStateEnumUpdateInitiated is a ModificationStateEnum enum value
	ModificationStateEnumUpdateInitiated = "UPDATE_INITIATED"

	// ModificationStateEnumUpdateInProgress is a ModificationStateEnum enum value
	ModificationStateEnumUpdateInProgress = "UPDATE_IN_PROGRESS"
)

const (
	// OperatingSystemTypeWindows is a OperatingSystemType enum value
	OperatingSystemTypeWindows = "WINDOWS"

	// OperatingSystemTypeLinux is a OperatingSystemType enum value
	OperatingSystemTypeLinux = "LINUX"
)

const (
	// ReconnectEnumEnabled is a ReconnectEnum enum value
	ReconnectEnumEnabled = "ENABLED"

	// ReconnectEnumDisabled is a ReconnectEnum enum value
	ReconnectEnumDisabled = "DISABLED"
)

const (
	// RunningModeAutoStop is a RunningMode enum value
	RunningModeAutoStop = "AUTO_STOP"

	// RunningModeAlwaysOn is a RunningMode enum value
	RunningModeAlwaysOn = "ALWAYS_ON"
)

const (
	// TargetWorkspaceStateAvailable is a TargetWorkspaceState enum value
	TargetWorkspaceStateAvailable = "AVAILABLE"

	// TargetWorkspaceStateAdminMaintenance is a TargetWorkspaceState enum value
	TargetWorkspaceStateAdminMaintenance = "ADMIN_MAINTENANCE"
)

const (
	// WorkspaceDirectoryStateRegistering is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateRegistering = "REGISTERING"

	// WorkspaceDirectoryStateRegistered is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateRegistered = "REGISTERED"

	// WorkspaceDirectoryStateDeregistering is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateDeregistering = "DEREGISTERING"

	// WorkspaceDirectoryStateDeregistered is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateDeregistered = "DEREGISTERED"

	// WorkspaceDirectoryStateError is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateError = "ERROR"
)

const (
	// WorkspaceDirectoryTypeSimpleAd is a WorkspaceDirectoryType enum value
	WorkspaceDirectoryTypeSimpleAd = "SIMPLE_AD"

	// WorkspaceDirectoryTypeAdConnector is a WorkspaceDirectoryType enum value
	WorkspaceDirectoryTypeAdConnector = "AD_CONNECTOR"
)

const (
	// WorkspaceImageIngestionProcessByolRegular is a WorkspaceImageIngestionProcess enum value
	WorkspaceImageIngestionProcessByolRegular = "BYOL_REGULAR"

	// WorkspaceImageIngestionProcessByolGraphics is a WorkspaceImageIngestionProcess enum value
	WorkspaceImageIngestionProcessByolGraphics = "BYOL_GRAPHICS"

	// WorkspaceImageIngestionProcessByolGraphicspro is a WorkspaceImageIngestionProcess enum value
	WorkspaceImageIngestionProcessByolGraphicspro = "BYOL_GRAPHICSPRO"
)

const (
	// WorkspaceImageRequiredTenancyDefault is a WorkspaceImageRequiredTenancy enum value
	WorkspaceImageRequiredTenancyDefault = "DEFAULT"

	// WorkspaceImageRequiredTenancyDedicated is a WorkspaceImageRequiredTenancy enum value
	WorkspaceImageRequiredTenancyDedicated = "DEDICATED"
)

const (
	// WorkspaceImageStateAvailable is a WorkspaceImageState enum value
	WorkspaceImageStateAvailable = "AVAILABLE"

	// WorkspaceImageStatePending is a WorkspaceImageState enum value
	WorkspaceImageStatePending = "PENDING"

	// WorkspaceImageStateError is a WorkspaceImageState enum value
	WorkspaceImageStateError = "ERROR"
)

const (
	// WorkspaceStatePending is a WorkspaceState enum value
	WorkspaceStatePending = "PENDING"

	// WorkspaceStateAvailable is a WorkspaceState enum value
	WorkspaceStateAvailable = "AVAILABLE"

	// WorkspaceStateImpaired is a WorkspaceState enum value
	WorkspaceStateImpaired = "IMPAIRED"

	// WorkspaceStateUnhealthy is a WorkspaceState enum value
	WorkspaceStateUnhealthy = "UNHEALTHY"

	// WorkspaceStateRebooting is a WorkspaceState enum value
	WorkspaceStateRebooting = "REBOOTING"

	// WorkspaceStateStarting is a WorkspaceState enum value
	WorkspaceStateStarting = "STARTING"

	// WorkspaceStateRebuilding is a WorkspaceState enum value
	WorkspaceStateRebuilding = "REBUILDING"

	// WorkspaceStateMaintenance is a WorkspaceState enum value
	WorkspaceStateMaintenance = "MAINTENANCE"

	// WorkspaceStateAdminMaintenance is a WorkspaceState enum value
	WorkspaceStateAdminMaintenance = "ADMIN_MAINTENANCE"

	// WorkspaceStateTerminating is a WorkspaceState enum value
	WorkspaceStateTerminating = "TERMINATING"

	// WorkspaceStateTerminated is a WorkspaceState enum value
	WorkspaceStateTerminated = "TERMINATED"

	// WorkspaceStateSuspended is a WorkspaceState enum value
	WorkspaceStateSuspended = "SUSPENDED"

	// WorkspaceStateUpdating is a WorkspaceState enum value
	WorkspaceStateUpdating = "UPDATING"

	// WorkspaceStateStopping is a WorkspaceState enum value
	WorkspaceStateStopping = "STOPPING"

	// WorkspaceStateStopped is a WorkspaceState enum value
	WorkspaceStateStopped = "STOPPED"

	// WorkspaceStateError is a WorkspaceState enum value
	WorkspaceStateError = "ERROR"
)
