// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotthingsgraph

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateEntityToThing = "AssociateEntityToThing"

// AssociateEntityToThingRequest generates a "aws/request.Request" representing the
// client's request for the AssociateEntityToThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateEntityToThing for more information on using the AssociateEntityToThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateEntityToThingRequest method.
//    req, resp := client.AssociateEntityToThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/AssociateEntityToThing
func (c *IoTThingsGraph) AssociateEntityToThingRequest(input *AssociateEntityToThingInput) (req *request.Request, output *AssociateEntityToThingOutput) {
	op := &request.Operation{
		Name:       opAssociateEntityToThing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateEntityToThingInput{}
	}

	output = &AssociateEntityToThingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateEntityToThing API operation for AWS IoT Things Graph.
//
// Associates a device with a concrete thing that is in the user's registry.
//
// A thing can be associated with only one device at a time. If you associate
// a thing with a new device id, its previous association will be removed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation AssociateEntityToThing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/AssociateEntityToThing
func (c *IoTThingsGraph) AssociateEntityToThing(input *AssociateEntityToThingInput) (*AssociateEntityToThingOutput, error) {
	req, out := c.AssociateEntityToThingRequest(input)
	return out, req.Send()
}

// AssociateEntityToThingWithContext is the same as AssociateEntityToThing with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateEntityToThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) AssociateEntityToThingWithContext(ctx aws.Context, input *AssociateEntityToThingInput, opts ...request.Option) (*AssociateEntityToThingOutput, error) {
	req, out := c.AssociateEntityToThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFlowTemplate = "CreateFlowTemplate"

// CreateFlowTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateFlowTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFlowTemplate for more information on using the CreateFlowTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFlowTemplateRequest method.
//    req, resp := client.CreateFlowTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateFlowTemplate
func (c *IoTThingsGraph) CreateFlowTemplateRequest(input *CreateFlowTemplateInput) (req *request.Request, output *CreateFlowTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateFlowTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFlowTemplateInput{}
	}

	output = &CreateFlowTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFlowTemplate API operation for AWS IoT Things Graph.
//
// Creates a workflow template. Workflows can be created only in the user's
// namespace. (The public namespace contains only entities.) The workflow can
// contain only entities in the specified namespace. The workflow is validated
// against the entities in the latest version of the user's namespace unless
// another namespace version is specified in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation CreateFlowTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateFlowTemplate
func (c *IoTThingsGraph) CreateFlowTemplate(input *CreateFlowTemplateInput) (*CreateFlowTemplateOutput, error) {
	req, out := c.CreateFlowTemplateRequest(input)
	return out, req.Send()
}

// CreateFlowTemplateWithContext is the same as CreateFlowTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFlowTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) CreateFlowTemplateWithContext(ctx aws.Context, input *CreateFlowTemplateInput, opts ...request.Option) (*CreateFlowTemplateOutput, error) {
	req, out := c.CreateFlowTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSystemInstance = "CreateSystemInstance"

// CreateSystemInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateSystemInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSystemInstance for more information on using the CreateSystemInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSystemInstanceRequest method.
//    req, resp := client.CreateSystemInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemInstance
func (c *IoTThingsGraph) CreateSystemInstanceRequest(input *CreateSystemInstanceInput) (req *request.Request, output *CreateSystemInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateSystemInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSystemInstanceInput{}
	}

	output = &CreateSystemInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSystemInstance API operation for AWS IoT Things Graph.
//
// Creates a system instance.
//
// This action validates the system instance, prepares the deployment-related
// resources. For Greengrass deployments, it updates the Greengrass group that
// is specified by the greengrassGroupName parameter. It also adds a file to
// the S3 bucket specified by the s3BucketName parameter. You need to call DeploySystemInstance
// after running this action.
//
// For Greengrass deployments, since this action modifies and adds resources
// to a Greengrass group and an S3 bucket on the caller's behalf, the calling
// identity must have write permissions to both the specified Greengrass group
// and S3 bucket. Otherwise, the call will fail with an authorization error.
//
// For cloud deployments, this action requires a flowActionsRoleArn value. This
// is an IAM role that has permissions to access AWS services, such as AWS Lambda
// and AWS IoT, that the flow uses when it executes.
//
// If the definition document doesn't specify a version of the user's namespace,
// the latest version will be used by default.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation CreateSystemInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemInstance
func (c *IoTThingsGraph) CreateSystemInstance(input *CreateSystemInstanceInput) (*CreateSystemInstanceOutput, error) {
	req, out := c.CreateSystemInstanceRequest(input)
	return out, req.Send()
}

// CreateSystemInstanceWithContext is the same as CreateSystemInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSystemInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) CreateSystemInstanceWithContext(ctx aws.Context, input *CreateSystemInstanceInput, opts ...request.Option) (*CreateSystemInstanceOutput, error) {
	req, out := c.CreateSystemInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSystemTemplate = "CreateSystemTemplate"

// CreateSystemTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateSystemTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSystemTemplate for more information on using the CreateSystemTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSystemTemplateRequest method.
//    req, resp := client.CreateSystemTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemTemplate
func (c *IoTThingsGraph) CreateSystemTemplateRequest(input *CreateSystemTemplateInput) (req *request.Request, output *CreateSystemTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateSystemTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSystemTemplateInput{}
	}

	output = &CreateSystemTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSystemTemplate API operation for AWS IoT Things Graph.
//
// Creates a system. The system is validated against the entities in the latest
// version of the user's namespace unless another namespace version is specified
// in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation CreateSystemTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemTemplate
func (c *IoTThingsGraph) CreateSystemTemplate(input *CreateSystemTemplateInput) (*CreateSystemTemplateOutput, error) {
	req, out := c.CreateSystemTemplateRequest(input)
	return out, req.Send()
}

// CreateSystemTemplateWithContext is the same as CreateSystemTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSystemTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) CreateSystemTemplateWithContext(ctx aws.Context, input *CreateSystemTemplateInput, opts ...request.Option) (*CreateSystemTemplateOutput, error) {
	req, out := c.CreateSystemTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFlowTemplate = "DeleteFlowTemplate"

// DeleteFlowTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFlowTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFlowTemplate for more information on using the DeleteFlowTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFlowTemplateRequest method.
//    req, resp := client.DeleteFlowTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteFlowTemplate
func (c *IoTThingsGraph) DeleteFlowTemplateRequest(input *DeleteFlowTemplateInput) (req *request.Request, output *DeleteFlowTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteFlowTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFlowTemplateInput{}
	}

	output = &DeleteFlowTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFlowTemplate API operation for AWS IoT Things Graph.
//
// Deletes a workflow. Any new system or deployment that contains this workflow
// will fail to update or deploy. Existing deployments that contain the workflow
// will continue to run (since they use a snapshot of the workflow taken at
// the time of deployment).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation DeleteFlowTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteFlowTemplate
func (c *IoTThingsGraph) DeleteFlowTemplate(input *DeleteFlowTemplateInput) (*DeleteFlowTemplateOutput, error) {
	req, out := c.DeleteFlowTemplateRequest(input)
	return out, req.Send()
}

// DeleteFlowTemplateWithContext is the same as DeleteFlowTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFlowTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) DeleteFlowTemplateWithContext(ctx aws.Context, input *DeleteFlowTemplateInput, opts ...request.Option) (*DeleteFlowTemplateOutput, error) {
	req, out := c.DeleteFlowTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNamespace = "DeleteNamespace"

// DeleteNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNamespace for more information on using the DeleteNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNamespaceRequest method.
//    req, resp := client.DeleteNamespaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteNamespace
func (c *IoTThingsGraph) DeleteNamespaceRequest(input *DeleteNamespaceInput) (req *request.Request, output *DeleteNamespaceOutput) {
	op := &request.Operation{
		Name:       opDeleteNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNamespaceInput{}
	}

	output = &DeleteNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNamespace API operation for AWS IoT Things Graph.
//
// Deletes the specified namespace. This action deletes all of the entities
// in the namespace. Delete the systems and flows that use entities in the namespace
// before performing this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation DeleteNamespace for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteNamespace
func (c *IoTThingsGraph) DeleteNamespace(input *DeleteNamespaceInput) (*DeleteNamespaceOutput, error) {
	req, out := c.DeleteNamespaceRequest(input)
	return out, req.Send()
}

// DeleteNamespaceWithContext is the same as DeleteNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) DeleteNamespaceWithContext(ctx aws.Context, input *DeleteNamespaceInput, opts ...request.Option) (*DeleteNamespaceOutput, error) {
	req, out := c.DeleteNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSystemInstance = "DeleteSystemInstance"

// DeleteSystemInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSystemInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSystemInstance for more information on using the DeleteSystemInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSystemInstanceRequest method.
//    req, resp := client.DeleteSystemInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemInstance
func (c *IoTThingsGraph) DeleteSystemInstanceRequest(input *DeleteSystemInstanceInput) (req *request.Request, output *DeleteSystemInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteSystemInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSystemInstanceInput{}
	}

	output = &DeleteSystemInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSystemInstance API operation for AWS IoT Things Graph.
//
// Deletes a system instance. Only system instances that have never been deployed,
// or that have been undeployed can be deleted.
//
// Users can create a new system instance that has the same ID as a deleted
// system instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation DeleteSystemInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemInstance
func (c *IoTThingsGraph) DeleteSystemInstance(input *DeleteSystemInstanceInput) (*DeleteSystemInstanceOutput, error) {
	req, out := c.DeleteSystemInstanceRequest(input)
	return out, req.Send()
}

// DeleteSystemInstanceWithContext is the same as DeleteSystemInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSystemInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) DeleteSystemInstanceWithContext(ctx aws.Context, input *DeleteSystemInstanceInput, opts ...request.Option) (*DeleteSystemInstanceOutput, error) {
	req, out := c.DeleteSystemInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSystemTemplate = "DeleteSystemTemplate"

// DeleteSystemTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSystemTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSystemTemplate for more information on using the DeleteSystemTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSystemTemplateRequest method.
//    req, resp := client.DeleteSystemTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemTemplate
func (c *IoTThingsGraph) DeleteSystemTemplateRequest(input *DeleteSystemTemplateInput) (req *request.Request, output *DeleteSystemTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteSystemTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSystemTemplateInput{}
	}

	output = &DeleteSystemTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSystemTemplate API operation for AWS IoT Things Graph.
//
// Deletes a system. New deployments can't contain the system after its deletion.
// Existing deployments that contain the system will continue to work because
// they use a snapshot of the system that is taken when it is deployed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation DeleteSystemTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemTemplate
func (c *IoTThingsGraph) DeleteSystemTemplate(input *DeleteSystemTemplateInput) (*DeleteSystemTemplateOutput, error) {
	req, out := c.DeleteSystemTemplateRequest(input)
	return out, req.Send()
}

// DeleteSystemTemplateWithContext is the same as DeleteSystemTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSystemTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) DeleteSystemTemplateWithContext(ctx aws.Context, input *DeleteSystemTemplateInput, opts ...request.Option) (*DeleteSystemTemplateOutput, error) {
	req, out := c.DeleteSystemTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeploySystemInstance = "DeploySystemInstance"

// DeploySystemInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeploySystemInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeploySystemInstance for more information on using the DeploySystemInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeploySystemInstanceRequest method.
//    req, resp := client.DeploySystemInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeploySystemInstance
func (c *IoTThingsGraph) DeploySystemInstanceRequest(input *DeploySystemInstanceInput) (req *request.Request, output *DeploySystemInstanceOutput) {
	op := &request.Operation{
		Name:       opDeploySystemInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeploySystemInstanceInput{}
	}

	output = &DeploySystemInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeploySystemInstance API operation for AWS IoT Things Graph.
//
// Greengrass and Cloud Deployments
//
// Deploys the system instance to the target specified in CreateSystemInstance.
//
// Greengrass Deployments
//
// If the system or any workflows and entities have been updated before this
// action is called, then the deployment will create a new Amazon Simple Storage
// Service resource file and then deploy it.
//
// Since this action creates a Greengrass deployment on the caller's behalf,
// the calling identity must have write permissions to the specified Greengrass
// group. Otherwise, the call will fail with an authorization error.
//
// For information about the artifacts that get added to your Greengrass core
// device when you use this API, see AWS IoT Things Graph and AWS IoT Greengrass
// (https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation DeploySystemInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeploySystemInstance
func (c *IoTThingsGraph) DeploySystemInstance(input *DeploySystemInstanceInput) (*DeploySystemInstanceOutput, error) {
	req, out := c.DeploySystemInstanceRequest(input)
	return out, req.Send()
}

// DeploySystemInstanceWithContext is the same as DeploySystemInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeploySystemInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) DeploySystemInstanceWithContext(ctx aws.Context, input *DeploySystemInstanceInput, opts ...request.Option) (*DeploySystemInstanceOutput, error) {
	req, out := c.DeploySystemInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeprecateFlowTemplate = "DeprecateFlowTemplate"

// DeprecateFlowTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeprecateFlowTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeprecateFlowTemplate for more information on using the DeprecateFlowTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeprecateFlowTemplateRequest method.
//    req, resp := client.DeprecateFlowTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateFlowTemplate
func (c *IoTThingsGraph) DeprecateFlowTemplateRequest(input *DeprecateFlowTemplateInput) (req *request.Request, output *DeprecateFlowTemplateOutput) {
	op := &request.Operation{
		Name:       opDeprecateFlowTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeprecateFlowTemplateInput{}
	}

	output = &DeprecateFlowTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeprecateFlowTemplate API operation for AWS IoT Things Graph.
//
// Deprecates the specified workflow. This action marks the workflow for deletion.
// Deprecated flows can't be deployed, but existing deployments will continue
// to run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation DeprecateFlowTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateFlowTemplate
func (c *IoTThingsGraph) DeprecateFlowTemplate(input *DeprecateFlowTemplateInput) (*DeprecateFlowTemplateOutput, error) {
	req, out := c.DeprecateFlowTemplateRequest(input)
	return out, req.Send()
}

// DeprecateFlowTemplateWithContext is the same as DeprecateFlowTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeprecateFlowTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) DeprecateFlowTemplateWithContext(ctx aws.Context, input *DeprecateFlowTemplateInput, opts ...request.Option) (*DeprecateFlowTemplateOutput, error) {
	req, out := c.DeprecateFlowTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeprecateSystemTemplate = "DeprecateSystemTemplate"

// DeprecateSystemTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeprecateSystemTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeprecateSystemTemplate for more information on using the DeprecateSystemTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeprecateSystemTemplateRequest method.
//    req, resp := client.DeprecateSystemTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateSystemTemplate
func (c *IoTThingsGraph) DeprecateSystemTemplateRequest(input *DeprecateSystemTemplateInput) (req *request.Request, output *DeprecateSystemTemplateOutput) {
	op := &request.Operation{
		Name:       opDeprecateSystemTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeprecateSystemTemplateInput{}
	}

	output = &DeprecateSystemTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeprecateSystemTemplate API operation for AWS IoT Things Graph.
//
// Deprecates the specified system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation DeprecateSystemTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateSystemTemplate
func (c *IoTThingsGraph) DeprecateSystemTemplate(input *DeprecateSystemTemplateInput) (*DeprecateSystemTemplateOutput, error) {
	req, out := c.DeprecateSystemTemplateRequest(input)
	return out, req.Send()
}

// DeprecateSystemTemplateWithContext is the same as DeprecateSystemTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeprecateSystemTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) DeprecateSystemTemplateWithContext(ctx aws.Context, input *DeprecateSystemTemplateInput, opts ...request.Option) (*DeprecateSystemTemplateOutput, error) {
	req, out := c.DeprecateSystemTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNamespace = "DescribeNamespace"

// DescribeNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNamespace for more information on using the DescribeNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNamespaceRequest method.
//    req, resp := client.DescribeNamespaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DescribeNamespace
func (c *IoTThingsGraph) DescribeNamespaceRequest(input *DescribeNamespaceInput) (req *request.Request, output *DescribeNamespaceOutput) {
	op := &request.Operation{
		Name:       opDescribeNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNamespaceInput{}
	}

	output = &DescribeNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNamespace API operation for AWS IoT Things Graph.
//
// Gets the latest version of the user's namespace and the public version that
// it is tracking.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation DescribeNamespace for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DescribeNamespace
func (c *IoTThingsGraph) DescribeNamespace(input *DescribeNamespaceInput) (*DescribeNamespaceOutput, error) {
	req, out := c.DescribeNamespaceRequest(input)
	return out, req.Send()
}

// DescribeNamespaceWithContext is the same as DescribeNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) DescribeNamespaceWithContext(ctx aws.Context, input *DescribeNamespaceInput, opts ...request.Option) (*DescribeNamespaceOutput, error) {
	req, out := c.DescribeNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDissociateEntityFromThing = "DissociateEntityFromThing"

// DissociateEntityFromThingRequest generates a "aws/request.Request" representing the
// client's request for the DissociateEntityFromThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DissociateEntityFromThing for more information on using the DissociateEntityFromThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DissociateEntityFromThingRequest method.
//    req, resp := client.DissociateEntityFromThingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DissociateEntityFromThing
func (c *IoTThingsGraph) DissociateEntityFromThingRequest(input *DissociateEntityFromThingInput) (req *request.Request, output *DissociateEntityFromThingOutput) {
	op := &request.Operation{
		Name:       opDissociateEntityFromThing,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DissociateEntityFromThingInput{}
	}

	output = &DissociateEntityFromThingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DissociateEntityFromThing API operation for AWS IoT Things Graph.
//
// Dissociates a device entity from a concrete thing. The action takes only
// the type of the entity that you need to dissociate because only one entity
// of a particular type can be associated with a thing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation DissociateEntityFromThing for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DissociateEntityFromThing
func (c *IoTThingsGraph) DissociateEntityFromThing(input *DissociateEntityFromThingInput) (*DissociateEntityFromThingOutput, error) {
	req, out := c.DissociateEntityFromThingRequest(input)
	return out, req.Send()
}

// DissociateEntityFromThingWithContext is the same as DissociateEntityFromThing with the addition of
// the ability to pass a context and additional request options.
//
// See DissociateEntityFromThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) DissociateEntityFromThingWithContext(ctx aws.Context, input *DissociateEntityFromThingInput, opts ...request.Option) (*DissociateEntityFromThingOutput, error) {
	req, out := c.DissociateEntityFromThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEntities = "GetEntities"

// GetEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the GetEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEntities for more information on using the GetEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEntitiesRequest method.
//    req, resp := client.GetEntitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetEntities
func (c *IoTThingsGraph) GetEntitiesRequest(input *GetEntitiesInput) (req *request.Request, output *GetEntitiesOutput) {
	op := &request.Operation{
		Name:       opGetEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEntitiesInput{}
	}

	output = &GetEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEntities API operation for AWS IoT Things Graph.
//
// Gets definitions of the specified entities. Uses the latest version of the
// user's namespace by default. This API returns the following TDM entities.
//
//    * Properties
//
//    * States
//
//    * Events
//
//    * Actions
//
//    * Capabilities
//
//    * Mappings
//
//    * Devices
//
//    * Device Models
//
//    * Services
//
// This action doesn't return definitions for systems, flows, and deployments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation GetEntities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetEntities
func (c *IoTThingsGraph) GetEntities(input *GetEntitiesInput) (*GetEntitiesOutput, error) {
	req, out := c.GetEntitiesRequest(input)
	return out, req.Send()
}

// GetEntitiesWithContext is the same as GetEntities with the addition of
// the ability to pass a context and additional request options.
//
// See GetEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) GetEntitiesWithContext(ctx aws.Context, input *GetEntitiesInput, opts ...request.Option) (*GetEntitiesOutput, error) {
	req, out := c.GetEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFlowTemplate = "GetFlowTemplate"

// GetFlowTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetFlowTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFlowTemplate for more information on using the GetFlowTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFlowTemplateRequest method.
//    req, resp := client.GetFlowTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplate
func (c *IoTThingsGraph) GetFlowTemplateRequest(input *GetFlowTemplateInput) (req *request.Request, output *GetFlowTemplateOutput) {
	op := &request.Operation{
		Name:       opGetFlowTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetFlowTemplateInput{}
	}

	output = &GetFlowTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFlowTemplate API operation for AWS IoT Things Graph.
//
// Gets the latest version of the DefinitionDocument and FlowTemplateSummary
// for the specified workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation GetFlowTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplate
func (c *IoTThingsGraph) GetFlowTemplate(input *GetFlowTemplateInput) (*GetFlowTemplateOutput, error) {
	req, out := c.GetFlowTemplateRequest(input)
	return out, req.Send()
}

// GetFlowTemplateWithContext is the same as GetFlowTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetFlowTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) GetFlowTemplateWithContext(ctx aws.Context, input *GetFlowTemplateInput, opts ...request.Option) (*GetFlowTemplateOutput, error) {
	req, out := c.GetFlowTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFlowTemplateRevisions = "GetFlowTemplateRevisions"

// GetFlowTemplateRevisionsRequest generates a "aws/request.Request" representing the
// client's request for the GetFlowTemplateRevisions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFlowTemplateRevisions for more information on using the GetFlowTemplateRevisions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetFlowTemplateRevisionsRequest method.
//    req, resp := client.GetFlowTemplateRevisionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplateRevisions
func (c *IoTThingsGraph) GetFlowTemplateRevisionsRequest(input *GetFlowTemplateRevisionsInput) (req *request.Request, output *GetFlowTemplateRevisionsOutput) {
	op := &request.Operation{
		Name:       opGetFlowTemplateRevisions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetFlowTemplateRevisionsInput{}
	}

	output = &GetFlowTemplateRevisionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFlowTemplateRevisions API operation for AWS IoT Things Graph.
//
// Gets revisions of the specified workflow. Only the last 100 revisions are
// stored. If the workflow has been deprecated, this action will return revisions
// that occurred before the deprecation. This action won't work for workflows
// that have been deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation GetFlowTemplateRevisions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplateRevisions
func (c *IoTThingsGraph) GetFlowTemplateRevisions(input *GetFlowTemplateRevisionsInput) (*GetFlowTemplateRevisionsOutput, error) {
	req, out := c.GetFlowTemplateRevisionsRequest(input)
	return out, req.Send()
}

// GetFlowTemplateRevisionsWithContext is the same as GetFlowTemplateRevisions with the addition of
// the ability to pass a context and additional request options.
//
// See GetFlowTemplateRevisions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) GetFlowTemplateRevisionsWithContext(ctx aws.Context, input *GetFlowTemplateRevisionsInput, opts ...request.Option) (*GetFlowTemplateRevisionsOutput, error) {
	req, out := c.GetFlowTemplateRevisionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetFlowTemplateRevisionsPages iterates over the pages of a GetFlowTemplateRevisions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetFlowTemplateRevisions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetFlowTemplateRevisions operation.
//    pageNum := 0
//    err := client.GetFlowTemplateRevisionsPages(params,
//        func(page *iotthingsgraph.GetFlowTemplateRevisionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTThingsGraph) GetFlowTemplateRevisionsPages(input *GetFlowTemplateRevisionsInput, fn func(*GetFlowTemplateRevisionsOutput, bool) bool) error {
	return c.GetFlowTemplateRevisionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetFlowTemplateRevisionsPagesWithContext same as GetFlowTemplateRevisionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) GetFlowTemplateRevisionsPagesWithContext(ctx aws.Context, input *GetFlowTemplateRevisionsInput, fn func(*GetFlowTemplateRevisionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetFlowTemplateRevisionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetFlowTemplateRevisionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetFlowTemplateRevisionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetNamespaceDeletionStatus = "GetNamespaceDeletionStatus"

// GetNamespaceDeletionStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetNamespaceDeletionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNamespaceDeletionStatus for more information on using the GetNamespaceDeletionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetNamespaceDeletionStatusRequest method.
//    req, resp := client.GetNamespaceDeletionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetNamespaceDeletionStatus
func (c *IoTThingsGraph) GetNamespaceDeletionStatusRequest(input *GetNamespaceDeletionStatusInput) (req *request.Request, output *GetNamespaceDeletionStatusOutput) {
	op := &request.Operation{
		Name:       opGetNamespaceDeletionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetNamespaceDeletionStatusInput{}
	}

	output = &GetNamespaceDeletionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNamespaceDeletionStatus API operation for AWS IoT Things Graph.
//
// Gets the status of a namespace deletion task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation GetNamespaceDeletionStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetNamespaceDeletionStatus
func (c *IoTThingsGraph) GetNamespaceDeletionStatus(input *GetNamespaceDeletionStatusInput) (*GetNamespaceDeletionStatusOutput, error) {
	req, out := c.GetNamespaceDeletionStatusRequest(input)
	return out, req.Send()
}

// GetNamespaceDeletionStatusWithContext is the same as GetNamespaceDeletionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetNamespaceDeletionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) GetNamespaceDeletionStatusWithContext(ctx aws.Context, input *GetNamespaceDeletionStatusInput, opts ...request.Option) (*GetNamespaceDeletionStatusOutput, error) {
	req, out := c.GetNamespaceDeletionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSystemInstance = "GetSystemInstance"

// GetSystemInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetSystemInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSystemInstance for more information on using the GetSystemInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSystemInstanceRequest method.
//    req, resp := client.GetSystemInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemInstance
func (c *IoTThingsGraph) GetSystemInstanceRequest(input *GetSystemInstanceInput) (req *request.Request, output *GetSystemInstanceOutput) {
	op := &request.Operation{
		Name:       opGetSystemInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSystemInstanceInput{}
	}

	output = &GetSystemInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSystemInstance API operation for AWS IoT Things Graph.
//
// Gets a system instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation GetSystemInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemInstance
func (c *IoTThingsGraph) GetSystemInstance(input *GetSystemInstanceInput) (*GetSystemInstanceOutput, error) {
	req, out := c.GetSystemInstanceRequest(input)
	return out, req.Send()
}

// GetSystemInstanceWithContext is the same as GetSystemInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetSystemInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) GetSystemInstanceWithContext(ctx aws.Context, input *GetSystemInstanceInput, opts ...request.Option) (*GetSystemInstanceOutput, error) {
	req, out := c.GetSystemInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSystemTemplate = "GetSystemTemplate"

// GetSystemTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetSystemTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSystemTemplate for more information on using the GetSystemTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSystemTemplateRequest method.
//    req, resp := client.GetSystemTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplate
func (c *IoTThingsGraph) GetSystemTemplateRequest(input *GetSystemTemplateInput) (req *request.Request, output *GetSystemTemplateOutput) {
	op := &request.Operation{
		Name:       opGetSystemTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSystemTemplateInput{}
	}

	output = &GetSystemTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSystemTemplate API operation for AWS IoT Things Graph.
//
// Gets a system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation GetSystemTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplate
func (c *IoTThingsGraph) GetSystemTemplate(input *GetSystemTemplateInput) (*GetSystemTemplateOutput, error) {
	req, out := c.GetSystemTemplateRequest(input)
	return out, req.Send()
}

// GetSystemTemplateWithContext is the same as GetSystemTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetSystemTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) GetSystemTemplateWithContext(ctx aws.Context, input *GetSystemTemplateInput, opts ...request.Option) (*GetSystemTemplateOutput, error) {
	req, out := c.GetSystemTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSystemTemplateRevisions = "GetSystemTemplateRevisions"

// GetSystemTemplateRevisionsRequest generates a "aws/request.Request" representing the
// client's request for the GetSystemTemplateRevisions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSystemTemplateRevisions for more information on using the GetSystemTemplateRevisions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSystemTemplateRevisionsRequest method.
//    req, resp := client.GetSystemTemplateRevisionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplateRevisions
func (c *IoTThingsGraph) GetSystemTemplateRevisionsRequest(input *GetSystemTemplateRevisionsInput) (req *request.Request, output *GetSystemTemplateRevisionsOutput) {
	op := &request.Operation{
		Name:       opGetSystemTemplateRevisions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSystemTemplateRevisionsInput{}
	}

	output = &GetSystemTemplateRevisionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSystemTemplateRevisions API operation for AWS IoT Things Graph.
//
// Gets revisions made to the specified system template. Only the previous 100
// revisions are stored. If the system has been deprecated, this action will
// return the revisions that occurred before its deprecation. This action won't
// work with systems that have been deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation GetSystemTemplateRevisions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplateRevisions
func (c *IoTThingsGraph) GetSystemTemplateRevisions(input *GetSystemTemplateRevisionsInput) (*GetSystemTemplateRevisionsOutput, error) {
	req, out := c.GetSystemTemplateRevisionsRequest(input)
	return out, req.Send()
}

// GetSystemTemplateRevisionsWithContext is the same as GetSystemTemplateRevisions with the addition of
// the ability to pass a context and additional request options.
//
// See GetSystemTemplateRevisions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) GetSystemTemplateRevisionsWithContext(ctx aws.Context, input *GetSystemTemplateRevisionsInput, opts ...request.Option) (*GetSystemTemplateRevisionsOutput, error) {
	req, out := c.GetSystemTemplateRevisionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetSystemTemplateRevisionsPages iterates over the pages of a GetSystemTemplateRevisions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetSystemTemplateRevisions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetSystemTemplateRevisions operation.
//    pageNum := 0
//    err := client.GetSystemTemplateRevisionsPages(params,
//        func(page *iotthingsgraph.GetSystemTemplateRevisionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTThingsGraph) GetSystemTemplateRevisionsPages(input *GetSystemTemplateRevisionsInput, fn func(*GetSystemTemplateRevisionsOutput, bool) bool) error {
	return c.GetSystemTemplateRevisionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetSystemTemplateRevisionsPagesWithContext same as GetSystemTemplateRevisionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) GetSystemTemplateRevisionsPagesWithContext(ctx aws.Context, input *GetSystemTemplateRevisionsInput, fn func(*GetSystemTemplateRevisionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetSystemTemplateRevisionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetSystemTemplateRevisionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetSystemTemplateRevisionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetUploadStatus = "GetUploadStatus"

// GetUploadStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetUploadStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUploadStatus for more information on using the GetUploadStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUploadStatusRequest method.
//    req, resp := client.GetUploadStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetUploadStatus
func (c *IoTThingsGraph) GetUploadStatusRequest(input *GetUploadStatusInput) (req *request.Request, output *GetUploadStatusOutput) {
	op := &request.Operation{
		Name:       opGetUploadStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUploadStatusInput{}
	}

	output = &GetUploadStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUploadStatus API operation for AWS IoT Things Graph.
//
// Gets the status of the specified upload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation GetUploadStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetUploadStatus
func (c *IoTThingsGraph) GetUploadStatus(input *GetUploadStatusInput) (*GetUploadStatusOutput, error) {
	req, out := c.GetUploadStatusRequest(input)
	return out, req.Send()
}

// GetUploadStatusWithContext is the same as GetUploadStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetUploadStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) GetUploadStatusWithContext(ctx aws.Context, input *GetUploadStatusInput, opts ...request.Option) (*GetUploadStatusOutput, error) {
	req, out := c.GetUploadStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFlowExecutionMessages = "ListFlowExecutionMessages"

// ListFlowExecutionMessagesRequest generates a "aws/request.Request" representing the
// client's request for the ListFlowExecutionMessages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFlowExecutionMessages for more information on using the ListFlowExecutionMessages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFlowExecutionMessagesRequest method.
//    req, resp := client.ListFlowExecutionMessagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListFlowExecutionMessages
func (c *IoTThingsGraph) ListFlowExecutionMessagesRequest(input *ListFlowExecutionMessagesInput) (req *request.Request, output *ListFlowExecutionMessagesOutput) {
	op := &request.Operation{
		Name:       opListFlowExecutionMessages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFlowExecutionMessagesInput{}
	}

	output = &ListFlowExecutionMessagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFlowExecutionMessages API operation for AWS IoT Things Graph.
//
// Returns a list of objects that contain information about events in a flow
// execution.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation ListFlowExecutionMessages for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListFlowExecutionMessages
func (c *IoTThingsGraph) ListFlowExecutionMessages(input *ListFlowExecutionMessagesInput) (*ListFlowExecutionMessagesOutput, error) {
	req, out := c.ListFlowExecutionMessagesRequest(input)
	return out, req.Send()
}

// ListFlowExecutionMessagesWithContext is the same as ListFlowExecutionMessages with the addition of
// the ability to pass a context and additional request options.
//
// See ListFlowExecutionMessages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) ListFlowExecutionMessagesWithContext(ctx aws.Context, input *ListFlowExecutionMessagesInput, opts ...request.Option) (*ListFlowExecutionMessagesOutput, error) {
	req, out := c.ListFlowExecutionMessagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFlowExecutionMessagesPages iterates over the pages of a ListFlowExecutionMessages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFlowExecutionMessages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFlowExecutionMessages operation.
//    pageNum := 0
//    err := client.ListFlowExecutionMessagesPages(params,
//        func(page *iotthingsgraph.ListFlowExecutionMessagesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTThingsGraph) ListFlowExecutionMessagesPages(input *ListFlowExecutionMessagesInput, fn func(*ListFlowExecutionMessagesOutput, bool) bool) error {
	return c.ListFlowExecutionMessagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFlowExecutionMessagesPagesWithContext same as ListFlowExecutionMessagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) ListFlowExecutionMessagesPagesWithContext(ctx aws.Context, input *ListFlowExecutionMessagesInput, fn func(*ListFlowExecutionMessagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFlowExecutionMessagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFlowExecutionMessagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListFlowExecutionMessagesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListTagsForResource
func (c *IoTThingsGraph) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS IoT Things Graph.
//
// Lists all tags on an AWS IoT Things Graph resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListTagsForResource
func (c *IoTThingsGraph) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTagsForResource operation.
//    pageNum := 0
//    err := client.ListTagsForResourcePages(params,
//        func(page *iotthingsgraph.ListTagsForResourceOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTThingsGraph) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSearchEntities = "SearchEntities"

// SearchEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the SearchEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchEntities for more information on using the SearchEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchEntitiesRequest method.
//    req, resp := client.SearchEntitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchEntities
func (c *IoTThingsGraph) SearchEntitiesRequest(input *SearchEntitiesInput) (req *request.Request, output *SearchEntitiesOutput) {
	op := &request.Operation{
		Name:       opSearchEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchEntitiesInput{}
	}

	output = &SearchEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchEntities API operation for AWS IoT Things Graph.
//
// Searches for entities of the specified type. You can search for entities
// in your namespace and the public namespace that you're tracking.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation SearchEntities for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchEntities
func (c *IoTThingsGraph) SearchEntities(input *SearchEntitiesInput) (*SearchEntitiesOutput, error) {
	req, out := c.SearchEntitiesRequest(input)
	return out, req.Send()
}

// SearchEntitiesWithContext is the same as SearchEntities with the addition of
// the ability to pass a context and additional request options.
//
// See SearchEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) SearchEntitiesWithContext(ctx aws.Context, input *SearchEntitiesInput, opts ...request.Option) (*SearchEntitiesOutput, error) {
	req, out := c.SearchEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchEntitiesPages iterates over the pages of a SearchEntities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchEntities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchEntities operation.
//    pageNum := 0
//    err := client.SearchEntitiesPages(params,
//        func(page *iotthingsgraph.SearchEntitiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTThingsGraph) SearchEntitiesPages(input *SearchEntitiesInput, fn func(*SearchEntitiesOutput, bool) bool) error {
	return c.SearchEntitiesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchEntitiesPagesWithContext same as SearchEntitiesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) SearchEntitiesPagesWithContext(ctx aws.Context, input *SearchEntitiesInput, fn func(*SearchEntitiesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchEntitiesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchEntitiesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*SearchEntitiesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSearchFlowExecutions = "SearchFlowExecutions"

// SearchFlowExecutionsRequest generates a "aws/request.Request" representing the
// client's request for the SearchFlowExecutions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchFlowExecutions for more information on using the SearchFlowExecutions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchFlowExecutionsRequest method.
//    req, resp := client.SearchFlowExecutionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowExecutions
func (c *IoTThingsGraph) SearchFlowExecutionsRequest(input *SearchFlowExecutionsInput) (req *request.Request, output *SearchFlowExecutionsOutput) {
	op := &request.Operation{
		Name:       opSearchFlowExecutions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchFlowExecutionsInput{}
	}

	output = &SearchFlowExecutionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchFlowExecutions API operation for AWS IoT Things Graph.
//
// Searches for AWS IoT Things Graph workflow execution instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation SearchFlowExecutions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowExecutions
func (c *IoTThingsGraph) SearchFlowExecutions(input *SearchFlowExecutionsInput) (*SearchFlowExecutionsOutput, error) {
	req, out := c.SearchFlowExecutionsRequest(input)
	return out, req.Send()
}

// SearchFlowExecutionsWithContext is the same as SearchFlowExecutions with the addition of
// the ability to pass a context and additional request options.
//
// See SearchFlowExecutions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) SearchFlowExecutionsWithContext(ctx aws.Context, input *SearchFlowExecutionsInput, opts ...request.Option) (*SearchFlowExecutionsOutput, error) {
	req, out := c.SearchFlowExecutionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchFlowExecutionsPages iterates over the pages of a SearchFlowExecutions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchFlowExecutions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchFlowExecutions operation.
//    pageNum := 0
//    err := client.SearchFlowExecutionsPages(params,
//        func(page *iotthingsgraph.SearchFlowExecutionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTThingsGraph) SearchFlowExecutionsPages(input *SearchFlowExecutionsInput, fn func(*SearchFlowExecutionsOutput, bool) bool) error {
	return c.SearchFlowExecutionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchFlowExecutionsPagesWithContext same as SearchFlowExecutionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) SearchFlowExecutionsPagesWithContext(ctx aws.Context, input *SearchFlowExecutionsInput, fn func(*SearchFlowExecutionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchFlowExecutionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchFlowExecutionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*SearchFlowExecutionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSearchFlowTemplates = "SearchFlowTemplates"

// SearchFlowTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the SearchFlowTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchFlowTemplates for more information on using the SearchFlowTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchFlowTemplatesRequest method.
//    req, resp := client.SearchFlowTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowTemplates
func (c *IoTThingsGraph) SearchFlowTemplatesRequest(input *SearchFlowTemplatesInput) (req *request.Request, output *SearchFlowTemplatesOutput) {
	op := &request.Operation{
		Name:       opSearchFlowTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchFlowTemplatesInput{}
	}

	output = &SearchFlowTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchFlowTemplates API operation for AWS IoT Things Graph.
//
// Searches for summary information about workflows.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation SearchFlowTemplates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowTemplates
func (c *IoTThingsGraph) SearchFlowTemplates(input *SearchFlowTemplatesInput) (*SearchFlowTemplatesOutput, error) {
	req, out := c.SearchFlowTemplatesRequest(input)
	return out, req.Send()
}

// SearchFlowTemplatesWithContext is the same as SearchFlowTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See SearchFlowTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) SearchFlowTemplatesWithContext(ctx aws.Context, input *SearchFlowTemplatesInput, opts ...request.Option) (*SearchFlowTemplatesOutput, error) {
	req, out := c.SearchFlowTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchFlowTemplatesPages iterates over the pages of a SearchFlowTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchFlowTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchFlowTemplates operation.
//    pageNum := 0
//    err := client.SearchFlowTemplatesPages(params,
//        func(page *iotthingsgraph.SearchFlowTemplatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTThingsGraph) SearchFlowTemplatesPages(input *SearchFlowTemplatesInput, fn func(*SearchFlowTemplatesOutput, bool) bool) error {
	return c.SearchFlowTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchFlowTemplatesPagesWithContext same as SearchFlowTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) SearchFlowTemplatesPagesWithContext(ctx aws.Context, input *SearchFlowTemplatesInput, fn func(*SearchFlowTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchFlowTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchFlowTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*SearchFlowTemplatesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSearchSystemInstances = "SearchSystemInstances"

// SearchSystemInstancesRequest generates a "aws/request.Request" representing the
// client's request for the SearchSystemInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchSystemInstances for more information on using the SearchSystemInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchSystemInstancesRequest method.
//    req, resp := client.SearchSystemInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemInstances
func (c *IoTThingsGraph) SearchSystemInstancesRequest(input *SearchSystemInstancesInput) (req *request.Request, output *SearchSystemInstancesOutput) {
	op := &request.Operation{
		Name:       opSearchSystemInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchSystemInstancesInput{}
	}

	output = &SearchSystemInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchSystemInstances API operation for AWS IoT Things Graph.
//
// Searches for system instances in the user's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation SearchSystemInstances for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemInstances
func (c *IoTThingsGraph) SearchSystemInstances(input *SearchSystemInstancesInput) (*SearchSystemInstancesOutput, error) {
	req, out := c.SearchSystemInstancesRequest(input)
	return out, req.Send()
}

// SearchSystemInstancesWithContext is the same as SearchSystemInstances with the addition of
// the ability to pass a context and additional request options.
//
// See SearchSystemInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) SearchSystemInstancesWithContext(ctx aws.Context, input *SearchSystemInstancesInput, opts ...request.Option) (*SearchSystemInstancesOutput, error) {
	req, out := c.SearchSystemInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchSystemInstancesPages iterates over the pages of a SearchSystemInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchSystemInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchSystemInstances operation.
//    pageNum := 0
//    err := client.SearchSystemInstancesPages(params,
//        func(page *iotthingsgraph.SearchSystemInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTThingsGraph) SearchSystemInstancesPages(input *SearchSystemInstancesInput, fn func(*SearchSystemInstancesOutput, bool) bool) error {
	return c.SearchSystemInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchSystemInstancesPagesWithContext same as SearchSystemInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) SearchSystemInstancesPagesWithContext(ctx aws.Context, input *SearchSystemInstancesInput, fn func(*SearchSystemInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchSystemInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchSystemInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*SearchSystemInstancesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSearchSystemTemplates = "SearchSystemTemplates"

// SearchSystemTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the SearchSystemTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchSystemTemplates for more information on using the SearchSystemTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchSystemTemplatesRequest method.
//    req, resp := client.SearchSystemTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemTemplates
func (c *IoTThingsGraph) SearchSystemTemplatesRequest(input *SearchSystemTemplatesInput) (req *request.Request, output *SearchSystemTemplatesOutput) {
	op := &request.Operation{
		Name:       opSearchSystemTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchSystemTemplatesInput{}
	}

	output = &SearchSystemTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchSystemTemplates API operation for AWS IoT Things Graph.
//
// Searches for summary information about systems in the user's account. You
// can filter by the ID of a workflow to return only systems that use the specified
// workflow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation SearchSystemTemplates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemTemplates
func (c *IoTThingsGraph) SearchSystemTemplates(input *SearchSystemTemplatesInput) (*SearchSystemTemplatesOutput, error) {
	req, out := c.SearchSystemTemplatesRequest(input)
	return out, req.Send()
}

// SearchSystemTemplatesWithContext is the same as SearchSystemTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See SearchSystemTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) SearchSystemTemplatesWithContext(ctx aws.Context, input *SearchSystemTemplatesInput, opts ...request.Option) (*SearchSystemTemplatesOutput, error) {
	req, out := c.SearchSystemTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchSystemTemplatesPages iterates over the pages of a SearchSystemTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchSystemTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchSystemTemplates operation.
//    pageNum := 0
//    err := client.SearchSystemTemplatesPages(params,
//        func(page *iotthingsgraph.SearchSystemTemplatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTThingsGraph) SearchSystemTemplatesPages(input *SearchSystemTemplatesInput, fn func(*SearchSystemTemplatesOutput, bool) bool) error {
	return c.SearchSystemTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchSystemTemplatesPagesWithContext same as SearchSystemTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) SearchSystemTemplatesPagesWithContext(ctx aws.Context, input *SearchSystemTemplatesInput, fn func(*SearchSystemTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchSystemTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchSystemTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*SearchSystemTemplatesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opSearchThings = "SearchThings"

// SearchThingsRequest generates a "aws/request.Request" representing the
// client's request for the SearchThings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchThings for more information on using the SearchThings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchThingsRequest method.
//    req, resp := client.SearchThingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchThings
func (c *IoTThingsGraph) SearchThingsRequest(input *SearchThingsInput) (req *request.Request, output *SearchThingsOutput) {
	op := &request.Operation{
		Name:       opSearchThings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchThingsInput{}
	}

	output = &SearchThingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchThings API operation for AWS IoT Things Graph.
//
// Searches for things associated with the specified entity. You can search
// by both device and device model.
//
// For example, if two different devices, camera1 and camera2, implement the
// camera device model, the user can associate thing1 to camera1 and thing2
// to camera2. SearchThings(camera2) will return only thing2, but SearchThings(camera)
// will return both thing1 and thing2.
//
// This action searches for exact matches and doesn't perform partial text matching.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation SearchThings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchThings
func (c *IoTThingsGraph) SearchThings(input *SearchThingsInput) (*SearchThingsOutput, error) {
	req, out := c.SearchThingsRequest(input)
	return out, req.Send()
}

// SearchThingsWithContext is the same as SearchThings with the addition of
// the ability to pass a context and additional request options.
//
// See SearchThings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) SearchThingsWithContext(ctx aws.Context, input *SearchThingsInput, opts ...request.Option) (*SearchThingsOutput, error) {
	req, out := c.SearchThingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchThingsPages iterates over the pages of a SearchThings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchThings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchThings operation.
//    pageNum := 0
//    err := client.SearchThingsPages(params,
//        func(page *iotthingsgraph.SearchThingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTThingsGraph) SearchThingsPages(input *SearchThingsInput, fn func(*SearchThingsOutput, bool) bool) error {
	return c.SearchThingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchThingsPagesWithContext same as SearchThingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) SearchThingsPagesWithContext(ctx aws.Context, input *SearchThingsInput, fn func(*SearchThingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchThingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchThingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*SearchThingsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/TagResource
func (c *IoTThingsGraph) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS IoT Things Graph.
//
// Creates a tag for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/TagResource
func (c *IoTThingsGraph) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUndeploySystemInstance = "UndeploySystemInstance"

// UndeploySystemInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UndeploySystemInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UndeploySystemInstance for more information on using the UndeploySystemInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UndeploySystemInstanceRequest method.
//    req, resp := client.UndeploySystemInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UndeploySystemInstance
func (c *IoTThingsGraph) UndeploySystemInstanceRequest(input *UndeploySystemInstanceInput) (req *request.Request, output *UndeploySystemInstanceOutput) {
	op := &request.Operation{
		Name:       opUndeploySystemInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UndeploySystemInstanceInput{}
	}

	output = &UndeploySystemInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UndeploySystemInstance API operation for AWS IoT Things Graph.
//
// Removes a system instance from its target (Cloud or Greengrass).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation UndeploySystemInstance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UndeploySystemInstance
func (c *IoTThingsGraph) UndeploySystemInstance(input *UndeploySystemInstanceInput) (*UndeploySystemInstanceOutput, error) {
	req, out := c.UndeploySystemInstanceRequest(input)
	return out, req.Send()
}

// UndeploySystemInstanceWithContext is the same as UndeploySystemInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UndeploySystemInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) UndeploySystemInstanceWithContext(ctx aws.Context, input *UndeploySystemInstanceInput, opts ...request.Option) (*UndeploySystemInstanceOutput, error) {
	req, out := c.UndeploySystemInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UntagResource
func (c *IoTThingsGraph) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS IoT Things Graph.
//
// Removes a tag from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UntagResource
func (c *IoTThingsGraph) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlowTemplate = "UpdateFlowTemplate"

// UpdateFlowTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlowTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlowTemplate for more information on using the UpdateFlowTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateFlowTemplateRequest method.
//    req, resp := client.UpdateFlowTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateFlowTemplate
func (c *IoTThingsGraph) UpdateFlowTemplateRequest(input *UpdateFlowTemplateInput) (req *request.Request, output *UpdateFlowTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateFlowTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFlowTemplateInput{}
	}

	output = &UpdateFlowTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlowTemplate API operation for AWS IoT Things Graph.
//
// Updates the specified workflow. All deployed systems and system instances
// that use the workflow will see the changes in the flow when it is redeployed.
// If you don't want this behavior, copy the workflow (creating a new workflow
// with a different ID), and update the copy. The workflow can contain only
// entities in the specified namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation UpdateFlowTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateFlowTemplate
func (c *IoTThingsGraph) UpdateFlowTemplate(input *UpdateFlowTemplateInput) (*UpdateFlowTemplateOutput, error) {
	req, out := c.UpdateFlowTemplateRequest(input)
	return out, req.Send()
}

// UpdateFlowTemplateWithContext is the same as UpdateFlowTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlowTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) UpdateFlowTemplateWithContext(ctx aws.Context, input *UpdateFlowTemplateInput, opts ...request.Option) (*UpdateFlowTemplateOutput, error) {
	req, out := c.UpdateFlowTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSystemTemplate = "UpdateSystemTemplate"

// UpdateSystemTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSystemTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSystemTemplate for more information on using the UpdateSystemTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSystemTemplateRequest method.
//    req, resp := client.UpdateSystemTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateSystemTemplate
func (c *IoTThingsGraph) UpdateSystemTemplateRequest(input *UpdateSystemTemplateInput) (req *request.Request, output *UpdateSystemTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateSystemTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSystemTemplateInput{}
	}

	output = &UpdateSystemTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSystemTemplate API operation for AWS IoT Things Graph.
//
// Updates the specified system. You don't need to run this action after updating
// a workflow. Any deployment that uses the system will see the changes in the
// system when it is redeployed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation UpdateSystemTemplate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateSystemTemplate
func (c *IoTThingsGraph) UpdateSystemTemplate(input *UpdateSystemTemplateInput) (*UpdateSystemTemplateOutput, error) {
	req, out := c.UpdateSystemTemplateRequest(input)
	return out, req.Send()
}

// UpdateSystemTemplateWithContext is the same as UpdateSystemTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSystemTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) UpdateSystemTemplateWithContext(ctx aws.Context, input *UpdateSystemTemplateInput, opts ...request.Option) (*UpdateSystemTemplateOutput, error) {
	req, out := c.UpdateSystemTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUploadEntityDefinitions = "UploadEntityDefinitions"

// UploadEntityDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the UploadEntityDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UploadEntityDefinitions for more information on using the UploadEntityDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UploadEntityDefinitionsRequest method.
//    req, resp := client.UploadEntityDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UploadEntityDefinitions
func (c *IoTThingsGraph) UploadEntityDefinitionsRequest(input *UploadEntityDefinitionsInput) (req *request.Request, output *UploadEntityDefinitionsOutput) {
	op := &request.Operation{
		Name:       opUploadEntityDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UploadEntityDefinitionsInput{}
	}

	output = &UploadEntityDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UploadEntityDefinitions API operation for AWS IoT Things Graph.
//
// Asynchronously uploads one or more entity definitions to the user's namespace.
// The document parameter is required if syncWithPublicNamespace and deleteExistingEntites
// are false. If the syncWithPublicNamespace parameter is set to true, the user's
// namespace will synchronize with the latest version of the public namespace.
// If deprecateExistingEntities is set to true, all entities in the latest version
// will be deleted before the new DefinitionDocument is uploaded.
//
// When a user uploads entity definitions for the first time, the service creates
// a new namespace for the user. The new namespace tracks the public namespace.
// Currently users can have only one namespace. The namespace version increments
// whenever a user uploads entity definitions that are backwards-incompatible
// and whenever a user sets the syncWithPublicNamespace parameter or the deprecateExistingEntities
// parameter to true.
//
// The IDs for all of the entities should be in URN format. Each entity must
// be in the user's namespace. Users can't create entities in the public namespace,
// but entity definitions can refer to entities in the public namespace.
//
// Valid entities are Device, DeviceModel, Service, Capability, State, Action,
// Event, Property, Mapping, Enum.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Things Graph's
// API operation UploadEntityDefinitions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidRequestException "InvalidRequestException"
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//
//   * ErrCodeThrottlingException "ThrottlingException"
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UploadEntityDefinitions
func (c *IoTThingsGraph) UploadEntityDefinitions(input *UploadEntityDefinitionsInput) (*UploadEntityDefinitionsOutput, error) {
	req, out := c.UploadEntityDefinitionsRequest(input)
	return out, req.Send()
}

// UploadEntityDefinitionsWithContext is the same as UploadEntityDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See UploadEntityDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTThingsGraph) UploadEntityDefinitionsWithContext(ctx aws.Context, input *UploadEntityDefinitionsInput, opts ...request.Option) (*UploadEntityDefinitionsOutput, error) {
	req, out := c.UploadEntityDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AssociateEntityToThingInput struct {
	_ struct{} `type:"structure"`

	// The ID of the device to be associated with the thing.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME
	//
	// EntityId is a required field
	EntityId *string `locationName:"entityId" type:"string" required:"true"`

	// The version of the user's namespace. Defaults to the latest version of the
	// user's namespace.
	NamespaceVersion *int64 `locationName:"namespaceVersion" type:"long"`

	// The name of the thing to which the entity is to be associated.
	//
	// ThingName is a required field
	ThingName *string `locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateEntityToThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateEntityToThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateEntityToThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateEntityToThingInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *AssociateEntityToThingInput) SetEntityId(v string) *AssociateEntityToThingInput {
	s.EntityId = &v
	return s
}

// SetNamespaceVersion sets the NamespaceVersion field's value.
func (s *AssociateEntityToThingInput) SetNamespaceVersion(v int64) *AssociateEntityToThingInput {
	s.NamespaceVersion = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *AssociateEntityToThingInput) SetThingName(v string) *AssociateEntityToThingInput {
	s.ThingName = &v
	return s
}

type AssociateEntityToThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateEntityToThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateEntityToThingOutput) GoString() string {
	return s.String()
}

type CreateFlowTemplateInput struct {
	_ struct{} `type:"structure"`

	// The namespace version in which the workflow is to be created.
	//
	// If no value is specified, the latest version is used by default.
	CompatibleNamespaceVersion *int64 `locationName:"compatibleNamespaceVersion" type:"long"`

	// The workflow DefinitionDocument.
	//
	// Definition is a required field
	Definition *DefinitionDocument `locationName:"definition" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateFlowTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFlowTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFlowTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFlowTemplateInput"}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompatibleNamespaceVersion sets the CompatibleNamespaceVersion field's value.
func (s *CreateFlowTemplateInput) SetCompatibleNamespaceVersion(v int64) *CreateFlowTemplateInput {
	s.CompatibleNamespaceVersion = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *CreateFlowTemplateInput) SetDefinition(v *DefinitionDocument) *CreateFlowTemplateInput {
	s.Definition = v
	return s
}

type CreateFlowTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The summary object that describes the created workflow.
	Summary *FlowTemplateSummary `locationName:"summary" type:"structure"`
}

// String returns the string representation
func (s CreateFlowTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFlowTemplateOutput) GoString() string {
	return s.String()
}

// SetSummary sets the Summary field's value.
func (s *CreateFlowTemplateOutput) SetSummary(v *FlowTemplateSummary) *CreateFlowTemplateOutput {
	s.Summary = v
	return s
}

type CreateSystemInstanceInput struct {
	_ struct{} `type:"structure"`

	// A document that defines an entity.
	//
	// Definition is a required field
	Definition *DefinitionDocument `locationName:"definition" type:"structure" required:"true"`

	// The ARN of the IAM role that AWS IoT Things Graph will assume when it executes
	// the flow. This role must have read and write access to AWS Lambda and AWS
	// IoT and any other AWS services that the flow uses when it executes. This
	// value is required if the value of the target parameter is CLOUD.
	FlowActionsRoleArn *string `locationName:"flowActionsRoleArn" min:"20" type:"string"`

	// The name of the Greengrass group where the system instance will be deployed.
	// This value is required if the value of the target parameter is GREENGRASS.
	GreengrassGroupName *string `locationName:"greengrassGroupName" type:"string"`

	// An object that specifies whether cloud metrics are collected in a deployment
	// and, if so, what role is used to collect metrics.
	MetricsConfiguration *MetricsConfiguration `locationName:"metricsConfiguration" type:"structure"`

	// The name of the Amazon Simple Storage Service bucket that will be used to
	// store and deploy the system instance's resource file. This value is required
	// if the value of the target parameter is GREENGRASS.
	S3BucketName *string `locationName:"s3BucketName" type:"string"`

	// Metadata, consisting of key-value pairs, that can be used to categorize your
	// system instances.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The target type of the deployment. Valid values are GREENGRASS and CLOUD.
	//
	// Target is a required field
	Target *string `locationName:"target" type:"string" required:"true" enum:"DeploymentTarget"`
}

// String returns the string representation
func (s CreateSystemInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSystemInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSystemInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSystemInstanceInput"}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}
	if s.FlowActionsRoleArn != nil && len(*s.FlowActionsRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("FlowActionsRoleArn", 20))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}
	if s.MetricsConfiguration != nil {
		if err := s.MetricsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MetricsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefinition sets the Definition field's value.
func (s *CreateSystemInstanceInput) SetDefinition(v *DefinitionDocument) *CreateSystemInstanceInput {
	s.Definition = v
	return s
}

// SetFlowActionsRoleArn sets the FlowActionsRoleArn field's value.
func (s *CreateSystemInstanceInput) SetFlowActionsRoleArn(v string) *CreateSystemInstanceInput {
	s.FlowActionsRoleArn = &v
	return s
}

// SetGreengrassGroupName sets the GreengrassGroupName field's value.
func (s *CreateSystemInstanceInput) SetGreengrassGroupName(v string) *CreateSystemInstanceInput {
	s.GreengrassGroupName = &v
	return s
}

// SetMetricsConfiguration sets the MetricsConfiguration field's value.
func (s *CreateSystemInstanceInput) SetMetricsConfiguration(v *MetricsConfiguration) *CreateSystemInstanceInput {
	s.MetricsConfiguration = v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *CreateSystemInstanceInput) SetS3BucketName(v string) *CreateSystemInstanceInput {
	s.S3BucketName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSystemInstanceInput) SetTags(v []*Tag) *CreateSystemInstanceInput {
	s.Tags = v
	return s
}

// SetTarget sets the Target field's value.
func (s *CreateSystemInstanceInput) SetTarget(v string) *CreateSystemInstanceInput {
	s.Target = &v
	return s
}

type CreateSystemInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The summary object that describes the new system instance.
	Summary *SystemInstanceSummary `locationName:"summary" type:"structure"`
}

// String returns the string representation
func (s CreateSystemInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSystemInstanceOutput) GoString() string {
	return s.String()
}

// SetSummary sets the Summary field's value.
func (s *CreateSystemInstanceOutput) SetSummary(v *SystemInstanceSummary) *CreateSystemInstanceOutput {
	s.Summary = v
	return s
}

type CreateSystemTemplateInput struct {
	_ struct{} `type:"structure"`

	// The namespace version in which the system is to be created.
	//
	// If no value is specified, the latest version is used by default.
	CompatibleNamespaceVersion *int64 `locationName:"compatibleNamespaceVersion" type:"long"`

	// The DefinitionDocument used to create the system.
	//
	// Definition is a required field
	Definition *DefinitionDocument `locationName:"definition" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateSystemTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSystemTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSystemTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSystemTemplateInput"}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompatibleNamespaceVersion sets the CompatibleNamespaceVersion field's value.
func (s *CreateSystemTemplateInput) SetCompatibleNamespaceVersion(v int64) *CreateSystemTemplateInput {
	s.CompatibleNamespaceVersion = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *CreateSystemTemplateInput) SetDefinition(v *DefinitionDocument) *CreateSystemTemplateInput {
	s.Definition = v
	return s
}

type CreateSystemTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The summary object that describes the created system.
	Summary *SystemTemplateSummary `locationName:"summary" type:"structure"`
}

// String returns the string representation
func (s CreateSystemTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSystemTemplateOutput) GoString() string {
	return s.String()
}

// SetSummary sets the Summary field's value.
func (s *CreateSystemTemplateOutput) SetSummary(v *SystemTemplateSummary) *CreateSystemTemplateOutput {
	s.Summary = v
	return s
}

// A document that defines an entity.
type DefinitionDocument struct {
	_ struct{} `type:"structure"`

	// The language used to define the entity. GRAPHQL is the only valid value.
	//
	// Language is a required field
	Language *string `locationName:"language" type:"string" required:"true" enum:"DefinitionLanguage"`

	// The GraphQL text that defines the entity.
	//
	// Text is a required field
	Text *string `locationName:"text" type:"string" required:"true"`
}

// String returns the string representation
func (s DefinitionDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefinitionDocument) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DefinitionDocument) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DefinitionDocument"}
	if s.Language == nil {
		invalidParams.Add(request.NewErrParamRequired("Language"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguage sets the Language field's value.
func (s *DefinitionDocument) SetLanguage(v string) *DefinitionDocument {
	s.Language = &v
	return s
}

// SetText sets the Text field's value.
func (s *DefinitionDocument) SetText(v string) *DefinitionDocument {
	s.Text = &v
	return s
}

type DeleteFlowTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the workflow to be deleted.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFlowTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFlowTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFlowTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFlowTemplateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteFlowTemplateInput) SetId(v string) *DeleteFlowTemplateInput {
	s.Id = &v
	return s
}

type DeleteFlowTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFlowTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFlowTemplateOutput) GoString() string {
	return s.String()
}

type DeleteNamespaceInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNamespaceInput) GoString() string {
	return s.String()
}

type DeleteNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the namespace to be deleted.
	NamespaceArn *string `locationName:"namespaceArn" type:"string"`

	// The name of the namespace to be deleted.
	NamespaceName *string `locationName:"namespaceName" type:"string"`
}

// String returns the string representation
func (s DeleteNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNamespaceOutput) GoString() string {
	return s.String()
}

// SetNamespaceArn sets the NamespaceArn field's value.
func (s *DeleteNamespaceOutput) SetNamespaceArn(v string) *DeleteNamespaceOutput {
	s.NamespaceArn = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *DeleteNamespaceOutput) SetNamespaceName(v string) *DeleteNamespaceOutput {
	s.NamespaceName = &v
	return s
}

type DeleteSystemInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the system instance to be deleted.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s DeleteSystemInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSystemInstanceInput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DeleteSystemInstanceInput) SetId(v string) *DeleteSystemInstanceInput {
	s.Id = &v
	return s
}

type DeleteSystemInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSystemInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSystemInstanceOutput) GoString() string {
	return s.String()
}

type DeleteSystemTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the system to be deleted.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSystemTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSystemTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSystemTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSystemTemplateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteSystemTemplateInput) SetId(v string) *DeleteSystemTemplateInput {
	s.Id = &v
	return s
}

type DeleteSystemTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSystemTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSystemTemplateOutput) GoString() string {
	return s.String()
}

// An object that contains the ID and revision number of a workflow or system
// that is part of a deployment.
type DependencyRevision struct {
	_ struct{} `type:"structure"`

	// The ID of the workflow or system.
	Id *string `locationName:"id" type:"string"`

	// The revision number of the workflow or system.
	RevisionNumber *int64 `locationName:"revisionNumber" type:"long"`
}

// String returns the string representation
func (s DependencyRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DependencyRevision) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DependencyRevision) SetId(v string) *DependencyRevision {
	s.Id = &v
	return s
}

// SetRevisionNumber sets the RevisionNumber field's value.
func (s *DependencyRevision) SetRevisionNumber(v int64) *DependencyRevision {
	s.RevisionNumber = &v
	return s
}

type DeploySystemInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the system instance. This value is returned by the CreateSystemInstance
	// action.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s DeploySystemInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploySystemInstanceInput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DeploySystemInstanceInput) SetId(v string) *DeploySystemInstanceInput {
	s.Id = &v
	return s
}

type DeploySystemInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the Greengrass deployment used to deploy the system instance.
	GreengrassDeploymentId *string `locationName:"greengrassDeploymentId" type:"string"`

	// An object that contains summary information about a system instance that
	// was deployed.
	//
	// Summary is a required field
	Summary *SystemInstanceSummary `locationName:"summary" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeploySystemInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploySystemInstanceOutput) GoString() string {
	return s.String()
}

// SetGreengrassDeploymentId sets the GreengrassDeploymentId field's value.
func (s *DeploySystemInstanceOutput) SetGreengrassDeploymentId(v string) *DeploySystemInstanceOutput {
	s.GreengrassDeploymentId = &v
	return s
}

// SetSummary sets the Summary field's value.
func (s *DeploySystemInstanceOutput) SetSummary(v *SystemInstanceSummary) *DeploySystemInstanceOutput {
	s.Summary = v
	return s
}

type DeprecateFlowTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the workflow to be deleted.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeprecateFlowTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateFlowTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeprecateFlowTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeprecateFlowTemplateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeprecateFlowTemplateInput) SetId(v string) *DeprecateFlowTemplateInput {
	s.Id = &v
	return s
}

type DeprecateFlowTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeprecateFlowTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateFlowTemplateOutput) GoString() string {
	return s.String()
}

type DeprecateSystemTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the system to delete.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeprecateSystemTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateSystemTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeprecateSystemTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeprecateSystemTemplateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeprecateSystemTemplateInput) SetId(v string) *DeprecateSystemTemplateInput {
	s.Id = &v
	return s
}

type DeprecateSystemTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeprecateSystemTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeprecateSystemTemplateOutput) GoString() string {
	return s.String()
}

type DescribeNamespaceInput struct {
	_ struct{} `type:"structure"`

	// The name of the user's namespace. Set this to aws to get the public namespace.
	NamespaceName *string `locationName:"namespaceName" type:"string"`
}

// String returns the string representation
func (s DescribeNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNamespaceInput) GoString() string {
	return s.String()
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *DescribeNamespaceInput) SetNamespaceName(v string) *DescribeNamespaceInput {
	s.NamespaceName = &v
	return s
}

type DescribeNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the namespace.
	NamespaceArn *string `locationName:"namespaceArn" type:"string"`

	// The name of the namespace.
	NamespaceName *string `locationName:"namespaceName" type:"string"`

	// The version of the user's namespace to describe.
	NamespaceVersion *int64 `locationName:"namespaceVersion" type:"long"`

	// The name of the public namespace that the latest namespace version is tracking.
	TrackingNamespaceName *string `locationName:"trackingNamespaceName" type:"string"`

	// The version of the public namespace that the latest version is tracking.
	TrackingNamespaceVersion *int64 `locationName:"trackingNamespaceVersion" type:"long"`
}

// String returns the string representation
func (s DescribeNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNamespaceOutput) GoString() string {
	return s.String()
}

// SetNamespaceArn sets the NamespaceArn field's value.
func (s *DescribeNamespaceOutput) SetNamespaceArn(v string) *DescribeNamespaceOutput {
	s.NamespaceArn = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *DescribeNamespaceOutput) SetNamespaceName(v string) *DescribeNamespaceOutput {
	s.NamespaceName = &v
	return s
}

// SetNamespaceVersion sets the NamespaceVersion field's value.
func (s *DescribeNamespaceOutput) SetNamespaceVersion(v int64) *DescribeNamespaceOutput {
	s.NamespaceVersion = &v
	return s
}

// SetTrackingNamespaceName sets the TrackingNamespaceName field's value.
func (s *DescribeNamespaceOutput) SetTrackingNamespaceName(v string) *DescribeNamespaceOutput {
	s.TrackingNamespaceName = &v
	return s
}

// SetTrackingNamespaceVersion sets the TrackingNamespaceVersion field's value.
func (s *DescribeNamespaceOutput) SetTrackingNamespaceVersion(v int64) *DescribeNamespaceOutput {
	s.TrackingNamespaceVersion = &v
	return s
}

type DissociateEntityFromThingInput struct {
	_ struct{} `type:"structure"`

	// The entity type from which to disassociate the thing.
	//
	// EntityType is a required field
	EntityType *string `locationName:"entityType" type:"string" required:"true" enum:"EntityType"`

	// The name of the thing to disassociate.
	//
	// ThingName is a required field
	ThingName *string `locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DissociateEntityFromThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DissociateEntityFromThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DissociateEntityFromThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DissociateEntityFromThingInput"}
	if s.EntityType == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityType"))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityType sets the EntityType field's value.
func (s *DissociateEntityFromThingInput) SetEntityType(v string) *DissociateEntityFromThingInput {
	s.EntityType = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DissociateEntityFromThingInput) SetThingName(v string) *DissociateEntityFromThingInput {
	s.ThingName = &v
	return s
}

type DissociateEntityFromThingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DissociateEntityFromThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DissociateEntityFromThingOutput) GoString() string {
	return s.String()
}

// Describes the properties of an entity.
type EntityDescription struct {
	_ struct{} `type:"structure"`

	// The entity ARN.
	Arn *string `locationName:"arn" type:"string"`

	// The time at which the entity was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The definition document of the entity.
	Definition *DefinitionDocument `locationName:"definition" type:"structure"`

	// The entity ID.
	Id *string `locationName:"id" type:"string"`

	// The entity type.
	Type *string `locationName:"type" type:"string" enum:"EntityType"`
}

// String returns the string representation
func (s EntityDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityDescription) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EntityDescription) SetArn(v string) *EntityDescription {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *EntityDescription) SetCreatedAt(v time.Time) *EntityDescription {
	s.CreatedAt = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *EntityDescription) SetDefinition(v *DefinitionDocument) *EntityDescription {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *EntityDescription) SetId(v string) *EntityDescription {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *EntityDescription) SetType(v string) *EntityDescription {
	s.Type = &v
	return s
}

// An object that filters an entity search. Multiple filters function as OR
// criteria in the search. For example a search that includes a NAMESPACE and
// a REFERENCED_ENTITY_ID filter searches for entities in the specified namespace
// that use the entity specified by the value of REFERENCED_ENTITY_ID.
type EntityFilter struct {
	_ struct{} `type:"structure"`

	// The name of the entity search filter field. REFERENCED_ENTITY_ID filters
	// on entities that are used by the entity in the result set. For example, you
	// can filter on the ID of a property that is used in a state.
	Name *string `locationName:"name" type:"string" enum:"EntityFilterName"`

	// An array of string values for the search filter field. Multiple values function
	// as AND criteria in the search.
	Value []*string `locationName:"value" type:"list"`
}

// String returns the string representation
func (s EntityFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityFilter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *EntityFilter) SetName(v string) *EntityFilter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EntityFilter) SetValue(v []*string) *EntityFilter {
	s.Value = v
	return s
}

// An object that contains information about a flow event.
type FlowExecutionMessage struct {
	_ struct{} `type:"structure"`

	// The type of flow event .
	EventType *string `locationName:"eventType" type:"string" enum:"FlowExecutionEventType"`

	// The unique identifier of the message.
	MessageId *string `locationName:"messageId" type:"string"`

	// A string containing information about the flow event.
	Payload *string `locationName:"payload" type:"string"`

	// The date and time when the message was last updated.
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp"`
}

// String returns the string representation
func (s FlowExecutionMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FlowExecutionMessage) GoString() string {
	return s.String()
}

// SetEventType sets the EventType field's value.
func (s *FlowExecutionMessage) SetEventType(v string) *FlowExecutionMessage {
	s.EventType = &v
	return s
}

// SetMessageId sets the MessageId field's value.
func (s *FlowExecutionMessage) SetMessageId(v string) *FlowExecutionMessage {
	s.MessageId = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *FlowExecutionMessage) SetPayload(v string) *FlowExecutionMessage {
	s.Payload = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *FlowExecutionMessage) SetTimestamp(v time.Time) *FlowExecutionMessage {
	s.Timestamp = &v
	return s
}

// An object that contains summary information about a flow execution.
type FlowExecutionSummary struct {
	_ struct{} `type:"structure"`

	// The date and time when the flow execution summary was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ID of the flow execution.
	FlowExecutionId *string `locationName:"flowExecutionId" type:"string"`

	// The ID of the flow.
	FlowTemplateId *string `locationName:"flowTemplateId" type:"string"`

	// The current status of the flow execution.
	Status *string `locationName:"status" type:"string" enum:"FlowExecutionStatus"`

	// The ID of the system instance that contains the flow.
	SystemInstanceId *string `locationName:"systemInstanceId" type:"string"`

	// The date and time when the flow execution summary was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation
func (s FlowExecutionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FlowExecutionSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FlowExecutionSummary) SetCreatedAt(v time.Time) *FlowExecutionSummary {
	s.CreatedAt = &v
	return s
}

// SetFlowExecutionId sets the FlowExecutionId field's value.
func (s *FlowExecutionSummary) SetFlowExecutionId(v string) *FlowExecutionSummary {
	s.FlowExecutionId = &v
	return s
}

// SetFlowTemplateId sets the FlowTemplateId field's value.
func (s *FlowExecutionSummary) SetFlowTemplateId(v string) *FlowExecutionSummary {
	s.FlowTemplateId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FlowExecutionSummary) SetStatus(v string) *FlowExecutionSummary {
	s.Status = &v
	return s
}

// SetSystemInstanceId sets the SystemInstanceId field's value.
func (s *FlowExecutionSummary) SetSystemInstanceId(v string) *FlowExecutionSummary {
	s.SystemInstanceId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *FlowExecutionSummary) SetUpdatedAt(v time.Time) *FlowExecutionSummary {
	s.UpdatedAt = &v
	return s
}

// An object that contains a workflow's definition and summary information.
type FlowTemplateDescription struct {
	_ struct{} `type:"structure"`

	// A workflow's definition document.
	Definition *DefinitionDocument `locationName:"definition" type:"structure"`

	// An object that contains summary information about a workflow.
	Summary *FlowTemplateSummary `locationName:"summary" type:"structure"`

	// The version of the user's namespace against which the workflow was validated.
	// Use this value in your system instance.
	ValidatedNamespaceVersion *int64 `locationName:"validatedNamespaceVersion" type:"long"`
}

// String returns the string representation
func (s FlowTemplateDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FlowTemplateDescription) GoString() string {
	return s.String()
}

// SetDefinition sets the Definition field's value.
func (s *FlowTemplateDescription) SetDefinition(v *DefinitionDocument) *FlowTemplateDescription {
	s.Definition = v
	return s
}

// SetSummary sets the Summary field's value.
func (s *FlowTemplateDescription) SetSummary(v *FlowTemplateSummary) *FlowTemplateDescription {
	s.Summary = v
	return s
}

// SetValidatedNamespaceVersion sets the ValidatedNamespaceVersion field's value.
func (s *FlowTemplateDescription) SetValidatedNamespaceVersion(v int64) *FlowTemplateDescription {
	s.ValidatedNamespaceVersion = &v
	return s
}

// An object that filters a workflow search.
type FlowTemplateFilter struct {
	_ struct{} `type:"structure"`

	// The name of the search filter field.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"FlowTemplateFilterName"`

	// An array of string values for the search filter field. Multiple values function
	// as AND criteria in the search.
	//
	// Value is a required field
	Value []*string `locationName:"value" type:"list" required:"true"`
}

// String returns the string representation
func (s FlowTemplateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FlowTemplateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowTemplateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlowTemplateFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *FlowTemplateFilter) SetName(v string) *FlowTemplateFilter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FlowTemplateFilter) SetValue(v []*string) *FlowTemplateFilter {
	s.Value = v
	return s
}

// An object that contains summary information about a workflow.
type FlowTemplateSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the workflow.
	Arn *string `locationName:"arn" type:"string"`

	// The date when the workflow was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ID of the workflow.
	Id *string `locationName:"id" type:"string"`

	// The revision number of the workflow.
	RevisionNumber *int64 `locationName:"revisionNumber" type:"long"`
}

// String returns the string representation
func (s FlowTemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FlowTemplateSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *FlowTemplateSummary) SetArn(v string) *FlowTemplateSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FlowTemplateSummary) SetCreatedAt(v time.Time) *FlowTemplateSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *FlowTemplateSummary) SetId(v string) *FlowTemplateSummary {
	s.Id = &v
	return s
}

// SetRevisionNumber sets the RevisionNumber field's value.
func (s *FlowTemplateSummary) SetRevisionNumber(v int64) *FlowTemplateSummary {
	s.RevisionNumber = &v
	return s
}

type GetEntitiesInput struct {
	_ struct{} `type:"structure"`

	// An array of entity IDs.
	//
	// The IDs should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME
	//
	// Ids is a required field
	Ids []*string `locationName:"ids" type:"list" required:"true"`

	// The version of the user's namespace. Defaults to the latest version of the
	// user's namespace.
	NamespaceVersion *int64 `locationName:"namespaceVersion" type:"long"`
}

// String returns the string representation
func (s GetEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEntitiesInput"}
	if s.Ids == nil {
		invalidParams.Add(request.NewErrParamRequired("Ids"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIds sets the Ids field's value.
func (s *GetEntitiesInput) SetIds(v []*string) *GetEntitiesInput {
	s.Ids = v
	return s
}

// SetNamespaceVersion sets the NamespaceVersion field's value.
func (s *GetEntitiesInput) SetNamespaceVersion(v int64) *GetEntitiesInput {
	s.NamespaceVersion = &v
	return s
}

type GetEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// An array of descriptions for the specified entities.
	Descriptions []*EntityDescription `locationName:"descriptions" type:"list"`
}

// String returns the string representation
func (s GetEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEntitiesOutput) GoString() string {
	return s.String()
}

// SetDescriptions sets the Descriptions field's value.
func (s *GetEntitiesOutput) SetDescriptions(v []*EntityDescription) *GetEntitiesOutput {
	s.Descriptions = v
	return s
}

type GetFlowTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the workflow.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The number of the workflow revision to retrieve.
	RevisionNumber *int64 `locationName:"revisionNumber" type:"long"`
}

// String returns the string representation
func (s GetFlowTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFlowTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFlowTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFlowTemplateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetFlowTemplateInput) SetId(v string) *GetFlowTemplateInput {
	s.Id = &v
	return s
}

// SetRevisionNumber sets the RevisionNumber field's value.
func (s *GetFlowTemplateInput) SetRevisionNumber(v int64) *GetFlowTemplateInput {
	s.RevisionNumber = &v
	return s
}

type GetFlowTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The object that describes the specified workflow.
	Description *FlowTemplateDescription `locationName:"description" type:"structure"`
}

// String returns the string representation
func (s GetFlowTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFlowTemplateOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GetFlowTemplateOutput) SetDescription(v *FlowTemplateDescription) *GetFlowTemplateOutput {
	s.Description = v
	return s
}

type GetFlowTemplateRevisionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the workflow.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The string that specifies the next page of results. Use this when you're
	// paginating results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetFlowTemplateRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFlowTemplateRevisionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFlowTemplateRevisionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFlowTemplateRevisionsInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetFlowTemplateRevisionsInput) SetId(v string) *GetFlowTemplateRevisionsInput {
	s.Id = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetFlowTemplateRevisionsInput) SetMaxResults(v int64) *GetFlowTemplateRevisionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetFlowTemplateRevisionsInput) SetNextToken(v string) *GetFlowTemplateRevisionsInput {
	s.NextToken = &v
	return s
}

type GetFlowTemplateRevisionsOutput struct {
	_ struct{} `type:"structure"`

	// The string to specify as nextToken when you request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that provide summary data about each revision.
	Summaries []*FlowTemplateSummary `locationName:"summaries" type:"list"`
}

// String returns the string representation
func (s GetFlowTemplateRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFlowTemplateRevisionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetFlowTemplateRevisionsOutput) SetNextToken(v string) *GetFlowTemplateRevisionsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *GetFlowTemplateRevisionsOutput) SetSummaries(v []*FlowTemplateSummary) *GetFlowTemplateRevisionsOutput {
	s.Summaries = v
	return s
}

type GetNamespaceDeletionStatusInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetNamespaceDeletionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNamespaceDeletionStatusInput) GoString() string {
	return s.String()
}

type GetNamespaceDeletionStatusOutput struct {
	_ struct{} `type:"structure"`

	// An error code returned by the namespace deletion task.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"NamespaceDeletionStatusErrorCodes"`

	// An error code returned by the namespace deletion task.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The ARN of the namespace that is being deleted.
	NamespaceArn *string `locationName:"namespaceArn" type:"string"`

	// The name of the namespace that is being deleted.
	NamespaceName *string `locationName:"namespaceName" type:"string"`

	// The status of the deletion request.
	Status *string `locationName:"status" type:"string" enum:"NamespaceDeletionStatus"`
}

// String returns the string representation
func (s GetNamespaceDeletionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNamespaceDeletionStatusOutput) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *GetNamespaceDeletionStatusOutput) SetErrorCode(v string) *GetNamespaceDeletionStatusOutput {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *GetNamespaceDeletionStatusOutput) SetErrorMessage(v string) *GetNamespaceDeletionStatusOutput {
	s.ErrorMessage = &v
	return s
}

// SetNamespaceArn sets the NamespaceArn field's value.
func (s *GetNamespaceDeletionStatusOutput) SetNamespaceArn(v string) *GetNamespaceDeletionStatusOutput {
	s.NamespaceArn = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *GetNamespaceDeletionStatusOutput) SetNamespaceName(v string) *GetNamespaceDeletionStatusOutput {
	s.NamespaceName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetNamespaceDeletionStatusOutput) SetStatus(v string) *GetNamespaceDeletionStatusOutput {
	s.Status = &v
	return s
}

type GetSystemInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the system deployment instance. This value is returned by CreateSystemInstance.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:deployment:DEPLOYMENTNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSystemInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSystemInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSystemInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSystemInstanceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetSystemInstanceInput) SetId(v string) *GetSystemInstanceInput {
	s.Id = &v
	return s
}

type GetSystemInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the system instance.
	Description *SystemInstanceDescription `locationName:"description" type:"structure"`
}

// String returns the string representation
func (s GetSystemInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSystemInstanceOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GetSystemInstanceOutput) SetDescription(v *SystemInstanceDescription) *GetSystemInstanceOutput {
	s.Description = v
	return s
}

type GetSystemTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the system to get. This ID must be in the user's namespace.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The number that specifies the revision of the system to get.
	RevisionNumber *int64 `locationName:"revisionNumber" type:"long"`
}

// String returns the string representation
func (s GetSystemTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSystemTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSystemTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSystemTemplateInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetSystemTemplateInput) SetId(v string) *GetSystemTemplateInput {
	s.Id = &v
	return s
}

// SetRevisionNumber sets the RevisionNumber field's value.
func (s *GetSystemTemplateInput) SetRevisionNumber(v int64) *GetSystemTemplateInput {
	s.RevisionNumber = &v
	return s
}

type GetSystemTemplateOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains summary data about the system.
	Description *SystemTemplateDescription `locationName:"description" type:"structure"`
}

// String returns the string representation
func (s GetSystemTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSystemTemplateOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GetSystemTemplateOutput) SetDescription(v *SystemTemplateDescription) *GetSystemTemplateOutput {
	s.Description = v
	return s
}

type GetSystemTemplateRevisionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the system template.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The string that specifies the next page of results. Use this when you're
	// paginating results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetSystemTemplateRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSystemTemplateRevisionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSystemTemplateRevisionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSystemTemplateRevisionsInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetSystemTemplateRevisionsInput) SetId(v string) *GetSystemTemplateRevisionsInput {
	s.Id = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetSystemTemplateRevisionsInput) SetMaxResults(v int64) *GetSystemTemplateRevisionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetSystemTemplateRevisionsInput) SetNextToken(v string) *GetSystemTemplateRevisionsInput {
	s.NextToken = &v
	return s
}

type GetSystemTemplateRevisionsOutput struct {
	_ struct{} `type:"structure"`

	// The string to specify as nextToken when you request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that contain summary data about the system template revisions.
	Summaries []*SystemTemplateSummary `locationName:"summaries" type:"list"`
}

// String returns the string representation
func (s GetSystemTemplateRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSystemTemplateRevisionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetSystemTemplateRevisionsOutput) SetNextToken(v string) *GetSystemTemplateRevisionsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *GetSystemTemplateRevisionsOutput) SetSummaries(v []*SystemTemplateSummary) *GetSystemTemplateRevisionsOutput {
	s.Summaries = v
	return s
}

type GetUploadStatusInput struct {
	_ struct{} `type:"structure"`

	// The ID of the upload. This value is returned by the UploadEntityDefinitions
	// action.
	//
	// UploadId is a required field
	UploadId *string `locationName:"uploadId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUploadStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUploadStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUploadStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUploadStatusInput"}
	if s.UploadId == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadId"))
	}
	if s.UploadId != nil && len(*s.UploadId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UploadId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUploadId sets the UploadId field's value.
func (s *GetUploadStatusInput) SetUploadId(v string) *GetUploadStatusInput {
	s.UploadId = &v
	return s
}

type GetUploadStatusOutput struct {
	_ struct{} `type:"structure"`

	// The date at which the upload was created.
	//
	// CreatedDate is a required field
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp" required:"true"`

	// The reason for an upload failure.
	FailureReason []*string `locationName:"failureReason" type:"list"`

	// The ARN of the upload.
	NamespaceArn *string `locationName:"namespaceArn" type:"string"`

	// The name of the upload's namespace.
	NamespaceName *string `locationName:"namespaceName" type:"string"`

	// The version of the user's namespace. Defaults to the latest version of the
	// user's namespace.
	NamespaceVersion *int64 `locationName:"namespaceVersion" type:"long"`

	// The ID of the upload.
	//
	// UploadId is a required field
	UploadId *string `locationName:"uploadId" min:"1" type:"string" required:"true"`

	// The status of the upload. The initial status is IN_PROGRESS. The response
	// show all validation failures if the upload fails.
	//
	// UploadStatus is a required field
	UploadStatus *string `locationName:"uploadStatus" type:"string" required:"true" enum:"UploadStatus"`
}

// String returns the string representation
func (s GetUploadStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUploadStatusOutput) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *GetUploadStatusOutput) SetCreatedDate(v time.Time) *GetUploadStatusOutput {
	s.CreatedDate = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GetUploadStatusOutput) SetFailureReason(v []*string) *GetUploadStatusOutput {
	s.FailureReason = v
	return s
}

// SetNamespaceArn sets the NamespaceArn field's value.
func (s *GetUploadStatusOutput) SetNamespaceArn(v string) *GetUploadStatusOutput {
	s.NamespaceArn = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *GetUploadStatusOutput) SetNamespaceName(v string) *GetUploadStatusOutput {
	s.NamespaceName = &v
	return s
}

// SetNamespaceVersion sets the NamespaceVersion field's value.
func (s *GetUploadStatusOutput) SetNamespaceVersion(v int64) *GetUploadStatusOutput {
	s.NamespaceVersion = &v
	return s
}

// SetUploadId sets the UploadId field's value.
func (s *GetUploadStatusOutput) SetUploadId(v string) *GetUploadStatusOutput {
	s.UploadId = &v
	return s
}

// SetUploadStatus sets the UploadStatus field's value.
func (s *GetUploadStatusOutput) SetUploadStatus(v string) *GetUploadStatusOutput {
	s.UploadStatus = &v
	return s
}

type ListFlowExecutionMessagesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the flow execution.
	//
	// FlowExecutionId is a required field
	FlowExecutionId *string `locationName:"flowExecutionId" type:"string" required:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The string that specifies the next page of results. Use this when you're
	// paginating results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFlowExecutionMessagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFlowExecutionMessagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFlowExecutionMessagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFlowExecutionMessagesInput"}
	if s.FlowExecutionId == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowExecutionId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowExecutionId sets the FlowExecutionId field's value.
func (s *ListFlowExecutionMessagesInput) SetFlowExecutionId(v string) *ListFlowExecutionMessagesInput {
	s.FlowExecutionId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFlowExecutionMessagesInput) SetMaxResults(v int64) *ListFlowExecutionMessagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowExecutionMessagesInput) SetNextToken(v string) *ListFlowExecutionMessagesInput {
	s.NextToken = &v
	return s
}

type ListFlowExecutionMessagesOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects that contain information about events in the specified
	// flow execution.
	Messages []*FlowExecutionMessage `locationName:"messages" type:"list"`

	// The string to specify as nextToken when you request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFlowExecutionMessagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFlowExecutionMessagesOutput) GoString() string {
	return s.String()
}

// SetMessages sets the Messages field's value.
func (s *ListFlowExecutionMessagesOutput) SetMessages(v []*FlowExecutionMessage) *ListFlowExecutionMessagesOutput {
	s.Messages = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowExecutionMessagesOutput) SetNextToken(v string) *ListFlowExecutionMessagesOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of tags to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token that specifies the next page of results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the resource whose tags are to be returned.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The token that specifies the next page of results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of tags returned by the ListTagsForResource operation.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// An object that specifies whether cloud metrics are collected in a deployment
// and, if so, what role is used to collect metrics.
type MetricsConfiguration struct {
	_ struct{} `type:"structure"`

	// A Boolean that specifies whether cloud metrics are collected.
	CloudMetricEnabled *bool `locationName:"cloudMetricEnabled" type:"boolean"`

	// The ARN of the role that is used to collect cloud metrics.
	MetricRuleRoleArn *string `locationName:"metricRuleRoleArn" min:"20" type:"string"`
}

// String returns the string representation
func (s MetricsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MetricsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MetricsConfiguration"}
	if s.MetricRuleRoleArn != nil && len(*s.MetricRuleRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("MetricRuleRoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudMetricEnabled sets the CloudMetricEnabled field's value.
func (s *MetricsConfiguration) SetCloudMetricEnabled(v bool) *MetricsConfiguration {
	s.CloudMetricEnabled = &v
	return s
}

// SetMetricRuleRoleArn sets the MetricRuleRoleArn field's value.
func (s *MetricsConfiguration) SetMetricRuleRoleArn(v string) *MetricsConfiguration {
	s.MetricRuleRoleArn = &v
	return s
}

type SearchEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The entity types for which to search.
	//
	// EntityTypes is a required field
	EntityTypes []*string `locationName:"entityTypes" type:"list" required:"true"`

	// Optional filter to apply to the search. Valid filters are NAME NAMESPACE,
	// SEMANTIC_TYPE_PATH and REFERENCED_ENTITY_ID. REFERENCED_ENTITY_ID filters
	// on entities that are used by the entity in the result set. For example, you
	// can filter on the ID of a property that is used in a state.
	//
	// Multiple filters function as OR criteria in the query. Multiple values passed
	// inside the filter function as AND criteria.
	Filters []*EntityFilter `locationName:"filters" type:"list"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The version of the user's namespace. Defaults to the latest version of the
	// user's namespace.
	NamespaceVersion *int64 `locationName:"namespaceVersion" type:"long"`

	// The string that specifies the next page of results. Use this when you're
	// paginating results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s SearchEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchEntitiesInput"}
	if s.EntityTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityTypes"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityTypes sets the EntityTypes field's value.
func (s *SearchEntitiesInput) SetEntityTypes(v []*string) *SearchEntitiesInput {
	s.EntityTypes = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *SearchEntitiesInput) SetFilters(v []*EntityFilter) *SearchEntitiesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchEntitiesInput) SetMaxResults(v int64) *SearchEntitiesInput {
	s.MaxResults = &v
	return s
}

// SetNamespaceVersion sets the NamespaceVersion field's value.
func (s *SearchEntitiesInput) SetNamespaceVersion(v int64) *SearchEntitiesInput {
	s.NamespaceVersion = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchEntitiesInput) SetNextToken(v string) *SearchEntitiesInput {
	s.NextToken = &v
	return s
}

type SearchEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// An array of descriptions for each entity returned in the search result.
	Descriptions []*EntityDescription `locationName:"descriptions" type:"list"`

	// The string to specify as nextToken when you request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s SearchEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchEntitiesOutput) GoString() string {
	return s.String()
}

// SetDescriptions sets the Descriptions field's value.
func (s *SearchEntitiesOutput) SetDescriptions(v []*EntityDescription) *SearchEntitiesOutput {
	s.Descriptions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchEntitiesOutput) SetNextToken(v string) *SearchEntitiesOutput {
	s.NextToken = &v
	return s
}

type SearchFlowExecutionsInput struct {
	_ struct{} `type:"structure"`

	// The date and time of the latest flow execution to return.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The ID of a flow execution.
	FlowExecutionId *string `locationName:"flowExecutionId" type:"string"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The string that specifies the next page of results. Use this when you're
	// paginating results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The date and time of the earliest flow execution to return.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The ID of the system instance that contains the flow.
	//
	// SystemInstanceId is a required field
	SystemInstanceId *string `locationName:"systemInstanceId" type:"string" required:"true"`
}

// String returns the string representation
func (s SearchFlowExecutionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchFlowExecutionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchFlowExecutionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchFlowExecutionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SystemInstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("SystemInstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *SearchFlowExecutionsInput) SetEndTime(v time.Time) *SearchFlowExecutionsInput {
	s.EndTime = &v
	return s
}

// SetFlowExecutionId sets the FlowExecutionId field's value.
func (s *SearchFlowExecutionsInput) SetFlowExecutionId(v string) *SearchFlowExecutionsInput {
	s.FlowExecutionId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchFlowExecutionsInput) SetMaxResults(v int64) *SearchFlowExecutionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchFlowExecutionsInput) SetNextToken(v string) *SearchFlowExecutionsInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *SearchFlowExecutionsInput) SetStartTime(v time.Time) *SearchFlowExecutionsInput {
	s.StartTime = &v
	return s
}

// SetSystemInstanceId sets the SystemInstanceId field's value.
func (s *SearchFlowExecutionsInput) SetSystemInstanceId(v string) *SearchFlowExecutionsInput {
	s.SystemInstanceId = &v
	return s
}

type SearchFlowExecutionsOutput struct {
	_ struct{} `type:"structure"`

	// The string to specify as nextToken when you request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that contain summary information about each workflow
	// execution in the result set.
	Summaries []*FlowExecutionSummary `locationName:"summaries" type:"list"`
}

// String returns the string representation
func (s SearchFlowExecutionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchFlowExecutionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchFlowExecutionsOutput) SetNextToken(v string) *SearchFlowExecutionsOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *SearchFlowExecutionsOutput) SetSummaries(v []*FlowExecutionSummary) *SearchFlowExecutionsOutput {
	s.Summaries = v
	return s
}

type SearchFlowTemplatesInput struct {
	_ struct{} `type:"structure"`

	// An array of objects that limit the result set. The only valid filter is DEVICE_MODEL_ID.
	Filters []*FlowTemplateFilter `locationName:"filters" type:"list"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The string that specifies the next page of results. Use this when you're
	// paginating results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s SearchFlowTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchFlowTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchFlowTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchFlowTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchFlowTemplatesInput) SetFilters(v []*FlowTemplateFilter) *SearchFlowTemplatesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchFlowTemplatesInput) SetMaxResults(v int64) *SearchFlowTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchFlowTemplatesInput) SetNextToken(v string) *SearchFlowTemplatesInput {
	s.NextToken = &v
	return s
}

type SearchFlowTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// The string to specify as nextToken when you request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that contain summary information about each workflow
	// in the result set.
	Summaries []*FlowTemplateSummary `locationName:"summaries" type:"list"`
}

// String returns the string representation
func (s SearchFlowTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchFlowTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchFlowTemplatesOutput) SetNextToken(v string) *SearchFlowTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *SearchFlowTemplatesOutput) SetSummaries(v []*FlowTemplateSummary) *SearchFlowTemplatesOutput {
	s.Summaries = v
	return s
}

type SearchSystemInstancesInput struct {
	_ struct{} `type:"structure"`

	// Optional filter to apply to the search. Valid filters are SYSTEM_TEMPLATE_ID,
	// STATUS, and GREENGRASS_GROUP_NAME.
	//
	// Multiple filters function as OR criteria in the query. Multiple values passed
	// inside the filter function as AND criteria.
	Filters []*SystemInstanceFilter `locationName:"filters" type:"list"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The string that specifies the next page of results. Use this when you're
	// paginating results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s SearchSystemInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchSystemInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchSystemInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchSystemInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchSystemInstancesInput) SetFilters(v []*SystemInstanceFilter) *SearchSystemInstancesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchSystemInstancesInput) SetMaxResults(v int64) *SearchSystemInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchSystemInstancesInput) SetNextToken(v string) *SearchSystemInstancesInput {
	s.NextToken = &v
	return s
}

type SearchSystemInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The string to specify as nextToken when you request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that contain summary data abour the system instances
	// in the result set.
	Summaries []*SystemInstanceSummary `locationName:"summaries" type:"list"`
}

// String returns the string representation
func (s SearchSystemInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchSystemInstancesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchSystemInstancesOutput) SetNextToken(v string) *SearchSystemInstancesOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *SearchSystemInstancesOutput) SetSummaries(v []*SystemInstanceSummary) *SearchSystemInstancesOutput {
	s.Summaries = v
	return s
}

type SearchSystemTemplatesInput struct {
	_ struct{} `type:"structure"`

	// An array of filters that limit the result set. The only valid filter is FLOW_TEMPLATE_ID.
	Filters []*SystemTemplateFilter `locationName:"filters" type:"list"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The string that specifies the next page of results. Use this when you're
	// paginating results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s SearchSystemTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchSystemTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchSystemTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchSystemTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchSystemTemplatesInput) SetFilters(v []*SystemTemplateFilter) *SearchSystemTemplatesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchSystemTemplatesInput) SetMaxResults(v int64) *SearchSystemTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchSystemTemplatesInput) SetNextToken(v string) *SearchSystemTemplatesInput {
	s.NextToken = &v
	return s
}

type SearchSystemTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// The string to specify as nextToken when you request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that contain summary information about each system deployment
	// in the result set.
	Summaries []*SystemTemplateSummary `locationName:"summaries" type:"list"`
}

// String returns the string representation
func (s SearchSystemTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchSystemTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchSystemTemplatesOutput) SetNextToken(v string) *SearchSystemTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetSummaries sets the Summaries field's value.
func (s *SearchSystemTemplatesOutput) SetSummaries(v []*SystemTemplateSummary) *SearchSystemTemplatesOutput {
	s.Summaries = v
	return s
}

type SearchThingsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the entity to which the things are associated.
	//
	// The IDs should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME
	//
	// EntityId is a required field
	EntityId *string `locationName:"entityId" type:"string" required:"true"`

	// The maximum number of results to return in the response.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The version of the user's namespace. Defaults to the latest version of the
	// user's namespace.
	NamespaceVersion *int64 `locationName:"namespaceVersion" type:"long"`

	// The string that specifies the next page of results. Use this when you're
	// paginating results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s SearchThingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchThingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchThingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchThingsInput"}
	if s.EntityId == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityId sets the EntityId field's value.
func (s *SearchThingsInput) SetEntityId(v string) *SearchThingsInput {
	s.EntityId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchThingsInput) SetMaxResults(v int64) *SearchThingsInput {
	s.MaxResults = &v
	return s
}

// SetNamespaceVersion sets the NamespaceVersion field's value.
func (s *SearchThingsInput) SetNamespaceVersion(v int64) *SearchThingsInput {
	s.NamespaceVersion = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchThingsInput) SetNextToken(v string) *SearchThingsInput {
	s.NextToken = &v
	return s
}

type SearchThingsOutput struct {
	_ struct{} `type:"structure"`

	// The string to specify as nextToken when you request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of things in the result set.
	Things []*Thing `locationName:"things" type:"list"`
}

// String returns the string representation
func (s SearchThingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchThingsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchThingsOutput) SetNextToken(v string) *SearchThingsOutput {
	s.NextToken = &v
	return s
}

// SetThings sets the Things field's value.
func (s *SearchThingsOutput) SetThings(v []*Thing) *SearchThingsOutput {
	s.Things = v
	return s
}

// An object that contains a system instance definition and summary information.
type SystemInstanceDescription struct {
	_ struct{} `type:"structure"`

	// A document that defines an entity.
	Definition *DefinitionDocument `locationName:"definition" type:"structure"`

	// The AWS Identity and Access Management (IAM) role that AWS IoT Things Graph
	// assumes during flow execution in a cloud deployment. This role must have
	// read and write permissionss to AWS Lambda and AWS IoT and to any other AWS
	// services that the flow uses.
	FlowActionsRoleArn *string `locationName:"flowActionsRoleArn" min:"20" type:"string"`

	// An object that specifies whether cloud metrics are collected in a deployment
	// and, if so, what role is used to collect metrics.
	MetricsConfiguration *MetricsConfiguration `locationName:"metricsConfiguration" type:"structure"`

	// The Amazon Simple Storage Service bucket where information about a system
	// instance is stored.
	S3BucketName *string `locationName:"s3BucketName" type:"string"`

	// An object that contains summary information about a system instance.
	Summary *SystemInstanceSummary `locationName:"summary" type:"structure"`

	// A list of objects that contain all of the IDs and revision numbers of workflows
	// and systems that are used in a system instance.
	ValidatedDependencyRevisions []*DependencyRevision `locationName:"validatedDependencyRevisions" type:"list"`

	// The version of the user's namespace against which the system instance was
	// validated.
	ValidatedNamespaceVersion *int64 `locationName:"validatedNamespaceVersion" type:"long"`
}

// String returns the string representation
func (s SystemInstanceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemInstanceDescription) GoString() string {
	return s.String()
}

// SetDefinition sets the Definition field's value.
func (s *SystemInstanceDescription) SetDefinition(v *DefinitionDocument) *SystemInstanceDescription {
	s.Definition = v
	return s
}

// SetFlowActionsRoleArn sets the FlowActionsRoleArn field's value.
func (s *SystemInstanceDescription) SetFlowActionsRoleArn(v string) *SystemInstanceDescription {
	s.FlowActionsRoleArn = &v
	return s
}

// SetMetricsConfiguration sets the MetricsConfiguration field's value.
func (s *SystemInstanceDescription) SetMetricsConfiguration(v *MetricsConfiguration) *SystemInstanceDescription {
	s.MetricsConfiguration = v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *SystemInstanceDescription) SetS3BucketName(v string) *SystemInstanceDescription {
	s.S3BucketName = &v
	return s
}

// SetSummary sets the Summary field's value.
func (s *SystemInstanceDescription) SetSummary(v *SystemInstanceSummary) *SystemInstanceDescription {
	s.Summary = v
	return s
}

// SetValidatedDependencyRevisions sets the ValidatedDependencyRevisions field's value.
func (s *SystemInstanceDescription) SetValidatedDependencyRevisions(v []*DependencyRevision) *SystemInstanceDescription {
	s.ValidatedDependencyRevisions = v
	return s
}

// SetValidatedNamespaceVersion sets the ValidatedNamespaceVersion field's value.
func (s *SystemInstanceDescription) SetValidatedNamespaceVersion(v int64) *SystemInstanceDescription {
	s.ValidatedNamespaceVersion = &v
	return s
}

// An object that filters a system instance search. Multiple filters function
// as OR criteria in the search. For example a search that includes a GREENGRASS_GROUP_NAME
// and a STATUS filter searches for system instances in the specified Greengrass
// group that have the specified status.
type SystemInstanceFilter struct {
	_ struct{} `type:"structure"`

	// The name of the search filter field.
	Name *string `locationName:"name" type:"string" enum:"SystemInstanceFilterName"`

	// An array of string values for the search filter field. Multiple values function
	// as AND criteria in the search.
	Value []*string `locationName:"value" type:"list"`
}

// String returns the string representation
func (s SystemInstanceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemInstanceFilter) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SystemInstanceFilter) SetName(v string) *SystemInstanceFilter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SystemInstanceFilter) SetValue(v []*string) *SystemInstanceFilter {
	s.Value = v
	return s
}

// An object that contains summary information about a system instance.
type SystemInstanceSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the system instance.
	Arn *string `locationName:"arn" type:"string"`

	// The date when the system instance was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ID of the Greengrass group where the system instance is deployed.
	GreengrassGroupId *string `locationName:"greengrassGroupId" type:"string"`

	// The ID of the Greengrass group where the system instance is deployed.
	GreengrassGroupName *string `locationName:"greengrassGroupName" type:"string"`

	// The version of the Greengrass group where the system instance is deployed.
	GreengrassGroupVersionId *string `locationName:"greengrassGroupVersionId" type:"string"`

	// The ID of the system instance.
	Id *string `locationName:"id" type:"string"`

	// The status of the system instance.
	Status *string `locationName:"status" type:"string" enum:"SystemInstanceDeploymentStatus"`

	// The target of the system instance.
	Target *string `locationName:"target" type:"string" enum:"DeploymentTarget"`

	// The date and time when the system instance was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp"`
}

// String returns the string representation
func (s SystemInstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemInstanceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SystemInstanceSummary) SetArn(v string) *SystemInstanceSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SystemInstanceSummary) SetCreatedAt(v time.Time) *SystemInstanceSummary {
	s.CreatedAt = &v
	return s
}

// SetGreengrassGroupId sets the GreengrassGroupId field's value.
func (s *SystemInstanceSummary) SetGreengrassGroupId(v string) *SystemInstanceSummary {
	s.GreengrassGroupId = &v
	return s
}

// SetGreengrassGroupName sets the GreengrassGroupName field's value.
func (s *SystemInstanceSummary) SetGreengrassGroupName(v string) *SystemInstanceSummary {
	s.GreengrassGroupName = &v
	return s
}

// SetGreengrassGroupVersionId sets the GreengrassGroupVersionId field's value.
func (s *SystemInstanceSummary) SetGreengrassGroupVersionId(v string) *SystemInstanceSummary {
	s.GreengrassGroupVersionId = &v
	return s
}

// SetId sets the Id field's value.
func (s *SystemInstanceSummary) SetId(v string) *SystemInstanceSummary {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SystemInstanceSummary) SetStatus(v string) *SystemInstanceSummary {
	s.Status = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *SystemInstanceSummary) SetTarget(v string) *SystemInstanceSummary {
	s.Target = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *SystemInstanceSummary) SetUpdatedAt(v time.Time) *SystemInstanceSummary {
	s.UpdatedAt = &v
	return s
}

// An object that contains a system's definition document and summary information.
type SystemTemplateDescription struct {
	_ struct{} `type:"structure"`

	// The definition document of a system.
	Definition *DefinitionDocument `locationName:"definition" type:"structure"`

	// An object that contains summary information about a system.
	Summary *SystemTemplateSummary `locationName:"summary" type:"structure"`

	// The namespace version against which the system was validated. Use this value
	// in your system instance.
	ValidatedNamespaceVersion *int64 `locationName:"validatedNamespaceVersion" type:"long"`
}

// String returns the string representation
func (s SystemTemplateDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemTemplateDescription) GoString() string {
	return s.String()
}

// SetDefinition sets the Definition field's value.
func (s *SystemTemplateDescription) SetDefinition(v *DefinitionDocument) *SystemTemplateDescription {
	s.Definition = v
	return s
}

// SetSummary sets the Summary field's value.
func (s *SystemTemplateDescription) SetSummary(v *SystemTemplateSummary) *SystemTemplateDescription {
	s.Summary = v
	return s
}

// SetValidatedNamespaceVersion sets the ValidatedNamespaceVersion field's value.
func (s *SystemTemplateDescription) SetValidatedNamespaceVersion(v int64) *SystemTemplateDescription {
	s.ValidatedNamespaceVersion = &v
	return s
}

// An object that filters a system search.
type SystemTemplateFilter struct {
	_ struct{} `type:"structure"`

	// The name of the system search filter field.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true" enum:"SystemTemplateFilterName"`

	// An array of string values for the search filter field. Multiple values function
	// as AND criteria in the search.
	//
	// Value is a required field
	Value []*string `locationName:"value" type:"list" required:"true"`
}

// String returns the string representation
func (s SystemTemplateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemTemplateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SystemTemplateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SystemTemplateFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *SystemTemplateFilter) SetName(v string) *SystemTemplateFilter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SystemTemplateFilter) SetValue(v []*string) *SystemTemplateFilter {
	s.Value = v
	return s
}

// An object that contains information about a system.
type SystemTemplateSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the system.
	Arn *string `locationName:"arn" type:"string"`

	// The date when the system was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The ID of the system.
	Id *string `locationName:"id" type:"string"`

	// The revision number of the system.
	RevisionNumber *int64 `locationName:"revisionNumber" type:"long"`
}

// String returns the string representation
func (s SystemTemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemTemplateSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SystemTemplateSummary) SetArn(v string) *SystemTemplateSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SystemTemplateSummary) SetCreatedAt(v time.Time) *SystemTemplateSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *SystemTemplateSummary) SetId(v string) *SystemTemplateSummary {
	s.Id = &v
	return s
}

// SetRevisionNumber sets the RevisionNumber field's value.
func (s *SystemTemplateSummary) SetRevisionNumber(v int64) *SystemTemplateSummary {
	s.RevisionNumber = &v
	return s
}

// Metadata assigned to an AWS IoT Things Graph resource consisting of a key-value
// pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// The required name of the tag. The string value can be from 1 to 128 Unicode
	// characters in length.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The optional value of the tag. The string value can be from 1 to 256 Unicode
	// characters in length.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource whose tags are returned.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of tags to add to the resource.>
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// An AWS IoT thing.
type Thing struct {
	_ struct{} `type:"structure"`

	// The ARN of the thing.
	ThingArn *string `locationName:"thingArn" type:"string"`

	// The name of the thing.
	ThingName *string `locationName:"thingName" min:"1" type:"string"`
}

// String returns the string representation
func (s Thing) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Thing) GoString() string {
	return s.String()
}

// SetThingArn sets the ThingArn field's value.
func (s *Thing) SetThingArn(v string) *Thing {
	s.ThingArn = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *Thing) SetThingName(v string) *Thing {
	s.ThingName = &v
	return s
}

type UndeploySystemInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the system instance to remove from its target.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s UndeploySystemInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UndeploySystemInstanceInput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *UndeploySystemInstanceInput) SetId(v string) *UndeploySystemInstanceInput {
	s.Id = &v
	return s
}

type UndeploySystemInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains summary information about the system instance that
	// was removed from its target.
	Summary *SystemInstanceSummary `locationName:"summary" type:"structure"`
}

// String returns the string representation
func (s UndeploySystemInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UndeploySystemInstanceOutput) GoString() string {
	return s.String()
}

// SetSummary sets the Summary field's value.
func (s *UndeploySystemInstanceOutput) SetSummary(v *SystemInstanceSummary) *UndeploySystemInstanceOutput {
	s.Summary = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource whose tags are to be removed.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of tag key names to remove from the resource. You don't specify the
	// value. Both the key and its associated value are removed.
	//
	// This parameter to the API requires a JSON text string argument. For information
	// on how to format a JSON parameter for the various command line tool environments,
	// see Using JSON for Parameters (https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html#cli-using-param-json)
	// in the AWS CLI User Guide.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateFlowTemplateInput struct {
	_ struct{} `type:"structure"`

	// The version of the user's namespace.
	//
	// If no value is specified, the latest version is used by default. Use the
	// GetFlowTemplateRevisions if you want to find earlier revisions of the flow
	// to update.
	CompatibleNamespaceVersion *int64 `locationName:"compatibleNamespaceVersion" type:"long"`

	// The DefinitionDocument that contains the updated workflow definition.
	//
	// Definition is a required field
	Definition *DefinitionDocument `locationName:"definition" type:"structure" required:"true"`

	// The ID of the workflow to be updated.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:workflow:WORKFLOWNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateFlowTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowTemplateInput"}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompatibleNamespaceVersion sets the CompatibleNamespaceVersion field's value.
func (s *UpdateFlowTemplateInput) SetCompatibleNamespaceVersion(v int64) *UpdateFlowTemplateInput {
	s.CompatibleNamespaceVersion = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *UpdateFlowTemplateInput) SetDefinition(v *DefinitionDocument) *UpdateFlowTemplateInput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateFlowTemplateInput) SetId(v string) *UpdateFlowTemplateInput {
	s.Id = &v
	return s
}

type UpdateFlowTemplateOutput struct {
	_ struct{} `type:"structure"`

	// An object containing summary information about the updated workflow.
	Summary *FlowTemplateSummary `locationName:"summary" type:"structure"`
}

// String returns the string representation
func (s UpdateFlowTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFlowTemplateOutput) GoString() string {
	return s.String()
}

// SetSummary sets the Summary field's value.
func (s *UpdateFlowTemplateOutput) SetSummary(v *FlowTemplateSummary) *UpdateFlowTemplateOutput {
	s.Summary = v
	return s
}

type UpdateSystemTemplateInput struct {
	_ struct{} `type:"structure"`

	// The version of the user's namespace. Defaults to the latest version of the
	// user's namespace.
	//
	// If no value is specified, the latest version is used by default.
	CompatibleNamespaceVersion *int64 `locationName:"compatibleNamespaceVersion" type:"long"`

	// The DefinitionDocument that contains the updated system definition.
	//
	// Definition is a required field
	Definition *DefinitionDocument `locationName:"definition" type:"structure" required:"true"`

	// The ID of the system to be updated.
	//
	// The ID should be in the following format.
	//
	// urn:tdm:REGION/ACCOUNT ID/default:system:SYSTEMNAME
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSystemTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSystemTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSystemTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSystemTemplateInput"}
	if s.Definition == nil {
		invalidParams.Add(request.NewErrParamRequired("Definition"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompatibleNamespaceVersion sets the CompatibleNamespaceVersion field's value.
func (s *UpdateSystemTemplateInput) SetCompatibleNamespaceVersion(v int64) *UpdateSystemTemplateInput {
	s.CompatibleNamespaceVersion = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *UpdateSystemTemplateInput) SetDefinition(v *DefinitionDocument) *UpdateSystemTemplateInput {
	s.Definition = v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateSystemTemplateInput) SetId(v string) *UpdateSystemTemplateInput {
	s.Id = &v
	return s
}

type UpdateSystemTemplateOutput struct {
	_ struct{} `type:"structure"`

	// An object containing summary information about the updated system.
	Summary *SystemTemplateSummary `locationName:"summary" type:"structure"`
}

// String returns the string representation
func (s UpdateSystemTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSystemTemplateOutput) GoString() string {
	return s.String()
}

// SetSummary sets the Summary field's value.
func (s *UpdateSystemTemplateOutput) SetSummary(v *SystemTemplateSummary) *UpdateSystemTemplateOutput {
	s.Summary = v
	return s
}

type UploadEntityDefinitionsInput struct {
	_ struct{} `type:"structure"`

	// A Boolean that specifies whether to deprecate all entities in the latest
	// version before uploading the new DefinitionDocument. If set to true, the
	// upload will create a new namespace version.
	DeprecateExistingEntities *bool `locationName:"deprecateExistingEntities" type:"boolean"`

	// The DefinitionDocument that defines the updated entities.
	Document *DefinitionDocument `locationName:"document" type:"structure"`

	// A Boolean that specifies whether to synchronize with the latest version of
	// the public namespace. If set to true, the upload will create a new namespace
	// version.
	SyncWithPublicNamespace *bool `locationName:"syncWithPublicNamespace" type:"boolean"`
}

// String returns the string representation
func (s UploadEntityDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadEntityDefinitionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadEntityDefinitionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadEntityDefinitionsInput"}
	if s.Document != nil {
		if err := s.Document.Validate(); err != nil {
			invalidParams.AddNested("Document", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeprecateExistingEntities sets the DeprecateExistingEntities field's value.
func (s *UploadEntityDefinitionsInput) SetDeprecateExistingEntities(v bool) *UploadEntityDefinitionsInput {
	s.DeprecateExistingEntities = &v
	return s
}

// SetDocument sets the Document field's value.
func (s *UploadEntityDefinitionsInput) SetDocument(v *DefinitionDocument) *UploadEntityDefinitionsInput {
	s.Document = v
	return s
}

// SetSyncWithPublicNamespace sets the SyncWithPublicNamespace field's value.
func (s *UploadEntityDefinitionsInput) SetSyncWithPublicNamespace(v bool) *UploadEntityDefinitionsInput {
	s.SyncWithPublicNamespace = &v
	return s
}

type UploadEntityDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// The ID that specifies the upload action. You can use this to track the status
	// of the upload.
	//
	// UploadId is a required field
	UploadId *string `locationName:"uploadId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadEntityDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadEntityDefinitionsOutput) GoString() string {
	return s.String()
}

// SetUploadId sets the UploadId field's value.
func (s *UploadEntityDefinitionsOutput) SetUploadId(v string) *UploadEntityDefinitionsOutput {
	s.UploadId = &v
	return s
}

const (
	// DefinitionLanguageGraphql is a DefinitionLanguage enum value
	DefinitionLanguageGraphql = "GRAPHQL"
)

const (
	// DeploymentTargetGreengrass is a DeploymentTarget enum value
	DeploymentTargetGreengrass = "GREENGRASS"

	// DeploymentTargetCloud is a DeploymentTarget enum value
	DeploymentTargetCloud = "CLOUD"
)

const (
	// EntityFilterNameName is a EntityFilterName enum value
	EntityFilterNameName = "NAME"

	// EntityFilterNameNamespace is a EntityFilterName enum value
	EntityFilterNameNamespace = "NAMESPACE"

	// EntityFilterNameSemanticTypePath is a EntityFilterName enum value
	EntityFilterNameSemanticTypePath = "SEMANTIC_TYPE_PATH"

	// EntityFilterNameReferencedEntityId is a EntityFilterName enum value
	EntityFilterNameReferencedEntityId = "REFERENCED_ENTITY_ID"
)

const (
	// EntityTypeDevice is a EntityType enum value
	EntityTypeDevice = "DEVICE"

	// EntityTypeService is a EntityType enum value
	EntityTypeService = "SERVICE"

	// EntityTypeDeviceModel is a EntityType enum value
	EntityTypeDeviceModel = "DEVICE_MODEL"

	// EntityTypeCapability is a EntityType enum value
	EntityTypeCapability = "CAPABILITY"

	// EntityTypeState is a EntityType enum value
	EntityTypeState = "STATE"

	// EntityTypeAction is a EntityType enum value
	EntityTypeAction = "ACTION"

	// EntityTypeEvent is a EntityType enum value
	EntityTypeEvent = "EVENT"

	// EntityTypeProperty is a EntityType enum value
	EntityTypeProperty = "PROPERTY"

	// EntityTypeMapping is a EntityType enum value
	EntityTypeMapping = "MAPPING"

	// EntityTypeEnum is a EntityType enum value
	EntityTypeEnum = "ENUM"
)

const (
	// FlowExecutionEventTypeExecutionStarted is a FlowExecutionEventType enum value
	FlowExecutionEventTypeExecutionStarted = "EXECUTION_STARTED"

	// FlowExecutionEventTypeExecutionFailed is a FlowExecutionEventType enum value
	FlowExecutionEventTypeExecutionFailed = "EXECUTION_FAILED"

	// FlowExecutionEventTypeExecutionAborted is a FlowExecutionEventType enum value
	FlowExecutionEventTypeExecutionAborted = "EXECUTION_ABORTED"

	// FlowExecutionEventTypeExecutionSucceeded is a FlowExecutionEventType enum value
	FlowExecutionEventTypeExecutionSucceeded = "EXECUTION_SUCCEEDED"

	// FlowExecutionEventTypeStepStarted is a FlowExecutionEventType enum value
	FlowExecutionEventTypeStepStarted = "STEP_STARTED"

	// FlowExecutionEventTypeStepFailed is a FlowExecutionEventType enum value
	FlowExecutionEventTypeStepFailed = "STEP_FAILED"

	// FlowExecutionEventTypeStepSucceeded is a FlowExecutionEventType enum value
	FlowExecutionEventTypeStepSucceeded = "STEP_SUCCEEDED"

	// FlowExecutionEventTypeActivityScheduled is a FlowExecutionEventType enum value
	FlowExecutionEventTypeActivityScheduled = "ACTIVITY_SCHEDULED"

	// FlowExecutionEventTypeActivityStarted is a FlowExecutionEventType enum value
	FlowExecutionEventTypeActivityStarted = "ACTIVITY_STARTED"

	// FlowExecutionEventTypeActivityFailed is a FlowExecutionEventType enum value
	FlowExecutionEventTypeActivityFailed = "ACTIVITY_FAILED"

	// FlowExecutionEventTypeActivitySucceeded is a FlowExecutionEventType enum value
	FlowExecutionEventTypeActivitySucceeded = "ACTIVITY_SUCCEEDED"

	// FlowExecutionEventTypeStartFlowExecutionTask is a FlowExecutionEventType enum value
	FlowExecutionEventTypeStartFlowExecutionTask = "START_FLOW_EXECUTION_TASK"

	// FlowExecutionEventTypeScheduleNextReadyStepsTask is a FlowExecutionEventType enum value
	FlowExecutionEventTypeScheduleNextReadyStepsTask = "SCHEDULE_NEXT_READY_STEPS_TASK"

	// FlowExecutionEventTypeThingActionTask is a FlowExecutionEventType enum value
	FlowExecutionEventTypeThingActionTask = "THING_ACTION_TASK"

	// FlowExecutionEventTypeThingActionTaskFailed is a FlowExecutionEventType enum value
	FlowExecutionEventTypeThingActionTaskFailed = "THING_ACTION_TASK_FAILED"

	// FlowExecutionEventTypeThingActionTaskSucceeded is a FlowExecutionEventType enum value
	FlowExecutionEventTypeThingActionTaskSucceeded = "THING_ACTION_TASK_SUCCEEDED"

	// FlowExecutionEventTypeAcknowledgeTaskMessage is a FlowExecutionEventType enum value
	FlowExecutionEventTypeAcknowledgeTaskMessage = "ACKNOWLEDGE_TASK_MESSAGE"
)

const (
	// FlowExecutionStatusRunning is a FlowExecutionStatus enum value
	FlowExecutionStatusRunning = "RUNNING"

	// FlowExecutionStatusAborted is a FlowExecutionStatus enum value
	FlowExecutionStatusAborted = "ABORTED"

	// FlowExecutionStatusSucceeded is a FlowExecutionStatus enum value
	FlowExecutionStatusSucceeded = "SUCCEEDED"

	// FlowExecutionStatusFailed is a FlowExecutionStatus enum value
	FlowExecutionStatusFailed = "FAILED"
)

const (
	// FlowTemplateFilterNameDeviceModelId is a FlowTemplateFilterName enum value
	FlowTemplateFilterNameDeviceModelId = "DEVICE_MODEL_ID"
)

const (
	// NamespaceDeletionStatusInProgress is a NamespaceDeletionStatus enum value
	NamespaceDeletionStatusInProgress = "IN_PROGRESS"

	// NamespaceDeletionStatusSucceeded is a NamespaceDeletionStatus enum value
	NamespaceDeletionStatusSucceeded = "SUCCEEDED"

	// NamespaceDeletionStatusFailed is a NamespaceDeletionStatus enum value
	NamespaceDeletionStatusFailed = "FAILED"
)

const (
	// NamespaceDeletionStatusErrorCodesValidationFailed is a NamespaceDeletionStatusErrorCodes enum value
	NamespaceDeletionStatusErrorCodesValidationFailed = "VALIDATION_FAILED"
)

const (
	// SystemInstanceDeploymentStatusNotDeployed is a SystemInstanceDeploymentStatus enum value
	SystemInstanceDeploymentStatusNotDeployed = "NOT_DEPLOYED"

	// SystemInstanceDeploymentStatusBootstrap is a SystemInstanceDeploymentStatus enum value
	SystemInstanceDeploymentStatusBootstrap = "BOOTSTRAP"

	// SystemInstanceDeploymentStatusDeployInProgress is a SystemInstanceDeploymentStatus enum value
	SystemInstanceDeploymentStatusDeployInProgress = "DEPLOY_IN_PROGRESS"

	// SystemInstanceDeploymentStatusDeployedInTarget is a SystemInstanceDeploymentStatus enum value
	SystemInstanceDeploymentStatusDeployedInTarget = "DEPLOYED_IN_TARGET"

	// SystemInstanceDeploymentStatusUndeployInProgress is a SystemInstanceDeploymentStatus enum value
	SystemInstanceDeploymentStatusUndeployInProgress = "UNDEPLOY_IN_PROGRESS"

	// SystemInstanceDeploymentStatusFailed is a SystemInstanceDeploymentStatus enum value
	SystemInstanceDeploymentStatusFailed = "FAILED"

	// SystemInstanceDeploymentStatusPendingDelete is a SystemInstanceDeploymentStatus enum value
	SystemInstanceDeploymentStatusPendingDelete = "PENDING_DELETE"

	// SystemInstanceDeploymentStatusDeletedInTarget is a SystemInstanceDeploymentStatus enum value
	SystemInstanceDeploymentStatusDeletedInTarget = "DELETED_IN_TARGET"
)

const (
	// SystemInstanceFilterNameSystemTemplateId is a SystemInstanceFilterName enum value
	SystemInstanceFilterNameSystemTemplateId = "SYSTEM_TEMPLATE_ID"

	// SystemInstanceFilterNameStatus is a SystemInstanceFilterName enum value
	SystemInstanceFilterNameStatus = "STATUS"

	// SystemInstanceFilterNameGreengrassGroupName is a SystemInstanceFilterName enum value
	SystemInstanceFilterNameGreengrassGroupName = "GREENGRASS_GROUP_NAME"
)

const (
	// SystemTemplateFilterNameFlowTemplateId is a SystemTemplateFilterName enum value
	SystemTemplateFilterNameFlowTemplateId = "FLOW_TEMPLATE_ID"
)

const (
	// UploadStatusInProgress is a UploadStatus enum value
	UploadStatusInProgress = "IN_PROGRESS"

	// UploadStatusSucceeded is a UploadStatus enum value
	UploadStatusSucceeded = "SUCCEEDED"

	// UploadStatusFailed is a UploadStatus enum value
	UploadStatusFailed = "FAILED"
)
