package cdn

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// CacheBehavior enumerates the values for cache behavior.
type CacheBehavior string

const (
	// BypassCache ...
	BypassCache CacheBehavior = "BypassCache"
	// Override ...
	Override CacheBehavior = "Override"
	// SetIfMissing ...
	SetIfMissing CacheBehavior = "SetIfMissing"
)

// PossibleCacheBehaviorValues returns an array of possible values for the CacheBehavior const type.
func PossibleCacheBehaviorValues() []CacheBehavior {
	return []CacheBehavior{BypassCache, Override, SetIfMissing}
}

// CustomDomainResourceState enumerates the values for custom domain resource state.
type CustomDomainResourceState string

const (
	// Active ...
	Active CustomDomainResourceState = "Active"
	// Creating ...
	Creating CustomDomainResourceState = "Creating"
	// Deleting ...
	Deleting CustomDomainResourceState = "Deleting"
)

// PossibleCustomDomainResourceStateValues returns an array of possible values for the CustomDomainResourceState const type.
func PossibleCustomDomainResourceStateValues() []CustomDomainResourceState {
	return []CustomDomainResourceState{Active, Creating, Deleting}
}

// CustomHTTPSProvisioningState enumerates the values for custom https provisioning state.
type CustomHTTPSProvisioningState string

const (
	// Disabled ...
	Disabled CustomHTTPSProvisioningState = "Disabled"
	// Disabling ...
	Disabling CustomHTTPSProvisioningState = "Disabling"
	// Enabled ...
	Enabled CustomHTTPSProvisioningState = "Enabled"
	// Enabling ...
	Enabling CustomHTTPSProvisioningState = "Enabling"
	// Failed ...
	Failed CustomHTTPSProvisioningState = "Failed"
)

// PossibleCustomHTTPSProvisioningStateValues returns an array of possible values for the CustomHTTPSProvisioningState const type.
func PossibleCustomHTTPSProvisioningStateValues() []CustomHTTPSProvisioningState {
	return []CustomHTTPSProvisioningState{Disabled, Disabling, Enabled, Enabling, Failed}
}

// CustomHTTPSProvisioningSubstate enumerates the values for custom https provisioning substate.
type CustomHTTPSProvisioningSubstate string

const (
	// CertificateDeleted ...
	CertificateDeleted CustomHTTPSProvisioningSubstate = "CertificateDeleted"
	// CertificateDeployed ...
	CertificateDeployed CustomHTTPSProvisioningSubstate = "CertificateDeployed"
	// DeletingCertificate ...
	DeletingCertificate CustomHTTPSProvisioningSubstate = "DeletingCertificate"
	// DeployingCertificate ...
	DeployingCertificate CustomHTTPSProvisioningSubstate = "DeployingCertificate"
	// DomainControlValidationRequestApproved ...
	DomainControlValidationRequestApproved CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestApproved"
	// DomainControlValidationRequestRejected ...
	DomainControlValidationRequestRejected CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestRejected"
	// DomainControlValidationRequestTimedOut ...
	DomainControlValidationRequestTimedOut CustomHTTPSProvisioningSubstate = "DomainControlValidationRequestTimedOut"
	// IssuingCertificate ...
	IssuingCertificate CustomHTTPSProvisioningSubstate = "IssuingCertificate"
	// PendingDomainControlValidationREquestApproval ...
	PendingDomainControlValidationREquestApproval CustomHTTPSProvisioningSubstate = "PendingDomainControlValidationREquestApproval"
	// SubmittingDomainControlValidationRequest ...
	SubmittingDomainControlValidationRequest CustomHTTPSProvisioningSubstate = "SubmittingDomainControlValidationRequest"
)

// PossibleCustomHTTPSProvisioningSubstateValues returns an array of possible values for the CustomHTTPSProvisioningSubstate const type.
func PossibleCustomHTTPSProvisioningSubstateValues() []CustomHTTPSProvisioningSubstate {
	return []CustomHTTPSProvisioningSubstate{CertificateDeleted, CertificateDeployed, DeletingCertificate, DeployingCertificate, DomainControlValidationRequestApproved, DomainControlValidationRequestRejected, DomainControlValidationRequestTimedOut, IssuingCertificate, PendingDomainControlValidationREquestApproval, SubmittingDomainControlValidationRequest}
}

// EndpointResourceState enumerates the values for endpoint resource state.
type EndpointResourceState string

const (
	// EndpointResourceStateCreating ...
	EndpointResourceStateCreating EndpointResourceState = "Creating"
	// EndpointResourceStateDeleting ...
	EndpointResourceStateDeleting EndpointResourceState = "Deleting"
	// EndpointResourceStateRunning ...
	EndpointResourceStateRunning EndpointResourceState = "Running"
	// EndpointResourceStateStarting ...
	EndpointResourceStateStarting EndpointResourceState = "Starting"
	// EndpointResourceStateStopped ...
	EndpointResourceStateStopped EndpointResourceState = "Stopped"
	// EndpointResourceStateStopping ...
	EndpointResourceStateStopping EndpointResourceState = "Stopping"
)

// PossibleEndpointResourceStateValues returns an array of possible values for the EndpointResourceState const type.
func PossibleEndpointResourceStateValues() []EndpointResourceState {
	return []EndpointResourceState{EndpointResourceStateCreating, EndpointResourceStateDeleting, EndpointResourceStateRunning, EndpointResourceStateStarting, EndpointResourceStateStopped, EndpointResourceStateStopping}
}

// GeoFilterActions enumerates the values for geo filter actions.
type GeoFilterActions string

const (
	// Allow ...
	Allow GeoFilterActions = "Allow"
	// Block ...
	Block GeoFilterActions = "Block"
)

// PossibleGeoFilterActionsValues returns an array of possible values for the GeoFilterActions const type.
func PossibleGeoFilterActionsValues() []GeoFilterActions {
	return []GeoFilterActions{Allow, Block}
}

// MatchType enumerates the values for match type.
type MatchType string

const (
	// Literal ...
	Literal MatchType = "Literal"
	// Wildcard ...
	Wildcard MatchType = "Wildcard"
)

// PossibleMatchTypeValues returns an array of possible values for the MatchType const type.
func PossibleMatchTypeValues() []MatchType {
	return []MatchType{Literal, Wildcard}
}

// Name enumerates the values for name.
type Name string

const (
	// NameCacheExpiration ...
	NameCacheExpiration Name = "CacheExpiration"
	// NameDeliveryRuleAction ...
	NameDeliveryRuleAction Name = "DeliveryRuleAction"
)

// PossibleNameValues returns an array of possible values for the Name const type.
func PossibleNameValues() []Name {
	return []Name{NameCacheExpiration, NameDeliveryRuleAction}
}

// NameBasicDeliveryRuleCondition enumerates the values for name basic delivery rule condition.
type NameBasicDeliveryRuleCondition string

const (
	// NameDeliveryRuleCondition ...
	NameDeliveryRuleCondition NameBasicDeliveryRuleCondition = "DeliveryRuleCondition"
	// NameURLFileExtension ...
	NameURLFileExtension NameBasicDeliveryRuleCondition = "UrlFileExtension"
	// NameURLPath ...
	NameURLPath NameBasicDeliveryRuleCondition = "UrlPath"
)

// PossibleNameBasicDeliveryRuleConditionValues returns an array of possible values for the NameBasicDeliveryRuleCondition const type.
func PossibleNameBasicDeliveryRuleConditionValues() []NameBasicDeliveryRuleCondition {
	return []NameBasicDeliveryRuleCondition{NameDeliveryRuleCondition, NameURLFileExtension, NameURLPath}
}

// OptimizationType enumerates the values for optimization type.
type OptimizationType string

const (
	// DynamicSiteAcceleration ...
	DynamicSiteAcceleration OptimizationType = "DynamicSiteAcceleration"
	// GeneralMediaStreaming ...
	GeneralMediaStreaming OptimizationType = "GeneralMediaStreaming"
	// GeneralWebDelivery ...
	GeneralWebDelivery OptimizationType = "GeneralWebDelivery"
	// LargeFileDownload ...
	LargeFileDownload OptimizationType = "LargeFileDownload"
	// VideoOnDemandMediaStreaming ...
	VideoOnDemandMediaStreaming OptimizationType = "VideoOnDemandMediaStreaming"
)

// PossibleOptimizationTypeValues returns an array of possible values for the OptimizationType const type.
func PossibleOptimizationTypeValues() []OptimizationType {
	return []OptimizationType{DynamicSiteAcceleration, GeneralMediaStreaming, GeneralWebDelivery, LargeFileDownload, VideoOnDemandMediaStreaming}
}

// OriginResourceState enumerates the values for origin resource state.
type OriginResourceState string

const (
	// OriginResourceStateActive ...
	OriginResourceStateActive OriginResourceState = "Active"
	// OriginResourceStateCreating ...
	OriginResourceStateCreating OriginResourceState = "Creating"
	// OriginResourceStateDeleting ...
	OriginResourceStateDeleting OriginResourceState = "Deleting"
)

// PossibleOriginResourceStateValues returns an array of possible values for the OriginResourceState const type.
func PossibleOriginResourceStateValues() []OriginResourceState {
	return []OriginResourceState{OriginResourceStateActive, OriginResourceStateCreating, OriginResourceStateDeleting}
}

// ProfileResourceState enumerates the values for profile resource state.
type ProfileResourceState string

const (
	// ProfileResourceStateActive ...
	ProfileResourceStateActive ProfileResourceState = "Active"
	// ProfileResourceStateCreating ...
	ProfileResourceStateCreating ProfileResourceState = "Creating"
	// ProfileResourceStateDeleting ...
	ProfileResourceStateDeleting ProfileResourceState = "Deleting"
	// ProfileResourceStateDisabled ...
	ProfileResourceStateDisabled ProfileResourceState = "Disabled"
)

// PossibleProfileResourceStateValues returns an array of possible values for the ProfileResourceState const type.
func PossibleProfileResourceStateValues() []ProfileResourceState {
	return []ProfileResourceState{ProfileResourceStateActive, ProfileResourceStateCreating, ProfileResourceStateDeleting, ProfileResourceStateDisabled}
}

// QueryStringCachingBehavior enumerates the values for query string caching behavior.
type QueryStringCachingBehavior string

const (
	// BypassCaching ...
	BypassCaching QueryStringCachingBehavior = "BypassCaching"
	// IgnoreQueryString ...
	IgnoreQueryString QueryStringCachingBehavior = "IgnoreQueryString"
	// NotSet ...
	NotSet QueryStringCachingBehavior = "NotSet"
	// UseQueryString ...
	UseQueryString QueryStringCachingBehavior = "UseQueryString"
)

// PossibleQueryStringCachingBehaviorValues returns an array of possible values for the QueryStringCachingBehavior const type.
func PossibleQueryStringCachingBehaviorValues() []QueryStringCachingBehavior {
	return []QueryStringCachingBehavior{BypassCaching, IgnoreQueryString, NotSet, UseQueryString}
}

// ResourceType enumerates the values for resource type.
type ResourceType string

const (
	// MicrosoftCdnProfilesEndpoints ...
	MicrosoftCdnProfilesEndpoints ResourceType = "Microsoft.Cdn/Profiles/Endpoints"
)

// PossibleResourceTypeValues returns an array of possible values for the ResourceType const type.
func PossibleResourceTypeValues() []ResourceType {
	return []ResourceType{MicrosoftCdnProfilesEndpoints}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// CustomVerizon ...
	CustomVerizon SkuName = "Custom_Verizon"
	// PremiumVerizon ...
	PremiumVerizon SkuName = "Premium_Verizon"
	// StandardAkamai ...
	StandardAkamai SkuName = "Standard_Akamai"
	// StandardChinaCdn ...
	StandardChinaCdn SkuName = "Standard_ChinaCdn"
	// StandardMicrosoft ...
	StandardMicrosoft SkuName = "Standard_Microsoft"
	// StandardVerizon ...
	StandardVerizon SkuName = "Standard_Verizon"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{CustomVerizon, PremiumVerizon, StandardAkamai, StandardChinaCdn, StandardMicrosoft, StandardVerizon}
}

// CacheExpirationActionParameters defines the parameters for the cache expiration action.
type CacheExpirationActionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// CacheBehavior - Caching behavior for the requests that include query strings. Possible values include: 'BypassCache', 'Override', 'SetIfMissing'
	CacheBehavior CacheBehavior `json:"cacheBehavior,omitempty"`
	// CacheType - The level at which the content needs to be cached.
	CacheType *string `json:"cacheType,omitempty"`
	// CacheDuration - The duration for which the the content needs to be cached. Allowed format is [d.]hh:mm:ss
	CacheDuration *string `json:"cacheDuration,omitempty"`
}

// CheckNameAvailabilityInput input of CheckNameAvailability API.
type CheckNameAvailabilityInput struct {
	// Name - The resource name to validate.
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource whose name is to be validated.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityOutput output of check name availability API.
type CheckNameAvailabilityOutput struct {
	autorest.Response `json:"-"`
	// NameAvailable - Indicates whether the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - The reason why the name is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - The detailed error message describing why the name is not available.
	Message *string `json:"message,omitempty"`
}

// CidrIPAddress CIDR Ip address
type CidrIPAddress struct {
	// BaseIPAddress - Ip adress itself.
	BaseIPAddress *string `json:"baseIpAddress,omitempty"`
	// PrefixLength - The length of the prefix of the ip address.
	PrefixLength *int32 `json:"prefixLength,omitempty"`
}

// CustomDomain friendly domain name mapping to the endpoint hostname that the customer provides for branding
// purposes, e.g. www.consoto.com.
type CustomDomain struct {
	autorest.Response       `json:"-"`
	*CustomDomainProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDomain.
func (cd CustomDomain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cd.CustomDomainProperties != nil {
		objectMap["properties"] = cd.CustomDomainProperties
	}
	if cd.ID != nil {
		objectMap["id"] = cd.ID
	}
	if cd.Name != nil {
		objectMap["name"] = cd.Name
	}
	if cd.Type != nil {
		objectMap["type"] = cd.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomDomain struct.
func (cd *CustomDomain) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customDomainProperties CustomDomainProperties
				err = json.Unmarshal(*v, &customDomainProperties)
				if err != nil {
					return err
				}
				cd.CustomDomainProperties = &customDomainProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cd.Type = &typeVar
			}
		}
	}

	return nil
}

// CustomDomainListResult result of the request to list custom domains. It contains a list of custom domain objects
// and a URL link to get the next set of results.
type CustomDomainListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN CustomDomains within an endpoint.
	Value *[]CustomDomain `json:"value,omitempty"`
	// NextLink - URL to get the next set of custom domain objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// CustomDomainListResultIterator provides access to a complete listing of CustomDomain values.
type CustomDomainListResultIterator struct {
	i    int
	page CustomDomainListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *CustomDomainListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter CustomDomainListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter CustomDomainListResultIterator) Response() CustomDomainListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter CustomDomainListResultIterator) Value() CustomDomain {
	if !iter.page.NotDone() {
		return CustomDomain{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (cdlr CustomDomainListResult) IsEmpty() bool {
	return cdlr.Value == nil || len(*cdlr.Value) == 0
}

// customDomainListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cdlr CustomDomainListResult) customDomainListResultPreparer() (*http.Request, error) {
	if cdlr.NextLink == nil || len(to.String(cdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cdlr.NextLink)))
}

// CustomDomainListResultPage contains a page of CustomDomain values.
type CustomDomainListResultPage struct {
	fn   func(CustomDomainListResult) (CustomDomainListResult, error)
	cdlr CustomDomainListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *CustomDomainListResultPage) Next() error {
	next, err := page.fn(page.cdlr)
	if err != nil {
		return err
	}
	page.cdlr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page CustomDomainListResultPage) NotDone() bool {
	return !page.cdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page CustomDomainListResultPage) Response() CustomDomainListResult {
	return page.cdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page CustomDomainListResultPage) Values() []CustomDomain {
	if page.cdlr.IsEmpty() {
		return nil
	}
	return *page.cdlr.Value
}

// CustomDomainParameters the customDomain JSON object required for custom domain creation or update.
type CustomDomainParameters struct {
	*CustomDomainPropertiesParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for CustomDomainParameters.
func (cdp CustomDomainParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cdp.CustomDomainPropertiesParameters != nil {
		objectMap["properties"] = cdp.CustomDomainPropertiesParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CustomDomainParameters struct.
func (cdp *CustomDomainParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var customDomainPropertiesParameters CustomDomainPropertiesParameters
				err = json.Unmarshal(*v, &customDomainPropertiesParameters)
				if err != nil {
					return err
				}
				cdp.CustomDomainPropertiesParameters = &customDomainPropertiesParameters
			}
		}
	}

	return nil
}

// CustomDomainProperties the JSON object that contains the properties of the custom domain to create.
type CustomDomainProperties struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
	// ResourceState - Resource status of the custom domain. Possible values include: 'Creating', 'Active', 'Deleting'
	ResourceState CustomDomainResourceState `json:"resourceState,omitempty"`
	// CustomHTTPSProvisioningState - Provisioning status of Custom Https of the custom domain. Possible values include: 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Failed'
	CustomHTTPSProvisioningState CustomHTTPSProvisioningState `json:"customHttpsProvisioningState,omitempty"`
	// CustomHTTPSProvisioningSubstate - Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step. Possible values include: 'SubmittingDomainControlValidationRequest', 'PendingDomainControlValidationREquestApproval', 'DomainControlValidationRequestApproved', 'DomainControlValidationRequestRejected', 'DomainControlValidationRequestTimedOut', 'IssuingCertificate', 'DeployingCertificate', 'CertificateDeployed', 'DeletingCertificate', 'CertificateDeleted'
	CustomHTTPSProvisioningSubstate CustomHTTPSProvisioningSubstate `json:"customHttpsProvisioningSubstate,omitempty"`
	// ValidationData - Special validation or data may be required when delivering CDN to some regions due to local compliance reasons. E.g. ICP license number of a custom domain is required to deliver content in China.
	ValidationData *string `json:"validationData,omitempty"`
	// ProvisioningState - Provisioning status of the custom domain.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// CustomDomainPropertiesParameters the JSON object that contains the properties of the custom domain to create.
type CustomDomainPropertiesParameters struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
}

// CustomDomainsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type CustomDomainsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CustomDomainsCreateFuture) Result(client CustomDomainsClient) (cd CustomDomain, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.CustomDomainsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.CustomDomainsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cd.Response.Response, err = future.GetResult(sender); err == nil && cd.Response.Response.StatusCode != http.StatusNoContent {
		cd, err = client.CreateResponder(cd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.CustomDomainsCreateFuture", "Result", cd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CustomDomainsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type CustomDomainsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CustomDomainsDeleteFuture) Result(client CustomDomainsClient) (cd CustomDomain, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.CustomDomainsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.CustomDomainsDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cd.Response.Response, err = future.GetResult(sender); err == nil && cd.Response.Response.StatusCode != http.StatusNoContent {
		cd, err = client.DeleteResponder(cd.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.CustomDomainsDeleteFuture", "Result", cd.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeepCreatedOrigin the main origin of CDN content which is added when creating a CDN endpoint.
type DeepCreatedOrigin struct {
	// Name - Origin name
	Name                         *string `json:"name,omitempty"`
	*DeepCreatedOriginProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DeepCreatedOrigin.
func (dco DeepCreatedOrigin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dco.Name != nil {
		objectMap["name"] = dco.Name
	}
	if dco.DeepCreatedOriginProperties != nil {
		objectMap["properties"] = dco.DeepCreatedOriginProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DeepCreatedOrigin struct.
func (dco *DeepCreatedOrigin) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dco.Name = &name
			}
		case "properties":
			if v != nil {
				var deepCreatedOriginProperties DeepCreatedOriginProperties
				err = json.Unmarshal(*v, &deepCreatedOriginProperties)
				if err != nil {
					return err
				}
				dco.DeepCreatedOriginProperties = &deepCreatedOriginProperties
			}
		}
	}

	return nil
}

// DeepCreatedOriginProperties properties of the origin created on the CDN endpoint.
type DeepCreatedOriginProperties struct {
	// HostName - The address of the origin. It can be a domain name, IPv4 address, or IPv6 address.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the HTTPS port. Must be between 1 and 65535
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
}

// DeliveryRule a rule that specifies a set of actions and conditions
type DeliveryRule struct {
	// Order - The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will be applied before a rule with a greater order. Rule with order 0 is a special rule. It does not require any condition and actions listed in it will always be applied.
	Order *int32 `json:"order,omitempty"`
	// Actions - A list of actions that are executed when all the conditions of a rule are satisfied.
	Actions *[]BasicDeliveryRuleAction `json:"actions,omitempty"`
	// Conditions - A list of conditions that must be matched for the actions to be executed
	Conditions *[]BasicDeliveryRuleCondition `json:"conditions,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DeliveryRule struct.
func (dr *DeliveryRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "order":
			if v != nil {
				var order int32
				err = json.Unmarshal(*v, &order)
				if err != nil {
					return err
				}
				dr.Order = &order
			}
		case "actions":
			if v != nil {
				actions, err := unmarshalBasicDeliveryRuleActionArray(*v)
				if err != nil {
					return err
				}
				dr.Actions = &actions
			}
		case "conditions":
			if v != nil {
				conditions, err := unmarshalBasicDeliveryRuleConditionArray(*v)
				if err != nil {
					return err
				}
				dr.Conditions = &conditions
			}
		}
	}

	return nil
}

// BasicDeliveryRuleAction an action for the delivery rule.
type BasicDeliveryRuleAction interface {
	AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool)
	AsDeliveryRuleAction() (*DeliveryRuleAction, bool)
}

// DeliveryRuleAction an action for the delivery rule.
type DeliveryRuleAction struct {
	// Name - Possible values include: 'NameDeliveryRuleAction', 'NameCacheExpiration'
	Name Name `json:"name,omitempty"`
}

func unmarshalBasicDeliveryRuleAction(body []byte) (BasicDeliveryRuleAction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["name"] {
	case string(NameCacheExpiration):
		var drcea DeliveryRuleCacheExpirationAction
		err := json.Unmarshal(body, &drcea)
		return drcea, err
	default:
		var dra DeliveryRuleAction
		err := json.Unmarshal(body, &dra)
		return dra, err
	}
}
func unmarshalBasicDeliveryRuleActionArray(body []byte) ([]BasicDeliveryRuleAction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	draArray := make([]BasicDeliveryRuleAction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		dra, err := unmarshalBasicDeliveryRuleAction(*rawMessage)
		if err != nil {
			return nil, err
		}
		draArray[index] = dra
	}
	return draArray, nil
}

// MarshalJSON is the custom marshaler for DeliveryRuleAction.
func (dra DeliveryRuleAction) MarshalJSON() ([]byte, error) {
	dra.Name = NameDeliveryRuleAction
	objectMap := make(map[string]interface{})
	if dra.Name != "" {
		objectMap["name"] = dra.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return nil, false
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return &dra, true
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleAction.
func (dra DeliveryRuleAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &dra, true
}

// DeliveryRuleCacheExpirationAction defines the cache expiration action for the delivery rule.
type DeliveryRuleCacheExpirationAction struct {
	// Parameters - Defines the parameters for the action.
	Parameters *CacheExpirationActionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleAction', 'NameCacheExpiration'
	Name Name `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) MarshalJSON() ([]byte, error) {
	drcea.Name = NameCacheExpiration
	objectMap := make(map[string]interface{})
	if drcea.Parameters != nil {
		objectMap["parameters"] = drcea.Parameters
	}
	if drcea.Name != "" {
		objectMap["name"] = drcea.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleCacheExpirationAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsDeliveryRuleCacheExpirationAction() (*DeliveryRuleCacheExpirationAction, bool) {
	return &drcea, true
}

// AsDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsDeliveryRuleAction() (*DeliveryRuleAction, bool) {
	return nil, false
}

// AsBasicDeliveryRuleAction is the BasicDeliveryRuleAction implementation for DeliveryRuleCacheExpirationAction.
func (drcea DeliveryRuleCacheExpirationAction) AsBasicDeliveryRuleAction() (BasicDeliveryRuleAction, bool) {
	return &drcea, true
}

// BasicDeliveryRuleCondition a condition for the delivery rule.
type BasicDeliveryRuleCondition interface {
	AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool)
	AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool)
	AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool)
}

// DeliveryRuleCondition a condition for the delivery rule.
type DeliveryRuleCondition struct {
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameURLPath', 'NameURLFileExtension'
	Name NameBasicDeliveryRuleCondition `json:"name,omitempty"`
}

func unmarshalBasicDeliveryRuleCondition(body []byte) (BasicDeliveryRuleCondition, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["name"] {
	case string(NameURLPath):
		var drupc DeliveryRuleURLPathCondition
		err := json.Unmarshal(body, &drupc)
		return drupc, err
	case string(NameURLFileExtension):
		var drufec DeliveryRuleURLFileExtensionCondition
		err := json.Unmarshal(body, &drufec)
		return drufec, err
	default:
		var drc DeliveryRuleCondition
		err := json.Unmarshal(body, &drc)
		return drc, err
	}
}
func unmarshalBasicDeliveryRuleConditionArray(body []byte) ([]BasicDeliveryRuleCondition, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	drcArray := make([]BasicDeliveryRuleCondition, len(rawMessages))

	for index, rawMessage := range rawMessages {
		drc, err := unmarshalBasicDeliveryRuleCondition(*rawMessage)
		if err != nil {
			return nil, err
		}
		drcArray[index] = drc
	}
	return drcArray, nil
}

// MarshalJSON is the custom marshaler for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) MarshalJSON() ([]byte, error) {
	drc.Name = NameDeliveryRuleCondition
	objectMap := make(map[string]interface{})
	if drc.Name != "" {
		objectMap["name"] = drc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return &drc, true
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleCondition.
func (drc DeliveryRuleCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drc, true
}

// DeliveryRuleURLFileExtensionCondition defines the URL file extension condition for the delivery rule.
type DeliveryRuleURLFileExtensionCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *URLFileExtensionConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameURLPath', 'NameURLFileExtension'
	Name NameBasicDeliveryRuleCondition `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) MarshalJSON() ([]byte, error) {
	drufec.Name = NameURLFileExtension
	objectMap := make(map[string]interface{})
	if drufec.Parameters != nil {
		objectMap["parameters"] = drufec.Parameters
	}
	if drufec.Name != "" {
		objectMap["name"] = drufec.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return nil, false
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return &drufec, true
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLFileExtensionCondition.
func (drufec DeliveryRuleURLFileExtensionCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drufec, true
}

// DeliveryRuleURLPathCondition defines the URL path condition for the delivery rule.
type DeliveryRuleURLPathCondition struct {
	// Parameters - Defines the parameters for the condition.
	Parameters *URLPathConditionParameters `json:"parameters,omitempty"`
	// Name - Possible values include: 'NameDeliveryRuleCondition', 'NameURLPath', 'NameURLFileExtension'
	Name NameBasicDeliveryRuleCondition `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) MarshalJSON() ([]byte, error) {
	drupc.Name = NameURLPath
	objectMap := make(map[string]interface{})
	if drupc.Parameters != nil {
		objectMap["parameters"] = drupc.Parameters
	}
	if drupc.Name != "" {
		objectMap["name"] = drupc.Name
	}
	return json.Marshal(objectMap)
}

// AsDeliveryRuleURLPathCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleURLPathCondition() (*DeliveryRuleURLPathCondition, bool) {
	return &drupc, true
}

// AsDeliveryRuleURLFileExtensionCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleURLFileExtensionCondition() (*DeliveryRuleURLFileExtensionCondition, bool) {
	return nil, false
}

// AsDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsDeliveryRuleCondition() (*DeliveryRuleCondition, bool) {
	return nil, false
}

// AsBasicDeliveryRuleCondition is the BasicDeliveryRuleCondition implementation for DeliveryRuleURLPathCondition.
func (drupc DeliveryRuleURLPathCondition) AsBasicDeliveryRuleCondition() (BasicDeliveryRuleCondition, bool) {
	return &drupc, true
}

// EdgeNode edgenode is a global Point of Presence (POP) location used to deliver CDN content to end users.
type EdgeNode struct {
	*EdgeNodeProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EdgeNode.
func (en EdgeNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if en.EdgeNodeProperties != nil {
		objectMap["properties"] = en.EdgeNodeProperties
	}
	if en.ID != nil {
		objectMap["id"] = en.ID
	}
	if en.Name != nil {
		objectMap["name"] = en.Name
	}
	if en.Type != nil {
		objectMap["type"] = en.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EdgeNode struct.
func (en *EdgeNode) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var edgeNodeProperties EdgeNodeProperties
				err = json.Unmarshal(*v, &edgeNodeProperties)
				if err != nil {
					return err
				}
				en.EdgeNodeProperties = &edgeNodeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				en.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				en.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				en.Type = &typeVar
			}
		}
	}

	return nil
}

// EdgeNodeProperties the JSON object that contains the properties required to create an edgenode.
type EdgeNodeProperties struct {
	// IPAddressGroups - List of ip address groups.
	IPAddressGroups *[]IPAddressGroup `json:"ipAddressGroups,omitempty"`
}

// EdgenodeResult result of the request to list CDN edgenodes. It contains a list of ip address group and a URL
// link to get the next set of results.
type EdgenodeResult struct {
	autorest.Response `json:"-"`
	// Value - Edge node of CDN service.
	Value *[]EdgeNode `json:"value,omitempty"`
	// NextLink - URL to get the next set of edgenode list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// EdgenodeResultIterator provides access to a complete listing of EdgeNode values.
type EdgenodeResultIterator struct {
	i    int
	page EdgenodeResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EdgenodeResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EdgenodeResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EdgenodeResultIterator) Response() EdgenodeResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EdgenodeResultIterator) Value() EdgeNode {
	if !iter.page.NotDone() {
		return EdgeNode{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (er EdgenodeResult) IsEmpty() bool {
	return er.Value == nil || len(*er.Value) == 0
}

// edgenodeResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (er EdgenodeResult) edgenodeResultPreparer() (*http.Request, error) {
	if er.NextLink == nil || len(to.String(er.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(er.NextLink)))
}

// EdgenodeResultPage contains a page of EdgeNode values.
type EdgenodeResultPage struct {
	fn func(EdgenodeResult) (EdgenodeResult, error)
	er EdgenodeResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EdgenodeResultPage) Next() error {
	next, err := page.fn(page.er)
	if err != nil {
		return err
	}
	page.er = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EdgenodeResultPage) NotDone() bool {
	return !page.er.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EdgenodeResultPage) Response() EdgenodeResult {
	return page.er
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EdgenodeResultPage) Values() []EdgeNode {
	if page.er.IsEmpty() {
		return nil
	}
	return *page.er.Value
}

// Endpoint CDN endpoint is the entity within a CDN profile containing configuration information such as origin,
// protocol, content caching and delivery behavior. The CDN endpoint uses the URL format
// <endpointname>.azureedge.net.
type Endpoint struct {
	autorest.Response   `json:"-"`
	*EndpointProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Endpoint.
func (e Endpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.EndpointProperties != nil {
		objectMap["properties"] = e.EndpointProperties
	}
	if e.Location != nil {
		objectMap["location"] = e.Location
	}
	if e.Tags != nil {
		objectMap["tags"] = e.Tags
	}
	if e.ID != nil {
		objectMap["id"] = e.ID
	}
	if e.Name != nil {
		objectMap["name"] = e.Name
	}
	if e.Type != nil {
		objectMap["type"] = e.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Endpoint struct.
func (e *Endpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var endpointProperties EndpointProperties
				err = json.Unmarshal(*v, &endpointProperties)
				if err != nil {
					return err
				}
				e.EndpointProperties = &endpointProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				e.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				e.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				e.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				e.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				e.Type = &typeVar
			}
		}
	}

	return nil
}

// EndpointListResult result of the request to list endpoints. It contains a list of endpoint objects and a URL
// link to get the the next set of results.
type EndpointListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN endpoints within a profile
	Value *[]Endpoint `json:"value,omitempty"`
	// NextLink - URL to get the next set of endpoint objects if there is any.
	NextLink *string `json:"nextLink,omitempty"`
}

// EndpointListResultIterator provides access to a complete listing of Endpoint values.
type EndpointListResultIterator struct {
	i    int
	page EndpointListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EndpointListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EndpointListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EndpointListResultIterator) Response() EndpointListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EndpointListResultIterator) Value() Endpoint {
	if !iter.page.NotDone() {
		return Endpoint{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (elr EndpointListResult) IsEmpty() bool {
	return elr.Value == nil || len(*elr.Value) == 0
}

// endpointListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (elr EndpointListResult) endpointListResultPreparer() (*http.Request, error) {
	if elr.NextLink == nil || len(to.String(elr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(elr.NextLink)))
}

// EndpointListResultPage contains a page of Endpoint values.
type EndpointListResultPage struct {
	fn  func(EndpointListResult) (EndpointListResult, error)
	elr EndpointListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EndpointListResultPage) Next() error {
	next, err := page.fn(page.elr)
	if err != nil {
		return err
	}
	page.elr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EndpointListResultPage) NotDone() bool {
	return !page.elr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EndpointListResultPage) Response() EndpointListResult {
	return page.elr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EndpointListResultPage) Values() []Endpoint {
	if page.elr.IsEmpty() {
		return nil
	}
	return *page.elr.Value
}

// EndpointProperties the JSON object that contains the properties required to create an endpoint.
type EndpointProperties struct {
	// HostName - The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. consoto.azureedge.net
	HostName *string `json:"hostName,omitempty"`
	// Origins - The source of the content being delivered via CDN.
	Origins *[]DeepCreatedOrigin `json:"origins,omitempty"`
	// ResourceState - Resource status of the endpoint. Possible values include: 'EndpointResourceStateCreating', 'EndpointResourceStateDeleting', 'EndpointResourceStateRunning', 'EndpointResourceStateStarting', 'EndpointResourceStateStopped', 'EndpointResourceStateStopping'
	ResourceState EndpointResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - Provisioning status of the endpoint.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// OriginHostHeader - The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
	OriginHostHeader *string `json:"originHostHeader,omitempty"`
	// OriginPath - A directory path on the origin that CDN can use to retreive content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string `json:"originPath,omitempty"`
	// ContentTypesToCompress - List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress *[]string `json:"contentTypesToCompress,omitempty"`
	// IsCompressionEnabled - Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool `json:"isCompressionEnabled,omitempty"`
	// IsHTTPAllowed - Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPAllowed *bool `json:"isHttpAllowed,omitempty"`
	// IsHTTPSAllowed - Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPSAllowed *bool `json:"isHttpsAllowed,omitempty"`
	// QueryStringCachingBehavior - Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL. Possible values include: 'IgnoreQueryString', 'BypassCaching', 'UseQueryString', 'NotSet'
	QueryStringCachingBehavior QueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`
	// OptimizationType - Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this information, CDN can apply scenario driven optimization. Possible values include: 'GeneralWebDelivery', 'GeneralMediaStreaming', 'VideoOnDemandMediaStreaming', 'LargeFileDownload', 'DynamicSiteAcceleration'
	OptimizationType OptimizationType `json:"optimizationType,omitempty"`
	// ProbePath - Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the origin path.
	ProbePath *string `json:"probePath,omitempty"`
	// GeoFilters - List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an acess rule to a specified path or content, e.g. block APAC for path /pictures/
	GeoFilters *[]GeoFilter `json:"geoFilters,omitempty"`
	// DeliveryPolicy - A policy that specifies the delivery rules to be used for an endpoint.
	DeliveryPolicy *EndpointPropertiesUpdateParametersDeliveryPolicy `json:"deliveryPolicy,omitempty"`
}

// EndpointPropertiesUpdateParameters the JSON object containing endpoint update parameters.
type EndpointPropertiesUpdateParameters struct {
	// OriginHostHeader - The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services require this host header value to match the origin hostname by default.
	OriginHostHeader *string `json:"originHostHeader,omitempty"`
	// OriginPath - A directory path on the origin that CDN can use to retreive content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string `json:"originPath,omitempty"`
	// ContentTypesToCompress - List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress *[]string `json:"contentTypesToCompress,omitempty"`
	// IsCompressionEnabled - Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will be served as compressed if user requests for a compressed version. Content won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool `json:"isCompressionEnabled,omitempty"`
	// IsHTTPAllowed - Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPAllowed *bool `json:"isHttpAllowed,omitempty"`
	// IsHTTPSAllowed - Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS) must be allowed.
	IsHTTPSAllowed *bool `json:"isHttpsAllowed,omitempty"`
	// QueryStringCachingBehavior - Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL. Possible values include: 'IgnoreQueryString', 'BypassCaching', 'UseQueryString', 'NotSet'
	QueryStringCachingBehavior QueryStringCachingBehavior `json:"queryStringCachingBehavior,omitempty"`
	// OptimizationType - Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this information, CDN can apply scenario driven optimization. Possible values include: 'GeneralWebDelivery', 'GeneralMediaStreaming', 'VideoOnDemandMediaStreaming', 'LargeFileDownload', 'DynamicSiteAcceleration'
	OptimizationType OptimizationType `json:"optimizationType,omitempty"`
	// ProbePath - Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal routes for the CDN. This is relative to the origin path.
	ProbePath *string `json:"probePath,omitempty"`
	// GeoFilters - List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an acess rule to a specified path or content, e.g. block APAC for path /pictures/
	GeoFilters *[]GeoFilter `json:"geoFilters,omitempty"`
	// DeliveryPolicy - A policy that specifies the delivery rules to be used for an endpoint.
	DeliveryPolicy *EndpointPropertiesUpdateParametersDeliveryPolicy `json:"deliveryPolicy,omitempty"`
}

// EndpointPropertiesUpdateParametersDeliveryPolicy a policy that specifies the delivery rules to be used for an
// endpoint.
type EndpointPropertiesUpdateParametersDeliveryPolicy struct {
	// Description - User-friendly description of the policy.
	Description *string `json:"description,omitempty"`
	// Rules - A list of the delivery rules.
	Rules *[]DeliveryRule `json:"rules,omitempty"`
}

// EndpointsCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsCreateFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.CreateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsCreateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsDeleteFuture) Result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EndpointsLoadContentFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsLoadContentFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsLoadContentFuture) Result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsLoadContentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsLoadContentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EndpointsPurgeContentFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type EndpointsPurgeContentFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsPurgeContentFuture) Result(client EndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsPurgeContentFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsPurgeContentFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// EndpointsStartFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsStartFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsStartFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsStartFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.StartResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsStartFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointsStopFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsStopFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsStopFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsStopFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.StopResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsStopFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type EndpointsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EndpointsUpdateFuture) Result(client EndpointsClient) (e Endpoint, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.EndpointsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.EndpointsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.UpdateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.EndpointsUpdateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// EndpointUpdateParameters properties required to create or update an endpoint.
type EndpointUpdateParameters struct {
	// Tags - Endpoint tags.
	Tags                                map[string]*string `json:"tags"`
	*EndpointPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for EndpointUpdateParameters.
func (eup EndpointUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if eup.Tags != nil {
		objectMap["tags"] = eup.Tags
	}
	if eup.EndpointPropertiesUpdateParameters != nil {
		objectMap["properties"] = eup.EndpointPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EndpointUpdateParameters struct.
func (eup *EndpointUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				eup.Tags = tags
			}
		case "properties":
			if v != nil {
				var endpointPropertiesUpdateParameters EndpointPropertiesUpdateParameters
				err = json.Unmarshal(*v, &endpointPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				eup.EndpointPropertiesUpdateParameters = &endpointPropertiesUpdateParameters
			}
		}
	}

	return nil
}

// ErrorResponse error reponse indicates CDN service is not able to process the incoming request. The reason is
// provided in the error message.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// GeoFilter rules defining user's geo access within a CDN endpoint.
type GeoFilter struct {
	// RelativePath - Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
	RelativePath *string `json:"relativePath,omitempty"`
	// Action - Action of the geo filter, i.e. allow or block access. Possible values include: 'Block', 'Allow'
	Action GeoFilterActions `json:"action,omitempty"`
	// CountryCodes - Two letter country codes defining user country access in a geo filter, e.g. AU, MX, US.
	CountryCodes *[]string `json:"countryCodes,omitempty"`
}

// IPAddressGroup CDN Ip address group
type IPAddressGroup struct {
	// DeliveryRegion - The delivery region of the ip address group
	DeliveryRegion *string `json:"deliveryRegion,omitempty"`
	// Ipv4Addresses - The list of ip v4 addresses.
	Ipv4Addresses *[]CidrIPAddress `json:"ipv4Addresses,omitempty"`
	// Ipv6Addresses - The list of ip v6 addresses.
	Ipv6Addresses *[]CidrIPAddress `json:"ipv6Addresses,omitempty"`
}

// LoadParameters parameters required for content load.
type LoadParameters struct {
	// ContentPaths - The path to the content to be loaded. Path should be a relative file URL of the origin.
	ContentPaths *[]string `json:"contentPaths,omitempty"`
}

// Operation CDN REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Cdn
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationsListResult result of the request to list CDN operations. It contains a list of operations and a URL
// link to get the next set of results.
type OperationsListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN operations supported by the CDN resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationsListResultIterator provides access to a complete listing of Operation values.
type OperationsListResultIterator struct {
	i    int
	page OperationsListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationsListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationsListResultIterator) Response() OperationsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationsListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationsListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationsListResult) operationsListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationsListResultPage contains a page of Operation values.
type OperationsListResultPage struct {
	fn  func(OperationsListResult) (OperationsListResult, error)
	olr OperationsListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationsListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationsListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationsListResultPage) Response() OperationsListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationsListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Origin CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an
// endpoint do not have the requested content cached, they attempt to fetch it from one or more of the configured
// origins.
type Origin struct {
	autorest.Response `json:"-"`
	*OriginProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Origin.
func (o Origin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.OriginProperties != nil {
		objectMap["properties"] = o.OriginProperties
	}
	if o.Location != nil {
		objectMap["location"] = o.Location
	}
	if o.Tags != nil {
		objectMap["tags"] = o.Tags
	}
	if o.ID != nil {
		objectMap["id"] = o.ID
	}
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.Type != nil {
		objectMap["type"] = o.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Origin struct.
func (o *Origin) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var originProperties OriginProperties
				err = json.Unmarshal(*v, &originProperties)
				if err != nil {
					return err
				}
				o.OriginProperties = &originProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				o.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				o.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				o.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				o.Type = &typeVar
			}
		}
	}

	return nil
}

// OriginListResult result of the request to list origins. It contains a list of origin objects and a URL link to
// get the next set of results.
type OriginListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN origins within an endpoint
	Value *[]Origin `json:"value,omitempty"`
	// NextLink - URL to get the next set of origin objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OriginListResultIterator provides access to a complete listing of Origin values.
type OriginListResultIterator struct {
	i    int
	page OriginListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OriginListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OriginListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OriginListResultIterator) Response() OriginListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OriginListResultIterator) Value() Origin {
	if !iter.page.NotDone() {
		return Origin{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OriginListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// originListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OriginListResult) originListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OriginListResultPage contains a page of Origin values.
type OriginListResultPage struct {
	fn  func(OriginListResult) (OriginListResult, error)
	olr OriginListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OriginListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OriginListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OriginListResultPage) Response() OriginListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OriginListResultPage) Values() []Origin {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// OriginProperties the JSON object that contains the properties of the origin.
type OriginProperties struct {
	// HostName - The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the https port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
	// ResourceState - Resource status of the origin. Possible values include: 'OriginResourceStateCreating', 'OriginResourceStateActive', 'OriginResourceStateDeleting'
	ResourceState OriginResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - Provisioning status of the origin.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// OriginPropertiesParameters the JSON object that contains the properties of the origin.
type OriginPropertiesParameters struct {
	// HostName - The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.
	HostName *string `json:"hostName,omitempty"`
	// HTTPPort - The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32 `json:"httpPort,omitempty"`
	// HTTPSPort - The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32 `json:"httpsPort,omitempty"`
}

// OriginsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type OriginsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *OriginsUpdateFuture) Result(client OriginsClient) (o Origin, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.OriginsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.OriginsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if o.Response.Response, err = future.GetResult(sender); err == nil && o.Response.Response.StatusCode != http.StatusNoContent {
		o, err = client.UpdateResponder(o.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.OriginsUpdateFuture", "Result", o.Response.Response, "Failure responding to request")
		}
	}
	return
}

// OriginUpdateParameters origin properties needed for origin creation or update.
type OriginUpdateParameters struct {
	*OriginPropertiesParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OriginUpdateParameters.
func (oup OriginUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oup.OriginPropertiesParameters != nil {
		objectMap["properties"] = oup.OriginPropertiesParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OriginUpdateParameters struct.
func (oup *OriginUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var originPropertiesParameters OriginPropertiesParameters
				err = json.Unmarshal(*v, &originPropertiesParameters)
				if err != nil {
					return err
				}
				oup.OriginPropertiesParameters = &originPropertiesParameters
			}
		}
	}

	return nil
}

// Profile CDN profile is a logical grouping of endpoints that share the same settings, such as CDN provider and
// pricing tier.
type Profile struct {
	autorest.Response `json:"-"`
	// Sku - The pricing tier (defines a CDN provider, feature list and rate) of the CDN profile.
	Sku                *Sku `json:"sku,omitempty"`
	*ProfileProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Profile.
func (p Profile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.Sku != nil {
		objectMap["sku"] = p.Sku
	}
	if p.ProfileProperties != nil {
		objectMap["properties"] = p.ProfileProperties
	}
	if p.Location != nil {
		objectMap["location"] = p.Location
	}
	if p.Tags != nil {
		objectMap["tags"] = p.Tags
	}
	if p.ID != nil {
		objectMap["id"] = p.ID
	}
	if p.Name != nil {
		objectMap["name"] = p.Name
	}
	if p.Type != nil {
		objectMap["type"] = p.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Profile struct.
func (p *Profile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				p.Sku = &sku
			}
		case "properties":
			if v != nil {
				var profileProperties ProfileProperties
				err = json.Unmarshal(*v, &profileProperties)
				if err != nil {
					return err
				}
				p.ProfileProperties = &profileProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				p.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				p.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// ProfileListResult result of the request to list profiles. It contains a list of profile objects and a URL link
// to get the the next set of results.
type ProfileListResult struct {
	autorest.Response `json:"-"`
	// Value - List of CDN profiles within a resource group.
	Value *[]Profile `json:"value,omitempty"`
	// NextLink - URL to get the next set of profile objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProfileListResultIterator provides access to a complete listing of Profile values.
type ProfileListResultIterator struct {
	i    int
	page ProfileListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProfileListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProfileListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProfileListResultIterator) Response() ProfileListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProfileListResultIterator) Value() Profile {
	if !iter.page.NotDone() {
		return Profile{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProfileListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// profileListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProfileListResult) profileListResultPreparer() (*http.Request, error) {
	if plr.NextLink == nil || len(to.String(plr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProfileListResultPage contains a page of Profile values.
type ProfileListResultPage struct {
	fn  func(ProfileListResult) (ProfileListResult, error)
	plr ProfileListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProfileListResultPage) Next() error {
	next, err := page.fn(page.plr)
	if err != nil {
		return err
	}
	page.plr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProfileListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProfileListResultPage) Response() ProfileListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProfileListResultPage) Values() []Profile {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// ProfileProperties the JSON object that contains the properties required to create a profile.
type ProfileProperties struct {
	// ResourceState - Resource status of the profile. Possible values include: 'ProfileResourceStateCreating', 'ProfileResourceStateActive', 'ProfileResourceStateDeleting', 'ProfileResourceStateDisabled'
	ResourceState ProfileResourceState `json:"resourceState,omitempty"`
	// ProvisioningState - Provisioning status of the profile.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// ProfilesCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ProfilesCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ProfilesCreateFuture) Result(client ProfilesClient) (p Profile, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.ProfilesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.ProfilesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.CreateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.ProfilesCreateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ProfilesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ProfilesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ProfilesDeleteFuture) Result(client ProfilesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.ProfilesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.ProfilesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ProfilesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ProfilesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ProfilesUpdateFuture) Result(client ProfilesClient) (p Profile, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "cdn.ProfilesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("cdn.ProfilesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if p.Response.Response, err = future.GetResult(sender); err == nil && p.Response.Response.StatusCode != http.StatusNoContent {
		p, err = client.UpdateResponder(p.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "cdn.ProfilesUpdateFuture", "Result", p.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ProfileUpdateParameters properties required to update a profile.
type ProfileUpdateParameters struct {
	// Tags - Profile tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ProfileUpdateParameters.
func (pup ProfileUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pup.Tags != nil {
		objectMap["tags"] = pup.Tags
	}
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// PurgeParameters parameters required for content purge.
type PurgeParameters struct {
	// ContentPaths - The path to the content to be purged. Can describe a file path or a wild card directory.
	ContentPaths *[]string `json:"contentPaths,omitempty"`
}

// Resource the core properties of ARM resources
type Resource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// ResourceUsage output of check resource usage API.
type ResourceUsage struct {
	// ResourceType - Resource type for which the usage is provided.
	ResourceType *string `json:"resourceType,omitempty"`
	// Unit - Unit of the usage. e.g. Count.
	Unit *string `json:"unit,omitempty"`
	// CurrentValue - Actual value of usage on the specified resource type.
	CurrentValue *int32 `json:"currentValue,omitempty"`
	// Limit - Quota of the specified resource type.
	Limit *int32 `json:"limit,omitempty"`
}

// ResourceUsageListResult output of check resource usage API.
type ResourceUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - List of resource usages.
	Value *[]ResourceUsage `json:"value,omitempty"`
	// NextLink - URL to get the next set of custom domain objects if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceUsageListResultIterator provides access to a complete listing of ResourceUsage values.
type ResourceUsageListResultIterator struct {
	i    int
	page ResourceUsageListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceUsageListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceUsageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceUsageListResultIterator) Response() ResourceUsageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceUsageListResultIterator) Value() ResourceUsage {
	if !iter.page.NotDone() {
		return ResourceUsage{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (rulr ResourceUsageListResult) IsEmpty() bool {
	return rulr.Value == nil || len(*rulr.Value) == 0
}

// resourceUsageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rulr ResourceUsageListResult) resourceUsageListResultPreparer() (*http.Request, error) {
	if rulr.NextLink == nil || len(to.String(rulr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rulr.NextLink)))
}

// ResourceUsageListResultPage contains a page of ResourceUsage values.
type ResourceUsageListResultPage struct {
	fn   func(ResourceUsageListResult) (ResourceUsageListResult, error)
	rulr ResourceUsageListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceUsageListResultPage) Next() error {
	next, err := page.fn(page.rulr)
	if err != nil {
		return err
	}
	page.rulr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceUsageListResultPage) NotDone() bool {
	return !page.rulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceUsageListResultPage) Response() ResourceUsageListResult {
	return page.rulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceUsageListResultPage) Values() []ResourceUsage {
	if page.rulr.IsEmpty() {
		return nil
	}
	return *page.rulr.Value
}

// Sku the pricing tier (defines a CDN provider, feature list and rate) of the CDN profile.
type Sku struct {
	// Name - Name of the pricing tier. Possible values include: 'StandardVerizon', 'PremiumVerizon', 'CustomVerizon', 'StandardAkamai', 'StandardChinaCdn', 'StandardMicrosoft'
	Name SkuName `json:"name,omitempty"`
}

// SsoURI the URI required to login to the supplemental portal from the Azure portal.
type SsoURI struct {
	autorest.Response `json:"-"`
	// SsoURIValue - The URI used to login to the supplemental portal.
	SsoURIValue *string `json:"ssoUriValue,omitempty"`
}

// SupportedOptimizationTypesListResult the result of the GetSupportedOptimizationTypes API
type SupportedOptimizationTypesListResult struct {
	autorest.Response `json:"-"`
	// SupportedOptimizationTypes - Supported optimization types for a profile.
	SupportedOptimizationTypes *[]OptimizationType `json:"supportedOptimizationTypes,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource.
type TrackedResource struct {
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.ID != nil {
		objectMap["id"] = tr.ID
	}
	if tr.Name != nil {
		objectMap["name"] = tr.Name
	}
	if tr.Type != nil {
		objectMap["type"] = tr.Type
	}
	return json.Marshal(objectMap)
}

// URLFileExtensionConditionParameters defines the parameters for the URL file extension condition.
type URLFileExtensionConditionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// Extensions - A list of extensions for the condition of the delivery rule.
	Extensions *[]string `json:"extensions,omitempty"`
}

// URLPathConditionParameters defines the parameters for the URL path condition.
type URLPathConditionParameters struct {
	OdataType *string `json:"@odata.type,omitempty"`
	// Path - A URL path for the condition of the delivery rule
	Path *string `json:"path,omitempty"`
	// MatchType - The match type for the condition of the delivery rule. Possible values include: 'Literal', 'Wildcard'
	MatchType MatchType `json:"matchType,omitempty"`
}

// ValidateCustomDomainInput input of the custom domain to be validated for DNS mapping.
type ValidateCustomDomainInput struct {
	// HostName - The host name of the custom domain. Must be a domain name.
	HostName *string `json:"hostName,omitempty"`
}

// ValidateCustomDomainOutput output of custom domain validation.
type ValidateCustomDomainOutput struct {
	autorest.Response `json:"-"`
	// CustomDomainValidated - Indicates whether the custom domain is valid or not.
	CustomDomainValidated *bool `json:"customDomainValidated,omitempty"`
	// Reason - The reason why the custom domain is not valid.
	Reason *string `json:"reason,omitempty"`
	// Message - Error message describing why the custom domain is not valid.
	Message *string `json:"message,omitempty"`
}

// ValidateProbeInput input of the validate probe API.
type ValidateProbeInput struct {
	// ProbeURL - The probe URL to validate.
	ProbeURL *string `json:"probeURL,omitempty"`
}

// ValidateProbeOutput output of the validate probe API.
type ValidateProbeOutput struct {
	autorest.Response `json:"-"`
	// IsValid - Indicates whether the probe URL is accepted or not.
	IsValid *bool `json:"isValid,omitempty"`
	// ErrorCode - Specifies the error code when the probe url is not accepted.
	ErrorCode *string `json:"errorCode,omitempty"`
	// Message - The detailed error message describing why the probe URL is not accepted.
	Message *string `json:"message,omitempty"`
}
