/// <reference types="node" />
import * as childProcess from 'child_process';
import { Chalk } from 'chalk';
import * as webpack from 'webpack';
import { CancellationToken } from './CancellationToken';
import { NormalizedMessage } from './NormalizedMessage';
import { Message } from './Message';
type Formatter = (message: NormalizedMessage, useColors: boolean) => string;
interface Logger {
    error(message?: any): void;
    warn(message?: any): void;
    info(message?: any): void;
}
interface Options {
    typescript?: string;
    tsconfig: string;
    compilerOptions: object;
    tslint: string | true;
    watch: string | string[];
    async: boolean;
    ignoreDiagnostics: number[];
    ignoreLints: string[];
    reportFiles: string[];
    colors: boolean;
    logger: Logger;
    formatter: 'default' | 'codeframe' | Formatter;
    formatterOptions: any;
    silent: boolean;
    checkSyntacticErrors: boolean;
    memoryLimit: number;
    workers: number;
    vue: boolean;
}
/**
 * ForkTsCheckerWebpackPlugin
 * Runs typescript type checker and linter (tslint) on separate process.
 * This speed-ups build a lot.
 *
 * Options description in README.md
 */
declare class ForkTsCheckerWebpackPlugin {
    static DEFAULT_MEMORY_LIMIT: number;
    static ONE_CPU: number;
    static ALL_CPUS: number;
    static ONE_CPU_FREE: number;
    static TWO_CPUS_FREE: number;
    typescriptPath: string;
    options: Partial<Options>;
    tsconfig: string;
    compilerOptions: object;
    tslint: string | true;
    watch: string[];
    ignoreDiagnostics: number[];
    ignoreLints: string[];
    reportFiles: string[];
    logger: Logger;
    silent: boolean;
    async: boolean;
    checkSyntacticErrors: boolean;
    workersNumber: number;
    memoryLimit: number;
    useColors: boolean;
    colors: Chalk;
    formatter: Formatter;
    tsconfigPath: string;
    tslintPath: string;
    watchPaths: string[];
    compiler: any;
    started: [number, number];
    elapsed: [number, number];
    cancellationToken: CancellationToken;
    isWatching: boolean;
    checkDone: boolean;
    compilationDone: boolean;
    diagnostics: NormalizedMessage[];
    lints: NormalizedMessage[];
    emitCallback: () => void;
    doneCallback: () => void;
    typescriptVersion: any;
    tslintVersion: any;
    service: childProcess.ChildProcess;
    vue: boolean;
    constructor(options?: Partial<Options>);
    static createFormatter(type: 'default' | 'codeframe', options: any): (message: NormalizedMessage, useColors: boolean) => string;
    apply(compiler: webpack.Compiler): void;
    computeContextPath(filePath: string): string;
    pluginStart(): void;
    pluginStop(): void;
    registerCustomHooks(): void;
    pluginCompile(): void;
    pluginEmit(): void;
    pluginDone(): void;
    spawnService(): void;
    killService(): void;
    handleServiceMessage(message: Message): void;
    handleServiceExit(_code: string | number, signal: string): void;
    createEmitCallback(compilation: any, callback: () => void): (this: ForkTsCheckerWebpackPlugin) => void;
    createNoopEmitCallback(): () => void;
    createDoneCallback(): (this: ForkTsCheckerWebpackPlugin) => void;
}
export = ForkTsCheckerWebpackPlugin;
declare namespace ForkTsCheckerWebpackPlugin {
}
