'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _isPromise = require('is-promise');

var _isPromise2 = _interopRequireDefault(_isPromise);

var _reduxStandardAction = require('redux-standard-action');

var hasPromiseProps = function hasPromiseProps(object) {
  return Object.keys(object).some(function (key) {
    return _isPromise2['default'](object[key]);
  });
};

exports['default'] = function () {
  return function (next) {
    return function (action) {
      if (!_reduxStandardAction.isRSA(action) || !hasPromiseProps(action.payload)) {
        return next(action);
      }

      var payload = action.payload;
      var type = action.type;
      var types = action.types;
      var meta = action.meta;

      var _ref = types || [type + '/pending', type + '/success', type + '/failure'];

      var PENDING = _ref[0];
      var SUCCESS = _ref[1];
      var FAILURE = _ref[2];

      var _Object$keys$reduce = Object.keys(payload).reduce(function (_ref2, key) {
        var a = _ref2[0];
        var b = _ref2[1];

        var _extends2, _extends3;

        return _isPromise2['default'](payload[key]) ? [_extends({}, a, (_extends2 = {}, _extends2[key] = payload[key], _extends2)), b] : [a, _extends({}, b, (_extends3 = {}, _extends3[key] = payload[key], _extends3))];
      }, [{}, {}]);

      var promiseProps = _Object$keys$reduce[0];
      var nonPromiseProps = _Object$keys$reduce[1];

      next({
        type: PENDING,
        payload: nonPromiseProps,
        meta: meta
      });

      return Promise.all(Object.keys(promiseProps).map(function (key) {
        return promiseProps[key];
      })).then(function (results) {
        return Object.keys(promiseProps).reduce(function (output, key, index) {
          var _extends4;

          return _extends({}, output, (_extends4 = {}, _extends4[key] = results[index], _extends4));
        }, {});
      }).then(function (results) {
        return next({
          type: SUCCESS,
          payload: _extends({}, results, nonPromiseProps),
          meta: meta
        });
      }, function (error) {
        return next({
          type: FAILURE,
          payload: error,
          error: true,
          meta: _extends({}, meta, nonPromiseProps)
        });
      });
    };
  };
};

module.exports = exports['default'];