Object.defineProperty(exports, "__esModule", {
    value: true
});
var attr2obj = function attr2obj(elem) {
    var prefix = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "data";

    var attrs = elem.attributes;
    var dataAttrs = {};
    var rdashAlpha = /-([\da-z])/gi;
    var fcamelCase = function fcamelCase(all, letter) {
        return letter.toUpperCase();
    };
    var camelCase = function camelCase(string) {
        return string.replace(rdashAlpha, fcamelCase);
    };

    if (elem.nodeType === 1) {
        var i = attrs.length;
        while (i--) {
            var name = attrs[i].name;
            if (name.indexOf(prefix + "-") === 0) {
                var camelName = camelCase(name.slice(prefix.length + 1));
                dataAttrs[camelName] = elem.getAttribute(name);
            }
        }
    }
    return dataAttrs;
};

exports.default = attr2obj;