Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.TrackBindingPlugin = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.default = useTrackBindingPlugin;

var _EventListener = require("fbjs/lib/EventListener");

var _EventListener2 = _interopRequireDefault(_EventListener);

var _attr2obj = require("./utils/attr2obj");

var _attr2obj2 = _interopRequireDefault(_attr2obj);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function isLeftClickEvent(event) {
    return event.button === 0;
}

function isModifiedEvent(event) {
    return !!(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey);
}

var TrackBindingPlugin = exports.TrackBindingPlugin = function () {
    function TrackBindingPlugin() {
        var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
            _ref$attributePrefix = _ref.attributePrefix,
            attributePrefix = _ref$attributePrefix === undefined ? "data-metrics" : _ref$attributePrefix,
            _ref$traverseParent = _ref.traverseParent,
            traverseParent = _ref$traverseParent === undefined ? false : _ref$traverseParent;

        _classCallCheck(this, TrackBindingPlugin);

        this._attributePrefix = attributePrefix;
        this._traverseParent = traverseParent;
    }

    _createClass(TrackBindingPlugin, [{
        key: "listen",
        value: function listen(callback) {
            var rootElement = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : document.body;

            if (typeof callback !== "function") {
                throw new Error("callback needs to be a function.");
            }

            if (rootElement && rootElement.nodeType !== 1) {
                throw new Error("rootElement needs to be a valid node element.");
            }

            if (this._clickHandler) {
                this.remove();
            }

            this._rootElement = rootElement;
            this._clickHandler = _EventListener2.default.listen(rootElement, "click", this._handleClick.bind(this, callback));

            return {
                target: this,
                remove: this.remove.bind(this)
            };
        }
    }, {
        key: "remove",
        value: function remove() {
            if (this._clickHandler) {
                this._clickHandler.remove();
                this._clickHandler = null;
            }
        }

        /**
         * A click handler to perform custom link tracking, any element with 'metrics-*' attribute will be tracked.
         *
         * @method _handleClick
         * @param {Object} event
         * @private
         */

    }, {
        key: "_handleClick",
        value: function _handleClick(callback, event) {
            if (isModifiedEvent(event) || !isLeftClickEvent(event)) {
                return;
            }

            var elem = event.target || event.srcElement;
            var dataset = this._getData(elem);

            if (this._traverseParent) {
                var rootElement = this._rootElement;
                while (elem !== rootElement) {
                    elem = elem.parentElement || elem.parentNode;
                    dataset = _extends({}, this._getData(elem), dataset);
                }
            }

            if (!Object.keys(dataset).length) {
                return;
            }

            var eventName = dataset && dataset.eventName;
            var mergePagedefaults = dataset && dataset.mergePagedefaults;
            delete dataset.mergePagedefaults;

            if (eventName) {
                delete dataset.eventName;
                callback(eventName, dataset, mergePagedefaults === "true");
            }
        }
    }, {
        key: "_getData",
        value: function _getData(elem) {
            return (0, _attr2obj2.default)(elem, this._attributePrefix);
        }
    }]);

    return TrackBindingPlugin;
}();

function useTrackBindingPlugin(_ref2) {
    var callback = _ref2.callback,
        rootElement = _ref2.rootElement,
        attributePrefix = _ref2.attributePrefix,
        traverseParent = _ref2.traverseParent;

    var trackBindingPlugin = new TrackBindingPlugin({
        attributePrefix: attributePrefix,
        traverseParent: traverseParent
    });
    return trackBindingPlugin.listen(callback, rootElement);
}