Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.defaultService = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _defaultService;

exports.default = createService;

var _ActionTypes = require("./ActionTypes");

var _ActionTypes2 = _interopRequireDefault(_ActionTypes);

var _extractApis = require("./utils/extractApis");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /* eslint-disable no-empty */


var noop = function noop() {};

function isService(obj) {
    var functionProps = (0, _extractApis.aggregateApisByType)(obj);
    return functionProps.length > 0;
}

var defaultService = exports.defaultService = (_defaultService = {}, _defineProperty(_defaultService, _ActionTypes2.default.PAGE_VIEW, noop), _defineProperty(_defaultService, _ActionTypes2.default.TRACK, noop), _defaultService);

function createService() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var api = options.api;

    var instance = defaultService;
    function instantiate() {
        var ClassType = api;
        return new ClassType(options);
    }
    if (typeof api === "function") {
        var inst = void 0;
        try {
            inst = api(options);
        } catch (err) {} finally {
            if (!inst || !isService(inst)) {
                inst = instantiate();
            }
            if (isService(inst)) {
                instance = inst;
            }
        }
    } else if (api && (typeof api === "undefined" ? "undefined" : _typeof(api)) === "object" && isService(api)) {
        instance = api;
    }
    var name = options.name || instance.name;
    return { name: name, apis: instance };
}