'use strict';

exports.__esModule = true;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _createReactClass = require('create-react-class');

var _createReactClass2 = _interopRequireDefault(_createReactClass);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _KeyCode = require('rc-util/lib/KeyCode');

var _KeyCode2 = _interopRequireDefault(_KeyCode);

var _CalendarHeader = require('./calendar/CalendarHeader');

var _CalendarHeader2 = _interopRequireDefault(_CalendarHeader);

var _CalendarFooter = require('./calendar/CalendarFooter');

var _CalendarFooter2 = _interopRequireDefault(_CalendarFooter);

var _CalendarMixin = require('./mixin/CalendarMixin');

var _CalendarMixin2 = _interopRequireDefault(_CalendarMixin);

var _CommonMixin = require('./mixin/CommonMixin');

var _CommonMixin2 = _interopRequireDefault(_CommonMixin);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var MonthCalendar = (0, _createReactClass2['default'])({
  displayName: 'MonthCalendar',

  propTypes: {
    monthCellRender: _propTypes2['default'].func,
    dateCellRender: _propTypes2['default'].func
  },
  mixins: [_CommonMixin2['default'], _CalendarMixin2['default']],

  getInitialState: function getInitialState() {
    return { mode: 'month' };
  },
  onKeyDown: function onKeyDown(event) {
    var keyCode = event.keyCode;
    var ctrlKey = event.ctrlKey || event.metaKey;
    var stateValue = this.state.value;
    var disabledDate = this.props.disabledDate;

    var value = stateValue;
    switch (keyCode) {
      case _KeyCode2['default'].DOWN:
        value = stateValue.clone();
        value.add(3, 'months');
        break;
      case _KeyCode2['default'].UP:
        value = stateValue.clone();
        value.add(-3, 'months');
        break;
      case _KeyCode2['default'].LEFT:
        value = stateValue.clone();
        if (ctrlKey) {
          value.add(-1, 'years');
        } else {
          value.add(-1, 'months');
        }
        break;
      case _KeyCode2['default'].RIGHT:
        value = stateValue.clone();
        if (ctrlKey) {
          value.add(1, 'years');
        } else {
          value.add(1, 'months');
        }
        break;
      case _KeyCode2['default'].ENTER:
        if (!disabledDate || !disabledDate(stateValue)) {
          this.onSelect(stateValue);
        }
        event.preventDefault();
        return 1;
      default:
        return undefined;
    }
    if (value !== stateValue) {
      this.setValue(value);
      event.preventDefault();
      return 1;
    }
  },
  handlePanelChange: function handlePanelChange(_, mode) {
    if (mode !== 'date') {
      this.setState({ mode: mode });
    }
  },
  render: function render() {
    var props = this.props,
        state = this.state;
    var mode = state.mode,
        value = state.value;

    var children = _react2['default'].createElement(
      'div',
      { className: props.prefixCls + '-month-calendar-content' },
      _react2['default'].createElement(
        'div',
        { className: props.prefixCls + '-month-header-wrap' },
        _react2['default'].createElement(_CalendarHeader2['default'], {
          prefixCls: props.prefixCls,
          mode: mode,
          value: value,
          locale: props.locale,
          disabledMonth: props.disabledDate,
          monthCellRender: props.monthCellRender,
          monthCellContentRender: props.monthCellContentRender,
          onMonthSelect: this.onSelect,
          onValueChange: this.setValue,
          onPanelChange: this.handlePanelChange
        })
      ),
      _react2['default'].createElement(_CalendarFooter2['default'], {
        prefixCls: props.prefixCls,
        renderFooter: props.renderFooter
      })
    );
    return this.renderRoot({
      className: props.prefixCls + '-month-calendar',
      children: children
    });
  }
});

exports['default'] = MonthCalendar;
module.exports = exports['default'];