module.exports = registerEndpoints

function registerEndpoints (octokit, routes) {
  Object.keys(routes).forEach(namespaceName => {
    if (!octokit[namespaceName]) {
      octokit[namespaceName] = {}
    }

    Object.keys(routes[namespaceName]).forEach(apiName => {
      let apiOptions = routes[namespaceName][apiName]

      const endpointDefaults = ['method', 'url', 'headers'].reduce((map, key) => {
        if (typeof apiOptions[key] !== 'undefined') {
          map[key] = apiOptions[key]
        }

        return map
      }, {})

      endpointDefaults.request = {
        validate: apiOptions.params
      }

      const request = octokit.request.defaults(endpointDefaults)

      if (apiOptions.deprecated) {
        octokit[namespaceName][apiName] = function () {
          octokit.log.warn(apiOptions.deprecated)
          octokit[namespaceName][apiName] = request
          return request.apply(null, arguments)
        }

        return
      }

      octokit[namespaceName][apiName] = request
    })
  })
}
