module.exports = iterator

function iterator (octokit, options) {
  const headers = options.headers
  let url = octokit.request.endpoint(options).url

  return {
    [Symbol.asyncIterator]: () => ({
      next () {
        if (!url) {
          return Promise.resolve({ done: true })
        }

        return octokit.request({ url, headers })

          .then((response) => {
            // `response.headers.link` format:
            // '<https://api.github.com/users/aseemk/followers?page=2>; rel="next", <https://api.github.com/users/aseemk/followers?page=2>; rel="last"'
            // sets `url` to undefined if "next" URL is not present or `link` header is not set
            url = ((response.headers.link || '').match(/<([^>]+)>;\s*rel="next"/) || [])[1]

            return { value: response }
          })
      }
    })
  }
}
